/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.regexp.shared.MatchResult;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.IsSerializable;
import com.google.gwt.user.client.ui.Hidden;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.AriaSuggestBox;
import org.unitime.timetable.gwt.client.aria.AriaTextBox;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;

public class CourseNumbersSuggestBox
extends SuggestOracle {
    private static final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private String iConfiguration = null;
    private RegExp iRegExp = RegExp.compile((String)"\\$\\{([a-zA-Z_0-9]+)\\}");

    public CourseNumbersSuggestBox(String configuration) {
        this.iConfiguration = configuration;
    }

    public static AriaSuggestBox insert(RootPanel panel) {
        String config = panel.getElement().getAttribute("configuration");
        final String onchange = panel.getElement().getAttribute("onchange");
        AriaTextBox text = new AriaTextBox(panel.getElement().getFirstChildElement());
        text.getElement().setAttribute("autocomplete", "off");
        AriaSuggestBox box = new AriaSuggestBox(text, new CourseNumbersSuggestBox(config));
        if (onchange != null) {
            box.addValueChangeHandler(new ValueChangeHandler<String>(){

                public void onValueChange(ValueChangeEvent<String> event) {
                    ToolBox.eval(onchange);
                }
            });
        }
        panel.add((Widget)box);
        return box;
    }

    private String getConfiguration() {
        String conf = this.iConfiguration;
        MatchResult matcher = this.iRegExp.exec(conf);
        while (matcher != null) {
            com.google.gwt.user.client.Element element = DOM.getElementById((String)matcher.getGroup(1));
            Object value = "";
            if (element != null) {
                if ("select".equalsIgnoreCase(element.getTagName())) {
                    ListBox list = ListBox.wrap((Element)element);
                    for (int i = 0; i < list.getItemCount(); ++i) {
                        if (!list.isItemSelected(i)) continue;
                        value = (String)value + (((String)value).isEmpty() ? "" : ",") + list.getValue(i);
                    }
                } else if ("input".equalsIgnoreCase(element.getTagName())) {
                    TextBox text = TextBox.wrap((Element)element);
                    value = text.getText();
                } else {
                    Hidden hidden = Hidden.wrap((Element)element);
                    value = hidden.getValue();
                }
            }
            conf = conf.replace("${" + matcher.getGroup(1) + "}", (CharSequence)value);
            matcher = this.iRegExp.exec(conf);
        }
        return conf;
    }

    public void requestSuggestions(final SuggestOracle.Request request, final SuggestOracle.Callback callback) {
        RPC.execute(new SuggestionRpcRequest(request, this.getConfiguration()), new AsyncCallback<GwtRpcResponseList<SuggestionInterface>>(){

            public void onFailure(Throwable caught) {
                ArrayList<SuggestionInterface> suggestions = new ArrayList<SuggestionInterface>();
                suggestions.add(new SuggestionInterface("<font color='red'>" + caught.getMessage() + "</font>", ""));
                callback.onSuggestionsReady(request, new SuggestOracle.Response(suggestions));
            }

            public void onSuccess(GwtRpcResponseList<SuggestionInterface> result) {
                callback.onSuggestionsReady(request, new SuggestOracle.Response(result));
            }
        });
    }

    public boolean isDisplayStringHTML() {
        return true;
    }

    public static class SuggestionRpcRequest
    extends SuggestOracle.Request
    implements GwtRpcRequest<GwtRpcResponseList<SuggestionInterface>> {
        private String iConfiguration = null;

        public SuggestionRpcRequest() {
        }

        public SuggestionRpcRequest(SuggestOracle.Request request, String configuration) {
            super(request.getQuery(), request.getLimit());
            this.iConfiguration = configuration;
        }

        public String getConfiguration() {
            return this.iConfiguration;
        }

        public void setConfiguration(String configuration) {
            this.iConfiguration = configuration;
        }

        @Override
        public String toString() {
            return this.getConfiguration() + ";q=" + this.getQuery() + ";limit=" + this.getLimit();
        }
    }

    public static class SuggestionInterface
    implements IsSerializable,
    SuggestOracle.Suggestion {
        private String iDisplayString;
        private String iReplacementString;

        public SuggestionInterface() {
        }

        public SuggestionInterface(String display) {
            this.iDisplayString = display;
            this.iReplacementString = display;
        }

        public SuggestionInterface(String display, String replace) {
            this.iDisplayString = display;
            this.iReplacementString = replace;
        }

        public String getDisplayString() {
            return this.iDisplayString;
        }

        public String getReplacementString() {
            return this.iReplacementString;
        }
    }
}

