/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.solver;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.unitime.timetable.gwt.client.GwtHint;
import org.unitime.timetable.gwt.client.rooms.RoomHint;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.ServerDateTimeFormat;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.TimeSelector;
import org.unitime.timetable.gwt.client.widgets.UniTimeFrameDialog;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.FilterInterface;
import org.unitime.timetable.gwt.shared.TimetableGridInterface;

public class TimetableGrid
extends Composite {
    public static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    public static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static DateTimeFormat sDateFormatMeeting = ServerDateTimeFormat.getFormat(CONSTANTS.timetableGridDateFormat());
    protected static NumberFormat sUtilizationFormat = NumberFormat.getFormat((String)CONSTANTS.utilizationFormat());
    private static int sHeaderWidth = 100;
    private static int sLineHeight = 15;
    private P iContainer;
    private List<Meeting> iMeetings = new ArrayList<Meeting>();
    private List<Background> iBackbrounds = new ArrayList<Background>();
    private int iCellWidth;

    public TimetableGrid(FilterInterface filter, final TimetableGridInterface.TimetableGridModel model, int index, int pageWidth, int weekOffset) {
        int displayMode = Integer.valueOf(filter.getParameterValue("dispMode", "0"));
        boolean[] hasDay = new boolean[]{true, true, true, true, true, false, false};
        String days = filter.getParameterValue("days");
        int nrDays = 0;
        if (days != null && days.length() == 7 && days.indexOf(49) >= 0) {
            for (int i = 0; i < 7; ++i) {
                if (days.charAt(i) == '1') {
                    hasDay[i] = true;
                    ++nrDays;
                    continue;
                }
                hasDay[i] = false;
            }
        }
        int nrTimes = 20;
        int startSlot = 90;
        int step = 6;
        String[] times = filter.getParameterValue("times", "90|222|6").split("\\|");
        if (times != null && times.length == 3) {
            startSlot = Integer.parseInt(times[0]);
            step = Integer.parseInt(times[2]);
            nrTimes = (Integer.parseInt(times[1]) - startSlot) / step;
        }
        int endSlot = startSlot + step * nrTimes;
        boolean showPreferences = "1".equals(filter.getParameterValue("showPreferences"));
        boolean showInstructors = "1".equals(filter.getParameterValue("showInstructors"));
        boolean showTimes = "1".equals(filter.getParameterValue("showTimes"));
        boolean showRoom = !"0".equals(filter.getParameterValue("resource"));
        boolean showDate = "-100".equals(filter.getParameterValue("weeks"));
        String comment = TimetableGrid.getComment(model);
        if (displayMode == 0) {
            int headerLines = 2;
            if (index % 10 != 0) {
                headerLines = 0;
            }
            int nrLines = 0;
            int[] dayIndex = new int[7];
            int x = 0;
            int[] dayLines = new int[7];
            for (int i = 0; i < 7; ++i) {
                int d = (i + weekOffset) % 7;
                dayLines[d] = model.getNrLines(d, 2);
                if (hasDay[d] && nrLines < dayLines[d]) {
                    nrLines = dayLines[d];
                }
                dayIndex[d] = x++;
                if (!hasDay[d]) continue;
            }
            this.iContainer = new P("unitime-TimetableGrid");
            this.iCellWidth = (pageWidth - sHeaderWidth) / (nrDays * nrTimes);
            if (this.iCellWidth < 50) {
                this.iCellWidth = 50;
            }
            this.iContainer.setSize(sHeaderWidth + nrDays * nrTimes * this.iCellWidth + 2 * nrDays, (headerLines + nrLines) * sLineHeight + 1);
            if (headerLines > 0) {
                P name = new P("grid-name");
                name.setSize(sHeaderWidth, headerLines * sLineHeight);
                this.iContainer.add((Widget)name);
            }
            P verticalHeader = new P("vertical-header");
            verticalHeader.setSize(sHeaderWidth, nrLines * sLineHeight + 1);
            this.iContainer.add((Widget)verticalHeader, 0, headerLines * sLineHeight);
            P panel = new P("timetable-panel");
            panel.setSize(nrDays * nrTimes * this.iCellWidth + 2 * nrDays, nrLines * sLineHeight + 1);
            if (headerLines > 0) {
                P horizontalHeader = new P("horizontal-header");
                horizontalHeader.setSize(nrDays * nrTimes * this.iCellWidth + 2 * nrDays, headerLines * sLineHeight);
                this.iContainer.add((Widget)horizontalHeader, sHeaderWidth, 0);
                for (int i = 0; i < 7; ++i) {
                    int d = (i + weekOffset) % 7;
                    if (!hasDay[d]) continue;
                    for (int t = 0; t < nrTimes; ++t) {
                        int j = dayIndex[d] * nrTimes + t;
                        P p = new P("header-interval");
                        p.setSize(this.iCellWidth, headerLines * sLineHeight);
                        p.setHTML(CONSTANTS.days()[d] + "<br>" + TimeSelector.TimeUtils.slot2time(startSlot + t * step));
                        horizontalHeader.add((Widget)p, j * this.iCellWidth + 2 * dayIndex[d], 0);
                        if (t == 0 && dayIndex[d] > 0) {
                            P p2 = new P("vertical-double-separator");
                            panel.add((Widget)p2, j * this.iCellWidth + 2 * dayIndex[d] - 2, 0);
                            P p3 = new P("vertical-double-separator");
                            horizontalHeader.add((Widget)p3, j * this.iCellWidth + 2 * dayIndex[d] - 2, 0);
                            continue;
                        }
                        P p4 = new P("vertical-separator");
                        panel.add((Widget)p4, j * this.iCellWidth + 2 * dayIndex[d], 0);
                    }
                }
                P lastVShead = new P("vertical-separator");
                lastVShead.getElement().getStyle().setRight(0.0, Style.Unit.PX);
                lastVShead.getElement().getStyle().setTop(0.0, Style.Unit.PX);
                lastVShead.getElement().getStyle().setPosition(Style.Position.ABSOLUTE);
                horizontalHeader.add((Widget)lastVShead);
            } else {
                for (int d = 0; d < 7; ++d) {
                    if (!hasDay[d]) continue;
                    for (int t = 0; t < nrTimes; ++t) {
                        P vs;
                        int i = dayIndex[d] * nrTimes + t;
                        if (t == 0 && dayIndex[d] > 0) {
                            vs = new P("vertical-double-separator");
                            panel.add((Widget)vs, i * this.iCellWidth + 2 * dayIndex[d] - 2, 0);
                            continue;
                        }
                        vs = new P("vertical-separator");
                        panel.add((Widget)vs, i * this.iCellWidth + 2 * dayIndex[d], 0);
                    }
                }
            }
            this.iContainer.add((Widget)panel, sHeaderWidth, headerLines * sLineHeight);
            P lastVSpan = new P("vertical-separator");
            lastVSpan.getElement().getStyle().setRight(0.0, Style.Unit.PX);
            lastVSpan.getElement().getStyle().setTop(0.0, Style.Unit.PX);
            lastVSpan.getElement().getStyle().setPosition(Style.Position.ABSOLUTE);
            panel.add((Widget)lastVSpan);
            P hs = new P("horizontal-separator");
            panel.add((Widget)hs, 0, 0);
            final P hi = new P("header-interval");
            hi.setSize(sHeaderWidth, nrLines * sLineHeight);
            hi.setHTML(model.getName() + (String)(comment != null && !comment.isEmpty() ? "<br>" + comment : ""));
            if (model.hasNameColor()) {
                hi.getElement().getStyle().setColor(model.getNameColor());
            }
            if (model.getResourceType() == 0 && model.getResourceId() != null) {
                hi.addMouseOverHandler(new MouseOverHandler(){

                    public void onMouseOver(MouseOverEvent event) {
                        RoomHint.showHint((Element)hi.getElement(), model.getResourceId(), null, null, true);
                    }
                });
                hi.addMouseOutHandler(new MouseOutHandler(){

                    public void onMouseOut(MouseOutEvent event) {
                        RoomHint.hideHint();
                    }
                });
            } else {
                hi.setTitle(model.getName() + (String)(comment != null && !comment.isEmpty() ? "\n" + comment : ""));
            }
            verticalHeader.add((Widget)hi, 0, 0);
            P lastHSpan = new P("horizontal-separator");
            lastHSpan.getElement().getStyle().setLeft(0.0, Style.Unit.PX);
            lastHSpan.getElement().getStyle().setBottom(0.0, Style.Unit.PX);
            lastHSpan.getElement().getStyle().setPosition(Style.Position.ABSOLUTE);
            panel.add((Widget)lastHSpan);
            P lastHShead = new P("horizontal-separator");
            lastHShead.getElement().getStyle().setLeft(0.0, Style.Unit.PX);
            lastHShead.getElement().getStyle().setBottom(0.0, Style.Unit.PX);
            lastHShead.getElement().getStyle().setPosition(Style.Position.ABSOLUTE);
            verticalHeader.add((Widget)lastHShead);
            for (TimetableGridInterface.TimetableGridBackground timetableGridBackground : model.getBackgrounds()) {
                if (!hasDay[timetableGridBackground.getDay()] || timetableGridBackground.getSlot() + timetableGridBackground.getLength() <= startSlot || timetableGridBackground.getSlot() >= startSlot + step * nrTimes) continue;
                Background background = new Background(timetableGridBackground);
                this.iBackbrounds.add(background);
                background.getElement().getStyle().setHeight((double)(nrLines * sLineHeight), Style.Unit.PX);
                int start = timetableGridBackground.getSlot();
                int stop = timetableGridBackground.getSlot() + timetableGridBackground.getLength();
                if (start < startSlot) {
                    start = startSlot;
                }
                if (stop > endSlot) {
                    stop = endSlot;
                }
                background.getElement().getStyle().setWidth((double)(stop * this.iCellWidth / step - start * this.iCellWidth / step), Style.Unit.PX);
                panel.add((Widget)background, dayIndex[timetableGridBackground.getDay()] * nrTimes * this.iCellWidth + (start - startSlot) * this.iCellWidth / step + 2 * dayIndex[timetableGridBackground.getDay()], 0);
            }
            for (TimetableGridInterface.TimetableGridCell timetableGridCell : model.getCells()) {
                if (!hasDay[timetableGridCell.getDay()] || timetableGridCell.getSlot() + timetableGridCell.getLength() <= startSlot || timetableGridCell.getSlot() >= startSlot + step * nrTimes) continue;
                Meeting meeting = new Meeting(timetableGridCell, showRoom, showInstructors, showTimes, showPreferences, showDate);
                this.iMeetings.add(meeting);
                int lines = timetableGridCell.getNrLines();
                if (dayLines[timetableGridCell.getDay()] < nrLines && timetableGridCell.getIndex() + timetableGridCell.getNrLines() == dayLines[timetableGridCell.getDay()]) {
                    lines += nrLines - dayLines[timetableGridCell.getDay()];
                }
                meeting.getElement().getStyle().setHeight((double)(1 + lines * sLineHeight), Style.Unit.PX);
                int start = timetableGridCell.getSlot();
                int stop = timetableGridCell.getSlot() + timetableGridCell.getLength();
                if (start < startSlot) {
                    start = startSlot;
                }
                if (stop > endSlot) {
                    stop = endSlot;
                }
                meeting.getElement().getStyle().setWidth((double)(1 + (stop - startSlot) * this.iCellWidth / step - (start - startSlot) * this.iCellWidth / step), Style.Unit.PX);
                panel.add((Widget)meeting, dayIndex[timetableGridCell.getDay()] * nrTimes * this.iCellWidth + (start - startSlot) * this.iCellWidth / step + 2 * dayIndex[timetableGridCell.getDay()], timetableGridCell.getIndex() * sLineHeight);
            }
        } else if (displayMode == 1) {
            int nrLines = 0;
            int[] dayIndex = new int[8];
            int[] toDayIdx = new int[7];
            for (int i = 0; i < 7; ++i) {
                int d = (i + weekOffset) % 7;
                dayIndex[i] = nrLines;
                toDayIdx[d] = i;
                if (!hasDay[d]) continue;
                nrLines += model.getNrLines(d, 2);
            }
            dayIndex[7] = nrLines;
            int headerLines = 1 + (comment != null && !comment.isEmpty() ? 1 : 0);
            this.iContainer = new P("unitime-TimetableGrid");
            this.iCellWidth = (pageWidth - sHeaderWidth) / nrTimes;
            this.iContainer.setSize(sHeaderWidth + nrTimes * this.iCellWidth + 2, (headerLines + nrLines) * sLineHeight + 2);
            final P name = new P("grid-name");
            name.setSize(sHeaderWidth, headerLines * sLineHeight);
            name.setHTML(model.getName() + (String)(comment != null && !comment.isEmpty() ? "<br>" + comment : ""));
            if (model.hasNameColor()) {
                name.getElement().getStyle().setColor(model.getNameColor());
            }
            if (model.getResourceType() == 0 && model.getResourceId() != null) {
                name.addMouseOverHandler(new MouseOverHandler(){

                    public void onMouseOver(MouseOverEvent event) {
                        RoomHint.showHint((Element)name.getElement(), model.getResourceId(), null, null, true);
                    }
                });
                name.addMouseOutHandler(new MouseOutHandler(){

                    public void onMouseOut(MouseOutEvent event) {
                        RoomHint.hideHint();
                    }
                });
            } else {
                name.setTitle(model.getName() + (String)(comment != null && !comment.isEmpty() ? "\n" + comment : ""));
            }
            this.iContainer.add((Widget)name);
            P verticalHeader = new P("vertical-header");
            verticalHeader.setSize(sHeaderWidth, nrLines * sLineHeight + 1);
            this.iContainer.add((Widget)verticalHeader, 0, headerLines * sLineHeight);
            P horizontalHeader = new P("horizontal-header");
            horizontalHeader.setSize(nrTimes * this.iCellWidth + 1, headerLines * sLineHeight);
            this.iContainer.add((Widget)horizontalHeader, sHeaderWidth, 0);
            P panel = new P("timetable-panel");
            panel.setSize(nrTimes * this.iCellWidth + 1, nrLines * sLineHeight + 1);
            this.iContainer.add((Widget)panel, sHeaderWidth, headerLines * sLineHeight);
            for (int i = 0; i < nrTimes; ++i) {
                P hi = new P("header-interval");
                hi.setSize(this.iCellWidth, headerLines * sLineHeight);
                hi.setText(TimeSelector.TimeUtils.slot2time(startSlot + i * step));
                horizontalHeader.add((Widget)hi, i * this.iCellWidth, 0);
                P vs = new P("vertical-separator");
                panel.add((Widget)vs, i * this.iCellWidth, 0);
            }
            P lastVSpan = new P("vertical-separator");
            lastVSpan.getElement().getStyle().setRight(0.0, Style.Unit.PX);
            lastVSpan.getElement().getStyle().setTop(0.0, Style.Unit.PX);
            lastVSpan.getElement().getStyle().setPosition(Style.Position.ABSOLUTE);
            panel.add((Widget)lastVSpan);
            P lastVShead = new P("vertical-separator");
            lastVShead.getElement().getStyle().setRight(0.0, Style.Unit.PX);
            lastVShead.getElement().getStyle().setTop(0.0, Style.Unit.PX);
            lastVShead.getElement().getStyle().setPosition(Style.Position.ABSOLUTE);
            horizontalHeader.add((Widget)lastVShead);
            for (int i = 0; i < 7; ++i) {
                int d = (i + weekOffset) % 7;
                if (!hasDay[d]) continue;
                P p = new P("horizontal-separator");
                panel.add((Widget)p, 0, sLineHeight * dayIndex[i]);
                P p5 = new P("header-interval");
                p5.setSize(sHeaderWidth, (dayIndex[1 + i] - dayIndex[i]) * sLineHeight);
                p5.setText(CONSTANTS.longDays()[d]);
                verticalHeader.add((Widget)p5, 0, sLineHeight * dayIndex[i]);
            }
            P lastHSpan = new P("horizontal-separator");
            lastHSpan.getElement().getStyle().setLeft(0.0, Style.Unit.PX);
            lastHSpan.getElement().getStyle().setBottom(0.0, Style.Unit.PX);
            lastHSpan.getElement().getStyle().setPosition(Style.Position.ABSOLUTE);
            panel.add((Widget)lastHSpan);
            P lastHShead = new P("horizontal-separator");
            lastHShead.getElement().getStyle().setLeft(0.0, Style.Unit.PX);
            lastHShead.getElement().getStyle().setBottom(0.0, Style.Unit.PX);
            lastHShead.getElement().getStyle().setPosition(Style.Position.ABSOLUTE);
            verticalHeader.add((Widget)lastHShead);
            for (TimetableGridInterface.TimetableGridBackground timetableGridBackground : model.getBackgrounds()) {
                if (!hasDay[timetableGridBackground.getDay()] || timetableGridBackground.getSlot() + timetableGridBackground.getLength() <= startSlot || timetableGridBackground.getSlot() >= startSlot + step * nrTimes) continue;
                Background background = new Background(timetableGridBackground);
                this.iBackbrounds.add(background);
                int i = toDayIdx[timetableGridBackground.getDay()];
                background.getElement().getStyle().setHeight((double)((dayIndex[i + 1] - dayIndex[i]) * sLineHeight), Style.Unit.PX);
                int start = timetableGridBackground.getSlot();
                int stop = timetableGridBackground.getSlot() + timetableGridBackground.getLength();
                if (start < startSlot) {
                    start = startSlot;
                }
                if (stop > endSlot) {
                    stop = endSlot;
                }
                background.getElement().getStyle().setWidth((double)(stop * this.iCellWidth / step - start * this.iCellWidth / step), Style.Unit.PX);
                panel.add((Widget)background, (start - startSlot) * this.iCellWidth / step, dayIndex[i] * sLineHeight);
            }
            for (TimetableGridInterface.TimetableGridCell timetableGridCell : model.getCells()) {
                if (!hasDay[timetableGridCell.getDay()] || timetableGridCell.getSlot() + timetableGridCell.getLength() <= startSlot || timetableGridCell.getSlot() >= startSlot + step * nrTimes) continue;
                Meeting meeting = new Meeting(timetableGridCell, showRoom, showInstructors, showTimes, showPreferences, showDate);
                this.iMeetings.add(meeting);
                meeting.getElement().getStyle().setHeight((double)(1 + timetableGridCell.getNrLines() * sLineHeight), Style.Unit.PX);
                int start = timetableGridCell.getSlot();
                int stop = timetableGridCell.getSlot() + timetableGridCell.getLength();
                if (start < startSlot) {
                    start = startSlot;
                }
                if (stop > endSlot) {
                    stop = endSlot;
                }
                meeting.getElement().getStyle().setWidth((double)(1 + (stop - startSlot) * this.iCellWidth / step - (start - startSlot) * this.iCellWidth / step), Style.Unit.PX);
                panel.add((Widget)meeting, (start - startSlot) * this.iCellWidth / step, (dayIndex[toDayIdx[timetableGridCell.getDay()]] + timetableGridCell.getIndex()) * sLineHeight);
            }
        } else if (displayMode == 2) {
            int stop;
            int start;
            int nrColumns = 0;
            int[] colIndex = new int[8];
            int[] toDayIdx = new int[7];
            for (int i = 0; i < 7; ++i) {
                int d = (i + weekOffset) % 7;
                colIndex[i] = nrColumns;
                toDayIdx[d] = i;
                if (!hasDay[d]) continue;
                nrColumns += model.getNrLines(d, 1);
            }
            colIndex[7] = nrColumns;
            int linesPerTime = 2;
            int headerLines = 1 + (comment != null && !comment.isEmpty() ? 1 : 0);
            this.iContainer = new P("unitime-TimetableGrid");
            this.iCellWidth = (pageWidth - sHeaderWidth) / nrColumns;
            this.iContainer.setSize(sHeaderWidth + nrColumns * this.iCellWidth + 2, (headerLines + linesPerTime * nrTimes) * sLineHeight + 2);
            final P name = new P("grid-name");
            name.setSize(sHeaderWidth, headerLines * sLineHeight);
            name.setHTML(model.getName() + (String)(comment != null && !comment.isEmpty() ? "<br>" + comment : ""));
            if (model.hasNameColor()) {
                name.getElement().getStyle().setColor(model.getNameColor());
            }
            if (model.getResourceType() == 0 && model.getResourceId() != null) {
                name.addMouseOverHandler(new MouseOverHandler(){

                    public void onMouseOver(MouseOverEvent event) {
                        RoomHint.showHint((Element)name.getElement(), model.getResourceId(), null, null, true);
                    }
                });
                name.addMouseOutHandler(new MouseOutHandler(){

                    public void onMouseOut(MouseOutEvent event) {
                        RoomHint.hideHint();
                    }
                });
            } else {
                name.setTitle(model.getName() + (String)(comment != null && !comment.isEmpty() ? "\n" + comment : ""));
            }
            this.iContainer.add((Widget)name);
            P verticalHeader = new P("vertical-header");
            verticalHeader.setSize(sHeaderWidth, linesPerTime * nrTimes * sLineHeight + 1);
            this.iContainer.add((Widget)verticalHeader, 0, headerLines * sLineHeight);
            P horizontalHeader = new P("horizontal-header");
            horizontalHeader.setSize(nrColumns * this.iCellWidth + 1, headerLines * sLineHeight);
            this.iContainer.add((Widget)horizontalHeader, sHeaderWidth, 0);
            P panel = new P("timetable-panel");
            panel.setSize(nrColumns * this.iCellWidth + 1, linesPerTime * nrTimes * sLineHeight + 1);
            this.iContainer.add((Widget)panel, sHeaderWidth, headerLines * sLineHeight);
            for (int i = 0; i < 7; ++i) {
                int d = (i + weekOffset) % 7;
                if (!hasDay[d]) continue;
                P hi = new P("header-interval");
                hi.setSize(this.iCellWidth * model.getNrLines(d, 1), headerLines * sLineHeight);
                hi.setText(CONSTANTS.longDays()[d]);
                horizontalHeader.add((Widget)hi, colIndex[i] * this.iCellWidth, 0);
                P p = new P("vertical-separator");
                panel.add((Widget)p, colIndex[i] * this.iCellWidth, 0);
            }
            P lastVSpan = new P("vertical-separator");
            lastVSpan.getElement().getStyle().setRight(0.0, Style.Unit.PX);
            lastVSpan.getElement().getStyle().setTop(0.0, Style.Unit.PX);
            lastVSpan.getElement().getStyle().setPosition(Style.Position.ABSOLUTE);
            panel.add((Widget)lastVSpan);
            P lastVShead = new P("vertical-separator");
            lastVShead.getElement().getStyle().setRight(0.0, Style.Unit.PX);
            lastVShead.getElement().getStyle().setTop(0.0, Style.Unit.PX);
            lastVShead.getElement().getStyle().setPosition(Style.Position.ABSOLUTE);
            horizontalHeader.add((Widget)lastVShead);
            for (int i = 0; i < nrTimes; ++i) {
                P p = new P("horizontal-separator");
                panel.add((Widget)p, 0, sLineHeight * linesPerTime * i);
                P p6 = new P("header-interval");
                p6.setSize(sHeaderWidth, linesPerTime * sLineHeight);
                p6.setText(TimeSelector.TimeUtils.slot2time(startSlot + step * i));
                verticalHeader.add((Widget)p6, 0, sLineHeight * linesPerTime * i);
            }
            P lastHSpan = new P("horizontal-separator");
            lastHSpan.getElement().getStyle().setLeft(0.0, Style.Unit.PX);
            lastHSpan.getElement().getStyle().setBottom(0.0, Style.Unit.PX);
            lastHSpan.getElement().getStyle().setPosition(Style.Position.ABSOLUTE);
            panel.add((Widget)lastHSpan);
            P p = new P("horizontal-separator");
            p.getElement().getStyle().setLeft(0.0, Style.Unit.PX);
            p.getElement().getStyle().setBottom(0.0, Style.Unit.PX);
            p.getElement().getStyle().setPosition(Style.Position.ABSOLUTE);
            verticalHeader.add((Widget)p);
            for (TimetableGridInterface.TimetableGridBackground timetableGridBackground : model.getBackgrounds()) {
                if (!hasDay[timetableGridBackground.getDay()] || timetableGridBackground.getSlot() + timetableGridBackground.getLength() <= startSlot || timetableGridBackground.getSlot() >= startSlot + step * nrTimes) continue;
                Background b = new Background(timetableGridBackground);
                this.iBackbrounds.add(b);
                start = timetableGridBackground.getSlot();
                stop = timetableGridBackground.getSlot() + timetableGridBackground.getLength();
                if (start < startSlot) {
                    start = startSlot;
                }
                if (stop > endSlot) {
                    stop = endSlot;
                }
                b.getElement().getStyle().setHeight((double)(stop * sLineHeight * linesPerTime / step - start * sLineHeight * linesPerTime / step), Style.Unit.PX);
                int i = toDayIdx[timetableGridBackground.getDay()];
                b.getElement().getStyle().setWidth((double)((colIndex[1 + i] - colIndex[i]) * this.iCellWidth), Style.Unit.PX);
                panel.add((Widget)b, colIndex[i] * this.iCellWidth, (start - startSlot) * sLineHeight * linesPerTime / step);
            }
            for (TimetableGridInterface.TimetableGridCell timetableGridCell : model.getCells()) {
                if (!hasDay[timetableGridCell.getDay()] || timetableGridCell.getSlot() + timetableGridCell.getLength() <= startSlot || timetableGridCell.getSlot() >= startSlot + step * nrTimes) continue;
                Meeting m = new Meeting(timetableGridCell, showRoom, showInstructors, showTimes, showPreferences, showDate);
                this.iMeetings.add(m);
                start = timetableGridCell.getSlot();
                stop = timetableGridCell.getSlot() + timetableGridCell.getLength();
                if (start < startSlot) {
                    start = startSlot;
                }
                if (stop > endSlot) {
                    stop = endSlot;
                }
                m.getElement().getStyle().setHeight((double)(1 + (stop - startSlot) * sLineHeight * linesPerTime / step - (start - startSlot) * sLineHeight * linesPerTime / step), Style.Unit.PX);
                m.getElement().getStyle().setWidth((double)(1 + this.iCellWidth * timetableGridCell.getNrLines()), Style.Unit.PX);
                panel.add((Widget)m, (colIndex[toDayIdx[timetableGridCell.getDay()]] + timetableGridCell.getIndex()) * this.iCellWidth, (start - startSlot) * sLineHeight * linesPerTime / step);
            }
        } else if (displayMode == 3) {
            int stop;
            int start;
            int day;
            int nrLines = 0;
            int[] dayIndex = new int[366];
            for (int d = 0; d < 365; ++d) {
                int day2;
                dayIndex[d] = nrLines;
                int date2 = d + model.getFirstSessionDay();
                if (model.getFirstDay() >= 0 && (date2 < model.getFirstDay() || date2 > model.getFirstDay() + 6) || !hasDay[day2 = d % 7] || !model.hasDate(day2, date2)) continue;
                nrLines += model.getNrDateLines(day2, date2, 2);
            }
            dayIndex[365] = nrLines;
            int headerLines = 1 + (comment != null && !comment.isEmpty() ? 1 : 0);
            this.iContainer = new P("unitime-TimetableGrid");
            this.iCellWidth = (pageWidth - sHeaderWidth) / nrTimes;
            this.iContainer.setSize(sHeaderWidth + nrTimes * this.iCellWidth + 2, (headerLines + nrLines) * sLineHeight + 2);
            final P name = new P("grid-name");
            name.setSize(sHeaderWidth, headerLines * sLineHeight);
            name.setHTML(model.getName() + (String)(comment != null && !comment.isEmpty() ? "<br>" + comment : ""));
            if (model.hasNameColor()) {
                name.getElement().getStyle().setColor(model.getNameColor());
            }
            if (model.getResourceType() == 0 && model.getResourceId() != null) {
                name.addMouseOverHandler(new MouseOverHandler(){

                    public void onMouseOver(MouseOverEvent event) {
                        RoomHint.showHint((Element)name.getElement(), model.getResourceId(), null, null, true);
                    }
                });
                name.addMouseOutHandler(new MouseOutHandler(){

                    public void onMouseOut(MouseOutEvent event) {
                        RoomHint.hideHint();
                    }
                });
            } else {
                name.setTitle(model.getName() + (String)(comment != null && !comment.isEmpty() ? "\n" + comment : ""));
            }
            this.iContainer.add((Widget)name);
            P verticalHeader = new P("vertical-header");
            verticalHeader.setSize(sHeaderWidth, nrLines * sLineHeight + 1);
            this.iContainer.add((Widget)verticalHeader, 0, headerLines * sLineHeight);
            P horizontalHeader = new P("horizontal-header");
            horizontalHeader.setSize(nrTimes * this.iCellWidth + 1, headerLines * sLineHeight);
            this.iContainer.add((Widget)horizontalHeader, sHeaderWidth, 0);
            P panel = new P("timetable-panel");
            panel.setSize(nrTimes * this.iCellWidth + 1, nrLines * sLineHeight + 1);
            this.iContainer.add((Widget)panel, sHeaderWidth, headerLines * sLineHeight);
            for (int i = 0; i < nrTimes; ++i) {
                P hi = new P("header-interval");
                hi.setSize(this.iCellWidth, headerLines * sLineHeight);
                hi.setText(TimeSelector.TimeUtils.slot2time(startSlot + i * step));
                horizontalHeader.add((Widget)hi, i * this.iCellWidth, 0);
                P vs = new P("vertical-separator");
                panel.add((Widget)vs, i * this.iCellWidth, 0);
            }
            P lastVSpan = new P("vertical-separator");
            lastVSpan.getElement().getStyle().setRight(0.0, Style.Unit.PX);
            lastVSpan.getElement().getStyle().setTop(0.0, Style.Unit.PX);
            lastVSpan.getElement().getStyle().setPosition(Style.Position.ABSOLUTE);
            panel.add((Widget)lastVSpan);
            P lastVShead = new P("vertical-separator");
            lastVShead.getElement().getStyle().setRight(0.0, Style.Unit.PX);
            lastVShead.getElement().getStyle().setTop(0.0, Style.Unit.PX);
            lastVShead.getElement().getStyle().setPosition(Style.Position.ABSOLUTE);
            horizontalHeader.add((Widget)lastVShead);
            for (int d = 0; d < 365; ++d) {
                int day3;
                int date3 = d + model.getFirstSessionDay();
                if (model.getFirstDay() >= 0 && (date3 < model.getFirstDay() || date3 > model.getFirstDay() + 6) || !hasDay[day3 = d % 7] || !model.hasDate(day3, date3)) continue;
                P p = new P("horizontal-separator");
                panel.add((Widget)p, 0, sLineHeight * dayIndex[d]);
                P p7 = new P("header-interval");
                p7.setSize(sHeaderWidth, (dayIndex[1 + d] - dayIndex[d]) * sLineHeight);
                p7.setText(sDateFormatMeeting.format(TimetableGrid.getDate(model.getFirstDate(), d)));
                verticalHeader.add((Widget)p7, 0, sLineHeight * dayIndex[d]);
            }
            P lastHSpan = new P("horizontal-separator");
            lastHSpan.getElement().getStyle().setLeft(0.0, Style.Unit.PX);
            lastHSpan.getElement().getStyle().setBottom(0.0, Style.Unit.PX);
            lastHSpan.getElement().getStyle().setPosition(Style.Position.ABSOLUTE);
            panel.add((Widget)lastHSpan);
            P lastHShead = new P("horizontal-separator");
            lastHShead.getElement().getStyle().setLeft(0.0, Style.Unit.PX);
            lastHShead.getElement().getStyle().setBottom(0.0, Style.Unit.PX);
            lastHShead.getElement().getStyle().setPosition(Style.Position.ABSOLUTE);
            verticalHeader.add((Widget)lastHShead);
            for (TimetableGridInterface.TimetableGridBackground timetableGridBackground : model.getBackgrounds()) {
                if (!hasDay[timetableGridBackground.getDay()] || timetableGridBackground.getSlot() + timetableGridBackground.getLength() <= startSlot || timetableGridBackground.getSlot() >= startSlot + step * nrTimes) continue;
                for (int i = 0; i < 365; ++i) {
                    int n = i + model.getFirstSessionDay();
                    day = i % 7;
                    if (model.getFirstDay() >= 0 && (n < model.getFirstDay() || n > model.getFirstDay() + 6) || timetableGridBackground.getDay() != day) continue;
                    Background b = new Background(timetableGridBackground);
                    this.iBackbrounds.add(b);
                    b.getElement().getStyle().setHeight((double)((dayIndex[1 + i] - dayIndex[i]) * sLineHeight), Style.Unit.PX);
                    start = timetableGridBackground.getSlot();
                    stop = timetableGridBackground.getSlot() + timetableGridBackground.getLength();
                    if (start < startSlot) {
                        start = startSlot;
                    }
                    if (stop > endSlot) {
                        stop = endSlot;
                    }
                    b.getElement().getStyle().setWidth((double)(stop * this.iCellWidth / step - start * this.iCellWidth / step), Style.Unit.PX);
                    panel.add((Widget)b, (start - startSlot) * this.iCellWidth / step, dayIndex[i] * sLineHeight);
                }
            }
            for (TimetableGridInterface.TimetableGridCell timetableGridCell : model.getCells()) {
                if (!hasDay[timetableGridCell.getDay()] || timetableGridCell.getSlot() + timetableGridCell.getLength() <= startSlot || timetableGridCell.getSlot() >= startSlot + step * nrTimes) continue;
                for (int i = 0; i < 365; ++i) {
                    int n = i + model.getFirstSessionDay();
                    if (model.getFirstDay() >= 0 && (n < model.getFirstDay() || n > model.getFirstDay() + 6)) continue;
                    day = i % 7;
                    if (timetableGridCell.getDay() != day || !timetableGridCell.hasDate(n)) continue;
                    Meeting m = new Meeting(timetableGridCell, showRoom, showInstructors, showTimes, showPreferences, showDate);
                    this.iMeetings.add(m);
                    m.getElement().getStyle().setHeight((double)(1 + timetableGridCell.getNrLines(n) * sLineHeight), Style.Unit.PX);
                    start = timetableGridCell.getSlot();
                    stop = timetableGridCell.getSlot() + timetableGridCell.getLength();
                    if (start < startSlot) {
                        start = startSlot;
                    }
                    if (stop > endSlot) {
                        stop = endSlot;
                    }
                    m.getElement().getStyle().setWidth((double)(1 + (stop - startSlot) * this.iCellWidth / step - (start - startSlot) * this.iCellWidth / step), Style.Unit.PX);
                    panel.add((Widget)m, (start - startSlot) * this.iCellWidth / step, (dayIndex[i] + timetableGridCell.getIndex(n)) * sLineHeight);
                }
            }
        }
        this.initWidget((Widget)this.iContainer);
    }

    protected int min(int a, int b) {
        return a < b ? a : b;
    }

    protected int max(int a, int b) {
        return a > b ? a : b;
    }

    protected static String getComment(TimetableGridInterface.TimetableGridModel model) {
        if (model.getResourceType() == 0) {
            return "(" + model.getSize() + ", " + sUtilizationFormat.format(model.getUtilization()) + ")";
        }
        if (model.getResourceType() >= 2) {
            return "(" + model.getSize() + ")";
        }
        return null;
    }

    protected static Date getDate(Date firstDate, int date) {
        Date ret = new Date(firstDate.getTime());
        ret.setDate(ret.getDate() + date);
        return ret;
    }

    public class Background
    extends AbsolutePanel {
        private TimetableGridInterface.TimetableGridBackground iBackground;

        public Background(TimetableGridInterface.TimetableGridBackground background) {
            this.setStyleName("background");
            this.iBackground = background;
            this.getElement().getStyle().setPosition(Style.Position.ABSOLUTE);
            if (background.hasBackground()) {
                this.getElement().getStyle().setBackgroundColor(background.getBackground());
            }
        }

        public TimetableGridInterface.TimetableGridBackground getBackground() {
            return this.iBackground;
        }
    }

    public class Meeting
    extends AbsolutePanel {
        private TimetableGridInterface.TimetableGridCell iCell;
        private List<Meeting> iSiblings = null;
        private Widget iTitle = null;

        private Meeting(TimetableGridInterface.TimetableGridCell cell, boolean showRoom, boolean showInstructor, boolean showTime, boolean showPreference, boolean showDate) {
            this.iCell = cell;
            this.setStyleName("meeting");
            if (cell.hasBackground()) {
                this.getElement().getStyle().setBackgroundColor(cell.getBackground());
            }
            P header = new P("header", "label");
            header.setHeight(sLineHeight * cell.getNrNames());
            header.setHTML(cell.getName("<br>"));
            header.getElement().getStyle().setWhiteSpace(Style.WhiteSpace.NOWRAP);
            if (cell.isItalics()) {
                header.getElement().getStyle().setFontStyle(Style.FontStyle.ITALIC);
            }
            this.add((Widget)header);
            P footer = new P("footer");
            Object notes = "";
            if (showTime && cell.hasTime()) {
                notes = (String)notes + (((String)notes).isEmpty() ? "" : "<br>") + cell.getTime();
            }
            if (showDate && cell.hasDate()) {
                notes = (String)notes + (((String)notes).isEmpty() ? "" : "<br>") + cell.getDate();
            }
            if (showRoom && cell.getNrRooms() > 0) {
                notes = (String)notes + (((String)notes).isEmpty() ? "" : "<br>") + cell.getRoom("<br>");
            }
            if (showInstructor && cell.getNrInstructors() > 0) {
                notes = (String)notes + (((String)notes).isEmpty() ? "" : "<br>") + cell.getInstructor("<br>");
            }
            if (showPreference && cell.hasPreference()) {
                notes = (String)notes + (((String)notes).isEmpty() ? "" : "<br>") + "<span style='color:rgb(200,200,200)'>" + cell.getPreference() + "</span>";
            }
            footer.setHTML((String)notes);
            footer.getElement().getStyle().setWhiteSpace(Style.WhiteSpace.NOWRAP);
            this.add((Widget)footer);
            this.sinkEvents(1);
            this.sinkEvents(16);
            this.sinkEvents(32);
            this.getElement().getStyle().setPosition(Style.Position.ABSOLUTE);
        }

        public void onBrowserEvent(Event event) {
            EventTarget related = event.getRelatedEventTarget();
            switch (DOM.eventGetType((Event)event)) {
                case 1: {
                    if (!this.getCell().hasId() || this.getCell().getType() != TimetableGridInterface.TimetableGridCell.Type.Class) break;
                    UniTimeFrameDialog.openDialog(MESSAGES.dialogSuggestions(), "gwt.jsp?page=suggestions&menu=hide&id=" + this.getCell().getId(), "900", "90%");
                    this.select(false);
                    break;
                }
                case 16: {
                    if (related != null && this.getElement().isOrHasChild((Node)((Element)related.cast()))) break;
                    this.select(true);
                    break;
                }
                case 32: {
                    if (related != null && this.getElement().isOrHasChild((Node)((Element)related.cast()))) break;
                    this.select(false);
                }
            }
            super.onBrowserEvent(event);
        }

        public List<Meeting> getSiblings() {
            if (this.iSiblings == null) {
                this.iSiblings = new ArrayList<Meeting>();
                for (Meeting m : TimetableGrid.this.iMeetings) {
                    if (!this.getCell().sameClassOrMeeting(m.getCell())) continue;
                    this.iSiblings.add(m);
                }
                if (this.iSiblings.isEmpty()) {
                    this.iSiblings.add(this);
                }
            }
            return this.iSiblings;
        }

        protected Widget getCellTitle() {
            if (this.iTitle == null) {
                SimpleForm form = new SimpleForm();
                form.removeStyleName("unitime-NotPrintableBottomLine");
                form.addRow(MESSAGES.propName(), (Widget)new HTML(this.iCell.getTitle("<br>&nbsp;&nbsp;&nbsp;") + (String)(this.iCell.hasProperty(TimetableGridInterface.TimetableGridCell.Property.EventType) ? " (" + this.iCell.getProperty(TimetableGridInterface.TimetableGridCell.Property.EventType, "") + ")" : (this.iCell.hasProperty(TimetableGridInterface.TimetableGridCell.Property.Owner) ? " (" + this.iCell.getProperty(TimetableGridInterface.TimetableGridCell.Property.Owner, "") + ")" : ""))));
                if (this.iCell.hasTime()) {
                    form.addRow(MESSAGES.propTimeGridTime(), (Widget)new HTML((String)(this.iCell.hasDays() ? this.iCell.getDays() + " " : "") + this.iCell.getTime()));
                }
                if (this.iCell.hasDate()) {
                    form.addRow(MESSAGES.propTimeGridDate(), (Widget)new HTML(this.iCell.getDate()));
                }
                if (this.iCell.getNrRooms() > 0) {
                    form.addRow(MESSAGES.propTimeGridLocation(), (Widget)new HTML(this.iCell.getRoom("<br>")));
                }
                if (this.iCell.getNrInstructors() > 0) {
                    form.addRow(MESSAGES.propTimeGridInstructor(), (Widget)new HTML(this.iCell.getInstructor("<br>")));
                }
                if (this.iCell.hasProperty(TimetableGridInterface.TimetableGridCell.Property.StudentConflicts)) {
                    form.addRow(MESSAGES.propTimeGridStudentConflicts(), (Widget)new HTML(MESSAGES.formatStudentConflicts(this.iCell.getProperty(TimetableGridInterface.TimetableGridCell.Property.StudentConflicts, "0"), this.iCell.getProperty(TimetableGridInterface.TimetableGridCell.Property.StudentConflictsCommitted, "0"), this.iCell.getProperty(TimetableGridInterface.TimetableGridCell.Property.StudentConflictsDistance, "0"), this.iCell.getProperty(TimetableGridInterface.TimetableGridCell.Property.StudentConflictsHard, "0"))));
                }
                if (this.iCell.hasProperty(TimetableGridInterface.TimetableGridCell.Property.TimePreference)) {
                    form.addRow(MESSAGES.propTimeGridTimePreferences(), (Widget)new HTML(this.iCell.getProperty(TimetableGridInterface.TimetableGridCell.Property.TimePreference, "0")));
                }
                if (this.iCell.hasProperty(TimetableGridInterface.TimetableGridCell.Property.RoomPreference)) {
                    form.addRow(MESSAGES.propTimeGridRoomPreferences(), (Widget)new HTML(this.iCell.getProperty(TimetableGridInterface.TimetableGridCell.Property.RoomPreference, "0")));
                }
                if (this.iCell.hasProperty(TimetableGridInterface.TimetableGridCell.Property.DistributionPreference)) {
                    form.addRow(MESSAGES.propTimeGridDistributionPreferences(), (Widget)new HTML(this.iCell.getProperty(TimetableGridInterface.TimetableGridCell.Property.DistributionPreference, "0")));
                }
                if (this.iCell.hasProperty(TimetableGridInterface.TimetableGridCell.Property.InitialAssignment)) {
                    String initial = this.iCell.getProperty(TimetableGridInterface.TimetableGridCell.Property.InitialAssignment, "-");
                    form.addRow(MESSAGES.propTimeGridInitialAssignment(), (Widget)new HTML((String)("-".equals(initial) ? "<i>" + MESSAGES.initialAssignmentCurrent() + "</i>" : initial)));
                }
                if (this.iCell.hasProperty(TimetableGridInterface.TimetableGridCell.Property.PerturbationPenalty)) {
                    form.addRow(MESSAGES.propTimeGridPerturbationPenalty(), (Widget)new HTML(this.iCell.getProperty(TimetableGridInterface.TimetableGridCell.Property.PerturbationPenalty, "0")));
                }
                if (this.iCell.hasProperty(TimetableGridInterface.TimetableGridCell.Property.DepartmentBalance)) {
                    form.addRow(MESSAGES.propTimeGridDepartmentBalance(), (Widget)new HTML(this.iCell.getProperty(TimetableGridInterface.TimetableGridCell.Property.DepartmentBalance, "0")));
                }
                if (this.iCell.hasProperty(TimetableGridInterface.TimetableGridCell.Property.NonConflictingPlacements)) {
                    form.addRow(MESSAGES.propTimeGridNonConflictingPlacements(), (Widget)new HTML(this.iCell.getProperty(TimetableGridInterface.TimetableGridCell.Property.NonConflictingPlacements, "0")));
                }
                SimplePanel panel = new SimplePanel((Widget)form);
                panel.setStyleName("unitime-RoomHint");
                this.iTitle = panel;
            }
            return this.iTitle;
        }

        protected void select(boolean selected) {
            for (Meeting m : this.getSiblings()) {
                if (selected) {
                    m.getElement().getStyle().setBackgroundColor("rgb(223,231,242)");
                    continue;
                }
                if (this.iCell.hasBackground()) {
                    m.getElement().getStyle().setBackgroundColor(this.iCell.getBackground());
                    continue;
                }
                m.getElement().getStyle().clearBackgroundColor();
            }
            if (this.getCellTitle() != null) {
                if (selected) {
                    GwtHint.showHint((Element)this.getElement(), this.getCellTitle());
                } else {
                    GwtHint.hideHint();
                }
            }
        }

        public TimetableGridInterface.TimetableGridCell getCell() {
            return this.iCell;
        }
    }
}

