/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.sectioning.SectioningStatusCookie;
import org.unitime.timetable.gwt.client.sectioning.TimeGrid;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeConfirmationDialog;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTabPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.client.widgets.WebTable;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningResources;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SpecialRegistrationInterface;

public class StudentSchedule
extends Composite
implements TakesValue<ClassAssignmentInterface> {
    public static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    public static final StudentSectioningResources RESOURCES = (StudentSectioningResources)GWT.create(StudentSectioningResources.class);
    public static final StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    private static DateTimeFormat sDF = DateTimeFormat.getFormat((String)CONSTANTS.requestDateFormat());
    private static DateTimeFormat sTSF = DateTimeFormat.getFormat((String)CONSTANTS.timeStampFormat());
    private static DateTimeFormat sWLF = DateTimeFormat.getFormat((String)CONSTANTS.requestWaitListedDateFormat());
    private static DateTimeFormat sADF = DateTimeFormat.getFormat((String)CONSTANTS.advisedDateFormat());
    private ClassAssignmentInterface iAssignment;
    private UniTimeTabPanel iTabs;
    private TimeGrid iGrid;
    private WebTable iAssignments;
    private WebTable iRequests;
    private WebTable iAdvReqs;
    private WebTable iNotes;
    private UniTimeTable<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse> iSpecialRegistrations;
    private UniTimeTable<CourseRequestInterface.RequestedCourse> iWaitLists;
    private boolean iOnline = false;
    private float iTotalCredit = 0.0f;
    private Map<Character, Integer> iTabAccessKeys = new HashMap<Character, Integer>();
    private SelectionHandler<Integer> iHandler;
    private static DateTimeFormat sModifiedDateFormat = DateTimeFormat.getFormat((String)CONSTANTS.timeStampFormat());

    public StudentSchedule(boolean online) {
        this.iOnline = online;
        this.iTabs = new UniTimeTabPanel();
        this.iTabs.setDeckStyleName("unitime-TabPanel");
        this.iAdvReqs = new WebTable();
        this.iAdvReqs.setEmptyMessage(MESSAGES.emptyRequests());
        this.iAdvReqs.setHeader(new WebTable.Row(new WebTable.Cell(MESSAGES.colPriority(), 1, "25px"), new WebTable.Cell(MESSAGES.colCourse(), 1, "75px"), new WebTable.Cell(MESSAGES.colTitle(), 1, "200px"), new WebTable.Cell(MESSAGES.colCredit(), 1, "20px"), new WebTable.Cell(MESSAGES.colPreferences(), 1, "100px"), new WebTable.Cell(MESSAGES.colCritical(), 1, "20px"), new WebTable.Cell(MESSAGES.colWaitList(), 1, "20px"), new WebTable.Cell(MESSAGES.colNotes(), 1, "300px"), new WebTable.Cell(MESSAGES.colChanges(), 1, "100px"), new WebTable.Cell(MESSAGES.colAdvisedTimeStamp(), 1, "100px"), new WebTable.Cell(MESSAGES.colAdvisor(), 1, "100px")));
        this.iAdvReqs.setSelectSameIdRows(true);
        this.iAdvReqs.addStyleName("unitime-AdvisorCourseRequestsTable");
        this.iTabs.add((Widget)this.iAdvReqs, MESSAGES.tabAdvisorRequests(), true);
        Character cha = UniTimeHeaderPanel.guessAccessKey(MESSAGES.tabAdvisorRequests());
        if (cha != null) {
            this.iTabAccessKeys.put(cha, 0);
        }
        this.iRequests = new WebTable();
        this.iRequests.setEmptyMessage(MESSAGES.emptyRequests());
        this.iRequests.setHeader(new WebTable.Row(new WebTable.Cell(MESSAGES.colPriority(), 1, "25px"), new WebTable.Cell(MESSAGES.colCourse(), 1, "75px"), new WebTable.Cell(MESSAGES.colTitle(), 1, "200px"), new WebTable.Cell(MESSAGES.colCredit(), 1, "20px"), new WebTable.Cell(MESSAGES.colPreferences(), 1, "100px"), new WebTable.Cell(MESSAGES.colWarnings(), 1, "200px"), new WebTable.Cell(MESSAGES.colStatus(), 1, "20px"), new WebTable.Cell(MESSAGES.colCritical(), 1, "20px"), new WebTable.Cell(MESSAGES.colWaitList(), 1, "20px"), new WebTable.Cell(MESSAGES.colRequestTimeStamp(), 1, "50px")));
        this.iTabs.add((Widget)this.iRequests, MESSAGES.tabRequests(), true);
        Character ch0 = UniTimeHeaderPanel.guessAccessKey(MESSAGES.tabRequests());
        if (ch0 != null) {
            this.iTabAccessKeys.put(ch0, 1);
        }
        this.iAssignments = new WebTable();
        this.iAssignments.setHeader(new WebTable.Row(new WebTable.Cell(MESSAGES.colSubject(), 1, "75px"), new WebTable.Cell(MESSAGES.colCourse(), 1, "75px"), new WebTable.Cell(MESSAGES.colSubpart(), 1, "50px"), new WebTable.Cell(MESSAGES.colClass(), 1, "75px"), new WebTable.Cell(MESSAGES.colLimit(), 1, "60px"), new WebTable.Cell(MESSAGES.colDays(), 1, "50px"), new WebTable.Cell(MESSAGES.colStart(), 1, "75px"), new WebTable.Cell(MESSAGES.colEnd(), 1, "75px"), new WebTable.Cell(MESSAGES.colDate(), 1, "75px"), new WebTable.Cell(MESSAGES.colRoom(), 1, "100px"), new WebTable.Cell(MESSAGES.colInstructor(), 1, "100px"), new WebTable.Cell(MESSAGES.colParent(), 1, "75px"), new WebTable.Cell(MESSAGES.colNoteIcon(), 1, "10px"), new WebTable.Cell(MESSAGES.colCredit(), 1, "75px"), new WebTable.Cell(MESSAGES.colEnrollmentTimeStamp(), 1, "75px")));
        this.iAssignments.setEmptyMessage(MESSAGES.emptySchedule());
        this.iNotes = new WebTable();
        this.iNotes.setHeader(new WebTable.Row(new WebTable.Cell(MESSAGES.colTimeStamp(), 1, "75px"), new WebTable.Cell(MESSAGES.colNote(), 1, "400x"), new WebTable.Cell(MESSAGES.colNoteAuthor(), 1, "75x")));
        this.iNotes.setEmptyMessage(MESSAGES.emptyNotes());
        this.iSpecialRegistrations = new UniTimeTable();
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        header.add(new UniTimeTableHeader(""));
        header.add(new UniTimeTableHeader(MESSAGES.colSpecRegSubmitted()));
        header.add(new UniTimeTableHeader(MESSAGES.colSubject()));
        header.add(new UniTimeTableHeader(MESSAGES.colCourse()));
        header.add(new UniTimeTableHeader(MESSAGES.colSubpart()));
        header.add(new UniTimeTableHeader(MESSAGES.colClass()));
        header.add(new UniTimeTableHeader(MESSAGES.colLimit()));
        header.add(new UniTimeTableHeader(MESSAGES.colCredit()));
        header.add(new UniTimeTableHeader(MESSAGES.colGradeMode()));
        header.add(new UniTimeTableHeader(MESSAGES.colSpecRegErrors()));
        header.add(new UniTimeTableHeader(""));
        this.iSpecialRegistrations.addStyleName("unitime-SpecialRegistrationsPanel");
        this.iSpecialRegistrations.addRow(null, header);
        this.iWaitLists = new UniTimeTable();
        header = new ArrayList();
        header.add(new UniTimeTableHeader(""));
        header.add(new UniTimeTableHeader(MESSAGES.colWaitListedTimeStamp()));
        header.add(new UniTimeTableHeader(MESSAGES.colCourse()));
        header.add(new UniTimeTableHeader(MESSAGES.colTitle()));
        header.add(new UniTimeTableHeader(MESSAGES.colCredit()));
        header.add(new UniTimeTableHeader(MESSAGES.colWaitListSwapWithCourseOffering()));
        header.add(new UniTimeTableHeader(MESSAGES.colWaitListPosition()));
        header.add(new UniTimeTableHeader(MESSAGES.colRequirements()));
        header.add(new UniTimeTableHeader(MESSAGES.colWaitListErrors()));
        this.iWaitLists.addStyleName("unitime-WaitListsPanel");
        this.iWaitLists.addRow(null, header);
        this.iTabs.add((Widget)this.iAssignments, MESSAGES.tabClasses(), true);
        Character ch1 = UniTimeHeaderPanel.guessAccessKey(MESSAGES.tabClasses());
        if (ch1 != null) {
            this.iTabAccessKeys.put(ch1, 2);
        }
        this.iGrid = new TimeGrid();
        this.iTabs.add((Widget)this.iGrid, MESSAGES.tabTimetable(), true);
        Character ch2 = UniTimeHeaderPanel.guessAccessKey(MESSAGES.tabTimetable());
        if (ch2 != null) {
            this.iTabAccessKeys.put(ch2, 3);
        }
        if (this.iOnline) {
            this.iTabs.add((Widget)this.iSpecialRegistrations, MESSAGES.tabSpecialRegistrations(), true);
            Character ch4 = UniTimeHeaderPanel.guessAccessKey(MESSAGES.tabSpecialRegistrations());
            if (ch4 != null) {
                this.iTabAccessKeys.put(ch4, 4);
            }
        }
        if (this.iOnline) {
            this.iTabs.add((Widget)this.iWaitLists, MESSAGES.tabWaitListedCourses(), true);
            Character ch5 = UniTimeHeaderPanel.guessAccessKey(MESSAGES.tabWaitListedCourses());
            if (ch5 != null) {
                this.iTabAccessKeys.put(ch5, 5);
            }
        }
        if (this.iOnline) {
            this.iTabs.add((Widget)this.iNotes, MESSAGES.tabNotes(), true);
            Character ch3 = UniTimeHeaderPanel.guessAccessKey(MESSAGES.tabNotes());
            if (ch3 != null) {
                this.iTabAccessKeys.put(ch3, 6);
            }
        }
        if (!this.iOnline && SectioningStatusCookie.getInstance().getStudentTab() >= 4) {
            this.iTabs.selectTab(2);
        } else {
            this.iTabs.selectTab(SectioningStatusCookie.getInstance().getStudentTab());
        }
        this.iTabs.addSelectionHandler(new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                SectioningStatusCookie.getInstance().setStudentTab((Integer)event.getSelectedItem());
                if (StudentSchedule.this.iHandler != null) {
                    StudentSchedule.this.iHandler.onSelection(event);
                }
            }
        });
        this.iTabs.addStyleName("unitime-StudentSchedule");
        this.initWidget((Widget)this.iTabs);
    }

    public void setWaitListMode(OnlineSectioningInterface.WaitListMode mode, boolean advisorRequests, boolean studentRequests) {
        switch (mode) {
            case WaitList: {
                if (studentRequests) {
                    this.iRequests.getTable().setHTML(0, 8, MESSAGES.colWaitList());
                }
                if (!advisorRequests) break;
                this.iAdvReqs.getTable().setHTML(0, 6, MESSAGES.colWaitList());
                break;
            }
            default: {
                if (studentRequests) {
                    this.iRequests.getTable().setHTML(0, 8, MESSAGES.colNoSubs());
                }
                if (!advisorRequests) break;
                this.iAdvReqs.getTable().setHTML(0, 6, MESSAGES.colNoSubs());
            }
        }
    }

    public ClassAssignmentInterface getValue() {
        return this.iAssignment;
    }

    public void setValue(ClassAssignmentInterface result) {
        this.iAssignment = result;
        this.fillInAdvisorRequests();
        this.fillInRequests();
        this.fillInAssignments();
        this.fillInTimeGrid();
        if (this.iOnline) {
            this.fillInNotes();
        }
        if (this.iOnline) {
            this.fillInSpecialRegistrations();
        }
        if (this.iOnline) {
            this.fillInWaitLists();
        }
    }

    protected String getChanges(CourseRequestInterface.Request request, CourseRequestInterface.RequestedCourse rc) {
        CourseRequestInterface.RequestPriority rp;
        if (!rc.hasCourseId()) {
            return null;
        }
        CourseRequestInterface.RequestPriority arp = this.iAssignment.getAdvisorRequest().getRequestPriority(rc);
        CourseRequestInterface.RequestPriority requestPriority = rp = this.iAssignment.hasRequest() ? this.iAssignment.getRequest().getRequestPriority(rc) : null;
        if (arp.getChoice() == 0) {
            if (rp == null) {
                if (request.getRequestedCourse().size() > 1) {
                    CourseRequestInterface.RequestPriority top = null;
                    CourseRequestInterface.RequestedCourse other = null;
                    for (CourseRequestInterface.RequestedCourse x : request.getRequestedCourse()) {
                        CourseRequestInterface.RequestPriority p = this.iAssignment.hasRequest() ? this.iAssignment.getRequest().getRequestPriority(x) : null;
                        if (p == null || top != null && top.compareTo(p) < 0) continue;
                        top = p;
                        other = x;
                    }
                    if (top != null) {
                        String prio = "&rarr; ";
                        if (top.getPriority() != arp.getPriority()) {
                            prio = top.getPriority() < arp.getPriority() ? "&uarr; " : "&darr; ";
                        }
                        return prio + MESSAGES.advChangesMissingCourseButHasAlt(rc.getCourseName(), other.getCourseName());
                    }
                    return MESSAGES.advChangesMissingCourseWithAllAlts(rc.getCourseName());
                }
                return MESSAGES.advChangesMissingCourse(rc.getCourseName());
            }
            if (rp.isAlternative() != arp.isAlternative()) {
                if (rp.isAlternative()) {
                    return MESSAGES.advChangesPrimaryToSubstitute(rc.getCourseName(), rp.getPriority());
                }
                return MESSAGES.advChangesSubstituteToPrimary(rc.getCourseName(), rp.getPriority());
            }
            String prio = "&rarr; ";
            if (rp.getPriority() != arp.getPriority()) {
                String string = prio = rp.getPriority() < arp.getPriority() ? "&uarr; " : "&darr; ";
            }
            if (rp.getChoice() != arp.getChoice()) {
                CourseRequestInterface.RequestedCourse ch1 = (rp.isAlternative() ? this.iAssignment.getRequest().getAlternatives() : this.iAssignment.getRequest().getCourses()).get(rp.getPriority() - 1).getRequestedCourse(0);
                CourseRequestInterface.RequestPriority p = this.iAssignment.getAdvisorRequest().getRequestPriority(ch1);
                if (p != null && p.getPriority() == arp.getPriority()) {
                    return prio + MESSAGES.advChanges1stChoiceChanged(ch1.getCourseName());
                }
                return prio + MESSAGES.advChangesDifferent1stChoice(ch1.getCourseName());
            }
            if (rp.getPriority() != arp.getPriority()) {
                return prio + (rp.isAlternative() ? MESSAGES.advChangesMovedToSubstitute(rp.getPriority()) : MESSAGES.advChangesMovedToPriority(rp.getPriority()));
            }
        } else {
            String prio;
            if (rp == null) {
                if (this.iAssignment.getRequest().getRequestPriority(request.getRequestedCourse(0)) != null) {
                    return MESSAGES.advChangesMissingCourse(rc.getCourseName());
                }
                int nrContains = 0;
                for (CourseRequestInterface.RequestedCourse x : request.getRequestedCourse()) {
                    if (this.iAssignment.getRequest().getRequestPriority(x) == null) continue;
                    ++nrContains;
                }
                if (nrContains > 1) {
                    return MESSAGES.advChangesMissingCourse(rc.getCourseName());
                }
                return null;
            }
            if (rp.isAlternative() != arp.isAlternative()) {
                if (rp.isAlternative()) {
                    return MESSAGES.advChangesPrimaryToSubstitute(rc.getCourseName(), rp.getPriority());
                }
                return MESSAGES.advChangesSubstituteToPrimary(rc.getCourseName(), rp.getPriority());
            }
            CourseRequestInterface.RequestPriority top = null;
            for (CourseRequestInterface.RequestedCourse x : request.getRequestedCourse()) {
                CourseRequestInterface.RequestPriority p = this.iAssignment.hasRequest() ? this.iAssignment.getRequest().getRequestPriority(x) : null;
                if (p == null || top != null && top.compareTo(p) < 0) continue;
                top = p;
            }
            if (rp.getChoice() != arp.getChoice()) {
                if (rp.getChoice() == 0) {
                    if (top.getPriority() == rp.getPriority() && top.getChoice() == rp.getChoice()) {
                        return null;
                    }
                    if (top.getPriority() != rp.getPriority() && rp.getPriority() != arp.getPriority()) {
                        prio = rp.getPriority() < arp.getPriority() ? "&uarr; " : "&darr; ";
                        return prio + (rp.isAlternative() ? MESSAGES.advChangesMovedToSubstitute(rp.getPriority()) : MESSAGES.advChangesMovedToPriority(rp.getPriority()));
                    }
                    return MESSAGES.advChangesMoved1stChoice();
                }
                CourseRequestInterface.RequestedCourse ch1 = (rp.isAlternative() ? this.iAssignment.getRequest().getAlternatives() : this.iAssignment.getRequest().getCourses()).get(rp.getPriority() - 1).getRequestedCourse(0);
                CourseRequestInterface.RequestPriority p = this.iAssignment.getAdvisorRequest().getRequestPriority(ch1);
                if (p == null || p.getPriority() != arp.getPriority()) {
                    String prio2 = "&rarr; ";
                    if (rp.getPriority() != arp.getPriority()) {
                        prio2 = rp.getPriority() < arp.getPriority() ? "&uarr; " : "&darr; ";
                    }
                    return prio2 + MESSAGES.advChangesDifferent1stChoice(ch1.getCourseName());
                }
                if (rp.getChoice() == 1) {
                    return MESSAGES.advChangesMoved2ndChoice();
                }
                if (rp.getChoice() == 2) {
                    return MESSAGES.advChangesMoved3rdChoice();
                }
            } else if (top.getPriority() != rp.getPriority() && rp.getPriority() != arp.getPriority()) {
                prio = "";
                if (top.getPriority() != rp.getPriority() && rp.getPriority() != arp.getPriority()) {
                    prio = rp.getPriority() < arp.getPriority() ? "&uarr; " : "&darr; ";
                }
                return prio + (rp.isAlternative() ? MESSAGES.advChangesMovedToSubstitute(rp.getPriority()) : MESSAGES.advChangesMovedToPriority(rp.getPriority()));
            }
        }
        return null;
    }

    /*
     * Could not resolve type clashes
     */
    protected void fillInAdvisorRequests() {
        ArrayList<Object> rows = new ArrayList<Object>();
        boolean hasPref = false;
        boolean hasCrit = false;
        boolean hasImp = false;
        boolean hasVital = false;
        boolean hasWL = false;
        boolean hasChanges = false;
        this.iTabs.getTabBar().setTabEnabled(0, this.iAssignment.hasAdvisorRequest());
        if (this.iAssignment.hasAdvisorRequest()) {
            Object noteMessage;
            WebTable.Row row;
            Object note;
            WebTable.NoteCell note2;
            WebTable.Cell credit;
            Object row2;
            this.setWaitListMode(this.iAssignment.getAdvisorRequest().getWaitListMode(), true, false);
            int priority = 1;
            for (CourseRequestInterface.Request request : this.iAssignment.getAdvisorRequest().getCourses()) {
                if (request.hasRequestedCourse()) {
                    if (request.isCritical()) {
                        hasCrit = true;
                    }
                    if (request.isImportant()) {
                        hasImp = true;
                    }
                    if (request.isVital()) {
                        hasVital = true;
                    }
                    if (this.iAssignment.getAdvisorRequest().getWaitListMode() == OnlineSectioningInterface.WaitListMode.WaitList) {
                        if (request.isWaitList()) {
                            hasWL = true;
                        }
                    } else if (request.isNoSub()) {
                        hasWL = true;
                    }
                    boolean first = true;
                    for (CourseRequestInterface.RequestedCourse rc : request.getRequestedCourse()) {
                        row2 = null;
                        if (rc.isCourse()) {
                            String changes;
                            AbstractCollection prefs = null;
                            if (rc.hasSelectedIntructionalMethods()) {
                                if (rc.hasSelectedClasses()) {
                                    prefs = new ArrayList(rc.getSelectedIntructionalMethods().size() + rc.getSelectedClasses().size());
                                    prefs.addAll(new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedIntructionalMethods()));
                                    prefs.addAll(new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedClasses()));
                                } else {
                                    prefs = new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedIntructionalMethods());
                                }
                            } else if (rc.hasSelectedClasses()) {
                                prefs = new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedClasses());
                            }
                            if (prefs != null) {
                                hasPref = true;
                            }
                            if ((changes = this.getChanges(request, rc)) != null) {
                                hasChanges = true;
                            }
                            boolean enrolled = false;
                            for (ClassAssignmentInterface.CourseAssignment course : this.iAssignment.getCourseAssignments()) {
                                if (!course.isAssigned() || course.isTeachingAssignment() || course.isFreeTime() || !course.getCourseId().equals(rc.getCourseId())) continue;
                                enrolled = true;
                                break;
                            }
                            if (first) {
                                credit = new WebTable.Cell(request.hasAdvisorCredit() ? request.getAdvisorCredit() : "");
                                credit.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
                                note2 = new WebTable.NoteCell(request.hasAdvisorNote() ? request.getAdvisorNote() : "", null);
                                note2.setRowSpan(request.getRequestedCourse().size());
                                WebTable.Cell[] cellArray = new WebTable.Cell[11];
                                cellArray[0] = new WebTable.Cell(MESSAGES.courseRequestsPriority(priority));
                                cellArray[1] = enrolled ? new WebTable.IconCell(RESOURCES.courseEnrolled(), MESSAGES.titleCourseEnrolled(rc.getCourseName()), rc.getCourseName(), true) : new WebTable.Cell(rc.getCourseName());
                                cellArray[2] = new WebTable.Cell(rc.hasCourseTitle() ? rc.getCourseTitle() : "");
                                cellArray[3] = credit;
                                cellArray[4] = new WebTable.Cell(ToolBox.toString(prefs), true);
                                WebTable.Cell cell = request.isCritical() ? new WebTable.IconCell(RESOURCES.requestsCritical(), MESSAGES.descriptionRequestCritical(), "") : (request.isImportant() ? new WebTable.IconCell(RESOURCES.requestsImportant(), MESSAGES.descriptionRequestImportant(), "") : (cellArray[5] = request.isVital() ? new WebTable.IconCell(RESOURCES.requestsVital(), MESSAGES.descriptionRequestVital(), "") : new WebTable.Cell("")));
                                cellArray[6] = this.iAssignment.getAdvisorRequest().getWaitListMode() == OnlineSectioningInterface.WaitListMode.WaitList ? (request.isWaitList() ? new WebTable.IconCell(RESOURCES.requestsWaitList(), MESSAGES.descriptionRequestWaitListed(), "") : new WebTable.Cell("")) : (request.isNoSub() ? new WebTable.IconCell(RESOURCES.requestsWaitList(), MESSAGES.descriptionRequestNoSubs(), "") : new WebTable.Cell(""));
                                cellArray[7] = note2;
                                cellArray[8] = new WebTable.Cell(changes);
                                cellArray[9] = new WebTable.Cell(rc.getTimeStamp() == null ? "" : sADF.format(rc.getTimeStamp()));
                                cellArray[10] = new WebTable.Cell(rc.hasChangedBy() ? rc.getChangedBy() : "");
                                row2 = new WebTable.Row(cellArray);
                            } else {
                                row2 = new WebTable.Row(new WebTable.Cell(""), enrolled ? new WebTable.IconCell(RESOURCES.courseEnrolled(), MESSAGES.titleCourseEnrolled(rc.getCourseName()), rc.getCourseName(), true) : new WebTable.Cell(rc.getCourseName()), new WebTable.Cell(rc.hasCourseTitle() ? rc.getCourseTitle() : ""), new WebTable.Cell(""), new WebTable.Cell(ToolBox.toString(prefs), true), new WebTable.Cell(""), new WebTable.Cell(""), new WebTable.Cell(changes), new WebTable.Cell(rc.getTimeStamp() == null ? "" : sADF.format(rc.getTimeStamp())), new WebTable.Cell(rc.hasChangedBy() ? rc.getChangedBy() : ""));
                            }
                        } else if (rc.isFreeTime()) {
                            Object free = "";
                            for (CourseRequestInterface.FreeTime ft : rc.getFreeTime()) {
                                if (!free.isEmpty()) {
                                    free = (String)free + ", ";
                                }
                                free = (String)free + ft.toString(CONSTANTS.shortDays(), CONSTANTS.useAmPm());
                            }
                            if (first) {
                                WebTable.Cell credit2 = new WebTable.Cell(first && request.hasAdvisorCredit() ? request.getAdvisorCredit() : "");
                                credit2.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
                                WebTable.NoteCell note3 = new WebTable.NoteCell(request.hasAdvisorNote() ? request.getAdvisorNote() : "", null);
                                note3.setRowSpan(request.getRequestedCourse().size());
                                row2 = new WebTable.Row(new WebTable.Cell(MESSAGES.courseRequestsPriority(priority)), new WebTable.Cell(CONSTANTS.freePrefix() + (String)free, 2, null), credit2, new WebTable.Cell(""), new WebTable.Cell(""), new WebTable.Cell(""), note3, new WebTable.Cell(""), new WebTable.Cell(rc.getTimeStamp() == null ? "" : sADF.format(rc.getTimeStamp())), new WebTable.Cell(rc.hasChangedBy() ? rc.getChangedBy() : ""));
                            } else {
                                row2 = new WebTable.Row(new WebTable.Cell(""), new WebTable.Cell(CONSTANTS.freePrefix() + (String)free, 2, null), new WebTable.Cell(""), new WebTable.Cell(""), new WebTable.Cell(""), new WebTable.Cell(""), new WebTable.Cell(""), new WebTable.Cell(""), new WebTable.Cell(rc.getTimeStamp() == null ? "" : sADF.format(rc.getTimeStamp())), new WebTable.Cell(rc.hasChangedBy() ? rc.getChangedBy() : ""));
                            }
                        }
                        if (priority > 1 && first) {
                            for (Object cell : row2.getCells()) {
                                ((WebTable.Cell)cell).setStyleName("top-border-dashed");
                            }
                        }
                        row2.setId("P" + priority);
                        rows.add(row2);
                        first = false;
                    }
                } else {
                    WebTable.Cell credit3 = new WebTable.Cell(request.hasAdvisorCredit() ? request.getAdvisorCredit() : "");
                    credit3.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
                    note = new WebTable.NoteCell(request.hasAdvisorNote() ? request.getAdvisorNote() : "", null);
                    row = new WebTable.Row(new WebTable.Cell[]{new WebTable.Cell(MESSAGES.courseRequestsPriority(priority)), new WebTable.Cell(""), new WebTable.Cell(""), credit3, new WebTable.Cell(""), new WebTable.Cell(""), new WebTable.Cell(""), note, new WebTable.Cell(""), new WebTable.Cell(request.getTimeStamp() == null ? "" : sADF.format(request.getTimeStamp())), new WebTable.Cell(request.hasChangedBy() ? request.getChangedBy() : "")});
                    if (priority > 1) {
                        for (WebTable.Cell cell : row.getCells()) {
                            cell.setStyleName("top-border-dashed");
                        }
                    }
                    row.setId("P" + priority);
                    rows.add(row);
                }
                ++priority;
            }
            priority = 1;
            for (CourseRequestInterface.Request request : this.iAssignment.getAdvisorRequest().getAlternatives()) {
                if (request.hasRequestedCourse()) {
                    boolean first = true;
                    for (CourseRequestInterface.RequestedCourse rc : request.getRequestedCourse()) {
                        row2 = null;
                        if (rc.isCourse()) {
                            String changes;
                            Object cell;
                            AbstractCollection prefs = null;
                            if (rc.hasSelectedIntructionalMethods()) {
                                if (rc.hasSelectedClasses()) {
                                    prefs = new ArrayList(rc.getSelectedIntructionalMethods().size() + rc.getSelectedClasses().size());
                                    prefs.addAll(new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedIntructionalMethods()));
                                    prefs.addAll(new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedClasses()));
                                } else {
                                    prefs = new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedIntructionalMethods());
                                }
                            } else if (rc.hasSelectedClasses()) {
                                prefs = new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedClasses());
                            }
                            if (prefs != null) {
                                hasPref = true;
                            }
                            if ((changes = this.getChanges(request, rc)) != null) {
                                hasChanges = true;
                            }
                            int enrolled = 0;
                            cell = this.iAssignment.getCourseAssignments().iterator();
                            while (cell.hasNext()) {
                                ClassAssignmentInterface.CourseAssignment course;
                                course = (ClassAssignmentInterface.CourseAssignment)cell.next();
                                if (!course.isAssigned() || course.isTeachingAssignment() || course.isFreeTime() || !course.getCourseId().equals(rc.getCourseId())) continue;
                                enrolled = 1;
                                break;
                            }
                            if (first) {
                                credit = new WebTable.Cell(request.hasAdvisorCredit() ? request.getAdvisorCredit() : "");
                                credit.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
                                note2 = new WebTable.NoteCell(request.hasAdvisorNote() ? request.getAdvisorNote() : "", null);
                                note2.setRowSpan(request.getRequestedCourse().size());
                                row2 = new WebTable.Row(new WebTable.Cell(MESSAGES.courseRequestsAlternate(priority)), enrolled != 0 ? new WebTable.IconCell(RESOURCES.courseEnrolled(), MESSAGES.titleCourseEnrolled(rc.getCourseName()), rc.getCourseName(), true) : new WebTable.Cell(rc.getCourseName()), new WebTable.Cell(rc.hasCourseTitle() ? rc.getCourseTitle() : ""), credit, new WebTable.Cell(ToolBox.toString(prefs), true), new WebTable.Cell(""), new WebTable.Cell(""), note2, new WebTable.Cell(changes), new WebTable.Cell(rc.getTimeStamp() == null ? "" : sADF.format(rc.getTimeStamp())), new WebTable.Cell(rc.hasChangedBy() ? rc.getChangedBy() : ""));
                            } else {
                                row2 = new WebTable.Row(new WebTable.Cell(""), enrolled != 0 ? new WebTable.IconCell(RESOURCES.courseEnrolled(), MESSAGES.titleCourseEnrolled(rc.getCourseName()), rc.getCourseName(), true) : new WebTable.Cell(rc.getCourseName()), new WebTable.Cell(rc.hasCourseTitle() ? rc.getCourseTitle() : ""), new WebTable.Cell(""), new WebTable.Cell(ToolBox.toString(prefs), true), new WebTable.Cell(""), new WebTable.Cell(""), new WebTable.Cell(changes), new WebTable.Cell(rc.getTimeStamp() == null ? "" : sADF.format(rc.getTimeStamp())), new WebTable.Cell(rc.hasChangedBy() ? rc.getChangedBy() : ""));
                            }
                        }
                        if (first) {
                            for (Object cell : row2.getCells()) {
                                ((WebTable.Cell)cell).setStyleName(priority == 1 ? "top-border-solid" : "top-border-dashed");
                            }
                        }
                        row2.setId("A" + priority);
                        rows.add(row2);
                        first = false;
                    }
                } else {
                    WebTable.Cell credit4 = new WebTable.Cell(request.hasAdvisorCredit() ? request.getAdvisorCredit() : "");
                    credit4.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
                    note = new WebTable.NoteCell(request.hasAdvisorNote() ? request.getAdvisorNote() : "", null);
                    row = new WebTable.Row(new WebTable.Cell[]{new WebTable.Cell(MESSAGES.courseRequestsAlternate(priority)), new WebTable.Cell(""), new WebTable.Cell(""), credit4, new WebTable.Cell(""), new WebTable.Cell(""), new WebTable.Cell(""), note, new WebTable.Cell(""), new WebTable.Cell(request.getTimeStamp() == null ? "" : sADF.format(request.getTimeStamp())), new WebTable.Cell(request.hasChangedBy() ? request.getChangedBy() : "")});
                    for (WebTable.Cell cell : row.getCells()) {
                        cell.setStyleName(priority == 1 ? "top-border-solid" : "top-border-dashed");
                    }
                    row.setId("A" + priority);
                    rows.add(row);
                }
                ++priority;
            }
            float min = 0.0f;
            float max = 0.0f;
            for (CourseRequestInterface.Request request : this.iAssignment.getAdvisorRequest().getCourses()) {
                min += request.getAdvisorCreditMin();
                max += request.getAdvisorCreditMax();
            }
            WebTable.Cell credit4 = new WebTable.Cell(min < max ? MESSAGES.creditRange(min, max) : MESSAGES.credit(min));
            credit4.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
            Object object = noteMessage = this.iAssignment.getAdvisorRequest().hasCreditNote() ? this.iAssignment.getAdvisorRequest().getCreditNote() : "";
            if (this.iAssignment.getAdvisorRequest().hasReleasedPin() && !((String)noteMessage).contains(this.iAssignment.getAdvisorRequest().getPin())) {
                noteMessage = (String)noteMessage + (((String)noteMessage).isEmpty() ? "" : "\n") + MESSAGES.advisorNotePin(this.iAssignment.getAdvisorRequest().getPin());
            }
            WebTable.NoteCell note4 = new WebTable.NoteCell((String)noteMessage, null);
            note4.setColSpan(5);
            WebTable.Row crow = new WebTable.Row(new WebTable.Cell(MESSAGES.rowTotalPriorityCreditHours(), 2, null), new WebTable.Cell(""), credit4, note4, new WebTable.Cell(this.iAssignment.getAdvisorRequest().getTimeStamp() == null ? "" : sADF.format(this.iAssignment.getAdvisorRequest().getTimeStamp())), new WebTable.Cell(this.iAssignment.getAdvisorRequest().hasChangedBy() ? this.iAssignment.getAdvisorRequest().getChangedBy() : ""));
            for (Object cell : crow.getCells()) {
                ((WebTable.Cell)cell).setStyleName("top-border-solid");
            }
            crow.getCell(0).setStyleName("top-border-solid text-bold");
            crow.setId("C");
            rows.add(crow);
        }
        WebTable.Row[] rowArray = new WebTable.Row[rows.size()];
        int idx = 0;
        for (WebTable.Row row : rows) {
            rowArray[idx++] = row;
        }
        this.iAdvReqs.setData(rowArray);
        this.iAdvReqs.setColumnVisible(4, hasPref);
        this.iAdvReqs.setColumnVisible(5, (hasCrit || hasImp || hasVital) && CONSTANTS.advisorCourseRequestsShowCritical());
        if (hasCrit && !hasImp && !hasVital) {
            this.iAdvReqs.getTable().setHTML(0, 5, MESSAGES.opSetCritical());
        } else if (!hasCrit && hasImp && !hasVital) {
            this.iAdvReqs.getTable().setHTML(0, 5, MESSAGES.opSetImportant());
        } else if (!hasCrit && !hasImp && hasVital) {
            this.iAdvReqs.getTable().setHTML(0, 5, MESSAGES.opSetVital());
        } else {
            this.iAdvReqs.getTable().setHTML(0, 5, MESSAGES.colCritical());
        }
        this.iAdvReqs.setColumnVisible(6, hasWL);
        this.iAdvReqs.setColumnVisible(8, hasChanges);
    }

    protected void fillInRequests() {
        ArrayList<WebTable.Row> rows = new ArrayList<WebTable.Row>();
        boolean hasPref = false;
        boolean hasWarn = false;
        boolean hasWait = false;
        boolean hasCrit = false;
        boolean hasImp = false;
        boolean hasVital = false;
        boolean hasLC = false;
        boolean hasVisitF2F = false;
        NumberFormat df = NumberFormat.getFormat((String)"0.#");
        if (this.iAssignment.hasRequest()) {
            Object free;
            WebTable.Row row;
            Object noteTitle;
            WebTable.Cell credit;
            String msg;
            Object iconText;
            ImageResource icon;
            boolean first;
            this.setWaitListMode(this.iAssignment.getRequest().getWaitListMode(), false, true);
            CourseRequestInterface.CheckCoursesResponse check = new CourseRequestInterface.CheckCoursesResponse(this.iAssignment.getRequest().getConfirmations());
            hasWarn = this.iAssignment.getRequest().hasConfirmations();
            int priority = 1;
            for (CourseRequestInterface.Request request : this.iAssignment.getRequest().getCourses()) {
                if (!request.hasRequestedCourse()) continue;
                first = true;
                if (this.iAssignment.getRequest().getWaitListMode() == OnlineSectioningInterface.WaitListMode.WaitList) {
                    if (request.isWaitList()) {
                        hasWait = true;
                    }
                } else if (request.isNoSub()) {
                    hasWait = true;
                }
                if (request.isCritical()) {
                    hasCrit = true;
                }
                if (request.isImportant()) {
                    hasImp = true;
                }
                if (request.isVital()) {
                    hasVital = true;
                }
                if (request.isLC()) {
                    hasLC = true;
                }
                if (request.isVisitingF2F()) {
                    hasVisitF2F = true;
                }
                for (CourseRequestInterface.RequestedCourse rc : request.getRequestedCourse()) {
                    if (rc.isCourse()) {
                        icon = null;
                        iconText = null;
                        msg = check.getMessage(rc.getCourseName(), "\n", new String[0]);
                        if (check.isError(rc.getCourseName()) && (rc.getStatus() == null || rc.getStatus() != CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED)) {
                            icon = RESOURCES.requestError();
                            iconText = msg;
                        } else if (rc.getStatus() != null) {
                            switch (rc.getStatus()) {
                                case ENROLLED: {
                                    icon = RESOURCES.requestEnrolled();
                                    iconText = MESSAGES.enrolled(rc.getCourseName());
                                    break;
                                }
                                case OVERRIDE_NEEDED: {
                                    icon = RESOURCES.requestNeeded();
                                    iconText = msg == null ? MESSAGES.overrideNotRequested() : MESSAGES.overrideNeeded(msg);
                                    break;
                                }
                                case SAVED: {
                                    icon = RESOURCES.requestSaved();
                                    iconText = (String)(msg == null ? "" : MESSAGES.requestWarnings(msg) + "\n\n") + MESSAGES.requested(rc.getCourseName());
                                    break;
                                }
                                case OVERRIDE_REJECTED: {
                                    icon = RESOURCES.requestRejected();
                                    iconText = (String)(msg == null ? "" : MESSAGES.requestWarnings(msg) + "\n\n") + MESSAGES.overrideRejected(rc.getCourseName());
                                    break;
                                }
                                case OVERRIDE_PENDING: {
                                    icon = RESOURCES.requestPending();
                                    iconText = (String)(msg == null ? "" : MESSAGES.requestWarnings(msg) + "\n\n") + MESSAGES.overridePending(rc.getCourseName());
                                    break;
                                }
                                case OVERRIDE_CANCELLED: {
                                    icon = RESOURCES.requestCancelled();
                                    iconText = (String)(msg == null ? "" : MESSAGES.requestWarnings(msg) + "\n\n") + MESSAGES.overrideCancelled(rc.getCourseName());
                                    break;
                                }
                                case OVERRIDE_APPROVED: {
                                    icon = RESOURCES.requestSaved();
                                    iconText = (String)(msg == null ? "" : MESSAGES.requestWarnings(msg) + "\n\n") + MESSAGES.overrideApproved(rc.getCourseName());
                                    break;
                                }
                                case OVERRIDE_NOT_NEEDED: {
                                    icon = RESOURCES.requestNotNeeded();
                                    iconText = (String)(msg == null ? "" : MESSAGES.requestWarnings(msg) + "\n\n") + MESSAGES.overrideNotNeeded(rc.getCourseName());
                                    break;
                                }
                                default: {
                                    if (check.isError(rc.getCourseName())) {
                                        icon = RESOURCES.requestError();
                                    }
                                    iconText = msg;
                                }
                            }
                        }
                        if (rc.hasRequestorNote()) {
                            iconText = iconText + "\n" + MESSAGES.requestNote(rc.getRequestorNote());
                        }
                        if (rc.hasStatusNote()) {
                            iconText = (String)iconText + "\n" + MESSAGES.overrideNote(rc.getStatusNote());
                        }
                        AbstractCollection prefs = null;
                        if (rc.hasSelectedIntructionalMethods()) {
                            if (rc.hasSelectedClasses()) {
                                prefs = new ArrayList(rc.getSelectedIntructionalMethods().size() + rc.getSelectedClasses().size());
                                prefs.addAll(new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedIntructionalMethods()));
                                prefs.addAll(new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedClasses()));
                            } else {
                                prefs = new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedIntructionalMethods());
                            }
                        } else if (rc.hasSelectedClasses()) {
                            prefs = new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedClasses());
                        }
                        WebTable.Cell[] status = "";
                        if (rc.getStatus() != null) {
                            switch (rc.getStatus()) {
                                case ENROLLED: {
                                    status = MESSAGES.reqStatusEnrolled();
                                    break;
                                }
                                case OVERRIDE_APPROVED: {
                                    status = MESSAGES.reqStatusApproved();
                                    break;
                                }
                                case OVERRIDE_CANCELLED: {
                                    status = MESSAGES.reqStatusCancelled();
                                    break;
                                }
                                case OVERRIDE_PENDING: {
                                    status = MESSAGES.reqStatusPending();
                                    break;
                                }
                                case OVERRIDE_REJECTED: {
                                    status = MESSAGES.reqStatusRejected();
                                    break;
                                }
                                case OVERRIDE_NEEDED: {
                                    status = MESSAGES.reqStatusNeeded();
                                    break;
                                }
                                case OVERRIDE_NOT_NEEDED: {
                                    status = MESSAGES.reqStatusNotNeeded();
                                }
                            }
                        }
                        if (status.isEmpty()) {
                            status = MESSAGES.reqStatusRegistered();
                        }
                        if (prefs != null) {
                            hasPref = true;
                        }
                        credit = new WebTable.Cell((String)(rc.hasCredit() ? (rc.getCreditMin().equals(rc.getCreditMax()) ? df.format((Number)rc.getCreditMin()) : df.format((Number)rc.getCreditMin()) + " - " + df.format((Number)rc.getCreditMax())) : ""));
                        credit.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
                        Object note = null;
                        noteTitle = null;
                        if (check != null) {
                            note = check.getMessageWithColor(rc.getCourseName(), "<br>", "CREDIT");
                            noteTitle = check.getMessage(rc.getCourseName(), "\n", "CREDIT");
                        }
                        if (rc.hasRequestorNote()) {
                            note = (String)(note == null ? "" : note + "<br>") + rc.getRequestorNote();
                            noteTitle = (String)(noteTitle == null ? "" : noteTitle + "\n") + rc.getRequestorNote();
                        }
                        if (rc.hasStatusNote()) {
                            note = (String)(note == null ? "" : note + "<br>") + rc.getStatusNote();
                            noteTitle = (String)(noteTitle == null ? "" : noteTitle + "\n") + rc.getStatusNote();
                        }
                        WebTable.Cell[] cellArray = new WebTable.Cell[10];
                        cellArray[0] = new WebTable.Cell(first ? MESSAGES.courseRequestsPriority(priority) : "");
                        cellArray[1] = new WebTable.Cell(rc.getCourseName());
                        cellArray[2] = new WebTable.Cell(rc.hasCourseTitle() ? rc.getCourseTitle() : "");
                        cellArray[3] = credit;
                        cellArray[4] = new WebTable.Cell(ToolBox.toString(prefs));
                        cellArray[5] = new WebTable.NoteCell((String)note, (String)noteTitle);
                        WebTable.Cell cell = cellArray[6] = icon == null ? new WebTable.Cell((String)status) : new WebTable.IconCell(icon, (String)iconText, (String)status);
                        WebTable.Cell cell2 = first && this.iAssignment.isCanSetCriticalOverrides() ? new CriticalCell(request) : (first && request.isCritical() ? new WebTable.IconCell(RESOURCES.requestsCritical(), MESSAGES.descriptionRequestCritical(), MESSAGES.opSetCritical()) : (first && request.isImportant() ? new WebTable.IconCell(RESOURCES.requestsImportant(), MESSAGES.descriptionRequestImportant(), MESSAGES.opSetImportant()) : (first && request.isVital() ? new WebTable.IconCell(RESOURCES.requestsVital(), MESSAGES.descriptionRequestVital(), MESSAGES.opSetVital()) : (first && request.isLC() ? new WebTable.IconCell(RESOURCES.requestsLC(), MESSAGES.descriptionRequestLC(), MESSAGES.opSetLC()) : (cellArray[7] = first && request.isVisitingF2F() ? new WebTable.IconCell(RESOURCES.requestsVisitingF2F(), MESSAGES.descriptionRequestVisitingF2F(), MESSAGES.opSetVisitingF2F()) : new WebTable.Cell(""))))));
                        cellArray[8] = this.iAssignment.getRequest().getWaitListMode() == OnlineSectioningInterface.WaitListMode.WaitList ? (first && request.isWaitList() ? new WebTable.IconCell(RESOURCES.requestsWaitList(), MESSAGES.descriptionRequestWaitListed(), request.hasWaitListedTimeStamp() ? sWLF.format(request.getWaitListedTimeStamp()) : "") : new WebTable.Cell("")) : (first && request.isNoSub() ? new WebTable.IconCell(RESOURCES.requestsWaitList(), MESSAGES.descriptionRequestNoSubs(), "") : new WebTable.Cell(""));
                        cellArray[9] = new WebTable.Cell(first && request.hasTimeStamp() ? sDF.format(request.getTimeStamp()) : "");
                        row = new WebTable.Row(cellArray);
                        if (priority > 1 && first) {
                            for (WebTable.Cell cell3 : row.getCells()) {
                                cell3.setStyleName("top-border-dashed");
                            }
                        }
                        rows.add(row);
                    } else if (rc.isFreeTime()) {
                        free = "";
                        for (CourseRequestInterface.FreeTime ft : rc.getFreeTime()) {
                            if (!((String)free).isEmpty()) {
                                free = (String)free + ", ";
                            }
                            free = (String)free + ft.toString(CONSTANTS.shortDays(), CONSTANTS.useAmPm());
                        }
                        String note = null;
                        String noteTitle2 = null;
                        if (check != null) {
                            note = check.getMessageWithColor(CONSTANTS.freePrefix() + (String)free, "<br>", new String[0]);
                            noteTitle2 = check.getMessage(CONSTANTS.freePrefix() + (String)free, "\n", "CREDIT");
                        }
                        WebTable.Row row2 = new WebTable.Row(new WebTable.Cell(first ? MESSAGES.courseRequestsPriority(priority) : ""), new WebTable.Cell(CONSTANTS.freePrefix() + (String)free, 3, null), new WebTable.Cell(""), new WebTable.NoteCell(note, noteTitle2), new WebTable.IconCell(RESOURCES.requestSaved(), MESSAGES.requested((String)free), MESSAGES.reqStatusRegistered()), new WebTable.Cell(""), new WebTable.Cell(""), new WebTable.Cell(first && request.hasTimeStamp() ? sDF.format(request.getTimeStamp()) : ""));
                        if (priority > 1 && first) {
                            for (WebTable.Cell cell : row2.getCells()) {
                                cell.setStyleName("top-border-dashed");
                            }
                        }
                        rows.add(row2);
                    }
                    first = false;
                }
                ++priority;
            }
            priority = 1;
            for (CourseRequestInterface.Request request : this.iAssignment.getRequest().getAlternatives()) {
                if (!request.hasRequestedCourse()) continue;
                first = true;
                if (request.isWaitList()) {
                    hasWait = true;
                }
                if (request.isCritical()) {
                    hasCrit = true;
                }
                if (request.isImportant()) {
                    hasImp = true;
                }
                if (request.isVital()) {
                    hasVital = true;
                }
                if (request.isLC()) {
                    hasLC = true;
                }
                if (request.isVisitingF2F()) {
                    hasVisitF2F = true;
                }
                for (CourseRequestInterface.RequestedCourse rc : request.getRequestedCourse()) {
                    if (rc.isCourse()) {
                        icon = null;
                        iconText = null;
                        msg = check.getMessage(rc.getCourseName(), "\n", new String[0]);
                        if (check.isError(rc.getCourseName()) && (rc.getStatus() == null || rc.getStatus() != CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED)) {
                            icon = RESOURCES.requestError();
                            iconText = msg;
                        } else if (rc.getStatus() != null) {
                            switch (rc.getStatus()) {
                                case ENROLLED: {
                                    icon = RESOURCES.requestEnrolled();
                                    iconText = MESSAGES.enrolled(rc.getCourseName());
                                    break;
                                }
                                case OVERRIDE_NEEDED: {
                                    icon = RESOURCES.requestNeeded();
                                    iconText = msg == null ? MESSAGES.overrideNotRequested() : MESSAGES.overrideNeeded(msg);
                                    break;
                                }
                                case SAVED: {
                                    icon = RESOURCES.requestSaved();
                                    iconText = (String)(msg == null ? "" : MESSAGES.requestWarnings(msg) + "\n\n") + MESSAGES.requested(rc.getCourseName());
                                    break;
                                }
                                case OVERRIDE_REJECTED: {
                                    icon = RESOURCES.requestRejected();
                                    iconText = (String)(msg == null ? "" : MESSAGES.requestWarnings(msg) + "\n\n") + MESSAGES.overrideRejected(rc.getCourseName());
                                    break;
                                }
                                case OVERRIDE_PENDING: {
                                    icon = RESOURCES.requestPending();
                                    iconText = (String)(msg == null ? "" : MESSAGES.requestWarnings(msg) + "\n\n") + MESSAGES.overridePending(rc.getCourseName());
                                    break;
                                }
                                case OVERRIDE_CANCELLED: {
                                    icon = RESOURCES.requestCancelled();
                                    iconText = (String)(msg == null ? "" : MESSAGES.requestWarnings(msg) + "\n\n") + MESSAGES.overrideCancelled(rc.getCourseName());
                                    break;
                                }
                                case OVERRIDE_APPROVED: {
                                    icon = RESOURCES.requestSaved();
                                    iconText = (String)(msg == null ? "" : MESSAGES.requestWarnings(msg) + "\n\n") + MESSAGES.overrideApproved(rc.getCourseName());
                                    break;
                                }
                                case OVERRIDE_NOT_NEEDED: {
                                    icon = RESOURCES.requestNotNeeded();
                                    iconText = (String)(msg == null ? "" : MESSAGES.requestWarnings(msg) + "\n\n") + MESSAGES.overrideNotNeeded(rc.getCourseName());
                                    break;
                                }
                                default: {
                                    if (check.isError(rc.getCourseName())) {
                                        icon = RESOURCES.requestError();
                                    }
                                    iconText = msg;
                                }
                            }
                        }
                        if (rc.hasRequestorNote()) {
                            iconText = (String)iconText + "\n" + MESSAGES.requestNote(rc.getRequestorNote());
                        }
                        if (rc.hasStatusNote()) {
                            iconText = (String)iconText + "\n" + MESSAGES.overrideNote(rc.getStatusNote());
                        }
                        AbstractCollection prefs = null;
                        if (rc.hasSelectedIntructionalMethods()) {
                            if (rc.hasSelectedClasses()) {
                                prefs = new ArrayList(rc.getSelectedIntructionalMethods().size() + rc.getSelectedClasses().size());
                                prefs.addAll(new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedIntructionalMethods()));
                                prefs.addAll(new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedClasses()));
                            } else {
                                prefs = new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedIntructionalMethods());
                            }
                        } else if (rc.hasSelectedClasses()) {
                            prefs = new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedClasses());
                        }
                        if (prefs != null) {
                            hasPref = true;
                        }
                        String status = "";
                        if (rc.getStatus() != null) {
                            switch (rc.getStatus()) {
                                case ENROLLED: {
                                    status = MESSAGES.reqStatusEnrolled();
                                    break;
                                }
                                case OVERRIDE_APPROVED: {
                                    status = MESSAGES.reqStatusApproved();
                                    break;
                                }
                                case OVERRIDE_CANCELLED: {
                                    status = MESSAGES.reqStatusCancelled();
                                    break;
                                }
                                case OVERRIDE_PENDING: {
                                    status = MESSAGES.reqStatusPending();
                                    break;
                                }
                                case OVERRIDE_REJECTED: {
                                    status = MESSAGES.reqStatusRejected();
                                    break;
                                }
                                case OVERRIDE_NEEDED: {
                                    status = MESSAGES.reqStatusNeeded();
                                    break;
                                }
                                case OVERRIDE_NOT_NEEDED: {
                                    status = MESSAGES.reqStatusNotNeeded();
                                }
                            }
                        }
                        if (status.isEmpty()) {
                            status = MESSAGES.reqStatusRegistered();
                        }
                        credit = new WebTable.Cell((String)(rc.hasCredit() ? (rc.getCreditMin().equals(rc.getCreditMax()) ? df.format((Number)rc.getCreditMin()) : df.format((Number)rc.getCreditMin()) + " - " + df.format((Number)rc.getCreditMax())) : ""));
                        credit.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
                        Object note = null;
                        noteTitle = null;
                        if (check != null) {
                            note = check.getMessageWithColor(rc.getCourseName(), "<br>", "CREDIT");
                            noteTitle = check.getMessage(rc.getCourseName(), "\n", "CREDIT");
                        }
                        if (rc.hasRequestorNote()) {
                            note = (String)(note == null ? "" : note + "<br>") + rc.getRequestorNote();
                            noteTitle = (String)(noteTitle == null ? "" : (String)noteTitle + "\n") + rc.getRequestorNote();
                        }
                        if (rc.hasStatusNote()) {
                            note = (String)(note == null ? "" : note + "<br>") + rc.getStatusNote();
                            noteTitle = (String)(noteTitle == null ? "" : (String)noteTitle + "\n") + rc.getStatusNote();
                        }
                        WebTable.Cell[] cellArray = new WebTable.Cell[10];
                        cellArray[0] = new WebTable.Cell(first ? MESSAGES.courseRequestsAlternate(priority) : "");
                        cellArray[1] = new WebTable.Cell(rc.getCourseName());
                        cellArray[2] = new WebTable.Cell(rc.hasCourseTitle() ? rc.getCourseTitle() : "");
                        cellArray[3] = credit;
                        cellArray[4] = new WebTable.Cell(ToolBox.toString(prefs));
                        cellArray[5] = new WebTable.NoteCell((String)note, (String)noteTitle);
                        WebTable.Cell cell = cellArray[6] = icon == null ? new WebTable.Cell(status) : new WebTable.IconCell(icon, (String)iconText, status);
                        WebTable.Cell cell4 = first && this.iAssignment.isCanSetCriticalOverrides() ? new CriticalCell(request) : (first && request.isCritical() ? new WebTable.IconCell(RESOURCES.requestsCritical(), MESSAGES.descriptionRequestCritical(), MESSAGES.opSetCritical()) : (first && request.isImportant() ? new WebTable.IconCell(RESOURCES.requestsImportant(), MESSAGES.descriptionRequestImportant(), MESSAGES.opSetImportant()) : (first && request.isVital() ? new WebTable.IconCell(RESOURCES.requestsVital(), MESSAGES.descriptionRequestVital(), MESSAGES.opSetVital()) : (first && request.isLC() ? new WebTable.IconCell(RESOURCES.requestsLC(), MESSAGES.descriptionRequestLC(), MESSAGES.opSetLC()) : (cellArray[7] = first && request.isVisitingF2F() ? new WebTable.IconCell(RESOURCES.requestsVisitingF2F(), MESSAGES.descriptionRequestVisitingF2F(), MESSAGES.opSetVisitingF2F()) : new WebTable.Cell(""))))));
                        cellArray[8] = first && request.isWaitList() ? new WebTable.IconCell(RESOURCES.requestsWaitList(), MESSAGES.descriptionRequestWaitListed(), request.hasWaitListedTimeStamp() ? sWLF.format(request.getWaitListedTimeStamp()) : "") : new WebTable.Cell("");
                        cellArray[9] = new WebTable.Cell(first && request.hasTimeStamp() ? sDF.format(request.getTimeStamp()) : "");
                        row = new WebTable.Row(cellArray);
                        if (first) {
                            for (WebTable.Cell cell3 : row.getCells()) {
                                cell3.setStyleName(priority == 1 ? "top-border-solid" : "top-border-dashed");
                            }
                        }
                        rows.add(row);
                    } else if (rc.isFreeTime()) {
                        free = "";
                        for (CourseRequestInterface.FreeTime ft : rc.getFreeTime()) {
                            if (!((String)free).isEmpty()) {
                                free = (String)free + ", ";
                            }
                            free = (String)free + ft.toString(CONSTANTS.shortDays(), CONSTANTS.useAmPm());
                        }
                        WebTable.Row row3 = new WebTable.Row(new WebTable.Cell(first ? MESSAGES.courseRequestsAlternate(priority) : ""), new WebTable.Cell(CONSTANTS.freePrefix() + (String)free, 3, null), new WebTable.Cell(""), new WebTable.Cell(""), new WebTable.IconCell(RESOURCES.requestSaved(), MESSAGES.requested((String)free), MESSAGES.reqStatusRegistered()), new WebTable.Cell(""), new WebTable.Cell(""), new WebTable.Cell(first && request.hasTimeStamp() ? sDF.format(request.getTimeStamp()) : ""));
                        if (first) {
                            for (WebTable.Cell cell : row3.getCells()) {
                                cell.setStyleName(priority == 1 ? "top-border-solid" : "top-border-dashed");
                            }
                        }
                        rows.add(row3);
                    }
                    first = false;
                }
                ++priority;
            }
        }
        if (this.iAssignment.getRequest().getMaxCreditOverrideStatus() != null) {
            float[] range;
            ImageResource icon = null;
            String status = "";
            Object note = null;
            Object noteTitle = null;
            Object iconText = null;
            if (this.iAssignment.getRequest().hasCreditWarning()) {
                note = this.iAssignment.getRequest().getCreditWarning().replace("\n", "<br>");
                noteTitle = this.iAssignment.getRequest().getCreditWarning();
                iconText = this.iAssignment.getRequest().getCreditWarning();
                hasWarn = true;
            } else if (this.iAssignment.getRequest().getMaxCreditOverrideStatus() != CourseRequestInterface.RequestedCourseStatus.SAVED) {
                noteTitle = iconText = MESSAGES.creditWarning(this.iAssignment.getRequest().getMaxCredit().floatValue());
                note = iconText;
            }
            switch (this.iAssignment.getRequest().getMaxCreditOverrideStatus()) {
                case CREDIT_HIGH: {
                    icon = RESOURCES.requestNeeded();
                    status = MESSAGES.reqStatusWarning();
                    note = "<span class='text-red'>" + (String)note + "</span>";
                    iconText = (String)iconText + "\n" + MESSAGES.creditStatusTooHigh();
                    break;
                }
                case OVERRIDE_REJECTED: {
                    icon = RESOURCES.requestError();
                    status = MESSAGES.reqStatusRejected();
                    note = "<span class='text-red'>" + (String)note + "</span>";
                    iconText = (String)iconText + "\n" + MESSAGES.creditStatusDenied();
                    break;
                }
                case OVERRIDE_NEEDED: 
                case CREDIT_LOW: {
                    icon = RESOURCES.requestNeeded();
                    status = MESSAGES.reqStatusWarning();
                    note = "<span class='text-orange'>" + (String)note + "</span>";
                    break;
                }
                case OVERRIDE_CANCELLED: {
                    icon = RESOURCES.requestNeeded();
                    status = MESSAGES.reqStatusCancelled();
                    iconText = (String)iconText + "\n" + MESSAGES.creditStatusCancelled();
                    note = "<span class='text-orange'>" + (String)note + "</span>";
                    break;
                }
                case OVERRIDE_PENDING: {
                    icon = RESOURCES.requestPending();
                    status = MESSAGES.reqStatusPending();
                    iconText = (String)iconText + "\n" + MESSAGES.creditStatusPending();
                    note = "<span class='text-orange'>" + (String)note + "</span>";
                    break;
                }
                case OVERRIDE_APPROVED: {
                    icon = RESOURCES.requestSaved();
                    status = MESSAGES.reqStatusApproved();
                    iconText = (String)iconText + (String)(iconText == null ? "" : (String)iconText + "\n") + MESSAGES.creditStatusApproved();
                    break;
                }
                case SAVED: {
                    icon = null;
                    status = "";
                }
            }
            if (this.iAssignment.getRequest().hasRequestorNote()) {
                note = (String)(note == null ? "" : (String)note + "<br>") + this.iAssignment.getRequest().getRequestorNote().replace("\n", "<br>");
                noteTitle = (String)(noteTitle == null ? "" : (String)noteTitle + "\n") + MESSAGES.requestNote(this.iAssignment.getRequest().getRequestorNote());
                iconText = (String)(iconText == null ? "" : (String)iconText + "\n") + this.iAssignment.getRequest().getRequestorNote();
                hasWarn = true;
            }
            if (this.iAssignment.getRequest().hasCreditNote()) {
                note = (String)(note == null ? "" : (String)note + "<br>") + this.iAssignment.getRequest().getCreditNote().replace("\n", "<br>");
                noteTitle = (String)(noteTitle == null ? "" : (String)noteTitle + "\n") + MESSAGES.overrideNote(this.iAssignment.getRequest().getCreditNote());
                iconText = (String)(iconText == null ? "" : (String)iconText + "\n") + this.iAssignment.getRequest().getCreditNote();
                hasWarn = true;
            }
            WebTable.Cell credit = new WebTable.Cell((String)((range = this.iAssignment.getRequest().getCreditRange(this.iAssignment.getAdvisorWaitListedCourseIds())) != null ? (range[0] < range[1] ? df.format((double)range[0]) + " - " + df.format((double)range[1]) : df.format((double)range[0])) : ""));
            credit.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
            WebTable.Row row = new WebTable.Row(new WebTable.Cell(MESSAGES.rowRequestedCredit(), 2, null), new WebTable.Cell(""), credit, new WebTable.Cell(""), new WebTable.NoteCell((String)note, (String)noteTitle), icon == null ? new WebTable.Cell(status) : new WebTable.IconCell(icon, (String)iconText, status), new WebTable.Cell(""), new WebTable.Cell(""));
            for (WebTable.Cell cell : row.getCells()) {
                cell.setStyleName("top-border-solid");
            }
            row.getCell(0).setStyleName("top-border-solid text-bold");
            rows.add(row);
        }
        WebTable.Row[] rowArray = new WebTable.Row[rows.size()];
        int idx = 0;
        for (WebTable.Row row : rows) {
            rowArray[idx++] = row;
        }
        this.iRequests.setData(rowArray);
        this.iRequests.setColumnVisible(4, hasPref);
        this.iRequests.setColumnVisible(5, hasWarn);
        this.iRequests.setColumnVisible(7, hasCrit || hasImp || hasVital || hasLC || hasVisitF2F || this.iAssignment.isCanSetCriticalOverrides());
        if (!(!hasCrit || hasImp || hasVital || hasLC || hasVisitF2F)) {
            this.iRequests.getTable().setHTML(0, 7, MESSAGES.opSetCritical());
        } else if (!(hasCrit || !hasImp || hasVital || hasLC || hasVisitF2F)) {
            this.iRequests.getTable().setHTML(0, 7, MESSAGES.opSetImportant());
        } else if (!(hasCrit || hasImp || !hasVital || hasLC || hasVisitF2F)) {
            this.iRequests.getTable().setHTML(0, 7, MESSAGES.opSetVital());
        } else {
            this.iRequests.getTable().setHTML(0, 7, MESSAGES.colCritical());
        }
        this.iRequests.setColumnVisible(8, hasWait);
    }

    protected void fillInAssignments() {
        ArrayList<WebTable.Row> rows = new ArrayList<WebTable.Row>();
        this.iTotalCredit = 0.0f;
        for (ClassAssignmentInterface.CourseAssignment course : this.iAssignment.getCourseAssignments()) {
            WebTable.Cell[] cellArray;
            if (course.isAssigned()) {
                boolean firstClazz = true;
                for (ClassAssignmentInterface.ClassAssignment clazz : course.getClassAssignments()) {
                    Object style;
                    Object object = style = firstClazz && !rows.isEmpty() ? "top-border-dashed" : "";
                    if (clazz.isTeachingAssignment()) {
                        style = (String)style + (clazz.isInstructing() ? " text-steelblue" : " text-steelblue-italic");
                    }
                    WebTable.Cell[] cellArray2 = new WebTable.Cell[15];
                    cellArray2[0] = new WebTable.Cell(firstClazz ? (course.isFreeTime() ? MESSAGES.freeTimeSubject() : course.getSubject()) : "");
                    cellArray2[1] = new WebTable.Cell(firstClazz ? (course.isFreeTime() ? MESSAGES.freeTimeCourse() : course.getCourseNbr()) : "");
                    cellArray2[2] = new WebTable.Cell(clazz.getSubpart());
                    cellArray2[3] = new WebTable.Cell(clazz.getSection());
                    cellArray2[4] = new WebTable.Cell(clazz.getLimitString());
                    cellArray2[5] = new WebTable.Cell(clazz.getDaysString(CONSTANTS.shortDays()));
                    cellArray2[6] = new WebTable.Cell(clazz.getStartString(CONSTANTS.useAmPm()));
                    cellArray2[7] = new WebTable.Cell(clazz.getEndString(CONSTANTS.useAmPm()));
                    cellArray2[8] = new WebTable.Cell(clazz.getDatePattern());
                    cellArray2[9] = clazz.hasDistanceConflict() ? new WebTable.RoomCell(clazz.hasLongDistanceConflict() ? RESOURCES.longDistantConflict() : RESOURCES.distantConflict(), MESSAGES.backToBackDistance(clazz.getBackToBackRooms(), clazz.getBackToBackDistance()), clazz.getRooms(), ", ") : new WebTable.RoomCell((List<ClassAssignmentInterface.IdValue>)clazz.getRooms(), ", ");
                    cellArray2[10] = new WebTable.InstructorCell(clazz.getInstructors(), clazz.getInstructorEmails(), ", ");
                    cellArray2[11] = new WebTable.Cell(clazz.getParentSection());
                    cellArray2[12] = clazz.hasNote() ? new WebTable.IconCell(RESOURCES.note(), clazz.getNote(), "") : new WebTable.Cell("");
                    cellArray2[13] = new WebTable.AbbvTextCell(clazz.getCredit());
                    cellArray2[14] = new WebTable.Cell(clazz.getEnrolledDate() == null ? "" : sDF.format(clazz.getEnrolledDate()));
                    WebTable.Row row = new WebTable.Row(cellArray2);
                    if (clazz.isTeachingAssignment()) {
                        row.setStyleName("teaching-assignment");
                    }
                    rows.add(row);
                    for (WebTable.Cell cell : row.getCells()) {
                        cell.setStyleName((String)style);
                    }
                    firstClazz = false;
                    if (clazz.isTeachingAssignment()) continue;
                    this.iTotalCredit += clazz.guessCreditCount();
                }
                continue;
            }
            String style = "text-red" + (!rows.isEmpty() ? " top-border-dashed" : "");
            WebTable.Row row = null;
            Object unassignedMessage = MESSAGES.courseNotAssigned();
            if (course.hasEnrollmentMessage()) {
                unassignedMessage = course.getEnrollmentMessage();
            } else if (course.getOverlaps() != null && !course.getOverlaps().isEmpty()) {
                unassignedMessage = "";
                Iterator<String> i = course.getOverlaps().iterator();
                while (i.hasNext()) {
                    String x = i.next();
                    if (((String)unassignedMessage).isEmpty()) {
                        unassignedMessage = (String)unassignedMessage + MESSAGES.conflictWithFirst(x);
                        continue;
                    }
                    if (!i.hasNext()) {
                        unassignedMessage = (String)unassignedMessage + MESSAGES.conflictWithLast(x);
                        continue;
                    }
                    unassignedMessage = (String)unassignedMessage + MESSAGES.conflictWithMiddle(x);
                }
                if (course.getInstead() != null) {
                    unassignedMessage = (String)unassignedMessage + MESSAGES.conflictAssignedAlternative(course.getInstead());
                }
                unassignedMessage = (String)unassignedMessage + ".";
            } else if (course.isNotAvailable()) {
                unassignedMessage = course.hasConflictMessage() ? course.getConflictMessage() : (course.isFull() ? MESSAGES.courseIsFull() : (course.hasHasIncompReqs() ? MESSAGES.classNotAvailableDueToStudentPrefs() : MESSAGES.classNotAvailable()));
            } else if (course.isLocked()) {
                unassignedMessage = MESSAGES.courseLocked(course.getSubject() + " " + course.getCourseNbr());
            }
            if (course.isOverMaxCredit()) {
                unassignedMessage = MESSAGES.conflictOverMaxCredit(course.getOverMaxCredit().floatValue()) + (String)(MESSAGES.courseNotAssigned().equals(unassignedMessage) ? "" : "\n" + (String)unassignedMessage);
            }
            if (course.getWaitListedDate() != null) {
                unassignedMessage = MESSAGES.conflictWaitListed(sWLF.format(course.getWaitListedDate())) + (String)(unassignedMessage == null || ((String)unassignedMessage).isEmpty() || MESSAGES.courseNotAssigned().equals(unassignedMessage) ? "" : "\n" + (String)unassignedMessage);
            }
            if ((cellArray = course.getClassAssignments().iterator()).hasNext()) {
                ClassAssignmentInterface.ClassAssignment clazz = cellArray.next();
                row = new WebTable.Row(new WebTable.Cell(course.isFreeTime() ? MESSAGES.freeTimeSubject() : course.getSubject()), new WebTable.Cell(course.isFreeTime() ? MESSAGES.freeTimeCourse() : course.getCourseNbr()), new WebTable.Cell(clazz.getSubpart()), new WebTable.Cell(clazz.getSection()), new WebTable.Cell(clazz.getLimitString()), new WebTable.Cell(clazz.getDaysString(CONSTANTS.shortDays())), new WebTable.Cell(clazz.getStartString(CONSTANTS.useAmPm())), new WebTable.Cell(clazz.getEndString(CONSTANTS.useAmPm())), new WebTable.Cell(clazz.getDatePattern()), new WebTable.PreCell((String)unassignedMessage, 3), clazz.getNote() == null ? new WebTable.Cell("") : new WebTable.IconCell(RESOURCES.note(), clazz.getNote(), ""), new WebTable.AbbvTextCell(clazz.getCredit()), new WebTable.Cell(clazz.getEnrolledDate() != null ? sDF.format(clazz.getEnrolledDate()) : (course.getRequestedDate() == null ? "" : sDF.format(course.getRequestedDate()))));
            }
            if (row == null) {
                row = new WebTable.Row(new WebTable.Cell(course.getSubject()), new WebTable.Cell(course.getCourseNbr()), new WebTable.PreCell((String)unassignedMessage, 12), new WebTable.Cell(course.getRequestedDate() == null ? "" : sDF.format(course.getRequestedDate())));
            }
            cellArray = row.getCells();
            int n = cellArray.length;
            for (int i = 0; i < n; ++i) {
                WebTable.Cell cell = cellArray[i];
                cell.setStyleName(style);
            }
            row.getCell(row.getNrCells() - 2).setStyleName("text-gray" + (!rows.isEmpty() ? " top-border-dashed" : ""));
            rows.add(row);
        }
        WebTable.Row[] rowArray = new WebTable.Row[rows.size()];
        int idx = 0;
        for (WebTable.Row row : rows) {
            rowArray[idx++] = row;
        }
        this.iAssignments.setData(rowArray);
        if (!this.iOnline) {
            for (int row = 0; row < this.iAssignments.getTable().getRowCount(); ++row) {
                if (this.iAssignments.getTable().getCellCount(row) <= 2) continue;
                this.iAssignments.getTable().getFlexCellFormatter().setVisible(row, this.iAssignments.getTable().getCellCount(row) - 2, false);
            }
        }
    }

    public void fillInNotes() {
        this.iTabs.getTabBar().setTabEnabled(6, this.iAssignment.hasNotes());
        if (this.iTabs.getSelectedTab() != 6) {
            ((Widget)this.iTabs.getTabBar().getTab(6)).setVisible(this.iAssignment.hasNotes());
        }
        ArrayList<WebTable.Row> rows = new ArrayList<WebTable.Row>();
        if (this.iAssignment.hasNotes()) {
            for (ClassAssignmentInterface.Note note : this.iAssignment.getNotes()) {
                WebTable.Row row = new WebTable.Row(new WebTable.Cell(sTSF.format(note.getTimeStamp())), new WebTable.Cell(note.getMessage()), new WebTable.Cell(note.getOwner()));
                rows.add(row);
            }
        }
        WebTable.Row[] rowArray = new WebTable.Row[rows.size()];
        int idx = 0;
        for (WebTable.Row row : rows) {
            rowArray[idx++] = row;
        }
        this.iNotes.setData(rowArray);
    }

    /*
     * Could not resolve type clashes
     */
    public void fillInSpecialRegistrations() {
        this.iTabs.getTabBar().setTabEnabled(4, this.iAssignment.hasSpecialRegistrations());
        if (this.iTabs.getSelectedTab() != 4) {
            ((Widget)this.iTabs.getTabBar().getTab(4)).setVisible(this.iAssignment.hasSpecialRegistrations());
        }
        this.iSpecialRegistrations.clearTable(1);
        if (this.iAssignment.hasSpecialRegistrations()) {
            for (SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse reg : this.iAssignment.getSpecialRegistrations()) {
                P p = new P("icons");
                if (reg.isFullyApplied(this.iAssignment)) {
                    p.add((Widget)new Icon(RESOURCES.specRegApplied(), MESSAGES.hintSpecRegApplied()));
                } else if (reg.getStatus() != null) {
                    switch (reg.getStatus()) {
                        case Approved: {
                            if (reg.isGradeModeChange() || reg.isVariableTitleCourseChange() || reg.isExtended()) {
                                p.add((Widget)new Icon(RESOURCES.specRegApproved(), MESSAGES.hintSpecRegApproved()));
                                break;
                            }
                            p.add((Widget)new Icon(RESOURCES.specRegApproved(), MESSAGES.hintSpecRegApprovedNoteApply()));
                            break;
                        }
                        case Cancelled: {
                            p.add((Widget)new Icon(RESOURCES.specRegCancelled(), MESSAGES.hintSpecRegCancelled()));
                            break;
                        }
                        case Pending: {
                            if (reg.isHonorsGradeModeNotFullyMatching(this.iAssignment)) {
                                p.add((Widget)new Icon(RESOURCES.specRegCancelled(), MESSAGES.hintSpecRegHonorsGradeModeNotMatchingSchedule()));
                                break;
                            }
                            p.add((Widget)new Icon(RESOURCES.specRegPending(), MESSAGES.hintSpecRegPending()));
                            break;
                        }
                        case Rejected: {
                            p.add((Widget)new Icon(RESOURCES.specRegRejected(), MESSAGES.hintSpecRegRejected()));
                            break;
                        }
                        case Draft: {
                            p.add((Widget)new Icon(RESOURCES.specRegDraft(), MESSAGES.hintSpecRegDraft()));
                        }
                    }
                }
                if (reg.hasChanges()) {
                    Object ca2;
                    Long lastCourseId = null;
                    ArrayList<ClassAssignmentInterface.ClassAssignment> rows = new ArrayList<ClassAssignmentInterface.ClassAssignment>();
                    for (Object ca2 : reg.getChanges()) {
                        if (((ClassAssignmentInterface.ClassAssignment)ca2).getParentSection() != null && ((ClassAssignmentInterface.ClassAssignment)ca2).getParentSection().equals(((ClassAssignmentInterface.ClassAssignment)ca2).getSection())) continue;
                        rows.add((ClassAssignmentInterface.ClassAssignment)ca2);
                    }
                    for (int r = 0; r < rows.size(); ++r) {
                        int c;
                        ca2 = (ClassAssignmentInterface.ClassAssignment)rows.get(r);
                        ArrayList<Object> row = new ArrayList<Object>();
                        if (lastCourseId == null) {
                            row.add((Object)p);
                        } else {
                            row.add((Object)new P("icons"));
                        }
                        Label label = new Label();
                        label.addStyleName("date-and-note");
                        if (lastCourseId == null || !lastCourseId.equals(((ClassAssignmentInterface.ClassAssignment)ca2).getCourseId())) {
                            String note = reg.getNote(((ClassAssignmentInterface.ClassAssignment)rows.get(r)).getCourseName());
                            label.setText((String)(r > 0 || reg.getSubmitDate() == null ? (note == null ? "" : note) : sModifiedDateFormat.format(reg.getSubmitDate()) + (String)(note == null || note.isEmpty() ? "" : "\n" + note)));
                        }
                        row.add(label);
                        if (lastCourseId == null || !lastCourseId.equals(((ClassAssignmentInterface.ClassAssignment)ca2).getCourseId())) {
                            row.add(new Label(((ClassAssignmentInterface.ClassAssignment)ca2).getSubject(), false));
                            row.add(new Label(((ClassAssignmentInterface.ClassAssignment)ca2).getCourseNbr(), false));
                        } else {
                            row.add(new Label());
                            row.add(new Label());
                        }
                        row.add(new Label(((ClassAssignmentInterface.ClassAssignment)ca2).getSubpart(), false));
                        row.add(new Label(((ClassAssignmentInterface.ClassAssignment)ca2).getSection(), false));
                        row.add(new HTML(((ClassAssignmentInterface.ClassAssignment)ca2).getLimitString(), false));
                        if (((ClassAssignmentInterface.ClassAssignment)ca2).getCreditHour() != null) {
                            row.add(new Label(MESSAGES.credit(((ClassAssignmentInterface.ClassAssignment)ca2).getCreditHour().floatValue())));
                        } else {
                            row.add((Object)new CreditCell(((ClassAssignmentInterface.ClassAssignment)ca2).getCredit()));
                        }
                        if (((ClassAssignmentInterface.ClassAssignment)ca2).getGradeMode() != null) {
                            Label gm = new Label(((ClassAssignmentInterface.ClassAssignment)ca2).getGradeMode().getCode());
                            if (((ClassAssignmentInterface.ClassAssignment)ca2).getGradeMode().getLabel() != null) {
                                gm.setTitle(((ClassAssignmentInterface.ClassAssignment)ca2).getGradeMode().getLabel());
                            }
                            row.add(gm);
                        } else {
                            row.add(new Label());
                        }
                        HTML errorsLabel = new HTML(((ClassAssignmentInterface.ClassAssignment)ca2).hasError() ? ((ClassAssignmentInterface.ClassAssignment)ca2).getError() : "");
                        errorsLabel.addStyleName("registration-errors");
                        row.add(errorsLabel);
                        P s = new P("icons");
                        switch (((ClassAssignmentInterface.ClassAssignment)ca2).getSpecRegOperation()) {
                            case Add: {
                                s.add((Widget)new Icon(RESOURCES.assignment(), MESSAGES.specRegAssignment(((ClassAssignmentInterface.ClassAssignment)ca2).getSubject() + " " + ((ClassAssignmentInterface.ClassAssignment)ca2).getCourseNbr() + " " + ((ClassAssignmentInterface.ClassAssignment)ca2).getSubpart() + " " + ((ClassAssignmentInterface.ClassAssignment)ca2).getSection())));
                                break;
                            }
                            case Drop: {
                                s.add((Widget)new Icon(RESOURCES.unassignment(), MESSAGES.specRegRemoved(((ClassAssignmentInterface.ClassAssignment)ca2).getSubject() + " " + ((ClassAssignmentInterface.ClassAssignment)ca2).getCourseNbr() + " " + ((ClassAssignmentInterface.ClassAssignment)ca2).getSubpart() + " " + ((ClassAssignmentInterface.ClassAssignment)ca2).getSection())));
                                break;
                            }
                            case Keep: {
                                if (((ClassAssignmentInterface.ClassAssignment)ca2).getGradeMode() != null && ((ClassAssignmentInterface.ClassAssignment)ca2).getGradeMode().isHonor()) {
                                    boolean found = false;
                                    for (ClassAssignmentInterface.ClassAssignment x : this.iAssignment.getClassAssignments()) {
                                        if (!x.isSaved() || !((ClassAssignmentInterface.ClassAssignment)ca2).getClassId().equals(x.getClassId())) continue;
                                        found = true;
                                        break;
                                    }
                                    if (!found) {
                                        s.add((Widget)new Icon(RESOURCES.unassignment(), MESSAGES.specRegRemoved(((ClassAssignmentInterface.ClassAssignment)ca2).getSubject() + " " + ((ClassAssignmentInterface.ClassAssignment)ca2).getCourseNbr() + " " + ((ClassAssignmentInterface.ClassAssignment)ca2).getSubpart() + " " + ((ClassAssignmentInterface.ClassAssignment)ca2).getSection())));
                                    }
                                }
                            }
                            default: {
                                s.add((Widget)new Label());
                            }
                        }
                        row.add((Object)s);
                        int idx = this.iSpecialRegistrations.addRow(reg, row);
                        if (reg.getStatus() == SpecialRegistrationInterface.SpecialRegistrationStatus.Approved) {
                            this.iSpecialRegistrations.setBackGroundColor(idx, "#D7FFD7");
                        }
                        if (idx > 1 && lastCourseId == null) {
                            for (int c2 = 0; c2 < this.iSpecialRegistrations.getCellCount(idx); ++c2) {
                                this.iSpecialRegistrations.getCellFormatter().addStyleName(idx, c2, "top-border-solid");
                            }
                        }
                        if (lastCourseId != null && !lastCourseId.equals(((ClassAssignmentInterface.ClassAssignment)ca2).getCourseId())) {
                            for (int c3 = 2; c3 < this.iSpecialRegistrations.getCellCount(idx) - 1; ++c3) {
                                this.iSpecialRegistrations.getCellFormatter().addStyleName(idx, c3, "top-border-dashed");
                            }
                        }
                        if (!((ClassAssignmentInterface.ClassAssignment)ca2).isCourseAssigned()) {
                            for (c = 2; c < this.iSpecialRegistrations.getCellCount(idx) - 1; ++c) {
                                this.iSpecialRegistrations.getCellFormatter().addStyleName(idx, c, ((ClassAssignmentInterface.ClassAssignment)ca2).hasError() ? "change-drop-with-errors" : "change-drop");
                            }
                        } else {
                            for (c = 2; c < this.iSpecialRegistrations.getCellCount(idx) - 1; ++c) {
                                this.iSpecialRegistrations.getCellFormatter().addStyleName(idx, c, "change-add");
                            }
                        }
                        lastCourseId = ((ClassAssignmentInterface.ClassAssignment)ca2).getCourseId();
                    }
                    Object noCourseErrors = "";
                    if (reg.hasErrors()) {
                        ca2 = reg.getErrors().iterator();
                        while (ca2.hasNext()) {
                            ClassAssignmentInterface.ErrorMessage e = (ClassAssignmentInterface.ErrorMessage)ca2.next();
                            if (e.getCourse() != null && !e.getCourse().isEmpty()) continue;
                            noCourseErrors = (String)noCourseErrors + (((String)noCourseErrors).isEmpty() ? "" : "\n") + e.getMessage();
                        }
                    }
                    if (((String)noCourseErrors).isEmpty()) continue;
                    ArrayList<Object> row = new ArrayList<Object>();
                    row.add((Object)new P("icons"));
                    row.add((Object)new DateAndNoteCell(null, reg.getNote("MAXI")));
                    row.add(new DescriptionCell(null));
                    HTML errorsLabel = new HTML((String)noCourseErrors);
                    errorsLabel.addStyleName("registration-errors");
                    row.add(errorsLabel);
                    row.add(new Label());
                    int idx = this.iSpecialRegistrations.addRow(reg, row);
                    for (int c = 2; c < this.iSpecialRegistrations.getCellCount(idx) - 1; ++c) {
                        this.iSpecialRegistrations.getCellFormatter().addStyleName(idx, c, "top-border-dashed");
                    }
                    continue;
                }
                if (!reg.hasErrors()) continue;
                ArrayList<Object> row = new ArrayList<Object>();
                row.add((Object)p);
                row.add((Object)new DateAndNoteCell(reg.getSubmitDate(), reg.getNote("MAXI")));
                row.add(new DescriptionCell(reg.getDescription()));
                Object errors = "";
                for (ClassAssignmentInterface.ErrorMessage e : reg.getErrors()) {
                    errors = (String)errors + (((String)errors).isEmpty() ? "" : "\n") + e.getMessage();
                }
                HTML errorsLabel = new HTML((String)errors);
                errorsLabel.addStyleName("registration-errors");
                row.add(errorsLabel);
                row.add(new Label());
                int idx = this.iSpecialRegistrations.addRow(reg, row);
                if (idx <= 1) continue;
                for (int c = 0; c < this.iSpecialRegistrations.getCellCount(idx); ++c) {
                    this.iSpecialRegistrations.getCellFormatter().addStyleName(idx, c, "top-border-solid");
                }
            }
        }
    }

    public void fillInWaitLists() {
        this.iWaitLists.clearTable(1);
        if (this.iAssignment != null && this.iAssignment.hasRequest() && this.iAssignment.getRequest().getWaitListMode() == OnlineSectioningInterface.WaitListMode.WaitList) {
            NumberFormat df = NumberFormat.getFormat((String)"0.#");
            boolean hasSwap = false;
            boolean hasPosition = false;
            boolean hasPrefs = false;
            block17: for (CourseRequestInterface.Request request : this.iAssignment.getRequest().getCourses()) {
                if (!request.isWaitList() || !request.hasRequestedCourse()) continue;
                for (CourseRequestInterface.RequestedCourse requestedCourse : request.getRequestedCourse()) {
                    if (requestedCourse.getStatus() != CourseRequestInterface.RequestedCourseStatus.ENROLLED || request.getWaitListSwapWithCourseOfferingId() != null && request.getWaitListSwapWithCourseOfferingId().equals(requestedCourse.getCourseId())) continue;
                    continue block17;
                }
                boolean firstLine = true;
                for (CourseRequestInterface.RequestedCourse rc3 : request.getRequestedCourse()) {
                    if (!rc3.hasCourseId() || !rc3.isCanWaitList()) continue;
                    P p = new P("icons");
                    String style = "pending";
                    if (rc3.getStatus() != null) {
                        switch (rc3.getStatus()) {
                            case OVERRIDE_APPROVED: {
                                p.add((Widget)new Icon(RESOURCES.specRegApproved(), MESSAGES.hintSpecRegApproved()));
                                style = "approved";
                                break;
                            }
                            case OVERRIDE_CANCELLED: {
                                p.add((Widget)new Icon(RESOURCES.specRegCancelled(), MESSAGES.hintSpecRegCancelled()));
                                style = "cancelled";
                                break;
                            }
                            case OVERRIDE_PENDING: {
                                p.add((Widget)new Icon(RESOURCES.specRegPending(), MESSAGES.hintSpecRegPending()));
                                style = "pending";
                                break;
                            }
                            case OVERRIDE_REJECTED: {
                                p.add((Widget)new Icon(RESOURCES.specRegRejected(), MESSAGES.hintSpecRegRejected()));
                                style = "rejected";
                                break;
                            }
                            case OVERRIDE_NEEDED: 
                            case NEW_REQUEST: {
                                p.add((Widget)new Icon(RESOURCES.requestNeeded(), MESSAGES.reqStatusNeeded()));
                                style = "needed";
                                break;
                            }
                            case WAITLIST_INACTIVE: {
                                p.add((Widget)new Icon(RESOURCES.waitListNotActive(), MESSAGES.waitListInactive(rc3.getCourseName())));
                                style = "cancelled";
                                break;
                            }
                            case ENROLLED: 
                            case SAVED: {
                                p.add((Widget)new Icon(RESOURCES.requestsWaitList(), MESSAGES.descriptionRequestWaitListed()));
                                style = "saved";
                            }
                        }
                    } else {
                        p.add((Widget)new Icon(RESOURCES.requestsWaitList(), MESSAGES.descriptionRequestWaitListed()));
                        style = "saved";
                    }
                    ArrayList<Object> row = new ArrayList<Object>();
                    row.add((Object)p);
                    row.add((Object)new DateAndNoteCell(firstLine ? request.getWaitListedTimeStamp() : null, rc3.getRequestorNote()));
                    row.add(new Label(rc3.getCourseName()));
                    row.add(new Label(rc3.hasCourseTitle() ? rc3.getCourseTitle() : ""));
                    row.add(new Label((String)(rc3.hasCredit() ? (rc3.getCreditMin().equals(rc3.getCreditMax()) ? df.format((Number)rc3.getCreditMin()) : df.format((Number)rc3.getCreditMin()) + " - " + df.format((Number)rc3.getCreditMax())) : "")));
                    if (firstLine && request.getWaitListSwapWithCourseOfferingId() != null && this.iAssignment != null) {
                        Label swap = null;
                        for (ClassAssignmentInterface.CourseAssignment course : this.iAssignment.getCourseAssignments()) {
                            if (!request.getWaitListSwapWithCourseOfferingId().equals(course.getCourseId()) || course.isTeachingAssignment() || !course.isAssigned()) continue;
                            swap = new Label(course.getCourseName());
                            swap.setTitle(MESSAGES.conflictWaitListSwapWithNoCourseOffering(course.getCourseNameWithTitle()));
                            hasSwap = true;
                            break;
                        }
                        row.add(swap == null ? new Label("") : swap);
                    } else {
                        row.add(new Label(""));
                    }
                    if (rc3.hasWaitListPosition() && rc3.getStatus() != CourseRequestInterface.RequestedCourseStatus.NEW_REQUEST && rc3.getStatus() != CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NEEDED) {
                        hasPosition = true;
                        row.add(new Label(rc3.getWaitListPosition()));
                    } else {
                        row.add(new Label());
                    }
                    AbstractCollection prefs = null;
                    if (rc3.hasSelectedIntructionalMethods()) {
                        if (rc3.hasSelectedClasses()) {
                            prefs = new ArrayList(rc3.getSelectedIntructionalMethods().size() + rc3.getSelectedClasses().size());
                            prefs.addAll(new TreeSet<CourseRequestInterface.Preference>(rc3.getSelectedIntructionalMethods()));
                            prefs.addAll(new TreeSet<CourseRequestInterface.Preference>(rc3.getSelectedClasses()));
                        } else {
                            prefs = new TreeSet<CourseRequestInterface.Preference>(rc3.getSelectedIntructionalMethods());
                        }
                    } else if (rc3.hasSelectedClasses()) {
                        prefs = new TreeSet<CourseRequestInterface.Preference>(rc3.getSelectedClasses());
                    }
                    if (prefs != null && !prefs.isEmpty()) {
                        Iterator i = prefs.iterator();
                        while (i.hasNext()) {
                            CourseRequestInterface.Preference pr = (CourseRequestInterface.Preference)i.next();
                            if (pr.isRequired()) continue;
                            i.remove();
                        }
                    }
                    row.add(new Label(ToolBox.toString(prefs)));
                    if (prefs != null && !prefs.isEmpty()) {
                        hasPrefs = true;
                    }
                    String note = null;
                    if (this.iAssignment.getRequest().hasConfirmations()) {
                        for (CourseRequestInterface.CourseMessage m : this.iAssignment.getRequest().getConfirmations()) {
                            if ("NO_ALT".equals(m.getCode()) || "CREDIT".equals(m.getCode()) || !m.hasCourse() || !rc3.getCourseId().equals(m.getCourseId())) continue;
                            if (note == null) {
                                note = (String)(m.isError() ? "<span class='error'>" : "<span class='" + style + "'>") + m.getMessage() + "</span>";
                                continue;
                            }
                            note = (String)note + "\n" + (String)(m.isError() ? "<span class='error'>" : "<span class='" + style + "'>") + m.getMessage() + "</span>";
                        }
                    }
                    if (rc3.hasStatusNote()) {
                        note = (String)(note == null ? "" : note + "<br>") + "<span class='note'>" + rc3.getStatusNote() + "</span>";
                    }
                    for (ClassAssignmentInterface.CourseAssignment course : this.iAssignment.getCourseAssignments()) {
                        if (course.isAssigned() || !rc3.getCourseId().equals(course.getCourseId()) || !course.hasEnrollmentMessage() || this.iAssignment.getRequest().hasConfirmations(rc3.getCourseId(), "NO_ALT", "CREDIT")) continue;
                        note = (String)(note == null ? "" : note + "<br>") + "<span class='error'>" + course.getEnrollmentMessage() + "</span>";
                    }
                    HTML errorsLabel = new HTML((String)(note == null ? "" : note));
                    errorsLabel.addStyleName("waitlists-errors");
                    row.add(errorsLabel);
                    int idx = this.iWaitLists.addRow(rc3, row);
                    if (firstLine && idx > 1) {
                        for (int c = 0; c < this.iWaitLists.getCellCount(idx); ++c) {
                            this.iWaitLists.getCellFormatter().addStyleName(idx, c, "top-border-dashed");
                        }
                    }
                    firstLine = false;
                }
            }
            if (this.iAssignment.getRequest().hasMaxCreditOverride() && this.iAssignment.getRequest().getRequestId() != null) {
                P p = new P("icons");
                String style = "pending";
                if (this.iAssignment.getRequest().getMaxCreditOverrideStatus() != null) {
                    switch (this.iAssignment.getRequest().getMaxCreditOverrideStatus()) {
                        case OVERRIDE_APPROVED: {
                            p.add((Widget)new Icon(RESOURCES.specRegApproved(), MESSAGES.hintSpecRegApproved()));
                            style = "approved";
                            break;
                        }
                        case OVERRIDE_CANCELLED: {
                            p.add((Widget)new Icon(RESOURCES.specRegCancelled(), MESSAGES.hintSpecRegCancelled()));
                            style = "cancelled";
                            break;
                        }
                        case OVERRIDE_PENDING: {
                            p.add((Widget)new Icon(RESOURCES.specRegPending(), MESSAGES.hintSpecRegPending()));
                            style = "pending";
                            break;
                        }
                        case OVERRIDE_REJECTED: {
                            p.add((Widget)new Icon(RESOURCES.specRegRejected(), MESSAGES.hintSpecRegRejected()));
                            style = "rejected";
                            break;
                        }
                        case OVERRIDE_NEEDED: 
                        case NEW_REQUEST: {
                            p.add((Widget)new Icon(RESOURCES.requestNeeded(), MESSAGES.reqStatusNeeded()));
                            style = "needed";
                            break;
                        }
                        case SAVED: {
                            p.add((Widget)new Icon(RESOURCES.requestsWaitList(), MESSAGES.descriptionRequestWaitListed()));
                            style = "saved";
                        }
                    }
                } else {
                    p.add((Widget)new Icon(RESOURCES.requestsWaitList(), MESSAGES.descriptionRequestWaitListed()));
                    style = "saved";
                }
                ArrayList<Object> row = new ArrayList<Object>();
                row.add((Object)p);
                DateAndNoteCell dateAndNoteCell = new DateAndNoteCell(this.iAssignment.getRequest().getMaxCreditOverrideTimeStamp(), this.iAssignment.getRequest().getRequestorNote());
                row.add((Object)dateAndNoteCell);
                row.add(new Label(""));
                row.add(new Label(""));
                row.add(new Label(df.format((Number)this.iAssignment.getRequest().getMaxCreditOverride())));
                row.add(new Label(""));
                row.add(new Label(""));
                row.add(new Label(""));
                String note = null;
                note = this.iAssignment.getRequest().hasCreditWarning() ? "<span class='" + style + "'>" + this.iAssignment.getRequest().getCreditWarning() + "</span>" : "<span class='" + style + "'>" + MESSAGES.creditWarning(this.iAssignment.getRequest().getMaxCredit().floatValue()) + "</span>";
                if (this.iAssignment.getRequest().hasCreditNote()) {
                    note = note + "\n<span class='note'>" + this.iAssignment.getRequest().getCreditNote() + "</span>";
                }
                HTML errorsLabel = new HTML(note);
                errorsLabel.addStyleName("waitlists-errors");
                row.add(errorsLabel);
                int idx = this.iWaitLists.addRow(null, row);
                if (idx > 1) {
                    for (int c = 0; c < this.iWaitLists.getCellCount(idx); ++c) {
                        this.iWaitLists.getCellFormatter().addStyleName(idx, c, "top-border-dashed");
                    }
                }
            }
            this.iWaitLists.setColumnVisible(5, hasSwap);
            this.iWaitLists.setColumnVisible(6, hasPosition);
            this.iWaitLists.setColumnVisible(7, hasPrefs);
        }
        this.iTabs.getTabBar().setTabEnabled(5, this.iWaitLists.getRowCount() > 1);
        if (this.iTabs.getSelectedTab() != 5) {
            ((Widget)this.iTabs.getTabBar().getTab(5)).setVisible(this.iWaitLists.getRowCount() > 1);
        }
    }

    protected void fillInTimeGrid() {
        this.iGrid.clear(true);
        int index = 0;
        for (ClassAssignmentInterface.CourseAssignment course : this.iAssignment.getCourseAssignments()) {
            for (ClassAssignmentInterface.ClassAssignment clazz : course.getClassAssignments()) {
                if (clazz.isFreeTime()) {
                    CourseRequestInterface.FreeTime ft = new CourseRequestInterface.FreeTime();
                    ft.setLength(clazz.getLength());
                    ft.setStart(clazz.getStart());
                    for (int d : clazz.getDays()) {
                        ft.addDay(d);
                    }
                    this.iGrid.addFreeTime(ft);
                    continue;
                }
                if (!clazz.isAssigned()) continue;
                this.iGrid.addClass(clazz, index++);
            }
        }
        this.iGrid.shrink();
    }

    public float getTotalCredit() {
        return this.iTotalCredit;
    }

    public float[] getCreditRange() {
        return this.iAssignment == null || !this.iAssignment.hasRequest() ? null : this.iAssignment.getRequest().getCreditRange(this.iAssignment.getAdvisorWaitListedCourseIds());
    }

    public String getCreditMessage() {
        if (this.iTabs.getSelectedTab() == 0) {
            return "";
        }
        if (this.iTabs.getSelectedTab() == 1) {
            float[] range = this.getCreditRange();
            if (range != null && range[1] > 0.0f) {
                if (range[0] == range[1]) {
                    return MESSAGES.requestedCredit(range[0]);
                }
                return MESSAGES.requestedCreditRange(range[0], range[1]);
            }
            return "";
        }
        if (this.iTotalCredit > 0.0f) {
            return MESSAGES.totalCredit(this.iTotalCredit);
        }
        return "";
    }

    public String getErrorMessage() {
        return this.iAssignment.getRequest().getErrorMessaeg();
    }

    public boolean hasErrorMessage() {
        return this.iAssignment != null && this.iAssignment.hasRequest() && this.iAssignment.getRequest().hasErrorMessage();
    }

    public void checkAccessKeys(Event.NativePreviewEvent event) {
        if (event.getTypeInt() == 512 && (event.getNativeEvent().getAltKey() || event.getNativeEvent().getCtrlKey())) {
            for (Map.Entry<Character, Integer> entry : this.iTabAccessKeys.entrySet()) {
                if (event.getNativeEvent().getKeyCode() != Character.toLowerCase(entry.getKey().charValue()) && event.getNativeEvent().getKeyCode() != Character.toUpperCase(entry.getKey().charValue())) continue;
                if (entry.getValue() >= 4 && !((Widget)this.iTabs.getTabBar().getTab(entry.getValue().intValue())).isVisible()) {
                    return;
                }
                this.iTabs.selectTab(entry.getValue());
            }
        }
    }

    public void setSelectionHandler(SelectionHandler<Integer> handler) {
        this.iHandler = handler;
    }

    protected void setCritical(Long studentId, CourseRequestInterface.Request request, Integer critical, AsyncCallback<Integer> callback) {
        callback.onSuccess((Object)request.getCritical());
    }

    class CriticalCell
    extends WebTable.IconCell {
        private CourseRequestInterface.Request iRequest;

        CriticalCell(CourseRequestInterface.Request request) {
            super(request.isCritical() ? RESOURCES.requestsCritical() : (request.isImportant() ? RESOURCES.requestsImportant() : (request.isVital() ? RESOURCES.requestsVital() : (request.isLC() ? RESOURCES.requestsLC() : (request.isVisitingF2F() ? RESOURCES.requestsVisitingF2F() : RESOURCES.requestsNotCritical())))), null, request.isCritical() ? MESSAGES.opSetCritical() : (request.isImportant() ? MESSAGES.opSetImportant() : (request.isVital() ? MESSAGES.opSetVital() : (request.isLC() ? MESSAGES.opSetLC() : (request.isVisitingF2F() ? MESSAGES.opSetVisitingF2F() : MESSAGES.opSetNotCritical())))));
            this.getIcon().setAltText(request.isCritical() ? MESSAGES.descriptionRequestCritical() : (request.isImportant() ? MESSAGES.descriptionRequestImportant() : (request.isVital() ? MESSAGES.descriptionRequestVital() : (request.isLC() ? MESSAGES.descriptionRequestLC() : (request.isVisitingF2F() ? MESSAGES.descriptionRequestLC() : MESSAGES.descriptionRequestNotCritical())))));
            this.getIcon().setTitle(request.isCritical() ? MESSAGES.descriptionRequestCritical() : (request.isImportant() ? MESSAGES.descriptionRequestImportant() : (request.isVital() ? MESSAGES.descriptionRequestVital() : (request.isLC() ? MESSAGES.descriptionRequestLC() : (request.isVisitingF2F() ? MESSAGES.descriptionRequestLC() : MESSAGES.descriptionRequestNotCritical())))));
            this.iRequest = request;
            this.getIcon().getElement().getStyle().setCursor(Style.Cursor.POINTER);
            ClickHandler ch = new ClickHandler(){

                public void onClick(ClickEvent event) {
                    final PopupPanel popup = new PopupPanel(true);
                    popup.addStyleName("unitime-Menu");
                    UniTimeTableHeader.MenuBarWithAccessKeys menu = new UniTimeTableHeader.MenuBarWithAccessKeys();
                    MenuItem item1 = new MenuItem(MESSAGES.opSetCritical(), true, (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            popup.hide();
                            CriticalCell.this.change(1);
                        }
                    });
                    menu.addItem(item1);
                    MenuItem item1b = new MenuItem(MESSAGES.opSetVital(), true, (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            popup.hide();
                            CriticalCell.this.change(3);
                        }
                    });
                    menu.addItem(item1b);
                    MenuItem item2 = new MenuItem(MESSAGES.opSetImportant(), true, (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            popup.hide();
                            CriticalCell.this.change(2);
                        }
                    });
                    menu.addItem(item2);
                    MenuItem item3 = new MenuItem(MESSAGES.opSetNotCritical(), true, (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            popup.hide();
                            CriticalCell.this.change(0);
                        }
                    });
                    menu.addItem(item3);
                    MenuItem item4 = new MenuItem(MESSAGES.opSetCriticalNotSet(), true, (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            popup.hide();
                            CriticalCell.this.change(null);
                        }
                    });
                    menu.addItem(item4);
                    menu.setVisible(true);
                    popup.add((Widget)menu);
                    popup.showRelativeTo((UIObject)((Widget)event.getSource()));
                    ((MenuBar)popup.getWidget()).focus();
                }
            };
            this.getIcon().addClickHandler(ch);
            this.getLabel().addClickHandler(ch);
        }

        void change(Integer value) {
            StudentSchedule.this.setCritical(StudentSchedule.this.iAssignment.getRequest().getStudentId(), this.iRequest, value, new AsyncCallback<Integer>(){

                public void onFailure(Throwable caught) {
                    UniTimeNotifications.error(caught);
                }

                public void onSuccess(Integer result) {
                    if (result == null) {
                        return;
                    }
                    if (result == 1) {
                        CriticalCell.this.getIcon().setResource(RESOURCES.requestsCritical());
                        CriticalCell.this.getIcon().setTitle(MESSAGES.descriptionRequestCritical());
                        CriticalCell.this.getIcon().setAltText(MESSAGES.descriptionRequestCritical());
                        CriticalCell.this.getLabel().setText(MESSAGES.opSetCritical());
                    } else if (result == 2) {
                        CriticalCell.this.getIcon().setResource(RESOURCES.requestsImportant());
                        CriticalCell.this.getIcon().setTitle(MESSAGES.descriptionRequestImportant());
                        CriticalCell.this.getIcon().setAltText(MESSAGES.descriptionRequestImportant());
                        CriticalCell.this.getLabel().setText(MESSAGES.opSetImportant());
                    } else if (result == 3) {
                        CriticalCell.this.getIcon().setResource(RESOURCES.requestsVital());
                        CriticalCell.this.getIcon().setTitle(MESSAGES.descriptionRequestVital());
                        CriticalCell.this.getIcon().setAltText(MESSAGES.descriptionRequestVital());
                        CriticalCell.this.getLabel().setText(MESSAGES.opSetVital());
                    } else {
                        CriticalCell.this.getIcon().setResource(RESOURCES.requestsNotCritical());
                        CriticalCell.this.getIcon().setTitle(MESSAGES.descriptionRequestNotCritical());
                        CriticalCell.this.getIcon().setAltText(MESSAGES.descriptionRequestNotCritical());
                        CriticalCell.this.getLabel().setText(MESSAGES.opSetNotCritical());
                    }
                }
            });
        }
    }

    protected class Icon
    extends Image {
        public Icon(ImageResource image, final String text) {
            super(image);
            if (text != null && !text.isEmpty()) {
                this.setAltText(text);
                this.setTitle(text);
                this.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        event.preventDefault();
                        event.stopPropagation();
                        UniTimeConfirmationDialog.info(text);
                    }
                });
            }
        }
    }

    protected class CreditCell
    extends HTML {
        public CreditCell(String text) {
            if (text != null && text.indexOf(124) >= 0) {
                this.setHTML(text.substring(0, text.indexOf(124)));
                this.setTitle(text.substring(text.indexOf(124) + 1).replace("\n", "<br>"));
            } else {
                this.setHTML(text == null ? "" : text.replace("\n", "<br>"));
                if (text != null) {
                    this.setTitle(text);
                }
            }
        }
    }

    protected class DateAndNoteCell
    extends Label {
        public DateAndNoteCell(Date date, String note) {
            super((String)(date == null ? (note == null ? "" : note) : sModifiedDateFormat.format(date) + (String)(note == null || note.isEmpty() ? "" : "\n" + note)));
            this.addStyleName("date-and-note");
        }
    }

    protected class DescriptionCell
    extends Label
    implements UniTimeTable.HasColSpan {
        public DescriptionCell(String text) {
            super(text == null ? "" : text);
        }

        @Override
        public int getColSpan() {
            return 7;
        }
    }
}

