/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.rooms;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.page.UniTimePageLabel;
import org.unitime.timetable.gwt.client.rooms.RoomSharingWidget;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.RoomInterface;

public class RoomSharingPage
extends Composite {
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private SimpleForm iForm;
    private RoomSharingWidget iSharing;
    private UniTimeHeaderPanel iHeader;
    private UniTimeHeaderPanel iFooter;
    private Long iLocationId;
    private boolean iEventAvailability = "1".equals(Window.Location.getParameter((String)"events"));

    public RoomSharingPage() {
        if (this.iEventAvailability) {
            UniTimePageLabel.getInstance().setPageName(MESSAGES.pageEditRoomEventAvailability());
        }
        this.iForm = new SimpleForm();
        this.iHeader = new UniTimeHeaderPanel();
        this.iHeader.addButton("update", MESSAGES.buttonUpdate(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                RoomSharingPage.this.iHeader.showLoading();
                RPC.execute(RoomInterface.RoomSharingRequest.save(RoomSharingPage.this.iLocationId, RoomSharingPage.this.iSharing.getModel(), RoomSharingPage.this.iEventAvailability), new AsyncCallback<RoomInterface.RoomSharingModel>(){

                    public void onFailure(Throwable caught) {
                        RoomSharingPage.this.iHeader.setErrorMessage(MESSAGES.failedToSaveRoomAvailability(caught.getMessage()));
                    }

                    public void onSuccess(RoomInterface.RoomSharingModel result) {
                        ToolBox.open(GWT.getHostPageBaseURL() + "roomDetail.do?id=" + RoomSharingPage.this.iLocationId);
                    }
                });
            }
        });
        this.iHeader.addButton("back", MESSAGES.buttonBack(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                ToolBox.open(GWT.getHostPageBaseURL() + "roomDetail.do?id=" + RoomSharingPage.this.iLocationId);
            }
        });
        this.iHeader.setEnabled("update", false);
        this.iForm.addHeaderRow((Widget)this.iHeader);
        this.iSharing = new RoomSharingWidget(true);
        this.iSharing.setVisible(false);
        this.iForm.addRow((Widget)this.iSharing);
        this.iFooter = this.iHeader.clonePanel("");
        this.iForm.addBottomRow((Widget)this.iFooter);
        this.iFooter.setVisible(false);
        this.initWidget((Widget)this.iForm);
        try {
            this.iLocationId = Long.valueOf(Window.Location.getParameter((String)"id"));
            LoadingWidget.getInstance().show(MESSAGES.waitLoadingRoomAvailability());
            RPC.execute(RoomInterface.RoomSharingRequest.load(this.iLocationId, this.iEventAvailability), new AsyncCallback<RoomInterface.RoomSharingModel>(){

                public void onFailure(Throwable caught) {
                    LoadingWidget.getInstance().hide();
                    RoomSharingPage.this.iHeader.setErrorMessage(MESSAGES.failedToSaveRoomAvailability(caught.getMessage()));
                }

                public void onSuccess(RoomInterface.RoomSharingModel result) {
                    LoadingWidget.getInstance().hide();
                    RoomSharingPage.this.iSharing.setModel(result);
                    RoomSharingPage.this.iSharing.setVisible(true);
                    if (RoomSharingPage.this.iSharing.isEditable()) {
                        RoomSharingPage.this.iHeader.setEnabled("update", true);
                    }
                    RoomSharingPage.this.iFooter.setVisible(true);
                    RoomSharingPage.this.iHeader.setHeaderTitle(result.getName());
                }
            });
        }
        catch (Exception e) {
            this.iHeader.setErrorMessage(MESSAGES.failedToLoadRoomAvailability(e.getMessage()));
        }
    }
}

