/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.events;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.DistanceMetric;
import org.hibernate.Session;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.events.FilterBoxBackend;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentRoomFeature;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.GlobalRoomFeature;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomFeatureType;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomType;
import org.unitime.timetable.model.RoomTypeOption;
import org.unitime.timetable.model.TravelTime;
import org.unitime.timetable.model.base.BaseRefTableEntry;
import org.unitime.timetable.model.dao.RoomDAO;
import org.unitime.timetable.model.dao.RoomFeatureTypeDAO;
import org.unitime.timetable.model.dao.TimetableManagerDAO;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.rights.Right;

@GwtRpcImplements(value=EventInterface.RoomFilterRpcRequest.class)
public class RoomFilterBackend
extends FilterBoxBackend<EventInterface.RoomFilterRpcRequest> {
    private DistanceMetric iMetrics;
    private static double EPSILON = 1.0E-6;
    private static DecimalFormat sCDF = new DecimalFormat("0.000000");
    private static DecimalFormat sNF = new DecimalFormat("0000");
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    /*
     * WARNING - void declaration
     */
    @Override
    public void load(EventInterface.RoomFilterRpcRequest request, EventInterface.FilterRpcResponse response, EventAction.EventContext context) {
        Set<String> departments = request.getOptions("department");
        boolean fastCount = ApplicationProperty.RoomFilterFasterCounts.isTrue();
        if (fastCount) {
            boolean nearby;
            Set<String> building = request.getOptions("building");
            Set<String> flag = request.getOptions("flag");
            boolean bl = nearby = flag != null && (flag.contains("nearby") || flag.contains("Nearby"));
            if (nearby && building != null && !building.isEmpty()) {
                fastCount = false;
            }
        }
        this.fixRoomFeatureTypes(request);
        if (fastCount) {
            RoomQuery query = this.getQuery(request.getSessionId(), request.getOptions(), context);
            Session hibSession = RoomDAO.getInstance().getSession();
            TreeSet<EventInterface.FilterRpcResponse.Entity> types = new TreeSet<EventInterface.FilterRpcResponse.Entity>();
            for (Object o : query.select("l.roomType, count(distinct l)").group("l.roomType").exclude("type").query(hibSession).list()) {
                RoomType roomType = (RoomType)o[0];
                EventInterface.FilterRpcResponse.Entity entity = new EventInterface.FilterRpcResponse.Entity(roomType.getUniqueId(), roomType.getReference(), roomType.getLabel(), "order", sNF.format(roomType.getOrd()), "translated-value", roomType.getLabel());
                entity.setCount(((Number)o[1]).intValue());
                types.add(entity);
            }
            response.add("type", types);
            HashMap hashMap = new HashMap();
            for (Object[] objectArray : query.select("xf, count(distinct l)").from("inner join l.features xf").group("xf").query(hibSession).list()) {
                EventInterface.FilterRpcResponse.Entity feature;
                RoomFeature roomFeature = (RoomFeature)objectArray[0];
                if (!(roomFeature instanceof GlobalRoomFeature) && (!(roomFeature instanceof DepartmentRoomFeature) || departments == null || !departments.contains(((DepartmentRoomFeature)roomFeature).getDepartment().getDeptCode())) || !this.showRoomFeature(roomFeature.getFeatureType())) continue;
                String type = roomFeature.getFeatureType() == null ? "feature" : roomFeature.getFeatureType().getReference();
                HashMap<Long, EventInterface.FilterRpcResponse.Entity> features = (HashMap<Long, EventInterface.FilterRpcResponse.Entity>)hashMap.get(type);
                if (features == null) {
                    features = new HashMap<Long, EventInterface.FilterRpcResponse.Entity>();
                    hashMap.put(type, features);
                }
                if ((feature = (EventInterface.FilterRpcResponse.Entity)features.get(roomFeature.getUniqueId())) == null) {
                    feature = new EventInterface.FilterRpcResponse.Entity(roomFeature.getUniqueId(), roomFeature.getAbbv(), roomFeature.getLabel(), "translated-value", roomFeature.getLabel(), "hint", roomFeature.getDescription());
                    features.put(feature.getUniqueId(), feature);
                }
                feature.setCount(((Number)objectArray[1]).intValue());
            }
            for (String string : new TreeSet(hashMap.keySet())) {
                response.add(string.replace(' ', '_'), new TreeSet<EventInterface.FilterRpcResponse.Entity>(((Map)hashMap.get(string)).values()));
            }
            TreeSet<EventInterface.FilterRpcResponse.Entity> groups = new TreeSet<EventInterface.FilterRpcResponse.Entity>();
            for (Object[] objectArray : query.select("xg, count(distinct l)").from("inner join l.roomGroups xg").group("xg").exclude("group").query(hibSession).list()) {
                RoomGroup rg = (RoomGroup)objectArray[0];
                if (!rg.isGlobal().booleanValue() && (departments == null || !departments.contains(rg.getDepartment().getDeptCode()))) continue;
                EventInterface.FilterRpcResponse.Entity group = new EventInterface.FilterRpcResponse.Entity(rg.getUniqueId(), rg.getAbbv(), rg.getName(), "translated-value", rg.getName(), "hint", rg.getDescription());
                group.setCount(((Number)objectArray[1]).intValue());
                groups.add(group);
            }
            response.add("group", groups);
            TreeSet<EventInterface.FilterRpcResponse.Entity> treeSet = new TreeSet<EventInterface.FilterRpcResponse.Entity>();
            for (Object[] o : query.select("l.building, count(distinct l)").group("l.building").exclude("building").query(hibSession).list()) {
                Building b = (Building)o[0];
                EventInterface.FilterRpcResponse.Entity building = new EventInterface.FilterRpcResponse.Entity(b.getUniqueId(), b.getAbbreviation(), b.getAbbrName(), new String[0]);
                building.setCount(((Number)o[1]).intValue());
                treeSet.add(building);
            }
            response.add("building", treeSet);
            EventInterface.FilterRpcResponse.Entity entity = new EventInterface.FilterRpcResponse.Entity(0L, "Managed", MESSAGES.labelDepartmentManagedRooms(), "translated-value", MESSAGES.attrDepartmentManagedRooms());
            int isManaged = 0;
            boolean eventRooms = request.hasOptions("flag") && (request.getOptions("flag").contains("event") || request.getOptions("flag").contains("Event"));
            boolean allRooms = request.hasOptions("flag") && (request.getOptions("flag").contains("all") || request.getOptions("flag").contains("All"));
            boolean deptIndep = context.hasPermission(Right.DepartmentIndependent);
            HashSet userDepts = null;
            if (request.hasOption("user")) {
                userDepts = new HashSet(TimetableManagerDAO.getInstance().getSession().createQuery("select d.uniqueId from TimetableManager m inner join m.departments d where m.externalUniqueId = :user and d.session.uniqueId = :sessionId", Long.class).setParameter("sessionId", (Object)request.getSessionId()).setParameter("user", (Object)request.getOption("user")).setCacheable(true).list());
            }
            UserAuthority autority = context.getUser() == null ? null : context.getUser().getCurrentAuthority();
            TreeSet<EventInterface.FilterRpcResponse.Entity> exams = new TreeSet<EventInterface.FilterRpcResponse.Entity>();
            TreeSet<EventInterface.FilterRpcResponse.Entity> depts = new TreeSet<EventInterface.FilterRpcResponse.Entity>();
            if (eventRooms) {
                for (Object[] o : query.select("l.eventDepartment, count(distinct l)").group("l.eventDepartment").exclude("department").query(hibSession).list()) {
                    Department d = (Department)o[0];
                    EventInterface.FilterRpcResponse.Entity department = new EventInterface.FilterRpcResponse.Entity(d.getUniqueId(), d.getDeptCode(), d.getDeptCode() + " - " + d.getName(), new String[0]);
                    department.setCount(((Number)o[1]).intValue());
                    depts.add(department);
                    if (!deptIndep && (userDepts == null || !userDepts.contains(d.getUniqueId()))) continue;
                    ++isManaged;
                    entity.setCount(entity.getCount() + ((Number)o[1]).intValue());
                }
            } else {
                for (Object[] o : query.select("xd.department, count(distinct l)").from("inner join l.roomDepts xd").group("xd.department").exclude("department").query(hibSession).list()) {
                    Department d = (Department)o[0];
                    if (!(deptIndep || allRooms || userDepts != null && userDepts.contains(d.getUniqueId()) || autority != null && autority.hasQualifier(d))) continue;
                    EventInterface.FilterRpcResponse.Entity department = new EventInterface.FilterRpcResponse.Entity(d.getUniqueId(), d.getDeptCode(), d.getDeptCode() + " - " + d.getName(), new String[0]);
                    department.setCount(((Number)o[1]).intValue());
                    depts.add(department);
                    if (!deptIndep && (userDepts == null || !userDepts.contains(d.getUniqueId()))) continue;
                    if (++isManaged == 1) {
                        entity.setCount(((Number)o[1]).intValue());
                        continue;
                    }
                    entity.setCount(0);
                }
                if (context.hasPermission(request.getSessionId(), Right.Examinations) || context.hasPermission(request.getSessionId(), Right.ExaminationSchedule)) {
                    for (Object[] o : query.select("xt, count(distinct l)").from("inner join l.examTypes xt").group("xt").exclude("department").query(hibSession).list()) {
                        ExamType type = (ExamType)o[0];
                        EventInterface.FilterRpcResponse.Entity e = new EventInterface.FilterRpcResponse.Entity(-type.getUniqueId().longValue(), type.getReference(), MESSAGES.examinationRooms(type.getLabel()), new String[0]);
                        e.setCount(((Number)o[1]).intValue());
                        exams.add(e);
                    }
                }
            }
            if (isManaged > 0) {
                response.add("department", entity);
            }
            response.add("department", exams);
            response.add("department", depts);
        } else {
            void var12_45;
            HashSet userDepts = null;
            if (request.hasOption("user")) {
                userDepts = new HashSet(TimetableManagerDAO.getInstance().getSession().createQuery("select d.uniqueId from TimetableManager m inner join m.departments d where m.externalUniqueId = :user and d.session.uniqueId = :sessionId", Long.class).setParameter("sessionId", (Object)request.getSessionId()).setParameter("user", (Object)request.getOption("user")).setCacheable(true).list());
            }
            HashMap<Long, Iterator<Location>> types = new HashMap<Long, Iterator<Location>>();
            for (Location location : this.locations(request.getSessionId(), request.getOptions(), null, -1, null, "type", context)) {
                Object type = (EventInterface.FilterRpcResponse.Entity)types.get(location.getRoomType().getUniqueId());
                if (type == null) {
                    type = new EventInterface.FilterRpcResponse.Entity(location.getRoomType().getUniqueId(), location.getRoomType().getReference(), location.getRoomType().getLabel(), "order", sNF.format(location.getRoomType().getOrd()), "translated-value", location.getRoomType().getLabel());
                    types.put(((EventInterface.FilterRpcResponse.Entity)type).getUniqueId(), (Iterator<Location>)type);
                }
                ((EventInterface.FilterRpcResponse.Entity)type).incCount();
            }
            response.add("type", new TreeSet<EventInterface.FilterRpcResponse.Entity>(types.values()));
            HashMap featuresByType = new HashMap();
            for (Location location : this.locations(request.getSessionId(), request.getOptions(), null, -1, null, null, context)) {
                for (RoomFeature roomFeature : location.getFeatures()) {
                    EventInterface.FilterRpcResponse.Entity feature;
                    if (!(roomFeature instanceof GlobalRoomFeature) && (!(roomFeature instanceof DepartmentRoomFeature) || departments == null || !departments.contains(((DepartmentRoomFeature)roomFeature).getDepartment().getDeptCode())) || !this.showRoomFeature(roomFeature.getFeatureType())) continue;
                    String type = roomFeature.getFeatureType() == null ? "feature" : roomFeature.getFeatureType().getReference();
                    HashMap<Long, EventInterface.FilterRpcResponse.Entity> features = (HashMap<Long, EventInterface.FilterRpcResponse.Entity>)featuresByType.get(type);
                    if (features == null) {
                        features = new HashMap<Long, EventInterface.FilterRpcResponse.Entity>();
                        featuresByType.put(type, features);
                    }
                    if ((feature = (EventInterface.FilterRpcResponse.Entity)features.get(roomFeature.getUniqueId())) == null) {
                        feature = new EventInterface.FilterRpcResponse.Entity(roomFeature.getUniqueId(), roomFeature.getAbbv(), roomFeature.getLabel(), "translated-value", roomFeature.getLabel(), "hint", roomFeature.getDescription());
                        features.put(feature.getUniqueId(), feature);
                    }
                    feature.incCount();
                }
            }
            for (Object type : new TreeSet(featuresByType.keySet())) {
                response.add(((String)type).replace(' ', '_'), new TreeSet<EventInterface.FilterRpcResponse.Entity>(((Map)featuresByType.get(type)).values()));
            }
            HashMap<Long, EventInterface.FilterRpcResponse.Entity> hashMap = new HashMap<Long, EventInterface.FilterRpcResponse.Entity>();
            for (Location location : this.locations(request.getSessionId(), request.getOptions(), null, -1, null, "group", context)) {
                for (RoomGroup rg : location.getRoomGroups()) {
                    if (!rg.isGlobal().booleanValue() && (departments == null || !departments.contains(rg.getDepartment().getDeptCode()))) continue;
                    EventInterface.FilterRpcResponse.Entity group = (EventInterface.FilterRpcResponse.Entity)hashMap.get(rg.getUniqueId());
                    if (group == null) {
                        group = new EventInterface.FilterRpcResponse.Entity(rg.getUniqueId(), rg.getAbbv(), rg.getName(), "translated-value", rg.getName(), "hint", rg.getDescription());
                        hashMap.put(group.getUniqueId(), group);
                    }
                    group.incCount();
                }
            }
            response.add("group", new TreeSet<EventInterface.FilterRpcResponse.Entity>(hashMap.values()));
            HashMap<Long, EventInterface.FilterRpcResponse.Entity> buildings = new HashMap<Long, EventInterface.FilterRpcResponse.Entity>();
            for (Location location : this.locations(request.getSessionId(), request.getOptions(), null, -1, null, "building", context)) {
                if (!(location instanceof Room)) continue;
                Room room = (Room)location;
                EventInterface.FilterRpcResponse.Entity building = (EventInterface.FilterRpcResponse.Entity)buildings.get(room.getBuilding().getUniqueId());
                if (building == null) {
                    building = new EventInterface.FilterRpcResponse.Entity(room.getBuilding().getUniqueId(), room.getBuilding().getAbbreviation(), room.getBuilding().getAbbrName(), new String[0]);
                    buildings.put(building.getUniqueId(), building);
                }
                building.incCount();
            }
            response.add("building", new TreeSet<EventInterface.FilterRpcResponse.Entity>(buildings.values()));
            EventInterface.FilterRpcResponse.Entity entity = new EventInterface.FilterRpcResponse.Entity(0L, "Managed", MESSAGES.labelDepartmentManagedRooms(), "translated-value", MESSAGES.attrDepartmentManagedRooms());
            Object var12_43 = null;
            if (context.hasPermission(request.getSessionId(), Right.Examinations) || context.hasPermission(request.getSessionId(), Right.ExaminationSchedule)) {
                HashMap<Long, EventInterface.FilterRpcResponse.Entity> hashMap2 = new HashMap<Long, EventInterface.FilterRpcResponse.Entity>();
                for (ExamType type : ExamType.findAllApplicable(context.getUser(), DepartmentStatusType.Status.ExamView, DepartmentStatusType.Status.ExamTimetable)) {
                    EventInterface.FilterRpcResponse.Entity e = new EventInterface.FilterRpcResponse.Entity(-type.getUniqueId().longValue(), type.getReference(), MESSAGES.examinationRooms(type.getLabel()), new String[0]);
                    hashMap2.put(type.getUniqueId(), e);
                }
            }
            HashMap<Long, Object> depts = new HashMap<Long, Object>();
            boolean eventRooms = request.hasOptions("flag") && (request.getOptions("flag").contains("event") || request.getOptions("flag").contains("Event"));
            boolean allRooms = request.hasOptions("flag") && (request.getOptions("flag").contains("all") || request.getOptions("flag").contains("All"));
            boolean deptIndep = context.hasPermission(Right.DepartmentIndependent);
            UserAuthority autority = context.getUser() == null ? null : context.getUser().getCurrentAuthority();
            for (Location location : this.locations(request.getSessionId(), request.getOptions(), null, -1, null, "department", context)) {
                Object department;
                Department evtDept = location.getEventDepartment() != null && location.getEventDepartment().isAllowEvents() != false ? location.getEventDepartment() : null;
                boolean isManaged = false;
                if (eventRooms) {
                    department = (EventInterface.FilterRpcResponse.Entity)depts.get(location.getEventDepartment().getUniqueId());
                    if (department == null) {
                        department = new EventInterface.FilterRpcResponse.Entity(location.getEventDepartment().getUniqueId(), location.getEventDepartment().getDeptCode(), location.getEventDepartment().getDeptCode() + " - " + location.getEventDepartment().getName(), new String[0]);
                        depts.put(((EventInterface.FilterRpcResponse.Entity)department).getUniqueId(), department);
                    }
                    ((EventInterface.FilterRpcResponse.Entity)department).incCount();
                    if (deptIndep || userDepts != null && userDepts.contains(location.getEventDepartment().getUniqueId())) {
                        isManaged = true;
                    }
                } else {
                    for (RoomDept rd : location.getRoomDepts()) {
                        EventInterface.FilterRpcResponse.Entity department2;
                        if (!deptIndep && !allRooms && (userDepts == null || !userDepts.contains(rd.getDepartment().getUniqueId())) && (autority == null || !autority.hasQualifier(rd.getDepartment()))) continue;
                        if (evtDept != null && rd.getDepartment().equals(evtDept)) {
                            evtDept = null;
                        }
                        if ((department2 = (EventInterface.FilterRpcResponse.Entity)depts.get(rd.getDepartment().getUniqueId())) == null) {
                            department2 = new EventInterface.FilterRpcResponse.Entity(rd.getDepartment().getUniqueId(), rd.getDepartment().getDeptCode(), rd.getDepartment().getDeptCode() + " - " + rd.getDepartment().getName() + (String)(rd.getDepartment().isExternalManager() != false ? " (" + rd.getDepartment().getExternalMgrLabel() + ")" : ""), new String[0]);
                            depts.put(department2.getUniqueId(), department2);
                        }
                        department2.incCount();
                        if (!deptIndep && (userDepts == null || !userDepts.contains(rd.getDepartment().getUniqueId()))) continue;
                        isManaged = true;
                    }
                    if (evtDept != null && allRooms) {
                        department = (EventInterface.FilterRpcResponse.Entity)depts.get(evtDept.getUniqueId());
                        if (department == null) {
                            department = new EventInterface.FilterRpcResponse.Entity(evtDept.getUniqueId(), evtDept.getDeptCode(), evtDept.getDeptCode() + " - " + evtDept.getName() + (String)(evtDept.isExternalManager() != false ? " (" + evtDept.getExternalMgrLabel() + ")" : ""), new String[0]);
                            depts.put(((EventInterface.FilterRpcResponse.Entity)department).getUniqueId(), department);
                        }
                        if (deptIndep || userDepts != null && userDepts.contains(evtDept.getUniqueId())) {
                            isManaged = true;
                        }
                        ((EventInterface.FilterRpcResponse.Entity)department).incCount();
                    }
                }
                if (var12_45 != null && !var12_45.isEmpty()) {
                    for (ExamType type : location.getExamTypes()) {
                        EventInterface.FilterRpcResponse.Entity e = (EventInterface.FilterRpcResponse.Entity)var12_45.get(type.getUniqueId());
                        if (e == null) continue;
                        e.incCount();
                    }
                }
                if (!isManaged) continue;
                entity.incCount();
            }
            if (entity.getCount() > 0) {
                response.add("department", entity);
            }
            if (var12_45 != null && !var12_45.isEmpty()) {
                for (EventInterface.FilterRpcResponse.Entity e : new TreeSet(var12_45.values())) {
                    if (e.getCount() <= 0) continue;
                    response.add("department", e);
                }
            }
            response.add("department", new TreeSet<EventInterface.FilterRpcResponse.Entity>(depts.values()));
        }
    }

    protected void fixRoomFeatureTypes(EventInterface.RoomFilterRpcRequest request) {
        for (RoomFeatureType type : RoomFeatureTypeDAO.getInstance().findAll()) {
            if (!this.showRoomFeature(type) || !request.hasOptions(type.getReference().replace(' ', '_'))) continue;
            for (String option : request.getOptions(type.getReference().replace(' ', '_'))) {
                request.addOption("feature", option);
            }
        }
    }

    public List<Location> locations(Long sessionId, EventInterface.RoomFilterRpcRequest filter, int limit, Map<Long, Double> room2distance, EventAction.EventContext context) {
        this.fixRoomFeatureTypes(filter);
        return this.locations(sessionId, filter.getOptions(), new Query(filter.getText()), limit, room2distance, null, context);
    }

    protected List<Location> locations(Long sessionId, Map<String, Set<String>> options, Query query, int limit, Map<Long, Double> room2distance, String ignoreCommand, EventAction.EventContext context) {
        Hashtable<Long, Double> distances;
        Session hibSession = RoomDAO.getInstance().getSession();
        RoomQuery rq = this.getQuery(sessionId, options, context);
        org.hibernate.query.Query q = rq.select().exclude(ignoreCommand).query(hibSession);
        List locations = q.setCacheable(true).list();
        Set<String> building = options == null || "building".equals(ignoreCommand) ? null : options.get("building");
        Set<String> size = options == null || "size".equals(ignoreCommand) ? null : options.get("size");
        Set<String> flag = options == null || "flag".equals(ignoreCommand) ? null : options.get("flag");
        boolean nearby = flag != null && (flag.contains("nearby") || flag.contains("Nearby"));
        HashSet<String> featureTypes = new HashSet<String>();
        for (Object ft : RoomFeatureTypeDAO.getInstance().findAll()) {
            if (!this.showRoomFeature((RoomFeatureType)ft)) continue;
            featureTypes.add(((BaseRefTableEntry)ft).getReference().toLowerCase().replace(' ', '_'));
        }
        ArrayList<Location> ret = new ArrayList<Location>();
        for (Location location : locations) {
            if (query != null && !query.match(new LocationMatcher(location, featureTypes)) || nearby && building != null && !building.isEmpty() && (!(location instanceof Room) || !building.contains(((Room)location).getBuilding().getAbbreviation()))) continue;
            ret.add(location);
        }
        Hashtable<Long, Double> hashtable = distances = room2distance == null ? new Hashtable<Long, Double>() : room2distance;
        if (nearby && building != null && !building.isEmpty() && (limit <= 0 || ret.size() < limit)) {
            double allowedDistance = ApplicationProperty.EventNearByDistance.doubleValue();
            HashSet<Coordinates> coord = new HashSet<Coordinates>();
            for (Location location : ret) {
                coord.add(new Coordinates(location));
            }
            if (coord.isEmpty()) {
                for (Building b : hibSession.createQuery("select b from Building b where b.session.uniqueId = :sessionId and b.abbreviation in :building", Building.class).setParameter("sessionId", (Object)sessionId).setParameterList("building", building, String.class).list()) {
                    coord.add(new Coordinates(-b.getUniqueId().longValue(), b.getCoordinateX(), b.getCoordinateY()));
                }
            }
            if (!coord.isEmpty()) {
                for (Location location : locations) {
                    if (building != null && !building.isEmpty() && location instanceof Room && building.contains(((Room)location).getBuilding().getAbbreviation()) || query != null && !query.match(new LocationMatcher(location, featureTypes))) continue;
                    Coordinates c = new Coordinates(location);
                    Double distance = null;
                    for (Coordinates x : coord) {
                        double d = c.distance(x);
                        if (distance != null && !(distance > d)) continue;
                        distance = d;
                    }
                    if (distance == null || !(distance <= allowedDistance)) continue;
                    ret.add(location);
                    if (distances == null) continue;
                    distances.put(location.getUniqueId(), distance);
                }
            }
        }
        final boolean sortBySize = size != null && !size.isEmpty();
        Collections.sort(ret, new Comparator<Location>(){

            @Override
            public int compare(Location l1, Location l2) {
                int cmp;
                Double d1 = (Double)distances.get(l1.getUniqueId());
                Double d2 = (Double)distances.get(l2.getUniqueId());
                if (d1 == null && d2 != null) {
                    return -1;
                }
                if (d1 != null && d2 == null) {
                    return 1;
                }
                if (d1 != null && (cmp = Long.valueOf(Math.round(d1)).compareTo(Math.round(d2))) != 0) {
                    return cmp;
                }
                if (sortBySize && (cmp = Integer.valueOf(l1.getCapacity() != null ? l1.getCapacity() : Integer.MAX_VALUE).compareTo(l2.getCapacity() != null ? l2.getCapacity() : Integer.MAX_VALUE)) != 0) {
                    return cmp;
                }
                return l1.getLabel().compareTo(l2.getLabel());
            }
        });
        return limit <= 0 || ret.size() < limit ? ret : ret.subList(0, limit);
    }

    private String suggestionQuery(String query) {
        if (query == null || query.isEmpty()) {
            return query;
        }
        if (!query.contains(":") && !query.contains("\"")) {
            return "starts:\"" + query + "\"";
        }
        return query;
    }

    @Override
    public void suggestions(EventInterface.RoomFilterRpcRequest request, EventInterface.FilterRpcResponse response, EventAction.EventContext context) {
        this.fixRoomFeatureTypes(request);
        HashMap<Long, Double> distances = new HashMap<Long, Double>();
        for (Location location : this.locations(request.getSessionId(), request.getOptions(), new Query(this.suggestionQuery(request.getText())), 20, distances, null, context)) {
            String hint = location.getRoomTypeLabel() + (String)(location.getCapacity() == null ? "" : ", " + MESSAGES.hintRoomCapacity(location.getCapacity().toString()));
            Double dist = (Double)distances.get(location.getUniqueId());
            if (dist != null) {
                hint = hint + ", " + MESSAGES.hintRoomDistance(String.valueOf(Math.round(dist)));
            }
            response.addSuggestion(location.getLabelWithDisplayName(), location.getLabel(), "(" + hint + ")");
        }
    }

    @Override
    public void enumarate(EventInterface.RoomFilterRpcRequest request, EventInterface.FilterRpcResponse response, EventAction.EventContext context) {
        this.fixRoomFeatureTypes(request);
        String showRoomNote = ApplicationProperty.EventGridShowRoomNote.value();
        boolean showRoomNoteWhenAvailable = "available".equals(showRoomNote) && (context.hasPermission(Right.EventAddSpecial) || context.hasPermission(Right.EventAddCourseRelated));
        boolean showRoomNoteAlways = "always".equals(showRoomNote);
        HashMap<Long, Double> distances = new HashMap<Long, Double>();
        for (Location location : this.locations(request.getSessionId(), request.getOptions(), new Query(request.getText()), -1, distances, null, context)) {
            Double dist = (Double)distances.get(location.getUniqueId());
            response.addResult(new EventInterface.FilterRpcResponse.Entity(location.getUniqueId(), location.getDisplayName(), location.getLabel(), "permId", location.getPermanentId().toString(), "type", location.getRoomType().getLabel(), "capacity", location.getCapacity().toString(), "distance", String.valueOf(dist == null ? 0L : Math.round(dist)), "overbook", context.hasPermission(location, Right.EventLocationOverbook) ? "1" : "0", "breakTime", String.valueOf(location.getEffectiveBreakTime()), "message", location.getEventMessage(), "ignoreRoomCheck", location.isIgnoreRoomCheck() != false ? "1" : "0", "display", location.getDisplayName(), "gridNote", location.getEventMessage() != null && !location.getEventMessage().isEmpty() && (showRoomNoteAlways || showRoomNoteWhenAvailable && context.hasPermission(location, Right.EventLocation)) ? "1" : "0", "parentId", location.getPartitionParentId() == null ? null : location.getPartitionParentId().toString(), "email", location.effectiveEventEmail()));
        }
    }

    public DistanceMetric getDistanceMetric() {
        if (this.iMetrics == null) {
            DataProperties config = new DataProperties();
            config.setProperty("Distances.Ellipsoid", ApplicationProperty.DistanceEllipsoid.value());
            config.setProperty("Distances.Speed", ApplicationProperty.EventDistanceSpeed.value());
            this.iMetrics = new DistanceMetric(new DataProperties((Properties)config));
            TravelTime.populateTravelTimes(this.iMetrics);
        }
        return this.iMetrics;
    }

    public static String toCommand(String label) {
        Object ret = "";
        for (String word : label.toLowerCase().split(" ")) {
            ret = ((String)ret).isEmpty() || word.length() <= 1 ? (String)ret + word : (String)ret + word.substring(0, 1).toUpperCase() + word.substring(1);
        }
        return ret;
    }

    protected boolean checkEventStatus() {
        return true;
    }

    protected boolean showRoomFeature(RoomFeatureType type) {
        return type == null || type.isShowInEventManagement() != false;
    }

    public RoomQuery getQuery(Long sessionId, Map<String, Set<String>> options, EventAction.EventContext context) {
        Set<String> ids;
        boolean allRooms;
        Set<String> buildings;
        Set<String> size;
        Set<String> groups;
        int id;
        Set<String> features;
        Set<String> types;
        RoomQuery query = new RoomQuery(sessionId);
        Set<String> set = types = options == null ? null : options.get("type");
        if (types != null && !types.isEmpty()) {
            Object type = "";
            int id2 = 0;
            for (String s : types) {
                type = (String)type + (((String)type).isEmpty() ? "" : ",") + ":Xt" + id2;
                query.addParameter("type", "Xt" + id2, s);
                ++id2;
            }
            query.addWhere("type", "l.roomType.label in (" + (String)type + ") or l.roomType.reference in (" + (String)type + ")");
        }
        Set<String> departments = options == null ? null : options.get("department");
        String department = departments == null || departments.isEmpty() ? null : departments.iterator().next();
        Set<String> set2 = features = options == null ? null : options.get("feature");
        if (features != null && !features.isEmpty()) {
            Object from = "";
            Object where = "";
            id = 0;
            for (String s : features) {
                if (department == null) {
                    from = (String)from + (((String)from).isEmpty() ? "" : " ") + "inner join l.features f" + id;
                    where = (String)where + (((String)where).isEmpty() ? "" : " and ") + " (f" + id + ".label = :Xf" + id + " or f" + id + ".abbv = :Xf" + id + ") and type(f" + id + ") = GlobalRoomFeature";
                } else {
                    from = (String)from + (((String)from).isEmpty() ? "" : " ") + "inner join l.features f" + id + " left outer join f" + id + ".department fd" + id;
                    where = (String)where + (((String)where).isEmpty() ? "" : " and ") + " (f" + id + ".label = :Xf" + id + " or f" + id + ".abbv = :Xf" + id + ") and (type(f" + id + ") = GlobalRoomFeature or fd" + id + ".deptCode = :Xfd)";
                }
                query.addParameter("feature", "Xf" + id, s);
                ++id;
            }
            if (department != null) {
                query.addParameter("feature", "Xfd", department);
            }
            query.addFrom("feature", (String)from);
            query.addWhere("feature", (String)where);
        }
        Set<String> set3 = groups = options == null ? null : options.get("group");
        if (groups != null && !groups.isEmpty()) {
            Object group = "";
            id = 0;
            for (String s : groups) {
                group = (String)group + (((String)group).isEmpty() ? "" : ", ") + ":Xg" + id;
                query.addParameter("group", "Xg" + id, s);
                ++id;
            }
            query.addFrom("group", "inner join l.roomGroups g left outer join g.department gd");
            if (department == null) {
                query.addWhere("group", "(g.name in (" + (String)group + ") or g.abbv in (" + (String)group + ")) and g.global = true");
            } else {
                query.addWhere("group", "(g.name in (" + (String)group + ") or g.abbv in (" + (String)group + ")) and (g.global = true or gd.deptCode = :Xgd)");
                query.addParameter("group", "Xgd", department);
            }
        }
        Set<String> set4 = size = options == null ? null : options.get("size");
        if (size != null && !size.isEmpty()) {
            String term = size.iterator().next();
            int min = 0;
            int max = Integer.MAX_VALUE;
            Size prefix = Size.eq;
            String number = term;
            if (number.startsWith("<=")) {
                prefix = Size.le;
                number = number.substring(2);
            } else if (number.startsWith(">=")) {
                prefix = Size.ge;
                number = number.substring(2);
            } else if (number.startsWith("<")) {
                prefix = Size.lt;
                number = number.substring(1);
            } else if (number.startsWith(">")) {
                prefix = Size.gt;
                number = number.substring(1);
            } else if (number.startsWith("=")) {
                prefix = Size.eq;
                number = number.substring(1);
            }
            try {
                int a = Integer.parseInt(number);
                switch (prefix) {
                    case eq: {
                        min = max = a;
                        break;
                    }
                    case le: {
                        max = a;
                        break;
                    }
                    case ge: {
                        min = a;
                        break;
                    }
                    case lt: {
                        max = a - 1;
                        break;
                    }
                    case gt: {
                        min = a + 1;
                    }
                }
            }
            catch (NumberFormatException a) {
                // empty catch block
            }
            if (term.contains("..")) {
                try {
                    String a = term.substring(0, term.indexOf(46));
                    String b = term.substring(term.indexOf("..") + 2);
                    min = Integer.parseInt(a);
                    max = Integer.parseInt(b);
                }
                catch (NumberFormatException a) {
                    // empty catch block
                }
            }
            if (min > 0) {
                if (max < Integer.MAX_VALUE) {
                    query.addWhere("size", "l.capacity >= :Xmin and l.capacity <= :Xmax");
                    query.addParameter("size", "Xmin", min);
                    query.addParameter("size", "Xmax", max);
                } else {
                    query.addWhere("size", "l.capacity >= :Xmin");
                    query.addParameter("size", "Xmin", min);
                }
            } else if (max < Integer.MAX_VALUE) {
                query.addWhere("size", "l.capacity <= :Xmax");
                query.addParameter("size", "Xmax", max);
            }
        }
        Set<String> flags = options == null ? null : options.get("flag");
        boolean nearby = flags != null && (flags.contains("nearby") || flags.contains("Nearby"));
        Set<String> set5 = buildings = options == null ? null : options.get("building");
        if (buildings != null && !buildings.isEmpty() && !nearby) {
            Object building = "";
            int id3 = 0;
            for (String s : buildings) {
                building = (String)building + (((String)building).isEmpty() ? "" : ", ") + ":Xb" + id3;
                query.addParameter("building", "Xb" + id3, s);
                ++id3;
            }
            query.addWhere("building", "l.building.abbreviation in (" + (String)building + ")");
        }
        boolean eventRooms = flags != null && (flags.contains("event") || flags.contains("Event"));
        boolean bl = allRooms = flags != null && (flags.contains("all") || flags.contains("All"));
        if (department != null) {
            String user;
            Set<String> users = options == null ? null : options.get("user");
            String string = user = users == null || users.isEmpty() ? null : users.iterator().next();
            if ("Managed".equalsIgnoreCase(department) && user != null) {
                if (context.hasPermission(Right.DepartmentIndependent)) {
                    if (eventRooms) {
                        query.addWhere("department", "l.eventDepartment is not null");
                    } else if (!allRooms) {
                        query.addFrom("department", "inner join l.roomDepts rd");
                    }
                } else {
                    if (eventRooms) {
                        query.addFrom("department", "inner join l.eventDepartment.timetableManagers m");
                        query.addWhere("department", "m.externalUniqueId = :Xu");
                    } else if (allRooms) {
                        query.addFrom("department", "left outer join l.eventDepartment.timetableManagers m1 left outer join l.roomDepts rd left outer join rd.department.timetableManagers m2");
                        query.addWhere("department", "m1.externalUniqueId = :Xu or m2.externalUniqueId = :Xu");
                    } else {
                        query.addFrom("department", "inner join l.roomDepts rd inner join rd.department.timetableManagers m");
                        query.addWhere("department", "m.externalUniqueId = :Xu");
                    }
                    query.addParameter("department", "Xu", user);
                }
            } else {
                if (eventRooms) {
                    query.addFrom("department", "left outer join l.examTypes x");
                    query.addWhere("department", "l.eventDepartment.deptCode = :Xd or x.reference = :Xd");
                } else if (allRooms) {
                    query.addFrom("department", "left outer join l.examTypes x left outer join l.roomDepts rd left outer join rd.department rdd left outer join l.eventDepartment ed");
                    query.addWhere("department", "rdd.deptCode = :Xd or ed.deptCode = :Xd or x.reference = :Xd");
                } else {
                    query.addFrom("department", "left outer join l.examTypes x left outer join l.roomDepts rd left outer join rd.department rdd");
                    query.addWhere("department", "rdd.deptCode = :Xd or x.reference = :Xd");
                }
                query.addParameter("department", "Xd", department);
            }
        }
        if (eventRooms) {
            if (this.checkEventStatus()) {
                query.addFrom("flag", "RoomTypeOption o");
                query.addWhere("flag", "l.eventDepartment.allowEvents = true and ((l.eventStatus is null and o.status != 0 and o.roomType = l.roomType and o.department = l.eventDepartment) or l.eventStatus != 0)");
            } else {
                query.addWhere("flag", "l.eventDepartment is not null");
            }
        }
        Set<String> set6 = ids = options == null ? null : options.get("id");
        if (ids != null && !ids.isEmpty()) {
            Object list = "";
            int id4 = 0;
            for (String s : ids) {
                list = (String)list + (((String)list).isEmpty() ? "" : ", ") + ":Xi" + id4;
                query.addParameter("id", "Xi" + id4, Long.valueOf(s));
                ++id4;
            }
            query.addWhere("id", "l.uniqueId in (" + (String)list + ")");
        }
        return query;
    }

    public static class RoomQuery {
        private Long iSessionId;
        private Map<String, String> iFrom = new HashMap<String, String>();
        private Map<String, String> iWhere = new HashMap<String, String>();
        private Map<String, Map<String, Object>> iParams = new HashMap<String, Map<String, Object>>();

        public RoomQuery(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public void addFrom(String option, String from) {
            this.iFrom.put(option, from);
        }

        public void addWhere(String option, String where) {
            this.iWhere.put(option, where);
        }

        protected void addParameter(String option, String name, Object value) {
            Map<String, Object> params = this.iParams.get(option);
            if (params == null) {
                params = new HashMap<String, Object>();
                this.iParams.put(option, params);
            }
            params.put(name, value);
        }

        public String getFrom(Collection<String> excludeOption) {
            Object from = "";
            for (Map.Entry<String, String> entry : this.iFrom.entrySet()) {
                if (excludeOption != null && excludeOption.contains(entry.getKey())) continue;
                from = (String)from + (entry.getValue().startsWith("inner join") || entry.getValue().startsWith("left outer join") || entry.getValue().startsWith("left join fetch") ? " " : ", ") + entry.getValue();
            }
            return from;
        }

        public String getWhere(Collection<String> excludeOption) {
            Object where = "";
            for (Map.Entry<String, String> entry : this.iWhere.entrySet()) {
                if (excludeOption != null && excludeOption.contains(entry.getKey())) continue;
                where = (String)where + " and (" + entry.getValue() + ")";
            }
            return where;
        }

        public org.hibernate.query.Query setParams(org.hibernate.query.Query query, Collection<String> excludeOption) {
            for (Map.Entry<String, Map<String, Object>> entry : this.iParams.entrySet()) {
                if (excludeOption != null && excludeOption.contains(entry.getKey())) continue;
                for (Map.Entry<String, Object> param : entry.getValue().entrySet()) {
                    if (param.getValue() instanceof Integer) {
                        query.setParameter(param.getKey(), (Object)((Integer)param.getValue()));
                        continue;
                    }
                    if (param.getValue() instanceof Long) {
                        query.setParameter(param.getKey(), (Object)((Long)param.getValue()));
                        continue;
                    }
                    if (param.getValue() instanceof String) {
                        query.setParameter(param.getKey(), (Object)((String)param.getValue()));
                        continue;
                    }
                    if (param.getValue() instanceof Boolean) {
                        query.setParameter(param.getKey(), (Object)((Boolean)param.getValue()));
                        continue;
                    }
                    if (param.getValue() instanceof Date) {
                        query.setParameter(param.getKey(), (Object)((Date)param.getValue()));
                        continue;
                    }
                    if (param.getValue() instanceof List) {
                        List list = (List)param.getValue();
                        if (!list.isEmpty() && list.get(0) instanceof Long) {
                            query.setParameterList(param.getKey(), (Collection)list, Long.class);
                            continue;
                        }
                        if (!list.isEmpty() && list.get(0) instanceof String) {
                            query.setParameterList(param.getKey(), (Collection)list, String.class);
                            continue;
                        }
                        query.setParameterList(param.getKey(), (Collection)list);
                        continue;
                    }
                    query.setParameter(param.getKey(), (Object)param.getValue().toString());
                }
            }
            return query;
        }

        public RoomInstance select(String select) {
            return new RoomInstance(select);
        }

        public RoomInstance select() {
            return this.select(null);
        }

        public class RoomInstance {
            private String iSelect = null;
            private String iFrom = null;
            private String iWhere = null;
            private String iOrderBy = null;
            private String iGroupBy = null;
            private String iType = "Location";
            private Integer iLimit = null;
            private Set<String> iExclude = new HashSet<String>();
            private Map<String, Object> iParams = new HashMap<String, Object>();

            private RoomInstance(String select) {
                this.iSelect = select;
            }

            public RoomInstance from(String from) {
                this.iFrom = from;
                return this;
            }

            public RoomInstance where(String where) {
                this.iWhere = this.iWhere == null ? "(" + where + ")" : this.iWhere + " and (" + where + ")";
                return this;
            }

            public RoomInstance type(String type) {
                this.iType = type;
                return this;
            }

            public RoomInstance order(String orderBy) {
                this.iOrderBy = orderBy;
                return this;
            }

            public RoomInstance group(String groupBy) {
                this.iGroupBy = groupBy;
                return this;
            }

            public RoomInstance exclude(String excludeOption) {
                if (excludeOption != null && !excludeOption.isEmpty()) {
                    this.iExclude.add(excludeOption);
                }
                return this;
            }

            public RoomInstance set(String param, Object value) {
                this.iParams.put(param, value);
                return this;
            }

            public RoomInstance limit(Integer limit) {
                this.iLimit = limit == null || limit <= 0 ? null : limit;
                return this;
            }

            public String query() {
                return "select " + (this.iSelect == null ? "distinct l" : this.iSelect) + " from " + this.iType + " l " + (String)(this.iFrom == null ? "" : (this.iFrom.trim().toLowerCase().startsWith("inner join") ? " " + this.iFrom : ", " + this.iFrom)) + RoomQuery.this.getFrom(this.iExclude) + " where l.session.uniqueId = :sessionId " + RoomQuery.this.getWhere(this.iExclude) + (String)(this.iWhere == null ? "" : " and (" + this.iWhere + ")") + (String)(this.iGroupBy == null ? "" : " group by " + this.iGroupBy) + (String)(this.iOrderBy == null ? "" : " order by " + this.iOrderBy);
            }

            public org.hibernate.query.Query query(Session hibSession) {
                org.hibernate.query.Query query = RoomQuery.this.setParams(hibSession.createQuery(this.query()), this.iExclude);
                query.setParameter("sessionId", (Object)RoomQuery.this.iSessionId);
                query.setCacheable(true);
                for (Map.Entry<String, Object> param : this.iParams.entrySet()) {
                    if (param.getValue() instanceof Integer) {
                        query.setParameter(param.getKey(), (Object)((Integer)param.getValue()));
                        continue;
                    }
                    if (param.getValue() instanceof Long) {
                        query.setParameter(param.getKey(), (Object)((Long)param.getValue()));
                        continue;
                    }
                    if (param.getValue() instanceof String) {
                        query.setParameter(param.getKey(), (Object)((String)param.getValue()));
                        continue;
                    }
                    if (param.getValue() instanceof Boolean) {
                        query.setParameter(param.getKey(), (Object)((Boolean)param.getValue()));
                        continue;
                    }
                    if (param.getValue() instanceof Date) {
                        query.setParameter(param.getKey(), (Object)((Date)param.getValue()));
                        continue;
                    }
                    if (param.getValue() instanceof List) {
                        List list = (List)param.getValue();
                        if (!list.isEmpty() && list.get(0) instanceof Long) {
                            query.setParameterList(param.getKey(), (Collection)list, Long.class);
                            continue;
                        }
                        if (!list.isEmpty() && list.get(0) instanceof String) {
                            query.setParameterList(param.getKey(), (Collection)list, String.class);
                            continue;
                        }
                        query.setParameterList(param.getKey(), (Collection)list);
                        continue;
                    }
                    query.setParameter(param.getKey(), (Object)param.getValue().toString());
                }
                if (this.iLimit != null) {
                    query.setMaxResults(this.iLimit.intValue());
                }
                return query;
            }
        }
    }

    public static class LocationMatcher
    implements Query.TermMatcher {
        private Location iLocation;
        private Set<String> iFeatureTypes = null;

        public LocationMatcher(Location location, Set<String> featureTypes) {
            this.iLocation = location;
            this.iFeatureTypes = featureTypes;
        }

        public Location getLocation() {
            return this.iLocation;
        }

        @Override
        public boolean match(String attr, String term) {
            if (attr == null || attr.isEmpty()) {
                return term.isEmpty() || this.has(this.getLocation().getLabel(), term) || this.has(this.getLocation().getDisplayName(), term) || this.eq(this.getLocation().getLabelWithDisplayName(), term);
            }
            if ("feature".equals(attr) || this.iFeatureTypes != null && this.iFeatureTypes.contains(attr.toLowerCase())) {
                for (RoomFeature rf : this.getLocation().getFeatures()) {
                    if (!(rf instanceof GlobalRoomFeature) || !this.eq(rf.getAbbv(), term) && !this.has(rf.getLabel(), term)) continue;
                    return true;
                }
                return false;
            }
            if ("group".equals(attr)) {
                for (RoomGroup rg : this.getLocation().getRoomGroups()) {
                    if (!rg.isGlobal().booleanValue() || !this.eq(rg.getAbbv(), term) && !this.has(rg.getName(), term)) continue;
                    return true;
                }
                return false;
            }
            if ("type".equals(attr)) {
                return this.eq(this.getLocation().getRoomType().getReference(), term) || this.has(this.getLocation().getRoomType().getLabel(), term);
            }
            if ("room".equals(attr)) {
                return this.has(this.getLocation().getLabel(), term) || this.has(this.getLocation().getDisplayName(), term);
            }
            if ("starts".equals(attr)) {
                return this.getLocation().getLabel().toLowerCase().startsWith(term.toLowerCase()) || this.getLocation() instanceof Room && ((Room)this.getLocation()).getRoomNumber().toLowerCase().startsWith(term.toLowerCase()) || this.getLocation().getLabelWithDisplayName().toLowerCase().startsWith(term.toLowerCase()) || this.starts(this.getLocation().getDisplayName(), term);
            }
            if ("contains".equals(attr)) {
                return this.getLocation().getLabel().toLowerCase().contains(term.toLowerCase()) || this.getLocation() instanceof Room && ((Room)this.getLocation()).getRoomNumber().toLowerCase().contains(term.toLowerCase());
            }
            if ("building".equals(attr) || "bldg".equals(attr)) {
                if (this.getLocation() instanceof Room) {
                    Building building = ((Room)this.getLocation()).getBuilding();
                    return this.eq(building.getAbbreviation(), term) || this.has(building.getName(), term);
                }
                return false;
            }
            if ("size".equals(attr)) {
                int min = 0;
                int max = Integer.MAX_VALUE;
                Size prefix = Size.eq;
                String number = term;
                if (number.startsWith("<=")) {
                    prefix = Size.le;
                    number = number.substring(2);
                } else if (number.startsWith(">=")) {
                    prefix = Size.ge;
                    number = number.substring(2);
                } else if (number.startsWith("<")) {
                    prefix = Size.lt;
                    number = number.substring(1);
                } else if (number.startsWith(">")) {
                    prefix = Size.gt;
                    number = number.substring(1);
                } else if (number.startsWith("=")) {
                    prefix = Size.eq;
                    number = number.substring(1);
                }
                try {
                    int a = Integer.parseInt(number);
                    switch (prefix) {
                        case eq: {
                            min = max = a;
                            break;
                        }
                        case le: {
                            max = a;
                            break;
                        }
                        case ge: {
                            min = a;
                            break;
                        }
                        case lt: {
                            max = a - 1;
                            break;
                        }
                        case gt: {
                            min = a + 1;
                        }
                    }
                }
                catch (NumberFormatException a) {
                    // empty catch block
                }
                if (term.contains("..")) {
                    try {
                        String a = term.substring(0, term.indexOf(46));
                        String b = term.substring(term.indexOf("..") + 2);
                        min = Integer.parseInt(a);
                        max = Integer.parseInt(b);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return min <= this.getLocation().getCapacity() && this.getLocation().getCapacity() <= max;
            }
            if ("flag".equals(attr) && "event".equalsIgnoreCase(term)) {
                return this.getLocation().getEventDepartment() != null && this.getLocation().getEventDepartment().isAllowEvents() != false && this.getLocation().getEffectiveEventStatus() != RoomTypeOption.Status.NoEventManagement;
            }
            if ("department".equals(attr) || "dept".equals(attr) || "event".equals(attr) || "control".equals(attr)) {
                if ("event".equalsIgnoreCase(term)) {
                    return this.getLocation().getEventDepartment() != null && this.getLocation().getEventDepartment().isAllowEvents() != false && this.getLocation().getEffectiveEventStatus() != RoomTypeOption.Status.NoEventManagement;
                }
                if ("managed".equals(term)) {
                    return false;
                }
                if (!"control".equals(attr) && this.getLocation().getEventDepartment() != null && (this.eq(this.getLocation().getEventDepartment().getDeptCode(), term) || this.eq(this.getLocation().getEventDepartment().getAbbreviation(), term) || this.has(this.getLocation().getEventDepartment().getName(), term))) {
                    return true;
                }
                if (!"event".equals(attr)) {
                    for (RoomDept rd : this.getLocation().getRoomDepts()) {
                        if ("control".equals(attr) && !rd.isControl().booleanValue() || !this.eq(rd.getDepartment().getDeptCode(), term) && !this.eq(rd.getDepartment().getAbbreviation(), term) && !this.has(rd.getDepartment().getName(), term) && (!rd.getDepartment().isExternalManager().booleanValue() || !this.eq(rd.getDepartment().getExternalMgrAbbv(), term) && !this.has(rd.getDepartment().getExternalMgrLabel(), term))) continue;
                        return true;
                    }
                    if (!"control".equals(attr)) {
                        for (ExamType t : this.getLocation().getExamTypes()) {
                            if (!this.eq(t.getReference(), term) && !this.has(t.getLabel(), term)) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
            return true;
        }

        private boolean eq(String name, String term) {
            if (name == null) {
                return false;
            }
            return name.equalsIgnoreCase(term);
        }

        private boolean has(String name, String term) {
            if (name == null) {
                return false;
            }
            if (this.eq(name, term)) {
                return true;
            }
            for (String t : name.split(" |,")) {
                if (!t.equalsIgnoreCase(term)) continue;
                return true;
            }
            return false;
        }

        private boolean starts(String name, String term) {
            if (name == null || name.isEmpty()) {
                return false;
            }
            if (name.toLowerCase().startsWith(term.toLowerCase())) {
                return true;
            }
            for (String t : name.toLowerCase().split(" |,")) {
                if (!t.startsWith(term.toLowerCase())) continue;
                return true;
            }
            return false;
        }
    }

    public class Coordinates {
        Long iId;
        Double iX;
        Double iY;

        public Coordinates(Long id, Double x, Double y) {
            this.iId = id;
            this.iX = x;
            this.iY = y;
        }

        public Coordinates(Location location) {
            this.iId = location.getUniqueId();
            this.iX = location.getCoordinateX();
            this.iY = location.getCoordinateY();
        }

        public Long id() {
            return this.iId;
        }

        public Double x() {
            return this.iX;
        }

        public Double y() {
            return this.iY;
        }

        public boolean hasCoordinates() {
            return this.iX != null && this.iY != null;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Coordinates)) {
                return false;
            }
            Coordinates c = (Coordinates)o;
            if (!this.hasCoordinates()) {
                return !c.hasCoordinates();
            }
            if (!c.hasCoordinates()) {
                return false;
            }
            return Math.abs(c.x() - this.x()) < EPSILON && Math.abs(c.y() - this.y()) < EPSILON;
        }

        public double distance(Coordinates c) {
            return this.hasCoordinates() && c.hasCoordinates() ? RoomFilterBackend.this.getDistanceMetric().getDistanceInMeters(this.id(), this.x(), this.y(), c.id(), c.x(), c.y()) : Double.POSITIVE_INFINITY;
        }

        public double distance(Location location) {
            return this.distance(new Coordinates(location));
        }

        public String toString() {
            return this.hasCoordinates() ? sCDF.format(this.iX) + "," + sCDF.format(this.iY) : "";
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }

    private static enum Size {
        eq,
        lt,
        gt,
        le,
        ge;

    }
}

