/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.api.connectors;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import org.hibernate.Transaction;
import org.springframework.stereotype.Service;
import org.unitime.timetable.api.ApiConnector;
import org.unitime.timetable.api.ApiHelper;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.dao.BuildingDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.rights.Right;

@Service(value="/api/buildings")
public class BuildingsConntector
extends ApiConnector {
    @Override
    public void doGet(ApiHelper helper) throws IOException {
        Long sessionId = helper.getAcademicSessionId();
        if (sessionId == null) {
            throw new IllegalArgumentException("Academic session not provided, please set the term parameter.");
        }
        helper.getSessionContext().checkPermissionAnyAuthority(sessionId, "Session", Right.ApiRetrieveRooms, new Qualifiable[0]);
        ArrayList<RoomInterface.BuildingInterface> buildings = new ArrayList<RoomInterface.BuildingInterface>();
        for (Building b : Building.findAll(sessionId)) {
            RoomInterface.BuildingInterface building = new RoomInterface.BuildingInterface();
            building.setId(b.getUniqueId());
            building.setName(b.getName());
            building.setAbbreviation(b.getAbbreviation());
            building.setX(b.getCoordinateX());
            building.setY(b.getCoordinateY());
            building.setExternalId(b.getExternalUniqueId());
            buildings.add(building);
        }
        helper.setResponse(buildings);
    }

    @Override
    public void doDelete(ApiHelper helper) throws IOException {
        Transaction tx = helper.getHibSession().beginTransaction();
        try {
            Building building = null;
            Long buildingId = helper.getOptinalParameterLong("id", null);
            if (buildingId != null) {
                building = (Building)BuildingDAO.getInstance().get(buildingId, helper.getHibSession());
                if (building == null) {
                    throw new IllegalArgumentException("Building " + buildingId + " does not exist.");
                }
            } else {
                Long sessionId = helper.getAcademicSessionId();
                if (sessionId == null) {
                    throw new IllegalArgumentException("Academic session not provided, please set the term parameter.");
                }
                String externalId = helper.getOptinalParameter("externalId", null);
                if (externalId != null && (building = (Building)helper.getHibSession().createQuery("from Building where externalUniqueId = :externalId and session.uniqueId = :sessionId", Building.class).setParameter("sessionId", (Object)sessionId).setParameter("externalId", (Object)externalId).setMaxResults(1).uniqueResult()) == null) {
                    throw new IllegalArgumentException("Building " + externalId + " does not exist.");
                }
                if (building == null) {
                    String abbv = helper.getRequiredParameter("building");
                    building = (Building)helper.getHibSession().createQuery("from Building where (abbreviation = :abbv or name = :abbv) and session.uniqueId = :sessionId", Building.class).setParameter("sessionId", (Object)sessionId).setParameter("abbv", (Object)abbv).setMaxResults(1).uniqueResult();
                    if (building == null) {
                        throw new IllegalArgumentException("Building " + abbv + " does not exist.");
                    }
                }
            }
            helper.getSessionContext().checkPermissionAnyAuthority((Object)building.getSession(), Right.ApiRoomEdit, new Qualifiable[0]);
            helper.getSessionContext().checkPermissionAnyAuthority((Object)building, Right.BuildingDelete, new Qualifiable[0]);
            for (Room r : BuildingDAO.getInstance().getSession().createQuery("from Room r where r.building.uniqueId = :buildingId", Room.class).setParameter("buildingId", (Object)building.getUniqueId()).list()) {
                helper.getHibSession().createMutationQuery("delete RoomPref p where p.room.uniqueId = :roomId").setParameter("roomId", (Object)r.getUniqueId()).executeUpdate();
                Iterator<Assignment> i = r.getAssignments().iterator();
                while (i.hasNext()) {
                    Assignment a = i.next();
                    a.getRooms().remove(r);
                    helper.getHibSession().merge((Object)a);
                    i.remove();
                }
                helper.getHibSession().remove((Object)r);
            }
            ChangeLog.addChange(helper.getHibSession(), TimetableManager.findByExternalId(this.sessionContext.getUser().getExternalUserId()), building.getSession(), building, ChangeLog.Source.BUILDING_EDIT, ChangeLog.Operation.DELETE, null, null);
            helper.getHibSession().remove((Object)building);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public void doPost(ApiHelper helper) throws IOException {
        RoomInterface.BuildingInterface b = (RoomInterface.BuildingInterface)helper.getRequest((Type)((Object)RoomInterface.BuildingInterface.class));
        Transaction tx = helper.getHibSession().beginTransaction();
        try {
            Building building = null;
            if (b.getId() != null) {
                building = (Building)BuildingDAO.getInstance().get(b.getId(), helper.getHibSession());
                if (building == null) {
                    throw new IllegalArgumentException("Building " + b.getId() + " does not exist.");
                }
            } else {
                Long sessionId = helper.getAcademicSessionId();
                if (sessionId == null) {
                    throw new IllegalArgumentException("Academic session not provided, please set the term parameter.");
                }
                if (b.getExternalId() != null) {
                    building = (Building)helper.getHibSession().createQuery("from Building where externalUniqueId = :externalId and session.uniqueId = :sessionId", Building.class).setParameter("sessionId", (Object)sessionId).setParameter("externalId", (Object)b.getExternalId()).setMaxResults(1).uniqueResult();
                } else if (b.getAbbreviation() != null) {
                    building = (Building)helper.getHibSession().createQuery("from Building where abbreviation = :abbv and session.uniqueId = :sessionId", Building.class).setParameter("sessionId", (Object)sessionId).setParameter("abbv", (Object)b.getAbbreviation()).setMaxResults(1).uniqueResult();
                }
            }
            if (building != null) {
                helper.getSessionContext().checkPermissionAnyAuthority((Object)building.getSession(), Right.ApiRoomEdit, new Qualifiable[0]);
                helper.getSessionContext().checkPermissionAnyAuthority((Object)building, Right.BuildingEdit, new Qualifiable[0]);
            } else {
                helper.getSessionContext().checkPermissionAnyAuthority(helper.getAcademicSessionId(), "Session", Right.ApiRoomEdit, new Qualifiable[0]);
                helper.getSessionContext().checkPermissionAnyAuthority(helper.getAcademicSessionId(), "Session", Right.BuildingAdd, new Qualifiable[0]);
            }
            ChangeLog.Operation op = null;
            if (building == null) {
                building = new Building();
                building.setSession((Session)SessionDAO.getInstance().get(helper.getAcademicSessionId(), helper.getHibSession()));
                op = ChangeLog.Operation.CREATE;
            } else {
                op = ChangeLog.Operation.UPDATE;
            }
            building.setName(b.getName());
            building.setAbbreviation(b.getAbbreviation());
            building.setExternalUniqueId(b.getExternalId());
            building.setCoordinateX(b.getX());
            building.setCoordinateY(b.getY());
            if (building.getUniqueId() == null) {
                helper.getHibSession().persist((Object)building);
            } else {
                helper.getHibSession().merge((Object)building);
            }
            b.setId(building.getUniqueId());
            ChangeLog.addChange(helper.getHibSession(), TimetableManager.findByExternalId(this.sessionContext.getUser().getExternalUserId()), building.getSession(), building, ChangeLog.Source.BUILDING_EDIT, op, null, null);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage(), e);
        }
        helper.setResponse(b);
    }

    @Override
    protected String getName() {
        return "buildings";
    }
}

