/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesDefinitions;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.hibernate.Transaction;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.localization.messages.SecurityMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.CourseOfferingEditForm;
import org.unitime.timetable.interfaces.ExternalCourseOfferingEditAction;
import org.unitime.timetable.interfaces.ExternalInstructionalOfferingAddAction;
import org.unitime.timetable.interfaces.ExternalLinkLookup;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.CourseCreditUnitConfig;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseType;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.FixedCreditUnitConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.LastLikeCourseDemand;
import org.unitime.timetable.model.OfferingConsentType;
import org.unitime.timetable.model.OfferingCoordinator;
import org.unitime.timetable.model.OverrideType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentSectioningQueue;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TeachingRequest;
import org.unitime.timetable.model.TeachingResponsibility;
import org.unitime.timetable.model.VariableFixedCreditUnitConfig;
import org.unitime.timetable.model.VariableRangeCreditUnitConfig;
import org.unitime.timetable.model.base.BaseOfferingCoordinator;
import org.unitime.timetable.model.comparators.OfferingCoordinatorComparator;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.CourseTypeDAO;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.OfferingConsentTypeDAO;
import org.unitime.timetable.model.dao.OverrideTypeDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.model.dao.TeachingResponsibilityDAO;
import org.unitime.timetable.security.permissions.Permission;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.InstrOfferingPermIdGenerator;
import org.unitime.timetable.util.LookupTables;

@Action(value="courseOfferingEdit", results={@Result(name={"edit"}, type="tiles", location="courseOfferingEdit.tiles"), @Result(name={"add"}, type="tiles", location="courseOfferingAdd.tiles"), @Result(name={"instructionalOfferingDetail"}, type="redirect", location="/instructionalOfferingDetail.action", params={"io", "${form.instrOfferingId}", "op", "view"}), @Result(name={"instructionalOfferingsList"}, type="redirect", location="/instructionalOfferingSearch.action", params={"backType", "InstructionalOffering", "backId", "${form.instrOfferingId}", "anchor", "back"})})
@TilesDefinitions(value={@TilesDefinition(name="courseOfferingEdit.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Edit Course Offering"), @TilesPutAttribute(name="body", value="/user/courseOfferingEdit.jsp"), @TilesPutAttribute(name="showNavigation", value="true")}), @TilesDefinition(name="courseOfferingAdd.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Add Course Offering"), @TilesPutAttribute(name="body", value="/user/courseOfferingEdit.jsp"), @TilesPutAttribute(name="showNavigation", value="true")})})
public class CourseOfferingEditAction
extends UniTimeAction<CourseOfferingEditForm> {
    private static final long serialVersionUID = -8547793378971178908L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    protected static final SecurityMessages SEC = Localization.create(SecurityMessages.class);
    protected String op2 = null;
    protected Long courseOfferingId;
    protected Long subjAreaId;
    protected String courseNbr;
    protected Integer deleteId;
    protected String deleteType;

    public String getHdnOp() {
        return this.op2;
    }

    public void setHdnOp(String hdnOp) {
        this.op2 = hdnOp;
    }

    public Long getCourseOfferingId() {
        return this.courseOfferingId;
    }

    public void setCourseOfferingId(Long courseOfferingId) {
        this.courseOfferingId = courseOfferingId;
    }

    public Long getSubjAreaId() {
        return this.subjAreaId;
    }

    public void setSubjAreaId(Long subjAreaId) {
        this.subjAreaId = subjAreaId;
    }

    public String getCourseNbr() {
        return this.courseNbr;
    }

    public void setCourseNbr(String courseNbr) {
        this.courseNbr = courseNbr;
    }

    public Integer getDeleteId() {
        return this.deleteId;
    }

    public void setDeleteId(Integer deleteId) {
        this.deleteId = deleteId;
    }

    public String getDeleteType() {
        return this.deleteType;
    }

    public void setDeleteType(String deleteType) {
        this.deleteType = deleteType;
    }

    public String execute() throws Exception {
        if (this.form == null) {
            this.form = new CourseOfferingEditForm();
        }
        if (this.op == null) {
            this.op = ((CourseOfferingEditForm)this.form).getOp();
        }
        if (this.op2 != null && !this.op2.isEmpty()) {
            this.op = this.op2;
        }
        if (this.op == null || this.op.trim().isEmpty()) {
            this.op = "reload";
        }
        Debug.debug("Op: " + this.op);
        if (this.op.equals(MSG.actionBackToIODetail()) && !((CourseOfferingEditForm)this.form).isAdd()) {
            return "instructionalOfferingDetail";
        }
        if (this.op.equals(MSG.actionBackToIOList()) && ((CourseOfferingEditForm)this.form).isAdd()) {
            return "instructionalOfferingsList";
        }
        if (this.op.equals(MSG.actionEditCourseOffering())) {
            if (this.courseOfferingId == null && ((CourseOfferingEditForm)this.form).getCourseOfferingId() != null) {
                this.courseOfferingId = ((CourseOfferingEditForm)this.form).getCourseOfferingId();
            }
            if (this.courseOfferingId == null) {
                throw new Exception(MSG.errorCourseDataNotCorrect() + this.courseOfferingId);
            }
            if (ApplicationProperty.LegacyCourseEdit.isTrue()) {
                this.doLoad(this.courseOfferingId);
                return "edit";
            }
            this.response.sendRedirect("gwt.jsp?page=courseOffering&offering=" + String.valueOf(this.courseOfferingId == null ? "" : this.courseOfferingId) + "&op=editCourseOffering");
            return null;
        }
        if (this.op.equals(MSG.actionAddCourseOffering())) {
            ((CourseOfferingEditForm)this.form).setSubjectAreaId(this.subjAreaId);
            ((CourseOfferingEditForm)this.form).setCourseNbr(this.courseNbr);
            TreeSet<SubjectArea> subjects = SubjectArea.getUserSubjectAreas(this.sessionContext.getUser());
            if (((CourseOfferingEditForm)this.form).getSubjectAreaId() == null && !subjects.isEmpty()) {
                ((CourseOfferingEditForm)this.form).setSubjectAreaId(subjects.first().getUniqueId());
            }
            ((CourseOfferingEditForm)this.form).setIsControl(true);
            ((CourseOfferingEditForm)this.form).setAllowDemandCourseOfferings(true);
            for (int i = 0; i < 2; ++i) {
                ((CourseOfferingEditForm)this.form).getInstructors().add("-");
                ((CourseOfferingEditForm)this.form).getPercentShares().add("");
                ((CourseOfferingEditForm)this.form).getResponsibilities().add(((CourseOfferingEditForm)this.form).getDefaultTeachingResponsibilityId());
            }
            ((CourseOfferingEditForm)this.form).setAdd(true);
            Session session = (Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId());
            ((CourseOfferingEditForm)this.form).setWkEnrollDefault(session.getLastWeekToEnroll());
            ((CourseOfferingEditForm)this.form).setWkChangeDefault(session.getLastWeekToChange());
            ((CourseOfferingEditForm)this.form).setWkDropDefault(session.getLastWeekToDrop());
            ((CourseOfferingEditForm)this.form).setWeekStartDayOfWeek(Localization.getDateFormat("EEEE").format(session.getSessionBeginDateTime()));
            ((CourseOfferingEditForm)this.form).setAllowAlternativeCourseOfferings(ApplicationProperty.StudentSchedulingAlternativeCourse.isTrue());
            this.doReload();
        }
        if (this.op.equals(MSG.actionUpdateCourseOffering()) || this.op.equals(MSG.actionSaveCourseOffering())) {
            ((CourseOfferingEditForm)this.form).validate(this);
            if (!this.hasFieldErrors()) {
                if (((CourseOfferingEditForm)this.form).isAdd()) {
                    this.doSave();
                } else {
                    this.doUpdate();
                }
                String cn = (String)this.sessionContext.getAttribute(SessionAttribute.OfferingsCourseNumber);
                if (cn != null) {
                    this.sessionContext.setAttribute(SessionAttribute.OfferingsCourseNumber, (Object)((CourseOfferingEditForm)this.form).getCourseNbr());
                }
                ((CourseOfferingEditForm)this.form).setOp("view");
                return "instructionalOfferingDetail";
            }
            this.doReload();
        }
        if (this.op.equals(MSG.actionAddCoordinator())) {
            for (int i = 0; i < 2; ++i) {
                ((CourseOfferingEditForm)this.form).getInstructors().add("-");
                ((CourseOfferingEditForm)this.form).getPercentShares().add("");
                ((CourseOfferingEditForm)this.form).getResponsibilities().add(((CourseOfferingEditForm)this.form).getDefaultTeachingResponsibilityId());
            }
            this.doReload();
        }
        if (this.op.equals(MSG.actionRemoveCoordinator()) && "coordinator".equals(this.deleteType)) {
            try {
                if (this.deleteId != null && this.deleteId >= 0) {
                    ((CourseOfferingEditForm)this.form).getInstructors().remove(this.deleteId);
                    ((CourseOfferingEditForm)this.form).getResponsibilities().remove(this.deleteId);
                    ((CourseOfferingEditForm)this.form).getPercentShares().remove(this.deleteId);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.doReload();
        }
        if (this.op.equals("reload")) {
            this.doReload();
        }
        return ((CourseOfferingEditForm)this.form).isAdd() ? "add" : "edit";
    }

    private void doUpdate() throws Exception {
        boolean limitedEdit = false;
        boolean updateNote = false;
        boolean updateCoordinators = false;
        if (this.sessionContext.hasPermission(((CourseOfferingEditForm)this.form).getCourseOfferingId(), "CourseOffering", Right.EditCourseOfferingNote)) {
            updateNote = true;
        }
        if (this.sessionContext.hasPermission(((CourseOfferingEditForm)this.form).getCourseOfferingId(), "CourseOffering", Right.EditCourseOfferingCoordinators)) {
            updateCoordinators = true;
        }
        if (updateNote || updateCoordinators) {
            limitedEdit = !this.sessionContext.hasPermission(((CourseOfferingEditForm)this.form).getCourseOfferingId(), "CourseOffering", Right.EditCourseOffering);
        } else {
            this.sessionContext.checkPermission(((CourseOfferingEditForm)this.form).getCourseOfferingId(), "CourseOffering", Right.EditCourseOffering);
        }
        String title = ((CourseOfferingEditForm)this.form).getTitle();
        String note = ((CourseOfferingEditForm)this.form).getScheduleBookNote();
        Long crsId = ((CourseOfferingEditForm)this.form).getCourseOfferingId();
        String crsNbr = ((CourseOfferingEditForm)this.form).getCourseNbr();
        org.hibernate.Session hibSession = null;
        Transaction tx = null;
        try {
            OfferingConsentTypeDAO odao = OfferingConsentTypeDAO.getInstance();
            CourseOfferingDAO cdao = CourseOfferingDAO.getInstance();
            hibSession = cdao.getSession();
            tx = hibSession.beginTransaction();
            CourseOffering co = (CourseOffering)cdao.get(crsId);
            InstructionalOffering io = co.getInstructionalOffering();
            if (!limitedEdit || updateNote) {
                co.setScheduleBookNote(note);
            }
            co.getDisabledOverrides().clear();
            for (String override : ((CourseOfferingEditForm)this.form).getCourseOverrides()) {
                co.getDisabledOverrides().add((OverrideType)OverrideTypeDAO.getInstance().get(Long.valueOf(override)));
            }
            if (co.isIsControl().booleanValue()) {
                if (((CourseOfferingEditForm)this.form).getWaitList() == null || ((CourseOfferingEditForm)this.form).getWaitList().isEmpty()) {
                    io.setWaitListMode(null);
                } else if ("waitlist".equalsIgnoreCase(((CourseOfferingEditForm)this.form).getWaitList())) {
                    io.setWaitListMode(InstructionalOffering.OfferingWaitListMode.WaitList);
                } else if ("reschedule".equalsIgnoreCase(((CourseOfferingEditForm)this.form).getWaitList())) {
                    io.setWaitListMode(InstructionalOffering.OfferingWaitListMode.ReSchedule);
                } else {
                    io.setWaitListMode(InstructionalOffering.OfferingWaitListMode.Disabled);
                }
                if (limitedEdit) {
                    hibSession.merge((Object)io);
                }
            }
            if ((!limitedEdit || updateCoordinators) && co.isIsControl().booleanValue()) {
                boolean assignTeachingRequest = Department.isInstructorSchedulingCommitted(co.getDepartment().getUniqueId());
                if (io.getOfferingCoordinators() == null) {
                    io.setOfferingCoordinators(new HashSet<OfferingCoordinator>());
                }
                ArrayList<OfferingCoordinator> coordinators = new ArrayList<OfferingCoordinator>(io.getOfferingCoordinators());
                int idx = 0;
                for (String instructorId : ((CourseOfferingEditForm)this.form).getInstructors()) {
                    TeachingResponsibility responsibility;
                    String responsibilityId = ((CourseOfferingEditForm)this.form).getResponsibilities(idx);
                    String percShare = ((CourseOfferingEditForm)this.form).getPercentShares(idx);
                    ++idx;
                    if (Constants.BLANK_OPTION_VALUE.equals(instructorId) || "-".equals(instructorId)) continue;
                    DepartmentalInstructor instructor = (DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(Long.valueOf(instructorId));
                    TeachingResponsibility teachingResponsibility = responsibility = Constants.BLANK_OPTION_VALUE.equals(responsibilityId) || "-".equals(responsibilityId) ? null : (TeachingResponsibility)TeachingResponsibilityDAO.getInstance().get(Long.valueOf(responsibilityId));
                    if (instructor == null) continue;
                    BaseOfferingCoordinator coordinator = null;
                    Iterator<Object> j = coordinators.iterator();
                    while (j.hasNext()) {
                        OfferingCoordinator c = (OfferingCoordinator)j.next();
                        if (!instructor.equals(c.getInstructor())) continue;
                        coordinator = c;
                        j.remove();
                        break;
                    }
                    if (coordinator == null) {
                        coordinator = new OfferingCoordinator();
                        coordinator.setInstructor(instructor);
                        coordinator.setOffering(io);
                        if (assignTeachingRequest) {
                            for (TeachingRequest tr : io.getTeachingRequests()) {
                                if (!tr.getAssignCoordinator().booleanValue() || !tr.getAssignedInstructors().contains(instructor)) continue;
                                coordinator.setTeachingRequest(tr);
                                break;
                            }
                        }
                    }
                    coordinator.setResponsibility(responsibility);
                    try {
                        coordinator.setPercentShare(percShare == null ? 0 : Integer.parseInt(percShare));
                    }
                    catch (NumberFormatException e) {
                        coordinator.setPercentShare(0);
                    }
                    io.getOfferingCoordinators().add((OfferingCoordinator)coordinator);
                    instructor.getOfferingCoordinators().add((OfferingCoordinator)coordinator);
                    if (coordinator.getUniqueId() == null) {
                        hibSession.persist((Object)coordinator);
                        continue;
                    }
                    hibSession.merge((Object)coordinator);
                }
                for (OfferingCoordinator coordinator : coordinators) {
                    coordinator.getInstructor().getOfferingCoordinators().remove(coordinator);
                    io.getOfferingCoordinators().remove(coordinator);
                    hibSession.remove((Object)coordinator);
                }
                if (limitedEdit) {
                    hibSession.merge((Object)io);
                }
            }
            if (!limitedEdit) {
                if (co.getCourseNbr() != null && !co.getCourseNbr().equals(crsNbr) && co.getPermId() == null) {
                    LastLikeCourseDemand llcd2 = null;
                    String permId = InstrOfferingPermIdGenerator.getGenerator().generate((SharedSessionContractImplementor)((SessionImplementor)CourseOfferingDAO.getInstance().getSession()), co).toString();
                    for (LastLikeCourseDemand llcd2 : co.getCourseOfferingDemands()) {
                        if (llcd2.getCoursePermId() != null) continue;
                        llcd2.setCoursePermId(permId);
                        hibSession.merge((Object)llcd2);
                    }
                    co.setPermId(permId);
                }
                co.setCourseNbr(crsNbr);
                co.setTitle(title);
                if (((CourseOfferingEditForm)this.form).getDemandCourseOfferingId() == null) {
                    co.setDemandOffering(null);
                } else {
                    CourseOffering dco = (CourseOffering)cdao.get(((CourseOfferingEditForm)this.form).getDemandCourseOfferingId(), hibSession);
                    co.setDemandOffering(dco == null ? null : dco);
                }
                if (ApplicationProperty.StudentSchedulingAlternativeCourse.isTrue()) {
                    if (((CourseOfferingEditForm)this.form).getAlternativeCourseOfferingId() == null) {
                        co.setAlternativeOffering(null);
                    } else {
                        co.setAlternativeOffering((CourseOffering)CourseOfferingDAO.getInstance().get(((CourseOfferingEditForm)this.form).getAlternativeCourseOfferingId(), hibSession));
                    }
                }
                if (((CourseOfferingEditForm)this.form).getCourseTypeId() == null || ((CourseOfferingEditForm)this.form).getCourseTypeId().isEmpty()) {
                    co.setCourseType(null);
                } else {
                    co.setCourseType((CourseType)CourseTypeDAO.getInstance().get(Long.valueOf(((CourseOfferingEditForm)this.form).getCourseTypeId()), hibSession));
                }
                if (((CourseOfferingEditForm)this.form).getConsent() == null || ((CourseOfferingEditForm)this.form).getConsent().intValue() <= 0) {
                    co.setConsentType(null);
                } else {
                    OfferingConsentType oct = (OfferingConsentType)odao.get(((CourseOfferingEditForm)this.form).getConsent());
                    co.setConsentType(oct);
                }
                if (((CourseOfferingEditForm)this.form).getCreditFormat() == null || ((CourseOfferingEditForm)this.form).getCreditFormat().length() == 0 || ((CourseOfferingEditForm)this.form).getCreditFormat().equals(Constants.BLANK_OPTION_VALUE)) {
                    CourseCreditUnitConfig origConfig = co.getCredit();
                    if (origConfig != null) {
                        co.setCredit(null);
                        hibSession.remove((Object)origConfig);
                    }
                } else {
                    if (co.getCredit() != null) {
                        CourseCreditUnitConfig ccuc = co.getCredit();
                        if (ccuc.getCreditFormat().equals(((CourseOfferingEditForm)this.form).getCreditFormat())) {
                            boolean changed = false;
                            if (!ccuc.getCreditType().getUniqueId().equals(((CourseOfferingEditForm)this.form).getCreditType())) {
                                changed = true;
                            }
                            if (!ccuc.getCreditUnitType().getUniqueId().equals(((CourseOfferingEditForm)this.form).getCreditUnitType())) {
                                changed = true;
                            }
                            if (ccuc instanceof FixedCreditUnitConfig) {
                                FixedCreditUnitConfig fcuc = (FixedCreditUnitConfig)ccuc;
                                if (!fcuc.getFixedUnits().equals(((CourseOfferingEditForm)this.form).getUnits())) {
                                    changed = true;
                                }
                            } else if (ccuc instanceof VariableFixedCreditUnitConfig) {
                                VariableRangeCreditUnitConfig vrcuc;
                                VariableFixedCreditUnitConfig vfcuc = (VariableFixedCreditUnitConfig)ccuc;
                                if (!vfcuc.getMinUnits().equals(((CourseOfferingEditForm)this.form).getUnits())) {
                                    changed = true;
                                }
                                if (!vfcuc.getMaxUnits().equals(((CourseOfferingEditForm)this.form).getMaxUnits())) {
                                    changed = true;
                                }
                                if (vfcuc instanceof VariableRangeCreditUnitConfig && ((vrcuc = (VariableRangeCreditUnitConfig)vfcuc).isFractionalIncrementsAllowed() == null || !vrcuc.isFractionalIncrementsAllowed().equals(((CourseOfferingEditForm)this.form).getFractionalIncrementsAllowed()))) {
                                    changed = true;
                                }
                            }
                            if (changed) {
                                CourseCreditUnitConfig origConfig = co.getCredit();
                                co.setCredit(null);
                                hibSession.remove((Object)origConfig);
                                co.setCredit(CourseCreditUnitConfig.createCreditUnitConfigOfFormat(((CourseOfferingEditForm)this.form).getCreditFormat(), ((CourseOfferingEditForm)this.form).getCreditType(), ((CourseOfferingEditForm)this.form).getCreditUnitType(), ((CourseOfferingEditForm)this.form).getUnits(), ((CourseOfferingEditForm)this.form).getMaxUnits(), ((CourseOfferingEditForm)this.form).getFractionalIncrementsAllowed(), (Boolean)true));
                                co.getCredit().setOwner(co);
                            }
                        } else {
                            CourseCreditUnitConfig origConfig = co.getCredit();
                            co.setCredit(null);
                            hibSession.remove((Object)origConfig);
                            co.setCredit(CourseCreditUnitConfig.createCreditUnitConfigOfFormat(((CourseOfferingEditForm)this.form).getCreditFormat(), ((CourseOfferingEditForm)this.form).getCreditType(), ((CourseOfferingEditForm)this.form).getCreditUnitType(), ((CourseOfferingEditForm)this.form).getUnits(), ((CourseOfferingEditForm)this.form).getMaxUnits(), ((CourseOfferingEditForm)this.form).getFractionalIncrementsAllowed(), (Boolean)true));
                            co.getCredit().setOwner(co);
                        }
                    } else {
                        co.setCredit(CourseCreditUnitConfig.createCreditUnitConfigOfFormat(((CourseOfferingEditForm)this.form).getCreditFormat(), ((CourseOfferingEditForm)this.form).getCreditType(), ((CourseOfferingEditForm)this.form).getCreditUnitType(), ((CourseOfferingEditForm)this.form).getUnits(), ((CourseOfferingEditForm)this.form).getMaxUnits(), ((CourseOfferingEditForm)this.form).getFractionalIncrementsAllowed(), (Boolean)true));
                        co.getCredit().setOwner(co);
                    }
                    if (co.getCredit() != null) {
                        if (co.getCredit().getUniqueId() == null) {
                            hibSession.persist((Object)co.getCredit());
                        } else {
                            hibSession.merge((Object)co.getCredit());
                        }
                    }
                }
                if (co.isIsControl().booleanValue()) {
                    io.setByReservationOnly(((CourseOfferingEditForm)this.form).isByReservationOnly());
                    try {
                        io.setLastWeekToEnroll(Integer.parseInt(((CourseOfferingEditForm)this.form).getWkEnroll()));
                    }
                    catch (Exception e) {
                        io.setLastWeekToEnroll(null);
                    }
                    try {
                        io.setLastWeekToChange(Integer.parseInt(((CourseOfferingEditForm)this.form).getWkChange()));
                    }
                    catch (Exception e) {
                        io.setLastWeekToChange(null);
                    }
                    try {
                        io.setLastWeekToDrop(Integer.parseInt(((CourseOfferingEditForm)this.form).getWkDrop()));
                    }
                    catch (Exception e) {
                        io.setLastWeekToDrop(null);
                    }
                    io.setNotes(((CourseOfferingEditForm)this.form).getNotes() == null || ((CourseOfferingEditForm)this.form).getNotes().length() <= 2000 ? ((CourseOfferingEditForm)this.form).getNotes() : ((CourseOfferingEditForm)this.form).getNotes().substring(0, 2000));
                    hibSession.merge((Object)io);
                }
                if (ApplicationProperty.CourseOfferingEditExternalIds.isTrue()) {
                    co.setExternalUniqueId(((CourseOfferingEditForm)this.form).getExternalId() == null || ((CourseOfferingEditForm)this.form).getExternalId().isEmpty() ? null : ((CourseOfferingEditForm)this.form).getExternalId());
                }
            }
            hibSession.merge((Object)co);
            ChangeLog.addChange(hibSession, this.sessionContext, co, ChangeLog.Source.COURSE_OFFERING_EDIT, ChangeLog.Operation.UPDATE, co.getSubjectArea(), co.getDepartment());
            if (limitedEdit && this.getPermissionOfferingLockNeeded().check(this.sessionContext.getUser(), io)) {
                StudentSectioningQueue.offeringChanged(hibSession, this.sessionContext.getUser(), io.getSessionId(), io.getUniqueId());
            }
            hibSession.flush();
            tx.commit();
            hibSession.refresh((Object)co);
            hibSession.refresh((Object)io);
            String className = ApplicationProperty.ExternalActionCourseOfferingEdit.value();
            if (className != null && className.trim().length() > 0) {
                if (io == null) {
                    io = co.getInstructionalOffering();
                }
                ExternalCourseOfferingEditAction editAction = (ExternalCourseOfferingEditAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                editAction.performExternalCourseOfferingEditAction(io, hibSession);
            }
        }
        catch (Exception e) {
            try {
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Debug.error(e);
            throw e;
        }
    }

    private void doSave() throws Exception {
        this.sessionContext.checkPermission(((CourseOfferingEditForm)this.form).getSubjectAreaId(), "SubjectArea", Right.AddCourseOffering);
        org.hibernate.Session hibSession = CourseOfferingDAO.getInstance().getSession();
        Transaction tx = null;
        try {
            String className2;
            String className1;
            tx = hibSession.beginTransaction();
            SubjectArea subjArea = (SubjectArea)SubjectAreaDAO.getInstance().get(((CourseOfferingEditForm)this.form).getSubjectAreaId(), hibSession);
            CourseOffering co = new CourseOffering();
            co.setSubjectArea(subjArea);
            co.setSubjectAreaAbbv(subjArea.getSubjectAreaAbbreviation());
            co.setCourseNbr(((CourseOfferingEditForm)this.form).getCourseNbr());
            co.setProjectedDemand(0);
            co.setDemand(0);
            co.setNbrExpectedStudents(0);
            co.setIsControl(true);
            co.setPermId(InstrOfferingPermIdGenerator.getGenerator().generate((SharedSessionContractImplementor)((SessionImplementor)CourseOfferingDAO.getInstance().getSession()), co).toString());
            subjArea.getCourseOfferings().add(co);
            InstructionalOffering io = new InstructionalOffering();
            io.setNotOffered(false);
            io.setSession(subjArea.getSession());
            io.generateInstrOfferingPermId();
            co.setInstructionalOffering(io);
            io.addToCourseOfferings(co);
            co.setScheduleBookNote(((CourseOfferingEditForm)this.form).getScheduleBookNote());
            co.setDisabledOverrides(new HashSet<OverrideType>());
            for (String override : ((CourseOfferingEditForm)this.form).getCourseOverrides()) {
                co.getDisabledOverrides().add((OverrideType)OverrideTypeDAO.getInstance().get(Long.valueOf(override)));
            }
            io.setOfferingCoordinators(new HashSet<OfferingCoordinator>());
            int idx = 0;
            for (String instructorId : ((CourseOfferingEditForm)this.form).getInstructors()) {
                TeachingResponsibility responsibility;
                String responsibilityId = ((CourseOfferingEditForm)this.form).getResponsibilities(idx);
                String percShare = ((CourseOfferingEditForm)this.form).getPercentShares(idx);
                ++idx;
                if (Constants.BLANK_OPTION_VALUE.equals(instructorId) || "-".equals(instructorId)) continue;
                DepartmentalInstructor instructor = (DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(Long.valueOf(instructorId));
                TeachingResponsibility teachingResponsibility = responsibility = Constants.BLANK_OPTION_VALUE.equals(responsibilityId) || "-".equals(responsibilityId) ? null : (TeachingResponsibility)TeachingResponsibilityDAO.getInstance().get(Long.valueOf(responsibilityId));
                if (instructor == null) continue;
                OfferingCoordinator coordinator = new OfferingCoordinator();
                coordinator.setInstructor(instructor);
                coordinator.setOffering(io);
                coordinator.setResponsibility(responsibility);
                try {
                    coordinator.setPercentShare(percShare == null ? 0 : Integer.parseInt(percShare));
                }
                catch (NumberFormatException e) {
                    coordinator.setPercentShare(0);
                }
                io.getOfferingCoordinators().add(coordinator);
                instructor.getOfferingCoordinators().add(coordinator);
            }
            co.setTitle(((CourseOfferingEditForm)this.form).getTitle());
            if (((CourseOfferingEditForm)this.form).getDemandCourseOfferingId() != null) {
                co.setDemandOffering((CourseOffering)CourseOfferingDAO.getInstance().get(((CourseOfferingEditForm)this.form).getDemandCourseOfferingId(), hibSession));
            }
            if (((CourseOfferingEditForm)this.form).getAlternativeCourseOfferingId() != null && ApplicationProperty.StudentSchedulingAlternativeCourse.isTrue()) {
                co.setAlternativeOffering((CourseOffering)CourseOfferingDAO.getInstance().get(((CourseOfferingEditForm)this.form).getAlternativeCourseOfferingId(), hibSession));
            }
            if (((CourseOfferingEditForm)this.form).getCourseTypeId() != null && !((CourseOfferingEditForm)this.form).getCourseTypeId().isEmpty()) {
                co.setCourseType((CourseType)CourseTypeDAO.getInstance().get(Long.valueOf(((CourseOfferingEditForm)this.form).getCourseTypeId()), hibSession));
            }
            if (((CourseOfferingEditForm)this.form).getConsent() != null && ((CourseOfferingEditForm)this.form).getConsent().intValue() > 0) {
                co.setConsentType((OfferingConsentType)OfferingConsentTypeDAO.getInstance().get(((CourseOfferingEditForm)this.form).getConsent()));
            }
            io.setByReservationOnly(((CourseOfferingEditForm)this.form).isByReservationOnly());
            try {
                io.setLastWeekToEnroll(Integer.parseInt(((CourseOfferingEditForm)this.form).getWkEnroll()));
            }
            catch (Exception e) {
                io.setLastWeekToEnroll(null);
            }
            try {
                io.setLastWeekToChange(Integer.parseInt(((CourseOfferingEditForm)this.form).getWkChange()));
            }
            catch (Exception e) {
                io.setLastWeekToChange(null);
            }
            try {
                io.setLastWeekToDrop(Integer.parseInt(((CourseOfferingEditForm)this.form).getWkDrop()));
            }
            catch (Exception e) {
                io.setLastWeekToDrop(null);
            }
            if (((CourseOfferingEditForm)this.form).getWaitList() == null || ((CourseOfferingEditForm)this.form).getWaitList().isEmpty()) {
                io.setWaitListMode(null);
            } else if ("waitlist".equalsIgnoreCase(((CourseOfferingEditForm)this.form).getWaitList())) {
                io.setWaitListMode(InstructionalOffering.OfferingWaitListMode.WaitList);
            } else if ("reschedule".equalsIgnoreCase(((CourseOfferingEditForm)this.form).getWaitList())) {
                io.setWaitListMode(InstructionalOffering.OfferingWaitListMode.ReSchedule);
            } else {
                io.setWaitListMode(InstructionalOffering.OfferingWaitListMode.Disabled);
            }
            io.setNotes(((CourseOfferingEditForm)this.form).getNotes() == null || ((CourseOfferingEditForm)this.form).getNotes().length() <= 2000 ? ((CourseOfferingEditForm)this.form).getNotes() : ((CourseOfferingEditForm)this.form).getNotes().substring(0, 2000));
            if (ApplicationProperty.CourseOfferingEditExternalIds.isTrue()) {
                co.setExternalUniqueId(((CourseOfferingEditForm)this.form).getExternalId() == null || ((CourseOfferingEditForm)this.form).getExternalId().isEmpty() ? null : ((CourseOfferingEditForm)this.form).getExternalId());
            }
            hibSession.persist((Object)io);
            hibSession.persist((Object)co);
            if (((CourseOfferingEditForm)this.form).getCreditFormat() != null && !((CourseOfferingEditForm)this.form).getCreditFormat().isEmpty() && !((CourseOfferingEditForm)this.form).getCreditFormat().equals(Constants.BLANK_OPTION_VALUE)) {
                co.setCredit(CourseCreditUnitConfig.createCreditUnitConfigOfFormat(((CourseOfferingEditForm)this.form).getCreditFormat(), ((CourseOfferingEditForm)this.form).getCreditType(), ((CourseOfferingEditForm)this.form).getCreditUnitType(), ((CourseOfferingEditForm)this.form).getUnits(), ((CourseOfferingEditForm)this.form).getMaxUnits(), ((CourseOfferingEditForm)this.form).getFractionalIncrementsAllowed(), (Boolean)true));
                co.getCredit().setOwner(co);
            }
            if (co.getCredit() != null) {
                hibSession.persist((Object)co.getCredit());
            }
            for (OfferingCoordinator coordinator : io.getOfferingCoordinators()) {
                hibSession.persist((Object)coordinator);
            }
            ChangeLog.addChange(hibSession, this.sessionContext, co, ChangeLog.Source.COURSE_OFFERING_EDIT, ChangeLog.Operation.CREATE, co.getSubjectArea(), co.getDepartment());
            hibSession.flush();
            tx.commit();
            ((CourseOfferingEditForm)this.form).setInstrOfferingId(io.getUniqueId());
            ((CourseOfferingEditForm)this.form).setCourseOfferingId(co.getUniqueId());
            hibSession.refresh((Object)co);
            hibSession.refresh((Object)io);
            if (this.sessionContext.hasPermission(io, Right.OfferingCanLock)) {
                io.getSession().lockOffering(io.getUniqueId());
            }
            if (this.getPermissionOfferingLockNeeded().check(this.sessionContext.getUser(), io)) {
                StudentSectioningQueue.offeringChanged(hibSession, this.sessionContext.getUser(), io.getSessionId(), io.getUniqueId());
            }
            if ((className1 = ApplicationProperty.ExternalActionInstructionalOfferingAdd.value()) != null && className1.trim().length() > 0) {
                ExternalInstructionalOfferingAddAction addAction = (ExternalInstructionalOfferingAddAction)Class.forName(className1).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                addAction.performExternalInstructionalOfferingAddAction(io, hibSession);
            }
            if ((className2 = ApplicationProperty.ExternalActionCourseOfferingEdit.value()) != null && className2.trim().length() > 0) {
                ExternalCourseOfferingEditAction editAction = (ExternalCourseOfferingEditAction)Class.forName(className2).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                editAction.performExternalCourseOfferingEditAction(io, hibSession);
            }
        }
        catch (Exception e) {
            try {
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Debug.error(e);
            throw e;
        }
    }

    private void doLoad(Long crsOfferingId) throws Exception {
        if (!this.sessionContext.hasPermission(crsOfferingId, "CourseOffering", Right.EditCourseOfferingNote) && !this.sessionContext.hasPermission(crsOfferingId, "CourseOffering", Right.EditCourseOfferingCoordinators)) {
            this.sessionContext.checkPermission(crsOfferingId, "CourseOffering", Right.EditCourseOffering);
        }
        Long courseOfferingId = (long)crsOfferingId;
        CourseOfferingDAO cdao = CourseOfferingDAO.getInstance();
        final CourseOffering co = (CourseOffering)cdao.get(courseOfferingId);
        InstructionalOffering io = co.getInstructionalOffering();
        Long subjectAreaId = co.getSubjectArea().getUniqueId();
        ((CourseOfferingEditForm)this.form).setDemandCourseOfferingId(co.getDemandOffering() == null ? null : co.getDemandOffering().getUniqueId());
        ((CourseOfferingEditForm)this.form).setAllowDemandCourseOfferings(true);
        ((CourseOfferingEditForm)this.form).setCourseName(co.getCourseName());
        ((CourseOfferingEditForm)this.form).setCourseNbr(co.getCourseNbr());
        ((CourseOfferingEditForm)this.form).setCourseOfferingId(courseOfferingId);
        ((CourseOfferingEditForm)this.form).setInstrOfferingId(io.getUniqueId());
        ((CourseOfferingEditForm)this.form).setScheduleBookNote(co.getScheduleBookNote());
        ((CourseOfferingEditForm)this.form).setNotes(io.getNotes());
        ((CourseOfferingEditForm)this.form).setSubjectAreaId(subjectAreaId);
        ((CourseOfferingEditForm)this.form).setTitle(co.getTitle());
        ((CourseOfferingEditForm)this.form).setIsControl(co.getIsControl());
        ((CourseOfferingEditForm)this.form).setIoNotOffered(io.getNotOffered());
        ((CourseOfferingEditForm)this.form).setByReservationOnly(io.isByReservationOnly());
        ((CourseOfferingEditForm)this.form).setWkEnroll(io.getLastWeekToEnroll() == null ? "" : io.getLastWeekToEnroll().toString());
        ((CourseOfferingEditForm)this.form).setWkEnrollDefault(io.getSession().getLastWeekToEnroll());
        ((CourseOfferingEditForm)this.form).setWkChange(io.getLastWeekToChange() == null ? "" : io.getLastWeekToChange().toString());
        ((CourseOfferingEditForm)this.form).setWkChangeDefault(io.getSession().getLastWeekToChange());
        ((CourseOfferingEditForm)this.form).setWkDrop(io.getLastWeekToDrop() == null ? "" : io.getLastWeekToDrop().toString());
        ((CourseOfferingEditForm)this.form).setWkDropDefault(io.getSession().getLastWeekToDrop());
        ((CourseOfferingEditForm)this.form).setWaitList(io.getWaitlistMode() == null ? "" : io.getWaitListMode().name());
        ((CourseOfferingEditForm)this.form).setWeekStartDayOfWeek(Localization.getDateFormat("EEEE").format(io.getSession().getSessionBeginDateTime()));
        ((CourseOfferingEditForm)this.form).setCourseTypeId(co.getCourseType() == null ? "" : co.getCourseType().getUniqueId().toString());
        ((CourseOfferingEditForm)this.form).setAlternativeCourseOfferingId(co.getAlternativeOffering() == null ? null : co.getAlternativeOffering().getUniqueId());
        ((CourseOfferingEditForm)this.form).setAllowAlternativeCourseOfferings(ApplicationProperty.StudentSchedulingAlternativeCourse.isTrue());
        if (ApplicationProperty.CourseOfferingShowExternalIds.isTrue() || ApplicationProperty.CourseOfferingEditExternalIds.isTrue()) {
            ((CourseOfferingEditForm)this.form).setExternalId(co.getExternalUniqueId());
        }
        if (co.getConsentType() != null) {
            ((CourseOfferingEditForm)this.form).setConsent(co.getConsentType().getUniqueId());
        } else {
            ((CourseOfferingEditForm)this.form).setConsent(-1L);
        }
        LookupTables.setupConsentType(this.request);
        LookupTables.setupCoordinatorTeachingResponsibilities(this.request);
        ArrayList<OfferingCoordinator> coordinatorList = new ArrayList<OfferingCoordinator>(io.getOfferingCoordinators());
        Collections.sort(coordinatorList, new OfferingCoordinatorComparator(this.sessionContext));
        for (OfferingCoordinator coordinator : coordinatorList) {
            ((CourseOfferingEditForm)this.form).getInstructors().add(coordinator.getInstructor().getUniqueId().toString());
            ((CourseOfferingEditForm)this.form).getResponsibilities().add(coordinator.getResponsibility() == null ? Constants.BLANK_OPTION_VALUE : coordinator.getResponsibility().getUniqueId().toString());
            ((CourseOfferingEditForm)this.form).getPercentShares().add(coordinator.getPercentShare() == null ? "0" : coordinator.getPercentShare().toString());
        }
        for (OverrideType override : co.getDisabledOverrides()) {
            ((CourseOfferingEditForm)this.form).addCourseOverride(override.getUniqueId().toString());
        }
        if (this.sessionContext.hasPermission(crsOfferingId, "CourseOffering", Right.EditCourseOfferingCoordinators) || this.sessionContext.hasPermission(crsOfferingId, "CourseOffering", Right.EditCourseOffering)) {
            for (int i = 0; i < 2; ++i) {
                ((CourseOfferingEditForm)this.form).getInstructors().add(Constants.BLANK_OPTION_VALUE);
                ((CourseOfferingEditForm)this.form).getResponsibilities().add(((CourseOfferingEditForm)this.form).getDefaultTeachingResponsibilityId());
            }
        }
        if (((CourseOfferingEditForm)this.form).getCreditFormat() == null && co.getCredit() != null) {
            CourseCreditUnitConfig credit = co.getCredit();
            ((CourseOfferingEditForm)this.form).setCreditText(credit.creditText());
            ((CourseOfferingEditForm)this.form).setCreditFormat(credit.getCreditFormat());
            ((CourseOfferingEditForm)this.form).setCreditType(credit.getCreditType().getUniqueId());
            ((CourseOfferingEditForm)this.form).setCreditUnitType(credit.getCreditUnitType().getUniqueId());
            if (credit instanceof FixedCreditUnitConfig) {
                ((CourseOfferingEditForm)this.form).setUnits(((FixedCreditUnitConfig)credit).getFixedUnits());
            } else if (credit instanceof VariableFixedCreditUnitConfig) {
                ((CourseOfferingEditForm)this.form).setUnits(((VariableFixedCreditUnitConfig)credit).getMinUnits());
                ((CourseOfferingEditForm)this.form).setMaxUnits(((VariableFixedCreditUnitConfig)credit).getMaxUnits());
                if (credit instanceof VariableRangeCreditUnitConfig) {
                    ((CourseOfferingEditForm)this.form).setFractionalIncrementsAllowed(((VariableRangeCreditUnitConfig)credit).isFractionalIncrementsAllowed());
                }
            }
        }
        LookupTables.setupCourseCreditFormats(this.request);
        LookupTables.setupCourseCreditTypes(this.request);
        LookupTables.setupCourseCreditUnitTypes(this.request);
        if (co.isIsControl().booleanValue()) {
            String linkLookupClass = ApplicationProperty.CourseCatalogLinkProvider.value();
            if (linkLookupClass != null && linkLookupClass.trim().length() > 0) {
                ExternalLinkLookup lookup = (ExternalLinkLookup)Class.forName(linkLookupClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Map results = lookup.getLink(io);
                if (results == null) {
                    throw new Exception(lookup.getErrorMessage());
                }
                ((CourseOfferingEditForm)this.form).setCatalogLinkLabel((String)results.get("label"));
                ((CourseOfferingEditForm)this.form).setCatalogLinkLocation((String)results.get("href"));
            }
            HashSet<Long> deptIds = new HashSet<Long>();
            for (OfferingCoordinator coordinator : co.getInstructionalOffering().getOfferingCoordinators()) {
                deptIds.add(coordinator.getInstructor().getDepartment().getUniqueId());
            }
            for (CourseOffering x : co.getInstructionalOffering().getCourseOfferings()) {
                deptIds.add(x.getSubjectArea().getDepartment().getUniqueId());
            }
            Long[] deptsIdsArray = new Long[deptIds.size()];
            int idx = 0;
            for (Long departmentId : deptIds) {
                deptsIdsArray[idx++] = departmentId;
            }
            LookupTables.setupInstructors(this.request, this.sessionContext, deptsIdsArray);
        }
        LookupTables.setupCourseOfferings(this.request, this.sessionContext, new LookupTables.CourseFilter(){

            @Override
            public boolean accept(CourseOffering course) {
                return course.getDemand() != null && course.getDemand() > 0;
            }
        });
        if (ApplicationProperty.StudentSchedulingAlternativeCourse.isTrue()) {
            LookupTables.setupCourseOfferings(this.request, this.sessionContext, new LookupTables.CourseFilter(){

                @Override
                public boolean accept(CourseOffering course) {
                    return course.getInstructionalOffering().isNotOffered() == false && !course.equals(co);
                }
            }, "altOfferingList");
        }
        LookupTables.setupCourseTypes(this.request);
    }

    private void doReload() throws Exception {
        if (((CourseOfferingEditForm)this.form).isAdd()) {
            if (((CourseOfferingEditForm)this.form).getInstrOfferingId() != null && ((CourseOfferingEditForm)this.form).getInstrOfferingId() == 0L) {
                ((CourseOfferingEditForm)this.form).setInstrOfferingId(null);
            }
            if (((CourseOfferingEditForm)this.form).getCourseOfferingId() != null && ((CourseOfferingEditForm)this.form).getCourseOfferingId() == 0L) {
                ((CourseOfferingEditForm)this.form).setCourseOfferingId(null);
            }
            LookupTables.setupConsentType(this.request);
            LookupTables.setupCoordinatorTeachingResponsibilities(this.request);
            LookupTables.setupCourseCreditFormats(this.request);
            LookupTables.setupCourseCreditTypes(this.request);
            LookupTables.setupCourseCreditUnitTypes(this.request);
            LookupTables.setupCourseOfferings(this.request, this.sessionContext, new LookupTables.CourseFilter(){

                @Override
                public boolean accept(CourseOffering course) {
                    return course.getDemand() != null && course.getDemand() > 0;
                }
            });
            if (ApplicationProperty.StudentSchedulingAlternativeCourse.isTrue()) {
                LookupTables.setupCourseOfferings(this.request, this.sessionContext, new LookupTables.CourseFilter(){

                    @Override
                    public boolean accept(CourseOffering course) {
                        return course.getInstructionalOffering().isNotOffered() == false;
                    }
                }, "altOfferingList");
            }
            LookupTables.setupCourseTypes(this.request);
            ArrayList<SubjectArea> subjects = new ArrayList<SubjectArea>();
            boolean found = false;
            for (SubjectArea subject : SubjectArea.getUserSubjectAreas(this.sessionContext.getUser())) {
                if (!this.sessionContext.hasPermission(subject, Right.AddCourseOffering)) continue;
                subjects.add(subject);
                if (!subject.getUniqueId().equals(((CourseOfferingEditForm)this.form).getSubjectAreaId())) continue;
                found = true;
            }
            if (!found && !subjects.isEmpty()) {
                ((CourseOfferingEditForm)this.form).setSubjectAreaId(((SubjectArea)subjects.get(0)).getUniqueId());
            }
            this.request.setAttribute("subjects", subjects);
            if (((CourseOfferingEditForm)this.form).getSubjectAreaId() != null) {
                SubjectArea subject = (SubjectArea)SubjectAreaDAO.getInstance().get(((CourseOfferingEditForm)this.form).getSubjectAreaId());
                LookupTables.setupInstructors(this.request, this.sessionContext, subject.getDepartment().getUniqueId());
            }
            return;
        }
        if (!this.sessionContext.hasPermission(((CourseOfferingEditForm)this.form).getCourseOfferingId(), "CourseOffering", Right.EditCourseOfferingNote) && !this.sessionContext.hasPermission(((CourseOfferingEditForm)this.form).getCourseOfferingId(), "CourseOffering", Right.EditCourseOfferingCoordinators)) {
            this.sessionContext.checkPermission(((CourseOfferingEditForm)this.form).getCourseOfferingId(), "CourseOffering", Right.EditCourseOffering);
        }
        ((CourseOfferingEditForm)this.form).setAllowDemandCourseOfferings(true);
        ((CourseOfferingEditForm)this.form).setAllowAlternativeCourseOfferings(ApplicationProperty.StudentSchedulingAlternativeCourse.isTrue());
        LookupTables.setupConsentType(this.request);
        LookupTables.setupCoordinatorTeachingResponsibilities(this.request);
        LookupTables.setupCourseCreditFormats(this.request);
        LookupTables.setupCourseCreditTypes(this.request);
        LookupTables.setupCourseCreditUnitTypes(this.request);
        final CourseOffering co = (CourseOffering)CourseOfferingDAO.getInstance().get(((CourseOfferingEditForm)this.form).getCourseOfferingId());
        LookupTables.setupCourseOfferings(this.request, this.sessionContext, new LookupTables.CourseFilter(){

            @Override
            public boolean accept(CourseOffering course) {
                return course.getDemand() != null && course.getDemand() > 0;
            }
        });
        if (ApplicationProperty.StudentSchedulingAlternativeCourse.isTrue()) {
            LookupTables.setupCourseOfferings(this.request, this.sessionContext, new LookupTables.CourseFilter(){

                @Override
                public boolean accept(CourseOffering course) {
                    return course.getInstructionalOffering().isNotOffered() == false && !course.equals(co);
                }
            }, "altOfferingList");
        }
        if (co.isIsControl().booleanValue()) {
            HashSet<Long> deptIds = new HashSet<Long>();
            for (OfferingCoordinator coordinator : co.getInstructionalOffering().getOfferingCoordinators()) {
                deptIds.add(coordinator.getInstructor().getDepartment().getUniqueId());
            }
            for (CourseOffering x : co.getInstructionalOffering().getCourseOfferings()) {
                deptIds.add(x.getSubjectArea().getDepartment().getUniqueId());
            }
            Long[] deptsIdsArray = new Long[deptIds.size()];
            int idx = 0;
            for (Long departmentId : deptIds) {
                deptsIdsArray[idx++] = departmentId;
            }
            LookupTables.setupInstructors(this.request, this.sessionContext, deptsIdsArray);
        }
    }

    protected Permission<InstructionalOffering> getPermissionOfferingLockNeeded() {
        return this.getPermission("permissionOfferingLockNeeded");
    }

    public String getCrsNbr() {
        return (String)this.sessionContext.getAttribute(SessionAttribute.OfferingsCourseNumber);
    }
}

