/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.termination;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.termination.TerminationCondition;
import org.cpsolver.ifs.util.DataProperties;

public class GeneralTerminationCondition<V extends Variable<V, T>, T extends Value<V, T>>
implements TerminationCondition<V, T> {
    protected static Logger sLogger = LogManager.getLogger(GeneralTerminationCondition.class);
    private int iMaxIter;
    private double iTimeOut;
    private boolean iStopWhenComplete;

    public GeneralTerminationCondition(DataProperties properties) {
        this.iMaxIter = properties.getPropertyInt("Termination.MaxIters", -1);
        this.iTimeOut = properties.getPropertyDouble("Termination.TimeOut", -1.0);
        this.iStopWhenComplete = properties.getPropertyBoolean("Termination.StopWhenComplete", false);
    }

    @Override
    public boolean canContinue(Solution<V, T> currentSolution) {
        if (this.iMaxIter >= 0 && currentSolution.getIteration() >= (long)this.iMaxIter) {
            sLogger.info("Maximum number of iteration reached.");
            return false;
        }
        if (this.iTimeOut >= 0.0 && currentSolution.getTime() > this.iTimeOut) {
            sLogger.info("Timeout reached.");
            return false;
        }
        if (this.iStopWhenComplete || this.iMaxIter < 0 && this.iTimeOut < 0.0) {
            boolean ret;
            boolean bl = ret = currentSolution.getAssignment().nrUnassignedVariables(currentSolution.getModel()) != 0;
            if (!ret) {
                sLogger.info("Complete solution found.");
            }
            return ret;
        }
        return true;
    }
}

