/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.heuristics;

import java.util.ArrayList;
import java.util.List;

public class HeuristicSelector<E> {
    private double[] iThreshKoef;
    private List<Element> iElements = new ArrayList<Element>();
    private double iBestValueZero = 0.0;

    public HeuristicSelector(double[] threshKoef) {
        this.iThreshKoef = threshKoef;
    }

    public boolean add(double[] values, E object) {
        if (this.iElements.isEmpty() || values[0] < this.iBestValueZero) {
            this.iBestValueZero = values[0];
            this.iElements.add(new Element(values, object));
            return true;
        }
        double d = values[0];
        double d2 = this.iBestValueZero < 0.0 ? 1.0 - this.iThreshKoef[0] : 1.0 + this.iThreshKoef[0];
        if (d <= this.iBestValueZero * d2) {
            this.iElements.add(new Element(values, object));
            return true;
        }
        return false;
    }

    public Double firstLevelThreshold() {
        return this.iElements.isEmpty() ? null : Double.valueOf(this.iBestValueZero * (this.iBestValueZero < 0.0 ? 1.0 - this.iThreshKoef[0] : 1.0 + this.iThreshKoef[0]));
    }

    public List<Element> selection() {
        List<Element> selection = this.iElements;
        double bestValue = this.iBestValueZero;
        for (int level = 0; level < this.iThreshKoef.length; ++level) {
            ArrayList<Element> x = new ArrayList<Element>(selection.size());
            double threshold = (bestValue < 0.0 ? 1.0 - this.iThreshKoef[level] : 1.0 + this.iThreshKoef[level]) * bestValue;
            double nextBestValue = 0.0;
            boolean lastLevel = level + 1 == this.iThreshKoef.length;
            for (Element element : selection) {
                if (!(element.getValue(level) <= threshold)) continue;
                if (!lastLevel && (x.isEmpty() || element.getValue(level + 1) < nextBestValue)) {
                    nextBestValue = element.getValue(level + 1);
                }
                x.add(element);
            }
            selection = x;
            bestValue = nextBestValue;
        }
        return selection;
    }

    public class Element {
        private double[] iValues;
        private E iObject;

        private Element(double[] values, E object) {
            this.iValues = values;
            this.iObject = object;
        }

        public double[] getValues() {
            return this.iValues;
        }

        public double getValue(int level) {
            return this.iValues[level];
        }

        public E getObject() {
            return this.iObject;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.iValues.length; ++i) {
                sb.append(i == 0 ? "" : ",").append(this.iValues[i]);
            }
            return "[" + sb + "]:" + this.iObject;
        }
    }
}

