/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.webutil.timegrid;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.awt.Color;
import java.io.OutputStream;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.unitime.timetable.form.ExamGridForm;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.util.PdfEventHandler;
import org.unitime.timetable.util.PdfFont;
import org.unitime.timetable.webutil.timegrid.ExamGridTable;

public class PdfExamGridTable
extends ExamGridTable {
    private Document iDocument = null;
    private PdfPTable iPdfTable = null;
    private static Color sBorderColor = new Color(100, 100, 100);

    public PdfExamGridTable(ExamGridForm form, SessionContext context, ExamSolverProxy solver) throws Exception {
        super(form, context, solver);
    }

    public void export(OutputStream out) throws Exception {
        int nrCols = this.getNrColumns();
        this.iDocument = this.iForm.getDispMode() == ExamGridTable.DispMode.InRowHorizontal.ordinal() || this.iForm.getDispMode() == ExamGridTable.DispMode.InRowVertical.ordinal() ? new Document(new Rectangle(Math.max(PageSize.LETTER.getWidth(), 60.0f + 100.0f * (float)nrCols), Math.max(PageSize.LETTER.getHeight(), 60.0f + 150.0f * (float)nrCols)).rotate(), 30.0f, 30.0f, 30.0f, 30.0f) : new Document(new Rectangle(Math.max(PageSize.LETTER.getWidth(), 60.0f + 100.0f * (float)nrCols), Math.max(PageSize.LETTER.getHeight(), 60.0f + 150.0f * (float)nrCols)), 30.0f, 30.0f, 30.0f, 30.0f);
        PdfEventHandler.initFooter(this.iDocument, out);
        this.iDocument.open();
        this.printTable();
        this.printLegend();
        this.iDocument.close();
    }

    public int getNrColumns() {
        if (this.iForm.getDispMode() == ExamGridTable.DispMode.InRowHorizontal.ordinal()) {
            return 1 + this.days().size() * this.slots().size();
        }
        if (this.iForm.getDispMode() == ExamGridTable.DispMode.InRowVertical.ordinal()) {
            return 1 + this.models().size();
        }
        if (this.iForm.getDispMode() == ExamGridTable.DispMode.PerDayHorizontal.ordinal()) {
            return 1 + this.slots().size();
        }
        if (this.iForm.getDispMode() == ExamGridTable.DispMode.PerDayVertical.ordinal()) {
            return 1 + this.days().size();
        }
        if (this.iForm.getDispMode() == ExamGridTable.DispMode.PerWeekHorizontal.ordinal()) {
            return 1 + this.weeks().size() * this.slots().size();
        }
        if (this.iForm.getDispMode() == ExamGridTable.DispMode.PerWeekVertical.ordinal()) {
            return 1 + this.daysOfWeek().size();
        }
        return 0;
    }

    public PdfPCell createCell() {
        PdfPCell cell = new PdfPCell();
        cell.setBorderColor(sBorderColor);
        cell.setPadding(3.0f);
        cell.setBorderWidth(0.0f);
        cell.setVerticalAlignment(4);
        cell.setHorizontalAlignment(1);
        cell.setBorderWidthTop(1.0f);
        cell.setBorderWidthBottom(1.0f);
        cell.setBorderWidthLeft(1.0f);
        cell.setBorderWidthRight(1.0f);
        return cell;
    }

    public PdfPCell createCellNoBorder() {
        PdfPCell cell = new PdfPCell();
        cell.setBorderColor(sBorderColor);
        cell.setPadding(3.0f);
        cell.setBorderWidth(0.0f);
        cell.setVerticalAlignment(4);
        cell.setHorizontalAlignment(1);
        return cell;
    }

    public void addText(PdfPCell cell, String text) {
        if (text == null) {
            return;
        }
        this.addText(cell, text, false);
    }

    public void addText(PdfPCell cell, String text, boolean bold) {
        if (text == null) {
            return;
        }
        if (text.indexOf("<span") >= 0) {
            text = text.replaceAll("</span>", "").replaceAll("<span .*>", "");
        }
        text = text.replaceAll("<br>", "\n");
        text = text.replaceAll("<BR>", "\n");
        if (cell.getPhrase() == null) {
            cell.setPhrase((Phrase)new Paragraph(text, PdfFont.getFont(bold)));
            cell.setVerticalAlignment(4);
            cell.setHorizontalAlignment(1);
        } else {
            cell.getPhrase().add((Object)new Chunk("\n" + text, PdfFont.getFont(bold)));
        }
    }

    public void printHeaderCell(String name, boolean vertical, boolean eod, boolean eol) {
        PdfPCell c = this.createCell();
        if (!eol && !eod) {
            c.setBorderWidthRight(0.0f);
        }
        if (name == null) {
            c.setBorderWidthLeft(0.0f);
            c.setBorderWidthTop(0.0f);
            c.setBorderWidthBottom(0.0f);
        } else {
            this.addText(c, name);
        }
        this.iPdfTable.addCell(c);
    }

    public void printHeader(String name) throws Exception {
        boolean vertical = this.isVertical();
        this.printHeaderCell(name, vertical, false, false);
        TreeSet<Integer> days = this.days();
        TreeSet<Integer> slots = this.slots();
        TreeSet<Integer> weeks = this.weeks();
        TreeSet<Integer> daysOfWeek = this.daysOfWeek();
        if (this.iForm.getDispMode() == ExamGridTable.DispMode.InRowHorizontal.ordinal()) {
            for (Integer day : days) {
                for (Integer slot : this.slots()) {
                    boolean eod = slot == slots.last();
                    boolean eol = eod && day == days.last();
                    this.printHeaderCell(this.getDayName(day) + "<br>" + this.getSlotName(slot), vertical, eod, eol);
                }
            }
        } else if (this.iForm.getDispMode() == ExamGridTable.DispMode.InRowVertical.ordinal()) {
            for (ExamGridTable.ExamGridModel m : this.models()) {
                boolean eol = m.equals(this.models().lastElement());
                this.printHeaderCell(m.getName() + (String)(m.getSize() > 0 ? " (" + m.getSize() + ")" : ""), vertical, false, eol);
            }
        } else if (this.iForm.getDispMode() == ExamGridTable.DispMode.PerDayHorizontal.ordinal()) {
            for (Integer slot : this.slots()) {
                boolean eol = slot == slots.last();
                this.printHeaderCell(this.getSlotName(slot) + "<br> ", vertical, false, eol);
            }
        } else if (this.iForm.getDispMode() == ExamGridTable.DispMode.PerDayVertical.ordinal()) {
            for (Integer day : days) {
                boolean eol = day == days.last();
                this.printHeaderCell(this.getDayName(day) + "<br> ", vertical, false, eol);
            }
        } else if (this.iForm.getDispMode() == ExamGridTable.DispMode.PerWeekHorizontal.ordinal()) {
            for (Integer week : weeks) {
                for (Integer slot : slots) {
                    boolean eod = slot == slots.last();
                    boolean eol = eod && week == weeks.last();
                    this.printHeaderCell(this.getWeekName(week) + "<br>" + this.getSlotName(slot), vertical, eod, eol);
                }
            }
        } else if (this.iForm.getDispMode() == ExamGridTable.DispMode.PerWeekVertical.ordinal()) {
            for (Integer dow : daysOfWeek) {
                boolean eol = dow == daysOfWeek.last();
                this.printHeaderCell(this.getDayOfWeekName(dow) + "<br> ", vertical, false, eol);
            }
        }
        this.iPdfTable.setHeaderRows(1);
    }

    private Color getColor(String rgbColor) {
        StringTokenizer x = new StringTokenizer(rgbColor.substring("rgb(".length(), rgbColor.length() - ")".length()), ",");
        return new Color(Integer.parseInt(x.nextToken()), Integer.parseInt(x.nextToken()), Integer.parseInt(x.nextToken()));
    }

    private void createTable(boolean keepTogether) {
        this.iPdfTable = new PdfPTable(this.getNrColumns());
        this.iPdfTable.setWidthPercentage(100.0f);
        this.iPdfTable.getDefaultCell().setPadding(3.0f);
        this.iPdfTable.getDefaultCell().setBorderWidth(1.0f);
        this.iPdfTable.setSplitRows(false);
        this.iPdfTable.setSpacingBefore(10.0f);
        this.iPdfTable.setKeepTogether(keepTogether);
    }

    private void flushTable() throws Exception {
        if (this.iPdfTable != null) {
            this.iDocument.add((Element)this.iPdfTable);
        }
        this.iPdfTable = null;
    }

    public void printCell(ExamGridTable.ExamGridModel model, int day, int slot, int idx, int maxIdx, boolean head, boolean vertical, boolean in, boolean eod, boolean eol) {
        ExamPeriod period = this.getPeriod(day, slot);
        ExamGridTable.ExamGridModel.ExamGridCell cell = model.getAssignment(period, idx);
        PdfPCell c = this.createCell();
        c.setBorderWidthTop(head || !in && !vertical ? 1.0f : 0.0f);
        c.setBorderWidthRight(eod || eol ? 1.0f : 0.0f);
        if (cell == null) {
            String bgColor = model.getBackground(period);
            if (bgColor == null && !model.isAvailable(period)) {
                bgColor = sBgColorNotAvailable;
            }
            if (period == null) {
                bgColor = sBgColorNotAvailable;
            }
            if (bgColor != null) {
                c.setBackgroundColor(this.getColor(bgColor));
            }
            c.setBorderWidthBottom(idx < maxIdx ? 0.0f : 1.0f);
            this.addText(c, " ");
        } else {
            String bgColor = cell.getBackground();
            if (this.iForm.getBackground() == ExamGridTable.Background.None.ordinal() && !sBgColorNotAvailable.equals(bgColor) && !model.isAvailable(period)) {
                bgColor = sBgColorNotAvailableButAssigned;
            }
            if (bgColor != null) {
                c.setBackgroundColor(this.getColor(bgColor));
            }
            this.addText(c, cell.getName());
            if (this.iForm.getResource() != ExamGridTable.Resource.Room.ordinal()) {
                this.addText(c, cell.getRoomName());
            } else {
                this.addText(c, cell.getShortCommentNoColors() == null ? "" : cell.getShortCommentNoColors());
            }
        }
        this.iPdfTable.addCell(c);
    }

    public void printRowHeaderCell(String name, int idx, int maxIdx, boolean vertical, boolean head, boolean in) {
        PdfPCell c = this.createCell();
        c.setBorderWidthTop(idx == 0 && (head || !in && !vertical) ? 1.0f : 0.0f);
        c.setBorderWidthBottom(idx < maxIdx ? 0.0f : 1.0f);
        c.setBorderWidthRight(0.0f);
        if (idx == 0) {
            this.addText(c, name);
        }
        this.iPdfTable.addCell(c);
    }

    public void printTable() throws Exception {
        boolean vertical = this.isVertical();
        TreeSet<Integer> days = this.days();
        TreeSet<Integer> slots = this.slots();
        TreeSet<Integer> weeks = this.weeks();
        TreeSet<Integer> daysOfWeek = this.daysOfWeek();
        int rowNumber = 0;
        if (this.iForm.getDispMode() == ExamGridTable.DispMode.InRowVertical.ordinal()) {
            int globalMaxIdx = 0;
            for (Integer n : days) {
                for (Integer slot : slots) {
                    globalMaxIdx = Math.max(globalMaxIdx, this.getMaxIdx(n, slot));
                }
            }
            int week = -1;
            for (Integer day : days) {
                boolean head = false;
                if (week != this.getWeek(day)) {
                    week = this.getWeek(day);
                    head = true;
                    this.flushTable();
                    this.createTable(true);
                    this.printHeader(this.getWeekName(week));
                }
                for (Integer slot : slots) {
                    if (this.getPeriod(day, slot) == null) continue;
                    int maxIdx = this.getMaxIdx(day, slot);
                    for (int idx = 0; idx <= maxIdx; ++idx) {
                        this.printRowHeaderCell(this.getDayName(day) + "<br>" + this.getSlotName(slot), idx, maxIdx, vertical, head && slot == slots.first(), globalMaxIdx == 0);
                        for (ExamGridTable.ExamGridModel model : this.models()) {
                            this.printCell(model, day, slot, idx, maxIdx, head && slot == slots.first() && idx == 0, vertical, globalMaxIdx == 0 || idx > 0, false, model.equals(this.models().lastElement()));
                        }
                    }
                    ++rowNumber;
                }
            }
        } else {
            int tmx = 0;
            for (ExamGridTable.ExamGridModel examGridModel : this.models()) {
                tmx = Math.max(tmx, this.getMaxIdx(examGridModel, days.first(), days.last(), slots.first(), slots.last()));
            }
            for (ExamGridTable.ExamGridModel examGridModel : this.models()) {
                int gmx;
                if (this.iForm.getDispMode() == ExamGridTable.DispMode.InRowHorizontal.ordinal()) {
                    if (rowNumber == 0) {
                        this.createTable(false);
                        this.printHeader(null);
                    }
                    int maxIdx = this.getMaxIdx(examGridModel, days.first(), days.last(), slots.first(), slots.last());
                    for (int idx = 0; idx <= maxIdx; ++idx) {
                        this.printRowHeaderCell(examGridModel.getName() + (String)(examGridModel.getSize() > 0 ? " (" + examGridModel.getSize() + ")" : "") + "<br> ", idx, maxIdx, vertical, rowNumber % 10 == 0, tmx == 0);
                        for (Integer day : days) {
                            for (Integer slot : slots) {
                                boolean eod = slot == slots.last();
                                boolean eol = eod && day == days.last();
                                this.printCell(examGridModel, day, slot, idx, maxIdx, rowNumber % 10 == 0 && idx == 0, vertical, tmx == 0 || idx > 0, eod, eol);
                            }
                        }
                    }
                } else if (this.iForm.getDispMode() == ExamGridTable.DispMode.PerDayVertical.ordinal()) {
                    this.flushTable();
                    this.createTable(true);
                    this.printHeader(this.getModelName(examGridModel));
                    gmx = this.getMaxIdx(examGridModel, days.first(), days.last(), slots.first(), slots.last());
                    for (Integer slot : slots) {
                        int maxIdx = this.getMaxIdx(examGridModel, days.first(), days.last(), slot, slot);
                        for (int idx = 0; idx <= maxIdx; ++idx) {
                            this.printRowHeaderCell(this.getSlotName(slot) + "<br> ", idx, maxIdx, vertical, slot == slots.first(), gmx == 0);
                            for (Integer day : days) {
                                this.printCell(examGridModel, day, slot, idx, maxIdx, slot == slots.first() && idx == 0, vertical, gmx == 0 || idx > 0, false, day == days.last());
                            }
                        }
                    }
                } else if (this.iForm.getDispMode() == ExamGridTable.DispMode.PerDayHorizontal.ordinal()) {
                    this.flushTable();
                    this.createTable(true);
                    this.printHeader(this.getModelName(examGridModel));
                    gmx = this.getMaxIdx(examGridModel, days.first(), days.last(), slots.first(), slots.last());
                    for (Integer day : days) {
                        int maxIdx = this.getMaxIdx(examGridModel, day, day, slots.first(), slots.last());
                        for (int idx = 0; idx <= maxIdx; ++idx) {
                            this.printRowHeaderCell(this.getDayName(day) + "<br> ", idx, maxIdx, vertical, day == days.first(), gmx == 0);
                            for (Integer slot : slots) {
                                this.printCell(examGridModel, day, slot, idx, maxIdx, day == days.first() && idx == 0, vertical, gmx == 0 || idx > 0, false, slot == slots.last());
                            }
                        }
                    }
                } else if (this.iForm.getDispMode() == ExamGridTable.DispMode.PerWeekHorizontal.ordinal()) {
                    this.flushTable();
                    this.createTable(true);
                    this.printHeader(this.getModelName(examGridModel));
                    gmx = this.getMaxIdx(examGridModel, days.first(), days.last(), slots.first(), slots.last());
                    for (Integer dow : this.daysOfWeek()) {
                        int maxIdx = this.getMaxIdx(examGridModel, dow, slots.first(), slots.last());
                        for (int idx = 0; idx <= maxIdx; ++idx) {
                            this.printRowHeaderCell(this.getDayOfWeekName(dow) + "<br> ", idx, maxIdx, vertical, dow == daysOfWeek.first(), gmx == 0);
                            for (Integer week : weeks) {
                                for (Integer slot : slots) {
                                    this.printCell(examGridModel, this.getDay(week, dow), slot, idx, maxIdx, dow == daysOfWeek.first() && idx == 0, vertical, gmx == 0 || idx > 0, slot == slots.last(), slot == slots.last() && week == weeks.last());
                                }
                            }
                        }
                    }
                } else if (this.iForm.getDispMode() == ExamGridTable.DispMode.PerWeekVertical.ordinal()) {
                    this.flushTable();
                    this.createTable(true);
                    this.printHeader(this.getModelName(examGridModel));
                    gmx = this.getMaxIdx(examGridModel, days.first(), days.last(), slots.first(), slots.last());
                    for (Integer week : weeks) {
                        for (Integer slot : slots) {
                            int maxIdx = this.getMaxIdx(examGridModel, week, slot);
                            for (int idx = 0; idx <= maxIdx; ++idx) {
                                this.printRowHeaderCell(this.getWeekName(week) + "<br>" + this.getSlotName(slot), idx, maxIdx, vertical, slot == slots.first(), gmx == 0);
                                for (Integer dow : daysOfWeek) {
                                    this.printCell(examGridModel, this.getDay(week, dow), slot, idx, maxIdx, slot == slots.first() && idx == 0, vertical, gmx == 0 || idx > 0, false, dow == daysOfWeek.last());
                                }
                            }
                        }
                    }
                }
                ++rowNumber;
            }
        }
        this.flushTable();
    }

    private void addLegendRow(String color, String text) {
        PdfPCell c = this.createCellNoBorder();
        c.setBorderWidth(1.0f);
        c.setBackgroundColor(this.getColor(color));
        this.iPdfTable.addCell(c);
        c = this.createCellNoBorder();
        this.addText(c, "  " + text);
        c.setHorizontalAlignment(0);
        this.iPdfTable.addCell(c);
    }

    public void printLegend() throws Exception {
        PdfPCell c;
        this.iPdfTable = new PdfPTable(2);
        this.iPdfTable.setWidths(new float[]{10.0f, 200.0f});
        this.iPdfTable.getDefaultCell().setPadding(3.0f);
        this.iPdfTable.getDefaultCell().setBorderWidth(1.0f);
        this.iPdfTable.setHorizontalAlignment(0);
        this.iPdfTable.setSplitRows(false);
        this.iPdfTable.setSpacingBefore(10.0f);
        this.iPdfTable.setKeepTogether(true);
        if (this.iForm.getBackground() != ExamGridTable.Background.None.ordinal()) {
            c = this.createCellNoBorder();
            c.setColspan(2);
            this.addText(c, MSG.propAssignedExaminations());
            c.setHorizontalAlignment(0);
            this.iPdfTable.addCell(c);
        }
        if (this.iForm.getBackground() == ExamGridTable.Background.PeriodPref.ordinal()) {
            this.addLegendRow(PdfExamGridTable.pref2color(PreferenceLevel.sRequired), MSG.legendRequiredPeriod());
            this.addLegendRow(PdfExamGridTable.pref2color(PreferenceLevel.sStronglyPreferred), MSG.legendStronglyPreferredPeriod());
            this.addLegendRow(PdfExamGridTable.pref2color(PreferenceLevel.sPreferred), MSG.legendPreferredPeriod());
            this.addLegendRow(PdfExamGridTable.pref2color(PreferenceLevel.sNeutral), MSG.legendNoPeriodPreference());
            this.addLegendRow(PdfExamGridTable.pref2color(PreferenceLevel.sDiscouraged), MSG.legendDiscouragedPeriod());
            this.addLegendRow(PdfExamGridTable.pref2color(PreferenceLevel.sStronglyDiscouraged), MSG.legendStronglyDiscouragedPeriod());
            this.addLegendRow(PdfExamGridTable.pref2color(PreferenceLevel.sProhibited), MSG.legendProhibitedPeriod());
        } else if (this.iForm.getBackground() == ExamGridTable.Background.RoomPref.ordinal()) {
            this.addLegendRow(PdfExamGridTable.pref2color(PreferenceLevel.sRequired), MSG.legendRequiredRoom());
            this.addLegendRow(PdfExamGridTable.pref2color(PreferenceLevel.sStronglyPreferred), MSG.legendStronglyPreferredRoom());
            this.addLegendRow(PdfExamGridTable.pref2color(PreferenceLevel.sPreferred), MSG.legendPreferredRoom());
            this.addLegendRow(PdfExamGridTable.pref2color(PreferenceLevel.sNeutral), MSG.legendNoRoomPreference());
            this.addLegendRow(PdfExamGridTable.pref2color(PreferenceLevel.sDiscouraged), MSG.legendDiscouragedRoom());
            this.addLegendRow(PdfExamGridTable.pref2color(PreferenceLevel.sStronglyDiscouraged), MSG.legendStronglyDiscouragedRoom());
            this.addLegendRow(PdfExamGridTable.pref2color(PreferenceLevel.sProhibited), MSG.legendProhibitedRoom());
        } else if (this.iForm.getBackground() == ExamGridTable.Background.InstructorConfs.ordinal()) {
            this.addLegendRow(PdfExamGridTable.pref2color(PreferenceLevel.sNeutral), MSG.legendNoInstructorConflict());
            this.addLegendRow(PdfExamGridTable.pref2color(PreferenceLevel.sDiscouraged), MSG.legendOneOrMoreInstructorBackToBackConflicts());
            this.addLegendRow(PdfExamGridTable.pref2color(PreferenceLevel.sStronglyDiscouraged), MSG.legendOneOrMoreInstructorThreeOrMoreExamsADayConflicts());
            this.addLegendRow(PdfExamGridTable.pref2color(PreferenceLevel.sProhibited), MSG.legendOneOrMoreInstructorDirectConflicts());
        } else if (this.iForm.getBackground() == ExamGridTable.Background.StudentConfs.ordinal()) {
            this.addLegendRow(PdfExamGridTable.pref2color(PreferenceLevel.sNeutral), MSG.legendNoStudentConflict());
            this.addLegendRow(PdfExamGridTable.pref2color(PreferenceLevel.sDiscouraged), MSG.legendOneOrMoreStudentBackToBackConflicts());
            this.addLegendRow(PdfExamGridTable.pref2color(PreferenceLevel.sStronglyDiscouraged), MSG.legendOneOrMoreStudentThreeOrMoreExamsADayStudentConflicts());
            this.addLegendRow(PdfExamGridTable.pref2color(PreferenceLevel.sProhibited), MSG.legendOneOrMoreStudentDirectConflicts());
        } else if (this.iForm.getBackground() == ExamGridTable.Background.DirectInstructorConfs.ordinal()) {
            for (int nrConflicts = 0; nrConflicts <= 6; ++nrConflicts) {
                String color = PdfExamGridTable.lessConflicts2color(nrConflicts);
                this.addLegendRow(color, MSG.legendInstructorConflicts(nrConflicts + (String)(nrConflicts == 6 ? " " + MSG.legendOrMore() : "")));
            }
        } else if (this.iForm.getBackground() == ExamGridTable.Background.MoreThanTwoADayInstructorConfs.ordinal()) {
            for (int nrConflicts = 0; nrConflicts <= 15; ++nrConflicts) {
                String color = PdfExamGridTable.conflicts2color(nrConflicts);
                this.addLegendRow(color, MSG.legendInstructorMoreThanTwoExamsADayConflicts(nrConflicts + (String)(nrConflicts == 15 ? " " + MSG.legendOrMore() : "")));
            }
        } else if (this.iForm.getBackground() == ExamGridTable.Background.BackToBackInstructorConfs.ordinal()) {
            for (int nrConflicts = 0; nrConflicts <= 15; ++nrConflicts) {
                String color = PdfExamGridTable.conflicts2color(nrConflicts);
                this.addLegendRow(color, MSG.legendInstructorBackToBackConflicts(nrConflicts + (String)(nrConflicts == 15 ? " " + MSG.legendOrMore() : "")));
            }
        } else if (this.iForm.getBackground() == ExamGridTable.Background.DirectStudentConfs.ordinal()) {
            for (int nrConflicts = 0; nrConflicts <= 6; ++nrConflicts) {
                String color = PdfExamGridTable.lessConflicts2color(nrConflicts);
                this.addLegendRow(color, MSG.legendStudentDirectConflicts(nrConflicts + (String)(nrConflicts == 6 ? " " + MSG.legendOrMore() : "")));
            }
        } else if (this.iForm.getBackground() == ExamGridTable.Background.MoreThanTwoADayStudentConfs.ordinal()) {
            for (int nrConflicts = 0; nrConflicts <= 15; ++nrConflicts) {
                String color = PdfExamGridTable.conflicts2color(nrConflicts);
                this.addLegendRow(color, MSG.legendStudentMoreThanTwoExamsADayConflicts(nrConflicts + (String)(nrConflicts == 15 ? " " + MSG.legendOrMore() : "")));
            }
        } else if (this.iForm.getBackground() == ExamGridTable.Background.BackToBackStudentConfs.ordinal()) {
            for (int nrConflicts = 0; nrConflicts <= 15; ++nrConflicts) {
                String color = PdfExamGridTable.conflicts2color(nrConflicts);
                this.addLegendRow(color, MSG.legendStudentBackToBackConflicts(nrConflicts + (String)(nrConflicts == 15 ? " " + MSG.legendOrMore() : "")));
            }
        } else if (this.iForm.getBackground() == ExamGridTable.Background.DistPref.ordinal()) {
            this.addLegendRow(PdfExamGridTable.pref2color(PreferenceLevel.sNeutral), MSG.legendNoViloatedDistributionConstraint());
            this.addLegendRow(PdfExamGridTable.pref2color(PreferenceLevel.sDiscouraged), MSG.legendDiscouragedOrPreferredDistributionConstraintViolated());
            this.addLegendRow(PdfExamGridTable.pref2color(PreferenceLevel.sStronglyDiscouraged), MSG.legendStronglyDiscouragedOrPreferredDistributionConstraintViolated());
            this.addLegendRow(PdfExamGridTable.pref2color(PreferenceLevel.sProhibited), MSG.legendRequiredOrProhibitedDistributionConstraintViolated());
        }
        c = this.createCellNoBorder();
        c.setColspan(2);
        this.addText(c, MSG.propFreeTimes());
        c.setHorizontalAlignment(0);
        this.iPdfTable.addCell(c);
        this.addLegendRow(sBgColorNotAvailable, MSG.legendPeriodNotAvailable());
        if (this.iForm.getBgPreferences() && this.iForm.getBackground() == ExamGridTable.Background.PeriodPref.ordinal()) {
            this.addLegendRow(PdfExamGridTable.pref2color(PreferenceLevel.sStronglyPreferred), MSG.legendStronglyPreferredPeriod());
            this.addLegendRow(PdfExamGridTable.pref2color(PreferenceLevel.sPreferred), MSG.legendNoPeriodPreference());
        }
        this.addLegendRow(PdfExamGridTable.pref2color(PreferenceLevel.sNeutral), MSG.legendNoPeriodPreference());
        if (this.iForm.getBgPreferences() && this.iForm.getBackground() == ExamGridTable.Background.PeriodPref.ordinal()) {
            this.addLegendRow(PdfExamGridTable.pref2color(PreferenceLevel.sDiscouraged), MSG.legendDiscouragedPeriod());
            this.addLegendRow(PdfExamGridTable.pref2color(PreferenceLevel.sStronglyDiscouraged), MSG.legendStronglyPreferredPeriod());
            this.addLegendRow(PdfExamGridTable.pref2color(PreferenceLevel.sProhibited), MSG.legendProhibitedPeriod());
        }
        this.iDocument.add((Element)this.iPdfTable);
    }
}

