/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.tags;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.unitime.commons.Debug;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Curriculum;
import org.unitime.timetable.model.DepartmentRoomFeature;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.GlobalRoomFeature;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.context.HttpSessionContext;

public class LastChange
extends BodyTagSupport {
    private static final long serialVersionUID = -983949265164022751L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    protected static final GwtMessages GWT = Localization.create(GwtMessages.class);
    private String iPackage = "org.unitime.timetable.model";
    private String iType = null;
    private String iId = null;
    private String iSource = null;

    public void setType(String type) {
        this.iType = type;
    }

    public String getType() {
        return this.iType;
    }

    public void setId(String id) {
        this.iId = id;
    }

    public String getId() {
        return this.iId;
    }

    public void setPackage(String packageStr) {
        this.iPackage = packageStr;
    }

    public String getPackage() {
        return this.iPackage;
    }

    public void setSource(String source) {
        this.iSource = source;
    }

    public String getSource() {
        return this.iSource;
    }

    public int doStartTag() throws JspException {
        return 2;
    }

    public SessionContext getSessionContext() {
        return HttpSessionContext.getSessionContext(this.pageContext.getServletContext());
    }

    private int printLastChangeTableRow(WebTable webTable, ChangeLog lastChange) {
        if (lastChange == null) {
            return 0;
        }
        webTable.addLine(null, new String[]{lastChange.getSourceTitle(), lastChange.getObjectTitle(), lastChange.getOperationTitle(), lastChange.getManager().getShortName(), ChangeLog.sDF.format(lastChange.getTimeStamp())}, new Comparable[]{lastChange.getSourceTitle(), lastChange.getObjectTitle(), Integer.valueOf(lastChange.getOperation().ordinal()), lastChange.getManager().getName(), Long.valueOf(lastChange.getTimeStamp().getTime())});
        return 1;
    }

    private static ChangeLog combine(ChangeLog c1, ChangeLog c2) {
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        return c1.compareTo(c2) < 0 ? c2 : c1;
    }

    public boolean printLastChange(InstructionalOffering io) throws IOException {
        if (io == null) {
            return false;
        }
        int nrChanges = 0;
        WebTable.setOrder(this.getSessionContext(), "lastChanges.ord", this.pageContext.getRequest().getParameter("lcord"), 5);
        WebTable webTable = new WebTable(5, MSG.columnLastChanges(), "instructionalOfferingDetail.action?io=" + io.getUniqueId() + "&lcord=%%", new String[]{MSG.columnPage(), MSG.columnObject(), MSG.columnOperation(), MSG.columnManager(), MSG.columnDate()}, new String[]{"left", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, false});
        HashSet<Long> configIds = new HashSet<Long>();
        HashSet<Long> subpartIds = new HashSet<Long>();
        HashSet<Long> classIds = new HashSet<Long>();
        HashSet<Long> offeringIds = new HashSet<Long>();
        HashSet<Long> curriculumIds = new HashSet<Long>();
        for (InstrOfferingConfig ioc : io.getInstrOfferingConfigs()) {
            configIds.add(ioc.getUniqueId());
            for (SchedulingSubpart ss : ioc.getSchedulingSubparts()) {
                subpartIds.add(ss.getUniqueId());
                for (Class_ c : ss.getClasses()) {
                    classIds.add(c.getUniqueId());
                }
            }
        }
        for (CourseOffering o : io.getCourseOfferings()) {
            offeringIds.add(o.getUniqueId());
        }
        curriculumIds.addAll(InstructionalOfferingDAO.getInstance().getSession().createQuery("select c.classification.curriculum.uniqueId from CurriculumCourse c where c.course.instructionalOffering.uniqueId = :offeringId", Long.class).setParameter("offeringId", (Object)io.getUniqueId()).setCacheable(true).list());
        nrChanges += this.printLastChangeTableRow(webTable, ChangeLog.findLastChange(io, ChangeLog.Source.CROSS_LIST));
        nrChanges += this.printLastChangeTableRow(webTable, LastChange.combine(ChangeLog.findLastChange(io, ChangeLog.Source.MAKE_OFFERED), ChangeLog.findLastChange(io, ChangeLog.Source.MAKE_NOT_OFFERED)));
        nrChanges += this.printLastChangeTableRow(webTable, ChangeLog.findLastChange(CourseOffering.class.getName(), offeringIds, ChangeLog.Source.COURSE_OFFERING_EDIT));
        nrChanges += this.printLastChangeTableRow(webTable, LastChange.combine(ChangeLog.findLastChange(InstructionalOffering.class.getName(), io.getUniqueId(), ChangeLog.Source.RESERVATION), ChangeLog.findLastChange(Class_.class.getName(), classIds, ChangeLog.Source.RESERVATION)));
        nrChanges += this.printLastChangeTableRow(webTable, LastChange.combine(ChangeLog.findLastChange(io, ChangeLog.Source.INSTR_CFG_EDIT), ChangeLog.findLastChange(InstrOfferingConfig.class.getName(), configIds, ChangeLog.Source.INSTR_CFG_EDIT)));
        nrChanges += this.printLastChangeTableRow(webTable, ChangeLog.findLastChange(InstrOfferingConfig.class.getName(), configIds, ChangeLog.Source.CLASS_SETUP));
        nrChanges += this.printLastChangeTableRow(webTable, ChangeLog.findLastChange(InstrOfferingConfig.class.getName(), configIds, ChangeLog.Source.CLASS_INSTR_ASSIGN));
        nrChanges += this.printLastChangeTableRow(webTable, ChangeLog.findLastChange(SchedulingSubpart.class.getName(), subpartIds, ChangeLog.Source.SCHEDULING_SUBPART_EDIT));
        nrChanges += this.printLastChangeTableRow(webTable, ChangeLog.findLastChange(Class_.class.getName(), classIds, ChangeLog.Source.CLASS_EDIT));
        nrChanges += this.printLastChangeTableRow(webTable, ChangeLog.findLastChange(io, ChangeLog.Source.DIST_PREF_EDIT));
        nrChanges += this.printLastChangeTableRow(webTable, ChangeLog.findLastChange(CourseOffering.class.getName(), offeringIds, ChangeLog.Source.CURRICULA));
        nrChanges += this.printLastChangeTableRow(webTable, LastChange.combine(ChangeLog.findLastChange(Curriculum.class.getName(), curriculumIds, ChangeLog.Source.CURRICULA), ChangeLog.findLastChange(Curriculum.class.getName(), curriculumIds, ChangeLog.Source.CURRICULUM_EDIT)));
        if ((nrChanges += this.printLastChangeTableRow(webTable, ChangeLog.findLastChange(Class_.class.getName(), classIds, ChangeLog.Source.INSTRUCTOR_ASSIGNMENT))) > 0) {
            this.pageContext.getOut().println("<TR><TD coslpan='2'>&nbsp;</TD></TR><TR><TD colspan='2'><table border='0' width='100%' cellspacing='0' cellpadding='3'>" + webTable.printTable(WebTable.getOrder(this.getSessionContext(), "lastChanges.ord")) + "</table></TD></TR>");
        }
        return true;
    }

    public boolean printLastChange(DepartmentalInstructor inst) throws IOException {
        if (inst == null) {
            return false;
        }
        int nrChanges = 0;
        WebTable.setOrder(this.getSessionContext(), "lastChanges.ord", this.pageContext.getRequest().getParameter("lcord"), 5);
        WebTable webTable = new WebTable(5, MSG.columnLastChanges(), "instructorDetail.action?instructorId=" + inst.getUniqueId() + "&lcord=%%", new String[]{MSG.columnPage(), MSG.columnObject(), MSG.columnOperation(), MSG.columnManager(), MSG.columnDate()}, new String[]{"left", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, false});
        nrChanges += this.printLastChangeTableRow(webTable, LastChange.combine(ChangeLog.findLastChange(inst, ChangeLog.Source.INSTRUCTOR_EDIT), ChangeLog.findLastChange(inst, ChangeLog.Source.INSTRUCTOR_MANAGE)));
        nrChanges += this.printLastChangeTableRow(webTable, ChangeLog.findLastChange(inst, ChangeLog.Source.INSTRUCTOR_PREF_EDIT));
        if ((nrChanges += this.printLastChangeTableRow(webTable, ChangeLog.findLastChange(inst, ChangeLog.Source.INSTRUCTOR_ASSIGNMENT_PREF_EDIT))) > 0) {
            this.pageContext.getOut().println("<TR><TD coslpan='2'>&nbsp;</TD></TR><TR><TD colspan='2'><table border='0' width='100%' cellspacing='0' cellpadding='3'>" + webTable.printTable(WebTable.getOrder(this.getSessionContext(), "lastChanges.ord")) + "</table></TD></TR>");
        }
        return true;
    }

    public boolean printLastChange(Location location) throws IOException {
        if (location == null) {
            return false;
        }
        int nrChanges = 0;
        WebTable.setOrder(this.getSessionContext(), "lastChanges.ord", this.pageContext.getRequest().getParameter("lcord"), 5);
        WebTable webTable = new WebTable(5, MSG.columnLastChanges(), "roomDetail.action?id=" + location.getUniqueId() + "&lcord=%%", new String[]{MSG.columnPage(), MSG.columnObject(), MSG.columnOperation(), MSG.columnManager(), MSG.columnDate()}, new String[]{"left", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, false});
        nrChanges += this.printLastChangeTableRow(webTable, ChangeLog.findLastChange(location, ChangeLog.Source.ROOM_EDIT));
        nrChanges += this.printLastChangeTableRow(webTable, ChangeLog.findLastChange(location, ChangeLog.Source.ROOM_DEPT_EDIT));
        nrChanges += this.printLastChangeTableRow(webTable, ChangeLog.findLastChange(location, ChangeLog.Source.ROOM_PREF_EDIT));
        HashSet<Long> roomFeatureIds = new HashSet<Long>();
        Iterator<RoomFeature> i = location.getGlobalRoomFeatures().iterator();
        while (i.hasNext()) {
            roomFeatureIds.add(((RoomFeature)i.next()).getUniqueId());
        }
        i = location.getDepartmentRoomFeatures().iterator();
        while (i.hasNext()) {
            roomFeatureIds.add(i.next().getUniqueId());
        }
        HashSet<Long> roomGroupIds = new HashSet<Long>();
        Iterator<RoomGroup> i2 = location.getRoomGroups().iterator();
        while (i2.hasNext()) {
            roomGroupIds.add(i2.next().getUniqueId());
        }
        nrChanges += this.printLastChangeTableRow(webTable, LastChange.combine(ChangeLog.findLastChange(location, ChangeLog.Source.ROOM_FEATURE_EDIT), LastChange.combine(ChangeLog.findLastChange(GlobalRoomFeature.class.getName(), roomFeatureIds, ChangeLog.Source.ROOM_FEATURE_EDIT), ChangeLog.findLastChange(DepartmentRoomFeature.class.getName(), roomFeatureIds, ChangeLog.Source.ROOM_FEATURE_EDIT))));
        if ((nrChanges += this.printLastChangeTableRow(webTable, LastChange.combine(ChangeLog.findLastChange(location, ChangeLog.Source.ROOM_GROUP_EDIT), ChangeLog.findLastChange(RoomGroup.class.getName(), roomGroupIds, ChangeLog.Source.ROOM_GROUP_EDIT)))) > 0) {
            this.pageContext.getOut().println("<TR><TD coslpan='2'>&nbsp;</TD></TR><TR><TD colspan='2'><table border='0' width='100%' cellspacing='0' cellpadding='3'>" + webTable.printTable(WebTable.getOrder(this.getSessionContext(), "lastChanges.ord")) + "</table></TD></TR>");
        }
        return true;
    }

    public int doEndTag() throws JspException {
        try {
            String objectIdStr;
            if (!this.getSessionContext().isAuthenticated() || CommonValues.No.eq(this.getSessionContext().getUser().getProperty(UserProperty.DisplayLastChanges))) {
                return 6;
            }
            String string = objectIdStr = this.getBodyContent() == null ? null : this.getBodyContent().getString().trim();
            if (objectIdStr == null || objectIdStr.length() == 0) {
                String string2 = objectIdStr = this.getId() == null ? null : this.getId().trim();
            }
            if (objectIdStr == null || objectIdStr.length() == 0) {
                return 6;
            }
            Long objectId = Long.parseLong(objectIdStr);
            String objectType = this.getPackage().trim() + "." + this.getType().trim();
            ChangeLog.Source source = null;
            if (this.getSource() != null && this.getSource().trim().length() > 0) {
                ChangeLog.Source.valueOf(this.getSource().trim());
            }
            if (source == null) {
                if (InstructionalOffering.class.getName().equals(objectType) && this.printLastChange((InstructionalOffering)InstructionalOfferingDAO.getInstance().get(objectId))) {
                    return 6;
                }
                if (DepartmentalInstructor.class.getName().equals(objectType) && this.printLastChange((DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(objectId))) {
                    return 6;
                }
                if (Location.class.getName().equals(objectType) && this.printLastChange((Location)LocationDAO.getInstance().get(objectId))) {
                    return 6;
                }
            }
            ChangeLog lch = ChangeLog.findLastChange(objectType, objectId, source);
            this.pageContext.getOut().println("<TR><TD>" + GWT.propLastChange() + "</TD><TD>");
            if (lch == null) {
                this.pageContext.getOut().print("<i>" + GWT.notApplicable() + "</i>");
            } else {
                this.pageContext.getOut().print(lch.getShortLabel());
            }
            this.pageContext.getOut().println("</TD></TR>");
        }
        catch (Exception e) {
            Debug.error(e);
            try {
                this.pageContext.getOut().print("<font color='red'>" + GWT.failedToComputeReport(e.getMessage()) + "</font>");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 6;
    }
}

