/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.exam.ui;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.coursett.preference.MinMaxPreferenceCombination;
import org.cpsolver.coursett.preference.PreferenceCombination;
import org.cpsolver.coursett.preference.SumPreferenceCombination;
import org.hibernate.Session;
import org.unitime.commons.Debug;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.form.ExamInfoForm;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao.RoomDAO;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.solver.exam.ui.ExamConflictStatisticsInfo;
import org.unitime.timetable.solver.exam.ui.ExamInfo;
import org.unitime.timetable.solver.exam.ui.ExamProposedChange;
import org.unitime.timetable.solver.exam.ui.ExamRoomInfo;
import org.unitime.timetable.solver.exam.ui.ExamSuggestionsInfo;
import org.unitime.timetable.util.RoomAvailability;

public class ExamInfoModel
implements Serializable {
    private static final long serialVersionUID = 6594424808143469141L;
    private static Log sLog = LogFactory.getLog(ExamInfoModel.class);
    protected static final ExaminationMessages MSG = Localization.create(ExaminationMessages.class);
    private transient ExamSolverProxy iSolver = null;
    private ExamInfo iExam = null;
    private ExamInfoForm iForm = null;
    private ExamProposedChange iChange = null;
    private Collection<ExamAssignmentInfo> iPeriods = null;
    private Vector<ExamRoomInfo> iRooms = null;
    private int iPeriodTableOrd = 0;
    private String iManagerExternalId = null;
    private ExamConflictStatisticsInfo iCbs = null;
    private ExamSuggestionsInfo iSuggestions = null;

    public void setSolver(ExamSolverProxy solver) {
        this.iSolver = solver;
    }

    public ExamSolverProxy getSolver() {
        return this.iSolver;
    }

    public void clear(UserContext user) {
        this.iExam = null;
        this.iChange = null;
        this.iRooms = null;
        this.iPeriods = null;
        this.iManagerExternalId = user == null ? null : user.getExternalUserId();
    }

    public ExamInfo getExam() {
        return this.iExam;
    }

    public ExamAssignmentInfo getExamOldAssignment() {
        if (this.iExam instanceof ExamAssignmentInfo) {
            return (ExamAssignmentInfo)this.iExam;
        }
        return null;
    }

    public ExamAssignmentInfo getExamAssignment() {
        if (this.iChange != null && this.iChange.getConflict(this.iExam) != null) {
            return null;
        }
        if (this.iExam instanceof ExamAssignmentInfo) {
            return (ExamAssignmentInfo)this.iExam;
        }
        return null;
    }

    public boolean isExamAssigned() {
        return this.getExamAssignment() != null && this.getExamAssignment().getPeriodId() != null;
    }

    public void update() throws Exception {
        this.iSuggestions = null;
        if (this.iChange == null) {
            return;
        }
        if (this.getSolver() != null && this.getSolver().getExamTypeId().equals(this.getExam().getExamTypeId())) {
            this.iChange = this.getSolver().update(this.iChange);
        } else {
            Vector<ExamAssignmentInfo> assignments = new Vector<ExamAssignmentInfo>(this.iChange.getAssignments());
            Hashtable<Long, ExamAssignment> table = this.iChange.getAssignmentTable();
            this.iChange.getAssignments().clear();
            for (ExamAssignment examAssignment : assignments) {
                this.iChange.getAssignments().add(new ExamAssignmentInfo(examAssignment.getExam(), examAssignment.getPeriod(), examAssignment.getRooms(), table));
            }
            if (assignments.isEmpty()) {
                Iterator<ExamAssignment> i = this.iChange.getConflicts().iterator();
                while (i.hasNext()) {
                    ExamAssignment examAssignment = i.next();
                    if (examAssignment != null && examAssignment.getExamId().equals(this.getExam().getExamId())) continue;
                    i.remove();
                }
            } else {
                this.iChange.getConflicts().clear();
            }
            block2: for (ExamAssignment examAssignment : new Vector<ExamAssignmentInfo>(this.iChange.getAssignments())) {
                if (examAssignment.getRooms() == null) continue;
                for (ExamRoomInfo room : examAssignment.getRooms()) {
                    if (!room.isHard()) continue;
                    Set<Object> canShareRoom = examAssignment.getRooms().size() == 1 ? this.getCanShareRoomExams(examAssignment.getExamId()) : new HashSet();
                    int size = examAssignment.getNrStudents();
                    if (!canShareRoom.isEmpty()) {
                        for (ExamAssignment examAssignment2 : this.iChange.getAssignments()) {
                            if (examAssignment2.equals(examAssignment) || !examAssignment2.getPeriodId().equals(examAssignment.getPeriodId()) || !examAssignment.getRooms().equals(examAssignment2.getRooms())) continue;
                            size += examAssignment2.getNrStudents();
                        }
                        if (size > room.getCapacity(examAssignment)) {
                            if (this.getExam().equals(examAssignment)) continue block2;
                            this.iChange.getAssignments().remove(examAssignment);
                            this.iChange.getConflicts().add(new ExamAssignment(examAssignment.getExam()));
                            continue block2;
                        }
                    }
                    for (Exam exam : room.getLocation().getExams(examAssignment.getPeriodId())) {
                        if (this.iChange.getCurrent(exam.getUniqueId()) != null || this.iChange.getConflict(exam.getUniqueId()) != null) continue;
                        if (canShareRoom.contains(exam.getUniqueId())) {
                            if (size + exam.getSize() <= room.getCapacity(examAssignment)) {
                                size += exam.getSize();
                                continue;
                            }
                            this.iChange.getConflicts().add(new ExamAssignment(exam));
                            continue;
                        }
                        this.iChange.getConflicts().add(new ExamAssignment(exam));
                    }
                    if (!(room.getLocation() instanceof Room)) continue;
                    Room r = (Room)RoomDAO.getInstance().get(room.getLocationId());
                    if (r.getParentRoom() != null) {
                        ExamRoomInfo examRoomInfo = new ExamRoomInfo(r.getParentRoom(), 0);
                        if (examAssignment.getRooms().contains(examRoomInfo)) {
                            this.iChange.getAssignments().remove(examAssignment);
                            this.iChange.getConflicts().add(new ExamAssignment(examAssignment.getExam()));
                            continue block2;
                        }
                        if (!r.getParentRoom().isIgnoreRoomCheck().booleanValue()) {
                            for (Exam x : r.getParentRoom().getExams(examAssignment.getPeriodId())) {
                                if (this.iChange.getCurrent(x.getUniqueId()) != null || this.iChange.getConflict(x.getUniqueId()) != null) continue;
                                this.iChange.getConflicts().add(new ExamAssignment(x));
                            }
                        }
                    }
                    for (Room p : r.getPartitions()) {
                        if (p.isIgnoreRoomCheck().booleanValue()) continue;
                        for (Exam x : p.getExams(examAssignment.getPeriodId())) {
                            if (this.iChange.getCurrent(x.getUniqueId()) != null || this.iChange.getConflict(x.getUniqueId()) != null) continue;
                            this.iChange.getConflicts().add(new ExamAssignment(x));
                        }
                    }
                }
            }
        }
    }

    public String assign() {
        String m;
        if (this.iChange == null) {
            return MSG.warnNothingToAssign();
        }
        sLog.info((Object)("About to be assigned: " + String.valueOf(this.iChange)));
        if (this.getSolver() != null && this.getSolver().getExamTypeId().equals(this.getExam().getExamTypeId())) {
            String message = null;
            for (ExamAssignment examAssignment : this.iChange.getConflicts()) {
                String string = this.getSolver().unassign(examAssignment);
                if (string == null) continue;
                message = (String)(message == null ? "" : message + "\n") + string;
            }
            for (ExamAssignment examAssignment : this.iChange.getAssignments()) {
                String string;
                if (this.iChange.getInitial(examAssignment) == null || (string = this.getSolver().unassign(this.iChange.getInitial(examAssignment))) == null) continue;
                message = (String)(message == null ? "" : message + "\n") + string;
            }
            for (ExamAssignment examAssignment : this.iChange.getAssignments()) {
                String string = this.getSolver().assign(examAssignment);
                if (string == null) continue;
                message = (String)(message == null ? "" : message + "\n") + string;
            }
            return message;
        }
        Session hibSession = ExamDAO.getInstance().getSession();
        String message = null;
        for (ExamAssignment examAssignment : this.iChange.getConflicts()) {
            m = examAssignment.getExam(hibSession).unassign(this.iManagerExternalId, hibSession);
            if (m == null) continue;
            message = (String)(message == null ? "" : message + "\n") + m;
        }
        for (ExamAssignment examAssignment : this.iChange.getAssignments()) {
            try {
                m = examAssignment.getExam(hibSession).assign(this.getAssignmentInfo(examAssignment), this.iManagerExternalId, hibSession);
                if (m == null) continue;
                message = (String)(message == null ? "" : message + "\n") + m;
            }
            catch (Exception e) {
                message = (String)(message == null ? "" : message + "\n") + MSG.errorAssignmentFailed(examAssignment.getExamName(), examAssignment.getPeriodAbbreviation(), examAssignment.getRoomsName(", "), e.getMessage());
            }
        }
        return message;
    }

    public boolean getCanAssign() {
        if (this.iChange == null) {
            return false;
        }
        for (ExamAssignment examAssignment : this.iChange.getAssignments()) {
            if (examAssignment.isValid()) continue;
            return false;
        }
        return true;
    }

    public String getAssignConfirm() {
        if (this.getSolver() != null && this.getSolver().getExamTypeId().equals(this.getExam().getExamTypeId())) {
            return MSG.questionAssignSolver();
        }
        return MSG.questionAssignDatabase();
    }

    public void setForm(ExamInfoForm form) {
        this.iForm = form;
    }

    public void setExam(Exam exam) {
        this.iPeriods = null;
        this.iRooms = null;
        this.iCbs = null;
        this.iSuggestions = null;
        if (this.getSolver() != null && this.getSolver().getExamTypeId().equals(exam.getExamType().getUniqueId())) {
            this.iExam = this.getSolver().getAssignmentInfo(exam.getUniqueId());
            if (this.iExam == null) {
                this.iExam = this.getSolver().getInfo(exam.getUniqueId());
            }
            if (this.iExam == null) {
                this.iExam = new ExamInfo(exam);
            }
        } else {
            this.iExam = exam.getAssignedPeriod() != null ? new ExamAssignmentInfo(exam) : new ExamInfo(exam);
        }
        if (this.iChange != null) {
            this.iChange.setSelected(exam.getUniqueId());
        }
        if (this.iExam.getMaxRooms() > 0) {
            this.iForm.setMinRoomSize(String.valueOf(this.iExam.getNrStudents()));
            this.iForm.setMaxRoomSize(null);
        }
        this.iForm.setRoomFilter(null);
        this.iForm.setDepth(2);
        this.iForm.setTimeout(5000L);
    }

    public ExamAssignmentInfo getAssignmentInfo(ExamAssignment assignment) throws Exception {
        if (assignment instanceof ExamAssignmentInfo) {
            return (ExamAssignmentInfo)assignment;
        }
        if (this.getSolver() != null && this.getSolver().getExamTypeId().equals(this.getExam().getExamTypeId())) {
            return this.getSolver().getAssignment(assignment.getExamId(), assignment.getPeriodId(), assignment.getRoomIds());
        }
        if (this.iChange != null) {
            return new ExamAssignmentInfo(assignment.getExam(), assignment.getPeriod(), assignment.getRooms(), this.iChange.getAssignmentTable());
        }
        return new ExamAssignmentInfo(assignment.getExam(), assignment.getPeriod(), assignment.getRooms());
    }

    public ExamAssignmentInfo getSelectedAssignment() throws Exception {
        if (this.iChange == null) {
            return null;
        }
        for (ExamAssignment examAssignment : this.iChange.getAssignments()) {
            if (!examAssignment.getExamId().equals(this.iExam.getExamId())) continue;
            return this.getAssignmentInfo(examAssignment);
        }
        return null;
    }

    public void setPeriod(long periodId) throws Exception {
        this.iRooms = null;
        if (this.iChange == null) {
            this.iChange = new ExamProposedChange();
            this.iChange.setSelected(this.getExam().getExamId());
        }
        for (ExamAssignmentInfo period : this.getPeriods()) {
            if (periodId != period.getPeriodId()) continue;
            this.iChange.addChange(period, this.getExamOldAssignment());
        }
        if (periodId == -1L) {
            this.iChange.addChange(new ExamAssignmentInfo(this.getExam().getExam(), null, null, null, this.iChange == null ? null : this.iChange.getAssignmentTable()), this.getExamOldAssignment());
        }
        if (this.iChange.isEmpty()) {
            this.iChange = null;
        }
        this.update();
    }

    public void delete(long examId) throws Exception {
        if (this.iChange == null) {
            return;
        }
        Iterator<ExamAssignmentInfo> i = this.iChange.getAssignments().iterator();
        while (i.hasNext()) {
            ExamAssignmentInfo x = i.next();
            if (!x.getExamId().equals(examId)) continue;
            i.remove();
        }
        this.update();
    }

    public void setRooms(String rooms) throws Exception {
        StringTokenizer stk;
        TreeSet<ExamRoomInfo> assignedRooms;
        ExamAssignmentInfo assignment;
        if (this.iChange == null) {
            this.iChange = new ExamProposedChange();
            this.iChange.setSelected(this.getExam().getExamId());
        }
        if ((assignment = this.iChange.getCurrent(this.iExam)) == null && this.isExamAssigned()) {
            for (ExamAssignmentInfo period : this.getPeriods()) {
                if (!this.getExamOldAssignment().getPeriodId().equals(period.getPeriodId())) continue;
                assignment = period;
                break;
            }
        }
        if (assignment == null) {
            return;
        }
        if (this.getSolver() != null && this.getSolver().getExamTypeId().equals(this.getExam().getExamTypeId())) {
            assignedRooms = new Vector();
            stk = new StringTokenizer(rooms, ":");
            while (stk.hasMoreTokens()) {
                String token = stk.nextToken();
                if (token.trim().length() == 0) continue;
                ((Vector)((Object)assignedRooms)).add((ExamRoomInfo)((Object)Long.valueOf(token.substring(0, token.indexOf(64)))));
            }
            assignment = this.getSolver().getAssignment(this.getExam().getExamId(), assignment.getPeriodId(), assignedRooms);
        } else {
            assignedRooms = new TreeSet();
            stk = new StringTokenizer(rooms, ":");
            while (stk.hasMoreTokens()) {
                String token = stk.nextToken();
                if (token.trim().length() == 0) continue;
                Long roomId = Long.valueOf(token.substring(0, token.indexOf(64)));
                ExamRoomInfo room = null;
                for (ExamRoomInfo r : this.getRooms()) {
                    if (!r.getLocationId().equals(roomId)) continue;
                    room = r;
                    break;
                }
                if (room == null) continue;
                assignedRooms.add(room);
            }
            assignment = new ExamAssignmentInfo(this.getExam().getExam(), assignment.getPeriod(), assignedRooms, this.iChange.getAssignmentTable());
        }
        this.iChange.addChange(assignment, this.getExamOldAssignment());
        if (this.iChange.isEmpty()) {
            this.iChange = null;
        }
        this.update();
    }

    public void setSuggestion(int idx) {
        if (this.iSuggestions == null || this.iSuggestions.getSuggestions() == null || this.iSuggestions.getSuggestions().size() <= idx) {
            return;
        }
        this.iChange = this.iSuggestions.getSuggestions().elementAt(idx);
    }

    public void apply(HttpServletRequest request, ExamInfoForm form) {
        if (request.getParameter("pord") != null) {
            this.iPeriodTableOrd = Integer.parseInt(request.getParameter("pord"));
        }
        this.iForm = form;
    }

    public void refreshRooms() {
        this.iRooms = null;
    }

    public void refreshSuggestions() {
        this.iSuggestions = null;
    }

    public static String dc2html(boolean html, int conf, int diff) {
        Object ret;
        Object object = conf <= 0 ? "" : (ret = html ? "<font color='" + PreferenceLevel.prolog2color("P") + "'>" + conf + "</font>" : String.valueOf(conf));
        if (html && diff < 0) {
            ret = (String)ret + "<font color='" + PreferenceLevel.prolog2color("R") + "'> (" + diff + ")</font>";
        }
        if (html && diff > 0) {
            ret = (String)ret + "<font color='" + PreferenceLevel.prolog2color("P") + "'> (+" + diff + ")</font>";
        }
        if (!html && diff < 0) {
            ret = (String)ret + " (" + diff + ")";
        }
        if (!html && diff > 0) {
            ret = (String)ret + " (+" + diff + ")";
        }
        return ret;
    }

    public static String m2d2html(boolean html, int conf, int diff) {
        Object ret;
        Object object = conf <= 0 ? "" : (ret = html ? "<font color='" + PreferenceLevel.prolog2color("2") + "'>" + conf + "</font>" : String.valueOf(conf));
        if (html && diff < 0) {
            ret = (String)ret + "<font color='" + PreferenceLevel.prolog2color("-2") + "'> (" + diff + ")</font>";
        }
        if (html && diff > 0) {
            ret = (String)ret + "<font color='" + PreferenceLevel.prolog2color("2") + "'> (+" + diff + ")</font>";
        }
        if (!html && diff < 0) {
            ret = (String)ret + " (" + diff + ")";
        }
        if (!html && diff > 0) {
            ret = (String)ret + " (+" + diff + ")";
        }
        return ret;
    }

    public static String btb2html(boolean html, int conf, int diff, int dconf, int ddiff) {
        Object ret;
        Object object = conf <= 0 ? "" : (ret = html ? "<font color='" + PreferenceLevel.prolog2color("1") + "'>" + conf + "</font>" : String.valueOf(conf));
        if (html) {
            if (diff < 0) {
                ret = (String)ret + "<font color='" + PreferenceLevel.prolog2color("-1") + "'> (" + diff + "</font>";
            } else if (diff > 0) {
                ret = (String)ret + "<font color='" + PreferenceLevel.prolog2color("1") + "'> (+" + diff + "</font>";
            } else if (ddiff != 0) {
                ret = (String)ret + " (" + String.valueOf(diff);
            }
            if (ddiff < 0) {
                ret = (String)ret + "<font color='" + PreferenceLevel.prolog2color("-1") + "'> " + MSG.prefixDistanceConclict() + ddiff + "</font>";
            }
            if (ddiff > 0) {
                ret = (String)ret + "<font color='" + PreferenceLevel.prolog2color("1") + "'> " + MSG.prefixDistanceConclict() + "+" + ddiff + "</font>";
            }
            if (diff < 0) {
                ret = (String)ret + "<font color='" + PreferenceLevel.prolog2color("-1") + "'>)</font>";
            } else if (diff > 0) {
                ret = (String)ret + "<font color='" + PreferenceLevel.prolog2color("1") + "'>)</font>";
            } else if (ddiff != 0) {
                ret = (String)ret + ")";
            }
        } else {
            if (diff < 0) {
                ret = (String)ret + " (" + diff;
            } else if (diff > 0) {
                ret = (String)ret + " (+" + diff;
            } else if (ddiff != 0) {
                ret = (String)ret + " (" + String.valueOf(diff);
            }
            if (ddiff < 0) {
                ret = (String)ret + " " + MSG.prefixDistanceConclict() + ddiff;
            }
            if (ddiff > 0) {
                ret = (String)ret + " " + MSG.prefixDistanceConclict() + "+" + ddiff;
            }
            if (diff < 0) {
                ret = (String)ret + ")";
            } else if (diff > 0) {
                ret = (String)ret + ")";
            } else if (ddiff != 0) {
                ret = (String)ret + ")";
            }
        }
        return ret;
    }

    public String getPeriodsTable() {
        try {
            WebTable table = new WebTable(8, MSG.sectAvailablePeriodsForExam(this.getExam().getExamName()), "examInfo.action?op=Reorder&pord=%%&noCacheTS=" + new Date().getTime(), new String[]{MSG.colAvailablePeriod().replace("\n", "<br>"), MSG.colViolatedDistributions().replace("\n", "<br>"), MSG.colStudentDirectConflicts().replace("\n", "<br>"), MSG.colStudentMoreThanTwoExamsADayConflicts().replace(">", "&gt;").replace("\n", "<br>"), MSG.colStudentBackToBackConflicts().replace("\n", "<br>"), MSG.colInstructorDirectConflicts().replace("\n", "<br>"), MSG.colInstructorMoreThanTwoExamsADayConflicts().replace(">", "&gt;").replace("\n", "<br>"), MSG.colInstructorBackToBackConflicts().replace("\n", "<br>")}, new String[]{"left", "left", "right", "right", "right", "right", "right", "right", "right"}, new boolean[]{true, true, true, true, true, true, true, true});
            ExamAssignmentInfo current = this.getExamAssignment();
            for (ExamAssignmentInfo period : this.getPeriods()) {
                ExamAssignmentInfo examAssignment;
                boolean initial = this.getExamOldAssignment() != null && this.getExamOldAssignment().getPeriodId() != null && this.getExamOldAssignment().getPeriodId().equals(period.getPeriodId());
                WebTable.WebTableLine line = table.addLine("onClick=\"displayLoading();document.location='examInfo.action?op=Select&period=" + period.getPeriodId() + "&noCacheTS=" + new Date().getTime() + "';\"", new String[]{(initial ? "<u>" : "") + period.getPeriodAbbreviationWithPref() + (initial ? "</u>" : ""), period.getDistributionConflictsHtml("<br>"), ExamInfoModel.dc2html(true, period.getNrDirectConflicts(), current == null ? 0 : period.getNrDirectConflicts() - current.getNrDirectConflicts()), ExamInfoModel.m2d2html(true, period.getNrMoreThanTwoConflicts(), current == null ? 0 : period.getNrMoreThanTwoConflicts() - current.getNrMoreThanTwoConflicts()), ExamInfoModel.btb2html(true, period.getNrBackToBackConflicts(), current == null ? 0 : period.getNrBackToBackConflicts() - current.getNrBackToBackConflicts(), period.getNrDistanceBackToBackConflicts(), current == null ? 0 : period.getNrDistanceBackToBackConflicts() - current.getNrDistanceBackToBackConflicts()), ExamInfoModel.dc2html(true, period.getNrInstructorDirectConflicts(), current == null ? 0 : period.getNrInstructorDirectConflicts() - current.getNrInstructorDirectConflicts()), ExamInfoModel.m2d2html(true, period.getNrInstructorMoreThanTwoConflicts(), current == null ? 0 : period.getNrInstructorMoreThanTwoConflicts() - current.getNrInstructorMoreThanTwoConflicts()), ExamInfoModel.btb2html(true, period.getNrInstructorBackToBackConflicts(), current == null ? 0 : period.getNrInstructorBackToBackConflicts() - current.getNrInstructorBackToBackConflicts(), period.getNrInstructorDistanceBackToBackConflicts(), current == null ? 0 : period.getNrInstructorDistanceBackToBackConflicts() - current.getNrInstructorDistanceBackToBackConflicts())}, new Comparable[]{period.getPeriodOrd(), period.getDistributionConflictsList(":"), Integer.valueOf(period.getNrDirectConflicts()), Integer.valueOf(period.getNrMoreThanTwoConflicts()), Integer.valueOf(period.getNrBackToBackConflicts()), Integer.valueOf(period.getNrInstructorDirectConflicts()), Integer.valueOf(period.getNrInstructorMoreThanTwoConflicts()), Integer.valueOf(period.getNrInstructorBackToBackConflicts())});
                ExamAssignmentInfo examAssignmentInfo = examAssignment = this.iChange == null ? null : this.iChange.getCurrent(this.iExam);
                if (!this.isExamAssigned() && examAssignment == null || !period.getPeriodId().equals((examAssignment == null ? this.getExamAssignment() : examAssignment).getPeriodId())) continue;
                line.setBgColor("rgb(168,187,225)");
            }
            if (current != null) {
                table.addLine("onClick=\"displayLoading();document.location='examInfo.action?op=Select&period=-1&noCacheTS=" + new Date().getTime() + "';\"", new String[]{MSG.notAssigned(), "", ExamInfoModel.dc2html(true, 0, -current.getNrDirectConflicts()), ExamInfoModel.m2d2html(true, 0, -current.getNrMoreThanTwoConflicts()), ExamInfoModel.btb2html(true, 0, -current.getNrBackToBackConflicts(), 0, -current.getNrDistanceBackToBackConflicts()), ExamInfoModel.dc2html(true, 0, -current.getNrInstructorDirectConflicts()), ExamInfoModel.m2d2html(true, 0, -current.getNrInstructorMoreThanTwoConflicts()), ExamInfoModel.btb2html(true, 0, -current.getNrInstructorBackToBackConflicts(), 0, -current.getNrInstructorDistanceBackToBackConflicts())}, new Comparable[]{Integer.valueOf(9999), "", Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0)});
            }
            return table.printTable(this.iPeriodTableOrd);
        }
        catch (Exception e) {
            Debug.error(e);
            return null;
        }
    }

    public Collection<ExamAssignmentInfo> getPeriods() {
        if (this.iPeriods == null) {
            if (this.getSolver() != null && this.getSolver().getExamTypeId().equals(this.getExam().getExamTypeId())) {
                this.iPeriods = this.getSolver().getPeriods(this.getExam().getExamId(), this.iChange);
            } else {
                try {
                    Hashtable<Long, Set<Exam>> studentExams = this.getExam().getExam().getStudentExams();
                    this.iPeriods = new Vector<ExamAssignmentInfo>();
                    for (ExamPeriod period : ExamPeriod.findAll(this.getExam().getExam().getSession().getUniqueId(), this.getExam().getExamTypeId())) {
                        try {
                            this.iPeriods.add(new ExamAssignmentInfo(this.getExam().getExam(), period, null, studentExams, this.iChange == null ? null : this.iChange.getAssignmentTable()));
                        }
                        catch (Exception e) {
                            if (MSG.errorPeriodProhibited().equals(e.getMessage()) || MSG.errorPeriodTooShort().equals(e.getMessage()) || MSG.errorPeriodNotRequired().equals(e.getMessage())) continue;
                            Debug.error(e);
                        }
                    }
                }
                catch (Exception e) {
                    Debug.error(e);
                }
            }
        }
        return this.iPeriods;
    }

    public TreeSet<Location> findAllExamLocations(Long sessionId, Long examTypeId) {
        int i;
        Object a = "";
        Object b = "";
        if (this.iForm.getRoomFeatures() != null && this.iForm.getRoomFeatures().length > 0) {
            for (i = 0; i < this.iForm.getRoomFeatures().length; ++i) {
                a = (String)a + ", GlobalRoomFeature f" + i;
                b = (String)b + " and f" + i + ".uniqueId=" + this.iForm.getRoomFeatures()[i] + " and f" + i + " in elements(r.features)";
            }
        }
        if (this.iForm.getRoomGroups() != null && this.iForm.getRoomGroups().length > 0) {
            b = (String)b + " and (";
            for (i = 0; i < this.iForm.getRoomGroups().length; ++i) {
                if (i > 0) {
                    b = (String)b + " or";
                }
                a = (String)a + ", RoomGroup g" + i;
                b = (String)b + " (g" + i + ".uniqueId=" + this.iForm.getRoomGroups()[i] + " and g" + i + " in elements(r.roomGroups))";
            }
            b = (String)b + ")";
        }
        if (this.iForm.getRoomTypes() != null && this.iForm.getRoomTypes().length > 0) {
            b = (String)b + " and r.roomType.uniqueId in (";
            for (i = 0; i < this.iForm.getRoomTypes().length; ++i) {
                if (i > 0) {
                    b = (String)b + ",";
                }
                b = (String)b + this.iForm.getRoomTypes()[i];
            }
            b = (String)b + ")";
        }
        return new TreeSet<Location>(LocationDAO.getInstance().getSession().createQuery("select r from Location r inner join r.examTypes x " + (String)a + " where r.session.uniqueId = :sessionId and x.uniqueId = :examTypeId " + (String)b, Location.class).setParameter("sessionId", (Object)sessionId).setParameter("examTypeId", (Object)examTypeId).setCacheable(true).list());
    }

    protected void filterRooms() {
        Iterator<ExamRoomInfo> i1 = this.iRooms.iterator();
        block0: while (i1.hasNext()) {
            int i;
            ExamRoomInfo r = i1.next();
            if (this.iForm.getRoomTypes() != null && this.iForm.getRoomTypes().length > 0) {
                boolean ok = false;
                for (int i2 = 0; i2 < this.iForm.getRoomTypes().length; ++i2) {
                    if (!r.getLocation().getRoomType().getUniqueId().equals(this.iForm.getRoomTypes()[i2])) continue;
                    ok = true;
                    break;
                }
                if (!ok) {
                    i1.remove();
                    continue;
                }
            }
            if (this.iForm.getRoomFeatures() != null && this.iForm.getRoomFeatures().length > 0) {
                for (i = 0; i < this.iForm.getRoomFeatures().length; ++i) {
                    if (r.getLocation().hasFeature(this.iForm.getRoomFeatures()[i])) continue;
                    i1.remove();
                    continue block0;
                }
            }
            if (this.iForm.getRoomGroups() == null || this.iForm.getRoomGroups().length <= 0) continue;
            for (i = 0; i < this.iForm.getRoomGroups().length; ++i) {
                if (r.getLocation().hasGroup(this.iForm.getRoomGroups()[i])) continue block0;
            }
            i1.remove();
        }
    }

    protected Set<Long> getCanShareRoomExams(Long examId) {
        return new HashSet<Long>(ExamDAO.getInstance().getSession().createQuery("select o.prefGroup.uniqueId from DistributionPref p inner join p.distributionObjects x inner join p.distributionObjects o where p.distributionType.reference = :shareType and x.prefGroup.uniqueId = :examId and x.prefGroup != o.prefGroup", Long.class).setParameter("shareType", (Object)"EX_SHARE_ROOM").setParameter("examId", (Object)examId).setCacheable(true).list());
    }

    protected Vector<ExamRoomInfo> findRooms(ExamPeriod period, int minRoomSize, int maxRoomSize, String filter, boolean allowConflicts) {
        Vector<ExamRoomInfo> rooms = new Vector<ExamRoomInfo>();
        boolean reqRoom = false;
        boolean reqBldg = false;
        boolean reqGroup = false;
        Exam exam = this.getExam().getExam(ExamDAO.getInstance().getSession());
        Set<Long> canShareRoom = this.getCanShareRoomExams(this.getExam().getExamId());
        Set<RoomGroupPref> groupPrefs = exam.getPreferences(RoomGroupPref.class);
        Set<RoomPref> roomPrefs = exam.getPreferences(RoomPref.class);
        Set<BuildingPref> bldgPrefs = exam.getPreferences(BuildingPref.class);
        Set<RoomFeaturePref> featurePrefs = exam.getPreferences(RoomFeaturePref.class);
        TreeSet<Location> locations = this.findAllExamLocations(period.getSession().getUniqueId(), period.getExamType().getUniqueId());
        Hashtable<Long, Set<Long>> locationTable = Location.findExamLocationTable(period.getUniqueId());
        if (this.getExamAssignment() != null && this.getExamAssignment().getPeriod().equals(period) && this.getExamAssignment().getRooms() != null) {
            for (ExamRoomInfo examRoomInfo : this.getExamAssignment().getRooms()) {
                Set<Long> exams = locationTable.get(examRoomInfo.getLocationId());
                if (exams == null) continue;
                exams.remove(this.getExam().getExamId());
            }
        }
        if (this.iChange != null) {
            Set<Long> exams;
            for (ExamAssignment examAssignment : this.iChange.getConflicts()) {
                if (!examAssignment.getPeriod().equals(period) || examAssignment.getRooms() == null) continue;
                for (ExamRoomInfo examRoomInfo : examAssignment.getRooms()) {
                    exams = locationTable.get(examRoomInfo.getLocationId());
                    if (exams == null) continue;
                    exams.remove(examAssignment.getExamId());
                }
            }
            for (ExamAssignment examAssignment : this.iChange.getAssignments()) {
                ExamAssignment initial = this.iChange.getInitial(examAssignment);
                if (initial == null || !initial.getPeriod().equals(period) || initial.getRooms() == null) continue;
                for (ExamRoomInfo room : initial.getRooms()) {
                    Set<Long> exams2 = locationTable.get(room.getLocationId());
                    if (exams2 == null) continue;
                    exams2.remove(initial.getExamId());
                }
            }
            for (ExamAssignment examAssignment : this.iChange.getAssignments()) {
                if (this.iExam.getExamId().equals(examAssignment.getExamId()) || !examAssignment.getPeriod().equals(period) || examAssignment.getRooms() == null) continue;
                for (ExamRoomInfo examRoomInfo : examAssignment.getRooms()) {
                    exams = locationTable.get(examRoomInfo.getLocationId());
                    if (exams == null) {
                        exams = new HashSet<Long>();
                        locationTable.put(examRoomInfo.getLocationId(), exams);
                    }
                    exams.add(examAssignment.getExamId());
                }
            }
        }
        block7: for (Location location : locations) {
            Collection<RoomAvailabilityInterface.TimeBlock> times;
            boolean shouldNotBeUsed = PreferenceLevel.sStronglyDiscouraged.equals(location.getExamPreference(period).getPrefProlog());
            boolean bl = true;
            SumPreferenceCombination pref = new SumPreferenceCombination();
            PreferenceCombination groupPref = PreferenceCombination.getDefault();
            for (RoomGroupPref p : groupPrefs) {
                if (!p.getRoomGroup().getRooms().contains(location)) continue;
                groupPref.addPreferenceProlog(p.getPrefLevel().getPrefProlog());
            }
            if (groupPref.getPreferenceProlog().equals(PreferenceLevel.sProhibited)) {
                bl = false;
            }
            if (reqGroup && !groupPref.getPreferenceProlog().equals(PreferenceLevel.sRequired)) {
                bl = false;
            }
            if (!reqGroup && groupPref.getPreferenceProlog().equals(PreferenceLevel.sRequired)) {
                reqGroup = true;
                rooms.clear();
            }
            if (!groupPref.getPreferenceProlog().equals(PreferenceLevel.sProhibited) && !groupPref.getPreferenceProlog().equals(PreferenceLevel.sRequired)) {
                pref.addPreferenceProlog(groupPref.getPreferenceProlog());
            }
            String roomPref = location.getExamPreference(period).getPrefProlog();
            for (RoomPref p : roomPrefs) {
                if (!location.equals(p.getRoom())) continue;
                roomPref = p.getPrefLevel().getPrefProlog();
                shouldNotBeUsed = false;
                break;
            }
            if (roomPref != null && roomPref.equals(PreferenceLevel.sProhibited)) {
                bl = false;
            }
            if (reqRoom && (roomPref == null || !roomPref.equals(PreferenceLevel.sRequired))) {
                bl = false;
            }
            if (!reqRoom && roomPref != null && roomPref.equals(PreferenceLevel.sRequired)) {
                reqRoom = true;
                rooms.clear();
            }
            if (roomPref != null && !roomPref.equals(PreferenceLevel.sProhibited) && !roomPref.equals(PreferenceLevel.sRequired)) {
                pref.addPreferenceProlog(roomPref);
            }
            Building bldg = location instanceof Room ? ((Room)location).getBuilding() : null;
            String bldgPref = null;
            for (BuildingPref p : bldgPrefs) {
                if (bldg == null || !bldg.equals(p.getBuilding())) continue;
                bldgPref = p.getPrefLevel().getPrefProlog();
                break;
            }
            if (bldgPref != null && bldgPref.equals(PreferenceLevel.sProhibited)) {
                bl = false;
            }
            if (reqBldg && (bldgPref == null || !bldgPref.equals(PreferenceLevel.sRequired))) {
                bl = false;
            }
            if (!reqBldg && bldgPref != null && bldgPref.equals(PreferenceLevel.sRequired)) {
                reqBldg = true;
                rooms.clear();
            }
            if (bldgPref != null && !bldgPref.equals(PreferenceLevel.sProhibited) && !bldgPref.equals(PreferenceLevel.sRequired)) {
                pref.addPreferenceProlog(bldgPref);
            }
            boolean acceptableFeatures = true;
            MinMaxPreferenceCombination featurePref = new MinMaxPreferenceCombination();
            for (RoomFeaturePref roomFeaturePref : featurePrefs) {
                RoomFeature feature = roomFeaturePref.getRoomFeature();
                String p = roomFeaturePref.getPrefLevel().getPrefProlog();
                boolean hasFeature = feature.getRooms().contains(location);
                if (p.equals(PreferenceLevel.sProhibited) && hasFeature) {
                    acceptableFeatures = false;
                }
                if (p.equals(PreferenceLevel.sRequired) && !hasFeature) {
                    acceptableFeatures = false;
                }
                if (p == null || !hasFeature || p.equals(PreferenceLevel.sProhibited) || p.equals(PreferenceLevel.sRequired)) continue;
                featurePref.addPreferenceProlog(p);
            }
            pref.addPreferenceInt(featurePref.getPreferenceInt());
            if (!acceptableFeatures) {
                bl = false;
            }
            if (!bl || shouldNotBeUsed) continue;
            Set<Long> exams = locationTable.get(location.getUniqueId());
            boolean roomConflict = false;
            if (exams != null && !exams.isEmpty() && !location.isIgnoreRoomCheck().booleanValue()) {
                for (Long other : exams) {
                    if (canShareRoom.contains(other)) continue;
                    roomConflict = true;
                    if (allowConflicts && (this.iChange == null || this.iChange.getCurrent(other) == null)) continue;
                    continue block7;
                }
            }
            if (location instanceof Room) {
                Object parentExams;
                Room r = (Room)location;
                if (r.getParentRoom() != null && (parentExams = locationTable.get(r.getParentRoom().getUniqueId())) != null && !parentExams.isEmpty() && !r.getParentRoom().isIgnoreRoomCheck().booleanValue()) {
                    Iterator hasFeature = parentExams.iterator();
                    while (hasFeature.hasNext()) {
                        Long l = (Long)hasFeature.next();
                        if (canShareRoom.contains(l)) continue;
                        roomConflict = true;
                        if (allowConflicts && (this.iChange == null || this.iChange.getCurrent(l) == null)) continue;
                        continue block7;
                    }
                }
                parentExams = r.getPartitions().iterator();
                while (parentExams.hasNext()) {
                    Room p = (Room)parentExams.next();
                    Set<Long> set = locationTable.get(p.getUniqueId());
                    if (set == null || set.isEmpty() || p.isIgnoreRoomCheck().booleanValue()) continue;
                    for (Long other : set) {
                        if (canShareRoom.contains(other)) continue;
                        roomConflict = true;
                        if (allowConflicts && (this.iChange == null || this.iChange.getCurrent(other) == null)) continue;
                        continue block7;
                    }
                }
            }
            int cap = this.getExam().getSeatingType() == 1 ? location.getExamCapacity() : location.getCapacity();
            if (minRoomSize >= 0 && cap < minRoomSize || maxRoomSize >= 0 && cap > maxRoomSize || PreferenceLevel.sProhibited.equals(location.getExamPreference(period).getPrefProlog()) || !ExamInfoModel.match(location.getLabel(), filter)) continue;
            if (!location.isIgnoreRoomCheck().booleanValue() && RoomAvailability.getInstance() != null && (times = RoomAvailability.getInstance().getRoomAvailability(location.getUniqueId(), period.getStartTime(), period.getEndTime(), period.getExamType().getReference())) != null) {
                for (RoomAvailabilityInterface.TimeBlock timeBlock : times) {
                    if (!period.overlap(timeBlock)) continue;
                    sLog.info((Object)("Room " + location.getLabel() + " is not avaiable due to " + String.valueOf(timeBlock)));
                    continue block7;
                }
            }
            if (location instanceof Room && RoomAvailability.getInstance() != null) {
                Collection<RoomAvailabilityInterface.TimeBlock> times2;
                Room r = (Room)location;
                if (r.getParentRoom() != null && !r.getParentRoom().isIgnoreRoomCheck().booleanValue() && (times2 = RoomAvailability.getInstance().getRoomAvailability(r.getParentRoom().getUniqueId(), period.getStartTime(), period.getEndTime(), period.getExamType().getReference())) != null) {
                    for (RoomAvailabilityInterface.TimeBlock time2 : times2) {
                        if (!period.overlap(time2)) continue;
                        sLog.info((Object)("Room " + location.getLabel() + " is not avaiable due to " + String.valueOf(time2)));
                        continue block7;
                    }
                }
                for (Room room : r.getPartitions()) {
                    Collection<RoomAvailabilityInterface.TimeBlock> times3;
                    if (room.isIgnoreRoomCheck().booleanValue() || (times3 = RoomAvailability.getInstance().getRoomAvailability(room.getUniqueId(), period.getStartTime(), period.getEndTime(), period.getExamType().getReference())) == null) continue;
                    for (RoomAvailabilityInterface.TimeBlock time : times3) {
                        if (!period.overlap(time)) continue;
                        sLog.info((Object)("Room " + location.getLabel() + " is not avaiable due to " + String.valueOf(time)));
                        continue block7;
                    }
                }
            }
            rooms.add(new ExamRoomInfo(location, (roomConflict ? 1000 : 0) + pref.getPreferenceInt()));
        }
        return rooms;
    }

    public String getRoomTable() {
        try {
            TreeSet<ExamRoomInfo> original;
            ExamAssignmentInfo examAssignment;
            Vector<ExamRoomInfo> rooms = this.getRooms();
            ExamAssignmentInfo examAssignmentInfo = examAssignment = this.iChange == null ? null : this.iChange.getCurrent(this.iExam);
            TreeSet<ExamRoomInfo> assigned = examAssignment != null ? examAssignment.getRooms() : (this.isExamAssigned() ? this.getExamAssignment().getRooms() : null);
            TreeSet<ExamRoomInfo> treeSet = original = this.getExamOldAssignment() != null ? this.getExamOldAssignment().getRooms() : null;
            if (rooms == null || rooms.isEmpty()) {
                return "";
            }
            Collections.sort(rooms, new Comparator<ExamRoomInfo>(){

                @Override
                public int compare(ExamRoomInfo r1, ExamRoomInfo r2) {
                    int cmp = 0;
                    cmp = ExamInfoForm.OrderBy.NameAsc.name().equals(ExamInfoModel.this.iForm.getRoomOrder()) ? r1.getName().compareTo(r2.getName()) : (ExamInfoForm.OrderBy.NameDesc.name().equals(ExamInfoModel.this.iForm.getRoomOrder()) ? -r1.getName().compareTo(r2.getName()) : (ExamInfoForm.OrderBy.SizeAsc.name().equals(ExamInfoModel.this.iForm.getRoomOrder()) ? Double.compare(r1.getCapacity(ExamInfoModel.this.getExam()), r2.getCapacity(ExamInfoModel.this.getExam())) : (ExamInfoForm.OrderBy.SizeDesc.name().equals(ExamInfoModel.this.iForm.getRoomOrder()) ? -Double.compare(r1.getCapacity(ExamInfoModel.this.getExam()), r2.getCapacity(ExamInfoModel.this.getExam())) : r1.getName().compareTo(r2.getName()))));
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = r1.getName().compareTo(r2.getName());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return r1.getLocationId().compareTo(r2.getLocationId());
                }
            });
            Object ret = "";
            ret = (String)ret + "<script language='javascript'>";
            ret = (String)ret + "function roomOver(source, id) { ";
            ret = (String)ret + "    document.getElementById('r'+id).style.backgroundColor='rgb(223,231,242)';";
            ret = (String)ret + "    document.getElementById('c'+id).style.backgroundColor='rgb(223,231,242)';";
            ret = (String)ret + "    source.style.cursor='hand';source.style.cursor='pointer';";
            ret = (String)ret + "}";
            ret = (String)ret + "var sCap = -1;";
            ret = (String)ret + "var sRooms = '";
            if (assigned != null && assigned.size() > 0) {
                for (ExamRoomInfo room : assigned) {
                    ret = (String)ret + ":" + room.getLocationId() + "@" + room.getCapacity(this.getExam());
                }
            }
            ret = (String)ret + "';";
            ret = (String)ret + "var sNrRooms = " + (assigned != null ? assigned.size() : 0) + ";";
            ret = (String)ret + "function roomSelected(id) {";
            ret = (String)ret + "    return sRooms.indexOf(':'+id+'@')>=0;";
            ret = (String)ret + "}";
            ret = (String)ret + "function roomOut(id) { ";
            ret = (String)ret + "    var bg = 'transparent';";
            ret = (String)ret + "    if (roomSelected(id)) bg='rgb(168,187,225)';";
            ret = (String)ret + "    document.getElementById('r'+id).style.backgroundColor=bg;";
            ret = (String)ret + "    document.getElementById('c'+id).style.backgroundColor=bg;";
            ret = (String)ret + "}";
            ret = (String)ret + "function roomClick(source, id, cap) { ";
            ret = (String)ret + "    if (sCap<0) {";
            ret = (String)ret + "        sCap = 0; sRooms=''; sNrRooms=0;";
            if (assigned != null && assigned.size() > 0) {
                for (ExamRoomInfo room : assigned) {
                    ret = (String)ret + "        roomOut(" + room.getLocationId() + ");";
                }
            }
            ret = (String)ret + "    }";
            ret = (String)ret + "    var i = sRooms.indexOf(':'+id+'@');";
            ret = (String)ret + "    if (i>=0) {";
            ret = (String)ret + "        var j = sRooms.indexOf(':',i+1);";
            ret = (String)ret + "        sRooms = sRooms.substring(0, i)+(j>=0?sRooms.substring(j):'');";
            ret = (String)ret + "        sCap -= cap; sNrRooms--;";
            ret = (String)ret + "    } else {";
            ret = (String)ret + "        sRooms = sRooms + ':' + id + '@' + cap;";
            ret = (String)ret + "        sCap += cap; sNrRooms++;";
            ret = (String)ret + "        if (sNrRooms>" + this.getExam().getMaxRooms() + ") {";
            ret = (String)ret + "            var fid = sRooms.substring(1, sRooms.indexOf('@'));";
            ret = (String)ret + "            var fcap = sRooms.substring(sRooms.indexOf('@')+1, sRooms.indexOf(':',1));";
            ret = (String)ret + "            sRooms = sRooms.substring(sRooms.indexOf(':',1));";
            ret = (String)ret + "            sCap -= fcap; sNrRooms--; roomOut(fid);";
            ret = (String)ret + "        };";
            ret = (String)ret + "    }";
            ret = (String)ret + "    roomOut(id);";
            ret = (String)ret + "    if (sCap>=" + this.getExam().getNrStudents() + ") {displayLoading(); document.location='examInfo.action?op=Select&room='+sRooms+'&noCacheTS=" + new Date().getTime() + "';}";
            ret = (String)ret + "    var c = document.getElementById('roomCapacityCounter');";
            ret = (String)ret + "    if (c!=null) c.innerHTML = (sCap<" + this.getExam().getNrStudents() + "?'<font color=\"red\">'+sCap+'</font>':''+sCap);";
            ret = (String)ret + "}";
            ret = (String)ret + "</script>";
            ret = (String)ret + "<table border='0' cellspacing='0' cellpadding='3'>";
            int idx = 0;
            int step = 6;
            for (ExamRoomInfo room : rooms) {
                if (idx % step == 0) {
                    if (idx > 0) {
                        ret = (String)ret + "</tr>";
                    }
                    ret = (String)ret + "<tr>";
                }
                Object style = "";
                if (assigned != null && assigned.contains(room)) {
                    style = (String)style + "background-color:rgb(168,187,225);";
                }
                if (original != null && original.contains(room)) {
                    style = (String)style + "text-decoration:underline;";
                }
                if (!room.isHard()) {
                    style = (String)style + "font-style:italic;";
                }
                String mouse = "onMouseOver=\"roomOver(this," + room.getLocationId() + ");\" onMouseOut=\"roomOut(" + room.getLocationId() + ");\" onClick=\"roomClick(this," + room.getLocationId() + "," + room.getCapacity(this.getExam()) + ");\"";
                ret = (String)ret + "<td nowrap id='r" + room.getLocationId() + "' " + (String)(((String)style).length() > 0 ? "style='" + (String)style + "' " : "") + mouse + ">" + room.toString() + "</td>";
                if (idx % step < step - 1) {
                    style = (String)style + "border-right: #646464 1px dashed;";
                }
                ret = (String)ret + "<td id='c" + room.getLocationId() + "' " + (String)(((String)style).length() > 0 ? "style='" + (String)style + "' " : "") + mouse + ">" + room.getCapacity(this.getExam()) + "</td>";
                ++idx;
            }
            while (idx % step != 0) {
                ret = (String)ret + "<td colspan='2'>&nbsp;</td>";
                ++idx;
            }
            ret = (String)ret + "</tr>";
            ret = (String)ret + "</table>";
            return ret;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public Vector<ExamRoomInfo> getRooms() {
        if (this.getExam().getMaxRooms() == 0) {
            return null;
        }
        int minRoomSize = -1;
        try {
            minRoomSize = this.iForm.getMinRoomSize() == null || this.iForm.getMinRoomSize().length() == 0 ? -1 : Integer.parseInt(this.iForm.getMinRoomSize().trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        int maxRoomSize = -1;
        try {
            maxRoomSize = this.iForm.getMaxRoomSize() == null || this.iForm.getMaxRoomSize().length() == 0 ? -1 : Integer.parseInt(this.iForm.getMaxRoomSize().trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.getSelectedAssignment() == null && !this.isExamAssigned()) {
                return null;
            }
            if (this.iRooms == null) {
                if (this.getSolver() != null && this.getSolver().getExamTypeId().equals(this.getExam().getExamTypeId())) {
                    this.iRooms = this.getSolver().getRooms(this.getExam().getExamId(), this.getSelectedAssignment() != null ? this.getSelectedAssignment().getPeriodId() : this.getExamAssignment().getPeriodId(), this.iChange, minRoomSize, maxRoomSize, this.iForm.getRoomFilter(), this.iForm.getAllowRoomConflict());
                    this.filterRooms();
                } else {
                    this.iRooms = this.findRooms(this.getSelectedAssignment() != null ? this.getSelectedAssignment().getPeriod() : this.getExamAssignment().getPeriod(), minRoomSize, maxRoomSize, this.iForm.getRoomFilter(), this.iForm.getAllowRoomConflict());
                }
            }
            return this.iRooms;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public int getRoomSize() {
        ExamAssignmentInfo examAssignment;
        ExamAssignmentInfo examAssignmentInfo = examAssignment = this.iChange == null ? null : this.iChange.getCurrent(this.iExam);
        if (examAssignment != null) {
            return examAssignment.getRoomSize();
        }
        if (this.isExamAssigned()) {
            return this.getExamAssignment().getRoomSize();
        }
        return 0;
    }

    public ExamProposedChange getChange() {
        if (this.iChange == null || this.iChange.isEmpty()) {
            return null;
        }
        return this.iChange;
    }

    public static boolean match(String name, String filter) {
        if (filter == null || filter.trim().length() == 0) {
            return true;
        }
        String n = name.toUpperCase();
        StringTokenizer stk1 = new StringTokenizer(filter.toUpperCase(), ";");
        while (stk1.hasMoreTokens()) {
            StringTokenizer stk2 = new StringTokenizer(stk1.nextToken(), " ,");
            boolean match = true;
            while (match && stk2.hasMoreTokens()) {
                String token = stk2.nextToken().trim();
                if (token.length() == 0) continue;
                if (token.indexOf(42) >= 0 || token.indexOf(63) >= 0) {
                    try {
                        String tokenRegExp = "\\s+" + token.replaceAll("\\.", "\\.").replaceAll("\\?", ".+").replaceAll("\\*", ".*") + "\\s";
                        if (Pattern.compile(tokenRegExp).matcher(" " + n + " ").find()) continue;
                        match = false;
                    }
                    catch (PatternSyntaxException e) {
                        match = false;
                    }
                    continue;
                }
                if (n.indexOf(token) >= 0) continue;
                match = false;
            }
            if (!match) continue;
            return true;
        }
        return false;
    }

    public ExamConflictStatisticsInfo getCbs() {
        if (this.getSolver() != null && this.getSolver().getExamTypeId().equals(this.getExam().getExamTypeId())) {
            if (this.iCbs == null) {
                this.iCbs = this.getSolver().getCbsInfo(this.iExam.getExamId());
            }
            return this.iCbs;
        }
        return null;
    }

    public ExamSuggestionsInfo getSuggestions() {
        if (this.getSolver() != null && this.getSolver().getExamTypeId().equals(this.getExam().getExamTypeId())) {
            if (this.iSuggestions == null) {
                try {
                    this.iSuggestions = this.getSolver().getSuggestions(this.iExam.getExamId(), this.iChange, this.iForm.getFilter(), this.iForm.getDepth(), this.iForm.getLimit(), this.iForm.getTimeout());
                }
                catch (Exception e) {
                    sLog.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            return this.iSuggestions;
        }
        return null;
    }

    public boolean getCanComputeSuggestions() {
        return this.getSolver() != null && this.getSolver().getExamTypeId().equals(this.getExam().getExamTypeId());
    }

    public String getSuggestionTable() {
        ExamSuggestionsInfo suggestions = this.getSuggestions();
        if (suggestions == null) {
            return null;
        }
        Object ret = "<table border='0' cellspacing='0' cellpadding='3' width='100%'>";
        if (suggestions.getSuggestions() != null && !suggestions.getSuggestions().isEmpty()) {
            ret = (String)ret + "<tr>";
            ret = (String)ret + "<td><i>" + MSG.colValue() + "</i></td>";
            ret = (String)ret + "<td><i>" + MSG.colExamination() + "</i></td>";
            ret = (String)ret + "<td><i>" + MSG.colPeriodChange() + "</i></td>";
            ret = (String)ret + "<td><i>" + MSG.colRoomChange() + "</i></td>";
            ret = (String)ret + "<td><i>" + MSG.conflictDirect() + "</i></td>";
            ret = (String)ret + "<td><i>" + MSG.conflictMoreThanTwoADay().replace(">", "&gt;") + "</i></td>";
            ret = (String)ret + "<td><i>" + MSG.conflictBackToBack() + "</i></td>";
            ret = (String)ret + "</tr>";
            int idx = 0;
            for (ExamProposedChange suggestion : suggestions.getSuggestions()) {
                ret = (String)ret + suggestion.getHtmlLine(idx++);
            }
        }
        ret = (String)ret + "<tr><td colspan='7'><i>" + suggestions.getMessage() + "</i></td></tr>";
        ret = (String)ret + "</table>";
        return ret;
    }

    public boolean isSuggestionsTimeoutReached() {
        ExamSuggestionsInfo suggestions = this.getSuggestions();
        if (suggestions == null) {
            return false;
        }
        return suggestions.getTimeoutReached();
    }
}

