/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.exam.ui;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import org.cpsolver.coursett.preference.MinMaxPreferenceCombination;
import org.cpsolver.exam.criteria.ExamRotationPenalty;
import org.cpsolver.exam.criteria.InstructorBackToBackConflicts;
import org.cpsolver.exam.criteria.InstructorDirectConflicts;
import org.cpsolver.exam.criteria.InstructorDistanceBackToBackConflicts;
import org.cpsolver.exam.criteria.InstructorMoreThan2ADayConflicts;
import org.cpsolver.exam.criteria.InstructorNotAvailableConflicts;
import org.cpsolver.exam.criteria.PeriodPenalty;
import org.cpsolver.exam.criteria.RoomPenalty;
import org.cpsolver.exam.criteria.RoomSizePenalty;
import org.cpsolver.exam.criteria.RoomSplitPenalty;
import org.cpsolver.exam.criteria.StudentBackToBackConflicts;
import org.cpsolver.exam.criteria.StudentDirectConflicts;
import org.cpsolver.exam.criteria.StudentDistanceBackToBackConflicts;
import org.cpsolver.exam.criteria.StudentMoreThan2ADayConflicts;
import org.cpsolver.exam.criteria.StudentNotAvailableConflicts;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamDistributionConstraint;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamRoomPlacement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Session;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamPeriodPref;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.dao.ExamPeriodDAO;
import org.unitime.timetable.solver.exam.ui.ExamInfo;
import org.unitime.timetable.solver.exam.ui.ExamRoomInfo;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;

public class ExamAssignment
extends ExamInfo
implements Serializable {
    private static final long serialVersionUID = -5726339642542287195L;
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    protected static final ExaminationMessages MSG = Localization.create(ExaminationMessages.class);
    private Formats.Format<Number> s2Z = Formats.getNumberFormat("00");
    private Formats.Format<Date> sDateFormat = Formats.getDateFormat(Formats.Pattern.DATE_EXAM_PERIOD);
    protected Long iPeriodId = null;
    protected TreeSet<ExamRoomInfo> iRooms = null;
    protected String iPeriodPref = null;
    protected int iPeriodIdx = -1;
    protected transient ExamPeriod iPeriod = null;
    protected ExamInfo iExam = null;
    protected String iDistPref = null;
    protected int iNrDirectConflicts = 0;
    protected int iNrMoreThanTwoADayConflicts = 0;
    protected int iNrBackToBackConflicts = 0;
    protected int iNrDistanceBackToBackConflicts = 0;
    protected int iPeriodPenalty = 0;
    protected int iRoomSizePenalty = 0;
    protected int iRoomSplitPenalty = 0;
    protected int iRotationPenalty = 0;
    protected int iRoomPenalty = 0;
    protected int iNrInstructorDirectConflicts = 0;
    protected int iNrInstructorMoreThanTwoADayConflicts = 0;
    protected int iNrInstructorBackToBackConflicts = 0;
    protected int iNrInstructorDistanceBackToBackConflicts = 0;
    protected double iValue = 0.0;

    public ExamAssignment(ExamPlacement placement, Assignment<Exam, ExamPlacement> assignment) {
        this((Exam)placement.variable(), placement, assignment);
    }

    public ExamAssignment(Exam exam, ExamPlacement placement, Assignment<Exam, ExamPlacement> assignment) {
        super(exam);
        if (placement != null) {
            this.iNrDirectConflicts = (int)exam.getModel().getCriterion(StudentDirectConflicts.class).getValue(assignment, (Value)placement, null) + (int)exam.getModel().getCriterion(StudentNotAvailableConflicts.class).getValue(assignment, (Value)placement, null);
            this.iNrMoreThanTwoADayConflicts = (int)exam.getModel().getCriterion(StudentMoreThan2ADayConflicts.class).getValue(assignment, (Value)placement, null);
            this.iNrBackToBackConflicts = (int)exam.getModel().getCriterion(StudentBackToBackConflicts.class).getValue(assignment, (Value)placement, null);
            this.iNrDistanceBackToBackConflicts = (int)exam.getModel().getCriterion(StudentDistanceBackToBackConflicts.class).getValue(assignment, (Value)placement, null);
            this.iPeriodPenalty = (int)exam.getModel().getCriterion(PeriodPenalty.class).getValue(assignment, (Value)placement, null);
            this.iRoomSizePenalty = (int)exam.getModel().getCriterion(RoomSizePenalty.class).getValue(assignment, (Value)placement, null);
            this.iRoomSplitPenalty = (int)exam.getModel().getCriterion(RoomSplitPenalty.class).getValue(assignment, (Value)placement, null);
            this.iRotationPenalty = (int)exam.getModel().getCriterion(ExamRotationPenalty.class).getValue(assignment, (Value)placement, null);
            this.iRoomPenalty = (int)exam.getModel().getCriterion(RoomPenalty.class).getValue(assignment, (Value)placement, null);
            this.iNrInstructorDirectConflicts = (int)exam.getModel().getCriterion(InstructorDirectConflicts.class).getValue(assignment, (Value)placement, null) + (int)exam.getModel().getCriterion(InstructorNotAvailableConflicts.class).getValue(assignment, (Value)placement, null);
            this.iNrInstructorMoreThanTwoADayConflicts = (int)exam.getModel().getCriterion(InstructorMoreThan2ADayConflicts.class).getValue(assignment, (Value)placement, null);
            this.iNrInstructorBackToBackConflicts = (int)exam.getModel().getCriterion(InstructorBackToBackConflicts.class).getValue(assignment, (Value)placement, null);
            this.iNrInstructorDistanceBackToBackConflicts = (int)exam.getModel().getCriterion(InstructorDistanceBackToBackConflicts.class).getValue(assignment, (Value)placement, null);
            this.iValue = placement.toDouble(assignment);
            this.iPeriodId = placement.getPeriod().getId();
            this.iPeriodIdx = placement.getPeriod().getIndex();
            this.iRooms = new TreeSet();
            String string = this.iPeriodPref = exam.getPeriodPlacements().size() == 1 ? PreferenceLevel.sRequired : PreferenceLevel.int2prolog(this.iPeriodPenalty);
            if (placement.getRoomPlacements() != null) {
                boolean reqRoom = placement.getRoomPlacements().size() == exam.getRoomPlacements().size();
                for (ExamRoomPlacement room : placement.getRoomPlacements()) {
                    this.iRooms.add(new ExamRoomInfo(room.getRoom(), reqRoom ? PreferenceLevel.sIntLevelRequired : room.getPenalty(placement.getPeriod())));
                }
            }
            MinMaxPreferenceCombination pc = new MinMaxPreferenceCombination();
            for (ExamDistributionConstraint dc : ((Exam)placement.variable()).getDistributionConstraints()) {
                if (dc.isHard() || dc.isSatisfied(assignment)) continue;
                pc.addPreferenceInt(dc.getWeight());
            }
            this.iDistPref = pc.getPreferenceProlog();
        }
    }

    public ExamAssignment(org.unitime.timetable.model.Exam exam) {
        super(exam);
        if (exam.getAssignedPeriod() != null) {
            this.iPeriod = exam.getAssignedPeriod();
            this.iPeriodId = exam.getAssignedPeriod().getUniqueId();
            this.iRooms = new TreeSet();
            for (Location location : exam.getAssignedRooms()) {
                this.iRooms.add(new ExamRoomInfo(location, 0));
            }
            if (exam.getAssignedPreference() != null && exam.getAssignedPreference().length() > 0) {
                StringTokenizer stk = new StringTokenizer(exam.getAssignedPreference(), ":");
                if (stk.hasMoreTokens()) {
                    this.iPeriodPref = stk.nextToken();
                }
                if (stk.hasMoreTokens()) {
                    this.iDistPref = stk.nextToken();
                }
                Iterator<ExamRoomInfo> i = this.iRooms.iterator();
                while (i.hasNext() && stk.hasMoreTokens()) {
                    ExamRoomInfo room = i.next();
                    room.setPreference(Integer.parseInt(stk.nextToken()));
                }
            }
        }
    }

    public ExamAssignment(org.unitime.timetable.model.Exam exam, Hashtable<Long, Set<Long>> owner2students, Hashtable<Long, Hashtable<Long, Set<Long>>> onwer2course2students) {
        this(exam);
        if (owner2students != null) {
            this.createSections(owner2students);
        }
        if (onwer2course2students != null) {
            this.createSectionsIncludeCrosslistedDummies(onwer2course2students);
        }
    }

    public ExamAssignment(org.unitime.timetable.model.Exam exam, ExamPeriod period, Collection<ExamRoomInfo> rooms) throws Exception {
        super(exam);
        if (period == null) {
            return;
        }
        if (Constants.SLOT_LENGTH_MIN * period.getLength() < exam.getLength()) {
            throw new Exception(MSG.errorPeriodTooShort());
        }
        this.iPeriodPref = period.getPrefLevel().getPrefProlog();
        boolean reqPeriod = false;
        boolean hasPeriodPref = false;
        for (ExamPeriodPref periodPref : exam.getPreferences(ExamPeriodPref.class)) {
            if (PreferenceLevel.sRequired.equals(periodPref.getPrefLevel().getPrefProlog())) {
                reqPeriod = true;
            }
            if (!periodPref.getExamPeriod().equals(period)) continue;
            this.iPeriodPref = periodPref.getPrefLevel().getPrefProlog();
            hasPeriodPref = true;
        }
        if (exam.getExamType().getType() == 1 && !hasPeriodPref) {
            this.iPeriodPref = PreferenceLevel.sProhibited;
        }
        if (PreferenceLevel.sProhibited.equals(this.iPeriodPref)) {
            throw new Exception(MSG.errorPeriodProhibited());
        }
        if (reqPeriod && !PreferenceLevel.sRequired.equals(this.iPeriodPref)) {
            throw new Exception(MSG.errorPeriodNotRequired());
        }
        this.iPeriod = period;
        this.iPeriodId = period.getUniqueId();
        this.iRooms = new TreeSet();
        if (rooms != null) {
            this.iRooms.addAll(rooms);
        }
    }

    public String getAssignedPreferenceString() {
        String ret = this.getPeriodPref() + ":" + this.getDistributionPref();
        for (ExamRoomInfo room : this.getRooms()) {
            ret = ret + ":" + room.getPreference();
        }
        return ret;
    }

    public Long getPeriodId() {
        return this.iPeriodId;
    }

    public ExamPeriod getPeriod() {
        if (this.iPeriod == null) {
            if (this.getPeriodId() == null) {
                return null;
            }
            this.iPeriod = (ExamPeriod)ExamPeriodDAO.getInstance().get(this.getPeriodId());
        }
        return this.iPeriod;
    }

    public ExamPeriod getPeriod(Session hibSession) {
        return (ExamPeriod)ExamPeriodDAO.getInstance().get(this.getPeriodId(), hibSession);
    }

    public Comparable getPeriodOrd() {
        if (this.iPeriodIdx >= 0) {
            return Integer.valueOf(this.iPeriodIdx);
        }
        return this.iPeriod;
    }

    public String getPeriodName() {
        if (this.getPeriod() == null) {
            return "";
        }
        int start = this.getPeriod().getStartSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN + this.getPrintOffset();
        int end = start + this.getLength();
        return this.sDateFormat.format(this.getPeriod().getStartDate()) + " " + Constants.toTime(start) + " - " + Constants.toTime(end);
    }

    public String getPeriodNameFixedLength() {
        if (this.getPeriod() == null) {
            return "";
        }
        int min = this.getPeriod().getStartSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN + this.getPrintOffset();
        int startHour = min / 60;
        int startMin = min % 60;
        int endHour = (min += this.getLength()) / 60;
        int endMin = min % 60;
        if (endHour > 24) {
            endHour -= 24;
        }
        return this.sDateFormat.format(this.getPeriod().getStartDate()) + " " + this.s2Z.format(startHour == 0 ? 12 : (startHour > 12 ? startHour - 12 : startHour)) + ":" + this.s2Z.format(startMin) + (startHour < 24 && startHour >= 12 ? "p" : "a") + " - " + this.s2Z.format(endHour == 0 ? 12 : (endHour > 12 ? endHour - 12 : endHour)) + ":" + this.s2Z.format(endMin) + (endHour < 24 && endHour >= 12 ? "p" : "a");
    }

    public String getPeriodAbbreviation() {
        if (this.getPeriod() == null) {
            return "";
        }
        int start = this.getPeriod().getStartSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN + this.getPrintOffset();
        return this.sDateFormat.format(this.getPeriod().getStartDate()) + " " + Constants.toTime(start);
    }

    public String getPeriodNameWithPref() {
        if (this.iPeriodPref == null) {
            return this.getPeriodName();
        }
        if (ApplicationProperty.LegacyPeriodPreferences.isTrue()) {
            return "<span style='color:" + PreferenceLevel.prolog2color(this.iPeriodPref) + ";' onmouseover=\"showGwtTimeHint(this, '" + this.getExamId() + "," + this.getPeriodId() + "');\" onmouseout=\"hideGwtTimeHint();\">" + this.getPeriodName() + "</span>";
        }
        return "<span style='color:" + PreferenceLevel.prolog2color(this.iPeriodPref) + ";' onmouseover=\"showGwtExamPeriodPreferencesHint(this,'" + this.getExamId() + "','" + this.getPeriodId() + "');\" onmouseout=\"hideGwtPeriodPreferencesHint();\">" + this.getPeriodName() + "</span>";
    }

    public String getPeriodAbbreviationWithPref() {
        if (this.iPeriodPref == null) {
            return this.getPeriodAbbreviation();
        }
        if (ApplicationProperty.LegacyPeriodPreferences.isTrue()) {
            return "<span style='color:" + PreferenceLevel.prolog2color(this.iPeriodPref) + ";' onmouseover=\"showGwtTimeHint(this, '" + this.getExamId() + "," + this.getPeriodId() + "');\" onmouseout=\"hideGwtTimeHint();\">" + this.getPeriodAbbreviation() + "</span>";
        }
        return "<span style='color:" + PreferenceLevel.prolog2color(this.iPeriodPref) + ";' onmouseover=\"showGwtExamPeriodPreferencesHint(this,'" + this.getExamId() + "','" + this.getPeriodId() + "');\" onmouseout=\"hideGwtPeriodPreferencesHint();\">" + this.getPeriodAbbreviation() + "</span>";
    }

    public String getDate(boolean pref) {
        if (this.getPeriod() == null) {
            return "";
        }
        if (!pref || this.iPeriodPref == null || PreferenceLevel.sNeutral.equals(this.iPeriodPref)) {
            return this.sDateFormat.format(this.getPeriod().getStartDate());
        }
        return "<span title='" + PreferenceLevel.prolog2string(this.iPeriodPref) + " " + this.getPeriodName() + "' style='color:" + PreferenceLevel.prolog2color(this.iPeriodPref) + ";'>" + this.sDateFormat.format(this.getPeriod().getStartDate()) + "</span>";
    }

    public String getTime(boolean pref) {
        if (this.getPeriod() == null) {
            return "";
        }
        int start = this.getPeriod().getStartSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN + this.getPrintOffset();
        int end = start + this.getLength();
        if (!pref || this.iPeriodPref == null || PreferenceLevel.sNeutral.equals(this.iPeriodPref)) {
            return Constants.toTime(start) + " - " + Constants.toTime(end);
        }
        return "<span title='" + PreferenceLevel.prolog2string(this.iPeriodPref) + " " + this.getPeriodName() + "' style='color:" + PreferenceLevel.prolog2color(this.iPeriodPref) + ";'>" + Constants.toTime(start) + " - " + Constants.toTime(end) + "</span>";
    }

    public String getTimeFixedLength() {
        if (this.getPeriod() == null) {
            return "";
        }
        int min = this.getPeriod().getStartSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN + this.getPrintOffset();
        int startHour = min / 60;
        int startMin = min % 60;
        int endHour = (min += this.getLength()) / 60;
        int endMin = min % 60;
        if (endHour > 24) {
            endHour -= 24;
        }
        return this.s2Z.format(startHour == 0 ? 12 : (startHour > 12 ? startHour - 12 : startHour)) + ":" + this.s2Z.format(startMin) + (startHour < 24 && startHour >= 12 ? "p" : "a") + " - " + this.s2Z.format(endHour == 0 ? 12 : (endHour > 12 ? endHour - 12 : endHour)) + ":" + this.s2Z.format(endMin) + (endHour < 24 && endHour >= 12 ? "p" : "a");
    }

    public TreeSet<ExamRoomInfo> getRooms() {
        return this.iRooms;
    }

    public Vector<Long> getRoomIds() {
        Vector<Long> roomIds = new Vector<Long>(this.iRooms == null ? 0 : this.iRooms.size());
        if (this.iRooms != null) {
            for (ExamRoomInfo room : this.iRooms) {
                roomIds.add(room.getLocationId());
            }
        }
        return roomIds;
    }

    public boolean hasRoom(Long locationId) {
        if (this.iRooms == null) {
            return false;
        }
        for (ExamRoomInfo room : this.getRooms()) {
            if (!room.getLocationId().equals(locationId)) continue;
            return true;
        }
        return false;
    }

    public String getRoomsName(String delim) {
        return this.getRoomsName(false, delim);
    }

    public String getRoomsNameWithPref(String delim) {
        return this.getRoomsName(true, delim);
    }

    public String getRoomsName(boolean pref, String delim) {
        if (this.getPeriod() == null) {
            return "";
        }
        Object rooms = "";
        for (ExamRoomInfo room : this.getRooms()) {
            if (((String)rooms).length() > 0) {
                rooms = (String)rooms + delim;
            }
            rooms = (String)rooms + (pref ? room.toString() : room.getName());
        }
        return rooms;
    }

    public String getRoomsNameWithHint(boolean pref, String delim) {
        if (this.getPeriod() == null) {
            return "";
        }
        Object rooms = "";
        for (ExamRoomInfo room : this.getRooms()) {
            if (((String)rooms).length() > 0) {
                rooms = (String)rooms + delim;
            }
            rooms = (String)rooms + room.getNameWithHint(pref);
        }
        return rooms;
    }

    public String getRoomsCapacity(boolean pref, String delim) {
        if (this.getPeriod() == null) {
            return "";
        }
        Object rooms = "";
        for (ExamRoomInfo room : this.getRooms()) {
            if (((String)rooms).length() > 0) {
                rooms = (String)rooms + delim;
            }
            if (!pref) {
                rooms = (String)rooms + room.getCapacity();
                continue;
            }
            rooms = (String)rooms + "<span style='color:" + PreferenceLevel.prolog2color(PreferenceLevel.int2prolog(room.getPreference())) + ";' >" + room.getCapacity() + "</span>";
        }
        return rooms;
    }

    public int getRoomsCapacity() {
        if (this.getPeriod() == null) {
            return 0;
        }
        int cap = 0;
        for (ExamRoomInfo room : this.getRooms()) {
            cap += room.getCapacity();
        }
        return cap;
    }

    @Override
    public String toString() {
        return this.getExamName() + " " + this.getPeriodAbbreviation() + " " + this.getRoomsName(",");
    }

    public String getPeriodPref() {
        return this.iPeriodPref == null ? PreferenceLevel.sNeutral : this.iPeriodPref;
    }

    public void setPeriodPref(String periodPref) {
        this.iPeriodPref = periodPref;
    }

    public String getDistributionPref() {
        return this.iDistPref == null ? PreferenceLevel.sNeutral : this.iDistPref;
    }

    public String getRoomPref(Long locationId) {
        for (ExamRoomInfo room : this.getRooms()) {
            if (!room.getLocationId().equals(locationId)) continue;
            return PreferenceLevel.int2prolog(room.getPreference());
        }
        return PreferenceLevel.sNeutral;
    }

    public String getRoomPref() {
        MinMaxPreferenceCombination c = new MinMaxPreferenceCombination();
        for (ExamRoomInfo room : this.getRooms()) {
            c.addPreferenceInt(room.getPreference());
        }
        return c.getPreferenceProlog();
    }

    public boolean isValid() {
        return this.getMaxRooms() <= 0 || this.getRooms() != null && !this.getRooms().isEmpty();
    }

    public int getRoomSize() {
        if (this.getRooms() == null) {
            return 0;
        }
        int roomSize = 0;
        for (ExamRoomInfo room : this.getRooms()) {
            roomSize += room.getCapacity(this);
        }
        return roomSize;
    }

    @Override
    public int compareTo(ExamInfo info) {
        ExamPeriod otherPeriod;
        int cmp = this.getExamName().compareTo(info.getExamName());
        if (cmp != 0) {
            return cmp;
        }
        ExamPeriod examPeriod = otherPeriod = info instanceof ExamAssignment ? ((ExamAssignment)info).getPeriod() : null;
        if (this.getPeriod() == null) {
            if (otherPeriod != null) {
                return -1;
            }
        } else {
            if (otherPeriod == null) {
                return 1;
            }
            cmp = this.getPeriod().compareTo(otherPeriod);
            if (cmp != 0) {
                return cmp;
            }
        }
        return this.getExamId().compareTo(info.getExamId());
    }

    public int getPlacementNrDirectConflicts() {
        return this.iNrDirectConflicts;
    }

    public int getPlacementNrMoreThanTwoADayConflicts() {
        return this.iNrMoreThanTwoADayConflicts;
    }

    public int getPlacementNrBackToBackConflicts() {
        return this.iNrBackToBackConflicts;
    }

    public int getPlacementNrDistanceBackToBackConflicts() {
        return this.iNrDistanceBackToBackConflicts;
    }

    public int getPlacementPeriodPenalty() {
        return this.iPeriodPenalty;
    }

    public int getPlacementRoomSizePenalty() {
        return this.iRoomSizePenalty;
    }

    public int getPlacementRoomSplitPenalty() {
        return this.iRoomSplitPenalty;
    }

    public int getPlacementRotationPenalty() {
        return this.iRotationPenalty;
    }

    public int getPlacementRoomPenalty() {
        return this.iRoomPenalty;
    }

    public int getPlacementNrInstructorDirectConflicts() {
        return this.iNrInstructorDirectConflicts;
    }

    public int getPlacementNrInstructorMoreThanTwoADayConflicts() {
        return this.iNrInstructorMoreThanTwoADayConflicts;
    }

    public int getPlacementNrInstructorBackToBackConflicts() {
        return this.iNrInstructorBackToBackConflicts;
    }

    public int getPlacementNrInstructorDistanceBackToBackConflicts() {
        return this.iNrInstructorDistanceBackToBackConflicts;
    }

    public double getPlacementValue() {
        return this.iValue;
    }

    public int getNrRooms() {
        return this.iRooms == null ? 0 : this.iRooms.size();
    }

    public boolean assignmentEquals(ExamAssignment other) {
        if (!this.getExamId().equals(other.getExamId())) {
            return false;
        }
        return ToolBox.equals((Object)this.getPeriodId(), (Object)other.getPeriodId()) && ToolBox.equals(this.getRooms(), other.getRooms());
    }
}

