/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.solver;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.CourseTimetablingSolverInterface;
import org.unitime.timetable.gwt.shared.SolverInterface;
import org.unitime.timetable.gwt.shared.TableInterface;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.solver.SolverPageBackend;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.TimetableSolver;
import org.unitime.timetable.solver.interactive.ClassAssignmentDetails;
import org.unitime.timetable.solver.interactive.Suggestion;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.webutil.BackTracker;

@GwtRpcImplements(value=CourseTimetablingSolverInterface.AssignmentHistoryRequest.class)
public class AssignmentHistoryBackend
implements GwtRpcImplementation<CourseTimetablingSolverInterface.AssignmentHistoryRequest, CourseTimetablingSolverInterface.AssignmentHistoryResponse> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    protected static DecimalFormat sDF = new DecimalFormat("0.###", new DecimalFormatSymbols(Locale.US));
    protected static Formats.Format<Date> sTS = Formats.getDateFormat(Formats.Pattern.DATE_TIME_STAMP);
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;

    @Override
    public CourseTimetablingSolverInterface.AssignmentHistoryResponse execute(CourseTimetablingSolverInterface.AssignmentHistoryRequest request, SessionContext context) {
        context.checkPermission(Right.AssignmentHistory);
        CourseTimetablingSolverInterface.AssignmentHistoryResponse response = new CourseTimetablingSolverInterface.AssignmentHistoryResponse();
        context.getUser().setProperty("SuggestionsModel.simpleMode", request.getFilter().getParameterValue("simpleMode"));
        boolean simple = "1".equals(request.getFilter().getParameterValue("simpleMode"));
        SolverProxy solver = this.courseTimetablingSolverService.getSolver();
        List<TimetableSolver.AssignmentRecord> history = null;
        if (solver == null) {
            response.setMessage(MESSAGES.errorNoSolverLoaded());
        } else {
            history = solver.getAssignmentRecords();
        }
        if (history != null) {
            long idx = 0L;
            for (TimetableSolver.AssignmentRecord record : history) {
                TableInterface.TableCellMultiLine allClasses = new TableInterface.TableCellMultiLine();
                TableInterface.TableCellMultiLine allDates = new TableInterface.TableCellMultiLine();
                TableInterface.TableCellMultiLine allTimes = new TableInterface.TableCellMultiLine();
                TableInterface.TableCellMultiLine allRooms = new TableInterface.TableCellMultiLine();
                Long classId = null;
                for (TimetableSolver.RecordedAssignment assignment : record.getAssignments()) {
                    ClassAssignmentDetails ca;
                    ClassAssignmentDetails before = assignment.getBefore() == null ? null : assignment.getBefore().getDetails(context, solver, false);
                    ClassAssignmentDetails after = assignment.getAfter() == null ? null : assignment.getAfter().getDetails(context, solver, false);
                    ClassAssignmentDetails classAssignmentDetails = ca = after == null ? before : after;
                    if (classId == null) {
                        classId = ca.getClazz().getClassId();
                    }
                    TableInterface.TableCellChange date = new TableInterface.TableCellChange(before == null || before.getAssignedTime() == null ? null : new TableInterface.TableCellInterface<String>(before.getAssignedTime().getDatePatternName()).setColor(PreferenceLevel.int2color(before.getAssignedTime().getDatePatternPreference())), after == null || after.getAssignedTime() == null ? null : new TableInterface.TableCellInterface<String>(after.getAssignedTime().getDatePatternName()).setColor(PreferenceLevel.int2color(after.getAssignedTime().getDatePatternPreference())));
                    TableInterface.TableCellChange time = new TableInterface.TableCellChange(before == null || before.getAssignedTime() == null ? null : new TableInterface.TableCellTime(before.getAssignedTime().getDaysName() + " " + before.getAssignedTime().getStartTime()).setId(before.getClazz().getClassId() + "," + before.getAssignedTime().getDays() + "," + before.getAssignedTime().getStartSlot()).setColor(PreferenceLevel.int2color(before.getAssignedTime().getPref())), after == null || after.getAssignedTime() == null ? null : new TableInterface.TableCellTime(after.getAssignedTime().getDaysName() + " " + after.getAssignedTime().getStartTime()).setId(after.getClazz().getClassId() + "," + after.getAssignedTime().getDays() + "," + after.getAssignedTime().getStartSlot()).setColor(PreferenceLevel.int2color(after.getAssignedTime().getPref())));
                    TableInterface.TableCellChange room = new TableInterface.TableCellChange();
                    if (before != null && before.getAssignedRoom() != null) {
                        TableInterface.TableCellRooms beforeRooms = new TableInterface.TableCellRooms();
                        for (ClassAssignmentDetails.RoomInfo r : new TreeSet<ClassAssignmentDetails.RoomInfo>(Arrays.asList(before.getAssignedRoom()))) {
                            beforeRooms.add(r.getName(), r.getColor(), r.getId(), PreferenceLevel.int2string(r.getPref()));
                        }
                        room.setFirst(beforeRooms);
                        if (before.getAssignedRoom().length == 0 && after == null) {
                            room.setSecond(new TableInterface.TableCellRooms());
                        }
                    }
                    if (after != null && after.getAssignedRoom() != null) {
                        TableInterface.TableCellRooms afterRooms = new TableInterface.TableCellRooms();
                        for (ClassAssignmentDetails.RoomInfo r : new TreeSet<ClassAssignmentDetails.RoomInfo>(Arrays.asList(after.getAssignedRoom()))) {
                            afterRooms.add(r.getName(), r.getColor(), r.getId(), PreferenceLevel.int2string(r.getPref()));
                        }
                        room.setSecond(afterRooms);
                        if (after.getAssignedRoom().length == 0 && before == null) {
                            room.setFirst(new TableInterface.TableCellRooms());
                        }
                    }
                    allClasses.add(new TableInterface.TableCellClassName(ca.getClazz().getName()).setColor(PreferenceLevel.prolog2color(ca.getClazz().getPref())));
                    allDates.add(date);
                    allTimes.add(time);
                    allRooms.add(room);
                }
                Suggestion bSg = record.getBefore();
                Suggestion aSg = record.getAfter();
                TableInterface.TableCellMulti studentConfs = new TableInterface.TableCellMulti();
                studentConfs.add(this.dispNumber(aSg.getViolatedStudentConflicts() - bSg.getViolatedStudentConflicts()));
                if (aSg.getCommitedStudentConflicts() - bSg.getCommitedStudentConflicts() != 0L) {
                    if (studentConfs.getNrChunks() <= 1) {
                        studentConfs.add(" (");
                    } else {
                        studentConfs.add(",");
                    }
                    studentConfs.add(this.dispNumber(aSg.getCommitedStudentConflicts() - bSg.getCommitedStudentConflicts()).setFormattedValue("c" + (aSg.getCommitedStudentConflicts() - bSg.getCommitedStudentConflicts())));
                }
                if (aSg.getDistanceStudentConflicts() - bSg.getDistanceStudentConflicts() != 0L) {
                    if (studentConfs.getNrChunks() <= 1) {
                        studentConfs.add(" (");
                    } else {
                        studentConfs.add(",");
                    }
                    studentConfs.add(this.dispNumber(aSg.getDistanceStudentConflicts() - bSg.getDistanceStudentConflicts()).setFormattedValue("d" + (aSg.getDistanceStudentConflicts() - bSg.getDistanceStudentConflicts())));
                }
                if (aSg.getHardStudentConflicts() - bSg.getHardStudentConflicts() != 0L) {
                    if (studentConfs.getNrChunks() <= 1) {
                        studentConfs.add(" (");
                    } else {
                        studentConfs.add(",");
                    }
                    studentConfs.add(this.dispNumber(aSg.getHardStudentConflicts() - bSg.getHardStudentConflicts()).setFormattedValue("h" + (aSg.getHardStudentConflicts() - bSg.getHardStudentConflicts())));
                }
                if (studentConfs.getNrChunks() > 1) {
                    studentConfs.add(")");
                }
                if (simple) {
                    response.addRow(new TableInterface.TableRowInterface((Long)idx, "gwt.jsp?page=suggestions&menu=hide&id=" + classId + "&history=" + idx, MESSAGES.dialogSuggestions(), new TableInterface.TableCellInterface<Date>(record.getTimeStamp(), sTS.format(record.getTimeStamp())), this.dispNumber(aSg.getValue() - bSg.getValue()), allClasses, allDates, allTimes, allRooms, this.dispNumber(aSg.getUnassignedVariables() - bSg.getUnassignedVariables()), studentConfs));
                } else {
                    response.addRow(new TableInterface.TableRowInterface((Long)idx, "gwt.jsp?page=suggestions&menu=hide&id=" + classId + "&history=" + idx, MESSAGES.dialogSuggestions(), new TableInterface.TableCellInterface<Date>(record.getTimeStamp(), sTS.format(record.getTimeStamp())), this.dispNumber(aSg.getValue() - bSg.getValue()), allClasses, allDates, allTimes, allRooms, this.dispNumber(aSg.getUnassignedVariables() - bSg.getUnassignedVariables()), studentConfs, this.dispNumber(aSg.getGlobalTimePreference() - bSg.getGlobalTimePreference()), this.dispNumber(aSg.getGlobalRoomPreference() - bSg.getGlobalRoomPreference()), this.dispNumber(aSg.getGlobalGroupConstraintPreference() - bSg.getGlobalGroupConstraintPreference()), this.dispNumber(aSg.getInstructorDistancePreference() - bSg.getInstructorDistancePreference()), this.dispNumber(aSg.getUselessSlots() - bSg.getUselessSlots()), this.dispNumber(aSg.getTooBigRooms() - bSg.getTooBigRooms()), this.dispNumber(aSg.getDepartmentSpreadPenalty() - bSg.getDepartmentSpreadPenalty()), this.dispNumber(aSg.getSpreadPenalty() - bSg.getSpreadPenalty()), this.dispNumber(aSg.getPerturbationPenalty() - bSg.getPerturbationPenalty())));
                }
                ++idx;
            }
        }
        if (simple) {
            response.setHeader(new TableInterface.TableHeaderIterface(MESSAGES.colTimeStamp()), new TableInterface.TableHeaderIterface(MESSAGES.colScore()), new TableInterface.TableHeaderIterface(MESSAGES.colClass()), new TableInterface.TableHeaderIterface(MESSAGES.colDate()), new TableInterface.TableHeaderIterface(MESSAGES.colTime()), new TableInterface.TableHeaderIterface(MESSAGES.colRoom()), new TableInterface.TableHeaderIterface(MESSAGES.colShortUnassignments()), new TableInterface.TableHeaderIterface(MESSAGES.colNrStudentConflicts()));
        } else {
            response.setHeader(new TableInterface.TableHeaderIterface(MESSAGES.colTimeStamp()), new TableInterface.TableHeaderIterface(MESSAGES.colScore()), new TableInterface.TableHeaderIterface(MESSAGES.colClass()), new TableInterface.TableHeaderIterface(MESSAGES.colDate()), new TableInterface.TableHeaderIterface(MESSAGES.colTime()), new TableInterface.TableHeaderIterface(MESSAGES.colRoom()), new TableInterface.TableHeaderIterface(MESSAGES.colShortUnassignments()), new TableInterface.TableHeaderIterface(MESSAGES.colNrStudentConflicts()), new TableInterface.TableHeaderIterface(MESSAGES.colShortTimePref()), new TableInterface.TableHeaderIterface(MESSAGES.colShortRoomPref()), new TableInterface.TableHeaderIterface(MESSAGES.colShortDistPref()), new TableInterface.TableHeaderIterface(MESSAGES.colShortInstructorBtbPref()), new TableInterface.TableHeaderIterface(MESSAGES.colShortUselessHalfHours()), new TableInterface.TableHeaderIterface(MESSAGES.colShortTooBigRooms()), new TableInterface.TableHeaderIterface(MESSAGES.colShortDepartmentBalance()), new TableInterface.TableHeaderIterface(MESSAGES.colShortSameSubpartBalance()), new TableInterface.TableHeaderIterface(MESSAGES.colShortPerturbations()));
        }
        SolverPageBackend.fillSolverWarnings(context, solver, SolverInterface.SolverType.COURSE, response);
        BackTracker.markForBack(context, "gwt.jsp?page=solutionChanges", MESSAGES.pageSolutionChanges(), true, true);
        return response;
    }

    public TableInterface.TableCellInterface dispNumber(int value) {
        return new TableInterface.TableCellInterface<Integer>(value, (String)(value == 0 ? "" : (value <= 0 ? String.valueOf(value) : "+" + String.valueOf(value)))).setColor(value < 0 ? "green" : (value > 0 ? "red" : null));
    }

    public TableInterface.TableCellInterface dispNumber(double value) {
        return new TableInterface.TableCellInterface<Double>(value, (String)((double)Math.round(1000.0 * value) == 0.0 ? "" : (value >= 5.0E-4 ? "+" : "") + sDF.format(value))).setColor(value < 0.0 ? "green" : (value > 0.0 ? "red" : null));
    }
}

