/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.updates;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.model.Student;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.Customization;
import org.unitime.timetable.onlinesectioning.custom.WaitListComparatorProvider;
import org.unitime.timetable.onlinesectioning.custom.WaitListValidationProvider;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollments;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XOverride;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequestComparator;
import org.unitime.timetable.onlinesectioning.status.StatusPageSuggestionsAction;

public abstract class WaitlistedOnlineSectioningAction<T>
implements OnlineSectioningAction<T> {
    private static final long serialVersionUID = 1L;
    protected static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private Set<String> iWaitlistStatuses = null;
    private Set<String> iReschedulingStatuses = null;
    private Map<Student.StudentPriority, String> iPriorityStudentGroupReference = null;
    private Map<Student.StudentPriority, Query> iPriorityStudentQuery = null;

    public boolean hasWaitListingStatus(XStudent student, OnlineSectioningServer server) {
        String status = student.getStatus();
        if (status == null) {
            status = server.getAcademicSession().getDefaultSectioningStatus();
        }
        if (status != null) {
            if (this.iWaitlistStatuses == null) {
                this.iWaitlistStatuses = StudentSectioningStatus.getMatchingStatuses(server.getAcademicSession().getUniqueId(), StudentSectioningStatus.Option.waitlist, StudentSectioningStatus.Option.enrollment);
            }
            if (!this.iWaitlistStatuses.contains(status)) {
                return false;
            }
        }
        return true;
    }

    public boolean hasReSchedulingStatus(XStudent student, OnlineSectioningServer server) {
        String status = student.getStatus();
        if (status == null) {
            status = server.getAcademicSession().getDefaultSectioningStatus();
        }
        if (status != null) {
            if (this.iReschedulingStatuses == null) {
                this.iReschedulingStatuses = StudentSectioningStatus.getMatchingStatuses(server.getAcademicSession().getUniqueId(), StudentSectioningStatus.Option.reschedule, StudentSectioningStatus.Option.enrollment);
            }
            if (!this.iReschedulingStatuses.contains(status)) {
                return false;
            }
        }
        return true;
    }

    public boolean isWaitListed(XStudent student, XCourseRequest request, XOffering offering, OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (student == null || request == null || !request.isWaitlist() || !offering.isWaitList()) {
            return false;
        }
        if (request.getEnrollment() != null) {
            if (!request.getEnrollment().equals(request.getWaitListSwapWithCourseOffering())) {
                return false;
            }
            if (request.getIndex(offering) > request.getEnrolledCourseIndex()) {
                return false;
            }
            if (request.getEnrollment().getOfferingId().equals(offering.getOfferingId()) && request.isRequired(request.getEnrollment(), offering)) {
                return false;
            }
        }
        if (!student.canAssign(request, OnlineSectioningInterface.WaitListMode.WaitList)) {
            return false;
        }
        if (!this.hasWaitListingStatus(student, server)) {
            return false;
        }
        if (student.isFailedWaitlist(request.getCourseIdByOfferingId(offering.getOfferingId()))) {
            return false;
        }
        if (Customization.WaitListValidationProvider.hasProvider()) {
            Float credit = null;
            if (student.getMaxCreditOverride() != null && student.getMaxCredit() != null) {
                credit = Float.valueOf(0.0f);
                for (XRequest r : student.getRequests()) {
                    if (!(r instanceof XCourseRequest) || ((XCourseRequest)r).getEnrollment() == null) continue;
                    XCourseRequest cr = (XCourseRequest)r;
                    if (request.getWaitListSwapWithCourseOffering() != null && request.getWaitListSwapWithCourseOffering().getCourseId().equals(cr.getEnrollment().getCourseId())) continue;
                    credit = Float.valueOf(credit.floatValue() + cr.getEnrollment().getCredit(server));
                }
            }
            for (XCourse course : offering.getCourses()) {
                WaitListValidationProvider wp;
                if (!request.hasCourse(course.getCourseId())) continue;
                XOverride override = request.getOverride(course);
                if (override != null) {
                    if ("TBD".equals(override.getExternalId())) continue;
                    wp = (WaitListValidationProvider)Customization.WaitListValidationProvider.getProvider();
                    try {
                        if (wp.updateStudent(server, helper, student, helper.getAction())) {
                            override = request.getOverride(course);
                        }
                    }
                    catch (Exception e) {
                        helper.warn("Failed to check wait-list status for student " + student.getExternalId() + ": " + e.getMessage());
                    }
                } else if (credit != null && course.hasCredit() && credit.floatValue() + course.getMinCredit().floatValue() > student.getMaxCredit().floatValue()) {
                    wp = (WaitListValidationProvider)Customization.WaitListValidationProvider.getProvider();
                    try {
                        wp.updateStudent(server, helper, student, helper.getAction());
                    }
                    catch (Exception e) {
                        helper.warn("Failed to check wait-list status for student " + student.getExternalId() + ": " + e.getMessage());
                    }
                }
                if (override != null && !override.isApproved() || credit != null && course.hasCredit() && credit.floatValue() + course.getMinCredit().floatValue() > student.getMaxCredit().floatValue()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean isWaitListedAssumeApproved(XStudent student, XCourseRequest request, XOffering offering, XCourseId courseId, OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (student == null) {
            return false;
        }
        if (request == null || !request.isWaitlist()) {
            return false;
        }
        if (!offering.isWaitList()) {
            return false;
        }
        if (courseId == null) {
            return false;
        }
        if (request.getEnrollment() != null) {
            if (!request.getEnrollment().equals(request.getWaitListSwapWithCourseOffering())) {
                return false;
            }
            if (request.getIndex(offering) > request.getEnrolledCourseIndex()) {
                return false;
            }
            if (request.getEnrollment().getOfferingId().equals(offering.getOfferingId()) && request.isRequired(request.getEnrollment(), offering)) {
                return false;
            }
        }
        return this.hasWaitListingStatus(student, server);
    }

    public Student.StudentPriority getStudentPriority(XStudent student, OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (this.iPriorityStudentGroupReference == null) {
            Student.StudentPriority priority;
            this.iPriorityStudentGroupReference = new HashMap<Student.StudentPriority, String>();
            this.iPriorityStudentQuery = new HashMap<Student.StudentPriority, Query>();
            DataProperties config = server.getConfig();
            Student.StudentPriority[] studentPriorityArray = Student.StudentPriority.values();
            int n = studentPriorityArray.length;
            for (int i = 0; i < n && (priority = studentPriorityArray[i]) != Student.StudentPriority.Normal; ++i) {
                String groupRef;
                String priorityStudentFilter = config.getProperty("Load." + priority.name() + "StudentFilter", null);
                if (priorityStudentFilter != null && !priorityStudentFilter.isEmpty()) {
                    Query q = new Query(priorityStudentFilter);
                    this.iPriorityStudentQuery.put(priority, q);
                }
                if ((groupRef = config.getProperty("Load." + priority.name() + "StudentGroupReference", null)) == null || groupRef.isEmpty()) continue;
                this.iPriorityStudentGroupReference.put(priority, groupRef);
            }
        }
        for (Student.StudentPriority priority : Student.StudentPriority.values()) {
            if (priority == Student.StudentPriority.Normal) break;
            Query query = this.iPriorityStudentQuery.get(priority);
            String groupRef = this.iPriorityStudentGroupReference.get(priority);
            if (query != null && query.match(new StatusPageSuggestionsAction.StudentMatcher(student, server.getAcademicSession().getDefaultSectioningStatus(), server, false))) {
                return priority;
            }
            if (groupRef == null) continue;
            for (XStudent.XGroup g : student.getGroups()) {
                if (!groupRef.equals(g.getAbbreviation())) continue;
                return priority;
            }
        }
        return Student.StudentPriority.Normal;
    }

    public String getWaitListPosition(XOffering offering, XStudent student, XCourseRequest request, XCourseId courseId, OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (!this.isWaitListedAssumeApproved(student, request, offering, courseId, server, helper)) {
            return null;
        }
        if (!courseId.equals(request.getCourseIdByOfferingId(offering.getOfferingId()))) {
            return null;
        }
        XEnrollments enrl = server.getEnrollments(offering.getOfferingId());
        if (enrl == null) {
            return null;
        }
        WaitListComparatorProvider cmpProvider = (WaitListComparatorProvider)Customization.WaitListComparatorProvider.getProvider();
        Comparator<SectioningRequest> cmp = cmpProvider == null ? new SectioningRequestComparator() : cmpProvider.getComparator(server, helper);
        SectioningRequest sr = new SectioningRequest(offering, request, courseId, student, null, this.getStudentPriority(student, server, helper), null);
        sr.setNewEnrollment(request.getEnrollment());
        int before = 0;
        int total = 0;
        for (XCourseRequest cr : enrl.getRequests()) {
            XCourseId c;
            XStudent s;
            if (!cr.isWaitlist() || cr.getEnrollment() != null && (!cr.getEnrollment().equals(cr.getWaitListSwapWithCourseOffering()) || cr.getIndex(offering) > cr.getEnrolledCourseIndex() || cr.getEnrollment().getOfferingId().equals(offering.getOfferingId()) && cr.isRequired(cr.getEnrollment(), offering)) || !this.isWaitListedAssumeApproved(s = server.getStudent(cr.getStudentId()), cr, offering, c = cr.getCourseIdByOfferingId(offering.getOfferingId()), server, helper)) continue;
            ++total;
            if (cr.equals(request)) continue;
            SectioningRequest other = new SectioningRequest(offering, cr, c, s, null, this.getStudentPriority(s, server, helper), null);
            other.setNewEnrollment(cr.getEnrollment());
            if (cmp.compare(other, sr) >= 0) continue;
            ++before;
        }
        return MSG.waitListPosition(before + 1, total);
    }
}

