/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import jakarta.persistence.Transient;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.hibernate.Session;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseType;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.StudentSchedulingRule;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XInstructionalMethod;
import org.unitime.timetable.onlinesectioning.model.XOffering;

public class XSchedulingRule
implements Serializable,
Externalizable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iRuleName;
    private String iStudentFilter;
    private String iInstructonalMethod;
    private String iCourseName;
    private String iCourseType;
    private Boolean iDisjunctive;
    private Boolean iAppliesToFilter;
    private Boolean iAppliesToOnline;
    private Boolean iAppliesToBatch;
    private Boolean iAdminOverride;
    private Boolean iAdvisorOverride;
    transient Query iQuery = null;

    public XSchedulingRule() {
    }

    public XSchedulingRule(StudentSchedulingRule rule) {
        this.iUniqueId = rule.getUniqueId();
        this.iRuleName = rule.getRuleName();
        this.iStudentFilter = rule.getStudentFilter();
        this.iInstructonalMethod = rule.getInstructonalMethod();
        this.iCourseName = rule.getCourseName();
        this.iCourseType = rule.getCourseType();
        this.iDisjunctive = rule.getDisjunctive();
        this.iAppliesToFilter = rule.getAppliesToFilter();
        this.iAppliesToOnline = rule.getAppliesToOnline();
        this.iAppliesToBatch = rule.getAppliesToBatch();
        this.iAdminOverride = rule.getAdminOverride();
        this.iAdvisorOverride = rule.getAdvisorOverride();
    }

    public XSchedulingRule(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public String getRuleName() {
        return this.iRuleName;
    }

    public String getStudentFilter() {
        return this.iStudentFilter;
    }

    public String getInstructonalMethod() {
        return this.iInstructonalMethod;
    }

    public String getCourseName() {
        return this.iCourseName;
    }

    public String getCourseType() {
        return this.iCourseType;
    }

    public Boolean isDisjunctive() {
        return this.iDisjunctive;
    }

    public Boolean isAppliesToFilter() {
        return this.iAppliesToFilter;
    }

    public Boolean isAppliesToOnline() {
        return this.iAppliesToOnline;
    }

    public Boolean isAppliesToBatch() {
        return this.iAppliesToBatch;
    }

    public Boolean isAdminOverride() {
        return this.iAdminOverride;
    }

    public Boolean isAdvisorOverride() {
        return this.iAdvisorOverride;
    }

    public boolean hasCourseName() {
        return this.getCourseName() != null && !this.getCourseName().isEmpty();
    }

    public boolean matchesCourseName(String cn) {
        if (!this.hasCourseName()) {
            return true;
        }
        if (this.getCourseName().startsWith("!")) {
            return cn != null && !cn.matches(this.getCourseName().substring(1));
        }
        return cn != null && cn.matches(this.getCourseName());
    }

    public boolean hasCourseType() {
        return this.getCourseType() != null && !this.getCourseType().isEmpty();
    }

    public boolean matchesCourseType(String ct) {
        if (!this.hasCourseType()) {
            return true;
        }
        if (this.getCourseType().startsWith("!")) {
            return ct != null && !ct.matches(this.getCourseType().substring(1));
        }
        return ct != null && ct.matches(this.getCourseType());
    }

    public boolean matchesCourseType(CourseType ct) {
        return this.matchesCourseType(ct == null ? null : ct.getReference());
    }

    public boolean hasInstructionalMethod() {
        return this.getInstructonalMethod() != null && !this.getInstructonalMethod().isEmpty();
    }

    public boolean matchesInstructionalMethod(String im) {
        if (!this.hasInstructionalMethod()) {
            return true;
        }
        if (this.getInstructonalMethod().startsWith("!")) {
            return im != null && !im.matches(this.getInstructonalMethod().substring(1));
        }
        return im != null && im.matches(this.getInstructonalMethod());
    }

    public boolean matchesInstructionalMethod(InstructionalMethod im) {
        return this.matchesInstructionalMethod(im == null ? null : im.getReference());
    }

    public boolean matchesInstructionalMethod(XInstructionalMethod im) {
        return this.matchesInstructionalMethod(im == null ? null : im.getReference());
    }

    public boolean matchesCourse(XCourseId course, Session hibSession) {
        if (this.isDisjunctive().booleanValue()) {
            InstructionalOffering offering;
            if (this.hasCourseName() && this.matchesCourseName(course.getCourseName())) {
                return true;
            }
            if (this.hasCourseType() && this.matchesCourseType(course.getType())) {
                return true;
            }
            if (this.hasInstructionalMethod() && (offering = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(course.getOfferingId(), hibSession)) != null) {
                for (InstrOfferingConfig config : offering.getInstrOfferingConfigs()) {
                    if (!this.matchesInstructionalMethod(config.getEffectiveInstructionalMethod())) continue;
                    return true;
                }
            }
            return false;
        }
        if (this.hasCourseName() && !this.matchesCourseName(course.getCourseName())) {
            return false;
        }
        if (this.hasCourseType() && !this.matchesCourseType(course.getType())) {
            return false;
        }
        if (this.hasInstructionalMethod()) {
            InstructionalOffering offering = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(course.getOfferingId(), hibSession);
            boolean hasMatchingConfig = false;
            if (offering != null) {
                for (InstrOfferingConfig config : offering.getInstrOfferingConfigs()) {
                    if (!this.matchesInstructionalMethod(config.getEffectiveInstructionalMethod())) continue;
                    hasMatchingConfig = true;
                    break;
                }
            }
            if (!hasMatchingConfig) {
                return false;
            }
        }
        return true;
    }

    public boolean matchesCourse(XCourseId course, OnlineSectioningServer server) {
        if (this.isDisjunctive().booleanValue()) {
            XOffering offering;
            if (this.hasCourseName() && this.matchesCourseName(course.getCourseName())) {
                return true;
            }
            if (this.hasCourseType() && this.matchesCourseType(course.getType())) {
                return true;
            }
            if (this.hasInstructionalMethod() && (offering = server.getOffering(course.getOfferingId())) != null) {
                for (XConfig config : offering.getConfigs()) {
                    if (!this.matchesInstructionalMethod(config.getInstructionalMethod())) continue;
                    return true;
                }
            }
            return false;
        }
        if (this.hasCourseName() && !this.matchesCourseName(course.getCourseName())) {
            return false;
        }
        if (this.hasCourseType() && !this.matchesCourseType(course.getType())) {
            return false;
        }
        if (this.hasInstructionalMethod()) {
            XOffering offering = server.getOffering(course.getOfferingId());
            boolean hasMatchingConfig = false;
            if (offering != null) {
                for (XConfig config : offering.getConfigs()) {
                    if (!this.matchesInstructionalMethod(config.getInstructionalMethod())) continue;
                    hasMatchingConfig = true;
                    break;
                }
            }
            if (!hasMatchingConfig) {
                return false;
            }
        }
        return true;
    }

    public boolean matchesCourse(CourseOffering course) {
        if (this.isDisjunctive().booleanValue()) {
            if (this.hasCourseName() && this.matchesCourseName(course.getCourseName())) {
                return true;
            }
            if (this.hasCourseType() && this.matchesCourseType(course.getCourseType())) {
                return true;
            }
            if (this.hasInstructionalMethod()) {
                for (InstrOfferingConfig config : course.getInstructionalOffering().getInstrOfferingConfigs()) {
                    if (!this.matchesInstructionalMethod(config.getEffectiveInstructionalMethod())) continue;
                    return true;
                }
            }
            return false;
        }
        if (this.hasCourseName() && !this.matchesCourseName(course.getCourseName())) {
            return false;
        }
        if (this.hasCourseType() && !this.matchesCourseType(course.getCourseType())) {
            return false;
        }
        if (this.hasInstructionalMethod()) {
            boolean hasMatchingConfig = false;
            for (InstrOfferingConfig config : course.getInstructionalOffering().getInstrOfferingConfigs()) {
                if (!this.matchesInstructionalMethod(config.getEffectiveInstructionalMethod())) continue;
                hasMatchingConfig = true;
                break;
            }
            if (!hasMatchingConfig) {
                return false;
            }
        }
        return true;
    }

    @Transient
    public Query getStudentQuery() {
        if (this.iQuery == null) {
            this.iQuery = new Query(this.getStudentFilter());
        }
        return this.iQuery;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.iUniqueId);
        out.writeObject(this.iRuleName);
        out.writeObject(this.iStudentFilter);
        out.writeObject(this.iInstructonalMethod);
        out.writeObject(this.iCourseName);
        out.writeObject(this.iCourseType);
        out.writeObject(this.iDisjunctive);
        out.writeObject(this.iAppliesToFilter);
        out.writeObject(this.iAppliesToOnline);
        out.writeObject(this.iAppliesToBatch);
        out.writeObject(this.iAdminOverride);
        out.writeObject(this.iAdvisorOverride);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.iUniqueId = (Long)in.readObject();
        this.iRuleName = (String)in.readObject();
        this.iStudentFilter = (String)in.readObject();
        this.iInstructonalMethod = (String)in.readObject();
        this.iCourseName = (String)in.readObject();
        this.iCourseType = (String)in.readObject();
        this.iDisjunctive = (Boolean)in.readObject();
        this.iAppliesToFilter = (Boolean)in.readObject();
        this.iAppliesToOnline = (Boolean)in.readObject();
        this.iAppliesToBatch = (Boolean)in.readObject();
        this.iAdminOverride = (Boolean)in.readObject();
        this.iAdvisorOverride = (Boolean)in.readObject();
    }
}

