/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Reader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Uniform;
import org.restlet.data.Encoding;
import org.restlet.data.Header;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Protocol;
import org.restlet.engine.application.DecodeRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.ClientResource;
import org.restlet.resource.ResourceException;
import org.restlet.util.Series;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.DegreePlanInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.DegreePlansProvider;
import org.unitime.timetable.onlinesectioning.custom.ExternalTermProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.BannerTermProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.CriticalCoursesExplorers;
import org.unitime.timetable.onlinesectioning.custom.purdue.EduNavInterface;
import org.unitime.timetable.onlinesectioning.custom.purdue.GsonRepresentation;
import org.unitime.timetable.onlinesectioning.match.CourseMatcher;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XStudentId;
import org.unitime.timetable.onlinesectioning.server.DatabaseServer;

public class EduNavPlansProvider
implements DegreePlansProvider {
    private static Log sLog = LogFactory.getLog(EduNavPlansProvider.class);
    private Client iClient;
    private ExternalTermProvider iExternalTermProvider;
    private DegreePlansProvider iFallback;

    public EduNavPlansProvider() {
        String clazz;
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        protocols.add(Protocol.HTTP);
        protocols.add(Protocol.HTTPS);
        this.iClient = new Client(protocols);
        Context cx = new Context();
        cx.getParameters().add("readTimeout", this.getEduNavApiReadTimeout());
        this.iClient.setContext(cx);
        try {
            clazz = ApplicationProperty.CustomizationExternalTerm.value();
            this.iExternalTermProvider = clazz == null || clazz.isEmpty() ? new BannerTermProvider() : (ExternalTermProvider)Class.forName(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            sLog.error((Object)"Failed to create external term provider, using the default one instead.", (Throwable)e);
            this.iExternalTermProvider = new BannerTermProvider();
        }
        try {
            clazz = this.getEduNavFallbackProvider();
            if (clazz != null && !clazz.isEmpty()) {
                this.iFallback = (CriticalCoursesExplorers)Class.forName(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            sLog.error((Object)"Failed to create fallback degree plan provider.");
        }
    }

    protected String getEduNavApiReadTimeout() {
        return ApplicationProperties.getProperty("edunav.readTimeout", "60000");
    }

    protected String getEduNavApiSite() {
        return ApplicationProperties.getProperty("edunav.site");
    }

    protected String getEduNavApiAuthenticationKey() {
        return ApplicationProperties.getProperty("edunav.key.name", "edunav-api-key");
    }

    protected String getEduNavApiAuthenticationKeyValue() {
        return ApplicationProperties.getProperty("edunav.key.value");
    }

    protected String getEduNavFallbackProvider() {
        return ApplicationProperties.getProperty("edunav.fallbackProvider");
    }

    protected boolean getEduNavFallbackCombine() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("edunav.fallbackCombine"));
    }

    public String getEduNavIncludePlanContent() {
        return ApplicationProperties.getProperty("edunav.includePlanContent", "true");
    }

    protected String getDegreeWorksNoPlansMessage() {
        return ApplicationProperties.getProperty("edunav.noPlansMessage", "No EduNav plan is available.");
    }

    protected String getBannerId(XStudentId student) {
        Object id = student.getExternalId();
        while (((String)id).length() < 9) {
            id = "0" + (String)id;
        }
        return id;
    }

    protected String getBannerTerm(AcademicSessionInfo session) {
        return this.iExternalTermProvider.getExternalTerm(session);
    }

    protected Gson getGson(OnlineSectioningHelper helper) {
        GsonBuilder builder = new GsonBuilder();
        if (helper == null || helper.isDebugEnabled()) {
            builder.setPrettyPrinting();
        }
        return builder.create();
    }

    protected String toString(Reader reader) throws IOException {
        char[] buffer = new char[8192];
        StringBuilder out = new StringBuilder();
        int read = 0;
        while ((read = reader.read(buffer, 0, buffer.length)) > 0) {
            out.append(buffer, 0, read);
        }
        reader.close();
        return out.toString();
    }

    protected boolean isCourse(EduNavInterface.Element element) {
        return element.id != null && element.id.indexOf(32) >= 0 && element.name != null && !element.name.isEmpty();
    }

    protected String getSubject(EduNavInterface.Element element) {
        String courseName = element.id;
        if (courseName == null || courseName.indexOf(32) <= 0) {
            return null;
        }
        return courseName.substring(0, courseName.lastIndexOf(32));
    }

    protected String getCourseNbr(EduNavInterface.Element element) {
        String courseName = element.id;
        if (courseName == null || courseName.indexOf(32) <= 0) {
            return null;
        }
        return courseName.substring(courseName.lastIndexOf(32) + 1);
    }

    protected String getTitle(EduNavInterface.Element element) {
        TreeSet<String> rules = new TreeSet<String>();
        if (element.rules != null) {
            for (EduNavInterface.Rule rule : element.rules) {
                if (rule.label == null || rule.label.text == null || rule.label.text.isEmpty()) continue;
                rules.add(rule.label.text);
            }
        }
        if (rules.isEmpty()) {
            return element.name;
        }
        Iterator it = rules.iterator();
        while (it.hasNext()) {
            String string = (String)it.next();
            boolean contain = false;
            for (String other : rules) {
                if (other.equals(string) || !other.contains(string)) continue;
                contain = true;
            }
            if (!contain) continue;
            it.remove();
        }
        Object ret = "";
        for (String rule : rules) {
            ret = (String)ret + (((String)ret).isEmpty() ? "" : ", ") + rule;
        }
        return ret;
    }

    protected String getDegree(EduNavInterface.Plan plan) {
        if (plan == null || plan.goal == null || plan.goal.programs == null) {
            return null;
        }
        TreeSet<String> majors = new TreeSet<String>();
        for (EduNavInterface.Program program : plan.goal.programs) {
            if (program.majors == null) continue;
            for (EduNavInterface.Major major : program.majors) {
                if (major.name == null) continue;
                majors.add(major.name);
            }
        }
        Object ret = "";
        for (String major : majors) {
            ret = (String)ret + (((String)ret).isEmpty() ? "" : ", ") + major;
        }
        return ret;
    }

    protected String getDegreeShort(EduNavInterface.Plan plan) {
        if (plan == null || plan.goal == null || plan.goal.programs == null) {
            return null;
        }
        TreeSet<Object> majors = new TreeSet<Object>();
        for (EduNavInterface.Program program : plan.goal.programs) {
            if (program.majors == null) continue;
            for (EduNavInterface.Major major : program.majors) {
                if (major.id != null && major.degree != null) {
                    majors.add(major.id + "-" + major.degree);
                    continue;
                }
                if (major.id == null) continue;
                majors.add(major.id);
            }
        }
        Object ret = "";
        for (String string : majors) {
            ret = (String)ret + (((String)ret).isEmpty() ? "" : ", ") + string;
        }
        return ret;
    }

    protected String getSchool(EduNavInterface.Plan plan) {
        if (plan == null || plan.goal == null || plan.goal.programs == null) {
            return null;
        }
        TreeSet<String> schools = new TreeSet<String>();
        for (EduNavInterface.Program program : plan.goal.programs) {
            if (program.collegeName == null) continue;
            schools.add(program.collegeName);
        }
        Object ret = "";
        for (String school : schools) {
            ret = (String)ret + (((String)ret).isEmpty() ? "" : ", ") + school;
        }
        return ret;
    }

    @Override
    public List<DegreePlanInterface> getDegreePlans(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, CourseMatcher matcher) throws SectioningException {
        if (this.iFallback == null) {
            List<DegreePlanInterface> ret = this._getDegreePlans(server, helper, student, matcher);
            if (ret == null || ret.isEmpty()) {
                throw new SectioningException(this.getDegreeWorksNoPlansMessage()).withTypeInfo();
            }
            return ret;
        }
        if (this.getEduNavFallbackCombine()) {
            boolean has2;
            List<DegreePlanInterface> ret1 = null;
            List<DegreePlanInterface> ret2 = null;
            SectioningException e1 = null;
            SectioningException e2 = null;
            try {
                ret1 = this.iFallback.getDegreePlans(server, helper, student, matcher);
            }
            catch (SectioningException e) {
                e1 = e;
            }
            try {
                ret2 = this._getDegreePlans(server, helper, student, matcher);
            }
            catch (SectioningException e) {
                e2 = e;
            }
            boolean has1 = ret1 != null && !ret1.isEmpty();
            boolean bl = has2 = ret2 != null && !ret2.isEmpty();
            if (has2) {
                for (DegreePlanInterface p : ret2) {
                    p.setName("EduNav: " + p.getName());
                }
            }
            if (has1 && !has2) {
                return ret1;
            }
            if (has2 && !has1) {
                return ret2;
            }
            if (!has1 && !has2) {
                if (e2 != null) {
                    throw e2;
                }
                if (e1 != null) {
                    throw e1;
                }
                return null;
            }
            for (DegreePlanInterface p : ret2) {
                ret1.add(p);
            }
            return ret1;
        }
        try {
            List<DegreePlanInterface> ret = this._getDegreePlans(server, helper, student, matcher);
            if (ret != null && !ret.isEmpty()) {
                return ret;
            }
        }
        catch (Exception e) {
            helper.warn("EduNav has failed: " + e.getMessage());
        }
        return this.iFallback.getDegreePlans(server, helper, student, matcher);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected List<DegreePlanInterface> _getDegreePlans(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, CourseMatcher matcher) throws SectioningException {
        try {
            AcademicSessionInfo session = server.getAcademicSession();
            String bannerTerm = this.getBannerTerm(session);
            String studentId = this.getBannerId(student);
            if (helper.isDebugEnabled()) {
                helper.debug("Retrieving degree plans for " + student.getName() + " (term: " + bannerTerm + ", id:" + studentId + ")");
            }
            helper.getAction().addOptionBuilder().setKey("term").setValue(bannerTerm);
            helper.getAction().addOptionBuilder().setKey("studentId").setValue(studentId);
            ClientResource resource = null;
            try {
                resource = new ClientResource(this.getEduNavApiSite());
                resource.setNext((Uniform)this.iClient);
                resource.addQueryParameter("studentId", studentId);
                resource.addQueryParameter("includePlanContent", this.getEduNavIncludePlanContent());
                Series headers = (Series)resource.getRequestAttributes().get("org.restlet.http.headers");
                if (headers == null) {
                    headers = new Series(Header.class);
                    resource.getRequestAttributes().put("org.restlet.http.headers", headers);
                }
                headers.set(this.getEduNavApiAuthenticationKey(), this.getEduNavApiAuthenticationKeyValue());
                resource.accept(new Metadata[]{Encoding.GZIP, MediaType.APPLICATION_JSON});
                try {
                    resource.get();
                }
                catch (ResourceException exception) {
                    String message = null;
                    try {
                        message = this.toString(new DecodeRepresentation(resource.getResponseEntity()).getReader());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    throw new SectioningException(message != null && !message.isEmpty() ? message : exception.getMessage());
                }
                List results = (List)new GsonRepresentation((Representation)new DecodeRepresentation(resource.getResponseEntity()), EduNavInterface.Result.TYPE_LIST).getObject();
                Gson gson = this.getGson(helper);
                helper.getAction().addOptionBuilder().setKey("edunav-response").setValue(gson.toJson((Object)results));
                if (helper.isDebugEnabled()) {
                    helper.debug("Current degree plans: " + gson.toJson((Object)results));
                }
                ArrayList<DegreePlanInterface> ret = new ArrayList<DegreePlanInterface>();
                if (results != null) {
                    for (EduNavInterface.Result result : results) {
                        if (result == null || result.plan == null || result.plan.terms == null) continue;
                        DegreePlanInterface p = new DegreePlanInterface();
                        p.setId(result.id);
                        p.setName(result.name);
                        if (p.getName() == null || p.getName().isEmpty()) {
                            p.setName(this.getDegree(result.plan));
                        }
                        if (p.getName() == null || p.getName().isEmpty()) {
                            p.setName("Unnamed-" + (ret.size() + 1));
                        }
                        p.setDegree(this.getDegreeShort(result.plan));
                        p.setSchool(this.getSchool(result.plan));
                        p.setLastModified(result.updateDate == null ? null : new Date(result.updateDate));
                        p.setModifiedWho(result.owner);
                        ret.add(p);
                        for (EduNavInterface.Term term : result.plan.terms) {
                            if (!bannerTerm.equals(term.id)) continue;
                            DegreePlanInterface.DegreeGroupInterface root = new DegreePlanInterface.DegreeGroupInterface();
                            root.setChoice(false);
                            root.setDescription(term.name);
                            root.setId(term.id);
                            p.setGroup(root);
                            if (term.elements == null) continue;
                            for (EduNavInterface.Element element : term.elements) {
                                if (this.isCourse(element)) {
                                    Collection<? extends XCourseId> ids = server.findCourses(element.id, -1, matcher);
                                    DegreePlanInterface.DegreeCourseInterface course = new DegreePlanInterface.DegreeCourseInterface();
                                    course.setSubject(this.getSubject(element));
                                    course.setCourse(this.getCourseNbr(element));
                                    course.setTitle(element.name);
                                    course.setId(element.id);
                                    course.setCritical("mandatory".equals(element.type));
                                    if (ids != null) {
                                        for (XCourseId xCourseId : ids) {
                                            XCourse xc = xCourseId instanceof XCourse ? (XCourse)xCourseId : server.getCourse(xCourseId.getCourseId());
                                            if (xc == null || !xCourseId.getCourseName().startsWith(element.id)) continue;
                                            ClassAssignmentInterface.CourseAssignment ca = new ClassAssignmentInterface.CourseAssignment();
                                            ca.setCourseId(xc.getCourseId());
                                            ca.setSubject(xc.getSubjectArea());
                                            ca.setCourseNbr(xc.getCourseNumber());
                                            ca.setTitle(xc.getTitle());
                                            ca.setNote(xc.getNote());
                                            ca.setCreditAbbv(xc.getCreditAbbv());
                                            ca.setCreditText(xc.getCreditText());
                                            ca.setTitle(xc.getTitle());
                                            ca.setHasUniqueName(xc.hasUniqueName());
                                            ca.setLimit(xc.getLimit());
                                            if (server instanceof DatabaseServer) {
                                                InstructionalOffering io = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(xCourseId.getOfferingId(), helper.getHibSession());
                                                if (io != null) {
                                                    ca.setEnrollment(io.getEnrollment());
                                                    ca.setProjected(io.getDemand());
                                                    ca.setCanWaitList(io.effectiveWaitList());
                                                }
                                            } else {
                                                int firstChoiceReqs = 0;
                                                int enrl = 0;
                                                Collection<XCourseRequest> requests = server.getRequests(xCourseId.getOfferingId());
                                                if (requests != null) {
                                                    for (XCourseRequest r : requests) {
                                                        if (r.getEnrollment() != null && r.getEnrollment().getCourseId().equals(xCourseId.getCourseId())) {
                                                            ++enrl;
                                                        }
                                                        if (r.isAlternative() || r.getEnrollment() != null || !r.getCourseIds().get(0).equals(xCourseId)) continue;
                                                        ++firstChoiceReqs;
                                                    }
                                                }
                                                ca.setEnrollment(enrl);
                                                ca.setProjected(firstChoiceReqs);
                                                XOffering io = server.getOffering(xCourseId.getOfferingId());
                                                ca.setCanWaitList(io != null && io.isWaitList());
                                            }
                                            course.addCourse(ca);
                                        }
                                    }
                                    if (course.hasCourses()) {
                                        for (ClassAssignmentInterface.CourseAssignment courseAssignment : course.getCourses()) {
                                            if (!courseAssignment.getSubject().equals(course.getSubject()) || !courseAssignment.getCourseNbr().equals(course.getCourse())) continue;
                                            course.setCourseId(courseAssignment.getCourseId());
                                        }
                                    }
                                    root.addCourse(course);
                                    continue;
                                }
                                DegreePlanInterface.DegreePlaceHolderInterface placeHolder = new DegreePlanInterface.DegreePlaceHolderInterface();
                                placeHolder.setType(element.type);
                                if (element.name != null && !element.name.isEmpty()) {
                                    placeHolder.setName(element.name);
                                } else {
                                    placeHolder.setName(element.id);
                                }
                                placeHolder.setId(element.id);
                                if ("Additional Credits".equals(element.id) && element.hours != null && element.hours > 0.0) {
                                    placeHolder.setName("Additional " + new DecimalFormat("0.#").format(element.hours) + " Credit(s)");
                                }
                                root.addPlaceHolder(placeHolder);
                            }
                        }
                    }
                }
                ArrayList<DegreePlanInterface> arrayList = ret;
                return arrayList;
            }
            catch (SectioningException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SectioningException(e.getMessage(), e);
            }
            finally {
                if (resource != null) {
                    if (resource.getResponse() != null) {
                        resource.getResponse().release();
                    }
                    resource.release();
                }
            }
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SectioningException(e.getMessage(), e);
        }
    }

    @Override
    public void dispose() {
        try {
            this.iClient.stop();
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
        }
        if (this.iFallback != null) {
            this.iFallback.dispose();
            this.iFallback = null;
        }
    }
}

