/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.advisors;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.onlinesectioning.advisors.AdvisorCourseRequestsSubmit;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.PdfEventHandler;
import org.unitime.timetable.util.PdfFont;

public class AdvisorConfirmationPDF {
    private OnlineSectioningInterface.AdvisingStudentDetails iDetails;
    protected static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    protected static StudentSectioningConstants CONST = Localization.create(StudentSectioningConstants.class);

    public AdvisorConfirmationPDF(OnlineSectioningInterface.AdvisingStudentDetails details) {
        this.iDetails = details;
    }

    public OnlineSectioningInterface.AdvisingStudentDetails getDetails() {
        return this.iDetails;
    }

    public void generatePdfConfirmation(OutputStream out) throws IOException, DocumentException {
        Document document = new Document(PageSize.LETTER);
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)out);
        writer.setPageEvent((PdfPageEvent)new PdfEventHandler());
        document.open();
        CourseDemand.Critical critical = CourseDemand.Critical.fromText(ApplicationProperty.AdvisorCourseRequestsAllowCritical.valueOfSession(this.iDetails.getSessionId()));
        Image image = null;
        URL imageUrl = AdvisorCourseRequestsSubmit.class.getClassLoader().getResource(ApplicationProperty.AdvisorCourseRequestsPDFLogo.value());
        image = imageUrl != null ? Image.getInstance((URL)imageUrl) : Image.getInstance((URL)new URL(ApplicationProperty.AdvisorCourseRequestsPDFLogo.value()));
        image.scaleToFit(80.0f, 80.0f);
        PdfPTable header = new PdfPTable(new float[]{80.0f, 200.0f, 40.0f, 200.0f});
        header.setHeaderRows(0);
        header.setWidthPercentage(100.0f);
        Font font = PdfFont.getBigFont(true);
        PdfPCell imageCell = new PdfPCell();
        imageCell.setBorder(0);
        imageCell.addElement((Element)new Chunk(image, 0.0f, 0.0f));
        imageCell.setPaddingTop(Math.max(0.0f, font.getCalculatedLeading(1.5f) - image.getScaledHeight()));
        imageCell.setPaddingBottom(10.0f);
        header.addCell(imageCell);
        Paragraph ch = new Paragraph(MSG.pdfHeaderAdvisorCourseRequests(), font);
        ch.setAlignment(1);
        PdfPCell headerCell = new PdfPCell();
        headerCell.addElement((Element)ch);
        headerCell.setBorder(0);
        headerCell.setColspan(3);
        headerCell.setPaddingTop(Math.max(0.0f, image.getScaledHeight() - font.getCalculatedLeading(1.5f)));
        headerCell.setPaddingRight(80.0f);
        headerCell.setPaddingBottom(10.0f);
        header.addCell(headerCell);
        header.completeRow();
        if (this.getDetails().getStudentExternalId() != null) {
            header.addCell(this.header(MSG.propStudentName()));
            header.addCell(this.cell(this.getDetails().getStudentName()));
            header.addCell(this.header(MSG.propStudentExternalId()));
            header.addCell(this.cell(this.getDetails().getStudentExternalId()));
            header.addCell(this.header(MSG.propStudentEmail()));
            header.addCell(this.cell(this.getDetails().getStudentEmail()));
            header.addCell(this.header(MSG.propAcademicSession()));
            header.addCell(this.cell(this.getDetails().getSessionName()));
            header.addCell(this.header(MSG.propAdvisorEmail()));
            header.addCell(this.cell(this.getDetails().getAdvisorEmail()));
            header.addCell(this.header(MSG.propStudentStatus()));
            header.addCell(this.cell(this.getDetails().getStatus() == null ? "" : this.getDetails().getStatus().getLabel()));
            if (this.getDetails().getRequest().hasReleasedPin()) {
                header.addCell(this.header(""));
                header.addCell(this.cell(""));
                header.addCell(this.header(MSG.propStudentPin()));
                header.addCell(this.cell(this.getDetails().getRequest().getPin()));
            }
        } else {
            header.addCell(this.header(MSG.propStudentName()));
            header.addCell(this.cell(this.getDetails().getStudentName()));
            header.addCell(this.header(MSG.propAcademicSession()));
            header.addCell(this.cell(this.getDetails().getSessionName()));
            header.addCell(this.header(MSG.propStudentEmail()));
            header.addCell(this.cell(this.getDetails().getStudentEmail()));
            if (this.getDetails().getRequest().hasReleasedPin()) {
                header.addCell(this.header(MSG.propStudentStatus()));
                header.addCell(this.cell(this.getDetails().getStatus() == null ? "" : this.getDetails().getStatus().getLabel()));
            } else {
                PdfPCell sh = this.header(this.getDetails().getStatus() == null ? "" : MSG.propStudentStatus());
                sh.setRowspan(2);
                header.addCell(sh);
                PdfPCell sc = this.cell(this.getDetails().getStatus() == null ? "" : this.getDetails().getStatus().getLabel());
                sc.setRowspan(2);
                header.addCell(sc);
            }
            header.addCell(this.header(MSG.propAdvisorEmail()));
            header.addCell(this.cell(this.getDetails().getAdvisorEmail()));
            if (this.getDetails().getRequest().hasReleasedPin()) {
                header.addCell(this.header(MSG.propStudentPin()));
                header.addCell(this.cell(this.getDetails().getRequest().getPin()));
            }
        }
        document.add((Element)header);
        if (this.getDetails().getRequest().getCourses() != null && !this.getDetails().getRequest().getCourses().isEmpty()) {
            boolean hasWaitList = false;
            for (CourseRequestInterface.Request request : this.getDetails().getRequest().getCourses()) {
                if (this.getDetails().getWaitListMode() == OnlineSectioningInterface.WaitListMode.WaitList) {
                    if (!request.isWaitList()) continue;
                    hasWaitList = true;
                    break;
                }
                if (this.getDetails().getWaitListMode() != OnlineSectioningInterface.WaitListMode.NoSubs || !request.isNoSub()) continue;
                hasWaitList = true;
                break;
            }
            boolean hasCritical = false;
            for (CourseRequestInterface.Request r : this.getDetails().getRequest().getCourses()) {
                if (!r.hasCritical() || r.getCritical() <= 0) continue;
                hasCritical = true;
            }
            document.add((Element)this.courseTable(true, hasWaitList ? this.getDetails().getWaitListMode() : OnlineSectioningInterface.WaitListMode.None, hasCritical ? critical : CourseDemand.Critical.NORMAL));
        }
        if (this.getDetails().getRequest().getAlternatives() != null && !this.getDetails().getRequest().getAlternatives().isEmpty()) {
            document.add((Element)this.courseTable(false, OnlineSectioningInterface.WaitListMode.None, CourseDemand.Critical.NORMAL));
        }
        if (this.getDetails().getRequest().hasCreditNote()) {
            Paragraph p = new Paragraph(this.getDetails().getRequest().getCreditNote(), PdfFont.getSmallFont());
            p.setSpacingBefore(10.0f);
            document.add((Element)p);
        }
        PdfPTable sign = new PdfPTable(new float[]{PdfFont.getSmallFont(true).getBaseFont().getWidth(MSG.pdfAdvisorSignature()), PdfFont.getSmallFont(true).getBaseFont().getWidth(MSG.pdfSignatureDate())});
        sign.setSpacingBefore(20.0f);
        sign.setHeaderRows(0);
        sign.setKeepTogether(true);
        sign.setWidthPercentage(100.0f);
        sign.addCell(this.header(MSG.pdfAdvisorSignature()));
        sign.addCell(this.header(MSG.pdfSignatureDate()));
        PdfPCell h1 = this.header(MSG.pdfStudentSignature());
        h1.setPaddingTop(10.0f);
        sign.addCell(h1);
        PdfPCell pdfPCell = this.header(MSG.pdfSignatureDate());
        pdfPCell.setPaddingTop(10.0f);
        sign.addCell(pdfPCell);
        String disclaimer = ApplicationProperty.AdvisorCourseRequestsPDFDisclaimer.value();
        if (disclaimer != null && !disclaimer.isEmpty()) {
            PdfPCell disc = this.cell(disclaimer);
            disc.setPaddingTop(30.0f);
            disc.setColspan(2);
            sign.addCell(disc);
        }
        sign.setTotalWidth(document.right() - document.left());
        if (writer.getVerticalPosition(true) < sign.getTotalHeight() + document.bottom()) {
            document.newPage();
        }
        sign.writeSelectedRows(0, -1, document.left(), sign.getTotalHeight() + document.bottom(), writer.getDirectContent());
        document.close();
        out.flush();
        out.close();
    }

    private PdfPTable courseTable(boolean primary, OnlineSectioningInterface.WaitListMode waitListMode, CourseDemand.Critical critical) {
        Object ch;
        PdfPCell c;
        Font font = PdfFont.getSmallFont();
        float wP = (float)font.getBaseFont().getWidth(primary ? MSG.courseRequestsPriority(100) : MSG.courseRequestsAlternate(100)) * 0.001f * font.getSize();
        float wA = 20.0f + (float)font.getBaseFont().getWidth(MSG.courseRequestsAlternative(100)) * 0.001f * font.getSize() - wP;
        float wC = 5.0f + (float)font.getBaseFont().getWidth("999 - 999") * 0.001f * font.getSize();
        String criticalHead = null;
        switch (critical) {
            case CRITICAL: {
                criticalHead = MSG.opSetCritical();
                break;
            }
            case IMPORTANT: {
                criticalHead = MSG.opSetImportant();
                break;
            }
            case VITAL: {
                criticalHead = MSG.opSetVital();
            }
        }
        String waitListHead = null;
        switch (waitListMode) {
            case NoSubs: {
                waitListHead = MSG.colNoSubs();
                break;
            }
            case WaitList: {
                waitListHead = MSG.colWaitList();
            }
        }
        float wV = criticalHead == null ? 0.0f : 5.0f + (float)font.getBaseFont().getWidth(criticalHead) * 0.001f * font.getSize();
        float wW = waitListHead == null ? 0.0f : 5.0f + (float)font.getBaseFont().getWidth(waitListHead) * 0.001f * font.getSize();
        float pw = PageSize.LETTER.getWidth() - 72.0f;
        float wX = pw - wP - wA - wC - wV - wW;
        PdfPTable cr = waitListHead != null && criticalHead != null ? new PdfPTable(new float[]{wP, wA, wX * 0.4f, wC, wX * 0.6f, wV, wW}) : (waitListHead != null && criticalHead == null ? new PdfPTable(new float[]{wP, wA, wX * 0.4f, wC, wX * 0.6f, wW}) : (waitListHead == null && criticalHead != null ? new PdfPTable(new float[]{wP, wA, wX * 0.4f, wC, wX * 0.6f, wV}) : new PdfPTable(new float[]{wP, wA, wX * 0.4f, wC, wX * 0.6f})));
        cr.setHeaderRows(1);
        cr.setWidthPercentage(100.0f);
        cr.setKeepTogether(true);
        if (primary) {
            c = new PdfPCell();
            c.setBorder(0);
            font = PdfFont.getBigFont(true);
            font.setSize(font.getSize() * 0.8f);
            ch = new Paragraph(MSG.advisorRequestsCourses(), font);
            ch.setAlignment(0);
            ch.setSpacingBefore(10.0f);
            ch.setSpacingAfter(2.0f);
            c.addElement((Element)ch);
            c.setColspan(3);
            c.setBorder(2);
            c.setBorderWidth(0.1f);
            cr.addCell(c);
            c = this.italicNumber(MSG.colCredit());
            c.setVerticalAlignment(6);
            c.setBorder(2);
            c.setBorderWidth(0.1f);
            cr.addCell(c);
            c = this.italic(MSG.colNotes());
            c.setVerticalAlignment(6);
            c.setBorder(2);
            c.setBorderWidth(0.1f);
            cr.addCell(c);
            if (criticalHead != null) {
                c = this.italic(criticalHead);
                c.setVerticalAlignment(6);
                c.setBorder(2);
                c.setBorderWidth(0.1f);
                cr.addCell(c);
            }
            if (waitListMode != OnlineSectioningInterface.WaitListMode.None) {
                c = this.italic(waitListMode == OnlineSectioningInterface.WaitListMode.WaitList ? MSG.colWaitList() : MSG.colNoSubs());
                c.setVerticalAlignment(6);
                c.setBorder(2);
                c.setBorderWidth(0.1f);
                cr.addCell(c);
            }
        } else {
            c = new PdfPCell();
            c.setBorder(0);
            font = PdfFont.getBigFont(true);
            font.setSize(font.getSize() * 0.8f);
            ch = new Paragraph(MSG.advisorRequestsAlternatives(), font);
            Chunk x = new Chunk("          " + MSG.courseRequestsAlternativesNote());
            x.setFont(PdfFont.getSmallFont(false, true));
            ch.add((Object)x);
            ch.setAlignment(0);
            ch.setSpacingBefore(10.0f);
            ch.setSpacingAfter(2.0f);
            c.addElement((Element)ch);
            c.setColspan(5 + (criticalHead == null ? 0 : 1) + (waitListHead == null ? 0 : 1));
            c.setBorder(2);
            c.setBorderWidth(0.1f);
            cr.addCell(c);
        }
        int priority = 1;
        for (CourseRequestInterface.Request r : primary ? this.getDetails().getRequest().getCourses() : this.getDetails().getRequest().getAlternatives()) {
            int alt = 0;
            if (r.getRequestedCourse() == null) {
                PdfPCell wl;
                PdfPCell h = this.cell(MSG.courseRequestsPriority(priority));
                h.setBorder(2);
                h.setBorderWidth(0.1f);
                cr.addCell(h);
                PdfPCell course = this.cell("");
                course.setColspan(2);
                course.setBorder(2);
                course.setBorderWidth(0.1f);
                cr.addCell(course);
                PdfPCell credit = this.number(r.getAdvisorCredit());
                credit.setBorder(14);
                credit.setBorderWidth(0.1f);
                cr.addCell(credit);
                PdfPCell note = this.cell(r.getAdvisorNote());
                note.setBorder(2);
                note.setBorderWidth(0.1f);
                cr.addCell(note);
                if (criticalHead != null) {
                    PdfPCell vit = this.cell(r.isCritical() ? MSG.pdfCourseCritical() : (r.isVital() ? MSG.pdfCourseVital() : (r.isImportant() ? MSG.pdfCourseImportant() : MSG.pdfCourseNotCritical())));
                    ((Paragraph)vit.getCompositeElements().get(0)).setAlignment(1);
                    vit.setBorder(6);
                    vit.setBorderWidth(0.1f);
                    cr.addCell(vit);
                }
                if (waitListMode == OnlineSectioningInterface.WaitListMode.WaitList) {
                    wl = this.cell(r.isWaitList() ? MSG.pdfCourseWaitListed() : MSG.pdfCourseNotWaitListed());
                    ((Paragraph)wl.getCompositeElements().get(0)).setAlignment(1);
                    wl.setBorder(6);
                    wl.setBorderWidth(0.1f);
                    cr.addCell(wl);
                    continue;
                }
                if (waitListMode != OnlineSectioningInterface.WaitListMode.NoSubs) continue;
                wl = this.cell(r.isNoSub() ? MSG.pdfCourseWaitListed() : MSG.pdfCourseNotWaitListed());
                ((Paragraph)wl.getCompositeElements().get(0)).setAlignment(1);
                wl.setBorder(6);
                wl.setBorderWidth(0.1f);
                cr.addCell(wl);
                continue;
            }
            for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                PdfPCell course;
                PdfPCell h;
                boolean last;
                boolean bl = last = alt + 1 == r.getRequestedCourse().size();
                if (alt == 0) {
                    PdfPCell wl;
                    h = this.cell(MSG.courseRequestsPriority(priority));
                    if (last) {
                        h.setBorder(2);
                        h.setBorderWidth(0.1f);
                    }
                    cr.addCell(h);
                    course = this.course(rc);
                    course.setColspan(2);
                    if (last) {
                        course.setBorder(2);
                        course.setBorderWidth(0.1f);
                    }
                    cr.addCell(course);
                    PdfPCell credit = this.number(r.getAdvisorCredit());
                    credit.setBorder(14);
                    credit.setBorderWidth(0.1f);
                    credit.setRowspan(r.getRequestedCourse().size());
                    cr.addCell(credit);
                    PdfPCell note = this.cell(r.getAdvisorNote());
                    note.setBorder(2);
                    note.setBorderWidth(0.1f);
                    note.setRowspan(r.getRequestedCourse().size());
                    cr.addCell(note);
                    if (criticalHead != null) {
                        PdfPCell vit = this.cell(r.isCritical() ? MSG.pdfCourseCritical() : (r.isVital() ? MSG.pdfCourseVital() : (r.isImportant() ? MSG.pdfCourseImportant() : MSG.pdfCourseNotCritical())));
                        ((Paragraph)vit.getCompositeElements().get(0)).setAlignment(1);
                        vit.setBorder(6);
                        vit.setBorderWidth(0.1f);
                        vit.setRowspan(r.getRequestedCourse().size());
                        cr.addCell(vit);
                    }
                    if (waitListMode == OnlineSectioningInterface.WaitListMode.WaitList) {
                        wl = this.cell(r.isWaitList() ? MSG.pdfCourseWaitListed() : MSG.pdfCourseNotWaitListed());
                        ((Paragraph)wl.getCompositeElements().get(0)).setAlignment(1);
                        wl.setBorder(6);
                        wl.setBorderWidth(0.1f);
                        wl.setRowspan(r.getRequestedCourse().size());
                        cr.addCell(wl);
                    } else if (waitListMode == OnlineSectioningInterface.WaitListMode.NoSubs) {
                        wl = this.cell(r.isNoSub() ? MSG.pdfCourseWaitListed() : MSG.pdfCourseNotWaitListed());
                        ((Paragraph)wl.getCompositeElements().get(0)).setAlignment(1);
                        wl.setBorder(6);
                        wl.setBorderWidth(0.1f);
                        wl.setRowspan(r.getRequestedCourse().size());
                        cr.addCell(wl);
                    }
                } else {
                    h = this.cell(MSG.courseRequestsAlternative(alt));
                    h.setColspan(2);
                    h.setPaddingLeft(20.0f);
                    if (last) {
                        h.setBorder(2);
                        h.setBorderWidth(0.1f);
                    }
                    cr.addCell(h);
                    course = this.course(rc);
                    if (last) {
                        course.setBorder(2);
                        course.setBorderWidth(0.1f);
                    }
                    cr.addCell(course);
                }
                ++alt;
            }
            ++priority;
        }
        if (primary) {
            float min = 0.0f;
            float max = 0.0f;
            for (CourseRequestInterface.Request r : this.getDetails().getRequest().getCourses()) {
                if (!r.hasAdvisorCredit()) continue;
                String cred = r.getAdvisorCredit().replaceAll("\\s", "");
                try {
                    min += Float.parseFloat(cred);
                    max += Float.parseFloat(cred);
                }
                catch (NumberFormatException last) {
                    int idx = cred.indexOf(45);
                    if (idx < 0) continue;
                    try {
                        min += Float.parseFloat(cred.substring(0, idx));
                        max += Float.parseFloat(cred.substring(idx + 1));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            Object credTx = "";
            Formats.Format<Number> nf = Formats.getNumberFormat("0.#");
            credTx = min < max ? nf.format(Float.valueOf(min)) + " - " + nf.format(Float.valueOf(max)) : nf.format(Float.valueOf(min));
            PdfPCell credit = this.number(MSG.labelTotalPriorityCreditHours());
            credit.setColspan(3);
            cr.addCell(credit);
            credit = this.number((String)credTx);
            cr.addCell(credit);
            credit = this.cell("");
            credit.setColspan(1 + (criticalHead == null ? 0 : 1) + (waitListHead == null ? 0 : 1));
            cr.addCell(credit);
        }
        return cr;
    }

    private PdfPCell cell(String text, boolean bold, boolean italic, boolean right) {
        PdfPCell cell = new PdfPCell();
        cell.setVerticalAlignment(4);
        Font font = PdfFont.getSmallFont(bold, italic);
        Paragraph ch = new Paragraph(text, font);
        ch.setAlignment(right ? 2 : 0);
        if (right) {
            cell.setPaddingRight(5.0f);
        }
        ch.setLeading(0.0f, 1.0f);
        ch.setSpacingAfter(2.0f);
        cell.addElement((Element)ch);
        cell.setBorder(0);
        return cell;
    }

    private PdfPCell cell(String text) {
        return this.cell(text, false, false, false);
    }

    private PdfPCell header(String text) {
        return this.cell(text, true, false, false);
    }

    private PdfPCell number(String text) {
        return this.cell(text, false, false, true);
    }

    private PdfPCell italic(String text) {
        return this.cell(text, false, true, false);
    }

    private PdfPCell italicNumber(String text) {
        return this.cell(text, false, true, true);
    }

    private PdfPCell course(CourseRequestInterface.RequestedCourse rc) {
        Chunk x;
        PdfPCell course = new PdfPCell();
        Paragraph coursePg = new Paragraph(rc.toString(CONST), PdfFont.getSmallFont(true));
        coursePg.setLeading(0.0f, 1.0f);
        coursePg.setSpacingAfter(2.0f);
        coursePg.setAlignment(0);
        course.addElement((Element)coursePg);
        course.setBorder(0);
        boolean first = true;
        if (rc.hasSelectedClasses()) {
            for (CourseRequestInterface.Preference p : rc.getSelectedClasses()) {
                x = new Chunk((first ? "  " : ", ") + p.getText() + (p.isRequired() ? "!" : ""));
                x.setFont(PdfFont.getSmallFont());
                x.getFont().setSize(x.getFont().getSize() * 0.8f);
                x.getFont().setColor(Color.DARK_GRAY);
                coursePg.add((Object)x);
                first = false;
            }
        }
        if (rc.hasSelectedIntructionalMethods()) {
            for (CourseRequestInterface.Preference p : rc.getSelectedIntructionalMethods()) {
                x = new Chunk((first ? "  " : ", ") + p.getText() + (p.isRequired() ? "!" : ""));
                x.setFont(PdfFont.getSmallFont());
                x.getFont().setSize(x.getFont().getSize() * 0.8f);
                x.getFont().setColor(Color.DARK_GRAY);
                coursePg.add((Object)x);
                first = false;
            }
        }
        if (rc.hasCourseTitle()) {
            Chunk x2 = new Chunk((first ? "  " : " - ") + rc.getCourseTitle());
            x2.setFont(PdfFont.getSmallFont(false, true));
            x2.getFont().setSize(x2.getFont().getSize() * 0.8f);
            x2.getFont().setColor(Color.DARK_GRAY);
            coursePg.add((Object)x2);
        }
        return course;
    }
}

