/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.Curriculum;
import org.unitime.timetable.model.CurriculumClassification;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.PosMajor;

@MappedSuperclass
public abstract class BaseCurriculum
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iAbbv;
    private String iName;
    private Boolean iMultipleMajors;
    private AcademicArea iAcademicArea;
    private Department iDepartment;
    private Set<PosMajor> iMajors;
    private Set<CurriculumClassification> iClassifications;

    public BaseCurriculum() {
    }

    public BaseCurriculum(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="abbv", nullable=false, length=40)
    public String getAbbv() {
        return this.iAbbv;
    }

    public void setAbbv(String abbv) {
        this.iAbbv = abbv;
    }

    @Column(name="name", nullable=false, length=100)
    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    @Column(name="multiple_majors", nullable=false)
    public Boolean isMultipleMajors() {
        return this.iMultipleMajors;
    }

    @Transient
    public Boolean getMultipleMajors() {
        return this.iMultipleMajors;
    }

    public void setMultipleMajors(Boolean multipleMajors) {
        this.iMultipleMajors = multipleMajors;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="acad_area_id", nullable=false)
    public AcademicArea getAcademicArea() {
        return this.iAcademicArea;
    }

    public void setAcademicArea(AcademicArea academicArea) {
        this.iAcademicArea = academicArea;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="dept_id", nullable=false)
    public Department getDepartment() {
        return this.iDepartment;
    }

    public void setDepartment(Department department) {
        this.iDepartment = department;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="curriculum_major", joinColumns={@JoinColumn(name="curriculum_id")}, inverseJoinColumns={@JoinColumn(name="major_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<PosMajor> getMajors() {
        return this.iMajors;
    }

    public void setMajors(Set<PosMajor> majors) {
        this.iMajors = majors;
    }

    public void addToMajors(PosMajor posMajor) {
        if (this.iMajors == null) {
            this.iMajors = new HashSet<PosMajor>();
        }
        this.iMajors.add(posMajor);
    }

    @Deprecated
    public void addTomajors(PosMajor posMajor) {
        this.addToMajors(posMajor);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="curriculum", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<CurriculumClassification> getClassifications() {
        return this.iClassifications;
    }

    public void setClassifications(Set<CurriculumClassification> classifications) {
        this.iClassifications = classifications;
    }

    public void addToClassifications(CurriculumClassification curriculumClassification) {
        if (this.iClassifications == null) {
            this.iClassifications = new HashSet<CurriculumClassification>();
        }
        this.iClassifications.add(curriculumClassification);
    }

    @Deprecated
    public void addToclassifications(CurriculumClassification curriculumClassification) {
        this.addToClassifications(curriculumClassification);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Curriculum)) {
            return false;
        }
        if (this.getUniqueId() == null || ((Curriculum)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((Curriculum)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "Curriculum[" + this.getUniqueId() + " " + this.getName() + "]";
    }

    public String toDebugString() {
        return "Curriculum[\n\tAbbv: " + this.getAbbv() + "\n\tAcademicArea: " + String.valueOf(this.getAcademicArea()) + "\n\tDepartment: " + String.valueOf(this.getDepartment()) + "\n\tMultipleMajors: " + this.getMultipleMajors() + "\n\tName: " + this.getName() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

