/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.sectioning.EnrollmentTable;
import org.unitime.timetable.gwt.client.sectioning.SectioningCookie;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.WebTable;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningResources;
import org.unitime.timetable.gwt.services.SectioningService;
import org.unitime.timetable.gwt.services.SectioningServiceAsync;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;

public class StudentScheduleTable
extends Composite {
    public static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    public static final StudentSectioningResources RESOURCES = (StudentSectioningResources)GWT.create(StudentSectioningResources.class);
    public static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    protected static final SectioningServiceAsync sSectioningService = (SectioningServiceAsync)GWT.create(SectioningService.class);
    private boolean iOnline;
    private SimpleForm iPanel;
    private UniTimeHeaderPanel iHeader;
    private WebTable iTable;
    private ClassAssignmentInterface.Student iStudent;
    private boolean iShowTeachingAssignments;

    public StudentScheduleTable(boolean showHeader, boolean online, boolean showTeachingAssignments) {
        this.iOnline = online;
        this.iPanel = new SimpleForm();
        this.iShowTeachingAssignments = showTeachingAssignments;
        this.iHeader = new UniTimeHeaderPanel(showHeader ? MESSAGES.enrollmentsTable() : "&nbsp;");
        this.iHeader.addCollapsibleHandler(new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                SectioningCookie.getInstance().setEnrollmentCoursesDetails((Boolean)event.getValue());
                if (StudentScheduleTable.this.iTable.getTable().getRowCount() > 2) {
                    for (int row = 1; row < StudentScheduleTable.this.iTable.getTable().getRowCount(); ++row) {
                        StudentScheduleTable.this.iTable.getTable().getRowFormatter().setVisible(row, ((Boolean)event.getValue()).booleanValue());
                    }
                }
                if (StudentScheduleTable.this.iTable.getTable().getRowCount() == 0) {
                    StudentScheduleTable.this.refresh();
                }
            }
        });
        this.iHeader.setCollapsible(showHeader ? Boolean.valueOf(SectioningCookie.getInstance().getEnrollmentCoursesDetails()) : null);
        this.iHeader.setTitleStyleName("unitime3-HeaderTitle");
        this.iPanel.removeStyleName("unitime-NotPrintableBottomLine");
        if (showHeader) {
            this.iPanel.addHeaderRow((Widget)this.iHeader);
            this.iHeader.getElement().getStyle().setMarginTop(10.0, Style.Unit.PX);
        }
        this.iTable = new WebTable();
        this.iTable.addStyleName("unitime-Enrollments");
        this.iPanel.addRow((Widget)this.iTable);
        if (!showHeader) {
            this.iPanel.addBottomRow((Widget)this.iHeader);
        }
        this.iHeader.setEnabled("approve", false);
        this.iHeader.setEnabled("reject", false);
        this.iHeader.addButton("registration", MESSAGES.buttonRegistration(), new ClickHandler(){

            public void onClick(ClickEvent e) {
                EnrollmentTable.showCourseRequests(StudentScheduleTable.this.iStudent, StudentScheduleTable.this.iOnline, new AsyncCallback<Boolean>(){

                    public void onFailure(Throwable caught) {
                        UniTimeNotifications.error(caught);
                    }

                    public void onSuccess(Boolean result) {
                    }
                });
            }
        });
        this.iHeader.addButton("assistant", MESSAGES.buttonAssistant(), new ClickHandler(){

            public void onClick(ClickEvent e) {
                EnrollmentTable.showStudentAssistant(StudentScheduleTable.this.iStudent, StudentScheduleTable.this.iOnline, new AsyncCallback<Boolean>(){

                    public void onFailure(Throwable caught) {
                        UniTimeNotifications.error(caught);
                    }

                    public void onSuccess(Boolean result) {
                    }
                });
            }
        });
        if (this.iOnline) {
            this.iHeader.addButton("log", MESSAGES.buttonChangeLog(), new ClickHandler(){

                public void onClick(ClickEvent event) {
                    LoadingWidget.getInstance().show(MESSAGES.loadingChangeLog(StudentScheduleTable.this.iStudent.getName()));
                    EnrollmentTable.showChangeLog(StudentScheduleTable.this.iStudent, new AsyncCallback<Boolean>(){

                        public void onFailure(Throwable caught) {
                            LoadingWidget.getInstance().hide();
                            UniTimeNotifications.error(caught);
                        }

                        public void onSuccess(Boolean result) {
                            LoadingWidget.getInstance().hide();
                        }
                    });
                }
            });
        }
        this.initWidget((Widget)this.iPanel);
    }

    public void insert(final RootPanel panel) {
        String studentId = panel.getElement().getInnerText().trim();
        panel.getElement().setInnerText(null);
        panel.add((Widget)this);
        sSectioningService.lookupStudent(this.iOnline, studentId, new AsyncCallback<ClassAssignmentInterface.Student>(){

            public void onSuccess(ClassAssignmentInterface.Student result) {
                if (result != null) {
                    panel.setVisible(true);
                    StudentScheduleTable.this.setStudent(result);
                    if (SectioningCookie.getInstance().getEnrollmentCoursesDetails()) {
                        StudentScheduleTable.this.refresh();
                    } else {
                        StudentScheduleTable.this.clear();
                        StudentScheduleTable.this.iHeader.clearMessage();
                        StudentScheduleTable.this.iHeader.setCollapsible(false);
                    }
                }
            }

            public void onFailure(Throwable caught) {
            }
        });
    }

    public void setStudent(ClassAssignmentInterface.Student student) {
        this.iStudent = student;
        this.iHeader.setEnabled("registration", this.iStudent != null && this.iStudent.isCanRegister());
        this.iHeader.setEnabled("assistant", this.iStudent != null && this.iStudent.isCanUseAssistant());
        this.iHeader.setEnabled("log", this.iStudent != null && this.iStudent.isCanUseAssistant());
    }

    public void clear() {
        for (int row = this.iTable.getTable().getRowCount() - 1; row >= 0; --row) {
            this.iTable.getTable().removeRow(row);
        }
        this.iTable.getTable().clear(true);
    }

    public void refresh() {
        sSectioningService.getEnrollment(this.iOnline, this.iStudent.getId(), new AsyncCallback<ClassAssignmentInterface>(){

            public void onFailure(Throwable caught) {
                StudentScheduleTable.this.iHeader.setErrorMessage(MESSAGES.failedToLoadEnrollments(caught.getMessage()));
            }

            public void onSuccess(ClassAssignmentInterface result) {
                StudentScheduleTable.this.populate(result.getCourseAssignments());
            }
        });
    }

    public void populate(Collection<ClassAssignmentInterface.CourseAssignment> data) {
        this.clear();
        this.iTable.setHeader(new WebTable.Row(new WebTable.Cell(MESSAGES.colSubject(), 1, "75px"), new WebTable.Cell(MESSAGES.colCourse(), 1, "75px"), new WebTable.Cell(MESSAGES.colSubpart(), 1, "50px"), new WebTable.Cell(MESSAGES.colClass(), 1, "75px"), new WebTable.Cell(MESSAGES.colLimit(), 1, "60px"), new WebTable.Cell(MESSAGES.colTime(), 1, "150px"), new WebTable.Cell(MESSAGES.colDate(), 1, "75px"), new WebTable.Cell(MESSAGES.colRoom(), 1, "100px"), new WebTable.Cell(MESSAGES.colInstructor(), 1, "100px"), new WebTable.Cell(MESSAGES.colParent(), 1, "75px"), new WebTable.Cell(MESSAGES.colNoteIcon(), 1, "10px"), new WebTable.Cell(MESSAGES.colCredit(), 1, "75px")));
        this.iTable.setEmptyMessage(MESSAGES.emptySchedule());
        this.iHeader.clearMessage();
        ArrayList<WebTable.Row> rows = new ArrayList<WebTable.Row>();
        for (ClassAssignmentInterface.CourseAssignment course : data) {
            if (course.isAssigned()) {
                boolean firstClazz = true;
                for (ClassAssignmentInterface.ClassAssignment clazz : course.getClassAssignments()) {
                    Object style;
                    Object object = style = firstClazz && !rows.isEmpty() ? "top-border-dashed" : "";
                    if (clazz.isTeachingAssignment()) {
                        if (!this.iShowTeachingAssignments) continue;
                        style = (String)style + (clazz.isInstructing() ? " text-steelblue" : " text-steelblue-italic");
                    }
                    WebTable.Cell[] cellArray = new WebTable.Cell[12];
                    cellArray[0] = new WebTable.Cell(firstClazz ? (course.isFreeTime() ? MESSAGES.freeTimeSubject() : course.getSubject()) : "");
                    cellArray[1] = new WebTable.Cell(firstClazz ? (course.isFreeTime() ? MESSAGES.freeTimeCourse() : course.getCourseNbr()) : "");
                    cellArray[2] = new WebTable.Cell(clazz.getSubpart());
                    cellArray[3] = new WebTable.Cell(clazz.getSection());
                    cellArray[4] = new WebTable.Cell(clazz.getLimitString());
                    cellArray[5] = new WebTable.Cell(clazz.getDaysString(CONSTANTS.shortDays()) + " " + clazz.getStartString(CONSTANTS.useAmPm()) + " - " + clazz.getEndString(CONSTANTS.useAmPm()));
                    cellArray[6] = new WebTable.Cell(clazz.getDatePattern());
                    cellArray[7] = clazz.hasDistanceConflict() ? new WebTable.RoomCell(clazz.hasLongDistanceConflict() ? RESOURCES.longDistantConflict() : RESOURCES.distantConflict(), MESSAGES.backToBackDistance(clazz.getBackToBackRooms(), clazz.getBackToBackDistance()), clazz.getRooms(), ", ") : new WebTable.RoomCell((List<ClassAssignmentInterface.IdValue>)clazz.getRooms(), ", ");
                    cellArray[8] = new WebTable.InstructorCell(clazz.getInstructors(), clazz.getInstructorEmails(), ", ");
                    cellArray[9] = new WebTable.Cell(clazz.getParentSection());
                    cellArray[10] = clazz.hasNote() ? new WebTable.IconCell(RESOURCES.note(), clazz.getNote(), "") : new WebTable.Cell("");
                    cellArray[11] = new WebTable.AbbvTextCell(clazz.getCredit());
                    WebTable.Row row = new WebTable.Row(cellArray);
                    rows.add(row);
                    if (clazz.isTeachingAssignment()) {
                        row.setStyleName("teaching-assignment");
                    }
                    for (WebTable.Cell cell : row.getCells()) {
                        cell.setStyleName((String)style);
                    }
                    firstClazz = false;
                }
                continue;
            }
            String style = "text-red" + (!rows.isEmpty() ? " top-border-dashed" : "");
            WebTable.Row row = null;
            Object unassignedMessage = MESSAGES.courseNotAssigned();
            if (course.hasEnrollmentMessage()) {
                unassignedMessage = course.getEnrollmentMessage();
            } else if (course.isOverMaxCredit()) {
                unassignedMessage = MESSAGES.conflictOverMaxCredit(course.getOverMaxCredit().floatValue());
            } else if (course.getOverlaps() != null && !course.getOverlaps().isEmpty()) {
                unassignedMessage = "";
                Iterator<String> i = course.getOverlaps().iterator();
                while (i.hasNext()) {
                    String x = i.next();
                    unassignedMessage = ((String)unassignedMessage).isEmpty() ? (String)unassignedMessage + MESSAGES.conflictWithFirst(x) : (!i.hasNext() ? (String)unassignedMessage + MESSAGES.conflictWithLast(x) : (String)unassignedMessage + MESSAGES.conflictWithMiddle(x));
                    if (!i.hasNext()) continue;
                    unassignedMessage = (String)unassignedMessage + ", ";
                }
                if (course.getInstead() != null) {
                    unassignedMessage = (String)unassignedMessage + MESSAGES.conflictAssignedAlternative(course.getInstead());
                }
                unassignedMessage = (String)unassignedMessage + ".";
            } else if (course.isNotAvailable()) {
                unassignedMessage = course.hasConflictMessage() ? course.getConflictMessage() : (course.isFull() ? MESSAGES.courseIsFull() : (course.hasHasIncompReqs() ? MESSAGES.classNotAvailableDueToStudentPrefs() : MESSAGES.classNotAvailable()));
            } else if (course.isLocked()) {
                unassignedMessage = MESSAGES.courseLocked(course.getSubject() + " " + course.getCourseNbr());
            }
            WebTable.Cell[] cellArray = course.getClassAssignments().iterator();
            if (cellArray.hasNext()) {
                ClassAssignmentInterface.ClassAssignment clazz = cellArray.next();
                row = new WebTable.Row(new WebTable.Cell(course.isFreeTime() ? MESSAGES.freeTimeSubject() : course.getSubject()), new WebTable.Cell(course.isFreeTime() ? MESSAGES.freeTimeCourse() : course.getCourseNbr()), new WebTable.Cell(clazz.getSubpart()), new WebTable.Cell(clazz.getSection()), new WebTable.Cell(clazz.getLimitString()), new WebTable.Cell(clazz.getDaysString(CONSTANTS.shortDays())), new WebTable.Cell(clazz.getStartString(CONSTANTS.useAmPm())), new WebTable.Cell(clazz.getEndString(CONSTANTS.useAmPm())), new WebTable.Cell(clazz.getDatePattern()), new WebTable.Cell((String)unassignedMessage, 3, null), clazz.getNote() == null ? new WebTable.Cell("") : new WebTable.IconCell(RESOURCES.note(), clazz.getNote(), ""), new WebTable.AbbvTextCell(clazz.getCredit()));
            }
            if (row == null) {
                row = new WebTable.Row(new WebTable.Cell(course.getSubject()), new WebTable.Cell(course.getCourseNbr()), new WebTable.Cell((String)unassignedMessage, 12, null));
            }
            for (WebTable.Cell cell : row.getCells()) {
                cell.setStyleName(style);
            }
            row.getCell(row.getNrCells() - 1).setStyleName("text-gray" + (!rows.isEmpty() ? " top-border-dashed" : ""));
            rows.add(row);
        }
        WebTable.Row[] rowArray = new WebTable.Row[rows.size()];
        int idx = 0;
        for (WebTable.Row row : rows) {
            rowArray[idx++] = row;
        }
        this.iTable.setData(rowArray);
    }
}

