/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.offerings;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.gwt.client.aria.ImageButton;
import org.unitime.timetable.gwt.client.widgets.NumberBox;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeConfirmationDialog;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.InstrOfferingConfigInterface;

public class InstrOfferingConfigTable
extends UniTimeTable<InstrOfferingConfigInterface.SubpartLine> {
    protected static final CourseMessages MESSAGES = (CourseMessages)GWT.create(CourseMessages.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    private InstrOfferingConfigInterface iData;
    private NumberFormat sRoomRatioFormat = NumberFormat.getFormat((String)"##0.0##");

    public InstrOfferingConfigTable(InstrOfferingConfigInterface data) {
        this.iData = data;
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        for (InstrOfferingConfigInterface.InstrOfferingConfigColumn col : InstrOfferingConfigInterface.InstrOfferingConfigColumn.values()) {
            if (!this.isColumnVisible(col)) continue;
            UniTimeTableHeader h = new UniTimeTableHeader(this.getColumnName(col));
            header.add(h);
            h.setHorizontalAlignment(this.getColumnAlighment(col));
            if (col != InstrOfferingConfigInterface.InstrOfferingConfigColumn.MINS_PER_WK) continue;
            h.getElement().getStyle().setWidth(65.0, Style.Unit.PX);
            h.getElement().getStyle().clearWhiteSpace();
        }
        this.addRow(null, header);
        this.setData(data.getSubpartLines());
        this.setUnlimited(data.isUnlimited());
    }

    protected List<Widget> generateRow(InstrOfferingConfigInterface.SubpartLine subpart) {
        ArrayList<Widget> line = new ArrayList<Widget>();
        for (InstrOfferingConfigInterface.InstrOfferingConfigColumn col : InstrOfferingConfigInterface.InstrOfferingConfigColumn.values()) {
            if (!this.isColumnVisible(col)) continue;
            Widget w = this.getColumnWidget(col, subpart);
            line.add(w);
        }
        return line;
    }

    protected void addRow(InstrOfferingConfigInterface.SubpartLine subpart) {
        this.addRow(subpart, this.generateRow(subpart));
    }

    public void setData(List<InstrOfferingConfigInterface.SubpartLine> subparts) {
        this.clearTable(1);
        if (subparts != null) {
            for (InstrOfferingConfigInterface.SubpartLine subpart : subparts) {
                this.addRow(subpart);
            }
        }
    }

    public void updateButtons() {
        for (int row = 1; row < this.getRowCount(); ++row) {
            for (int col = 0; col < this.getCellCount(row); ++col) {
                Widget w = this.getWidget(row, col);
                if (w == null || !(w instanceof HasUpdate)) continue;
                ((HasUpdate)w).update(row);
            }
        }
        this.onLimitChange();
    }

    protected void onLimitChange() {
    }

    public void setUnlimited(Boolean unlimited) {
        if (Boolean.TRUE.equals(unlimited)) {
            for (InstrOfferingConfigInterface.InstrOfferingConfigColumn col : InstrOfferingConfigInterface.InstrOfferingConfigColumn.values()) {
                int idx = this.getIndex(col);
                if (idx < 0) continue;
                this.setColumnVisible(idx, this.isColumnVisibleWhenUnlimited(col));
            }
        } else {
            for (InstrOfferingConfigInterface.InstrOfferingConfigColumn col : InstrOfferingConfigInterface.InstrOfferingConfigColumn.values()) {
                int idx = this.getIndex(col);
                if (idx < 0) continue;
                this.setColumnVisible(idx, true);
            }
        }
    }

    protected void addSubpartLine(Long itype) {
        InstrOfferingConfigInterface.SubpartLine subpart = this.iData.addSubpartLine(this.iData.getInstructionalType(itype));
        this.addRow(subpart, this.generateRow(subpart));
        this.updateButtons();
        this.focus(this.getWidget(this.getRowCount() - 1, this.getIndex(InstrOfferingConfigInterface.InstrOfferingConfigColumn.LIMIT)));
    }

    public boolean isColumnVisibleWhenUnlimited(InstrOfferingConfigInterface.InstrOfferingConfigColumn column) {
        switch (column) {
            case LIMIT: 
            case NBR_ROOMS: 
            case ROOM_RATIO: 
            case SPLIT_ATTENDANCE: {
                return false;
            }
        }
        return true;
    }

    public boolean isColumnVisible(InstrOfferingConfigInterface.InstrOfferingConfigColumn column) {
        switch (column) {
            default: 
        }
        return true;
    }

    public String getColumnName(InstrOfferingConfigInterface.InstrOfferingConfigColumn column) {
        switch (column) {
            case ERROR: {
                return "";
            }
            case LABEL: {
                return "";
            }
            case BUTTONS: {
                return "";
            }
            case LIMIT: {
                if (this.iData.isDisplayMaxLimit()) {
                    return MESSAGES.columnSubpartLimitPerClass() + "<br>" + MESSAGES.columnMin() + " - " + MESSAGES.columnMax();
                }
                return MESSAGES.columnSubpartLimitPerClass();
            }
            case ROOM_RATIO: {
                return MESSAGES.columnRoomRatioBr();
            }
            case NBR_ROOMS: {
                return MESSAGES.columnSubpartNumberOfRooms();
            }
            case SPLIT_ATTENDANCE: {
                return MESSAGES.columnRoomSplitAttendance();
            }
            case DEPARTMENT: {
                return MESSAGES.columnSubpartManagingDepartment();
            }
            case MINS_PER_WK: {
                return this.iData.getDurationTypeId() == null ? MESSAGES.columnSubpartMinutesPerWeek() : this.iData.getDurationType(this.iData.getDurationTypeId()).getLabel();
            }
            case NBR_CLASSES: {
                return MESSAGES.columnSubpartNumberOfClasses();
            }
        }
        return column.name();
    }

    public HasHorizontalAlignment.HorizontalAlignmentConstant getColumnAlighment(InstrOfferingConfigInterface.InstrOfferingConfigColumn column) {
        switch (column) {
            default: 
        }
        return HasHorizontalAlignment.ALIGN_LEFT;
    }

    public int getIndex(InstrOfferingConfigInterface.InstrOfferingConfigColumn column) {
        if (!this.isColumnVisible(column)) {
            return -1;
        }
        int index = 0;
        for (InstrOfferingConfigInterface.InstrOfferingConfigColumn c : InstrOfferingConfigInterface.InstrOfferingConfigColumn.values()) {
            if (c.ordinal() >= column.ordinal() || !this.isColumnVisible(c)) continue;
            ++index;
        }
        return index;
    }

    protected void updateLine(InstrOfferingConfigInterface.SubpartLine line) {
        for (int row = 1; row < this.getRowCount(); ++row) {
            if (!line.getSubpartId().equals(((InstrOfferingConfigInterface.SubpartLine)this.getData(row)).getSubpartId())) continue;
            this.setRow(row, line, this.generateRow(line));
            break;
        }
    }

    protected int getRow(InstrOfferingConfigInterface.SubpartLine line) {
        if (line == null) {
            return -1;
        }
        for (int row = 1; row < this.getRowCount(); ++row) {
            if (!line.equals(this.getData(row))) continue;
            return row;
        }
        return -1;
    }

    protected boolean focus(Widget w) {
        if (w instanceof Focusable) {
            ((Focusable)w).setFocus(true);
            return true;
        }
        return false;
    }

    public Widget getColumnWidget(InstrOfferingConfigInterface.InstrOfferingConfigColumn column, final InstrOfferingConfigInterface.SubpartLine line) {
        switch (column) {
            case ERROR: {
                Error error = new Error(line);
                error.update(this.getRowCount());
                return error;
            }
            case LABEL: {
                SubpartLabel subpartLabel = new SubpartLabel(line);
                subpartLabel.update(this.getRowCount());
                return subpartLabel;
            }
            case BUTTONS: {
                Buttons buttons = new Buttons();
                Operation right = new Operation(line, RESOURCES.arrowRight(), MESSAGES.titleMoveToChildLevel(), new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        int idx = InstrOfferingConfigTable.this.iData.getSubpartLines().indexOf(line);
                        if (idx <= 0) {
                            return;
                        }
                        InstrOfferingConfigInterface.SubpartLine before = InstrOfferingConfigTable.this.iData.getSubpartLines().get(idx - 1);
                        if (before == null) {
                            return;
                        }
                        line.setParentId(InstrOfferingConfigTable.this.iData.getParentsWithMe(before).get(line.getIndent()).getSubpartId());
                        for (InstrOfferingConfigInterface.SubpartLine l : InstrOfferingConfigTable.this.iData.getLines(line)) {
                            l.setIndent(l.getIndent() + 1);
                        }
                        InstrOfferingConfigTable.this.updateButtons();
                        P buttons = (P)InstrOfferingConfigTable.this.getWidget(idx + 1, InstrOfferingConfigTable.this.getIndex(InstrOfferingConfigInterface.InstrOfferingConfigColumn.BUTTONS));
                        InstrOfferingConfigTable.this.focus(buttons.getWidget(line.getIndent() <= before.getIndent() ? 0 : 1));
                    }
                }, new Check(){

                    @Override
                    public boolean check(InstrOfferingConfigInterface.SubpartLine line) {
                        if (!line.isEditable()) {
                            return false;
                        }
                        int idx = InstrOfferingConfigTable.this.iData.getSubpartLines().indexOf(line);
                        if (idx <= 0) {
                            return false;
                        }
                        InstrOfferingConfigInterface.SubpartLine before = InstrOfferingConfigTable.this.iData.getSubpartLines().get(idx - 1);
                        return before != null && line.getIndent() <= before.getIndent();
                    }
                });
                right.update(this.getRowCount());
                buttons.add((Widget)right);
                Operation left = new Operation(line, RESOURCES.arrowLeft(), MESSAGES.titleMoveToParentLevel(), new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        if (line.getParentId() == null) {
                            return;
                        }
                        InstrOfferingConfigInterface.SubpartLine parent = InstrOfferingConfigTable.this.iData.getSubpartLine(line.getParentId());
                        if (parent == null) {
                            return;
                        }
                        List<InstrOfferingConfigInterface.SubpartLine> same = InstrOfferingConfigTable.this.iData.getSameParent(line);
                        if (same.indexOf(line) + 1 < same.size()) {
                            InstrOfferingConfigInterface.SubpartLine next = same.get(same.size() - 1);
                            List<InstrOfferingConfigInterface.SubpartLine> data = InstrOfferingConfigTable.this.iData.getLines(line);
                            int oldRow = InstrOfferingConfigTable.this.iData.getSubpartLines().indexOf(line);
                            InstrOfferingConfigTable.this.iData.getSubpartLines().removeAll(data);
                            for (int idx = 0; idx < data.size(); ++idx) {
                                InstrOfferingConfigTable.this.removeRow(oldRow + 1);
                            }
                            int newRow = InstrOfferingConfigTable.this.iData.getSubpartLines().indexOf(next) + InstrOfferingConfigTable.this.iData.getLines(next).size();
                            InstrOfferingConfigTable.this.iData.getSubpartLines().addAll(newRow, data);
                            int idx = 0;
                            for (InstrOfferingConfigInterface.SubpartLine l : data) {
                                InstrOfferingConfigTable.this.setRow(InstrOfferingConfigTable.this.insertRow(newRow + 1 + idx++), l, InstrOfferingConfigTable.this.generateRow(l));
                            }
                        }
                        line.setParentId(parent.getParentId());
                        for (InstrOfferingConfigInterface.SubpartLine l : InstrOfferingConfigTable.this.iData.getLines(line)) {
                            l.setIndent(l.getIndent() - 1);
                        }
                        InstrOfferingConfigTable.this.updateButtons();
                        P buttons = (P)InstrOfferingConfigTable.this.getWidget(InstrOfferingConfigTable.this.iData.getSubpartLines().indexOf(line) + 1, InstrOfferingConfigTable.this.getIndex(InstrOfferingConfigInterface.InstrOfferingConfigColumn.BUTTONS));
                        InstrOfferingConfigTable.this.focus(buttons.getWidget(line.getIndent() > 0 ? 1 : 0));
                    }
                }, new Check(){

                    @Override
                    public boolean check(InstrOfferingConfigInterface.SubpartLine line) {
                        if (!line.isEditable()) {
                            return false;
                        }
                        return line.getIndent() > 0;
                    }
                });
                left.update(this.getRowCount());
                buttons.add((Widget)left);
                Operation up = new Operation(line, RESOURCES.orderUp(), MESSAGES.titleMoveUp(), new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        List<InstrOfferingConfigInterface.SubpartLine> same = InstrOfferingConfigTable.this.iData.getSameParent(line);
                        int row = same.indexOf(line);
                        if (row <= 0) {
                            return;
                        }
                        InstrOfferingConfigInterface.SubpartLine prev = same.get(row - 1);
                        List<InstrOfferingConfigInterface.SubpartLine> data = InstrOfferingConfigTable.this.iData.getLines(line);
                        int oldRow = InstrOfferingConfigTable.this.iData.getSubpartLines().indexOf(line);
                        InstrOfferingConfigTable.this.iData.getSubpartLines().removeAll(data);
                        for (int idx = 0; idx < data.size(); ++idx) {
                            InstrOfferingConfigTable.this.removeRow(oldRow + 1);
                        }
                        int newRow = InstrOfferingConfigTable.this.iData.getSubpartLines().indexOf(prev);
                        InstrOfferingConfigTable.this.iData.getSubpartLines().addAll(newRow, data);
                        int idx = 0;
                        for (InstrOfferingConfigInterface.SubpartLine l : data) {
                            InstrOfferingConfigTable.this.setRow(InstrOfferingConfigTable.this.insertRow(newRow + 1 + idx++), l, InstrOfferingConfigTable.this.generateRow(l));
                        }
                        InstrOfferingConfigTable.this.updateButtons();
                        P buttons = (P)InstrOfferingConfigTable.this.getWidget(newRow + 1, InstrOfferingConfigTable.this.getIndex(InstrOfferingConfigInterface.InstrOfferingConfigColumn.BUTTONS));
                        InstrOfferingConfigTable.this.focus(buttons.getWidget(row >= 2 ? 2 : 3));
                    }
                }, new Check(){

                    @Override
                    public boolean check(InstrOfferingConfigInterface.SubpartLine line) {
                        int idx = InstrOfferingConfigTable.this.iData.getSubpartLines().indexOf(line);
                        for (int i = idx - 1; i >= 0; --i) {
                            InstrOfferingConfigInterface.SubpartLine l = InstrOfferingConfigTable.this.iData.getSubpartLines().get(i);
                            if (l.getParentId() == null && line.getParentId() == null) {
                                return true;
                            }
                            if (l.getParentId() == null || !l.getParentId().equals(line.getParentId())) continue;
                            return true;
                        }
                        return false;
                    }
                });
                up.update(this.getRowCount());
                buttons.add((Widget)up);
                Operation down = new Operation(line, RESOURCES.orderDown(), MESSAGES.titleMoveDown(), new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        List<InstrOfferingConfigInterface.SubpartLine> same = InstrOfferingConfigTable.this.iData.getSameParent(line);
                        int row = same.indexOf(line);
                        if (row + 1 >= same.size()) {
                            return;
                        }
                        InstrOfferingConfigInterface.SubpartLine next = same.get(row + 1);
                        List<InstrOfferingConfigInterface.SubpartLine> data = InstrOfferingConfigTable.this.iData.getLines(line);
                        int oldRow = InstrOfferingConfigTable.this.iData.getSubpartLines().indexOf(line);
                        InstrOfferingConfigTable.this.iData.getSubpartLines().removeAll(data);
                        for (int idx = 0; idx < data.size(); ++idx) {
                            InstrOfferingConfigTable.this.removeRow(oldRow + 1);
                        }
                        int newRow = InstrOfferingConfigTable.this.iData.getSubpartLines().indexOf(next) + InstrOfferingConfigTable.this.iData.getLines(next).size();
                        InstrOfferingConfigTable.this.iData.getSubpartLines().addAll(newRow, data);
                        int idx = 0;
                        for (InstrOfferingConfigInterface.SubpartLine l : data) {
                            InstrOfferingConfigTable.this.setRow(InstrOfferingConfigTable.this.insertRow(newRow + 1 + idx++), l, InstrOfferingConfigTable.this.generateRow(l));
                        }
                        InstrOfferingConfigTable.this.updateButtons();
                        P buttons = (P)InstrOfferingConfigTable.this.getWidget(newRow + 1, InstrOfferingConfigTable.this.getIndex(InstrOfferingConfigInterface.InstrOfferingConfigColumn.BUTTONS));
                        InstrOfferingConfigTable.this.focus(buttons.getWidget(row + 2 < same.size() ? 3 : 2));
                    }
                }, new Check(){

                    @Override
                    public boolean check(InstrOfferingConfigInterface.SubpartLine line) {
                        if (!line.isEditable()) {
                            return false;
                        }
                        int idx = InstrOfferingConfigTable.this.iData.getSubpartLines().indexOf(line);
                        for (int i = idx + 1; i < InstrOfferingConfigTable.this.iData.getSubpartLines().size(); ++i) {
                            InstrOfferingConfigInterface.SubpartLine l = InstrOfferingConfigTable.this.iData.getSubpartLines().get(i);
                            if (l.getParentId() == null && line.getParentId() == null) {
                                return true;
                            }
                            if (l.getParentId() == null || !l.getParentId().equals(line.getParentId())) continue;
                            return true;
                        }
                        return false;
                    }
                });
                down.update(this.getRowCount());
                buttons.add((Widget)down);
                Operation delete = new Operation(line, RESOURCES.delete(), MESSAGES.titleDeleteInstructionalType(), new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        List<InstrOfferingConfigInterface.SubpartLine> data = InstrOfferingConfigTable.this.iData.getLines(line);
                        int oldRow = InstrOfferingConfigTable.this.iData.getSubpartLines().indexOf(line);
                        InstrOfferingConfigTable.this.iData.getSubpartLines().removeAll(data);
                        for (int idx = 0; idx < data.size(); ++idx) {
                            InstrOfferingConfigTable.this.removeRow(oldRow + 1);
                        }
                        InstrOfferingConfigTable.this.updateButtons();
                    }
                }, new Check(){

                    @Override
                    public boolean check(InstrOfferingConfigInterface.SubpartLine line) {
                        if (!line.isEditable()) {
                            return false;
                        }
                        for (InstrOfferingConfigInterface.SubpartLine l : InstrOfferingConfigTable.this.iData.getLines(line)) {
                            if (l.isCanDelete()) continue;
                            return false;
                        }
                        return true;
                    }
                });
                delete.update(this.getRowCount());
                buttons.add((Widget)delete);
                return buttons;
            }
            case LIMIT: {
                ClassLimit limit = new ClassLimit(line);
                return limit;
            }
            case NBR_CLASSES: {
                final NumberBox nbrClasses = new NumberBox();
                nbrClasses.setWidth("40px");
                nbrClasses.setMaxLength(4);
                nbrClasses.setValue(line.getNumberOfClasses());
                nbrClasses.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                    public void onValueChange(ValueChangeEvent<String> event) {
                        try {
                            line.setNumberOfClasses(Integer.parseInt((String)event.getValue()));
                        }
                        catch (NumberFormatException e) {
                            line.setNumberOfClasses(null);
                            nbrClasses.setText("");
                        }
                        if (line.getNumberOfClasses() != null && line.getNumberOfClasses() > 100 && !Window.confirm((String)MESSAGES.confirmCreateTooManyClasses(line.getNumberOfClasses()))) {
                            line.setNumberOfClasses(null);
                            nbrClasses.setText("");
                            nbrClasses.setFocus(true);
                        }
                        InstrOfferingConfigTable.this.onLimitChange();
                    }
                });
                nbrClasses.addStyleName("subpart-nbr-classes");
                nbrClasses.setReadOnly(!line.isEditable());
                return nbrClasses;
            }
            case MINS_PER_WK: {
                final NumberBox minsPerWeek = new NumberBox();
                minsPerWeek.setWidth("40px");
                minsPerWeek.setMaxLength(4);
                minsPerWeek.setValue(line.getMinutesPerWeek());
                minsPerWeek.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                    public void onValueChange(ValueChangeEvent<String> event) {
                        try {
                            line.setMinutesPerWeek(Integer.parseInt((String)event.getValue()));
                        }
                        catch (NumberFormatException e) {
                            line.setMinutesPerWeek(null);
                            minsPerWeek.setText("");
                        }
                    }
                });
                minsPerWeek.addStyleName("subpart-mins-per-wk");
                minsPerWeek.setReadOnly(!line.isEditable());
                return minsPerWeek;
            }
            case NBR_ROOMS: {
                final NumberBox nbrRooms = new NumberBox();
                nbrRooms.setWidth("40px");
                nbrRooms.setMaxLength(5);
                nbrRooms.setValue(line.getNumberOfRooms());
                nbrRooms.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                    public void onValueChange(ValueChangeEvent<String> event) {
                        try {
                            line.setNumberOfRooms(Integer.parseInt((String)event.getValue()));
                        }
                        catch (NumberFormatException e) {
                            line.setNumberOfRooms(null);
                            nbrRooms.setText("");
                        }
                        CheckBox splitAttendance = (CheckBox)InstrOfferingConfigTable.this.getWidget(InstrOfferingConfigTable.this.getRowForWidget((Widget)nbrRooms), InstrOfferingConfigTable.this.getIndex(InstrOfferingConfigInterface.InstrOfferingConfigColumn.SPLIT_ATTENDANCE));
                        splitAttendance.setEnabled(line.getNumberOfRooms() != null && line.getNumberOfRooms() > 1);
                        if (!splitAttendance.isEnabled() && splitAttendance.getValue().booleanValue()) {
                            splitAttendance.setValue(Boolean.valueOf(false), true);
                        }
                    }
                });
                nbrRooms.addStyleName("subpart-nbr-rooms");
                nbrRooms.setReadOnly(!line.isEditable());
                return nbrRooms;
            }
            case ROOM_RATIO: {
                final NumberBox roomRatio = new NumberBox();
                roomRatio.setDecimal(true);
                roomRatio.setMaxLength(6);
                roomRatio.setWidth("40px");
                roomRatio.addStyleName("subpart-room-ratio");
                roomRatio.setValue(this.sRoomRatioFormat.format(line.getRoomRatio() == null ? 1.0 : (double)line.getRoomRatio().floatValue()));
                roomRatio.setReadOnly(!line.isEditable());
                roomRatio.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                    public void onValueChange(ValueChangeEvent<String> event) {
                        try {
                            line.setRoomRatio(Float.valueOf((float)NumberFormat.getDecimalFormat().parse((String)event.getValue())));
                        }
                        catch (NumberFormatException e) {
                            try {
                                line.setRoomRatio(Float.valueOf(Float.parseFloat((String)event.getValue())));
                            }
                            catch (NumberFormatException f) {
                                line.setRoomRatio(Float.valueOf(1.0f));
                            }
                        }
                        roomRatio.setValue(InstrOfferingConfigTable.this.sRoomRatioFormat.format((Number)line.getRoomRatio()));
                    }
                });
                return roomRatio;
            }
            case SPLIT_ATTENDANCE: {
                CheckBox splitAttendance = new CheckBox();
                splitAttendance.setValue(line.getSplitAttendance());
                splitAttendance.addStyleName("subpart-split-attendace");
                splitAttendance.setEnabled(line.isEditable() && line.getNumberOfRooms() != null && line.getNumberOfRooms() > 1);
                splitAttendance.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                    public void onValueChange(ValueChangeEvent<Boolean> event) {
                        line.setSplitAttendance((Boolean)event.getValue());
                    }
                });
                return splitAttendance;
            }
            case DEPARTMENT: {
                final ListBox department = new ListBox();
                department.addStyleName("class-department");
                department.setWidth("150px");
                for (InstrOfferingConfigInterface.Reference d : this.iData.getDepartments()) {
                    if (d.isSelectable() || d.getId().equals(line.getDepartmentId())) {
                        department.addItem(d.getLabel(), d.getId().toString());
                    }
                    if (!d.getId().equals(line.getDepartmentId())) continue;
                    department.setSelectedIndex(department.getItemCount() - 1);
                }
                department.addChangeHandler(new ChangeHandler(){

                    public void onChange(ChangeEvent event) {
                        line.setDepartmentId(Long.valueOf(department.getSelectedValue()));
                    }
                });
                department.setEnabled(line.isEditable());
                return department;
            }
        }
        return null;
    }

    private static interface HasUpdate {
        public void update(int var1);
    }

    private class Error
    extends P
    implements HasUpdate {
        private InstrOfferingConfigInterface.SubpartLine iLine;
        private Image iError;
        private Image iLock;

        Error(InstrOfferingConfigInterface.SubpartLine line) {
            super("subpart-error");
            this.iLine = line;
            this.iError = new Image(RESOURCES.attention());
            this.iError.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    UniTimeConfirmationDialog.alert(Error.this.iLine.getError(), true);
                }
            });
            this.iLock = new Image(RESOURCES.lock());
        }

        @Override
        public void update(int row) {
            this.clear();
            if (this.iLine.hasError()) {
                this.iError.setTitle(this.iLine.getError().replace("<br>", "\n").replace("&nbsp;", " "));
                this.add((Widget)this.iError);
            } else if (this.iLine.isLocked()) {
                this.add((Widget)this.iLock);
            }
        }
    }

    private class SubpartLabel
    extends P
    implements HasUpdate {
        private InstrOfferingConfigInterface.SubpartLine iLine;
        private Label iLabel;

        SubpartLabel(InstrOfferingConfigInterface.SubpartLine line) {
            super("subpart-label");
            this.iLine = line;
            this.iLabel = new Label(line.getLabel());
            if (!this.iLine.isEditable()) {
                this.iLabel.addStyleName("not-editable");
            }
            if (this.iLine.getIndent() > 0) {
                this.add((Widget)new Image(RESOURCES.indent()));
                this.getElement().getStyle().setPaddingLeft((double)(20 * (this.iLine.getIndent() - 1)), Style.Unit.PX);
            }
            this.add((Widget)this.iLabel);
        }

        @Override
        public void update(int row) {
            this.clear();
            this.iLabel.setText(this.iLine.getLabel());
            if (this.iLine.getIndent() > 0) {
                this.add((Widget)new Image(RESOURCES.indent()));
                this.getElement().getStyle().setPaddingLeft((double)(20 * (this.iLine.getIndent() - 1)), Style.Unit.PX);
            } else {
                this.getElement().getStyle().setPaddingLeft(0.0, Style.Unit.PX);
            }
            this.add((Widget)this.iLabel);
        }
    }

    private class Buttons
    extends P
    implements HasUpdate {
        private Buttons() {
            super("subpart-buttons");
        }

        @Override
        public void update(int row) {
            for (int i = 0; i < this.getWidgetCount(); ++i) {
                ((HasUpdate)this.getWidget(i)).update(row);
            }
        }
    }

    private class Operation
    extends P
    implements HasUpdate,
    Focusable {
        private Image iBlank;
        private ImageButton iButton;
        private InstrOfferingConfigInterface.SubpartLine iLine;
        private ClickHandler iClickHandler;
        private Check iCheck;
        private boolean iLastCheck;

        private Operation(InstrOfferingConfigInterface.SubpartLine line, ImageResource image, String title, ClickHandler click, Check check) {
            super(new String[0]);
            this.iLastCheck = false;
            this.iButton = new ImageButton(image);
            this.iButton.setTitle(title);
            this.iButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (InstrOfferingConfigTable.this.isEnabled()) {
                        Operation.this.iClickHandler.onClick(event);
                    }
                }
            });
            this.iBlank = new Image(RESOURCES.blank());
            this.iLine = line;
            this.iClickHandler = click;
            this.iCheck = check;
            this.add((Widget)this.iBlank);
        }

        @Override
        public void update(int row) {
            boolean check = this.iCheck.check(this.iLine);
            if (check != this.iLastCheck) {
                this.iLastCheck = check;
                this.clear();
                if (this.iLastCheck) {
                    this.add((Widget)this.iButton);
                } else {
                    this.add((Widget)this.iBlank);
                }
            }
        }

        public void setFocus(boolean focus) {
            if (this.iLastCheck) {
                this.iButton.setFocus(focus);
            }
        }

        public int getTabIndex() {
            if (this.iLastCheck) {
                return this.iButton.getTabIndex();
            }
            return -1;
        }

        public void setAccessKey(char key) {
            this.iButton.setAccessKey(key);
        }

        public void setTabIndex(int index) {
            this.iButton.setTabIndex(index);
        }
    }

    private static interface Check {
        public boolean check(InstrOfferingConfigInterface.SubpartLine var1);
    }

    class ClassLimit
    extends P {
        private InstrOfferingConfigInterface.SubpartLine iLine;
        private NumberBox iMin;
        private NumberBox iMax;

        ClassLimit(final InstrOfferingConfigInterface.SubpartLine line) {
            super("class-limit");
            this.iLine = line;
            this.iMin = new NumberBox();
            this.iMin.setMaxLength(5);
            this.iMin.setValue(line.getMinClassLimit());
            this.iMin.setReadOnly(!line.isEditable());
            this.iMin.setWidth("40px");
            this.add((Widget)this.iMin);
            this.iMax = new NumberBox();
            this.iMax.setMaxLength(5);
            this.iMax.setValue(line.getMaxClassLimit());
            this.iMax.setReadOnly(!line.isEditable());
            this.iMax.setWidth("40px");
            this.iMax.getElement().getStyle().setMarginLeft(2.0, Style.Unit.PX);
            this.iMax.setVisible(InstrOfferingConfigTable.this.iData.isDisplayMaxLimit());
            this.add((Widget)this.iMax);
            this.iMin.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                public void onValueChange(ValueChangeEvent<String> event) {
                    try {
                        line.setMinClassLimit(Integer.parseInt((String)event.getValue()));
                    }
                    catch (NumberFormatException e) {
                        line.setMinClassLimit(null);
                        ClassLimit.this.iMin.setText("");
                    }
                    line.setMaxClassLimit(line.getMinClassLimit());
                    ClassLimit.this.iMax.setText(ClassLimit.this.iMin.getText());
                    ClassLimit.this.updateNumberOfClasses();
                    InstrOfferingConfigTable.this.onLimitChange();
                }
            });
            this.iMax.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                public void onValueChange(ValueChangeEvent<String> event) {
                    try {
                        line.setMaxClassLimit(Integer.parseInt((String)event.getValue()));
                    }
                    catch (NumberFormatException e) {
                        line.setMaxClassLimit(line.getMinClassLimit());
                        ClassLimit.this.iMax.setValue(line.getMaxClassLimit());
                    }
                    if (line.getMaxClassLimit() != null && line.getMinClassLimit() != null && line.getMaxClassLimit() < line.getMinClassLimit()) {
                        line.setMaxClassLimit(line.getMinClassLimit());
                        ClassLimit.this.iMax.setValue(line.getMaxClassLimit());
                    }
                    ClassLimit.this.updateNumberOfClasses();
                    InstrOfferingConfigTable.this.onLimitChange();
                }
            });
        }

        protected void updateNumberOfClasses() {
            if (this.iLine.getMaxClassLimit() != null && InstrOfferingConfigTable.this.iData.getLimit() != null && !InstrOfferingConfigTable.this.iData.isUnlimited().booleanValue()) {
                NumberBox nbrClasses = (NumberBox)InstrOfferingConfigTable.this.getWidget(InstrOfferingConfigTable.this.getRowForWidget((Widget)this), InstrOfferingConfigTable.this.getIndex(InstrOfferingConfigInterface.InstrOfferingConfigColumn.NBR_CLASSES));
                InstrOfferingConfigInterface.SubpartLine parent = InstrOfferingConfigTable.this.iData.getSubpartLine(this.iLine.getParentId());
                if (parent != null && parent.getMaxClassLimit() != null && parent.getNumberOfClasses() != null) {
                    int classesPerParent = (int)Math.ceil(parent.getMaxClassLimit().doubleValue() / (double)this.iLine.getMaxClassLimit().intValue());
                    if (this.iLine.getMaxClassLimit() < 0) {
                        this.iLine.setNumberOfClasses(null);
                    } else if (this.iLine.getMaxClassLimit() == 0) {
                        this.iLine.setNumberOfClasses(1);
                    } else {
                        this.iLine.setNumberOfClasses(parent.getNumberOfClasses() * classesPerParent);
                    }
                } else if (this.iLine.getMaxClassLimit() < 0) {
                    this.iLine.setNumberOfClasses(null);
                } else if (this.iLine.getMaxClassLimit() == 0) {
                    this.iLine.setNumberOfClasses(1);
                } else {
                    this.iLine.setNumberOfClasses(Math.max(1, (int)Math.ceil(InstrOfferingConfigTable.this.iData.getLimit().doubleValue() / (double)this.iLine.getMaxClassLimit().intValue())));
                }
                nbrClasses.setValue(this.iLine.getNumberOfClasses());
            }
        }

        public void setMaxVisible(boolean visible) {
            this.iMax.setVisible(visible);
        }
    }
}

