/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.UniTimeForm;

public class DataImportForm
implements UniTimeForm {
    private static final long serialVersionUID = 7165669008085313647L;
    protected static CourseMessages MSG = Localization.create(CourseMessages.class);
    private transient File iFile;
    private String iFileContentType;
    private String iFileFileName;
    private String iOp;
    private String iExport;
    private boolean iEmail = false;
    private String iAddress = null;

    @Override
    public void validate(UniTimeAction action) {
        if ("Import".equals(this.iOp) && (this.iFile == null || !this.iFile.exists())) {
            action.addFieldError("form.file", MSG.errorRequiredField(MSG.fieldFile()));
        }
        if ("Export".equals(this.iOp) && this.getExportType() == null) {
            action.addFieldError("form.export", MSG.errorNothingToExport());
        }
    }

    @Override
    public void reset() {
        this.iFile = null;
        this.iFileContentType = null;
        this.iFileFileName = null;
        this.iExport = null;
        this.iEmail = false;
        this.iAddress = null;
    }

    public File getFile() {
        return this.iFile;
    }

    public void setFile(File file) {
        if (file != null && file.exists()) {
            try {
                File newFile = new File(file.getParent(), file.getName() + ".lock");
                Files.move(file.toPath(), newFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.iFile = newFile;
            }
            catch (IOException e) {
                this.iFile = file;
            }
        } else {
            this.iFile = file;
        }
    }

    public String getFileContentType() {
        return this.iFileContentType;
    }

    public void setFileContentType(String contentType) {
        this.iFileContentType = contentType;
    }

    public String getFileFileName() {
        return this.iFileFileName;
    }

    public void setFileFileName(String fileName) {
        this.iFileFileName = fileName;
    }

    public String getOp() {
        return this.iOp;
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    public String getExport() {
        return this.iExport;
    }

    public void setExport(String export) {
        this.iExport = export;
    }

    public boolean getEmail() {
        return this.iEmail;
    }

    public void setEmail(boolean email) {
        this.iEmail = email;
    }

    public String getAddress() {
        return this.iAddress;
    }

    public void setAddress(String address) {
        this.iAddress = address;
    }

    public Object clone() {
        DataImportForm form = new DataImportForm();
        form.iFile = this.iFile;
        form.iFileContentType = this.iFileContentType;
        form.iFileFileName = this.iFileFileName;
        form.iOp = this.iOp;
        form.iExport = this.iExport;
        form.iEmail = this.iEmail;
        form.iAddress = this.iAddress;
        return form;
    }

    public List<ListItem> getExportTypes() {
        ArrayList<ListItem> items = new ArrayList<ListItem>();
        items.add(new ListItem("", MSG.itemSelect()));
        for (ExportType t : ExportType.values()) {
            items.add(new ListItem(t.name(), t.getLabel()));
        }
        return items;
    }

    public ExportType getExportType() {
        if (this.getExport() == null || this.getExport().isEmpty()) {
            return null;
        }
        return ExportType.valueOf(this.getExport());
    }

    public static enum ExportType {
        COURSES("offerings", "Course Offerings", "tmtbl.export.timetable", "false", "tmtbl.export.exam.type", "none"),
        COURSES_WITH_TIME("offerings", "Course Offerings (including course timetable)", "tmtbl.export.timetable", "true", "tmtbl.export.exam.type", "none"),
        COURSES_WITH_EXAMS("offerings", "Course Offerings (including exams)", "tmtbl.export.timetable", "false", "tmtbl.export.exam.type", "all"),
        COURSES_ALL("offerings", "Course Offerings (including course timetable and exams)", "tmtbl.export.timetable", "true", "tmtbl.export.exam.type", "all"),
        TIMETABLE("timetable", "Course Timetable", new String[0]),
        EXAMS("exams", "Examinations", "tmtbl.export.exam", "true", "tmtbl.export.exam.type", "all"),
        EXAMS_FINAL("exams", "Examinations (only finals)", "tmtbl.export.exam", "true", "tmtbl.export.exam.type", "final"),
        EXAMS_MIDTERM("exams", "Examinations (only midterm)", "tmtbl.export.exam", "true", "tmtbl.export.exam.type", "midterm"),
        CURRICULA("curricula", "Curricula", new String[0]),
        STUDENTS("students", "Students", new String[0]),
        STUDENT_ENRL("studentEnrollments", "Student class enrollments", new String[0]),
        REQUESTS("request", "Student course requests", new String[0]),
        RESERVATIONS("reservations", "Reservations", new String[0]),
        SESSION("session", "Academic Session", new String[0]),
        PERMISSIONS("permissions", "Permissions", new String[0]),
        TRAVELTIMES("traveltimes", "Travel Times", new String[0]),
        ROOM_SHARING("roomSharing", "Room Sharing", new String[0]),
        POINT_IN_TIME_DATA("pointInTimeData", "Point-In-Time Data", new String[0]),
        PREFERENCES("preferences", "Course Timetabling Preferences", new String[0]),
        SESSION_SETUP("sessionSetup", "Academic Session Setup", new String[0]),
        STUDENT_ADVISORS("studentAdvisors", "Student Advisors", new String[0]),
        STUDENT_STATUSES("studentStatuses", "Student Scheduling Statuses", new String[0]),
        INSTRUCTOR_SURVEYS("instructorSurveys", "Instructor Surveys", new String[0]),
        SCRIPTS("scripts", "Scripts", new String[0]),
        REPORTS("reports", "Reports", new String[0]);

        private String iType;
        private String iLabel;
        private String[] iOptions;

        private ExportType(String type, String label, String ... options) {
            this.iType = type;
            this.iLabel = label;
            this.iOptions = options;
        }

        public String getType() {
            return this.iType;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public void setOptions(Properties config) {
            for (int i = 0; i < this.iOptions.length; i += 2) {
                config.put(this.iOptions[i], this.iOptions[i + 1]);
            }
        }
    }

    public static class ListItem {
        String iValue;
        String iText;

        public ListItem(String value, String text) {
            this.iValue = value;
            this.iText = text;
        }

        public String getValue() {
            return this.iValue;
        }

        public String getLabel() {
            return this.iText;
        }
    }
}

