/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.solver;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.solver.TableExporter;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.FilterInterface;
import org.unitime.timetable.gwt.shared.TimetableGridInterface;
import org.unitime.timetable.util.Formats;

@Service(value="org.unitime.timetable.export.Exporter:timetable.xls")
public class ExportTimetableXLS
extends TableExporter {
    protected static final GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    protected static Formats.Format<Date> sDateFormatMeeting = Formats.getDateFormat(Formats.Pattern.TIMETABLE_GRID_DATE);
    protected static Formats.Format<Number> sUtilizationFormat = Formats.getConcurrentNumberFormat(Formats.Pattern.UTILIZATION);
    @Autowired
    private ApplicationContext applicationContext;

    @Override
    public String reference() {
        return "timetable.xls";
    }

    @Override
    public void export(ExportHelper helper) throws IOException {
        GwtRpcImplementation filterService = (GwtRpcImplementation)this.applicationContext.getBean(TimetableGridInterface.TimetableGridFilterRequest.class.getName());
        TimetableGridInterface.TimetableGridFilterResponse filter = (TimetableGridInterface.TimetableGridFilterResponse)filterService.execute(new TimetableGridInterface.TimetableGridFilterRequest(), helper.getSessionContext());
        this.fillInFilter(filter, helper);
        GwtRpcImplementation service = (GwtRpcImplementation)this.applicationContext.getBean(TimetableGridInterface.TimetableGridRequest.class.getName());
        TimetableGridInterface.TimetableGridRequest request = new TimetableGridInterface.TimetableGridRequest();
        request.setFilter(filter);
        TimetableGridInterface.TimetableGridResponse response = (TimetableGridInterface.TimetableGridResponse)service.execute(request, helper.getSessionContext());
        this.printTables(filter, response, helper);
    }

    protected void printTables(FilterInterface filter, TimetableGridInterface.TimetableGridResponse response, ExportHelper helper) throws IOException {
        helper.setup("application/vnd.ms-excel", this.reference(), true);
        ExportContext cx = new ExportContext();
        int index = 0;
        int dispMode = Integer.valueOf(filter.getParameterValue("dispMode", "0"));
        if (dispMode == 0) {
            int i;
            int used = 0;
            boolean[] hasDay = new boolean[]{true, true, true, true, true, false, false};
            String days = filter.getParameterValue("days");
            if (days != null && days.length() == 7 && days.indexOf(49) >= 0) {
                for (i = 0; i < 7; ++i) {
                    hasDay[i] = days.charAt(i) == '1';
                }
            }
            for (i = 0; i < 7; ++i) {
                if (!hasDay[i]) continue;
                Object d = "";
                for (int j = 0; j < 7; ++j) {
                    d = (String)d + (i == j ? "1" : "0");
                }
                filter.getParameter("days").setValue((String)d);
                Sheet sheet = cx.createSheet(CONSTANTS.longDays()[i]);
                used = 0;
                for (TimetableGridInterface.TimetableGridModel model : response.getModels()) {
                    TimetableGrid tg = new TimetableGrid(filter, model, index++, response.getWeekOffset(), used == 0);
                    tg.print(cx, sheet, 0, used, null);
                    used += tg.getHeight();
                }
            }
        } else {
            for (TimetableGridInterface.TimetableGridModel model : response.getModels()) {
                TimetableGrid tg = new TimetableGrid(filter, model, index++, response.getWeekOffset(), true);
                if (tg.iMeetings.isEmpty()) continue;
                Sheet sheet = cx.createSheet(model.getName());
                tg.print(cx, sheet, 0, 0, null);
            }
        }
        cx.write(helper.getOutputStream(), dispMode == 2);
    }

    protected static String getComment(TimetableGridInterface.TimetableGridModel model) {
        if (model.getResourceType() == 0) {
            return "(" + model.getSize() + ", " + sUtilizationFormat.format(model.getUtilization()) + ")";
        }
        if (model.getResourceType() >= 2) {
            return "(" + model.getSize() + ")";
        }
        return null;
    }

    protected static Date getDate(Date firstDate, int date) {
        Date ret = new Date(firstDate.getTime());
        ret.setDate(ret.getDate() + date);
        return ret;
    }

    public static String slot2time(int slot) {
        if (CONSTANTS.useAmPm()) {
            if (slot == 0) {
                return CONSTANTS.timeMidnight();
            }
            if (slot == 144) {
                return CONSTANTS.timeNoon();
            }
            if (slot == 288) {
                return CONSTANTS.timeMidnightEnd();
            }
        }
        int h = slot / 12;
        int m = 5 * (slot % 12);
        if (CONSTANTS.useAmPm()) {
            return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + " " + (h == 24 ? CONSTANTS.timeAm() : (h >= 12 ? CONSTANTS.timePm() : CONSTANTS.timeAm()));
        }
        return h + ":" + (m < 10 ? "0" : "") + m;
    }

    public static class ExportContext {
        private Workbook iWorkbook;
        private Map<String, CellStyle> iStyles = new HashMap<String, CellStyle>();
        private Map<String, Font> iFonts = new HashMap<String, Font>();
        private Map<String, Short> iColors = new HashMap<String, Short>();
        private int iFontSize = 12;
        private String iFontName = "Arial";
        private Float iRowHeight = null;

        public ExportContext() {
            this.iWorkbook = new HSSFWorkbook();
            this.iFontSize = ApplicationProperty.TimeGridXLSFontSize.intValue();
            this.iFontName = ApplicationProperty.TimeGridXLSFontName.value();
            this.iRowHeight = ApplicationProperty.TimeGridXLSRowHeight.floatValue();
        }

        public Workbook getWorkbook() {
            return this.iWorkbook;
        }

        public Float getRowHeight() {
            return this.iRowHeight;
        }

        protected Font getFont(boolean bold, boolean italic, boolean underline, Color c) {
            String fontId;
            Font font;
            String colorId;
            Short color = null;
            if (c == null) {
                c = Color.BLACK;
            }
            if (c != null && (color = this.iColors.get(colorId = Integer.toHexString(c.getRGB()))) == null) {
                HSSFPalette palette = ((HSSFWorkbook)this.iWorkbook).getCustomPalette();
                HSSFColor clr = palette.findSimilarColor(c.getRed(), c.getGreen(), c.getBlue());
                color = clr == null ? IndexedColors.BLACK.getIndex() : clr.getIndex();
                this.iColors.put(colorId, color);
            }
            if ((font = this.iFonts.get(fontId = (bold ? "b" : "") + (italic ? "i" : "") + (underline ? "u" : "") + String.valueOf(color == null ? "" : color))) == null) {
                font = this.iWorkbook.createFont();
                font.setBold(bold);
                font.setItalic(italic);
                font.setUnderline(underline ? (byte)1 : 0);
                font.setColor(color.shortValue());
                font.setFontHeightInPoints((short)this.iFontSize);
                font.setFontName(this.iFontName);
                this.iFonts.put(fontId, font);
            }
            return font;
        }

        protected Font getFont(P p) {
            return this.getFont(p, null);
        }

        protected Font getFont(P p, P parent) {
            Pattern pt;
            Matcher m;
            boolean bold = p.isStyle("grid-name", "horizontal-header", "vertical-header");
            if (p.isStyle("header") && parent != null && parent.isStyle("meeting")) {
                bold = true;
            }
            Color color = null;
            if (p.iColor != null && (m = (pt = Pattern.compile("rgb\\(([0-9]+),([0-9]+),([0-9]+)\\)")).matcher(p.iColor)).matches()) {
                color = new Color(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)), Integer.parseInt(m.group(3)));
            }
            return this.getFont(bold, p.iItalics, false, color == null ? Color.BLACK : color);
        }

        protected CellStyle getMeetingHeaderStyle(P p, P parent, Color bgColor) {
            String styleId;
            CellStyle style;
            if (bgColor == null) {
                bgColor = Color.WHITE;
            }
            if ((style = this.iStyles.get(styleId = "meeting-header-" + Integer.toHexString(bgColor.getRGB()) + (p.iItalics ? "-italics" : ""))) == null) {
                style = this.iWorkbook.createCellStyle();
                style.setBorderTop(BorderStyle.THICK);
                style.setTopBorderColor(IndexedColors.BLACK.getIndex());
                style.setBorderLeft(BorderStyle.THICK);
                style.setLeftBorderColor(IndexedColors.BLACK.getIndex());
                style.setBorderRight(BorderStyle.THICK);
                style.setRightBorderColor(IndexedColors.BLACK.getIndex());
                style.setAlignment(HorizontalAlignment.CENTER);
                style.setVerticalAlignment(VerticalAlignment.TOP);
                style.setFont(this.getFont(parent));
                String colorId = Integer.toHexString(bgColor.getRGB());
                Short color = this.iColors.get(colorId);
                if (color == null) {
                    HSSFPalette palette = ((HSSFWorkbook)this.iWorkbook).getCustomPalette();
                    HSSFColor clr = palette.findSimilarColor(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue());
                    color = clr == null ? IndexedColors.BLACK.getIndex() : clr.getIndex();
                    this.iColors.put(colorId, color);
                }
                style.setFillForegroundColor(color.shortValue());
                style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                style.setWrapText(true);
                this.iStyles.put(styleId, style);
            }
            return style;
        }

        protected CellStyle getMeetingFooterStyle(P p, P parent, Color bgColor) {
            String styleId;
            CellStyle style;
            if (bgColor == null) {
                bgColor = Color.WHITE;
            }
            if ((style = this.iStyles.get(styleId = "meeting-footer-" + Integer.toHexString(bgColor.getRGB()))) == null) {
                style = this.iWorkbook.createCellStyle();
                style.setBorderBottom(BorderStyle.THICK);
                style.setBottomBorderColor(IndexedColors.BLACK.getIndex());
                style.setBorderLeft(BorderStyle.THICK);
                style.setLeftBorderColor(IndexedColors.BLACK.getIndex());
                style.setBorderRight(BorderStyle.THICK);
                style.setRightBorderColor(IndexedColors.BLACK.getIndex());
                style.setAlignment(HorizontalAlignment.CENTER);
                style.setVerticalAlignment(VerticalAlignment.TOP);
                style.setFont(this.getFont(parent));
                String colorId = Integer.toHexString(bgColor.getRGB());
                Short color = this.iColors.get(colorId);
                if (color == null) {
                    HSSFPalette palette = ((HSSFWorkbook)this.iWorkbook).getCustomPalette();
                    HSSFColor clr = palette.findSimilarColor(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue());
                    color = clr == null ? IndexedColors.WHITE.getIndex() : clr.getIndex();
                    this.iColors.put(colorId, color);
                }
                style.setFillForegroundColor(color.shortValue());
                style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                style.setWrapText(true);
                this.iStyles.put(styleId, style);
            }
            return style;
        }

        protected CellStyle getHeaderIntervalStyle(P p) {
            String styleId = "header-interval";
            CellStyle style = this.iStyles.get(styleId);
            if (style == null) {
                style = this.iWorkbook.createCellStyle();
                style.setBorderLeft(BorderStyle.THIN);
                style.setLeftBorderColor(IndexedColors.GREY_80_PERCENT.getIndex());
                style.setBorderTop(BorderStyle.THIN);
                style.setTopBorderColor(IndexedColors.GREY_80_PERCENT.getIndex());
                if (p.getWidth() == 1) {
                    style.setBorderRight(BorderStyle.THIN);
                    style.setRightBorderColor(IndexedColors.GREY_80_PERCENT.getIndex());
                }
                style.setFont(this.getFont(p));
                style.setAlignment(HorizontalAlignment.CENTER);
                style.setVerticalAlignment(VerticalAlignment.TOP);
                style.setWrapText(true);
                this.iStyles.put(styleId, style);
            }
            return style;
        }

        protected CellStyle getGridNameStyle(P p) {
            String styleId = "grid-name";
            CellStyle style = this.iStyles.get(styleId);
            if (style == null) {
                style = this.iWorkbook.createCellStyle();
                style.setBorderLeft(BorderStyle.THIN);
                style.setLeftBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
                style.setBorderTop(BorderStyle.THIN);
                style.setTopBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
                style.setFont(this.getFont(p));
                style.setAlignment(HorizontalAlignment.CENTER);
                style.setVerticalAlignment(VerticalAlignment.TOP);
                style.setWrapText(true);
                this.iStyles.put(styleId, style);
            }
            return style;
        }

        protected CellStyle getLineStyle(P p, int dx, int dy, Color bgColor, P parent, CellStyle ps) {
            String styleId;
            String colorId;
            boolean thinTop = false;
            boolean thinLeft = false;
            boolean thinBottom = false;
            boolean thinRight = false;
            boolean thickTop = false;
            boolean thickLeft = false;
            boolean thickBottom = false;
            boolean thickRight = false;
            if (parent != null && parent.isStyle("meeting")) {
                if (dy == 0 & p.isStyle("header")) {
                    thickTop = true;
                }
                if (dx == 0) {
                    thickLeft = true;
                }
                if (dy == p.getHeight() - 1 && p.isStyle("footer")) {
                    thickBottom = true;
                }
                if (dx == p.getWidth() - 1) {
                    thickRight = true;
                }
                if (dx == p.getWidth()) {
                    thickLeft = dy < p.getHeight();
                    bgColor = null;
                    thickTop = false;
                    thickBottom = false;
                    thickRight = false;
                }
                if (p.isStyle("footer") && dy == p.getHeight() && dx < p.getWidth()) {
                    thickTop = true;
                    bgColor = null;
                    thickLeft = false;
                    thickBottom = false;
                    thickRight = false;
                }
            } else if (p.isStyle("unitime-TimetableGrid")) {
                if (dy == 0) {
                    thinTop = true;
                }
                if (dx == 0) {
                    thinLeft = true;
                }
                if (dy == p.getHeight() - 1) {
                    thinBottom = true;
                }
                if (dx == p.getWidth() - 1) {
                    thinRight = true;
                }
            } else if (p.isStyle("header-interval") || p.isStyle("grid-name")) {
                if (dy == 0) {
                    thinTop = true;
                }
                if (dx == 0) {
                    thinLeft = true;
                }
            } else if (p.isStyle("horizontal-separator")) {
                if (dy == 0) {
                    thinTop = true;
                }
            } else if (p.isStyle("vertical-separator")) {
                if (dx == 0) {
                    thinLeft = true;
                }
            } else if (!p.isStyle("background")) {
                return null;
            }
            Short color = null;
            if (bgColor != null && (color = this.iColors.get(colorId = Integer.toHexString(bgColor.getRGB()))) == null) {
                HSSFPalette palette = ((HSSFWorkbook)this.iWorkbook).getCustomPalette();
                HSSFColor clr = palette.findSimilarColor(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue());
                color = clr == null ? IndexedColors.WHITE.getIndex() : clr.getIndex();
                this.iColors.put(colorId, color);
            }
            if (ps != null) {
                if (ps.getBorderTop() == BorderStyle.THICK) {
                    thickTop = true;
                }
                if (ps.getBorderTop() == BorderStyle.THIN) {
                    thinTop = true;
                }
                if (ps.getBorderLeft() == BorderStyle.THICK) {
                    thickLeft = true;
                }
                if (ps.getBorderLeft() == BorderStyle.THIN) {
                    thinLeft = true;
                }
                if (ps.getBorderBottom() == BorderStyle.THICK) {
                    thickBottom = true;
                }
                if (ps.getBorderBottom() == BorderStyle.THIN) {
                    thinBottom = true;
                }
                if (ps.getBorderRight() == BorderStyle.THICK) {
                    thickRight = true;
                }
                if (ps.getBorderRight() == BorderStyle.THIN) {
                    thinRight = true;
                }
                if (color == null && ps.getFillPattern() == FillPatternType.SOLID_FOREGROUND) {
                    color = ps.getFillForegroundColor();
                }
            }
            if ("line".equals(styleId = "line" + (thickTop ? "-ttop" : (thinTop ? "-top" : "")) + (thickLeft ? "-tleft" : (thinLeft ? "-left" : "")) + (thickBottom ? "-tbottom" : (thinBottom ? "-bottom" : "")) + (thickRight ? "-tright" : (thinRight ? "-right" : "")) + (String)(color == null ? "" : "-c" + color))) {
                return null;
            }
            CellStyle style = this.iStyles.get(styleId);
            if (style == null) {
                style = this.iWorkbook.createCellStyle();
                if (thickLeft) {
                    style.setBorderLeft(BorderStyle.THICK);
                    style.setLeftBorderColor(IndexedColors.BLACK.getIndex());
                } else if (thinLeft) {
                    style.setBorderLeft(BorderStyle.THIN);
                    style.setLeftBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
                }
                if (thickTop) {
                    style.setBorderTop(BorderStyle.THICK);
                    style.setTopBorderColor(IndexedColors.BLACK.getIndex());
                } else if (thinTop) {
                    style.setBorderTop(BorderStyle.THIN);
                    style.setTopBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
                }
                if (thickRight) {
                    style.setBorderRight(BorderStyle.THICK);
                    style.setRightBorderColor(IndexedColors.BLACK.getIndex());
                } else if (thinRight) {
                    style.setBorderRight(BorderStyle.THIN);
                    style.setRightBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
                }
                if (thickBottom) {
                    style.setBorderBottom(BorderStyle.THICK);
                    style.setBottomBorderColor(IndexedColors.BLACK.getIndex());
                } else if (thinBottom) {
                    style.setBorderBottom(BorderStyle.THIN);
                    style.setBottomBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
                }
                if (color != null) {
                    style.setFillForegroundColor(color.shortValue());
                    style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                }
                style.setWrapText(true);
                style.setAlignment(HorizontalAlignment.CENTER);
                style.setVerticalAlignment(VerticalAlignment.TOP);
                style.setFont(this.getFont(false, false, false, Color.BLACK));
                this.iStyles.put(styleId, style);
            }
            return style;
        }

        public Sheet createSheet(String name) {
            Sheet sheet = null;
            try {
                sheet = name == null ? this.iWorkbook.createSheet() : this.iWorkbook.createSheet(name.replace('/', '-').replace('\\', '-').replace('?', ' ').replace('*', ' ').replace(':', '-').replace('[', '(').replace(']', ')'));
            }
            catch (IllegalArgumentException e) {
                sheet = this.iWorkbook.createSheet();
            }
            sheet.setDisplayGridlines(false);
            sheet.setPrintGridlines(false);
            sheet.setFitToPage(true);
            sheet.setHorizontallyCenter(true);
            PrintSetup printSetup = sheet.getPrintSetup();
            printSetup.setLandscape(true);
            sheet.setAutobreaks(true);
            printSetup.setFitHeight((short)1);
            printSetup.setFitWidth((short)1);
            return sheet;
        }

        public void write(OutputStream output, boolean vertical) throws IOException {
            int headerWidth = (int)Math.round(256.0 * ApplicationProperty.TimeGridXLSHeaderWidth.doubleValue());
            int cellWidth = (int)Math.round(256.0 * (vertical ? ApplicationProperty.TimeGridXLSCellWidthVertical.doubleValue() : ApplicationProperty.TimeGridXLSCellWidth.doubleValue()));
            for (int s = 0; s < this.iWorkbook.getNumberOfSheets(); ++s) {
                Sheet sheet = this.iWorkbook.getSheetAt(s);
                sheet.setColumnWidth(0, headerWidth);
                for (short col = 1; col <= sheet.getRow(0).getLastCellNum(); col = (short)(col + 1)) {
                    sheet.setColumnWidth((int)col, cellWidth);
                }
            }
            this.iWorkbook.write(output);
            this.iWorkbook.close();
        }
    }

    public static class TimetableGrid
    extends P {
        private List<Meeting> iMeetings;
        private List<Background> iBackbrounds;

        /*
         * WARNING - void declaration
         */
        public TimetableGrid(FilterInterface filter, TimetableGridInterface.TimetableGridModel model, int index, int weekOffset, boolean showHeader) {
            block56: {
                int stop;
                int start;
                String comment;
                boolean showDate;
                boolean showRoom;
                boolean showTimes;
                boolean showInstructors;
                boolean showPreferences;
                int endSlot;
                int step;
                int startSlot;
                int nrTimes;
                boolean[] hasDay;
                int displayMode;
                block58: {
                    void var34_104;
                    void var34_102;
                    block57: {
                        P hi;
                        block55: {
                            int d;
                            super("unitime-TimetableGrid");
                            this.iMeetings = new ArrayList<Meeting>();
                            this.iBackbrounds = new ArrayList<Background>();
                            displayMode = Integer.valueOf(filter.getParameterValue("dispMode", "0"));
                            hasDay = new boolean[]{true, true, true, true, true, false, false};
                            String days = filter.getParameterValue("days");
                            int nrDays = 0;
                            if (days != null && days.length() == 7 && days.indexOf(49) >= 0) {
                                for (int i4 = 0; i4 < 7; ++i4) {
                                    if (days.charAt(i4) == '1') {
                                        hasDay[i4] = true;
                                        ++nrDays;
                                        continue;
                                    }
                                    hasDay[i4] = false;
                                }
                            }
                            nrTimes = 20;
                            startSlot = 90;
                            step = 6;
                            String[] times = filter.getParameterValue("times", "90|222|6").split("\\|");
                            if (times != null && times.length == 3) {
                                startSlot = Integer.parseInt(times[0]);
                                step = Integer.parseInt(times[2]);
                                nrTimes = (Integer.parseInt(times[1]) - startSlot) / step;
                            }
                            endSlot = startSlot + step * nrTimes;
                            showPreferences = "1".equals(filter.getParameterValue("showPreferences"));
                            showInstructors = "1".equals(filter.getParameterValue("showInstructors"));
                            showTimes = "1".equals(filter.getParameterValue("showTimes"));
                            showRoom = !"0".equals(filter.getParameterValue("resource"));
                            showDate = "-100".equals(filter.getParameterValue("weeks"));
                            comment = ExportTimetableXLS.getComment(model);
                            if (displayMode != 0) break block55;
                            int headerLines = showHeader ? 1 : 0;
                            int nrLines = 0;
                            int[] dayIndex = new int[7];
                            int x = 0;
                            int[] dayLines = new int[7];
                            for (int i5 = 0; i5 < 7; ++i5) {
                                int d2 = (i5 + weekOffset) % 7;
                                dayLines[d2] = model.getNrLines(d2, 2);
                                if (hasDay[d2] && nrLines < dayLines[d2]) {
                                    nrLines = dayLines[d2];
                                }
                                dayIndex[d2] = x++;
                                if (!hasDay[d2]) continue;
                            }
                            this.setSize(1 + nrDays * nrTimes * step, headerLines + nrLines);
                            if (headerLines > 0) {
                                P name = new P("grid-name");
                                name.setSize(1, headerLines);
                                for (int i6 = 0; i6 < 7; ++i6) {
                                    d = (i6 + weekOffset) % 7;
                                    if (!hasDay[d]) continue;
                                    name.setText(CONSTANTS.longDays()[d]);
                                    break;
                                }
                                this.add(name);
                            }
                            P verticalHeader = new P("vertical-header");
                            verticalHeader.setSize(1, nrLines);
                            this.add(verticalHeader, 0, headerLines);
                            P panel = new P("timetable-panel");
                            panel.setSize(nrDays * nrTimes * step, nrLines);
                            if (headerLines > 0) {
                                P horizontalHeader = new P("horizontal-header");
                                horizontalHeader.setSize(nrDays * nrTimes, headerLines);
                                this.add(horizontalHeader, 1, 0);
                                P lastVShead = new P("vertical-separator");
                                lastVShead.setRight(0);
                                lastVShead.setTop(0);
                                horizontalHeader.add(lastVShead);
                                for (int i = 0; i < 7; ++i) {
                                    int d3 = (i + weekOffset) % 7;
                                    if (!hasDay[d3]) continue;
                                    for (int t = 0; t < nrTimes; ++t) {
                                        int j = dayIndex[d3] * nrTimes + t;
                                        P p = new P("vertical-separator");
                                        panel.add(p, j * step, 0);
                                        P hi2 = new P("header-interval");
                                        hi2.setSize(step, headerLines);
                                        hi2.setText(ExportTimetableXLS.slot2time(startSlot + t * step));
                                        horizontalHeader.add(hi2, j * step, 0);
                                    }
                                }
                            } else {
                                for (d = 0; d < 7; ++d) {
                                    if (!hasDay[d]) continue;
                                    for (int t = 0; t < nrTimes; ++t) {
                                        int i3 = dayIndex[d] * nrTimes + t;
                                        P vs = new P("vertical-separator");
                                        panel.add(vs, i3 * step, 0);
                                    }
                                }
                            }
                            this.add(panel, 1, headerLines);
                            P lastVSpan = new P("vertical-separator");
                            lastVSpan.setRight(0);
                            lastVSpan.setTop(0);
                            panel.add(lastVSpan);
                            P lastHSpan = new P("horizontal-separator");
                            lastHSpan.setLeft(0);
                            lastHSpan.setBottom(0);
                            panel.add(lastHSpan);
                            P lastHShead = new P("horizontal-separator");
                            lastHShead.setLeft(0);
                            lastHShead.setBottom(0);
                            verticalHeader.add(lastHShead);
                            P hs = new P("horizontal-separator");
                            panel.add(hs, 0, 0);
                            P hi3 = new P("header-interval");
                            hi3.setSize(1, nrLines);
                            hi3.setText(model.getName() + (String)(comment != null && !comment.isEmpty() ? "\n" + comment : ""));
                            if (model.hasNameColor()) {
                                hi3.setColor(model.getNameColor());
                            }
                            verticalHeader.add(hi3, 0, 0);
                            for (TimetableGridInterface.TimetableGridBackground timetableGridBackground : model.getBackgrounds()) {
                                if (!hasDay[timetableGridBackground.getDay()] || timetableGridBackground.getSlot() + timetableGridBackground.getLength() <= startSlot || timetableGridBackground.getSlot() >= startSlot + step * nrTimes) continue;
                                Background b = new Background(timetableGridBackground);
                                this.iBackbrounds.add(b);
                                b.setHeight(nrLines);
                                int start2 = timetableGridBackground.getSlot();
                                int stop3 = timetableGridBackground.getSlot() + timetableGridBackground.getLength();
                                if (start2 < startSlot) {
                                    start2 = startSlot;
                                }
                                if (stop3 > endSlot) {
                                    stop3 = endSlot;
                                }
                                b.setWidth(stop3 - start2);
                                panel.add(b, dayIndex[timetableGridBackground.getDay()] * nrTimes * step + start2 - startSlot, 0);
                            }
                            for (TimetableGridInterface.TimetableGridCell timetableGridCell : model.getCells()) {
                                if (!hasDay[timetableGridCell.getDay()] || timetableGridCell.getSlot() + timetableGridCell.getLength() <= startSlot || timetableGridCell.getSlot() >= startSlot + step * nrTimes) continue;
                                Meeting m = new Meeting(timetableGridCell, showRoom, showInstructors, showTimes, showPreferences, showDate);
                                this.iMeetings.add(m);
                                int lines = timetableGridCell.getNrLines();
                                if (dayLines[timetableGridCell.getDay()] < nrLines && timetableGridCell.getIndex() + timetableGridCell.getNrLines() == dayLines[timetableGridCell.getDay()]) {
                                    lines += nrLines - dayLines[timetableGridCell.getDay()];
                                }
                                m.setHeight(lines);
                                int start3 = timetableGridCell.getSlot();
                                int stop4 = timetableGridCell.getSlot() + timetableGridCell.getLength();
                                if (start3 < startSlot) {
                                    start3 = startSlot;
                                }
                                if (stop4 > endSlot) {
                                    stop4 = endSlot;
                                }
                                m.setWidth(stop4 - start3);
                                panel.add(m, dayIndex[timetableGridCell.getDay()] * nrTimes * step + start3 - startSlot, timetableGridCell.getIndex());
                            }
                            break block56;
                        }
                        if (displayMode != 1) break block57;
                        int nrLines = 0;
                        int[] dayIndex = new int[8];
                        int[] toDayIdx = new int[7];
                        for (int i7 = 0; i7 < 7; ++i7) {
                            int d = (i7 + weekOffset) % 7;
                            dayIndex[i7] = nrLines;
                            toDayIdx[d] = i7;
                            if (!hasDay[d]) continue;
                            nrLines += model.getNrLines(d, 2);
                        }
                        dayIndex[7] = nrLines;
                        int headerLines = 1 + (comment != null && !comment.isEmpty() ? 1 : 0);
                        this.setSize(1 + nrTimes * step, headerLines + nrLines);
                        P name = new P("grid-name");
                        name.setSize(1, headerLines);
                        name.setText(model.getName() + (String)(comment != null && !comment.isEmpty() ? "\n" + comment : ""));
                        if (model.hasNameColor()) {
                            name.setColor(model.getNameColor());
                        }
                        this.add(name);
                        P verticalHeader = new P("vertical-header");
                        verticalHeader.setSize(1, nrLines);
                        this.add(verticalHeader, 0, headerLines);
                        P horizontalHeader = new P("horizontal-header");
                        horizontalHeader.setSize(nrTimes * step, headerLines);
                        this.add(horizontalHeader, 1, 0);
                        P panel = new P("timetable-panel");
                        panel.setSize(nrTimes * step, nrLines);
                        this.add(panel, 1, headerLines);
                        P lastVSpan = new P("vertical-separator");
                        lastVSpan.setRight(0);
                        lastVSpan.setTop(0);
                        panel.add(lastVSpan);
                        P lastVShead = new P("vertical-separator");
                        lastVShead.setRight(0);
                        lastVShead.setTop(0);
                        horizontalHeader.add(lastVShead);
                        P lastHSpan = new P("horizontal-separator");
                        lastHSpan.setLeft(0);
                        lastHSpan.setBottom(0);
                        panel.add(lastHSpan);
                        P lastHShead = new P("horizontal-separator");
                        lastHShead.setLeft(0);
                        lastHShead.setBottom(0);
                        verticalHeader.add(lastHShead);
                        for (int i2 = 0; i2 < nrTimes; ++i2) {
                            P p = new P("vertical-separator");
                            panel.add(p, i2 * step, 0);
                            hi = new P("header-interval");
                            hi.setSize(step, headerLines);
                            hi.setText(ExportTimetableXLS.slot2time(startSlot + i2 * step));
                            horizontalHeader.add(hi, i2 * step, 0);
                        }
                        for (int i = 0; i < 7; ++i) {
                            int n = (i + weekOffset) % 7;
                            if (!hasDay[n]) continue;
                            hi = new P("header-interval");
                            hi.setSize(1, dayIndex[1 + i] - dayIndex[i]);
                            hi.setText(CONSTANTS.longDays()[n]);
                            verticalHeader.add(hi, 0, dayIndex[i]);
                            P hs = new P("horizontal-separator");
                            panel.add(hs, 0, dayIndex[i]);
                        }
                        for (TimetableGridInterface.TimetableGridBackground timetableGridBackground : model.getBackgrounds()) {
                            if (!hasDay[timetableGridBackground.getDay()] || timetableGridBackground.getSlot() + timetableGridBackground.getLength() <= startSlot || timetableGridBackground.getSlot() >= startSlot + step * nrTimes) continue;
                            Background b = new Background(timetableGridBackground);
                            this.iBackbrounds.add(b);
                            int i8 = toDayIdx[timetableGridBackground.getDay()];
                            b.setHeight(dayIndex[i8 + 1] - dayIndex[i8]);
                            int start4 = timetableGridBackground.getSlot();
                            int stop5 = timetableGridBackground.getSlot() + timetableGridBackground.getLength();
                            if (start4 < startSlot) {
                                start4 = startSlot;
                            }
                            if (stop5 > endSlot) {
                                stop5 = endSlot;
                            }
                            b.setWidth(stop5 - start4);
                            panel.add(b, start4 - startSlot, dayIndex[i8]);
                        }
                        for (TimetableGridInterface.TimetableGridCell timetableGridCell : model.getCells()) {
                            if (!hasDay[timetableGridCell.getDay()] || timetableGridCell.getSlot() + timetableGridCell.getLength() <= startSlot || timetableGridCell.getSlot() >= startSlot + step * nrTimes) continue;
                            Meeting m = new Meeting(timetableGridCell, showRoom, showInstructors, showTimes, showPreferences, showDate);
                            this.iMeetings.add(m);
                            m.setHeight(timetableGridCell.getNrLines());
                            int start5 = timetableGridCell.getSlot();
                            int stop6 = timetableGridCell.getSlot() + timetableGridCell.getLength();
                            if (start5 < startSlot) {
                                start5 = startSlot;
                            }
                            if (stop6 > endSlot) {
                                stop6 = endSlot;
                            }
                            m.setWidth(stop6 - start5);
                            panel.add(m, start5 - startSlot, dayIndex[toDayIdx[timetableGridCell.getDay()]] + timetableGridCell.getIndex());
                        }
                        break block56;
                    }
                    if (displayMode != 2) break block58;
                    int nrColumns = 0;
                    int[] colIndex = new int[8];
                    int[] toDayIdx = new int[7];
                    for (int i9 = 0; i9 < 7; ++i9) {
                        int d = (i9 + weekOffset) % 7;
                        colIndex[i9] = nrColumns;
                        toDayIdx[d] = i9;
                        if (!hasDay[d]) continue;
                        nrColumns += model.getNrLines(d, 1);
                    }
                    colIndex[7] = nrColumns;
                    int linesPerTime = step;
                    int headerLines = 1 + (comment != null && !comment.isEmpty() ? 1 : 0);
                    this.setSize(1 + nrColumns, headerLines + linesPerTime * nrTimes);
                    P name = new P("grid-name");
                    name.setSize(1, headerLines);
                    name.setText(model.getName() + (String)(comment != null && !comment.isEmpty() ? "\n" + comment : ""));
                    if (model.hasNameColor()) {
                        name.setColor(model.getNameColor());
                    }
                    this.add(name);
                    P verticalHeader = new P("vertical-header");
                    verticalHeader.setSize(1, linesPerTime * nrTimes);
                    this.add(verticalHeader, 0, headerLines);
                    P horizontalHeader = new P("horizontal-header");
                    horizontalHeader.setSize(nrColumns, headerLines);
                    this.add(horizontalHeader, 1, 0);
                    P panel = new P("timetable-panel");
                    panel.setSize(nrColumns, linesPerTime * nrTimes);
                    this.add(panel, 1, headerLines);
                    P lastVSpan = new P("vertical-separator");
                    lastVSpan.setRight(0);
                    lastVSpan.setTop(0);
                    panel.add(lastVSpan);
                    P lastVShead = new P("vertical-separator");
                    lastVShead.setRight(0);
                    lastVShead.setTop(0);
                    horizontalHeader.add(lastVShead);
                    P lastHSpan = new P("horizontal-separator");
                    lastHSpan.setLeft(0);
                    lastHSpan.setBottom(0);
                    panel.add(lastHSpan);
                    P lastHShead = new P("horizontal-separator");
                    lastHShead.setLeft(0);
                    lastHShead.setBottom(0);
                    verticalHeader.add(lastHShead);
                    boolean bl = false;
                    while (var34_102 < 7) {
                        void d = (var34_102 + weekOffset) % 7;
                        if (hasDay[d]) {
                            P vs = new P("vertical-separator");
                            panel.add(vs, colIndex[var34_102], 0);
                            P hi = new P("header-interval");
                            hi.setSize(model.getNrLines((int)d, 1), headerLines);
                            hi.setText(CONSTANTS.longDays()[d]);
                            horizontalHeader.add(hi, colIndex[var34_102], 0);
                        }
                        ++var34_102;
                    }
                    boolean bl2 = false;
                    while (var34_104 < nrTimes) {
                        P hs = new P("horizontal-separator");
                        panel.add(hs, 0, linesPerTime * var34_104);
                        P hi = new P("header-interval");
                        hi.setSize(1, linesPerTime);
                        hi.setText(ExportTimetableXLS.slot2time(startSlot + step * var34_104));
                        verticalHeader.add(hi, 0, linesPerTime * var34_104);
                        ++var34_104;
                    }
                    for (TimetableGridInterface.TimetableGridBackground cell : model.getBackgrounds()) {
                        if (!hasDay[cell.getDay()] || cell.getSlot() + cell.getLength() <= startSlot || cell.getSlot() >= startSlot + step * nrTimes) continue;
                        Background b = new Background(cell);
                        this.iBackbrounds.add(b);
                        int start6 = cell.getSlot();
                        int stop2 = cell.getSlot() + cell.getLength();
                        if (start6 < startSlot) {
                            start6 = startSlot;
                        }
                        if (stop2 > endSlot) {
                            stop2 = endSlot;
                        }
                        b.setHeight(stop2 * linesPerTime / step - start6 * linesPerTime / step);
                        int i10 = toDayIdx[cell.getDay()];
                        b.setWidth(colIndex[1 + i10] - colIndex[i10]);
                        panel.add(b, colIndex[i10], (start6 - startSlot) * linesPerTime / step);
                    }
                    for (TimetableGridInterface.TimetableGridCell cell : model.getCells()) {
                        if (!hasDay[cell.getDay()] || cell.getSlot() + cell.getLength() <= startSlot || cell.getSlot() >= startSlot + step * nrTimes) continue;
                        Meeting m = new Meeting(cell, showRoom, showInstructors, showTimes, showPreferences, showDate);
                        this.iMeetings.add(m);
                        int start7 = cell.getSlot();
                        int stop2 = cell.getSlot() + cell.getLength();
                        if (start7 < startSlot) {
                            start7 = startSlot;
                        }
                        if (stop2 > endSlot) {
                            stop2 = endSlot;
                        }
                        m.setHeight((stop2 - startSlot) * linesPerTime / step - (start7 - startSlot) * linesPerTime / step);
                        m.setWidth(cell.getNrLines());
                        panel.add(m, colIndex[toDayIdx[cell.getDay()]] + cell.getIndex(), (start7 - startSlot) * linesPerTime / step);
                    }
                    break block56;
                }
                if (displayMode != 3) break block56;
                int nrLines = 0;
                int[] dayIndex = new int[366];
                for (int d = 0; d < 365; ++d) {
                    int day;
                    dayIndex[d] = nrLines;
                    int date = d + model.getFirstSessionDay();
                    if (model.getFirstDay() >= 0 && (date < model.getFirstDay() || date > model.getFirstDay() + 6) || !hasDay[day = d % 7] || !model.hasDate(day, date)) continue;
                    nrLines += model.getNrDateLines(day, date, 2);
                }
                dayIndex[365] = nrLines;
                int headerLines = 1 + (comment != null && !comment.isEmpty() ? 1 : 0);
                this.setSize(1 + nrTimes * step, headerLines + nrLines);
                P name = new P("grid-name");
                name.setSize(1, headerLines);
                name.setText(model.getName() + (String)(comment != null && !comment.isEmpty() ? "\n" + comment : ""));
                if (model.hasNameColor()) {
                    name.setColor(model.getNameColor());
                }
                this.add(name);
                P verticalHeader = new P("vertical-header");
                verticalHeader.setSize(1, nrLines);
                this.add(verticalHeader, 0, headerLines);
                P horizontalHeader = new P("horizontal-header");
                horizontalHeader.setSize(nrTimes * step, headerLines);
                this.add(horizontalHeader, 1, 0);
                P panel = new P("timetable-panel");
                panel.setSize(nrTimes * step, nrLines);
                this.add(panel, 1, headerLines);
                P lastVSpan = new P("vertical-separator");
                lastVSpan.setRight(0);
                lastVSpan.setTop(0);
                panel.add(lastVSpan);
                P lastVShead = new P("vertical-separator");
                lastVShead.setRight(0);
                lastVShead.setTop(0);
                horizontalHeader.add(lastVShead);
                P lastHSpan = new P("horizontal-separator");
                lastHSpan.setLeft(0);
                lastHSpan.setBottom(0);
                panel.add(lastHSpan);
                P lastHShead = new P("horizontal-separator");
                lastHShead.setLeft(0);
                lastHShead.setBottom(0);
                verticalHeader.add(lastHShead);
                for (int i = 0; i < nrTimes; ++i) {
                    P vs = new P("vertical-separator");
                    panel.add(vs, i * step, 0);
                    P p = new P("header-interval");
                    p.setSize(step, headerLines);
                    p.setText(ExportTimetableXLS.slot2time(startSlot + i * step));
                    horizontalHeader.add(p, i * step, 0);
                }
                for (int d = 0; d < 365; ++d) {
                    int n;
                    int date = d + model.getFirstSessionDay();
                    if (model.getFirstDay() >= 0 && (date < model.getFirstDay() || date > model.getFirstDay() + 6) || !hasDay[n = d % 7] || !model.hasDate(n, date)) continue;
                    P hs = new P("horizontal-separator");
                    panel.add(hs, 0, dayIndex[d]);
                    P hi = new P("header-interval");
                    hi.setSize(1, dayIndex[1 + d] - dayIndex[d]);
                    hi.setText(sDateFormatMeeting.format(ExportTimetableXLS.getDate(model.getFirstDate(), d)));
                    verticalHeader.add(hi, 0, dayIndex[d]);
                }
                for (TimetableGridInterface.TimetableGridBackground cell : model.getBackgrounds()) {
                    if (!hasDay[cell.getDay()] || cell.getSlot() + cell.getLength() <= startSlot || cell.getSlot() >= startSlot + step * nrTimes) continue;
                    for (int i = 0; i < 365; ++i) {
                        int date = i + model.getFirstSessionDay();
                        int day = i % 7;
                        if (model.getFirstDay() >= 0 && (date < model.getFirstDay() || date > model.getFirstDay() + 6) || cell.getDay() != day) continue;
                        Background b = new Background(cell);
                        this.iBackbrounds.add(b);
                        b.setHeight(dayIndex[1 + i] - dayIndex[i]);
                        start = cell.getSlot();
                        stop = cell.getSlot() + cell.getLength();
                        if (start < startSlot) {
                            start = startSlot;
                        }
                        if (stop > endSlot) {
                            stop = endSlot;
                        }
                        b.setWidth(stop - start);
                        panel.add(b, start - startSlot, dayIndex[i]);
                    }
                }
                for (TimetableGridInterface.TimetableGridCell cell : model.getCells()) {
                    if (!hasDay[cell.getDay()] || cell.getSlot() + cell.getLength() <= startSlot || cell.getSlot() >= startSlot + step * nrTimes) continue;
                    for (int i = 0; i < 365; ++i) {
                        int date = i + model.getFirstSessionDay();
                        if (model.getFirstDay() >= 0 && (date < model.getFirstDay() || date > model.getFirstDay() + 6)) continue;
                        int day = i % 7;
                        if (cell.getDay() != day || !cell.hasDate(date)) continue;
                        Meeting m = new Meeting(cell, showRoom, showInstructors, showTimes, showPreferences, showDate);
                        this.iMeetings.add(m);
                        m.setHeight(cell.getNrLines(date));
                        start = cell.getSlot();
                        stop = cell.getSlot() + cell.getLength();
                        if (start < startSlot) {
                            start = startSlot;
                        }
                        if (stop > endSlot) {
                            stop = endSlot;
                        }
                        m.setWidth(stop - start);
                        panel.add(m, start - startSlot, dayIndex[i] + cell.getIndex(date));
                    }
                }
            }
        }

        public boolean hasMeetings() {
            return !this.iMeetings.isEmpty();
        }
    }

    protected static class P {
        private Integer iLeft;
        private Integer iTop;
        private Integer iRight;
        private Integer iBottom;
        private Integer iWidth;
        private Integer iHeight;
        private String iText;
        private String iStyle;
        private boolean iItalics = false;
        private String iColor;
        private String iBgColor;
        private List<P> iContent = new ArrayList<P>();

        public P(String style) {
            this.iStyle = style;
        }

        public void setWidth(int width) {
            this.iWidth = width;
        }

        public void setHeight(int height) {
            this.iHeight = height;
        }

        public void setSize(int width, int height) {
            this.setWidth(width);
            this.setHeight(height);
        }

        public void setText(String text) {
            this.iText = text;
        }

        public void setLeft(int left) {
            this.iLeft = left;
        }

        public void setRight(int right) {
            this.iRight = right;
        }

        public void setBottom(int bottom) {
            this.iBottom = bottom;
        }

        public void setTop(int top) {
            this.iTop = top;
        }

        public void setColor(String color) {
            this.iColor = color;
        }

        public void setBackgroundColor(String color) {
            this.iBgColor = color;
        }

        public void setItalics(boolean italics) {
            this.iItalics = italics;
        }

        public void add(P p) {
            this.iContent.add(p);
        }

        public void add(P p, int left, int top) {
            p.iTop = top;
            p.iLeft = left;
            this.iContent.add(p);
        }

        public int getLeft() {
            if (this.iLeft != null) {
                return this.iLeft;
            }
            if (this.iRight != null) {
                return this.getWidth() - this.iRight;
            }
            return 0;
        }

        public int getTop() {
            if (this.iTop != null) {
                return this.iTop;
            }
            if (this.iBottom != null) {
                return this.getHeight() - this.iBottom;
            }
            return 0;
        }

        public int getWidth() {
            if (this.iWidth != null) {
                return this.iWidth;
            }
            int width = 0;
            for (P p : this.iContent) {
                int w = p.getLeft() + p.getWidth();
                if (w <= width) continue;
                width = w;
            }
            return width;
        }

        public int getHeight() {
            if (this.iHeight != null) {
                return this.iHeight;
            }
            int height = 0;
            for (P p : this.iContent) {
                int h = p.getTop() + p.getHeight();
                if (h <= height) continue;
                height = h;
            }
            return height;
        }

        public boolean hasText() {
            return this.iText != null && !this.iText.isEmpty();
        }

        public String getText() {
            return this.iText;
        }

        public String getStyle() {
            return this.iStyle;
        }

        public boolean isStyle(String ... style) {
            for (String s : style) {
                if (!s.equals(this.iStyle)) continue;
                return true;
            }
            return false;
        }

        public void print(ExportContext cx, Sheet sheet, int x, int y, P parent) {
            CellStyle lineStyle;
            Cell c;
            Pattern p;
            Matcher m;
            if (this.isStyle("unitime-TimetableGrid")) {
                for (int r = y; r < y + this.getHeight(); ++r) {
                    Row row = sheet.createRow(r);
                    if (cx.getRowHeight() != null) {
                        row.setHeightInPoints(cx.getRowHeight().floatValue());
                    } else {
                        row.setHeightInPoints(sheet.getDefaultRowHeightInPoints());
                    }
                    for (int c2 = x; c2 < x + this.getWidth(); ++c2) {
                        row.createCell(c2);
                    }
                }
            }
            if (this.isStyle("vertical-separator")) {
                this.setHeight(parent.getHeight());
            }
            if (this.isStyle("horizontal-separator")) {
                this.setWidth(parent.getWidth());
            }
            Color bgColor = null;
            if (parent != null && parent.isStyle("meeting")) {
                bgColor = Color.WHITE;
            }
            if (this.iBgColor != null && (m = (p = Pattern.compile("rgb\\(([0-9]+),([0-9]+),([0-9]+)\\)")).matcher(this.iBgColor)).matches()) {
                bgColor = new Color(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)), Integer.parseInt(m.group(3)));
            }
            if (parent != null && parent.isStyle("meeting")) {
                if (parent.iBgColor != null) {
                    p = Pattern.compile("rgb\\(([0-9]+),([0-9]+),([0-9]+)\\)");
                    m = p.matcher(parent.iBgColor);
                    if (m.matches()) {
                        Color color = new Color(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)), Integer.parseInt(m.group(3)));
                        bgColor = this.isStyle("header") ? color.darker() : color;
                    }
                } else {
                    Color color = Color.WHITE;
                    bgColor = this.isStyle("header") ? Color.LIGHT_GRAY : color;
                }
            }
            Cell cell = null;
            if (this.isStyle("header") && parent.isStyle("meeting")) {
                cell = sheet.getRow(y + this.getTop()).getCell(x + this.getLeft());
                cell.setCellStyle(cx.getMeetingHeaderStyle(this, parent, bgColor));
            }
            if (this.isStyle("footer") && parent.isStyle("meeting")) {
                cell = sheet.getRow(y + this.getTop()).getCell(x + this.getLeft());
                cell.setCellStyle(cx.getMeetingFooterStyle(this, parent, bgColor));
            }
            if (this.isStyle("header-interval")) {
                cell = sheet.getRow(y + this.getTop()).getCell(x + this.getLeft());
                cell.setCellStyle(cx.getHeaderIntervalStyle(this));
            }
            if (this.isStyle("grid-name")) {
                cell = sheet.getRow(y + this.getTop()).getCell(x + this.getLeft());
                cell.setCellStyle(cx.getGridNameStyle(this));
            }
            if (cell != null) {
                if (this.hasText()) {
                    cell.setCellValue(this.getText());
                }
                if (this.getHeight() > 1 || this.getWidth() > 1) {
                    try {
                        sheet.addMergedRegion(new CellRangeAddress(y + this.getTop(), y + this.getTop() + this.getHeight() - 1, x + this.getLeft(), x + this.getLeft() + this.getWidth() - 1));
                    }
                    catch (IllegalStateException e) {
                        System.err.println(e.getMessage());
                    }
                    for (int dx = 0; dx < this.getWidth() + 1; ++dx) {
                        for (int dy = 0; dy < this.getHeight() + 1; ++dy) {
                            CellStyle lineStyle2;
                            Cell c3;
                            Row r;
                            if (dx == 0 && dy == 0 || (r = sheet.getRow(y + this.getTop() + dy)) == null || (c3 = r.getCell(x + this.getLeft() + dx)) == null || (lineStyle2 = cx.getLineStyle(this, dx, dy, bgColor, parent, c3.getCellStyle())) == null) continue;
                            c3.setCellStyle(lineStyle2);
                        }
                    }
                }
            }
            if (this.isStyle("horizontal-separator")) {
                for (int dx = 0; dx < this.getWidth(); ++dx) {
                    c = sheet.getRow(y + this.getTop()).getCell(x + this.getLeft() + dx);
                    lineStyle = cx.getLineStyle(this, dx, 0, bgColor, parent, c.getCellStyle());
                    if (lineStyle == null) continue;
                    c.setCellStyle(lineStyle);
                }
            }
            if (this.isStyle("vertical-separator")) {
                for (int dy = 0; dy < this.getHeight(); ++dy) {
                    c = sheet.getRow(y + this.getTop() + dy).getCell(x + this.getLeft());
                    lineStyle = cx.getLineStyle(this, 0, dy, bgColor, parent, c.getCellStyle());
                    if (lineStyle == null) continue;
                    c.setCellStyle(lineStyle);
                }
            }
            if (this.isStyle("unitime-TimetableGrid") || this.isStyle("background")) {
                for (int dx = 0; dx < this.getWidth(); ++dx) {
                    for (int dy = 0; dy < this.getHeight(); ++dy) {
                        Cell c4 = sheet.getRow(y + this.getTop() + dy).getCell(x + this.getLeft() + dx);
                        CellStyle lineStyle3 = cx.getLineStyle(this, dx, dy, bgColor, parent, c4.getCellStyle());
                        if (lineStyle3 == null) continue;
                        c4.setCellStyle(lineStyle3);
                    }
                }
            }
            for (P p2 : this.iContent) {
                p2.print(cx, sheet, x + this.getLeft(), y + this.getTop(), this);
            }
        }
    }

    protected static class Background
    extends P {
        private TimetableGridInterface.TimetableGridBackground iBackground;

        public Background(TimetableGridInterface.TimetableGridBackground background) {
            super("background");
            this.iBackground = background;
            if (background.hasBackground()) {
                this.setBackgroundColor(background.getBackground());
            }
        }

        public TimetableGridInterface.TimetableGridBackground getBackground() {
            return this.iBackground;
        }
    }

    protected static class Meeting
    extends P {
        private TimetableGridInterface.TimetableGridCell iCell;
        private P iHeader;
        private P iFooter;

        private Meeting(TimetableGridInterface.TimetableGridCell cell, boolean showRoom, boolean showInstructor, boolean showTime, boolean showPreference, boolean showDate) {
            super("meeting");
            this.iCell = cell;
            if (cell.hasBackground()) {
                this.setBackgroundColor(cell.getBackground());
            }
            this.iHeader = new P("header");
            this.iHeader.setHeight(cell.getNrNames());
            this.iHeader.setText(cell.getName("\n"));
            if (cell.isItalics()) {
                this.iHeader.setItalics(true);
            }
            this.add(this.iHeader, 0, 0);
            this.iFooter = new P("footer");
            Object notes = "";
            if (showTime && cell.hasTime()) {
                notes = (String)notes + (((String)notes).isEmpty() ? "" : "\n") + cell.getTime();
            }
            if (showDate && cell.hasDate()) {
                notes = (String)notes + (((String)notes).isEmpty() ? "" : "\n") + cell.getDate();
            }
            if (showRoom && cell.getNrRooms() > 0) {
                notes = (String)notes + (((String)notes).isEmpty() ? "" : "\n") + cell.getRoom("\n");
            }
            if (showInstructor && cell.getNrInstructors() > 0) {
                notes = (String)notes + (((String)notes).isEmpty() ? "" : "\n") + cell.getInstructor("\n");
            }
            if (showPreference && cell.hasPreference()) {
                notes = (String)notes + (((String)notes).isEmpty() ? "" : "\n") + cell.getPreference().replaceAll("\\<[^>]*>", "");
            }
            this.iFooter.setText((String)notes);
            this.add(this.iFooter, 0, this.iHeader.getHeight());
        }

        @Override
        public void setHeight(int height) {
            super.setHeight(height);
            this.iFooter.setHeight(height - this.iHeader.getHeight());
        }

        @Override
        public void setWidth(int width) {
            super.setWidth(width);
            this.iHeader.setWidth(width);
            this.iFooter.setWidth(width);
        }

        public TimetableGridInterface.TimetableGridCell getCell() {
            return this.iCell;
        }
    }
}

