/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.SecurityMessages;
import org.unitime.timetable.StartupService;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.BlankForm;
import org.unitime.timetable.spring.SpringApplicationContextHolder;

@Action(value="login", results={@Result(name={"login"}, location="/login2.jsp"), @Result(name={"selectPrimaryRole"}, type="redirect", location="/selectPrimaryRole.action")})
public class LoginAction
extends UniTimeAction<BlankForm> {
    private static final long serialVersionUID = -7818620515562212897L;
    protected static SecurityMessages MSG = Localization.create(SecurityMessages.class);
    private int error = 0;
    private String menu;
    private String target;
    private String force;

    public Integer getE() {
        return this.error;
    }

    public void setE(Integer error) {
        this.error = error;
    }

    public String getErrorMsg() {
        switch (this.error) {
            case 1: {
                return MSG.errorInvalidUserPasswd();
            }
            case 2: {
                return MSG.errorAuthenticationFailed();
            }
            case 3: {
                return MSG.errorAuthenticationFailed();
            }
            case 4: {
                return MSG.errorUserLockedOut();
            }
        }
        return null;
    }

    public String getForce() {
        return this.force;
    }

    public void setForce(String force) {
        this.force = force;
    }

    public String getMenu() {
        return this.menu;
    }

    public void setMenu(String menu) {
        this.menu = menu;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getExternalHeader() {
        return ApplicationProperty.LoginPageHeader.value();
    }

    public String getExternalFooter() {
        return ApplicationProperty.LoginPageFooter.value();
    }

    protected StartupService getStartupService() {
        return (StartupService)SpringApplicationContextHolder.getBean("startupService");
    }

    public boolean getHasInitializationError() {
        return this.getStartupService().getInitializationException() != null;
    }

    public boolean isHasOauth2Authentication() {
        return ApplicationProperty.AuthenticationOAuht2ClientId.value() != null && !ApplicationProperty.AuthenticationOAuht2ClientId.value().isEmpty();
    }

    public String getOauth2LoginMessage() {
        return ApplicationProperty.AuthenticationOAuht2LoginMessage.value();
    }

    public String getOauth2LoginUrl() {
        return "oauth2/authorization/" + ApplicationProperty.AuthenticationOAuht2Provider.value();
    }

    public void printInitializationError() throws IOException {
        for (Throwable t = this.getStartupService().getInitializationException(); t != null; t = t.getCause()) {
            String clazz = t.getClass().getName();
            if (clazz.indexOf(46) >= 0) {
                clazz = clazz.substring(1 + clazz.lastIndexOf(46));
            }
            this.getPageContext().getOut().println("<br>" + clazz + ": " + t.getMessage() + (String)(t.getStackTrace() != null && t.getStackTrace().length > 0 ? " (at " + t.getStackTrace()[0].getFileName() + ":" + t.getStackTrace()[0].getLineNumber() + ")" : ""));
        }
    }

    public String execute() throws Exception {
        if ("true".equals(this.force)) {
            return "login";
        }
        if ("forward".equalsIgnoreCase(ApplicationProperty.LoginMethod.value())) {
            String login = ApplicationProperty.LoginPage.value();
            if (login == null || "login.jsp".equals(login) || "/login.jsp".equals(login) || "login".equals(login) || "login.action".equals(login)) {
                return "login";
            }
            if ("selectPrimaryRole.do".equals(login) || "/selectPrimaryRole.do".equals(login) || "selectPrimaryRole".equals(login) || "selectPrimaryRole.action".equals(login)) {
                return "selectPrimaryRole";
            }
            this.request.getRequestDispatcher(ApplicationProperty.LoginPage.value()).forward((ServletRequest)this.request, (ServletResponse)this.response);
        }
        if (this.target == null) {
            this.response.sendRedirect(ApplicationProperty.LoginPage.value());
        } else {
            this.response.sendRedirect(ApplicationProperty.LoginPage.value() + "?target=" + URLEncoder.encode(this.target, "UTF-8"));
        }
        return null;
    }
}

