/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesDefinitions;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.BlankForm;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.InstructorSurvey;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.util.IdValue;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.InstructorListBuilder;
import org.unitime.timetable.webutil.PdfWebTable;

@Action(value="instructorSearch", results={@Result(name={"showSearch"}, type="tiles", location="instructorSearch.tiles"), @Result(name={"showList"}, type="tiles", location="instructorSearch.tiles"), @Result(name={"manageInstructorList"}, type="redirect", location="/instructorListUpdate.action"), @Result(name={"addNewInstructor"}, type="redirect", location="/instructorAdd.action")})
@TilesDefinitions(value={@TilesDefinition(name="instructorSearch.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Instructors"), @TilesPutAttribute(name="body", value="/user/instructorSearch.jsp")})})
public class InstructorSearchAction
extends UniTimeAction<BlankForm> {
    private static final long serialVersionUID = -7920936708671752660L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private String iDeptId;
    private boolean iHasSurveys = false;

    public String getDeptId() {
        return this.iDeptId;
    }

    public void setDeptId(String deptId) {
        this.iDeptId = deptId;
    }

    public boolean getHasSurveys() {
        return this.iHasSurveys;
    }

    public void setHasSurveys(boolean hasSurveys) {
        this.iHasSurveys = hasSurveys;
    }

    public String execute() throws IOException {
        Department d;
        PdfWebTable table;
        if (MSG.actionManageInstructorList().equals(this.getOp())) {
            return "manageInstructorList";
        }
        if (MSG.actionAddNewInstructor().equals(this.getOp())) {
            return "addNewInstructor";
        }
        this.sessionContext.checkPermission(Right.Instructors);
        this.setupManagerDepartments();
        if (this.getDeptId() == null || this.getDeptId().isEmpty()) {
            this.setDeptId((String)this.sessionContext.getAttribute(SessionAttribute.DepartmentId));
        }
        if (MSG.actionSearchInstructors().equals(this.getOp()) && (this.getDeptId() == null || this.getDeptId().isEmpty())) {
            this.addActionError(MSG.errorRequiredDepartment());
        }
        if (this.getDeptId() == null || this.getDeptId().isEmpty() || !this.sessionContext.hasPermission((Serializable)((Object)this.getDeptId()), "Department", Right.Instructors)) {
            return "showSearch";
        }
        this.sessionContext.setAttribute(SessionAttribute.DepartmentId, (Object)this.getDeptId());
        WebTable.setOrder(this.sessionContext, "instructorList.ord", this.request.getParameter("order"), 2);
        InstructorListBuilder ilb = new InstructorListBuilder();
        String backId = "PreferenceGroup".equals(this.request.getParameter("backType")) ? this.request.getParameter("backId") : null;
        String tblData = ilb.htmlTableForInstructor(this.sessionContext, this.getDeptId(), WebTable.getOrder(this.sessionContext, "instructorList.ord"), backId);
        if (tblData == null || tblData.trim().isEmpty()) {
            this.addActionError(MSG.errorNoInstructorsFoundInSearch());
            return "showSearch";
        }
        this.request.setAttribute("instructorList", (Object)tblData);
        if (MSG.actionExportPdf().equals(this.op)) {
            table = ilb.pdfTableForInstructor(this.sessionContext, this.getDeptId(), true);
            if (table != null) {
                try {
                    ExportUtils.exportPDF(table, WebTable.getOrder(this.sessionContext, "instructorList.ord"), this.response, "instructors");
                    return null;
                }
                catch (Exception e) {
                    this.addActionError(MSG.exportFailed(e.getMessage()));
                }
            }
        } else if (MSG.actionExportCsv().equals(this.op)) {
            table = ilb.pdfTableForInstructor(this.sessionContext, this.getDeptId(), false);
            if (table != null) {
                try {
                    ExportUtils.exportCSV(table, WebTable.getOrder(this.sessionContext, "instructorList.ord"), this.response, "instructors");
                    return null;
                }
                catch (Exception e) {
                    this.addActionError(MSG.exportFailed(e.getMessage()));
                }
            }
        } else if (MSG.actionExportSurveysXLS().equals(this.op)) {
            this.response.sendRedirect(this.response.encodeURL("export?output=instructor-surveys.xls&department=" + this.getDeptId()));
            return null;
        }
        if (this.getDeptId() != null && !this.getDeptId().isEmpty()) {
            this.setHasSurveys(InstructorSurvey.hasInstructorSurveys(Long.valueOf(this.getDeptId())));
        } else {
            this.setHasSurveys(false);
        }
        if (this.getDeptId() != null && !this.getDeptId().isEmpty()) {
            d = (Department)DepartmentDAO.getInstance().get(Long.valueOf(this.getDeptId()));
            if (d != null) {
                BackTracker.markForBack(this.request, "instructorSearch.action?deptId=" + d.getUniqueId(), MSG.backInstructors(d.getDeptCode() + " - " + d.getName()), true, true);
            }
        } else if (this.sessionContext.getAttribute(SessionAttribute.DepartmentId) != null) {
            d = (Department)DepartmentDAO.getInstance().get(Long.valueOf(this.sessionContext.getAttribute(SessionAttribute.DepartmentId).toString()));
            if (d != null) {
                BackTracker.markForBack(this.request, "instructorSearch.action?deptId=" + d.getUniqueId(), MSG.backInstructors(d.getDeptCode() + " - " + d.getName()), true, true);
            }
        } else {
            BackTracker.markForBack(this.request, "instructorSearch.action", MSG.backInstructors2(), true, true);
        }
        return "showList";
    }

    private Set<Department> setupManagerDepartments() {
        TreeSet<Department> departments = Department.getUserDepartments(this.sessionContext.getUser());
        if (departments.isEmpty()) {
            this.addActionError(MSG.exceptionNoDepartmentToManage());
        }
        ArrayList<IdValue> labelValueDepts = new ArrayList<IdValue>();
        for (Department d : departments) {
            labelValueDepts.add(new IdValue(d.getUniqueId(), d.getDeptCode() + " - " + d.getName()));
        }
        if (labelValueDepts.size() == 1) {
            this.setDeptId(((IdValue)labelValueDepts.get(0)).getId().toString());
        }
        this.request.setAttribute(Department.DEPT_ATTR_NAME, labelValueDepts);
        return departments;
    }
}

