/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.check;

import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Student;

public class OverlapCheck {
    private static Logger sLog = LogManager.getLogger(OverlapCheck.class);
    private StudentSectioningModel iModel;

    public OverlapCheck(StudentSectioningModel model) {
        this.iModel = model;
    }

    public StudentSectioningModel getModel() {
        return this.iModel;
    }

    public boolean check(Assignment<Request, Enrollment> a) {
        sLog.info("Checking for overlaps...");
        boolean ret = true;
        for (Student student : this.getModel().getStudents()) {
            HashMap<TimeLocation, SctAssignment> times = new HashMap<TimeLocation, SctAssignment>();
            for (Request request : student.getRequests()) {
                Enrollment enrollment = a.getValue(request);
                if (enrollment == null) continue;
                for (SctAssignment assignment : enrollment.getAssignments()) {
                    if (assignment.getTime() == null) continue;
                    for (TimeLocation time : times.keySet()) {
                        if (!time.hasIntersection(assignment.getTime())) continue;
                        sLog.error("Student " + student + " assignment " + assignment + " overlaps with " + times.get(time));
                        ret = false;
                    }
                    times.put(assignment.getTime(), assignment);
                }
            }
        }
        return ret;
    }
}

