/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.solver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.DefaultParallelAssignment;
import org.cpsolver.ifs.assignment.DefaultSingleAssignment;
import org.cpsolver.ifs.model.LazyNeighbour;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solution.SolutionListener;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.solver.SolverListener;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.JProf;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.ifs.util.ToolBox;

public class ParallelSolver<V extends Variable<V, T>, T extends Value<V, T>>
extends Solver<V, T> {
    private SynchronizationThread iSynchronizationThread = null;
    private int iNrFinished = 0;

    public ParallelSolver(DataProperties properties) {
        super(properties);
    }

    @Override
    public void start() {
        int nrSolvers = Math.min(Math.abs(this.getProperties().getPropertyInt("Parallel.NrSolvers", 4)), 16);
        if (nrSolvers == 1) {
            super.start();
        } else {
            this.iSynchronizationThread = new SynchronizationThread(nrSolvers);
            this.iSynchronizationThread.setPriority(THREAD_PRIORITY);
            this.iSynchronizationThread.start();
        }
    }

    @Override
    public Thread getSolverThread() {
        return this.iSynchronizationThread != null ? this.iSynchronizationThread : super.getSolverThread();
    }

    @Override
    public void setInitalSolution(Model<V, T> model) {
        int nrSolvers = Math.min(Math.abs(this.getProperties().getPropertyInt("Parallel.NrSolvers", 4)), 16);
        boolean updateMasterSolution = this.getProperties().getPropertyBoolean("Parallel.UpdateMasterSolution", true);
        ((Solver)this).setInitalSolution(new Solution<V, T>(model, nrSolvers > 1 ? new DefaultParallelAssignment(updateMasterSolution ? 1 : 0) : new DefaultSingleAssignment(), 0L, 0.0));
    }

    protected Solution<V, T> getWorkingSolution() {
        if (this.iSynchronizationThread != null && !this.hasSingleSolution()) {
            int idx = this.currentSolution().getBestIndex();
            if (idx < 0) {
                idx = 0;
            }
            if (idx < this.iSynchronizationThread.iSolvers.size()) {
                return ((SolverThread)this.iSynchronizationThread.iSolvers.get(idx)).iSolution;
            }
        }
        return this.currentSolution();
    }

    protected Solution<V, T> createParallelSolution(int index) {
        Model model = this.iCurrentSolution.getModel();
        DefaultParallelAssignment assignment = new DefaultParallelAssignment(index, model, this.iCurrentSolution.getAssignment());
        model.createAssignmentContexts(assignment, true);
        Solution solution = new Solution(model, assignment);
        for (SolutionListener listener : this.iCurrentSolution.getSolutionListeners()) {
            solution.addSolutionListener(listener);
        }
        return solution;
    }

    @Override
    public boolean hasSingleSolution() {
        return this.iCurrentSolution.getAssignment() instanceof DefaultSingleAssignment;
    }

    protected class AssignmentThread
    extends Thread {
        private double iStartTime;
        private Solution<V, T> iSolution;
        private BlockingQueue<Neighbour<V, T>> iQueue;

        public AssignmentThread(BlockingQueue<Neighbour<V, T>> queue) {
            this.setName("Assignment");
            this.setPriority(1 + Solver.THREAD_PRIORITY);
            this.iSolution = ParallelSolver.this.iCurrentSolution;
            this.iQueue = queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.iStartTime = JProf.currentTimeSec();
            try {
                boolean neighbourCheck = ParallelSolver.this.getProperties().getPropertyBoolean("ParallelSolver.SingleSolutionNeighbourCheck", false);
                while (!ParallelSolver.this.iStop && ParallelSolver.this.getTerminationCondition().canContinue(this.iSolution)) {
                    Neighbour neighbour = this.iQueue.poll(1000L, TimeUnit.MILLISECONDS);
                    if (neighbour == null) continue;
                    double time = JProf.currentTimeSec() - this.iStartTime;
                    Map assignments = null;
                    try {
                        assignments = neighbour.assignments();
                    }
                    catch (Exception e) {
                        Solver.sLogger.error("Failed to enumerate " + neighbour.getClass().getSimpleName(), (Throwable)e);
                    }
                    if (assignments == null) {
                        Solver.sLogger.debug("No assignments returned.");
                        this.iSolution.update(time, false);
                        continue;
                    }
                    Lock lock = this.iSolution.getLock().writeLock();
                    lock.lock();
                    try {
                        Object var2;
                        LazyNeighbour.LazyNeighbourAcceptanceCriterion lazy = null;
                        double before = 0.0;
                        double value = 0.0;
                        if (neighbour instanceof LazyNeighbour) {
                            before = this.iSolution.getModel().getTotalValue(this.iSolution.getAssignment());
                            lazy = ((LazyNeighbour)neighbour).getAcceptanceCriterion();
                        } else if (neighbourCheck) {
                            before = this.iSolution.getModel().getTotalValue(this.iSolution.getAssignment());
                            value = neighbour.value(this.iSolution.getAssignment());
                        }
                        HashMap undo = new HashMap();
                        for (Object var2 : assignments.keySet()) {
                            undo.put((Variable)var2, this.iSolution.getAssignment().unassign(this.iSolution.getIteration(), var2));
                        }
                        boolean fail = false;
                        var2 = assignments.values().iterator();
                        while (var2.hasNext()) {
                            Value val = (Value)var2.next();
                            if (val == null) continue;
                            if (this.iSolution.getModel().inConflict(this.iSolution.getAssignment(), val)) {
                                fail = true;
                                break;
                            }
                            this.iSolution.getAssignment().assign(this.iSolution.getIteration(), val);
                        }
                        if (!fail) {
                            double after;
                            if (lazy != null) {
                                double after2 = this.iSolution.getModel().getTotalValue(this.iSolution.getAssignment());
                                if (!lazy.accept(this.iSolution.getAssignment(), (LazyNeighbour)neighbour, after2 - before)) {
                                    fail = true;
                                }
                            } else if (neighbourCheck && before + value < (after = this.iSolution.getModel().getTotalValue(this.iSolution.getAssignment())) && before < after && !ParallelSolver.this.getSolutionComparator().isBetterThanBestSolution(this.iSolution)) {
                                fail = true;
                            }
                        }
                        if (fail) {
                            for (Variable var3 : undo.keySet()) {
                                this.iSolution.getAssignment().unassign(this.iSolution.getIteration(), var3);
                            }
                            for (Value val : undo.values()) {
                                if (val == null) continue;
                                this.iSolution.getAssignment().assign(this.iSolution.getIteration(), val);
                            }
                        }
                        this.iSolution.update(time, !fail);
                        if (fail) {
                            for (SolverListener listener : ParallelSolver.this.iSolverListeners) {
                                listener.neighbourFailed(this.iSolution.getAssignment(), this.iSolution.getIteration(), neighbour);
                            }
                            continue;
                        }
                        ParallelSolver.this.onAssigned(this.iStartTime, this.iSolution);
                        if (ParallelSolver.this.iSaveBestUnassigned >= 0 && ParallelSolver.this.iSaveBestUnassigned < this.iSolution.getAssignment().nrUnassignedVariables(this.iSolution.getModel()) || !ParallelSolver.this.getSolutionComparator().isBetterThanBestSolution(this.iSolution)) continue;
                        this.iSolution.saveBest();
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
            catch (Exception ex) {
                Solver.sLogger.error(ex.getMessage(), (Throwable)ex);
                ParallelSolver.this.iProgress.fatal(this.getName() + " failed, reason:" + ex.getMessage(), ex);
            }
            Lock lock = ParallelSolver.this.currentSolution().getLock().writeLock();
            lock.lock();
            try {
                ParallelSolver.this.iNrFinished++;
            }
            finally {
                lock.unlock();
            }
        }
    }

    protected class SolverThread
    extends Thread {
        private double iStartTime;
        private int iIndex;
        private boolean iSingle;
        private Model<V, T> iModel;
        private Solution<V, T> iSolution;
        private Assignment<V, T> iAssignment;
        private BlockingQueue<Neighbour<V, T>> iQueue;

        public SolverThread(int index, BlockingQueue<Neighbour<V, T>> queue) {
            this.iIndex = index;
            this.iSingle = ParallelSolver.this.hasSingleSolution();
            this.iModel = ParallelSolver.this.iCurrentSolution.getModel();
            this.iSolution = this.iSingle || ParallelSolver.this.iCurrentSolution.getAssignment().getIndex() == index ? ParallelSolver.this.iCurrentSolution : ParallelSolver.this.createParallelSolution(this.iIndex);
            this.iAssignment = this.iSolution.getAssignment();
            this.iQueue = queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block44: {
                this.iStartTime = JProf.currentTimeSec();
                try {
                    boolean neighbourCheck = ParallelSolver.this.getProperties().getPropertyBoolean("ParallelSolver.SingleSolutionNeighbourCheck", false);
                    boolean tryLazyFirst = ParallelSolver.this.getProperties().getPropertyBoolean("ParallelSolver.SingleSolutionTryLazyFirst", false);
                    while (!ParallelSolver.this.iStop && ParallelSolver.this.getTerminationCondition().canContinue(this.iSolution)) {
                        Solution current = this.iSolution;
                        if (this.iSingle) {
                            current = new Solution(this.iModel, this.iModel.createInheritedAssignment(this.iSolution, this.iIndex), this.iSolution.getIteration(), this.iSolution.getTime());
                            current.addSolutionListener(new SolutionListener<V, T>(){

                                @Override
                                public void solutionUpdated(Solution<V, T> solution) {
                                }

                                @Override
                                public void getInfo(Solution<V, T> solution, Map<String, String> info) {
                                }

                                @Override
                                public void getInfo(Solution<V, T> solution, Map<String, String> info, Collection<V> variables) {
                                }

                                @Override
                                public void bestCleared(Solution<V, T> solution) {
                                }

                                @Override
                                public void bestSaved(Solution<V, T> solution) {
                                }

                                @Override
                                public void bestRestored(Solution<V, T> solution) {
                                    SolverThread.this.iSolution.restoreBest();
                                }
                            });
                        }
                        Neighbour neighbour = null;
                        try {
                            neighbour = ParallelSolver.this.getNeighbourSelection().selectNeighbour(current);
                        }
                        catch (Exception e) {
                            Solver.sLogger.debug("Failed to select a neighbour: " + (e.getMessage() == null ? e.getClass().getSimpleName() : e.getMessage()), (Throwable)e);
                        }
                        for (SolverListener listener : ParallelSolver.this.iSolverListeners) {
                            if (listener.neighbourSelected(this.iAssignment, this.iSolution.getIteration(), neighbour)) continue;
                            neighbour = null;
                        }
                        double time = JProf.currentTimeSec() - this.iStartTime;
                        if (neighbour == null) {
                            Solver.sLogger.debug("No neighbour selected.");
                            this.iSolution.update(time, false);
                            continue;
                        }
                        if (this.iSingle) {
                            if (this.iQueue != null) {
                                while (!this.iQueue.offer(neighbour, 1000L, TimeUnit.MILLISECONDS) && !ParallelSolver.this.iStop && ParallelSolver.this.getTerminationCondition().canContinue(this.iSolution)) {
                                }
                                continue;
                            }
                            Map assignments = null;
                            try {
                                assignments = neighbour.assignments();
                            }
                            catch (Exception e) {
                                Solver.sLogger.error("Failed to enumerate " + neighbour.getClass().getSimpleName(), (Throwable)e);
                            }
                            if (assignments == null) {
                                Solver.sLogger.debug("No assignments returned.");
                                this.iSolution.update(time, false);
                                continue;
                            }
                            if (tryLazyFirst && neighbour instanceof LazyNeighbour) {
                                LazyNeighbour lazy = (LazyNeighbour)neighbour;
                                double before = current.getModel().getTotalValue(current.getAssignment());
                                neighbour.assign(current.getAssignment(), current.getIteration());
                                double after = current.getModel().getTotalValue(current.getAssignment());
                                if (!lazy.getAcceptanceCriterion().accept(current.getAssignment(), lazy, after - before)) continue;
                            }
                            Lock lock = this.iSolution.getLock().writeLock();
                            lock.lock();
                            try {
                                LazyNeighbour.LazyNeighbourAcceptanceCriterion lazy = null;
                                double before = 0.0;
                                double value = 0.0;
                                if (neighbour instanceof LazyNeighbour) {
                                    before = this.iSolution.getModel().getTotalValue(this.iSolution.getAssignment());
                                    lazy = ((LazyNeighbour)neighbour).getAcceptanceCriterion();
                                } else if (neighbourCheck) {
                                    before = this.iSolution.getModel().getTotalValue(this.iSolution.getAssignment());
                                    value = neighbour.value(current.getAssignment());
                                }
                                HashMap undo = new HashMap();
                                Iterator i = assignments.entrySet().iterator();
                                while (i.hasNext()) {
                                    Map.Entry e = i.next();
                                    Object cur = this.iSolution.getAssignment().getValue((Variable)e.getKey());
                                    if (e.getValue() == null && cur == null) {
                                        i.remove();
                                        continue;
                                    }
                                    if (cur != null && ((Value)cur).equals(e.getValue())) {
                                        i.remove();
                                        continue;
                                    }
                                    undo.put(e.getKey(), this.iSolution.getAssignment().unassign(this.iSolution.getIteration(), (Variable)e.getKey()));
                                }
                                boolean fail = false;
                                for (Value val : assignments.values()) {
                                    if (val == null) continue;
                                    if (this.iModel.inConflict(this.iSolution.getAssignment(), val)) {
                                        fail = true;
                                        break;
                                    }
                                    this.iSolution.getAssignment().assign(this.iSolution.getIteration(), val);
                                }
                                if (!fail) {
                                    double after;
                                    if (lazy != null) {
                                        double after2 = this.iSolution.getModel().getTotalValue(this.iSolution.getAssignment());
                                        if (!lazy.accept(this.iSolution.getAssignment(), (LazyNeighbour)neighbour, after2 - before)) {
                                            fail = true;
                                        }
                                    } else if (neighbourCheck && before + value < (after = this.iSolution.getModel().getTotalValue(this.iSolution.getAssignment())) && before < after && !ParallelSolver.this.getSolutionComparator().isBetterThanBestSolution(this.iSolution)) {
                                        fail = true;
                                    }
                                }
                                if (fail) {
                                    for (Variable var : undo.keySet()) {
                                        this.iSolution.getAssignment().unassign(this.iSolution.getIteration(), var);
                                    }
                                    for (Value val : undo.values()) {
                                        if (val == null) continue;
                                        this.iSolution.getAssignment().assign(this.iSolution.getIteration(), val);
                                    }
                                }
                                this.iSolution.update(time, !fail);
                                if (fail) {
                                    for (SolverListener listener : ParallelSolver.this.iSolverListeners) {
                                        listener.neighbourFailed(current.getAssignment(), this.iSolution.getIteration(), neighbour);
                                    }
                                    continue;
                                }
                                ParallelSolver.this.onAssigned(this.iStartTime, this.iSolution);
                                if (ParallelSolver.this.iSaveBestUnassigned >= 0 && ParallelSolver.this.iSaveBestUnassigned < this.iSolution.getAssignment().nrUnassignedVariables(this.iModel) || !ParallelSolver.this.getSolutionComparator().isBetterThanBestSolution(this.iSolution)) continue;
                                this.iSolution.saveBest();
                                continue;
                            }
                            finally {
                                lock.unlock();
                                continue;
                            }
                        }
                        Lock lock = this.iSolution.getLock().writeLock();
                        lock.lock();
                        try {
                            neighbour.assign(this.iAssignment, this.iSolution.getIteration());
                            this.iSolution.update(time, ParallelSolver.this.currentSolution());
                        }
                        finally {
                            lock.unlock();
                        }
                        ParallelSolver.this.onAssigned(this.iStartTime, this.iSolution);
                        if (ParallelSolver.this.iSaveBestUnassigned >= 0 && ParallelSolver.this.iSaveBestUnassigned < this.iAssignment.nrUnassignedVariables(this.iModel)) continue;
                        this.iSolution.saveBestIfImproving(ParallelSolver.this.currentSolution(), ParallelSolver.this.getSolutionComparator());
                    }
                }
                catch (Exception ex) {
                    Solver.sLogger.error(ex.getMessage(), (Throwable)ex);
                    ParallelSolver.this.iProgress.fatal(this.getName() + " failed, reason:" + ex.getMessage(), ex);
                    if (this.iIndex != 0) break block44;
                    ParallelSolver.this.iProgress.setStatus("Solver failed.");
                    ParallelSolver.this.onFailure();
                }
            }
            Lock lock = ParallelSolver.this.currentSolution().getLock().writeLock();
            lock.lock();
            try {
                ParallelSolver.this.iNrFinished++;
            }
            finally {
                lock.unlock();
            }
        }
    }

    protected class SynchronizationThread
    extends Thread {
        private int iNrSolvers;
        private List<SolverThread> iSolvers = new ArrayList<SolverThread>();
        private AssignmentThread iAssignmentThread = null;

        SynchronizationThread(int nrSolvers) {
            this.iNrSolvers = nrSolvers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ParallelSolver.this.iStop = false;
                ParallelSolver.this.iNrFinished = 0;
                this.setName("SolverSync");
                ParallelSolver.this.iProgress = Progress.getInstance(ParallelSolver.this.currentSolution().getModel());
                ParallelSolver.this.iProgress.setStatus("Solving problem ...");
                ParallelSolver.this.iProgress.setPhase("Initializing solver");
                ParallelSolver.this.initSolver();
                ParallelSolver.this.onStart();
                if (ParallelSolver.this.isUpdateProgress()) {
                    if (ParallelSolver.this.currentSolution().getBestInfo() == null) {
                        ParallelSolver.this.iProgress.setPhase("Searching for initial solution ...", ParallelSolver.this.currentSolution().getModel().variables().size());
                    } else {
                        ParallelSolver.this.iProgress.setPhase("Improving found solution ...");
                    }
                }
                Solver.sLogger.info("Initial solution:" + ToolBox.dict2string(ParallelSolver.this.currentSolution().getInfo(), 2));
                if (!(ParallelSolver.this.iSaveBestUnassigned >= 0 && ParallelSolver.this.iSaveBestUnassigned < ParallelSolver.this.currentSolution().getAssignment().nrUnassignedVariables(ParallelSolver.this.currentSolution().getModel()) || ParallelSolver.this.currentSolution().getBestInfo() != null && !ParallelSolver.this.getSolutionComparator().isBetterThanBestSolution(ParallelSolver.this.currentSolution()))) {
                    if (ParallelSolver.this.currentSolution().getAssignment().nrAssignedVariables() == ParallelSolver.this.currentSolution().getModel().variables().size()) {
                        Solver.sLogger.info("Complete solution " + ToolBox.dict2string(ParallelSolver.this.currentSolution().getInfo(), 1) + " was found.");
                    }
                    ParallelSolver.this.currentSolution().saveBest();
                }
                if (ParallelSolver.this.currentSolution().getModel().variables().isEmpty()) {
                    ParallelSolver.this.iProgress.error("Nothing to solve.");
                    ParallelSolver.this.iStop = true;
                }
                ArrayBlockingQueue queue = null;
                if (ParallelSolver.this.hasSingleSolution() && this.iNrSolvers > 1 && ParallelSolver.this.getProperties().getPropertyBoolean("ParallelSolver.SingleSolutionQueue", false)) {
                    queue = new ArrayBlockingQueue(2 * this.iNrSolvers);
                }
                if (!ParallelSolver.this.iStop) {
                    for (int i = 1; i <= this.iNrSolvers; ++i) {
                        SolverThread thread = new SolverThread(i, queue);
                        thread.setPriority(Solver.THREAD_PRIORITY);
                        thread.setName("Solver-" + i);
                        thread.start();
                        this.iSolvers.add(thread);
                    }
                }
                if (queue != null) {
                    this.iAssignmentThread = new AssignmentThread(queue);
                    this.iAssignmentThread.start();
                }
                int timeout = ParallelSolver.this.getProperties().getPropertyInt("Termination.TimeOut", 1800);
                double start = JProf.currentTimeSec();
                while (!ParallelSolver.this.iStop && ParallelSolver.this.iNrFinished < this.iNrSolvers) {
                    try {
                        Thread.sleep(1000L);
                        double time = JProf.currentTimeSec() - start;
                        if (!ParallelSolver.this.isUpdateProgress()) continue;
                        if (ParallelSolver.this.currentSolution().getBestInfo() != null && ParallelSolver.this.currentSolution().getModel().getBestUnassignedVariables() == 0) {
                            if (!"Improving found solution ...".equals(ParallelSolver.this.iProgress.getPhase())) {
                                ParallelSolver.this.iProgress.setPhase("Improving found solution ...");
                            }
                            ParallelSolver.this.iProgress.setProgress(Math.min(100, (int)Math.round(100.0 * time / (double)timeout)));
                            continue;
                        }
                        if (ParallelSolver.this.currentSolution().getModel().getBestUnassignedVariables() > 0 && (long)(ParallelSolver.this.currentSolution().getModel().countVariables() - ParallelSolver.this.currentSolution().getModel().getBestUnassignedVariables()) > ParallelSolver.this.iProgress.getProgress()) {
                            ParallelSolver.this.iProgress.setProgress(ParallelSolver.this.currentSolution().getModel().countVariables() - ParallelSolver.this.currentSolution().getModel().getBestUnassignedVariables());
                            continue;
                        }
                        if ((long)this.iSolvers.get(0).iAssignment.nrAssignedVariables() <= ParallelSolver.this.iProgress.getProgress()) continue;
                        ParallelSolver.this.iProgress.setProgress(this.iSolvers.get(0).iAssignment.nrAssignedVariables());
                    }
                    catch (InterruptedException time) {}
                }
                boolean stop = ParallelSolver.this.iStop;
                ParallelSolver.this.iStop = true;
                for (SolverThread thread : this.iSolvers) {
                    try {
                        thread.join();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.iAssignmentThread != null) {
                    try {
                        this.iAssignmentThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                ParallelSolver.this.iLastSolution = ParallelSolver.this.iCurrentSolution;
                ParallelSolver.this.iProgress.setPhase("Done", 1L);
                ParallelSolver.this.iProgress.incProgress();
                ParallelSolver.this.iStop = stop;
                if (ParallelSolver.this.iStop) {
                    Solver.sLogger.debug("Solver stopped.");
                    ParallelSolver.this.iProgress.setStatus("Solver stopped.");
                    ParallelSolver.this.onStop();
                } else {
                    Solver.sLogger.debug("Solver done.");
                    ParallelSolver.this.iProgress.setStatus("Solver done.");
                    ParallelSolver.this.onFinish();
                }
            }
            catch (Exception ex) {
                Solver.sLogger.error(ex.getMessage(), (Throwable)ex);
                ParallelSolver.this.iProgress.fatal("Solver synchronization failed, reason:" + ex.getMessage(), ex);
                ParallelSolver.this.iProgress.setStatus("Solver failed.");
                ParallelSolver.this.onFailure();
            }
            finally {
                ParallelSolver.this.iSynchronizationThread = null;
            }
        }
    }
}

