/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.cellview.client;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.HasCell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.builder.shared.HtmlTableSectionBuilder;
import com.google.gwt.dom.builder.shared.TableSectionBuilder;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.TableCellElement;
import com.google.gwt.dom.client.TableElement;
import com.google.gwt.dom.client.TableRowElement;
import com.google.gwt.dom.client.TableSectionElement;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.safehtml.client.SafeHtmlTemplates;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.uibinder.client.UiChild;
import com.google.gwt.user.cellview.client.AbstractHasData;
import com.google.gwt.user.cellview.client.CellBasedWidgetImpl;
import com.google.gwt.user.cellview.client.CellTableBuilder;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.user.cellview.client.DefaultCellTableBuilder;
import com.google.gwt.user.cellview.client.DefaultHeaderOrFooterBuilder;
import com.google.gwt.user.cellview.client.FooterBuilder;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.HeaderBuilder;
import com.google.gwt.user.cellview.client.RowHoverEvent;
import com.google.gwt.user.cellview.client.RowStyles;
import com.google.gwt.user.cellview.client.SafeHtmlHeader;
import com.google.gwt.user.cellview.client.TextHeader;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.SelectionModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class AbstractCellTable<T>
extends AbstractHasData<T> {
    private static final String MALFORMED_HTML_SECTION = "Malformed HTML: The table section returned by HeaderBuilder or FooterBuilder must use the tag name thead or tfoot, as appropriate, and cannot contain any attributes or styles.";
    private static Impl TABLE_IMPL;
    private static Template template;
    private boolean cellIsEditing;
    private final List<Column<T, ?>> columns = new ArrayList();
    private final Map<Column<T, ?>, String> columnWidths = new HashMap();
    private boolean columnWidthsDirty;
    private final Map<Integer, String> columnWidthsByIndex = new HashMap<Integer, String>();
    private int maxColumnIndex = -1;
    private boolean dependsOnSelection;
    private Widget emptyTableWidget;
    private FooterBuilder<T> footerBuilder;
    private boolean footerRefreshDisabled;
    private final List<Header<?>> footers = new ArrayList();
    private boolean handlesSelection;
    private HeaderBuilder<T> headerBuilder;
    private boolean headerRefreshDisabled;
    private final List<Header<?>> headers = new ArrayList();
    private boolean headersDirty;
    private TableRowElement hoveringRow;
    private boolean isInteractive;
    private int keyboardSelectedColumn = 0;
    private int keyboardSelectedSubrow = 0;
    private int lastKeyboardSelectedSubrow = 0;
    private Widget loadingIndicator;
    private boolean legacyRenderRowValues = true;
    private final Resources resources;
    private RowStyles<T> rowStyles;
    private final ColumnSortList sortList = new ColumnSortList(new ColumnSortList.Delegate(){

        @Override
        public void onModification() {
            if (!AbstractCellTable.this.updatingSortList) {
                AbstractCellTable.this.createHeaders(false);
            }
        }
    });
    private final Style style;
    private CellTableBuilder<T> tableBuilder;
    private boolean updatingSortList;
    private boolean skipRowHoverCheck;
    private boolean skipRowHoverFloatElementCheck;
    private boolean skipRowHoverStyleUpdate;

    private static boolean isColumnInteractive(HasCell<?, ?> column) {
        Set<String> consumedEvents = column.getCell().getConsumedEvents();
        return consumedEvents != null && consumedEvents.size() > 0;
    }

    private static SafeHtml tableSectionToSafeHtml(TableSectionBuilder section, String tag) {
        if (!(section instanceof HtmlTableSectionBuilder)) {
            throw new IllegalArgumentException("Only HtmlTableSectionBuilder is supported at this time");
        }
        HtmlTableSectionBuilder htmlSection = (HtmlTableSectionBuilder)section;
        String rawHtml = htmlSection.asSafeHtml().asString();
        assert (tag.length() == 5) : "Unrecognized tag: " + tag;
        assert (rawHtml.startsWith("<" + tag + ">")) : "Malformed HTML: The table section returned by HeaderBuilder or FooterBuilder must use the tag name thead or tfoot, as appropriate, and cannot contain any attributes or styles.";
        assert (rawHtml.endsWith("</" + tag + ">")) : "Malformed HTML: The table section returned by HeaderBuilder or FooterBuilder must use the tag name thead or tfoot, as appropriate, and cannot contain any attributes or styles.";
        rawHtml = rawHtml.substring(7, rawHtml.length() - 8);
        return SafeHtmlUtils.fromTrustedString(rawHtml);
    }

    public AbstractCellTable(Element elem, int pageSize, Resources resources, ProvidesKey<T> keyProvider) {
        super(elem, pageSize, keyProvider);
        this.resources = resources;
        this.style = resources.style();
        this.init();
    }

    public AbstractCellTable(Widget widget, int pageSize, Resources resources, ProvidesKey<T> keyProvider) {
        super(widget, pageSize, keyProvider);
        this.resources = resources;
        this.style = resources.style();
        this.init();
    }

    public void addColumn(Column<T, ?> col) {
        this.insertColumn(this.getColumnCount(), col);
    }

    public void addColumn(Column<T, ?> col, Header<?> header) {
        this.insertColumn(this.getColumnCount(), col, header);
    }

    public void addColumn(Column<T, ?> col, Header<?> header, Header<?> footer) {
        this.insertColumn(this.getColumnCount(), col, header, footer);
    }

    public void addColumn(Column<T, ?> col, String headerString) {
        this.insertColumn(this.getColumnCount(), col, headerString);
    }

    public void addColumn(Column<T, ?> col, SafeHtml headerHtml) {
        this.insertColumn(this.getColumnCount(), col, headerHtml);
    }

    public void addColumn(Column<T, ?> col, String headerString, String footerString) {
        this.insertColumn(this.getColumnCount(), col, headerString, footerString);
    }

    public void addColumn(Column<T, ?> col, SafeHtml headerHtml, SafeHtml footerHtml) {
        this.insertColumn(this.getColumnCount(), col, headerHtml, footerHtml);
    }

    public HandlerRegistration addColumnSortHandler(ColumnSortEvent.Handler handler) {
        return this.addHandler(handler, ColumnSortEvent.getType());
    }

    public abstract void addColumnStyleName(int var1, String var2);

    public HandlerRegistration addRowHoverHandler(RowHoverEvent.Handler handler) {
        return this.addHandler(handler, RowHoverEvent.getType());
    }

    public void clearColumnWidth(Column<T, ?> column) {
        this.columnWidths.remove(column);
        this.updateColumnWidthImpl(column, null);
    }

    public void clearColumnWidth(Integer column) {
        this.columnWidthsByIndex.remove(column);
        if (column >= this.maxColumnIndex) {
            this.maxColumnIndex = -1;
            for (Integer index : this.columnWidthsByIndex.keySet()) {
                this.maxColumnIndex = Math.max(this.maxColumnIndex, index);
            }
        }
        if (column < this.getRealColumnCount()) {
            this.doSetColumnWidth(column, null);
        }
    }

    public void flush() {
        this.getPresenter().flush();
    }

    public Column<T, ?> getColumn(int col) {
        this.checkColumnBounds(col);
        return this.columns.get(col);
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public int getColumnIndex(Column<T, ?> column) {
        return this.columns.indexOf(column);
    }

    public ColumnSortList getColumnSortList() {
        return this.sortList;
    }

    public String getColumnWidth(Column<T, ?> column) {
        return this.columnWidths.get(column);
    }

    public Widget getEmptyTableWidget() {
        return this.emptyTableWidget;
    }

    public Header<?> getFooter(int index) {
        return this.footers.get(index);
    }

    public FooterBuilder<T> getFooterBuilder() {
        return this.footerBuilder;
    }

    public Header<?> getHeader(int index) {
        return this.headers.get(index);
    }

    public HeaderBuilder<T> getHeaderBuilder() {
        return this.headerBuilder;
    }

    public int getKeyboardSelectedColumn() {
        return HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.DISABLED == this.getKeyboardSelectionPolicy() ? -1 : this.keyboardSelectedColumn;
    }

    public int getKeyboardSelectedSubRow() {
        return HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.DISABLED == this.getKeyboardSelectionPolicy() ? -1 : this.keyboardSelectedSubrow;
    }

    public Widget getLoadingIndicator() {
        return this.loadingIndicator;
    }

    public Resources getResources() {
        return this.resources;
    }

    public TableRowElement getRowElement(int row) {
        this.flush();
        return this.getChildElement(row);
    }

    public RowStyles<T> getRowStyles() {
        return this.rowStyles;
    }

    public void insertColumn(int beforeIndex, Column<T, ?> col) {
        this.insertColumn(beforeIndex, col, (Header)null, (Header)null);
    }

    public void insertColumn(int beforeIndex, Column<T, ?> col, Header<?> header) {
        this.insertColumn(beforeIndex, col, header, null);
    }

    public void insertColumn(int beforeIndex, Column<T, ?> col, Header<?> header, Header<?> footer) {
        Set<String> footerEvents;
        Set<String> headerEvents;
        if (beforeIndex != this.getColumnCount()) {
            this.checkColumnBounds(beforeIndex);
        }
        this.headers.add(beforeIndex, header);
        this.footers.add(beforeIndex, footer);
        this.columns.add(beforeIndex, col);
        if (beforeIndex <= this.keyboardSelectedColumn) {
            this.keyboardSelectedColumn = Math.min(this.keyboardSelectedColumn + 1, this.columns.size() - 1);
        }
        if (AbstractCellTable.isColumnInteractive(col) && (this.keyboardSelectedColumn >= this.columns.size() || !AbstractCellTable.isColumnInteractive((HasCell)this.columns.get(this.keyboardSelectedColumn)))) {
            this.keyboardSelectedColumn = beforeIndex;
        }
        HashSet<String> consumedEvents = new HashSet<String>();
        Set<String> cellEvents = col.getCell().getConsumedEvents();
        if (cellEvents != null) {
            consumedEvents.addAll(cellEvents);
        }
        if (header != null && (headerEvents = header.getCell().getConsumedEvents()) != null) {
            consumedEvents.addAll(headerEvents);
        }
        if (footer != null && (footerEvents = footer.getCell().getConsumedEvents()) != null) {
            consumedEvents.addAll(footerEvents);
        }
        CellBasedWidgetImpl.get().sinkEvents(this, consumedEvents);
        this.headersDirty = true;
        this.refreshColumnsAndRedraw();
    }

    public void insertColumn(int beforeIndex, Column<T, ?> col, String headerString) {
        this.insertColumn(beforeIndex, col, new TextHeader(headerString), null);
    }

    public void insertColumn(int beforeIndex, Column<T, ?> col, SafeHtml headerHtml) {
        this.insertColumn(beforeIndex, col, new SafeHtmlHeader(headerHtml), null);
    }

    public void insertColumn(int beforeIndex, Column<T, ?> col, String headerString, String footerString) {
        this.insertColumn(beforeIndex, col, new TextHeader(headerString), new TextHeader(footerString));
    }

    public void insertColumn(int beforeIndex, Column<T, ?> col, SafeHtml headerHtml, SafeHtml footerHtml) {
        this.insertColumn(beforeIndex, col, new SafeHtmlHeader(headerHtml), new SafeHtmlHeader(footerHtml));
    }

    public boolean isAutoFooterRefreshDisabled() {
        return this.footerRefreshDisabled;
    }

    public boolean isAutoHeaderRefreshDisabled() {
        return this.headerRefreshDisabled;
    }

    public boolean isSkipRowHoverCheck() {
        return this.skipRowHoverCheck;
    }

    public boolean isSkipRowHoverFloatElementCheck() {
        return this.skipRowHoverFloatElementCheck;
    }

    public boolean isSkipRowHoverStyleUpdate() {
        return this.skipRowHoverStyleUpdate;
    }

    public void redrawFooters() {
        this.createHeaders(true);
    }

    public void redrawHeaders() {
        this.createHeaders(false);
    }

    public void removeColumn(Column<T, ?> col) {
        int index = this.columns.indexOf(col);
        if (index < 0) {
            throw new IllegalArgumentException("The specified column is not part of this table.");
        }
        this.removeColumn(index);
    }

    public void removeColumn(int index) {
        if (index < 0 || index >= this.columns.size()) {
            throw new IndexOutOfBoundsException("The specified column index is out of bounds.");
        }
        this.columns.remove(index);
        this.headers.remove(index);
        this.footers.remove(index);
        if (index <= this.keyboardSelectedColumn && this.keyboardSelectedColumn > 0) {
            --this.keyboardSelectedColumn;
        }
        this.headersDirty = true;
        this.refreshColumnsAndRedraw();
    }

    public abstract void removeColumnStyleName(int var1, String var2);

    public void setAutoFooterRefreshDisabled(boolean disabled) {
        this.footerRefreshDisabled = disabled;
    }

    public void setAutoHeaderRefreshDisabled(boolean disabled) {
        this.headerRefreshDisabled = disabled;
    }

    public void setColumnWidth(Column<T, ?> column, String width) {
        this.columnWidths.put(column, width);
        this.updateColumnWidthImpl(column, width);
    }

    public void setColumnWidth(Column<T, ?> column, double width, Style.Unit unit) {
        this.setColumnWidth(column, width + unit.getType());
    }

    public void setColumnWidth(int column, double width, Style.Unit unit) {
        this.setColumnWidth(column, width + unit.getType());
    }

    public void setColumnWidth(int column, String width) {
        this.columnWidthsByIndex.put(column, width);
        this.maxColumnIndex = Math.max(this.maxColumnIndex, column);
        if (column < this.getRealColumnCount()) {
            this.doSetColumnWidth(column, width);
        }
    }

    @UiChild(tagname="emptyTableWidget", limit=1)
    public void setEmptyTableWidget(Widget widget) {
        this.emptyTableWidget = widget;
    }

    public void setFooterBuilder(FooterBuilder<T> builder) {
        assert (builder != null) : "builder cannot be null";
        this.footerBuilder = builder;
        this.redrawFooters();
    }

    public void setHeaderBuilder(HeaderBuilder<T> builder) {
        assert (builder != null) : "builder cannot be null";
        this.headerBuilder = builder;
        this.redrawHeaders();
    }

    public final void setKeyboardSelectedColumn(int column) {
        this.setKeyboardSelectedColumn(column, true);
    }

    public void setKeyboardSelectedColumn(int column, boolean stealFocus) {
        assert (column >= 0) : "Column must be zero or greater";
        if (HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.DISABLED == this.getKeyboardSelectionPolicy()) {
            return;
        }
        this.keyboardSelectedColumn = column;
        this.setKeyboardSelectedRow(this.getKeyboardSelectedRow(), this.keyboardSelectedSubrow, stealFocus);
    }

    @Override
    public void setKeyboardSelectedRow(int row, boolean stealFocus) {
        this.setKeyboardSelectedRow(row, 0, stealFocus);
    }

    public void setKeyboardSelectedRow(int row, int subrow, boolean stealFocus) {
        this.keyboardSelectedSubrow = subrow;
        super.setKeyboardSelectedRow(row, stealFocus);
    }

    @UiChild(tagname="loadingIndicator", limit=1)
    public void setLoadingIndicator(Widget widget) {
        this.loadingIndicator = widget;
    }

    public void setRowStyles(RowStyles<T> rowStyles) {
        this.rowStyles = rowStyles;
    }

    public void setSkipRowHoverCheck(boolean skipRowHoverCheck) {
        this.skipRowHoverCheck = skipRowHoverCheck;
    }

    public void setSkipRowHoverFloatElementCheck(boolean skipRowHoverFloatElementCheck) {
        this.skipRowHoverFloatElementCheck = skipRowHoverFloatElementCheck;
    }

    public void setSkipRowHoverStyleUpdate(boolean skipRowHoverStyleUpdate) {
        this.skipRowHoverStyleUpdate = skipRowHoverStyleUpdate;
    }

    public void setTableBuilder(CellTableBuilder<T> tableBuilder) {
        assert (tableBuilder != null) : "tableBuilder cannot be null";
        this.tableBuilder = tableBuilder;
        this.redraw();
    }

    @Override
    protected Element convertToElements(SafeHtml html) {
        return TABLE_IMPL.convertToSectionElement(this, "tbody", html);
    }

    @Override
    protected boolean dependsOnSelection() {
        return this.dependsOnSelection;
    }

    protected abstract void doSetColumnWidth(int var1, String var2);

    protected abstract void doSetHeaderVisible(boolean var1, boolean var2);

    @Override
    protected Element getChildContainer() {
        return this.getTableBodyElement();
    }

    @Override
    protected TableRowElement getChildElement(int row) {
        return this.getSubRowElement(row + this.getPageStart(), 0);
    }

    @Override
    protected Element getKeyboardSelectedElement() {
        return this.getKeyboardSelectedElement(this.getKeyboardSelectedTableCellElement());
    }

    protected int getRealColumnCount() {
        return Math.max(this.getColumnCount(), this.maxColumnIndex + 1);
    }

    protected abstract TableSectionElement getTableBodyElement();

    protected abstract TableSectionElement getTableFootElement();

    protected abstract TableSectionElement getTableHeadElement();

    @Override
    protected boolean isKeyboardNavigationSuppressed() {
        return this.cellIsEditing;
    }

    @Override
    protected void onBlur() {
        TableCellElement td = this.getKeyboardSelectedTableCellElement();
        if (td != null) {
            TableRowElement tr = (TableRowElement)td.getParentElement().cast();
            td.removeClassName(this.style.keyboardSelectedCell());
            this.setRowStyleName(tr, this.style.keyboardSelectedRow(), this.style.keyboardSelectedRowCell(), false);
        }
    }

    @Override
    protected void onBrowserEvent2(Event event) {
        EventTarget eventTarget = event.getEventTarget();
        if (!Element.is(eventTarget)) {
            return;
        }
        Element target = (Element)event.getEventTarget().cast();
        TableSectionElement tbody = this.getTableBodyElement();
        TableSectionElement tfoot = this.getTableFootElement();
        TableSectionElement thead = this.getTableHeadElement();
        TableSectionElement targetTableSection = null;
        Element targetTableCell = null;
        Element cellParent = null;
        Element headerParent = null;
        Element headerColumnParent = null;
        Element footerParent = null;
        Element footerColumnParent = null;
        JavaScriptObject maybeTableCell = null;
        Element cur = target;
        if ("td".equalsIgnoreCase(cur.getTagName()) && this.tableBuilder.isColumn(cur.getFirstChildElement())) {
            cur = cur.getFirstChildElement();
        }
        while (cur != null && targetTableSection == null) {
            String tagName;
            if (cur == tbody || cur == tfoot || cur == thead) {
                targetTableSection = (TableSectionElement)cur.cast();
                if (maybeTableCell != null) {
                    targetTableCell = (TableCellElement)maybeTableCell.cast();
                    break;
                }
            }
            if ("td".equalsIgnoreCase(tagName = cur.getTagName()) || "th".equalsIgnoreCase(tagName)) {
                maybeTableCell = cur;
            }
            if (cellParent == null && this.tableBuilder.isColumn(cur)) {
                cellParent = cur;
            }
            if (headerParent == null && this.headerBuilder.isHeader(cur)) {
                headerParent = cur;
            }
            if (footerParent == null && this.footerBuilder.isHeader(cur)) {
                footerParent = cur;
            }
            if (headerColumnParent == null && this.headerBuilder.isColumn(cur)) {
                headerColumnParent = cur;
            }
            if (footerColumnParent == null && this.footerBuilder.isColumn(cur)) {
                footerColumnParent = cur;
            }
            cur = cur.getParentElement();
        }
        if (targetTableCell == null) {
            return;
        }
        if (this.legacyRenderRowValues) {
            cellParent = targetTableCell.getFirstChildElement();
        }
        TableRowElement targetTableRow = (TableRowElement)targetTableCell.getParentElement().cast();
        String eventType = event.getType();
        boolean isSelect = "click".equals(eventType) || "keydown".equals(eventType) && event.getKeyCode() == 13;
        int col = ((TableCellElement)targetTableCell).getCellIndex();
        if (targetTableSection == thead || targetTableSection == tfoot) {
            boolean isHeader = targetTableSection == thead;
            headerParent = isHeader ? headerParent : footerParent;
            Element columnParent = isHeader ? headerColumnParent : footerColumnParent;
            boolean shouldSortColumn = true;
            if (headerParent != null) {
                Header<?> header;
                Header<?> header2 = header = isHeader ? this.headerBuilder.getHeader(headerParent) : this.footerBuilder.getHeader(footerParent);
                if (header != null) {
                    int headerIndex = isHeader ? this.headerBuilder.getRowIndex(targetTableRow) : this.footerBuilder.getRowIndex(targetTableRow);
                    Cell.Context context = new Cell.Context(headerIndex, col, header.getKey());
                    if (this.cellConsumesEventType(header.getCell(), eventType)) {
                        header.onBrowserEvent(context, headerParent, event);
                    }
                    if (isSelect) {
                        shouldSortColumn = header.onPreviewColumnSortEvent(context, headerParent, event);
                    }
                }
            }
            if (isSelect && shouldSortColumn && columnParent != null) {
                Column<T, ?> column;
                Column<T, ?> column2 = column = isHeader ? this.headerBuilder.getColumn(columnParent) : this.footerBuilder.getColumn(columnParent);
                if (column != null && column.isSortable()) {
                    this.headersDirty = true;
                    this.updatingSortList = true;
                    this.sortList.push(column);
                    this.updatingSortList = false;
                    ColumnSortEvent.fire(this, this.sortList);
                }
            }
        } else if (targetTableSection == tbody) {
            HasCell<T, ?> column;
            int absRow = this.tableBuilder.getRowValueIndex(targetTableRow);
            int relRow = absRow - this.getPageStart();
            int subrow = this.tableBuilder.getSubrowValueIndex(targetTableRow);
            if (!this.skipRowHoverCheck) {
                boolean isRowChange;
                boolean bl = isRowChange = this.hoveringRow != targetTableRow;
                if ("mouseover".equals(eventType)) {
                    if (this.hoveringRow != null && this.getTableBodyElement().isOrHasChild(this.hoveringRow)) {
                        this.setRowHover(this.hoveringRow, event, false, isRowChange);
                    }
                    this.hoveringRow = targetTableRow;
                    this.setRowHover(this.hoveringRow, event, true, isRowChange);
                } else if ("mouseout".equals(eventType) && this.hoveringRow != null) {
                    boolean unhover = true;
                    if (!this.skipRowHoverFloatElementCheck) {
                        int clientX = event.getClientX() + Window.getScrollLeft();
                        int clientY = event.getClientY() + Window.getScrollTop();
                        int rowLeft = this.hoveringRow.getAbsoluteLeft();
                        int rowTop = this.hoveringRow.getAbsoluteTop();
                        int rowWidth = this.hoveringRow.getOffsetWidth();
                        int rowHeight = this.hoveringRow.getOffsetHeight();
                        int rowBottom = rowTop + rowHeight;
                        int rowRight = rowLeft + rowWidth;
                        boolean bl2 = unhover = clientX < rowLeft || clientX > rowRight || clientY < rowTop || clientY > rowBottom;
                    }
                    if (unhover) {
                        this.setRowHover(this.hoveringRow, event, false, isRowChange);
                        this.hoveringRow = null;
                    }
                }
            }
            if (!this.isRowWithinBounds(relRow)) {
                return;
            }
            boolean isSelectionHandled = this.handlesSelection || HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.BOUND_TO_SELECTION == this.getKeyboardSelectionPolicy();
            Object value = this.getVisibleItem(relRow);
            Cell.Context context = new Cell.Context(absRow, col, this.getValueKey(value), subrow);
            CellPreviewEvent previewEvent = CellPreviewEvent.fire(this, event, this, context, value, this.cellIsEditing, isSelectionHandled);
            if (cellParent != null && !previewEvent.isCanceled() && (column = this.legacyRenderRowValues ? (HasCell<T, ?>)this.columns.get(col) : this.tableBuilder.getColumn(context, value, cellParent)) != null) {
                this.fireEventToCell(event, eventType, cellParent, value, context, column);
            }
        }
    }

    @Override
    protected void onFocus() {
        TableCellElement td = this.getKeyboardSelectedTableCellElement();
        if (td != null) {
            TableRowElement tr = (TableRowElement)td.getParentElement().cast();
            td.addClassName(this.style.keyboardSelectedCell());
            this.setRowStyleName(tr, this.style.keyboardSelectedRow(), this.style.keyboardSelectedRowCell(), true);
        }
    }

    protected void refreshColumnWidths() {
        int columnCount = this.getRealColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            this.doSetColumnWidth(i, this.getColumnWidth(i));
        }
    }

    @Override
    @Deprecated
    protected void renderRowValues(SafeHtmlBuilder sb, List<T> values, int start, SelectionModel<? super T> selectionModel) {
        this.legacyRenderRowValues = false;
    }

    @Deprecated
    protected final void renderRowValuesLegacy(SafeHtmlBuilder sb, List<T> values, int start, SelectionModel<? super T> selectionModel) {
        int keyboardSelectedRow = this.getKeyboardSelectedRow() + this.getPageStart();
        String evenRowStyle = this.style.evenRow();
        String oddRowStyle = this.style.oddRow();
        String cellStyle = this.style.cell();
        String evenCellStyle = " " + this.style.evenRowCell();
        String oddCellStyle = " " + this.style.oddRowCell();
        String firstColumnStyle = " " + this.style.firstColumn();
        String lastColumnStyle = " " + this.style.lastColumn();
        String selectedRowStyle = " " + this.style.selectedRow();
        String selectedCellStyle = " " + this.style.selectedRowCell();
        int columnCount = this.columns.size();
        int length = values.size();
        int end = start + length;
        for (int i = start; i < end; ++i) {
            String extraRowStyles;
            String trClasses;
            T value = values.get(i - start);
            boolean isSelected = selectionModel == null || value == null ? false : selectionModel.isSelected(value);
            boolean isEven = i % 2 == 0;
            String string = trClasses = isEven ? evenRowStyle : oddRowStyle;
            if (isSelected) {
                trClasses = trClasses + selectedRowStyle;
            }
            if (this.rowStyles != null && (extraRowStyles = this.rowStyles.getStyleNames(value, i)) != null) {
                trClasses = trClasses + " ";
                trClasses = trClasses + extraRowStyles;
            }
            SafeHtmlBuilder trBuilder = new SafeHtmlBuilder();
            int curColumn = 0;
            for (Column<T, ?> column : this.columns) {
                Cell.Context context;
                String cellStyles;
                String tdClasses = cellStyle;
                tdClasses = tdClasses + (isEven ? evenCellStyle : oddCellStyle);
                if (curColumn == 0) {
                    tdClasses = tdClasses + firstColumnStyle;
                }
                if (isSelected) {
                    tdClasses = tdClasses + selectedCellStyle;
                }
                if (curColumn == columnCount - 1) {
                    tdClasses = tdClasses + lastColumnStyle;
                }
                if ((cellStyles = column.getCellStyleNames(context = new Cell.Context(i, curColumn, this.getValueKey(value)), value)) != null) {
                    tdClasses = tdClasses + " " + cellStyles;
                }
                SafeHtmlBuilder cellBuilder = new SafeHtmlBuilder();
                if (value != null) {
                    column.render(context, value, cellBuilder);
                }
                SafeHtml contents = SafeHtmlUtils.EMPTY_SAFE_HTML;
                contents = template.div(cellBuilder.toSafeHtml());
                HasHorizontalAlignment.HorizontalAlignmentConstant hAlign = column.getHorizontalAlignment();
                HasVerticalAlignment.VerticalAlignmentConstant vAlign = column.getVerticalAlignment();
                if (hAlign != null && vAlign != null) {
                    trBuilder.append(template.tdBothAlign(tdClasses, hAlign.getTextAlignString(), vAlign.getVerticalAlignString(), contents));
                } else if (hAlign != null) {
                    trBuilder.append(template.tdHorizontalAlign(tdClasses, hAlign.getTextAlignString(), contents));
                } else if (vAlign != null) {
                    trBuilder.append(template.tdVerticalAlign(tdClasses, vAlign.getVerticalAlignString(), contents));
                } else {
                    trBuilder.append(template.td(tdClasses, contents));
                }
                ++curColumn;
            }
            sb.append(template.tr(trClasses, trBuilder.toSafeHtml()));
        }
    }

    @Override
    protected void replaceAllChildren(List<T> values, SafeHtml html) {
        this.refreshHeadersAndColumnsImpl();
        if (html == null || !this.legacyRenderRowValues) {
            html = this.buildRowValues(values, this.getPageStart(), true);
        }
        TABLE_IMPL.replaceAllRows(this, this.getTableBodyElement(), CellBasedWidgetImpl.get().processHtml(html));
    }

    @Override
    protected void replaceChildren(List<T> values, int start, SafeHtml html) {
        this.refreshHeadersAndColumnsImpl();
        if (html == null || !this.legacyRenderRowValues) {
            html = this.buildRowValues(values, this.getPageStart() + start, false);
        }
        TABLE_IMPL.replaceChildren(this, this.getTableBodyElement(), CellBasedWidgetImpl.get().processHtml(html), start, values.size());
    }

    @Override
    protected boolean resetFocusOnCell() {
        Element elem = this.getKeyboardSelectedElement();
        if (elem == null) {
            return false;
        }
        int row = this.getKeyboardSelectedRow();
        int col = this.getKeyboardSelectedColumn();
        Object value = this.getVisibleItem(row);
        Object key = this.getValueKey(value);
        Cell.Context context = new Cell.Context(row + this.getPageStart(), col, key);
        HasCell<T, ?> column = this.tableBuilder.getColumn(context, value, elem);
        if (column == null) {
            return false;
        }
        this.resetFocusOnCellImpl(context, value, column, elem);
        return false;
    }

    @Override
    protected void setKeyboardSelected(int index, boolean selected, boolean stealFocus) {
        TableRowElement tr;
        if (HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.DISABLED == this.getKeyboardSelectionPolicy() || !this.isRowWithinBounds(index)) {
            return;
        }
        int subrow = this.lastKeyboardSelectedSubrow;
        if (selected) {
            subrow = this.keyboardSelectedSubrow;
            this.lastKeyboardSelectedSubrow = this.keyboardSelectedSubrow;
        }
        if ((tr = this.getSubRowElement(index + this.getPageStart(), subrow)) == null) {
            return;
        }
        String cellStyle = this.style.keyboardSelectedCell();
        boolean updatedSelection = !selected || this.isFocused || stealFocus;
        this.setRowStyleName(tr, this.style.keyboardSelectedRow(), this.style.keyboardSelectedRowCell(), selected);
        NodeList<TableCellElement> cells = tr.getCells();
        int keyboardColumn = Math.min(this.getKeyboardSelectedColumn(), cells.getLength() - 1);
        for (int i = 0; i < cells.getLength(); ++i) {
            TableCellElement td = cells.getItem(i);
            boolean isKeyboardSelected = i == keyboardColumn;
            AbstractCellTable.setStyleName(td, cellStyle, updatedSelection && selected && isKeyboardSelected);
            final Element focusable = this.getKeyboardSelectedElement(td);
            this.setFocusable(focusable, selected && isKeyboardSelected);
            if (!selected || !stealFocus || this.cellIsEditing || !isKeyboardSelected) continue;
            CellBasedWidgetImpl.get().resetFocus(new Scheduler.ScheduledCommand(){
                final /* synthetic */ AbstractCellTable this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void execute() {
                    focusable.focus();
                }
            });
        }
    }

    String getColumnWidth(int columnIndex) {
        String width = null;
        if (this.columns.size() > columnIndex) {
            width = this.columnWidths.get(this.columns.get(columnIndex));
        }
        if (width == null) {
            width = this.columnWidthsByIndex.get(columnIndex);
        }
        return width;
    }

    protected TableRowElement getSubRowElement(int absRow, int subrow) {
        int relRow = absRow - this.getPageStart();
        this.checkRowBounds(relRow);
        NodeList<TableRowElement> rows = this.getTableBodyElement().getRows();
        int rowCount = rows.getLength();
        if (rowCount == 0) {
            return null;
        }
        int frameStart = 0;
        int frameEnd = rowCount - 1;
        int domIndex = Math.min(relRow, frameEnd);
        while (domIndex >= frameStart && domIndex <= frameEnd) {
            TableRowElement curRow = rows.getItem(domIndex);
            int rowValueIndex = this.tableBuilder.getRowValueIndex(curRow);
            if (rowValueIndex == absRow) {
                int subrowValueIndex = this.tableBuilder.getSubrowValueIndex(curRow);
                if (subrow != subrowValueIndex) {
                    int offset = subrow - subrowValueIndex;
                    int subrowIndex = domIndex + offset;
                    if (subrowIndex >= rows.getLength()) {
                        return null;
                    }
                    curRow = rows.getItem(subrowIndex);
                    if (this.tableBuilder.getRowValueIndex(curRow) != absRow) {
                        return null;
                    }
                }
                return curRow;
            }
            if (rowValueIndex > absRow) {
                frameEnd = domIndex - 1;
            } else {
                frameStart = domIndex + 1;
            }
            domIndex = (frameStart + frameEnd) / 2;
        }
        return null;
    }

    private SafeHtml buildRowValues(List<T> values, int start, boolean isRebuildingAllRows) {
        int length = values.size();
        int end = start + length;
        this.tableBuilder.start(isRebuildingAllRows);
        for (int i = start; i < end; ++i) {
            T value = values.get(i - start);
            this.tableBuilder.buildRow(value, i);
        }
        this.coalesceCellProperties();
        TableSectionBuilder tableSectionBuilder = this.tableBuilder.finish();
        return AbstractCellTable.tableSectionToSafeHtml(tableSectionBuilder, "tbody");
    }

    private void checkColumnBounds(int col) {
        if (col < 0 || col >= this.getColumnCount()) {
            throw new IndexOutOfBoundsException("Column index is out of bounds: " + col);
        }
    }

    private void coalesceCellProperties() {
        this.dependsOnSelection = false;
        this.handlesSelection = false;
        this.isInteractive = false;
        for (HasCell<T, ?> column : this.tableBuilder.getColumns()) {
            Cell<?> cell = column.getCell();
            if (cell.dependsOnSelection()) {
                this.dependsOnSelection = true;
            }
            if (cell.handlesSelection()) {
                this.handlesSelection = true;
            }
            if (!AbstractCellTable.isColumnInteractive(column)) continue;
            this.isInteractive = true;
        }
    }

    private void createHeaders(boolean isFooter) {
        TableSectionBuilder section;
        TableSectionBuilder tableSectionBuilder = section = isFooter ? this.footerBuilder.buildFooter() : this.headerBuilder.buildHeader();
        if (section != null) {
            TABLE_IMPL.replaceAllRows(this, isFooter ? this.getTableFootElement() : this.getTableHeadElement(), AbstractCellTable.tableSectionToSafeHtml(section, isFooter ? "tfoot" : "thead"));
            this.doSetHeaderVisible(isFooter, true);
        } else {
            this.doSetHeaderVisible(isFooter, false);
        }
    }

    private <C> void fireEventToCell(Event event, String eventType, Element parentElem, final T rowValue, Cell.Context context, HasCell<T, C> column) {
        Cell<C> cell = column.getCell();
        if (!this.cellConsumesEventType(cell, eventType)) {
            return;
        }
        C cellValue = column.getValue(rowValue);
        boolean cellWasEditing = cell.isEditing(context, parentElem, cellValue);
        if (column instanceof Column) {
            Column col = (Column)column;
            col.onBrowserEvent(context, parentElem, rowValue, event);
        } else {
            final FieldUpdater<T, C> fieldUpdater = column.getFieldUpdater();
            final int index = context.getIndex();
            ValueUpdater valueUpdater = fieldUpdater == null ? null : new ValueUpdater<C>(){
                final /* synthetic */ AbstractCellTable this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void update(C value) {
                    fieldUpdater.update(index, rowValue, value);
                }
            };
            cell.onBrowserEvent(context, parentElem, cellValue, event, valueUpdater);
        }
        this.cellIsEditing = cell.isEditing(context, parentElem, cellValue);
        if (cellWasEditing && !this.cellIsEditing) {
            CellBasedWidgetImpl.get().resetFocus(new Scheduler.ScheduledCommand(){

                @Override
                public void execute() {
                    AbstractCellTable.this.setFocus(true);
                }
            });
        }
    }

    private Element getKeyboardSelectedElement(TableCellElement td) {
        if (td == null) {
            return null;
        }
        if (this.tableBuilder.isColumn(td)) {
            return td;
        }
        Element firstChild = td.getFirstChildElement();
        if (firstChild != null && td.getChildCount() == 1 && "div".equalsIgnoreCase(firstChild.getTagName())) {
            return firstChild;
        }
        return td;
    }

    private TableCellElement getKeyboardSelectedTableCellElement() {
        int cellCount;
        int colIndex = this.getKeyboardSelectedColumn();
        if (colIndex < 0) {
            return null;
        }
        int rowIndex = this.getKeyboardSelectedRow();
        if (rowIndex < 0 || rowIndex >= this.getTableBodyElement().getRows().getLength()) {
            return null;
        }
        TableRowElement tr = this.getSubRowElement(rowIndex + this.getPageStart(), this.keyboardSelectedSubrow);
        if (tr != null && (cellCount = tr.getCells().getLength()) > 0) {
            int column = Math.min(colIndex, cellCount - 1);
            return tr.getCells().getItem(column);
        }
        return null;
    }

    private void init() {
        if (TABLE_IMPL == null) {
            TABLE_IMPL = (Impl)GWT.create(Impl.class);
        }
        if (template == null) {
            template = (Template)GWT.create(Template.class);
        }
        this.setStyleName(this.style.widget());
        HashSet<String> eventTypes = new HashSet<String>();
        eventTypes.add("mouseover");
        eventTypes.add("mouseout");
        CellBasedWidgetImpl.get().sinkEvents(this, eventTypes);
        this.tableBuilder = new DefaultCellTableBuilder(this);
        this.headerBuilder = new DefaultHeaderOrFooterBuilder(this, false);
        this.footerBuilder = new DefaultHeaderOrFooterBuilder(this, true);
        this.setKeyboardSelectionHandler(new CellTableKeyboardSelectionHandler(this));
    }

    private void refreshColumnsAndRedraw() {
        this.columnWidthsDirty = true;
        this.redraw();
    }

    private void refreshHeadersAndColumnsImpl() {
        if (this.columnWidthsDirty) {
            this.columnWidthsDirty = false;
            this.refreshColumnWidths();
        }
        boolean wereHeadersDirty = this.headersDirty;
        this.headersDirty = false;
        if (wereHeadersDirty || !this.headerRefreshDisabled) {
            this.createHeaders(false);
        }
        if (wereHeadersDirty || !this.footerRefreshDisabled) {
            this.createHeaders(true);
        }
    }

    private <C> boolean resetFocusOnCellImpl(Cell.Context context, T value, HasCell<T, C> column, Element cellParent) {
        C cellValue = column.getValue(value);
        Cell<C> cell = column.getCell();
        return cell.resetFocus(context, cellParent, cellValue);
    }

    private void setRowHover(TableRowElement tr, Event event, boolean isHovering, boolean isRowChange) {
        if (!this.skipRowHoverStyleUpdate) {
            this.setRowStyleName(tr, this.style.hoveredRow(), this.style.hoveredRowCell(), isHovering);
        }
        RowHoverEvent.fire(this, tr, event, !isHovering, isRowChange ? RowHoverEvent.HoveringScope.ROW_HOVER : RowHoverEvent.HoveringScope.CELL_HOVER);
    }

    private void setRowStyleName(TableRowElement tr, String rowStyle, String cellStyle, boolean add) {
        AbstractCellTable.setStyleName(tr, rowStyle, add);
        NodeList<TableCellElement> cells = tr.getCells();
        for (int i = 0; i < cells.getLength(); ++i) {
            AbstractCellTable.setStyleName(cells.getItem(i), cellStyle, add);
        }
    }

    private void updateColumnWidthImpl(Column<T, ?> column, String width) {
        int columnCount = this.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            if (this.columns.get(i) != column) continue;
            this.doSetColumnWidth(i, width);
        }
    }

    static interface Template
    extends SafeHtmlTemplates {
        @SafeHtmlTemplates.Template(value="<div style=\"outline:none;\">{0}</div>")
        public SafeHtml div(SafeHtml var1);

        @SafeHtmlTemplates.Template(value="<table><tbody>{0}</tbody></table>")
        public SafeHtml tbody(SafeHtml var1);

        @SafeHtmlTemplates.Template(value="<td class=\"{0}\">{1}</td>")
        public SafeHtml td(String var1, SafeHtml var2);

        @SafeHtmlTemplates.Template(value="<td class=\"{0}\" align=\"{1}\" valign=\"{2}\">{3}</td>")
        public SafeHtml tdBothAlign(String var1, String var2, String var3, SafeHtml var4);

        @SafeHtmlTemplates.Template(value="<td class=\"{0}\" align=\"{1}\">{2}</td>")
        public SafeHtml tdHorizontalAlign(String var1, String var2, SafeHtml var3);

        @SafeHtmlTemplates.Template(value="<td class=\"{0}\" valign=\"{1}\">{2}</td>")
        public SafeHtml tdVerticalAlign(String var1, String var2, SafeHtml var3);

        @SafeHtmlTemplates.Template(value="<table><tfoot>{0}</tfoot></table>")
        public SafeHtml tfoot(SafeHtml var1);

        @SafeHtmlTemplates.Template(value="<table><thead>{0}</thead></table>")
        public SafeHtml thead(SafeHtml var1);

        @SafeHtmlTemplates.Template(value="<tr class=\"{0}\">{1}</tr>")
        public SafeHtml tr(String var1, SafeHtml var2);
    }

    public static interface Resources {
        public ImageResource sortAscending();

        public ImageResource sortDescending();

        public Style style();
    }

    public static interface Style {
        public String cell();

        public String evenRow();

        public String evenRowCell();

        public String firstColumn();

        public String firstColumnFooter();

        public String firstColumnHeader();

        public String footer();

        public String header();

        public String hoveredRow();

        public String hoveredRowCell();

        public String keyboardSelectedCell();

        public String keyboardSelectedRow();

        public String keyboardSelectedRowCell();

        public String lastColumn();

        public String lastColumnFooter();

        public String lastColumnHeader();

        public String oddRow();

        public String oddRowCell();

        public String selectedRow();

        public String selectedRowCell();

        public String sortableHeader();

        public String sortedHeaderAscending();

        public String sortedHeaderDescending();

        public String widget();
    }

    private static class Impl {
        private final Element tmpElem = Document.get().createDivElement();

        private Impl() {
        }

        public TableSectionElement convertToSectionElement(AbstractCellTable<?> table, String sectionTag, SafeHtml rowHtml) {
            DOM.setEventListener(this.tmpElem, table);
            sectionTag = sectionTag.toLowerCase(Locale.ROOT);
            if ("tbody".equals(sectionTag)) {
                this.tmpElem.setInnerSafeHtml(template.tbody(rowHtml));
            } else if ("thead".equals(sectionTag)) {
                this.tmpElem.setInnerSafeHtml(template.thead(rowHtml));
            } else if ("tfoot".equals(sectionTag)) {
                this.tmpElem.setInnerSafeHtml(template.tfoot(rowHtml));
            } else {
                throw new IllegalArgumentException("Invalid table section tag: " + sectionTag);
            }
            TableElement tableElem = (TableElement)this.tmpElem.getFirstChildElement().cast();
            DOM.setEventListener(this.tmpElem, null);
            if ("tbody".equals(sectionTag)) {
                return tableElem.getTBodies().getItem(0);
            }
            if ("thead".equals(sectionTag)) {
                return tableElem.getTHead();
            }
            if ("tfoot".equals(sectionTag)) {
                return tableElem.getTFoot();
            }
            throw new IllegalArgumentException("Invalid table section tag: " + sectionTag);
        }

        public final void replaceAllRows(AbstractCellTable<?> table, TableSectionElement section, SafeHtml html) {
            if (!table.isAttached()) {
                DOM.setEventListener(table.getElement(), table);
            }
            Element parent = section.getParentElement();
            Element nextSection = section.getNextSiblingElement();
            this.detachSectionElement(section);
            this.replaceAllRowsImpl(table, section, html);
            this.reattachSectionElement(parent, section, nextSection);
            if (!table.isAttached()) {
                DOM.setEventListener(table.getElement(), null);
            }
        }

        public final void replaceChildren(AbstractCellTable<?> table, TableSectionElement section, SafeHtml html, int startIndex, int childCount) {
            if (!table.isAttached()) {
                DOM.setEventListener(table.getElement(), table);
            }
            Element parent = section.getParentElement();
            Element nextSection = section.getNextSiblingElement();
            this.detachSectionElement(section);
            int absEndIndex = table.getPageStart() + startIndex + childCount;
            TableRowElement insertBefore = (TableRowElement)table.getChildElement(startIndex).cast();
            if (((AbstractCellTable)table).legacyRenderRowValues) {
                for (int count = 0; insertBefore != null && count < childCount; ++count) {
                    Element next = insertBefore.getNextSiblingElement();
                    section.removeChild(insertBefore);
                    insertBefore = next == null ? null : (TableRowElement)next.cast();
                }
            } else {
                while (insertBefore != null && ((AbstractCellTable)table).tableBuilder.getRowValueIndex(insertBefore) < absEndIndex) {
                    Element next = insertBefore.getNextSiblingElement();
                    section.removeChild(insertBefore);
                    insertBefore = next == null ? null : (TableRowElement)next.cast();
                }
            }
            TableSectionElement newSection = this.convertToSectionElement(table, section.getTagName(), html);
            Element newChild = newSection.getFirstChildElement();
            while (newChild != null) {
                Element next = newChild.getNextSiblingElement();
                section.insertBefore(newChild, insertBefore);
                newChild = next;
            }
            this.reattachSectionElement(parent, section, nextSection);
            if (!table.isAttached()) {
                DOM.setEventListener(table.getElement(), null);
            }
        }

        protected void detachSectionElement(TableSectionElement section) {
            section.removeFromParent();
        }

        protected void reattachSectionElement(Element parent, TableSectionElement section, Element nextSection) {
            parent.insertBefore(section, nextSection);
        }

        protected void replaceAllRowsImpl(AbstractCellTable<?> table, TableSectionElement section, SafeHtml html) {
            section.setInnerSafeHtml(html);
        }
    }

    public static class CellTableKeyboardSelectionHandler<T>
    extends AbstractHasData.DefaultKeyboardSelectionHandler<T> {
        private final AbstractCellTable<T> table;

        public CellTableKeyboardSelectionHandler(AbstractCellTable<T> table) {
            super(table);
            this.table = table;
        }

        @Override
        public AbstractCellTable<T> getDisplay() {
            return this.table;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onCellPreview(CellPreviewEvent<T> event) {
            block11: {
                String eventType;
                block10: {
                    NativeEvent nativeEvent = event.getNativeEvent();
                    eventType = event.getNativeEvent().getType();
                    if (!"keydown".equals(eventType) || event.isCellEditing()) break block10;
                    int oldRow = this.table.getKeyboardSelectedRow();
                    int oldColumn = this.table.getKeyboardSelectedColumn();
                    boolean isRtl = LocaleInfo.getCurrentLocale().isRTL();
                    int keyCodeLineEnd = isRtl ? 37 : 39;
                    int keyCodeLineStart = isRtl ? 39 : 37;
                    int keyCode = nativeEvent.getKeyCode();
                    if (keyCode == keyCodeLineEnd) {
                        int nextColumn = this.findInteractiveColumn(oldColumn, false);
                        if (nextColumn > oldColumn) {
                            this.table.setKeyboardSelectedColumn(nextColumn);
                            this.handledEvent(event);
                            return;
                        }
                        this.table.setKeyboardSelectedRow(oldRow + 1);
                        if (this.table.getKeyboardSelectedRow() != oldRow) {
                            this.table.setKeyboardSelectedColumn(nextColumn);
                            this.handledEvent(event);
                            return;
                        }
                        break block11;
                    } else if (keyCode == keyCodeLineStart) {
                        int prevColumn = this.findInteractiveColumn(oldColumn, true);
                        if (prevColumn < oldColumn) {
                            this.table.setKeyboardSelectedColumn(prevColumn);
                            this.handledEvent(event);
                            return;
                        }
                        this.table.setKeyboardSelectedRow(oldRow - 1);
                        if (this.table.getKeyboardSelectedRow() != oldRow) {
                            this.table.setKeyboardSelectedColumn(prevColumn);
                            this.handledEvent(event);
                            return;
                        }
                    }
                    break block11;
                }
                if ("click".equals(eventType) || "focus".equals(eventType)) {
                    int col = event.getColumn();
                    int relRow = event.getIndex() - this.table.getPageStart();
                    int subrow = event.getContext().getSubIndex();
                    if (this.table.getKeyboardSelectedColumn() != col || this.table.getKeyboardSelectedRow() != relRow || this.table.getKeyboardSelectedSubRow() != subrow) {
                        boolean stealFocus = false;
                        if ("click".equals(eventType)) {
                            Element target = Element.as(event.getNativeEvent().getEventTarget());
                            stealFocus = !CellBasedWidgetImpl.get().isFocusable(target);
                        }
                        this.table.setKeyboardSelectedRow(relRow, subrow, stealFocus);
                        this.table.setKeyboardSelectedColumn(col, stealFocus);
                    }
                    return;
                }
            }
            super.onCellPreview(event);
        }

        private int findInteractiveColumn(int start, boolean reverse) {
            if (!((AbstractCellTable)this.table).isInteractive) {
                return 0;
            }
            if (reverse) {
                int i;
                for (i = start - 1; i >= 0; --i) {
                    if (!AbstractCellTable.isColumnInteractive(this.table.getColumn(i))) continue;
                    return i;
                }
                for (i = this.table.getColumnCount() - 1; i >= start; --i) {
                    if (!AbstractCellTable.isColumnInteractive(this.table.getColumn(i))) continue;
                    return i;
                }
            } else {
                int i;
                for (i = start + 1; i < this.table.getColumnCount(); ++i) {
                    if (!AbstractCellTable.isColumnInteractive(this.table.getColumn(i))) continue;
                    return i;
                }
                for (i = 0; i <= start; ++i) {
                    if (!AbstractCellTable.isColumnInteractive(this.table.getColumn(i))) continue;
                    return i;
                }
            }
            return 0;
        }
    }

    private static class ImplTrident
    extends Impl {
        private ImplTrident() {
        }

        @Override
        protected void detachSectionElement(TableSectionElement section) {
        }

        @Override
        protected void reattachSectionElement(Element parent, TableSectionElement section, Element nextSection) {
        }

        @Override
        protected void replaceAllRowsImpl(AbstractCellTable<?> table, TableSectionElement section, SafeHtml html) {
            if (table instanceof TableSectionChangeHandler) {
                this.replaceTableSection(table, section, html);
            } else {
                this.replaceAllRowsImplLegacy(table, section, html);
            }
        }

        protected void replaceAllRowsImplLegacy(AbstractCellTable<?> table, TableSectionElement section, SafeHtml html) {
            Element child = section.getFirstChildElement();
            while (child != null) {
                Element next = child.getNextSiblingElement();
                section.removeChild(child);
                child = next;
            }
            TableSectionElement newSection = this.convertToSectionElement(table, section.getTagName(), html);
            child = newSection.getFirstChildElement();
            while (child != null) {
                Element next = child.getNextSiblingElement();
                section.appendChild(child);
                child = next;
            }
        }

        private void replaceTableSection(AbstractCellTable<?> table, TableSectionElement section, SafeHtml html) {
            String sectionName = section.getTagName().toLowerCase(Locale.ROOT);
            TableSectionElement newSection = this.convertToSectionElement(table, sectionName, html);
            TableElement tableElement = (TableElement)table.getElement().cast();
            tableElement.replaceChild(newSection, section);
            if ("tbody".equals(sectionName)) {
                ((TableSectionChangeHandler)((Object)table)).onTableBodyChange(newSection);
            } else if ("thead".equals(sectionName)) {
                ((TableSectionChangeHandler)((Object)table)).onTableHeadChange(newSection);
            } else if ("tfoot".equals(sectionName)) {
                ((TableSectionChangeHandler)((Object)table)).onTableFootChange(newSection);
            }
        }
    }

    private static class ImplMozilla
    extends Impl {
        private ImplMozilla() {
        }

        @Override
        protected void detachSectionElement(TableSectionElement section) {
            if (this.isGecko192OrBefore()) {
                return;
            }
            super.detachSectionElement(section);
        }

        @Override
        protected void reattachSectionElement(Element parent, TableSectionElement section, Element nextSection) {
            if (this.isGecko192OrBefore()) {
                return;
            }
            super.reattachSectionElement(parent, section, nextSection);
        }

        private native boolean isGecko192OrBefore();
    }

    protected static interface TableSectionChangeHandler {
        public void onTableBodyChange(TableSectionElement var1);

        public void onTableFootChange(TableSectionElement var1);

        public void onTableHeadChange(TableSectionElement var1);
    }
}

