/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.tags;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.unitime.commons.Debug;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamPeriodPref;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.MidtermPeriodPreferenceModel;
import org.unitime.timetable.model.PeriodPreferenceModel;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.context.HttpSessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.WebSolver;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;

public class Exams
extends BodyTagSupport {
    private static final long serialVersionUID = -666904499562226756L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private String iType = null;
    private boolean iAdd = true;
    private String iId = null;

    public SessionContext getSessionContext() {
        return HttpSessionContext.getSessionContext(this.pageContext.getServletContext());
    }

    public void setType(String type) {
        this.iType = type;
    }

    public String getType() {
        return this.iType;
    }

    public void setAdd(boolean add) {
        this.iAdd = add;
    }

    public boolean isAdd() {
        return this.iAdd;
    }

    public void setId(String id) {
        this.iId = id;
    }

    public String getId() {
        return this.iId;
    }

    public int doStartTag() throws JspException {
        return 2;
    }

    public int doEndTag() throws JspException {
        try {
            Object title;
            String objectIdStr;
            if (!this.getSessionContext().hasPermission(Right.Examinations) && !this.getSessionContext().hasPermission(Right.ExaminationSchedule)) {
                return 6;
            }
            String string = objectIdStr = this.getBodyContent() == null ? null : this.getBodyContent().getString().trim();
            if (objectIdStr == null || objectIdStr.length() == 0) {
                String string2 = objectIdStr = this.getId() == null ? null : this.getId().trim();
            }
            if (objectIdStr == null || objectIdStr.length() == 0) {
                return 6;
            }
            Long objectId = Long.parseLong(objectIdStr);
            List<Exam> exams = Exam.findAllRelated(this.getType(), objectId);
            Iterator<Exam> i = exams.iterator();
            while (i.hasNext()) {
                if (this.getSessionContext().hasPermission(i.next(), Right.ExaminationView)) continue;
                i.remove();
            }
            if (!(exams != null && !exams.isEmpty() || this.iAdd && this.getSessionContext().hasPermission(Right.ExaminationAdd))) {
                return 6;
            }
            Object object = title = exams.size() == 1 ? MSG.sectionTitleExamination() : MSG.sectionTitleExaminations();
            if (this.iAdd && this.getSessionContext().hasPermission(Right.ExaminationAdd)) {
                title = "<table width='100%'><tr><td width='100%'><DIV class=\"WelcomeRowHeadNoLine\">" + MSG.sectionTitleExaminations() + "</DIV></td><td style='padding-bottom: 2px'><input type=\"button\" onclick=\"document.location='examEdit.action?firstType=" + this.getType() + "&firstId=" + objectId + "';\" class=\"btn\" accesskey='" + MSG.accessAddExamination() + "' title='" + MSG.titleAddExamination(MSG.accessAddExamination()) + "' value='" + MSG.actionAddExamination() + "'></td></tr></table>";
            }
            WebTable table = new WebTable(10, (String)title, new String[]{MSG.columnExamClassesCourses(), MSG.columnExamType(), MSG.columnExamLength(), MSG.columnExamSeatingType(), MSG.columnExamSize(), MSG.columnExamMaxRooms(), MSG.columnExamInstructor(), MSG.columnExamPeriodPreferences(), MSG.columnExamRoomPreferences(), MSG.columnExamDistributionPreferences()}, new String[]{"left", "left", "right", "center", "right", "right", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, true, true, true, true, true});
            boolean timeVertical = CommonValues.VerticalGrid.eq(this.getSessionContext().getUser().getProperty(UserProperty.GridOrientation));
            boolean timeText = CommonValues.TextGrid.eq(this.getSessionContext().getUser().getProperty(UserProperty.GridOrientation));
            String instructorNameFormat = this.getSessionContext().getUser().getProperty(UserProperty.NameFormat);
            String backId = null;
            if ("PreferenceGroup".equals(this.pageContext.getRequest().getParameter("backType"))) {
                backId = this.pageContext.getRequest().getParameter("backId");
            }
            if (this.pageContext.getRequest().getAttribute("examId") != null) {
                backId = this.pageContext.getRequest().getAttribute("examId").toString();
            }
            boolean hasExamHash = false;
            if (exams != null) {
                ExamSolverProxy solver = WebSolver.getExamSolver(this.pageContext.getSession());
                Long solverType = solver == null ? null : solver.getExamTypeId();
                boolean hasSolution = false;
                for (Exam exam : new TreeSet<Exam>(exams)) {
                    ExamAssignment assignment = null;
                    if (exam.getExamType().getUniqueId().equals(solverType)) {
                        assignment = solver.getAssignment(exam.getUniqueId());
                    } else if (exam.getAssignedPeriod() != null) {
                        assignment = new ExamAssignment(exam);
                    }
                    if (assignment == null || assignment.getPeriodId() == null) continue;
                    hasSolution = true;
                    break;
                }
                if (this.getSessionContext().hasPermission(Right.Examinations)) {
                    if (hasSolution) {
                        table = new WebTable(10, (String)title, new String[]{MSG.columnExamClassesCourses(), MSG.columnExamType(), MSG.columnExamLength(), MSG.columnExamSeatingType(), MSG.columnExamSize(), MSG.columnExamMaxRooms(), MSG.columnExamInstructor(), MSG.columnExamAssignedPeriod(), MSG.columnExamAssignedRoom(), MSG.columnExamStudentConflicts()}, new String[]{"left", "left", "right", "center", "right", "right", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, true, true, true, true, true});
                    }
                    for (Exam exam : new TreeSet<Exam>(exams)) {
                        boolean view = this.getSessionContext().hasPermission(exam, Right.ExaminationDetail);
                        Object objects = "";
                        Object instructors = "";
                        Object perPref = "";
                        Object roomPref = "";
                        Object distPref = "";
                        ExamAssignmentInfo assignment = null;
                        if (exam.getExamType().getUniqueId().equals(solverType)) {
                            assignment = solver.getAssignmentInfo(exam.getUniqueId());
                        } else if (exam.getAssignedPeriod() != null) {
                            assignment = new ExamAssignmentInfo(exam);
                        }
                        Enumeration e = exam.getOwnerObjects().elements();
                        while (e.hasMoreElements()) {
                            Object object2 = e.nextElement();
                            if (((String)objects).length() > 0) {
                                objects = (String)objects + "<br>";
                            }
                            if (object2 instanceof Class_) {
                                objects = (String)objects + ((Class_)object2).getClassLabel();
                                continue;
                            }
                            if (object2 instanceof InstrOfferingConfig) {
                                objects = (String)objects + ((InstrOfferingConfig)object2).toString();
                                continue;
                            }
                            if (object2 instanceof InstructionalOffering) {
                                objects = (String)objects + ((InstructionalOffering)object2).getCourseName();
                                continue;
                            }
                            if (object2 instanceof CourseOffering) {
                                objects = (String)objects + ((CourseOffering)object2).getCourseName();
                                continue;
                            }
                            objects = (String)objects + object2.toString();
                        }
                        if (!hasSolution || assignment == null || assignment.getPeriodId() == null) {
                            if (((String)(roomPref = (String)roomPref + exam.getEffectivePrefHtmlForPrefType(RoomPref.class))).length() > 0 && !((String)roomPref).endsWith("<br>")) {
                                roomPref = (String)roomPref + "<br>";
                            }
                            if (((String)(roomPref = (String)roomPref + exam.getEffectivePrefHtmlForPrefType(BuildingPref.class))).length() > 0 && !((String)roomPref).endsWith("<br>")) {
                                roomPref = (String)roomPref + "<br>";
                            }
                            if (((String)(roomPref = (String)roomPref + exam.getEffectivePrefHtmlForPrefType(RoomFeaturePref.class))).length() > 0 && !((String)roomPref).endsWith("<br>")) {
                                roomPref = (String)roomPref + "<br>";
                            }
                            if (((String)(roomPref = (String)roomPref + exam.getEffectivePrefHtmlForPrefType(RoomGroupPref.class))).endsWith("<br>")) {
                                roomPref = ((String)roomPref).substring(0, ((String)roomPref).length() - "<br>".length());
                            }
                            if (exam.getExamType().getType() == 1) {
                                MidtermPeriodPreferenceModel epx = new MidtermPeriodPreferenceModel(exam.getSession(), exam.getExamType());
                                epx.load(exam);
                                perPref = (String)perPref + epx.toString(true);
                            } else if (timeText) {
                                perPref = (String)perPref + exam.getEffectivePrefHtmlForPrefType(ExamPeriodPref.class);
                            } else {
                                PeriodPreferenceModel px = new PeriodPreferenceModel(exam.getSession(), exam.getExamType().getUniqueId());
                                px.load(exam);
                                perPref = "<img border='0' src='pattern?v=" + (timeVertical ? 1 : 0) + "&x=" + exam.getUniqueId() + "' title='" + px.toString() + "'>";
                            }
                            distPref = !hasSolution ? (String)distPref + exam.getEffectivePrefHtmlForPrefType(DistributionPref.class) : "<i>Not Assigned</i>";
                        } else {
                            perPref = view ? assignment.getPeriodAbbreviationWithPref() : assignment.getPeriodAbbreviation();
                            roomPref = view ? assignment.getRoomsNameWithPref("<br>") : assignment.getRoomsName("<br>");
                            int dc = assignment.getNrDirectConflicts();
                            String dcStr = dc <= 0 ? "<font color='gray'>0</font>" : "<font color='" + PreferenceLevel.prolog2color("P") + "'>" + dc + "</font>";
                            int m2d = assignment.getNrMoreThanTwoConflicts();
                            String m2dStr = m2d <= 0 ? "<font color='gray'>0</font>" : "<font color='" + PreferenceLevel.prolog2color("2") + "'>" + m2d + "</font>";
                            int btb = assignment.getNrBackToBackConflicts();
                            int dbtb = assignment.getNrDistanceBackToBackConflicts();
                            String btbStr = btb <= 0 && dbtb <= 0 ? "<font color='gray'>0</font>" : "<font color='" + PreferenceLevel.prolog2color("1") + "'>" + btb + (String)(dbtb > 0 ? " (d:" + dbtb + ")" : "") + "</font>";
                            distPref = view ? dcStr + ", " + m2dStr + ", " + btbStr : "<i>N/A</i>";
                        }
                        for (DepartmentalInstructor instructor : new TreeSet<DepartmentalInstructor>(exam.getInstructors())) {
                            if (((String)instructors).length() > 0) {
                                instructors = (String)instructors + "<br>";
                            }
                            instructors = (String)instructors + instructor.getName(instructorNameFormat);
                        }
                        int nrStudents = exam.getSize();
                        if (exam.getUniqueId().toString().equals(backId)) {
                            objects = "<A name='examHash'>" + (String)objects + "</A>";
                            hasExamHash = true;
                        }
                        table.addLine(view ? "onClick=\"document.location='examDetail.action?examId=" + exam.getUniqueId() + "';\"" : null, new String[]{objects, exam.getExamType().getLabel(), exam.getLength().toString(), 0 == exam.getSeatingType() ? MSG.examSeatingTypeNormal() : MSG.examSeatingTypeExam(), String.valueOf(nrStudents), exam.getMaxNbrRooms().toString(), instructors, perPref, roomPref, distPref}, null, exam.getUniqueId().toString());
                    }
                } else {
                    if (!hasSolution) {
                        return 6;
                    }
                    table = new WebTable(5, (String)title, new String[]{MSG.columnExamClassesCourses(), MSG.columnExamType(), MSG.columnExamInstructor(), MSG.columnExamPeriod(), MSG.columnExamRoom()}, new String[]{"left", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, true});
                    for (Exam exam : new TreeSet<Exam>(exams)) {
                        Object objects = "";
                        Object instructors = "";
                        String perPref = "";
                        String roomPref = "";
                        ExamAssignmentInfo assignment = null;
                        if (exam.getExamType().getUniqueId().equals(solverType)) {
                            assignment = solver.getAssignmentInfo(exam.getUniqueId());
                        } else if (exam.getAssignedPeriod() != null) {
                            assignment = new ExamAssignmentInfo(exam);
                        }
                        Enumeration e = exam.getOwnerObjects().elements();
                        while (e.hasMoreElements()) {
                            Object object3 = e.nextElement();
                            if (((String)objects).length() > 0) {
                                objects = (String)objects + "<br>";
                            }
                            if (object3 instanceof Class_) {
                                objects = (String)objects + ((Class_)object3).getClassLabel();
                                continue;
                            }
                            if (object3 instanceof InstrOfferingConfig) {
                                objects = (String)objects + ((InstrOfferingConfig)object3).toString();
                                continue;
                            }
                            if (object3 instanceof InstructionalOffering) {
                                objects = (String)objects + ((InstructionalOffering)object3).getCourseName();
                                continue;
                            }
                            if (object3 instanceof CourseOffering) {
                                objects = (String)objects + ((CourseOffering)object3).getCourseName();
                                continue;
                            }
                            objects = (String)objects + object3.toString();
                        }
                        if (assignment == null || assignment.getPeriodId() == null) continue;
                        perPref = assignment.getPeriodName();
                        roomPref = assignment.getRoomsName("<br>");
                        for (DepartmentalInstructor instructor : new TreeSet<DepartmentalInstructor>(exam.getInstructors())) {
                            if (((String)instructors).length() > 0) {
                                instructors = (String)instructors + "<br>";
                            }
                            instructors = (String)instructors + instructor.getName(instructorNameFormat);
                        }
                        if (exam.getUniqueId().toString().equals(backId)) {
                            objects = "<A name='examHash'>" + (String)objects + "</A>";
                            hasExamHash = true;
                        }
                        table.addLine(null, new String[]{objects, exam.getExamType().getLabel(), instructors, perPref, roomPref}, null, exam.getUniqueId().toString());
                    }
                }
            }
            this.pageContext.getOut().println("<table width='100%' border='0' cellspacing='0' cellpadding='3'>");
            if ("Exam".equals(this.pageContext.getRequest().getParameter("backType"))) {
                this.pageContext.getOut().println("<tr><td colpan='9'><A name='examHash'>&nbsp;</A></td></tr>");
                hasExamHash = true;
            } else {
                this.pageContext.getOut().println("<tr><td colpan='9'>&nbsp;</td></tr>");
            }
            this.pageContext.getOut().println(table.printTable());
            this.pageContext.getOut().println("</table>");
            if (hasExamHash) {
                this.pageContext.getOut().println("<SCRIPT type='text/javascript' language='javascript'>location.hash = 'examHash';</SCRIPT>");
            }
        }
        catch (Exception e) {
            Debug.error(e);
            try {
                this.pageContext.getOut().print("<font color='red'>ERROR: " + e.getMessage() + "</font>");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 6;
    }
}

