/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.RefTableEntry;

@MappedSuperclass
public abstract class BaseDistributionType
extends RefTableEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Boolean iSequencingRequired;
    private Integer iRequirementId;
    private String iAllowedPref;
    private String iDescr;
    private String iAbbreviation;
    private Boolean iInstructorPref;
    private Boolean iExamPref;
    private Boolean iVisible;
    private Boolean iSurvey;
    private Set<Department> iDepartments;

    public BaseDistributionType() {
    }

    public BaseDistributionType(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Column(name="sequencing_required", nullable=false)
    public Boolean isSequencingRequired() {
        return this.iSequencingRequired;
    }

    @Transient
    public Boolean getSequencingRequired() {
        return this.iSequencingRequired;
    }

    public void setSequencingRequired(Boolean sequencingRequired) {
        this.iSequencingRequired = sequencingRequired;
    }

    @Column(name="req_id", nullable=false)
    public Integer getRequirementId() {
        return this.iRequirementId;
    }

    public void setRequirementId(Integer requirementId) {
        this.iRequirementId = requirementId;
    }

    @Column(name="allowed_pref", nullable=true, length=10)
    public String getAllowedPref() {
        return this.iAllowedPref;
    }

    public void setAllowedPref(String allowedPref) {
        this.iAllowedPref = allowedPref;
    }

    @Column(name="description", nullable=true, length=2048)
    public String getDescr() {
        return this.iDescr;
    }

    public void setDescr(String descr) {
        this.iDescr = descr;
    }

    @Column(name="abbreviation", nullable=true)
    public String getAbbreviation() {
        return this.iAbbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.iAbbreviation = abbreviation;
    }

    @Column(name="instructor_pref", nullable=false)
    public Boolean isInstructorPref() {
        return this.iInstructorPref;
    }

    @Transient
    public Boolean getInstructorPref() {
        return this.iInstructorPref;
    }

    public void setInstructorPref(Boolean instructorPref) {
        this.iInstructorPref = instructorPref;
    }

    @Column(name="exam_pref", nullable=false)
    public Boolean isExamPref() {
        return this.iExamPref;
    }

    @Transient
    public Boolean getExamPref() {
        return this.iExamPref;
    }

    public void setExamPref(Boolean examPref) {
        this.iExamPref = examPref;
    }

    @Column(name="visible", nullable=false)
    public Boolean isVisible() {
        return this.iVisible;
    }

    @Transient
    public Boolean getVisible() {
        return this.iVisible;
    }

    public void setVisible(Boolean visible) {
        this.iVisible = visible;
    }

    @Column(name="survey", nullable=true)
    public Boolean isSurvey() {
        return this.iSurvey;
    }

    @Transient
    public Boolean getSurvey() {
        return this.iSurvey;
    }

    public void setSurvey(Boolean survey) {
        this.iSurvey = survey;
    }

    @ManyToMany
    @JoinTable(name="dist_type_dept", joinColumns={@JoinColumn(name="dist_type_id")}, inverseJoinColumns={@JoinColumn(name="dept_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<Department> getDepartments() {
        return this.iDepartments;
    }

    public void setDepartments(Set<Department> departments) {
        this.iDepartments = departments;
    }

    public void addToDepartments(Department department) {
        if (this.iDepartments == null) {
            this.iDepartments = new HashSet<Department>();
        }
        this.iDepartments.add(department);
    }

    @Deprecated
    public void addTodepartments(Department department) {
        this.addToDepartments(department);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof DistributionType)) {
            return false;
        }
        if (this.getUniqueId() == null || ((DistributionType)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((DistributionType)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "DistributionType[" + this.getUniqueId() + " " + this.getLabel() + "]";
    }

    @Override
    public String toDebugString() {
        return "DistributionType[\n\tAbbreviation: " + this.getAbbreviation() + "\n\tAllowedPref: " + this.getAllowedPref() + "\n\tDescr: " + this.getDescr() + "\n\tExamPref: " + this.getExamPref() + "\n\tInstructorPref: " + this.getInstructorPref() + "\n\tLabel: " + this.getLabel() + "\n\tReference: " + this.getReference() + "\n\tRequirementId: " + this.getRequirementId() + "\n\tSequencingRequired: " + this.getSequencingRequired() + "\n\tSurvey: " + this.getSurvey() + "\n\tUniqueId: " + this.getUniqueId() + "\n\tVisible: " + this.getVisible() + "]";
    }
}

