/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.model.ExamLocationPref;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamPeriodPref;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BaseExamPeriod;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.webutil.RequiredTimeTableModel;

public class PeriodPreferenceModel
implements RequiredTimeTableModel {
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    private TreeSet iDates = new TreeSet();
    private TreeSet iStarts = new TreeSet();
    private Hashtable iPreferences = new Hashtable();
    private TreeSet iPeriods = null;
    private Date iFirstDate = null;
    private boolean iAllowHard = true;
    private boolean iAllowRequired = true;
    private ExamPeriod iPeriod = null;
    private Long iExamType = null;
    private SimpleDateFormat[] iDF = new SimpleDateFormat[]{new SimpleDateFormat(CONSTANTS.examPeriodPreferenceDateFormat()[0], Localization.getJavaLocale()), new SimpleDateFormat(CONSTANTS.examPeriodPreferenceDateFormat()[1], Localization.getJavaLocale())};

    public PeriodPreferenceModel(Session session, Long examType) {
        this(session, (ExamPeriod)null, examType);
    }

    public PeriodPreferenceModel(Session session, ExamAssignment assignment, Long examType) {
        this(session, assignment == null ? null : assignment.getPeriod(), examType);
    }

    public PeriodPreferenceModel(Session session, ExamPeriod assignedPeriod, Long examType) {
        this.iPeriod = assignedPeriod;
        this.iFirstDate = session.getExamBeginDate();
        this.iPeriods = ExamPeriod.findAll(session.getUniqueId(), examType);
        this.iExamType = examType;
        for (ExamPeriod period : this.iPeriods) {
            this.iPreferences.put(period, PreferenceLevel.sNeutral);
            this.iStarts.add(period.getStartSlot());
            this.iDates.add(period.getDateOffset());
        }
    }

    public void load(PreferenceGroup pg) {
        for (ExamPeriodPref pref : pg.getPreferences(ExamPeriodPref.class)) {
            this.iPreferences.put(pref.getExamPeriod(), pref.getPrefLevel().getPrefProlog());
        }
    }

    public void save(Set preferences, PreferenceGroup pg) {
        for (Map.Entry entry : this.iPreferences.entrySet()) {
            ExamPeriod period = (ExamPeriod)entry.getKey();
            String pref = (String)entry.getValue();
            if (PreferenceLevel.sNeutral.equals(pref)) continue;
            ExamPeriodPref p = new ExamPeriodPref();
            p.setOwner(pg);
            p.setExamPeriod(period);
            p.setPrefLevel(PreferenceLevel.getPreferenceLevel(pref));
            preferences.add(p);
        }
    }

    public void load(Location location) {
        for (ExamLocationPref pref : location.getExamPreferences()) {
            if (!this.iExamType.equals(pref.getExamPeriod().getExamType().getUniqueId())) continue;
            this.iPreferences.put(pref.getExamPeriod(), pref.getPrefLevel().getPrefProlog());
        }
    }

    public void save(Location location) {
        location.clearExamPreferences(this.iExamType);
        for (Map.Entry entry : this.iPreferences.entrySet()) {
            ExamPeriod period = (ExamPeriod)entry.getKey();
            String pref = (String)entry.getValue();
            if (PreferenceLevel.sNeutral.equals(pref)) continue;
            location.addExamPreference(period, PreferenceLevel.getPreferenceLevel(pref));
        }
    }

    public void setAllowHard(boolean allowHard) {
        this.iAllowHard = allowHard;
    }

    public void setAllowRequired(boolean allowReq) {
        this.iAllowRequired = allowReq;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public int getNrDays() {
        return this.iDates.size();
    }

    @Override
    public int getNrTimes() {
        return this.iStarts.size();
    }

    @Override
    public String getStartTime(int time) {
        Integer slot = (Integer)this.iStarts.toArray()[time];
        int start = slot * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
        return Constants.toTime(start);
    }

    @Override
    public String getEndTime(int time) {
        Integer slot = (Integer)this.iStarts.toArray()[time];
        BaseExamPeriod period = null;
        for (ExamPeriod p : new TreeSet(this.iPreferences.keySet())) {
            if (!p.getStartSlot().equals(slot)) continue;
            period = p;
            break;
        }
        int end = (slot + period.getLength()) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
        return Constants.toTime(end);
    }

    @Override
    public String getDayHeader(int day) {
        Integer dateOffset = (Integer)this.iDates.toArray()[day];
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.iFirstDate);
        cal.add(6, dateOffset);
        Date date = new Date(cal.getTime().getTime());
        return this.iDF[0].format(date) + "<br>" + this.iDF[1].format(date);
    }

    public String getFileName() {
        return "PPx" + this.getPreferences() + (String)(this.iPeriod == null ? "" : "_" + this.iPeriod.getUniqueId());
    }

    @Override
    public void setPreference(int day, int time, String pref) {
        Integer dateOffset = (Integer)this.iDates.toArray()[day];
        Integer slot = (Integer)this.iStarts.toArray()[time];
        Enumeration e = this.iPreferences.keys();
        while (e.hasMoreElements()) {
            ExamPeriod p = (ExamPeriod)e.nextElement();
            if (!p.getStartSlot().equals(slot) || !p.getDateOffset().equals(dateOffset)) continue;
            this.iPreferences.put(p, pref);
            return;
        }
    }

    @Override
    public String getPreference(int day, int time) {
        Integer dateOffset = (Integer)this.iDates.toArray()[day];
        Integer slot = (Integer)this.iStarts.toArray()[time];
        Enumeration e = this.iPreferences.keys();
        while (e.hasMoreElements()) {
            ExamPeriod p = (ExamPeriod)e.nextElement();
            if (!p.getStartSlot().equals(slot) || !p.getDateOffset().equals(dateOffset)) continue;
            return (String)this.iPreferences.get(p);
        }
        return "@";
    }

    @Override
    public String getFieldText(int day, int time) {
        Integer dateOffset = (Integer)this.iDates.toArray()[day];
        Integer slot = (Integer)this.iStarts.toArray()[time];
        Enumeration e = this.iPreferences.keys();
        while (e.hasMoreElements()) {
            ExamPeriod p = (ExamPeriod)e.nextElement();
            if (!p.getStartSlot().equals(slot) || !p.getDateOffset().equals(dateOffset)) continue;
            return p.getAbbreviation();
        }
        return null;
    }

    @Override
    public boolean isEditable(int day, int time) {
        Integer dateOffset = (Integer)this.iDates.toArray()[day];
        Integer slot = (Integer)this.iStarts.toArray()[time];
        Enumeration e = this.iPreferences.keys();
        while (e.hasMoreElements()) {
            ExamPeriod p = (ExamPeriod)e.nextElement();
            if (!p.getStartSlot().equals(slot) || !p.getDateOffset().equals(dateOffset)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getPreferences() {
        Object prefs = "";
        for (ExamPeriod period : new TreeSet(this.iPreferences.keySet())) {
            String pref = (String)this.iPreferences.get(period);
            prefs = (String)prefs + PreferenceLevel.prolog2char(pref);
        }
        return prefs;
    }

    @Override
    public void setPreferences(String pref) {
        int idx = 0;
        for (ExamPeriod period : new TreeSet(this.iPreferences.keySet())) {
            char p = pref.charAt(idx);
            this.iPreferences.put(period, PreferenceLevel.char2prolog(p));
            ++idx;
        }
    }

    @Override
    public boolean isExactTime() {
        return false;
    }

    @Override
    public int getExactDays() {
        return 0;
    }

    @Override
    public int getExactStartSlot() {
        return 0;
    }

    @Override
    public void setExactDays(int days) {
    }

    @Override
    public void setExactStartSlot(int slot) {
    }

    @Override
    public String getDefaultPreference() {
        return PreferenceLevel.sNeutral;
    }

    @Override
    public Color getBorder(int day, int time) {
        if (this.iPeriod != null) {
            Integer slot = (Integer)this.iStarts.toArray()[time];
            Integer dateOffset = (Integer)this.iDates.toArray()[day];
            if (this.iPeriod.getStartSlot().equals(slot) && this.iPeriod.getDateOffset().equals(dateOffset)) {
                return new Color(0, 0, 242);
            }
        }
        return null;
    }

    public boolean hasPreference(String pref) {
        Iterator i = this.iPreferences.values().iterator();
        while (i.hasNext()) {
            if (!pref.equals(i.next())) continue;
            return true;
        }
        return false;
    }

    public boolean hasNotAvailable() {
        return this.iPreferences.size() < this.iDates.size() * this.iStarts.size();
    }

    @Override
    public String[] getPreferenceNames() {
        ArrayList<String> ret = new ArrayList<String>();
        for (PreferenceLevel pref : PreferenceLevel.getPreferenceLevelList()) {
            if (!this.iAllowRequired && PreferenceLevel.sRequired.equals(pref.getPrefProlog()) || !this.iAllowHard && pref.isHard() && !this.hasPreference(pref.getPrefProlog())) continue;
            ret.add(pref.getPrefProlog());
        }
        if (this.hasNotAvailable()) {
            ret.add("@");
        }
        return ret.toArray(new String[ret.size()]);
    }

    @Override
    public Color getPreferenceColor(String pref) {
        if ("@".equals(pref)) {
            return new Color(150, 150, 150);
        }
        return PreferenceLevel.prolog2awtColor(pref);
    }

    @Override
    public String getPreferenceText(String pref) {
        if ("@".equals(pref)) {
            return "Period Not Available";
        }
        return PreferenceLevel.prolog2string(pref);
    }

    @Override
    public int getNrSelections() {
        return 0;
    }

    @Override
    public String getSelectionName(int idx) {
        return null;
    }

    @Override
    public int[] getSelectionLimits(int idx) {
        return new int[]{0, this.getNrTimes() - 1, 0, this.getNrDays() - 1};
    }

    @Override
    public int getDefaultSelection() {
        return -1;
    }

    @Override
    public void setDefaultSelection(int selection) {
    }

    @Override
    public void setDefaultSelection(String selectionName) {
    }

    @Override
    public String getPreferenceCheck() {
        return null;
    }

    @Override
    public boolean isPreferenceEnabled(String pref) {
        if ("@".equals(pref)) {
            return false;
        }
        return this.iAllowHard || !PreferenceLevel.getPreferenceLevel(pref).isHard();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int ld = -1;
        for (int d = 0; d < this.getNrDays(); ++d) {
            String pref = null;
            int a = 0;
            int b = 0;
            for (int t = 0; t < this.getNrTimes(); ++t) {
                String p = this.getPreference(d, t);
                if (pref == null || !pref.equals(p)) {
                    if (pref != null && !"@".equals(pref) && !PreferenceLevel.sNeutral.equals(pref)) {
                        if (sb.length() > 0) {
                            sb.append(", ");
                        }
                        if (ld != d) {
                            sb.append(this.getDayHeader(d) + " ");
                            ld = d;
                        }
                        sb.append(PreferenceLevel.prolog2abbv(pref) + " ");
                        sb.append(this.getStartTime(a) + " - " + this.getEndTime(b));
                        ld = d;
                    }
                    pref = p;
                    a = b = t;
                    continue;
                }
                b = t;
            }
            if (pref == null || "@".equals(pref) || PreferenceLevel.sNeutral.equals(pref)) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            if (ld != d) {
                sb.append(this.getDayHeader(d) + " ");
                ld = d;
            }
            sb.append(PreferenceLevel.prolog2abbv(pref) + " ");
            sb.append(this.getStartTime(a) + " - " + this.getEndTime(b));
        }
        return sb.toString();
    }
}

