/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import org.cpsolver.ifs.util.ToolBox;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.base.BaseInstructorPref;
import org.unitime.timetable.util.NameFormat;

@Entity
@Table(name="instructor_pref")
public class InstructorPref
extends BaseInstructorPref {
    private static final long serialVersionUID = 6242763326071980017L;

    @Override
    public String preferenceText() {
        return NameFormat.LAST_FIRST_MIDDLE_TITLE.format(this.getInstructor());
    }

    @Override
    public String preferenceText(String nameFormat) {
        if (nameFormat == null) {
            return NameFormat.LAST_FIRST_MIDDLE_TITLE.format(this.getInstructor());
        }
        return this.getInstructor().getName(nameFormat);
    }

    @Override
    public String preferenceAbbv() {
        return NameFormat.LAST_INITIAL.format(this.getInstructor());
    }

    @Override
    public String preferenceAbbv(String nameFormat) {
        if (nameFormat == null) {
            return NameFormat.LAST_INITIAL.format(this.getInstructor());
        }
        return this.getInstructor().getName(nameFormat);
    }

    @Override
    public Object clone() {
        InstructorPref pref = new InstructorPref();
        pref.setPrefLevel(this.getPrefLevel());
        pref.setInstructor(this.getInstructor());
        return pref;
    }

    @Override
    public boolean isSame(Preference other) {
        if (other == null || !(other instanceof InstructorPref)) {
            return false;
        }
        return ToolBox.equals((Object)this.getInstructor(), (Object)((InstructorPref)other).getInstructor());
    }

    @Override
    public String preferenceTitle() {
        return this.getPrefLevel().getPrefName() + " " + this.preferenceText();
    }

    @Override
    public String preferenceTitle(String nameFormat) {
        return this.getPrefLevel().getPrefName() + " " + this.preferenceText(nameFormat);
    }

    @Override
    public int compareTo(Object o) {
        if (o == null || !(o instanceof InstructorPref)) {
            return super.compareTo(o);
        }
        InstructorPref p = (InstructorPref)o;
        int cmp = this.getInstructor().compareTo(p.getInstructor());
        if (cmp != 0) {
            return cmp;
        }
        return super.compareTo(o);
    }

    @Override
    public boolean weakenHardPreferences() {
        return true;
    }

    @Override
    @Transient
    public Preference.Type getType() {
        return Preference.Type.INSTRUCTOR;
    }
}

