/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.instructors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.springframework.stereotype.Service;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.PDFPrinter;
import org.unitime.timetable.export.instructors.TeachingAssignmentsExportCSV;
import org.unitime.timetable.gwt.client.instructor.TeachingAssignmentsPage;
import org.unitime.timetable.gwt.client.instructor.TeachingAssignmentsTable;
import org.unitime.timetable.gwt.shared.InstructorInterface;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.webutil.RequiredTimeTable;

@Service(value="org.unitime.timetable.export.Exporter:teaching-assignments.pdf")
public class TeachingAssignmentsExportPDF
extends TeachingAssignmentsExportCSV {
    @Override
    public String reference() {
        return "teaching-assignments.pdf";
    }

    @Override
    protected void export(InstructorInterface.TeachingAssignmentsPageRequest request, List<TeachingAssignmentsPage.SingleTeachingAssingment> list, ExportHelper helper, boolean hasRequests, int cookie) throws IOException {
        PDFPrinter out = new PDFPrinter(helper.getOutputStream(), false);
        helper.setup(out.getContentType(), this.reference(), false);
        ArrayList<TeachingAssignmentsExportCSV.Column> columns = new ArrayList<TeachingAssignmentsExportCSV.Column>();
        for (TeachingAssignmentsTable.COLUMN column : TeachingAssignmentsTable.COLUMN.values()) {
            int nrCells = this.getNbrCells(column);
            for (int idx = 0; idx < nrCells; ++idx) {
                TeachingAssignmentsExportCSV.Column c = new TeachingAssignmentsExportCSV.Column(column, idx);
                if (!this.isColumnVisible(c, hasRequests, cookie)) continue;
                columns.add(c);
            }
        }
        String[] header = new String[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            header[i] = this.getColumnName((TeachingAssignmentsExportCSV.Column)columns.get(i)).replace("<br>", "\n");
        }
        out.printHeader(header);
        out.flush();
        boolean vertical = true;
        vertical = helper.getParameter("vertical") != null ? "1".equals(helper.getParameter("vertical")) : RequiredTimeTable.getTimeGridVertical(helper.getSessionContext().getUser());
        String mode = helper.getParameter("mode");
        if (mode == null) {
            mode = RequiredTimeTable.getTimeGridSize(helper.getSessionContext().getUser());
        }
        boolean grid = true;
        grid = helper.getParameter("grid") != null ? "1".equals(helper.getParameter("grid")) : !RequiredTimeTable.getTimeGridAsText(helper.getSessionContext().getUser());
        InstructorInterface.InstructorInfo last = null;
        for (TeachingAssignmentsPage.SingleTeachingAssingment a : list) {
            int i;
            PDFPrinter.A[] row = new PDFPrinter.A[columns.size()];
            if (last != null && last.equals(a.getInstructor())) {
                for (i = 0; i < columns.size(); ++i) {
                    if (((TeachingAssignmentsExportCSV.Column)columns.get(i)).getColumn().isHasRequest()) {
                        row[i] = this.getPdfCell(a.getRequest(), a.getInstructor(), (TeachingAssignmentsExportCSV.Column)columns.get(i), grid, vertical, mode);
                        if (row[i] == null) {
                            row[i] = new PDFPrinter.A();
                        }
                    } else {
                        row[i] = new PDFPrinter.A();
                    }
                    row[i].set(PDFPrinter.F.NOSEPARATOR);
                }
            } else {
                for (i = 0; i < columns.size(); ++i) {
                    row[i] = this.getPdfCell(a.getRequest(), a.getInstructor(), (TeachingAssignmentsExportCSV.Column)columns.get(i), grid, vertical, mode);
                }
            }
            out.printLine(row);
            out.flush();
            last = a.getInstructor();
        }
        if (list.isEmpty()) {
            out.printLine(new PDFPrinter.A(MESSAGES.errorNoData(), PDFPrinter.F.ITALIC).color("#FF0000"));
        }
        out.flush();
        out.close();
    }

    public PDFPrinter.A getPdfCell(InstructorInterface.TeachingRequestInfo request, InstructorInterface.InstructorInfo instructor, TeachingAssignmentsExportCSV.Column column, boolean grid, boolean vertical, String mode) {
        switch (column.getColumn()) {
            case COURSE: {
                if (request == null) {
                    return null;
                }
                return new PDFPrinter.A(request.getCourse().getCourseName(), new PDFPrinter.F[0]);
            }
            case SECTION: {
                if (request == null) {
                    return null;
                }
                PDFPrinter.A sections = new PDFPrinter.A();
                for (InstructorInterface.SectionInfo s : request.getSections()) {
                    if (s.isCommon()) {
                        sections.add(new PDFPrinter.A(s.getSectionType() + (String)(s.getExternalId() == null ? "" : " " + s.getExternalId()), PDFPrinter.F.ITALIC));
                        continue;
                    }
                    sections.add(new PDFPrinter.A(s.getSectionType() + (String)(s.getExternalId() == null ? "" : " " + s.getExternalId()), new PDFPrinter.F[0]));
                }
                return sections;
            }
            case TIME: {
                if (request == null) {
                    return null;
                }
                PDFPrinter.A times = new PDFPrinter.A();
                for (InstructorInterface.SectionInfo s : request.getSections()) {
                    if (s.isCommon()) {
                        times.add(new PDFPrinter.A(s.getTime() == null ? SECTMSG.arrangeHours() : s.getTime(), PDFPrinter.F.ITALIC));
                        continue;
                    }
                    times.add(new PDFPrinter.A(s.getTime() == null ? SECTMSG.arrangeHours() : s.getTime(), new PDFPrinter.F[0]));
                }
                return times;
            }
            case DATE: {
                if (request == null) {
                    return null;
                }
                PDFPrinter.A dates = new PDFPrinter.A();
                for (InstructorInterface.SectionInfo s : request.getSections()) {
                    if (s.isCommon()) {
                        dates.add(new PDFPrinter.A(s.getDate() == null ? SECTMSG.noDate() : s.getDate(), PDFPrinter.F.ITALIC));
                        continue;
                    }
                    dates.add(new PDFPrinter.A(s.getDate() == null ? SECTMSG.noDate() : s.getDate(), new PDFPrinter.F[0]));
                }
                return dates;
            }
            case ROOM: {
                if (request == null) {
                    return null;
                }
                PDFPrinter.A rooms = new PDFPrinter.A();
                for (InstructorInterface.SectionInfo s : request.getSections()) {
                    if (s.isCommon()) {
                        rooms.add(new PDFPrinter.A(s.getRoom() == null ? SECTMSG.noRoom() : s.getRoom(), PDFPrinter.F.ITALIC));
                        continue;
                    }
                    rooms.add(new PDFPrinter.A(s.getRoom() == null ? SECTMSG.noRoom() : s.getRoom(), new PDFPrinter.F[0]));
                }
                return rooms;
            }
            case EXTERNAL_ID: {
                if (instructor == null || instructor.getExternalId() == null) {
                    return null;
                }
                PDFPrinter.A extId = new PDFPrinter.A(instructor.getExternalId(), new PDFPrinter.F[0]);
                if (instructor.getTeachingPreference() != null && !"0".equals(instructor.getTeachingPreference())) {
                    extId.setColor(PreferenceLevel.prolog2color(instructor.getTeachingPreference()));
                }
                return extId;
            }
            case NAME: {
                if (instructor == null || instructor.getInstructorName() == null) {
                    return null;
                }
                PDFPrinter.A name = new PDFPrinter.A(instructor.getInstructorName(), new PDFPrinter.F[0]);
                if (instructor.getTeachingPreference() != null && !"0".equals(instructor.getTeachingPreference())) {
                    name.setColor(PreferenceLevel.prolog2color(instructor.getTeachingPreference()));
                }
                return name;
            }
            case ATTRIBUTE_PREFS: {
                if (request == null) {
                    return null;
                }
                return this.pdfPreferences(request.getAttributePreferences());
            }
            case INSTRUCTOR_PREFS: {
                if (request == null) {
                    return null;
                }
                return this.pdfPreferences(request.getInstructorPreferences());
            }
            case COURSE_PREF: {
                if (instructor == null) {
                    return null;
                }
                return this.pdfPreferences(instructor.getCoursePreferences());
            }
            case DISTRIBUTION_PREF: {
                if (instructor == null) {
                    return null;
                }
                return this.pdfPreferences(instructor.getDistributionPreferences());
            }
            case TIME_PREF: {
                if (instructor == null) {
                    return null;
                }
                if (grid && instructor.getAvailability() != null && !instructor.getAvailability().isEmpty()) {
                    RequiredTimeTable rtt = new RequiredTimeTable(new TimePattern().getTimePatternModel());
                    rtt.getModel().setPreferences(instructor.getAvailability());
                    try {
                        rtt.getModel().setDefaultSelection(Integer.parseInt(mode));
                    }
                    catch (NumberFormatException e) {
                        rtt.getModel().setDefaultSelection(mode);
                    }
                    return new PDFPrinter.A(rtt.createBufferedImage(vertical, false));
                }
                return this.pdfPreferences(instructor.getTimePreferences());
            }
            case ATTRIBUTES: {
                if (instructor == null) {
                    return null;
                }
                PDFPrinter.A attributes = new PDFPrinter.A();
                for (InstructorInterface.AttributeInterface attribute : instructor.getAttributes()) {
                    attributes.add(new PDFPrinter.A(attribute.getName() + (String)(attribute.hasType() ? " (" + attribute.getType().getLabel() + ")" : ""), new PDFPrinter.F[0]));
                }
                return attributes;
            }
            case OBJECTIVES: {
                if (request == null) {
                    return null;
                }
                PDFPrinter.A objectives = new PDFPrinter.A();
                for (String key : new TreeSet<String>(request.getValues().keySet())) {
                    Double value = request.getValues().get(key);
                    if (value == null || Math.abs(value) < 0.001) continue;
                    PDFPrinter.A obj = new PDFPrinter.A(key + ": " + (value > 0.0 ? "+" : "") + Formats.getNumberFormat(CONSTANTS.teachingLoadFormat()).format(value), new PDFPrinter.F[0]);
                    if (key.endsWith(" Preferences")) {
                        if (value <= -50.0) {
                            obj.setColor(PreferenceLevel.prolog2color("R"));
                        } else if (value <= -2.0) {
                            obj.setColor(PreferenceLevel.prolog2color("-2"));
                        } else if (value < 0.0) {
                            obj.setColor(PreferenceLevel.prolog2color("-1"));
                        } else if (value >= 50.0) {
                            obj.setColor(PreferenceLevel.prolog2color("P"));
                        } else if (value >= 2.0) {
                            obj.setColor(PreferenceLevel.prolog2color("2"));
                        } else if (value > 0.0) {
                            obj.setColor(PreferenceLevel.prolog2color("1"));
                        }
                    } else if (value < 0.0) {
                        obj.setColor("#0f821e");
                    } else if (value > 0.0) {
                        obj.setColor("#c81e14");
                    }
                    objectives.add(obj);
                }
                return objectives;
            }
        }
        return new PDFPrinter.A(this.getCell(request, instructor, column), new PDFPrinter.F[0]);
    }

    public PDFPrinter.A pdfPreferences(List<InstructorInterface.PreferenceInfo> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        PDFPrinter.A ret = new PDFPrinter.A();
        for (InstructorInterface.PreferenceInfo pref : list) {
            ret.add(new PDFPrinter.A(pref.getOwnerName(), new PDFPrinter.F[0]).color(PreferenceLevel.prolog2color(pref.getPreference())));
        }
        return ret;
    }
}

