/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.instructors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.export.PDFPrinter;
import org.unitime.timetable.export.XLSPrinter;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.InstructorCourseRequirement;
import org.unitime.timetable.model.InstructorCourseRequirementNote;
import org.unitime.timetable.model.InstructorCourseRequirementType;
import org.unitime.timetable.model.InstructorSurvey;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.TimePatternModel;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.ClassInstructorComparator;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.service.AssignmentService;
import org.unitime.timetable.solver.ui.AssignmentPreferenceInfo;
import org.unitime.timetable.spring.SpringApplicationContextHolder;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;

@Service(value="org.unitime.timetable.export.Exporter:instructor-surveys.xls")
public class InstructorSurveysXLS
implements Exporter {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    protected static final CourseMessages CMSG = Localization.create(CourseMessages.class);
    protected static final StudentSectioningMessages SECTMSG = Localization.create(StudentSectioningMessages.class);
    protected static final GwtConstants CONSTANTS = Localization.create(GwtConstants.class);

    @Override
    public String reference() {
        return "instructor-surveys.xls";
    }

    @Override
    public void export(ExportHelper helper) throws IOException {
        String dept = helper.getParameter("department");
        if (dept == null) {
            throw new IllegalArgumentException("Department not provided or not found.");
        }
        Department department = null;
        try {
            department = (Department)DepartmentDAO.getInstance().get(Long.valueOf(dept));
        }
        catch (Exception e) {
            department = Department.findByDeptCode(dept, helper.getAcademicSessionId());
        }
        if (department == null) {
            throw new IllegalArgumentException("Department '" + dept + "' not found.");
        }
        helper.getSessionContext().checkPermission(department, Right.InstructorSurveyAdmin);
        Map<String, InstructorSurvey> surveys = InstructorSurvey.getInstructorSurveysForDepartment(department.getUniqueId());
        if (surveys == null || surveys.isEmpty()) {
            throw new IllegalArgumentException("There are no instructor surveys filled in for " + department.getLabel() + ".");
        }
        XLSPrinter printer = new XLSPrinter(helper.getOutputStream(), false);
        helper.setup(printer.getContentType(), department.getDeptCode() + " " + this.reference(), false);
        printer.getWorkbook().setSheetName(printer.getSheetIndex(), MESSAGES.sectGeneralPreferences());
        printer.printHeader(MESSAGES.colExternalId(), MESSAGES.colNamePerson(), MESSAGES.colRequestedTimePrefs(), MESSAGES.colRequestedRoomPrefs(), MESSAGES.colRequestedDistPrefs(), MESSAGES.colRequestedOtherPrefs(), CMSG.columnInstrSurveyPDF(), MESSAGES.colTimePreferences().replace("<br>", "\n"), MESSAGES.colRoomPreferences().replace("<br>", "\n"), MESSAGES.colDistributionPreferences().replace("<br>", "\n"));
        printer.flush();
        ArrayList<DepartmentalInstructor> instructors = new ArrayList<DepartmentalInstructor>(DepartmentalInstructor.findInstructorsForDepartment(department.getUniqueId()));
        final String instructorNameFormat = helper.getSessionContext().getUser().getProperty(UserProperty.NameFormat);
        Collections.sort(instructors, new Comparator<DepartmentalInstructor>(){

            @Override
            public int compare(DepartmentalInstructor i1, DepartmentalInstructor i2) {
                String n2;
                String n1 = i1.getName(instructorNameFormat);
                int cmp = n1.compareTo(n2 = i2.getName(instructorNameFormat));
                if (cmp != 0) {
                    return cmp;
                }
                cmp = (i1.getExternalUniqueId() == null ? "" : i1.getExternalUniqueId()).compareTo(i2.getExternalUniqueId() == null ? "" : i2.getExternalUniqueId());
                if (cmp != 0) {
                    return cmp;
                }
                return i1.compareTo(i2);
            }
        });
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_TIME_STAMP);
        for (DepartmentalInstructor instructor : instructors) {
            InstructorSurvey survey;
            if (instructor.getExternalUniqueId() == null || (survey = surveys.get(instructor.getExternalUniqueId())) == null) continue;
            PDFPrinter.A extId = new PDFPrinter.A(instructor.getExternalUniqueId(), new PDFPrinter.F[0]);
            PDFPrinter.A name = new PDFPrinter.A(instructor.getName(instructorNameFormat), new PDFPrinter.F[0]);
            ArrayList<PDFPrinter.A> time = new ArrayList<PDFPrinter.A>();
            ArrayList<PDFPrinter.A> room = new ArrayList<PDFPrinter.A>();
            ArrayList<PDFPrinter.A> dist = new ArrayList<PDFPrinter.A>();
            ArrayList<PDFPrinter.A> itime = new ArrayList<PDFPrinter.A>();
            ArrayList<PDFPrinter.A> iroom = new ArrayList<PDFPrinter.A>();
            ArrayList<PDFPrinter.A> idist = new ArrayList<PDFPrinter.A>();
            this.addPreferences(time, room, dist, instructor, survey.getPreferences(), instructor.getPreferences(), instructorNameFormat);
            this.addPreferences(itime, iroom, idist, instructor, instructor.getPreferences(), survey.getPreferences(), instructorNameFormat);
            PDFPrinter.A other = new PDFPrinter.A(survey.getNote() == null ? "" : survey.getNote(), new PDFPrinter.F[0]);
            PDFPrinter.A is = null;
            if (survey.getSubmitted() != null) {
                is = new PDFPrinter.A(df.format(survey.getSubmitted()), new PDFPrinter.F[0]);
            } else {
                is = new PDFPrinter.A(CMSG.instrSurveyNotSubmitted(), new PDFPrinter.F[0]);
                is.setColor("#dcb414");
            }
            printer.printLine(extId, name, new PDFPrinter.A(time), new PDFPrinter.A(room), new PDFPrinter.A(dist), other, is, new PDFPrinter.A(itime), new PDFPrinter.A(iroom), new PDFPrinter.A(idist));
            printer.flush();
        }
        printer.newSheet();
        printer.getWorkbook().setSheetName(printer.getSheetIndex(), MESSAGES.sectCoursePreferences());
        final List<InstructorCourseRequirementType> types = InstructorCourseRequirementType.getInstructorCourseRequirementTypes();
        int nrCols = 0;
        int colExtId = nrCols++;
        int colName = nrCols++;
        int colRTime = nrCols++;
        int colRRoom = nrCols++;
        int colRDist = nrCols++;
        int colROther = nrCols++;
        int colSurv = nrCols++;
        int colCourse = nrCols++;
        int colReq = nrCols;
        nrCols += types.size();
        int colClass = nrCols++;
        int colTime = nrCols++;
        int colRoom = nrCols++;
        int colDist = nrCols++;
        int colATime = nrCols++;
        int colARoom = nrCols++;
        String[] head = new String[nrCols];
        head[colExtId] = MESSAGES.colExternalId();
        head[colName] = MESSAGES.colNamePerson();
        head[colRTime] = MESSAGES.colRequestedTimePrefs();
        head[colRRoom] = MESSAGES.colRequestedRoomPrefs();
        head[colRDist] = MESSAGES.colRequestedDistPrefs();
        head[colROther] = MESSAGES.colRequestedOtherPrefs();
        head[colSurv] = CMSG.columnInstrSurveyPDF();
        head[colCourse] = MESSAGES.colCourse();
        for (int i = 0; i < types.size(); ++i) {
            head[colReq + i] = types.get(i).getReference();
        }
        head[colClass] = CMSG.columnClass();
        head[colTime] = CMSG.columnTimePref();
        head[colRoom] = CMSG.columnRoomPref();
        head[colDist] = CMSG.columnDistributionPref();
        head[colATime] = CMSG.columnAssignedTime();
        head[colARoom] = CMSG.columnAssignedRoom();
        printer.printHeader(head);
        printer.flush();
        ClassAssignmentProxy classAssignment = this.getClassAssignmentService().getAssignment();
        for (DepartmentalInstructor instructor : instructors) {
            PDFPrinter.A[] line;
            InstructorSurvey survey;
            if (instructor.getExternalUniqueId() == null || (survey = surveys.get(instructor.getExternalUniqueId())) == null) continue;
            ArrayList<InstructorCourseRequirement> reqs = new ArrayList<InstructorCourseRequirement>(survey.getCourseRequirements());
            Collections.sort(reqs, new Comparator<InstructorCourseRequirement>(){

                @Override
                public int compare(InstructorCourseRequirement o1, InstructorCourseRequirement o2) {
                    String c2;
                    String c1 = o1.getCourseOffering() != null ? o1.getCourseOffering().getCourseName() : o1.getCourse();
                    int cmp = c1.compareTo(c2 = o2.getCourseOffering() != null ? o2.getCourseOffering().getCourseName() : o2.getCourse());
                    if (cmp != 0) {
                        return cmp;
                    }
                    for (InstructorCourseRequirementType type : types) {
                        InstructorCourseRequirementNote n2;
                        InstructorCourseRequirementNote n1 = o1.getNote(type);
                        cmp = (n1 == null ? "" : n1.getNote()).compareTo((n2 = o1.getNote(type)) == null ? "" : n2.getNote());
                        if (cmp == 0) continue;
                        return cmp;
                    }
                    return o1.getUniqueId().compareTo(o2.getUniqueId());
                }
            });
            int firstRowIns = -1;
            int firstRowCrs = -1;
            String prevCourse = null;
            Iterator classIterator = null;
            ArrayList<ClassInstructor> allClasses = new ArrayList<ClassInstructor>(instructor.getClasses().size());
            for (ClassInstructor ci : instructor.getClasses()) {
                if (!ci.isLead().booleanValue() || ci.getClassInstructing().isCancelled().booleanValue()) continue;
                allClasses.add(ci);
            }
            Collections.sort(allClasses, new ClassInstructorComparator(new ClassComparator(5)));
            if (survey.getCourseRequirements().isEmpty() && allClasses.isEmpty()) continue;
            for (InstructorCourseRequirement req : reqs) {
                String course;
                line = new PDFPrinter.A[nrCols];
                String string = course = req.getCourseOffering() != null ? req.getCourseOffering().getCourseName() : req.getCourse();
                if (firstRowIns < 0) {
                    firstRowIns = printer.getRow();
                    line[colExtId] = new PDFPrinter.A(instructor.getExternalUniqueId(), new PDFPrinter.F[0]);
                    line[colName] = new PDFPrinter.A(instructor.getName(instructorNameFormat), new PDFPrinter.F[0]);
                    if (survey.getSubmitted() != null) {
                        line[colSurv] = new PDFPrinter.A(df.format(survey.getSubmitted()), new PDFPrinter.F[0]);
                    } else {
                        line[colSurv] = new PDFPrinter.A(CMSG.instrSurveyNotSubmitted(), new PDFPrinter.F[0]);
                        line[colSurv].setColor("#dcb414");
                    }
                    ArrayList<PDFPrinter.A> time = new ArrayList<PDFPrinter.A>();
                    ArrayList<PDFPrinter.A> room = new ArrayList<PDFPrinter.A>();
                    ArrayList<PDFPrinter.A> dist = new ArrayList<PDFPrinter.A>();
                    this.addPreferences(time, room, dist, instructor, survey.getPreferences(), instructorNameFormat);
                    PDFPrinter.A other = new PDFPrinter.A(survey.getNote() == null ? "" : survey.getNote(), new PDFPrinter.F[0]);
                    line[colRTime] = new PDFPrinter.A(time);
                    line[colRRoom] = new PDFPrinter.A(room);
                    line[colRDist] = new PDFPrinter.A(dist);
                    line[colROther] = other;
                }
                if (prevCourse == null || !course.equals(prevCourse)) {
                    if (classIterator != null && classIterator.hasNext()) {
                        int lastRowCrs = printer.getRow() - 1;
                        while (classIterator.hasNext()) {
                            ClassInstructor ci = (ClassInstructor)classIterator.next();
                            PDFPrinter.A[] x = new PDFPrinter.A[nrCols];
                            this.fillClassInfo(x, ci, colClass, instructorNameFormat, classAssignment);
                            printer.printLine(x);
                        }
                        if (lastRowCrs < printer.getRow() - 1) {
                            for (int i = 0; i < types.size(); ++i) {
                                printer.getSheet().addMergedRegion(new CellRangeAddress(lastRowCrs, printer.getRow() - 1, colReq + i, colReq + i));
                            }
                        }
                    }
                    if (firstRowCrs >= 0 && firstRowCrs < printer.getRow() - 1) {
                        printer.getSheet().addMergedRegion(new CellRangeAddress(firstRowCrs, printer.getRow() - 1, colCourse, colCourse));
                    }
                    prevCourse = course;
                    classIterator = null;
                    if (req.getCourseOffering() != null) {
                        ArrayList<ClassInstructor> classes = new ArrayList<ClassInstructor>();
                        Iterator i = allClasses.iterator();
                        while (i.hasNext()) {
                            ClassInstructor ci = (ClassInstructor)i.next();
                            if (!ci.isLead().booleanValue() || !ci.getClassInstructing().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getCourseOfferings().contains(req.getCourseOffering())) continue;
                            classes.add(ci);
                            i.remove();
                        }
                        classIterator = classes.iterator();
                    }
                    firstRowCrs = printer.getRow();
                    if (req.getCourseOffering() == null) {
                        line[colCourse] = new PDFPrinter.A(req.getCourse(), new PDFPrinter.F[0]);
                    } else {
                        String title = req.getCourseOffering().getTitle();
                        if (title != null && !title.isEmpty()) {
                            PDFPrinter.A t = new PDFPrinter.A("  " + title, new PDFPrinter.F[0]);
                            t.setColor("#808B96");
                            line[colCourse] = new PDFPrinter.A(new PDFPrinter.A(req.getCourseOffering().getCourseName(), new PDFPrinter.F[0]), t);
                        } else {
                            line[colCourse] = new PDFPrinter.A(req.getCourseOffering().getCourseName(), new PDFPrinter.F[0]);
                        }
                    }
                }
                for (int i = 0; i < types.size(); ++i) {
                    InstructorCourseRequirementNote n = req.getNote(types.get(i));
                    line[colReq + i] = new PDFPrinter.A(n == null ? "" : n.getNote(), new PDFPrinter.F[0]);
                }
                if (classIterator != null && classIterator.hasNext()) {
                    ClassInstructor ci = (ClassInstructor)classIterator.next();
                    this.fillClassInfo(line, ci, colClass, instructorNameFormat, classAssignment);
                }
                printer.printLine(line);
            }
            if (classIterator != null && classIterator.hasNext()) {
                int lastRowCrs = printer.getRow() - 1;
                while (classIterator.hasNext()) {
                    ClassInstructor ci;
                    ci = (ClassInstructor)classIterator.next();
                    PDFPrinter.A[] x = new PDFPrinter.A[nrCols];
                    this.fillClassInfo(x, ci, colClass, instructorNameFormat, classAssignment);
                    printer.printLine(x);
                }
                if (lastRowCrs < printer.getRow() - 1) {
                    for (int i = 0; i < types.size(); ++i) {
                        printer.getSheet().addMergedRegion(new CellRangeAddress(lastRowCrs, printer.getRow() - 1, colReq + i, colReq + i));
                    }
                }
            }
            if (firstRowCrs >= 0 && firstRowCrs < printer.getRow() - 1) {
                printer.getSheet().addMergedRegion(new CellRangeAddress(firstRowCrs, printer.getRow() - 1, colCourse, colCourse));
            }
            if (!allClasses.isEmpty()) {
                firstRowCrs = -1;
                for (ClassInstructor ci : allClasses) {
                    line = new PDFPrinter.A[nrCols];
                    if (firstRowIns < 0) {
                        firstRowIns = printer.getRow();
                        line[colExtId] = new PDFPrinter.A(instructor.getExternalUniqueId(), new PDFPrinter.F[0]);
                        line[colName] = new PDFPrinter.A(instructor.getName(instructorNameFormat), new PDFPrinter.F[0]);
                        if (survey.getSubmitted() != null) {
                            line[colSurv] = new PDFPrinter.A(df.format(survey.getSubmitted()), new PDFPrinter.F[0]);
                        } else {
                            line[colSurv] = new PDFPrinter.A(CMSG.instrSurveyNotSubmitted(), new PDFPrinter.F[0]);
                            line[colSurv].setColor("#dcb414");
                        }
                        ArrayList<PDFPrinter.A> time = new ArrayList<PDFPrinter.A>();
                        ArrayList<PDFPrinter.A> room = new ArrayList<PDFPrinter.A>();
                        ArrayList<PDFPrinter.A> dist = new ArrayList<PDFPrinter.A>();
                        this.addPreferences(time, room, dist, instructor, survey.getPreferences(), instructorNameFormat);
                        PDFPrinter.A other = new PDFPrinter.A(survey.getNote() == null ? "" : survey.getNote(), new PDFPrinter.F[0]);
                        line[colRTime] = new PDFPrinter.A(time);
                        line[colRRoom] = new PDFPrinter.A(room);
                        line[colRDist] = new PDFPrinter.A(dist);
                        line[colROther] = other;
                    }
                    if (firstRowCrs < 0) {
                        firstRowCrs = printer.getRow();
                        line[colCourse] = new PDFPrinter.A(CMSG.courseOtherInstructorClasses(), new PDFPrinter.F[0]);
                    }
                    this.fillClassInfo(line, ci, colClass, instructorNameFormat, classAssignment);
                    printer.printLine(line);
                }
                printer.getSheet().addMergedRegion(new CellRangeAddress(firstRowCrs, printer.getRow() - 1, colCourse, colCourse + types.size()));
            }
            if (firstRowCrs >= 0 && firstRowCrs < printer.getRow() - 1) {
                printer.getSheet().addMergedRegion(new CellRangeAddress(firstRowIns, printer.getRow() - 1, colExtId, colExtId));
                printer.getSheet().addMergedRegion(new CellRangeAddress(firstRowIns, printer.getRow() - 1, colName, colName));
                printer.getSheet().addMergedRegion(new CellRangeAddress(firstRowIns, printer.getRow() - 1, colSurv, colSurv));
                printer.getSheet().addMergedRegion(new CellRangeAddress(firstRowIns, printer.getRow() - 1, colRTime, colRTime));
                printer.getSheet().addMergedRegion(new CellRangeAddress(firstRowIns, printer.getRow() - 1, colRRoom, colRRoom));
                printer.getSheet().addMergedRegion(new CellRangeAddress(firstRowIns, printer.getRow() - 1, colRDist, colRDist));
                printer.getSheet().addMergedRegion(new CellRangeAddress(firstRowIns, printer.getRow() - 1, colROther, colROther));
            }
            printer.flush();
        }
        printer.close();
    }

    protected AssignmentService<ClassAssignmentProxy> getClassAssignmentService() {
        return (AssignmentService)SpringApplicationContextHolder.getBean("classAssignmentService");
    }

    /*
     * WARNING - void declaration
     */
    protected void fillClassInfo(PDFPrinter.A[] line, ClassInstructor ci, int colClass, String instructorNameFormat, ClassAssignmentProxy classAssignment) {
        PDFPrinter.A a;
        line[colClass + 0] = new PDFPrinter.A(ci.getClassInstructing().getClassLabel(ApplicationProperty.DistributionsShowClassSufix.isTrue()), new PDFPrinter.F[0]);
        ArrayList<PDFPrinter.A> time = new ArrayList<PDFPrinter.A>();
        ArrayList<PDFPrinter.A> room = new ArrayList<PDFPrinter.A>();
        ArrayList<PDFPrinter.A> dist = new ArrayList<PDFPrinter.A>();
        for (RoomPref roomPref : ci.getClassInstructing().effectivePreferences(RoomPref.class)) {
            a = new PDFPrinter.A(roomPref.getPrefLevel().getPrefAbbv() + " " + roomPref.preferenceAbbv(instructorNameFormat), new PDFPrinter.F[0]);
            a.setColor(PreferenceLevel.prolog2color(roomPref.getPrefLevel().getPrefProlog()));
            room.add(a);
        }
        for (RoomGroupPref roomGroupPref : ci.getClassInstructing().effectivePreferences(RoomGroupPref.class)) {
            a = new PDFPrinter.A(roomGroupPref.getPrefLevel().getPrefAbbv() + " " + roomGroupPref.preferenceAbbv(instructorNameFormat), new PDFPrinter.F[0]);
            a.setColor(PreferenceLevel.prolog2color(roomGroupPref.getPrefLevel().getPrefProlog()));
            room.add(a);
        }
        for (RoomFeaturePref roomFeaturePref : ci.getClassInstructing().effectivePreferences(RoomFeaturePref.class)) {
            a = new PDFPrinter.A(roomFeaturePref.getPrefLevel().getPrefAbbv() + " " + roomFeaturePref.preferenceAbbv(instructorNameFormat), new PDFPrinter.F[0]);
            a.setColor(PreferenceLevel.prolog2color(roomFeaturePref.getPrefLevel().getPrefProlog()));
            room.add(a);
        }
        for (BuildingPref buildingPref : ci.getClassInstructing().effectivePreferences(BuildingPref.class)) {
            a = new PDFPrinter.A(buildingPref.getPrefLevel().getPrefAbbv() + " " + buildingPref.preferenceAbbv(instructorNameFormat), new PDFPrinter.F[0]);
            a.setColor(PreferenceLevel.prolog2color(buildingPref.getPrefLevel().getPrefProlog()));
            room.add(a);
        }
        for (TimePref timePref : ci.getClassInstructing().effectivePreferences(TimePref.class)) {
            TimePatternModel m = timePref.getTimePatternModel();
            time.add(new PDFPrinter.A(timePref.getTimePattern().getName(), new PDFPrinter.F[0]));
            time.addAll(this.timePrefToA(m));
        }
        for (DistributionPref distributionPref : ci.getClassInstructing().effectivePreferences(DistributionPref.class)) {
            PDFPrinter.A a3 = new PDFPrinter.A(distributionPref.getPrefLevel().getPrefAbbv() + " " + distributionPref.preferenceAbbv(instructorNameFormat), new PDFPrinter.F[0]);
            a3.setColor(PreferenceLevel.prolog2color(distributionPref.getPrefLevel().getPrefProlog()));
            dist.add(a3);
        }
        line[colClass + 1] = new PDFPrinter.A(time);
        line[colClass + 2] = new PDFPrinter.A(room);
        line[colClass + 3] = new PDFPrinter.A(dist);
        if (classAssignment != null) {
            void var10_23;
            ClassAssignmentProxy.AssignmentInfo a2 = null;
            Object var10_21 = null;
            try {
                a2 = classAssignment.getAssignment(ci.getClassInstructing());
                AssignmentPreferenceInfo assignmentPreferenceInfo = classAssignment.getAssignmentInfo(ci.getClassInstructing());
            }
            catch (Exception a3) {
                // empty catch block
            }
            if (a2 != null && var10_23 != null && a2.getTimeLocation() != null) {
                line[colClass + 4] = new PDFPrinter.A(a2.getTimeLocation().getLongName(CONSTANTS.useAmPm()), new PDFPrinter.F[0]);
                if (var10_23.getTimePreference() != Constants.sPreferenceLevelNeutral) {
                    line[colClass + 4].setColor(PreferenceLevel.int2color(var10_23.getTimePreference()));
                }
            }
            if (a2 != null && var10_23 != null && a2.getRooms() != null && !a2.getRooms().isEmpty()) {
                ArrayList<PDFPrinter.A> rx = new ArrayList<PDFPrinter.A>();
                for (Location r : a2.getRooms()) {
                    PDFPrinter.A ax = new PDFPrinter.A(r.getLabel(), new PDFPrinter.F[0]);
                    if (var10_23.getRoomPreference(r.getUniqueId()) != Constants.sPreferenceLevelNeutral) {
                        ax.setColor(PreferenceLevel.int2color(var10_23.getRoomPreference(r.getUniqueId())));
                    }
                    rx.add(ax);
                }
                line[colClass + 5] = new PDFPrinter.A(rx);
            }
        }
    }

    protected List<PDFPrinter.A> timePrefToA(TimePatternModel m, TimePref pref, TimePref other) {
        List<PDFPrinter.A> ret = this.timePrefToA(m);
        if (other != null) {
            for (PDFPrinter.A a : ret) {
                boolean match = false;
                TimePatternModel x = other.getTimePatternModel();
                x.setMode("|" + ApplicationProperty.InstructorSurveyTimePreferences.value());
                for (PDFPrinter.A b : this.timePrefToA(x)) {
                    if (!a.equals(b)) continue;
                    match = true;
                }
                if (match) continue;
                a.set(PDFPrinter.F.UNDERLINE);
            }
        } else {
            for (PDFPrinter.A a : ret) {
                a.set(PDFPrinter.F.UNDERLINE);
            }
        }
        return ret;
    }

    protected void addPreference(List<PDFPrinter.A> ret, Preference pref, PreferenceLevel instructorPref, String instructorNameFormat) {
        PDFPrinter.A a = new PDFPrinter.A(pref.getPrefLevel().getPrefName() + " " + pref.preferenceText(instructorNameFormat), new PDFPrinter.F[0]);
        a.setColor(PreferenceLevel.prolog2color(pref.getPrefLevel().getPrefProlog()));
        if (instructorPref == null) {
            a.set(PDFPrinter.F.UNDERLINE);
        } else if (PreferenceLevel.prolog2int(instructorPref.getPrefProlog()) != PreferenceLevel.prolog2int(pref.getPrefLevel().getPrefProlog())) {
            a.set(PDFPrinter.F.UNDERLINE);
        }
        ret.add(a);
        if (pref.getPrefLevel().isHard() && pref.getNote() != null && !pref.getNote().isEmpty()) {
            ret.add(new PDFPrinter.A(" - " + pref.getNote(), new PDFPrinter.F[0]));
        }
    }

    protected void addPreference(List<PDFPrinter.A> ret, Preference pref, String instructorNameFormat) {
        PDFPrinter.A a = new PDFPrinter.A((String)(pref.getPrefLevel().getPrefAbbv() == null || pref.getPrefLevel().getPrefAbbv().isEmpty() ? "" : pref.getPrefLevel().getPrefAbbv() + " ") + pref.preferenceText(instructorNameFormat), new PDFPrinter.F[0]);
        a.setColor(PreferenceLevel.prolog2color(pref.getPrefLevel().getPrefProlog()));
        ret.add(a);
        if (pref.getPrefLevel().isHard() && pref.getNote() != null && !pref.getNote().isEmpty()) {
            ret.add(new PDFPrinter.A(" - " + pref.getNote(), new PDFPrinter.F[0]));
        }
    }

    protected boolean applies(DepartmentalInstructor instructor, Preference pref) {
        if (pref instanceof RoomPref && !instructor.getAvailableRooms().contains(((RoomPref)pref).getRoom())) {
            return false;
        }
        if (pref instanceof RoomGroupPref && !instructor.getAvailableRoomGroups().contains(((RoomGroupPref)pref).getRoomGroup())) {
            return false;
        }
        if (pref instanceof RoomFeaturePref && !instructor.getAvailableRoomFeatures().contains(((RoomFeaturePref)pref).getRoomFeature())) {
            return false;
        }
        return !(pref instanceof BuildingPref) || instructor.getAvailableBuildings().contains(((BuildingPref)pref).getBuilding());
    }

    protected boolean match(Preference p1, Preference p2) {
        if (p1.getType() != p2.getType()) {
            return false;
        }
        if (p1 instanceof RoomPref && ((RoomPref)p1).getRoom().equals(((RoomPref)p2).getRoom())) {
            return true;
        }
        if (p1 instanceof RoomGroupPref && ((RoomGroupPref)p1).getRoomGroup().equals(((RoomGroupPref)p2).getRoomGroup())) {
            return true;
        }
        if (p1 instanceof RoomFeaturePref && ((RoomFeaturePref)p1).getRoomFeature().equals(((RoomFeaturePref)p2).getRoomFeature())) {
            return true;
        }
        if (p1 instanceof BuildingPref && ((BuildingPref)p1).getBuilding().equals(((BuildingPref)p2).getBuilding())) {
            return true;
        }
        if (p1 instanceof DistributionPref && ((DistributionPref)p1).getDistributionType().equals(((DistributionPref)p2).getDistributionType())) {
            return true;
        }
        return p1 instanceof TimePref;
    }

    protected void addPreferences(List<PDFPrinter.A> time, List<PDFPrinter.A> room, List<PDFPrinter.A> dist, DepartmentalInstructor instructor, Collection<Preference> preferences, Collection<Preference> compare, String instructorNameFormat) {
        for (Preference pref : this.sorted(preferences)) {
            if (!this.applies(instructor, pref)) continue;
            Preference otherPref = null;
            PreferenceLevel other = null;
            for (Preference p : compare) {
                if (!this.match(pref, p)) continue;
                otherPref = p;
                other = p.getPrefLevel();
                break;
            }
            if (pref instanceof RoomPref || pref instanceof RoomGroupPref || pref instanceof RoomFeaturePref || pref instanceof BuildingPref) {
                this.addPreference(room, pref, other, instructorNameFormat);
                continue;
            }
            if (pref instanceof TimePref) {
                TimePatternModel m = ((TimePref)pref).getTimePatternModel();
                m.setMode("|" + ApplicationProperty.InstructorSurveyTimePreferences.value());
                time.addAll(this.timePrefToA(m, (TimePref)pref, (TimePref)otherPref));
                if (!m.hasProgibitedPreferences() || pref.getNote() == null || pref.getNote().isEmpty()) continue;
                time.add(new PDFPrinter.A(pref.getNote(), new PDFPrinter.F[0]));
                continue;
            }
            if (!(pref instanceof DistributionPref)) continue;
            this.addPreference(dist, pref, other, instructorNameFormat);
        }
    }

    protected void addPreferences(List<PDFPrinter.A> time, List<PDFPrinter.A> room, List<PDFPrinter.A> dist, DepartmentalInstructor instructor, Collection<Preference> preferences, String instructorNameFormat) {
        for (Preference pref : this.sorted(preferences)) {
            if (!this.applies(instructor, pref)) continue;
            if (pref instanceof RoomPref || pref instanceof RoomGroupPref || pref instanceof RoomFeaturePref || pref instanceof BuildingPref) {
                this.addPreference(room, pref, instructorNameFormat);
                continue;
            }
            if (pref instanceof TimePref) {
                TimePatternModel m = ((TimePref)pref).getTimePatternModel();
                m.setMode("|" + ApplicationProperty.InstructorSurveyTimePreferences.value());
                time.addAll(this.timePrefToA(m));
                if (!m.hasProgibitedPreferences() || pref.getNote() == null || pref.getNote().isEmpty()) continue;
                time.add(new PDFPrinter.A(pref.getNote(), new PDFPrinter.F[0]));
                continue;
            }
            if (!(pref instanceof DistributionPref)) continue;
            this.addPreference(dist, pref, instructorNameFormat);
        }
    }

    protected List<PDFPrinter.A> timePrefToA(TimePatternModel m) {
        int j;
        int i;
        Integer firstDayOfWeek = ApplicationProperty.TimePatternFirstDayOfWeek.intValue();
        ArrayList<PDFPrinter.A> ret = new ArrayList<PDFPrinter.A>();
        if (m.isExactTime()) {
            int days = m.getExactDays();
            int startSlot = m.getExactStartSlot();
            StringBuffer sb = new StringBuffer();
            for (int i2 = 0; i2 < Constants.DAY_CODES.length; ++i2) {
                int j2;
                int n = j2 = firstDayOfWeek == null ? i2 : (i2 + firstDayOfWeek) % 7;
                if ((Constants.DAY_CODES[j2] & days) == 0) continue;
                sb.append(CONSTANTS.shortDays()[j2]);
            }
            sb.append(" ");
            sb.append(Constants.toTime(startSlot * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN));
            ret.add(new PDFPrinter.A(sb.toString(), new PDFPrinter.F[0]));
            return ret;
        }
        boolean canMergeDays = true;
        int i3 = 0;
        while (canMergeDays && i3 + 1 < m.getNrDays()) {
            for (int j3 = i3 + 1; canMergeDays && j3 < m.getNrDays(); ++j3) {
                if ((m.getDayCode(i3) & m.getDayCode(j3)) == 0) continue;
                canMergeDays = false;
            }
            ++i3;
        }
        boolean[][] out = new boolean[m.getNrDays()][m.getNrTimes()];
        for (i = 0; i < m.getNrDays(); ++i) {
            for (j = 0; j < m.getNrTimes(); ++j) {
                out[i][j] = false;
            }
        }
        for (i = 0; i < m.getNrDays(); ++i) {
            for (j = 0; j < m.getNrTimes(); ++j) {
                int x;
                boolean same;
                if (out[i][j]) continue;
                out[i][j] = true;
                if (PreferenceLevel.sNeutral.equals(m.getPreference(i, j))) continue;
                int endDay = i;
                int endTime = j;
                while (endTime + 1 < m.getNrTimes() && !out[i][endTime + 1] && m.getPreference(i, endTime + 1).equals(m.getPreference(i, j))) {
                    ++endTime;
                }
                if (i == 0) {
                    same = true;
                    int k = i;
                    while (k + 1 < m.getNrDays()) {
                        for (x = j; x <= endTime; ++x) {
                            if (!out[k + 1][x] && !m.getPreference(i, x).equals(m.getPreference(k + 1, x))) {
                                same = false;
                                break;
                            }
                            if (!same) break;
                        }
                        if (!same) break;
                        ++k;
                    }
                    if (same) {
                        endDay = m.getNrDays() - 1;
                    }
                }
                while (canMergeDays && endDay + 1 < m.getNrDays()) {
                    same = true;
                    for (int x2 = j; x2 <= endTime; ++x2) {
                        if (out[endDay + 1][x2] || m.getPreference(i, x2).equals(m.getPreference(endDay + 1, x2))) continue;
                        same = false;
                        break;
                    }
                    if (!same) break;
                    ++endDay;
                }
                for (int a = i; a <= endDay; ++a) {
                    for (int b = j; b <= endTime; ++b) {
                        out[a][b] = true;
                    }
                }
                StringBuffer sb = new StringBuffer(PreferenceLevel.prolog2abbv(m.getPreference(i, j)) + " ");
                int nrDays = 0;
                for (x = 0; x < Constants.DAY_CODES.length; ++x) {
                    boolean thisDay = false;
                    for (int a = i; a <= endDay; ++a) {
                        if ((m.getDayCode(a) & Constants.DAY_CODES[x]) == 0) continue;
                        thisDay = true;
                    }
                    if (!thisDay) continue;
                    ++nrDays;
                }
                for (x = 0; x < Constants.DAY_CODES.length; ++x) {
                    int y = firstDayOfWeek == null ? x : (x + firstDayOfWeek) % 7;
                    boolean thisDay = false;
                    for (int a = i; a <= endDay; ++a) {
                        if ((m.getDayCode(a) & Constants.DAY_CODES[y]) == 0) continue;
                        thisDay = true;
                    }
                    if (!thisDay) continue;
                    sb.append(nrDays == 1 ? CONSTANTS.days()[y] : CONSTANTS.shortDays()[y]);
                }
                Object d1 = " ";
                Object d2 = " ";
                for (int x3 = 0; x3 < 7; ++x3) {
                    int y;
                    int n = y = firstDayOfWeek == null ? x3 : (x3 + firstDayOfWeek) % 7;
                    if (x3 < 5) {
                        d1 = (String)d1 + CONSTANTS.shortDays()[y];
                    }
                    d2 = (String)d2 + CONSTANTS.shortDays()[y];
                }
                if (m.getTimePattern() != null && sb.toString().endsWith((String)d1)) {
                    sb.delete(sb.length() - ((String)d1).length(), sb.length());
                }
                if (m.getTimePattern() == null && sb.toString().endsWith((String)d2)) {
                    sb.delete(sb.length() - ((String)d2).length(), sb.length());
                }
                if (j != 0 || endTime + 1 != m.getNrTimes()) {
                    sb.append(" ");
                    sb.append(Constants.toTime(m.getSlot(j)));
                    sb.append(" - ");
                    sb.append(Constants.toTime(m.getSlot(endTime) + m.getSlotsPerMtg() * Constants.SLOT_LENGTH_MIN - m.getBreakTime()));
                }
                PDFPrinter.A a = new PDFPrinter.A(sb.toString(), new PDFPrinter.F[0]);
                a.setColor(PreferenceLevel.prolog2color(m.getPreference(i, j)));
                ret.add(a);
            }
        }
        return ret;
    }

    protected <T extends Preference> List<T> sorted(Collection<T> input) {
        ArrayList<T> list = new ArrayList<T>(input);
        Collections.sort(list, new Comparator<Preference>(){

            @Override
            public int compare(Preference p1, Preference p2) {
                if (p1.getType() != p2.getType()) {
                    return p1.getType().compareTo(p2.getType());
                }
                int cmp = p1.preferenceText().compareTo(p2.preferenceText());
                if (cmp != 0) {
                    return cmp;
                }
                return p1.compareTo(p2);
            }
        });
        return list;
    }
}

