/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.api.connectors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;
import org.unitime.timetable.api.ApiConnector;
import org.unitime.timetable.api.ApiHelper;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.PositionType;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.rights.Right;

@Service(value="/api/instructors")
public class InstructorsConnector
extends ApiConnector {
    @Override
    public void doGet(ApiHelper helper) throws IOException {
        Long departmentId = helper.getOptinalParameterLong("id", null);
        ArrayList<DepartmentInfo> response = new ArrayList<DepartmentInfo>();
        if (departmentId != null) {
            Department department = (Department)DepartmentDAO.getInstance().get(departmentId, helper.getHibSession());
            if (department == null) {
                throw new IllegalArgumentException("Department " + departmentId + " does not exist.");
            }
            helper.getSessionContext().checkPermissionAnyAuthority((Object)department.getSession(), Right.ApiRetrieveInstructors, new Qualifiable[0]);
            response.add(new DepartmentInfo(department));
        } else {
            Long sessionId = helper.getAcademicSessionId();
            if (sessionId == null) {
                throw new IllegalArgumentException("Academic session not provided, please set the term parameter.");
            }
            String deptCode = helper.getOptinalParameter("code", null);
            if (deptCode != null) {
                Department department = Department.findByDeptCode(deptCode, sessionId);
                if (department == null) {
                    throw new IllegalArgumentException("Department " + deptCode + " does not exist.");
                }
                helper.getSessionContext().checkPermissionAnyAuthority((Object)department.getSession(), Right.ApiRetrieveInstructors, new Qualifiable[0]);
                response.add(new DepartmentInfo(department));
            } else {
                helper.getSessionContext().checkPermissionAnyAuthority(sessionId, "Session", Right.ApiRetrieveInstructors, new Qualifiable[0]);
                for (Department department : Department.findAllBeingUsed(sessionId)) {
                    response.add(new DepartmentInfo(department));
                }
            }
        }
        helper.setResponse(response);
    }

    @Override
    protected String getName() {
        return "instructors";
    }

    class DepartmentInfo {
        Long iDepartmentId;
        String iExternalId;
        String iDeptCode;
        String iAbbreviation;
        String iName;
        Boolean iExternallyManaged;
        String iExternalName;
        String iExternalAbbreviation;
        List<InstructorInfo> iInstructors = new ArrayList<InstructorInfo>();

        DepartmentInfo(Department d) {
            this.iDepartmentId = d.getUniqueId();
            this.iExternalId = d.getExternalUniqueId();
            this.iDeptCode = d.getDeptCode();
            this.iAbbreviation = d.getAbbreviation();
            this.iName = d.getName();
            this.iExternallyManaged = d.isExternalManager();
            if (d.isExternalManager().booleanValue()) {
                this.iExternalName = d.getExternalMgrLabel();
                this.iExternalAbbreviation = d.getExternalMgrAbbv();
            }
            for (DepartmentalInstructor i : d.getInstructors()) {
                this.iInstructors.add(new InstructorInfo(i));
            }
        }
    }

    static class PositionInfo {
        String iReference;
        String iLabel;

        PositionInfo(PositionType type) {
            this.iReference = type.getReference();
            this.iLabel = type.getLabel();
        }
    }

    static class InstructorInfo {
        Long iInstructorId;
        String iExternalId;
        String iFirstName;
        String iMiddleName;
        String iLastName;
        String iTitle;
        PositionInfo iPosition;
        String iEmail;
        String iAcademicTitle;

        InstructorInfo(DepartmentalInstructor instructor) {
            this.iInstructorId = instructor.getUniqueId();
            this.iExternalId = instructor.getExternalUniqueId();
            this.iFirstName = instructor.getFirstName();
            this.iMiddleName = instructor.getMiddleName();
            this.iLastName = instructor.getLastName();
            this.iTitle = instructor.getAcademicTitle();
            if (instructor.getPositionType() != null) {
                this.iPosition = new PositionInfo(instructor.getPositionType());
            }
            this.iEmail = instructor.getEmail();
            this.iAcademicTitle = instructor.getAcademicTitle();
        }
    }
}

