/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.jgroups.util.AverageMinMax;
import org.jgroups.util.Util;

public class Profiler {
    protected final AverageMinMax avg = (AverageMinMax)new AverageMinMax(1024).unit(TimeUnit.NANOSECONDS);
    protected final Map<Thread, Long> threads = new ConcurrentHashMap<Thread, Long>();
    protected boolean print_details = true;
    protected boolean enabled = true;

    public boolean details() {
        return this.print_details;
    }

    public Profiler details(boolean d) {
        this.print_details = d;
        return this;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public Profiler enable(boolean b) {
        this.enabled = b;
        return this;
    }

    public void reset() {
        this.threads.clear();
        this.avg.clear();
    }

    public void start() {
        if (!this.enabled) {
            return;
        }
        Thread curr = Thread.currentThread();
        this.threads.put(curr, System.nanoTime());
    }

    public void stop() {
        if (!this.enabled) {
            return;
        }
        Thread curr_thread = Thread.currentThread();
        Long start = this.threads.remove(curr_thread);
        if (start != null) {
            long time = System.nanoTime() - start;
            this.avg.add(time);
        }
    }

    public String toString() {
        if (this.avg.count() == 0) {
            return "n/a";
        }
        return this.print_details ? String.format("min/avg/max=%s/%s/%s", Util.printTime(this.avg.min(), TimeUnit.NANOSECONDS), Util.printTime(this.avg.average(), TimeUnit.NANOSECONDS), Util.printTime(this.avg.max(), TimeUnit.NANOSECONDS)) : String.format("avg=%s", Util.printTime(this.avg.average(), TimeUnit.NANOSECONDS));
    }
}

