/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.concurrent.TimeUnit;
import org.jgroups.Message;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.AverageMinMax;
import org.jgroups.util.MessageBatch;

@MBean(description="Measures message delivery times")
public class TIME
extends Protocol {
    @ManagedAttribute(description="Average delivery time (in microseconds) for single messages")
    protected final AverageMinMax up_delivery_msgs = (AverageMinMax)new AverageMinMax().unit(TimeUnit.NANOSECONDS);
    @ManagedAttribute(description="Average delivery time (in microseconds) for message batches")
    protected final AverageMinMax up_delivery_batches = (AverageMinMax)new AverageMinMax().unit(TimeUnit.NANOSECONDS);
    @ManagedAttribute(description="Average size of received message batches")
    protected final AverageMinMax avg_up_batch_size = new AverageMinMax();
    @ManagedAttribute(description="Average down delivery time (in microseconds)")
    protected final AverageMinMax down_delivery = (AverageMinMax)new AverageMinMax().unit(TimeUnit.NANOSECONDS);
    @Property(description="Enables or disables measuring times of messages sent down")
    protected boolean down_msgs;
    @Property(description="Enables or disables measuring times of message batches received from below")
    protected boolean up_batches = true;
    @Property(description="Enables or disables measuring times of messages received from below. Attribute up_batches has to be true, or else up_msgs will be ignored")
    protected boolean up_msgs;

    @Override
    public void resetStats() {
        this.down_delivery.clear();
        this.up_delivery_msgs.clear();
        this.up_delivery_batches.clear();
        this.avg_up_batch_size.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object down(Message msg) {
        if (!this.down_msgs) {
            return this.down_prot.down(msg);
        }
        long start = System.nanoTime();
        try {
            Object object = this.down_prot.down(msg);
            return object;
        }
        finally {
            long time = System.nanoTime() - start;
            this.down_delivery.add(time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object up(Message msg) {
        if (!this.up_msgs) {
            return this.up_prot.up(msg);
        }
        long start = System.nanoTime();
        try {
            Object object = this.up_prot.up(msg);
            return object;
        }
        finally {
            long time = System.nanoTime() - start;
            this.up_delivery_msgs.add(time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void up(MessageBatch batch) {
        if (!this.up_batches) {
            this.up_prot.up(batch);
            return;
        }
        int size = batch.size();
        long start = System.nanoTime();
        try {
            this.up_prot.up(batch);
        }
        finally {
            long time = System.nanoTime() - start;
            this.up_delivery_batches.add(time);
            this.avg_up_batch_size.add(size);
        }
    }
}

