/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.vm;

import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.shared.AutoBeanFactory;
import com.google.web.bindery.autobean.vm.impl.BeanMethod;
import com.google.web.bindery.autobean.vm.impl.TypeUtils;
import com.google.web.bindery.requestfactory.shared.BaseProxy;
import com.google.web.bindery.requestfactory.shared.InstanceRequest;
import com.google.web.bindery.requestfactory.shared.JsonRpcContent;
import com.google.web.bindery.requestfactory.shared.JsonRpcWireName;
import com.google.web.bindery.requestfactory.shared.Request;
import com.google.web.bindery.requestfactory.shared.RequestContext;
import com.google.web.bindery.requestfactory.shared.impl.AbstractRequest;
import com.google.web.bindery.requestfactory.shared.impl.AbstractRequestContext;
import com.google.web.bindery.requestfactory.shared.impl.RequestData;
import com.google.web.bindery.requestfactory.shared.impl.SimpleProxyId;
import com.google.web.bindery.requestfactory.vm.InProcessRequestFactory;
import com.google.web.bindery.requestfactory.vm.impl.Deobfuscator;
import com.google.web.bindery.requestfactory.vm.impl.OperationKey;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collection;

class InProcessRequestContext
extends AbstractRequestContext {
    static final Object[] NO_ARGS = new Object[0];
    private final Class<? extends RequestContext> context;
    private final Deobfuscator deobfuscator;
    private final AbstractRequestContext.Dialect dialect;

    protected InProcessRequestContext(InProcessRequestFactory factory, AbstractRequestContext.Dialect dialect, Class<? extends RequestContext> context) {
        super(factory, dialect);
        this.context = context;
        this.deobfuscator = factory.getDeobfuscator();
        this.dialect = dialect;
    }

    @Override
    public <T extends RequestContext> T append(T other) {
        RequestContextHandler h = (RequestContextHandler)Proxy.getInvocationHandler(other);
        super.append(h.getContext());
        return other;
    }

    @Override
    protected <T extends BaseProxy> AutoBean<T> createProxy(Class<T> clazz, SimpleProxyId<T> id, boolean useAppendedContexts) {
        if (this.deobfuscator.isReferencedType(clazz.getName())) {
            return super.createProxy(clazz, id, useAppendedContexts);
        }
        throw new IllegalArgumentException("Unknown proxy type " + clazz.getName());
    }

    @Override
    protected AutoBeanFactory getAutoBeanFactory() {
        return ((InProcessRequestFactory)this.getRequestFactory()).getAutoBeanFactory();
    }

    class RequestContextHandler
    implements InvocationHandler {
        RequestContextHandler() {
        }

        public InProcessRequestContext getContext() {
            return InProcessRequestContext.this;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            RequestData data;
            Class<?> elementType;
            Object[] actualArgs;
            Type returnGenericType;
            Class<?> owner = method.getDeclaringClass();
            if (Object.class.equals(owner) || RequestContext.class.equals(owner) || AbstractRequestContext.class.equals(owner)) {
                try {
                    return method.invoke((Object)InProcessRequestContext.this, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
            boolean isInstance = InstanceRequest.class.isAssignableFrom(method.getReturnType());
            if (isInstance) {
                returnGenericType = TypeUtils.getParameterization(InstanceRequest.class, method.getGenericReturnType(), method.getReturnType())[1];
                if (args == null) {
                    actualArgs = new Object[1];
                } else {
                    actualArgs = new Object[args.length + 1];
                    System.arraycopy(args, 0, actualArgs, 1, args.length);
                }
            } else {
                returnGenericType = TypeUtils.getSingleParameterization(Request.class, method.getGenericReturnType(), method.getReturnType());
                actualArgs = args == null ? NO_ARGS : args;
            }
            Class<?> returnType = TypeUtils.ensureBaseType(returnGenericType);
            Class<?> clazz = elementType = Collection.class.isAssignableFrom(returnType) ? TypeUtils.ensureBaseType(TypeUtils.getSingleParameterization(Collection.class, returnGenericType)) : null;
            if (InProcessRequestContext.this.dialect.equals((Object)AbstractRequestContext.Dialect.STANDARD)) {
                StringBuilder descriptor = new StringBuilder("(");
                for (Class<?> param : method.getParameterTypes()) {
                    this.appendDescriptor(descriptor, param);
                }
                descriptor.append(")V");
                OperationKey operation = new OperationKey(InProcessRequestContext.this.context.getName(), method.getName(), descriptor.toString());
                data = new RequestData(operation.get(), actualArgs, returnType, elementType);
            } else {
                JsonRpcWireName wireInfo = method.getReturnType().getAnnotation(JsonRpcWireName.class);
                String apiVersion = wireInfo.version();
                String operation = wireInfo.value();
                int foundContent = -1;
                String[] parameterNames = args == null ? new String[]{} : new String[args.length];
                Annotation[][] parameterAnnotations = method.getParameterAnnotations();
                int j = parameterAnnotations.length;
                block3: for (int i = 0; i < j; ++i) {
                    for (Annotation annotation : parameterAnnotations[i]) {
                        if (AutoBean.PropertyName.class.equals(annotation.annotationType())) {
                            parameterNames[i] = ((AutoBean.PropertyName)annotation).value();
                            continue block3;
                        }
                        if (!JsonRpcContent.class.equals(annotation.annotationType())) continue;
                        foundContent = i;
                        continue block3;
                    }
                    throw new UnsupportedOperationException("No " + AutoBean.PropertyName.class.getCanonicalName() + " annotation on parameter " + i + " of method " + method.toString());
                }
                int contentIdx = foundContent;
                data = new RequestData(operation, actualArgs, returnType, elementType);
                int j2 = parameterNames.length;
                for (int i = 0; i < j2; ++i) {
                    if (i != contentIdx) {
                        data.setNamedParameter(parameterNames[i], args[i]);
                        continue;
                    }
                    data.setRequestContent(args[i]);
                }
                data.setApiVersion(apiVersion);
            }
            final AbstractRequest<BaseProxy, Object> req = new AbstractRequest<BaseProxy, Object>(this, (AbstractRequestContext)InProcessRequestContext.this){
                final /* synthetic */ RequestContextHandler this$1;
                {
                    this.this$1 = this$1;
                    super(requestContext);
                }

                @Override
                protected RequestData makeRequestData() {
                    data.setPropertyRefs(this.propertyRefs);
                    return data;
                }
            };
            if (!isInstance) {
                InProcessRequestContext.this.addInvocation(req);
            }
            if (InProcessRequestContext.this.dialect.equals((Object)AbstractRequestContext.Dialect.STANDARD)) {
                return req;
            }
            if (InProcessRequestContext.this.dialect.equals((Object)AbstractRequestContext.Dialect.JSON_RPC)) {
                Class<Request> requestType = method.getReturnType().asSubclass(Request.class);
                return Proxy.newProxyInstance(requestType.getClassLoader(), new Class[]{requestType}, new InvocationHandler(){
                    final /* synthetic */ RequestContextHandler this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        if (Object.class.equals(method.getDeclaringClass()) || Request.class.equals(method.getDeclaringClass())) {
                            return method.invoke((Object)req, args);
                        }
                        if (BeanMethod.SET.matches(method) || BeanMethod.SET_BUILDER.matches(method)) {
                            req.getRequestData().setNamedParameter(BeanMethod.SET.inferName(method), args[0]);
                            return Void.TYPE.equals(method.getReturnType()) ? null : proxy;
                        }
                        throw new UnsupportedOperationException(method.toString());
                    }
                });
            }
            throw new RuntimeException("Should not reach here");
        }

        private void appendDescriptor(StringBuilder descriptor, Class<?> param) {
            while (param.isArray()) {
                descriptor.append('[');
                param = param.getComponentType();
            }
            if (param.isPrimitive()) {
                if (param == Boolean.TYPE) {
                    descriptor.append('Z');
                } else if (param == Byte.TYPE) {
                    descriptor.append('B');
                } else if (param == Character.TYPE) {
                    descriptor.append('C');
                } else if (param == Double.TYPE) {
                    descriptor.append('D');
                } else if (param == Float.TYPE) {
                    descriptor.append('F');
                } else if (param == Integer.TYPE) {
                    descriptor.append('I');
                } else if (param == Long.TYPE) {
                    descriptor.append('J');
                } else if (param == Short.TYPE) {
                    descriptor.append('S');
                } else {
                    assert (param == Void.TYPE);
                    descriptor.append('V');
                }
            } else {
                descriptor.append('L').append(param.getName().replace('.', '/')).append(';');
            }
        }
    }
}

