/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.tags;

import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeSet;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.SolverParameter;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.model.dao.SolutionDAO;
import org.unitime.timetable.model.dao.SolverGroupDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.context.HttpSessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.solver.SolverPageBackend;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.WebSolver;
import org.unitime.timetable.solver.exam.ExamSolverProxy;

public class SolverWarnings
extends BodyTagSupport {
    private static final long serialVersionUID = 7947787141769725429L;
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    public SessionContext getSessionContext() {
        return HttpSessionContext.getSessionContext(this.pageContext.getServletContext());
    }

    public String getSolverWarningCheckSolution() {
        if (!this.getSessionContext().hasPermission(Right.CourseTimetabling)) {
            return null;
        }
        try {
            SolverProxy proxy = WebSolver.getSolver(this.pageContext.getSession());
            if (proxy != null) {
                return proxy.getProperties().getProperty("General.SolverWarnings");
            }
        }
        catch (Exception proxy) {
            // empty catch block
        }
        String id = (String)this.pageContext.getSession().getAttribute("Solver.selectedSolutionId");
        if (id != null && !id.isEmpty()) {
            Object warn = "";
            for (String solutionId : id.split(",")) {
                Solution solution = (Solution)SolutionDAO.getInstance().get(Long.valueOf(solutionId));
                for (SolverParameter p : solution.getParameters()) {
                    if (!"General.SolverWarnings".equals(p.getDefinition().getName()) || p.getValue() == null) continue;
                    if (!((String)warn).isEmpty()) {
                        warn = (String)warn + "<br>";
                    }
                    warn = (String)warn + p.getValue();
                }
            }
            return ((String)warn).isEmpty() ? null : warn;
        }
        TreeSet<SolverGroup> solverGroups = SolverGroup.getUserSolverGroups(this.getSessionContext().getUser());
        if (solverGroups.isEmpty()) {
            return null;
        }
        Object warn = "";
        int maxDistPriority = Integer.MIN_VALUE;
        int nrWarns = 0;
        for (SolverGroup sg : solverGroups) {
            maxDistPriority = Math.max(maxDistPriority, sg.getMaxDistributionPriority());
        }
        for (SolverGroup sg : SolverGroup.findBySessionId(this.getSessionContext().getUser().getCurrentAcademicSessionId())) {
            if (solverGroups.contains(sg) || sg.getMinDistributionPriority() >= maxDistPriority || sg.getCommittedSolution() != null) continue;
            if (nrWarns > 0) {
                warn = (String)warn + "<br>";
            }
            ArrayList<String> subjects = new ArrayList<String>();
            boolean dept = false;
            for (Department d : sg.getDepartments()) {
                if (d.isExternalManager().booleanValue()) {
                    subjects.add(d.getExternalMgrAbbv());
                    continue;
                }
                dept = true;
                for (SubjectArea sa : d.getSubjectAreas()) {
                    subjects.add(sa.getSubjectAreaAbbreviation());
                }
            }
            warn = dept ? (String)warn + MESSAGES.warnSolverNoCommittedSolutionDepartmental(sg.getAbbv(), SolverPageBackend.toString(subjects)) : (String)warn + MESSAGES.warnSolverNoCommittedSolutionExternal(sg.getAbbv(), SolverPageBackend.toString(subjects));
            if (++nrWarns < 3) continue;
            warn = (String)warn + "<br>...";
            break;
        }
        return ((String)warn).isEmpty() ? null : warn;
    }

    public String[] getCurrentAssignmentWarning() {
        if (!this.getSessionContext().hasPermission(Right.Timetables)) {
            return null;
        }
        try {
            SolverProxy proxy = WebSolver.getSolver(this.pageContext.getSession());
            if (proxy != null) {
                Long[] solverGroupId = proxy.getProperties().getPropertyLongArry("General.SolverGroupId", null);
                ArrayList<String> names = new ArrayList<String>();
                boolean interactive = proxy.getProperties().getPropertyBoolean("General.InteractiveMode", false);
                if (solverGroupId != null) {
                    for (int i = 0; i < solverGroupId.length; ++i) {
                        SolverGroup sg = (SolverGroup)SolverGroupDAO.getInstance().get(solverGroupId[i]);
                        names.add(sg == null ? MESSAGES.notApplicable() : (solverGroupId.length <= 3 ? sg.getName() : sg.getAbbv()));
                    }
                }
                if (names == null || names.isEmpty()) {
                    names.add(MESSAGES.notApplicable());
                }
                return new String[]{interactive ? "gwt.jsp?page=listSolutions" : "gwt.jsp?page=solver&type=course", MESSAGES.infoSolverShowingSolution(SolverPageBackend.toString(names))};
            }
        }
        catch (Exception proxy) {
            // empty catch block
        }
        String id = (String)this.pageContext.getSession().getAttribute("Solver.selectedSolutionId");
        if (id != null && !id.isEmpty()) {
            ArrayList<String> names = new ArrayList<String>();
            String[] solutionIds = id.split(",");
            for (int i = 0; i < solutionIds.length; ++i) {
                Solution solution = (Solution)SolutionDAO.getInstance().get(Long.valueOf(solutionIds[i]));
                names.add(solutionIds.length <= 3 ? solution.getOwner().getName() : solution.getOwner().getAbbv());
            }
            return new String[]{"gwt.jsp?page=listSolutions", names.isEmpty() ? null : (names.size() == 1 ? MESSAGES.infoSolverShowingSelectedSolution((String)names.get(0)) : MESSAGES.infoSolverShowingSelectedSolutions(SolverPageBackend.toString(names)))};
        }
        return null;
    }

    public String[] getExamAssignmentWarning(boolean checkExamType) {
        if (!this.getSessionContext().hasPermission(Right.ExaminationSolver)) {
            return null;
        }
        try {
            ExamType type;
            ExamSolverProxy proxy = WebSolver.getExamSolver(this.pageContext.getSession());
            if (proxy != null && (type = (ExamType)ExamTypeDAO.getInstance().get(proxy.getExamTypeId())) != null) {
                Long selectedExamTypeId;
                if (checkExamType && (selectedExamTypeId = (Long)this.getSessionContext().getAttribute(SessionAttribute.ExamType)) != null && !selectedExamTypeId.equals(type.getUniqueId())) {
                    return null;
                }
                return new String[]{"gwt.jsp?page=solver&type=exam", MESSAGES.infoExamSolverShowingSolution(type.getLabel())};
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void printWarning(String style, String message, String link) throws IOException {
        if (message != null && !message.isEmpty()) {
            this.pageContext.getOut().println("<div class=\"" + style + "\"" + (link == null ? "" : "onMouseOver=\"this.style.backgroundColor='#BBCDD0';\" onMouseOut=\"this.style.backgroundColor='#DFE7F2';\"") + ">");
            if (link != null) {
                this.pageContext.getOut().print("<a class='noFancyLinks' href=\"" + link + "\">");
            }
            this.pageContext.getOut().println(message);
            if (link != null) {
                this.pageContext.getOut().print("</a>");
            }
            this.pageContext.getOut().println("</div>");
        }
    }

    public int doStartTag() {
        return 2;
    }

    public int doEndTag() throws JspException {
        try {
            String[] awarn;
            String body;
            String string = body = this.getBodyContent() == null ? null : this.getBodyContent().getString().trim();
            if (body == null || body.isEmpty()) {
                return 6;
            }
            if ("solver".equals(body)) {
                String[] awarn2;
                String warn = this.getSolverWarningCheckSolution();
                if (warn != null) {
                    this.printWarning("unitime-PageWarn", warn, null);
                }
                if ((awarn2 = this.getCurrentAssignmentWarning()) != null) {
                    this.printWarning("unitime-PageMessage", awarn2[1], awarn2[0]);
                }
            } else if ("assignment".equals(body)) {
                String[] xwarn;
                String[] awarn3 = this.getCurrentAssignmentWarning();
                if (awarn3 != null) {
                    this.printWarning("unitime-PageMessage", awarn3[1], awarn3[0]);
                }
                if ((xwarn = this.getExamAssignmentWarning(false)) != null) {
                    this.printWarning("unitime-PageMessage", xwarn[1], xwarn[0]);
                }
            } else if ("exams".equals(body) && (awarn = this.getExamAssignmentWarning(true)) != null) {
                this.printWarning("unitime-PageMessage", awarn[1], awarn[0]);
            }
        }
        catch (Exception e) {
            Debug.error(e);
        }
        return 6;
    }
}

