/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.coursett.TimetableLoader;
import org.cpsolver.coursett.constraint.ClassLimitConstraint;
import org.cpsolver.coursett.constraint.DepartmentSpreadConstraint;
import org.cpsolver.coursett.constraint.DiscouragedRoomConstraint;
import org.cpsolver.coursett.constraint.FlexibleConstraint;
import org.cpsolver.coursett.constraint.GroupConstraint;
import org.cpsolver.coursett.constraint.IgnoreStudentConflictsConstraint;
import org.cpsolver.coursett.constraint.InstructorConstraint;
import org.cpsolver.coursett.constraint.JenrlConstraint;
import org.cpsolver.coursett.constraint.MinimizeNumberOfUsedGroupsOfTime;
import org.cpsolver.coursett.constraint.MinimizeNumberOfUsedRoomsConstraint;
import org.cpsolver.coursett.constraint.RoomConstraint;
import org.cpsolver.coursett.constraint.SoftInstructorConstraint;
import org.cpsolver.coursett.constraint.SpreadConstraint;
import org.cpsolver.coursett.model.Configuration;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.RoomSharingModel;
import org.cpsolver.coursett.model.StudentGroup;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.coursett.preference.MinMaxPreferenceCombination;
import org.cpsolver.coursett.preference.PreferenceCombination;
import org.cpsolver.coursett.preference.SumPreferenceCombination;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.BinaryConstraint;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.DistanceMetric;
import org.cpsolver.ifs.util.IdGenerator;
import org.cpsolver.ifs.util.Progress;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LazyInitializationException;
import org.hibernate.Transaction;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.CPSolverMessages;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.ClassDurationType;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseReservation;
import org.unitime.timetable.model.CurriculumReservation;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DatePatternPref;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.ExactTimeMins;
import org.unitime.timetable.model.IndividualReservation;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.LearningCommunityReservation;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Reservation;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentGroupReservation;
import org.unitime.timetable.model.StudentSchedulingRule;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePatternModel;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.TravelTime;
import org.unitime.timetable.model.UniversalOverrideReservation;
import org.unitime.timetable.model.base.BaseBuildingPref;
import org.unitime.timetable.model.base.BaseClass_;
import org.unitime.timetable.model.base.BaseDistributionType;
import org.unitime.timetable.model.base.BaseIndividualReservation;
import org.unitime.timetable.model.base.BasePreferenceGroup;
import org.unitime.timetable.model.base.BasePreferenceLevel;
import org.unitime.timetable.model.base.BaseRefTableEntry;
import org.unitime.timetable.model.base.BaseRoomFeaturePref;
import org.unitime.timetable.model.base.BaseRoomGroupPref;
import org.unitime.timetable.model.base.BaseRoomPref;
import org.unitime.timetable.model.base.BaseUniversalOverrideReservation;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.InstrOfferingConfigComparator;
import org.unitime.timetable.model.dao.AssignmentDAO;
import org.unitime.timetable.model.dao.SchedulingSubpartDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.SolutionDAO;
import org.unitime.timetable.model.dao.SolverGroupDAO;
import org.unitime.timetable.model.dao.TimetableManagerDAO;
import org.unitime.timetable.onlinesectioning.status.db.DbFindEnrollmentInfoAction;
import org.unitime.timetable.solver.EnrollmentCheck;
import org.unitime.timetable.solver.TimetableSolver;
import org.unitime.timetable.solver.course.weights.ClassWeightProvider;
import org.unitime.timetable.solver.course.weights.DefaultClassWeights;
import org.unitime.timetable.solver.curricula.LastLikeStudentCourseDemands;
import org.unitime.timetable.solver.curricula.StudentCourseDemands;
import org.unitime.timetable.solver.curricula.StudentGroupCourseDemands;
import org.unitime.timetable.solver.jgroups.SolverServerImplementation;
import org.unitime.timetable.solver.studentsct.StudentSectioningDatabaseLoader;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.DateUtils;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.RoomAvailability;
import org.unitime.timetable.util.duration.DurationModel;

public class TimetableDatabaseLoader
extends TimetableLoader {
    private static Log sLog = LogFactory.getLog(TimetableDatabaseLoader.class);
    protected static CPSolverMessages MSG = Localization.create(CPSolverMessages.class);
    private Session iSession;
    private Long iSessionId;
    private Long[] iSolverGroupId;
    private String iSolverGroupIds;
    private String iDepartmentIds = null;
    private SolverGroup[] iSolverGroup;
    private Long[] iSolutionId;
    private long iFakeLectureId = 0L;
    private Hashtable<Long, RoomConstraint> iRooms = new Hashtable();
    private Hashtable<Long, RoomConstraint> iRoomsByPermId = new Hashtable();
    private Hashtable<Object, InstructorConstraint> iInstructors = new Hashtable();
    private Hashtable<InstructorConstraint, List<DistributionType>> iInstructorDistributions = new Hashtable();
    private Hashtable<Long, Lecture> iLectures = new Hashtable();
    private Hashtable<Long, SchedulingSubpart> iSubparts = new Hashtable();
    private Hashtable<Long, org.cpsolver.coursett.model.Student> iStudents = new Hashtable();
    private Hashtable<Long, StudentCourseDemands.WeightedStudentId> iWeightedStudents = new Hashtable();
    private Hashtable<Long, String> iDeptNames = new Hashtable();
    private Hashtable<Long, Class_> iClasses = new Hashtable();
    private Set<DatePattern> iAllUsedDatePatterns = new HashSet<DatePattern>();
    private Hashtable<Long, StudentGroup> iGroups = new Hashtable();
    private Set<Class_> iAllClasses = null;
    private Hashtable<InstructionalOffering, List<Configuration>> iAltConfigurations = new Hashtable();
    private Hashtable<InstructionalOffering, Hashtable<InstrOfferingConfig, Set<SchedulingSubpart>>> iOfferings = new Hashtable();
    private Hashtable<CourseOffering, Set<org.cpsolver.coursett.model.Student>> iCourse2students = new Hashtable();
    private Set<org.cpsolver.coursett.model.Student> iOnlineOnlyStudents = new HashSet<org.cpsolver.coursett.model.Student>();
    private Map<org.cpsolver.coursett.model.Student, StudentSchedulingRule> iStudentRules = new HashMap<org.cpsolver.coursett.model.Student, StudentSchedulingRule>();
    private boolean iDeptBalancing = true;
    private boolean iSubjectBalancing = false;
    private boolean iMppAssignment = true;
    private boolean iInteractiveMode = false;
    private boolean iSpread = true;
    private boolean iAutoSameStudents = true;
    private String iAutoPrecedence = null;
    private boolean iLoadCommittedAssignments = false;
    private double iFewerSeatsDisouraged = 0.01;
    private double iFewerSeatsStronglyDisouraged = 0.02;
    private double iNormalizedPrefDecreaseFactor = TimePatternModel.sDefaultDecreaseFactor;
    private double iAlterTimePatternWeight = 0.0;
    private double iAlterDatePatternWeight = 1.0;
    private TimePatternModel iAlterTimePatternModel = (TimePatternModel)TimePattern.getDefaultRequiredTimeTable().getModel();
    private boolean iWeakenTimePreferences = false;
    private Progress iProgress = null;
    private boolean iLoadStudentEnrlsFromSolution = false;
    private boolean iFixMinPerWeek = false;
    private boolean iAssignSingleton = true;
    private boolean iIgnoreRoomSharing = false;
    private boolean iLoadStudentInstructorConflicts = false;
    private int iMaxRoomCombinations = 100;
    private String iAutoSameStudentsConstraint = "SAME_STUDENTS";
    private String iInstructorFormat = null;
    private boolean iRoomAvailabilityTimeStampIsSet = false;
    private CommittedStudentConflictsMode iCommittedStudentConflictsMode = CommittedStudentConflictsMode.Load;
    private StudentCourseDemands iStudentCourseDemands = null;
    private StudentGroupCourseDemands iStudentGroupCourseDemands = null;
    private ClassWeightProvider iClassWeightProvider = null;
    private boolean iUseAmPm = true;
    private boolean iShowClassSuffix = false;
    private boolean iShowConfigName = false;
    private boolean iLoadCommittedReservations = false;
    private boolean iInstructorDistributionsAcrossDepartments = false;
    private boolean iFixedTimesMPP = false;
    private boolean iWeakenDistributions = false;
    private boolean iSoftInstructorConstraints = false;
    private boolean iAllowProhibitedRooms = false;
    private Query iOnlineOnlyStudentQuery = null;
    private String iOnlineOnlyInstructionalModeRegExp;
    private String iResidentialInstructionalModeRegExp;
    private String iOnlineOnlyStudentSuffix;
    private Hashtable iRoomPreferences = null;

    public TimetableDatabaseLoader(TimetableModel model, Assignment<Lecture, Placement> assignment) {
        super(model, assignment);
        Progress.sTraceEnabled = false;
        this.iProgress = Progress.getInstance((Object)model);
        this.iSessionId = model.getProperties().getPropertyLong("General.SessionId", (Long)null);
        this.iSolverGroupId = model.getProperties().getPropertyLongArry("General.SolverGroupId", null);
        this.iSolutionId = model.getProperties().getPropertyLongArry("General.SolutionId", null);
        this.iIgnoreRoomSharing = model.getProperties().getPropertyBoolean("General.IgnoreRoomSharing", this.iIgnoreRoomSharing);
        this.iSolverGroupIds = "";
        if (this.iSolverGroupId != null) {
            for (int i = 0; i < this.iSolverGroupId.length; ++i) {
                if (i > 0) {
                    this.iSolverGroupIds = this.iSolverGroupIds + ",";
                }
                this.iSolverGroupIds = this.iSolverGroupIds + this.iSolverGroupId[i].toString();
            }
        }
        this.iDeptBalancing = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.DeptBalancing", this.iDeptBalancing);
        this.iSubjectBalancing = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.SubjectBalancing", this.iSubjectBalancing);
        this.iSpread = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.Spread", this.iSpread);
        this.iAutoSameStudents = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.AutoSameStudents", this.iAutoSameStudents);
        this.iAutoPrecedence = ((TimetableModel)this.getModel()).getProperties().getProperty("General.AutoPrecedence");
        this.iMppAssignment = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.MPP", this.iMppAssignment);
        this.iFixedTimesMPP = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.MPP.FixedTimes", this.iFixedTimesMPP);
        this.iWeakenDistributions = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.WeakenDistributions", this.iWeakenDistributions);
        this.iSoftInstructorConstraints = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.SoftInstructorConstraints", this.iSoftInstructorConstraints);
        this.iAllowProhibitedRooms = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.AllowProhibitedRooms", this.iAllowProhibitedRooms);
        this.iInteractiveMode = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.InteractiveMode", this.iInteractiveMode);
        this.iAssignSingleton = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.AssignSingleton", this.iAssignSingleton);
        this.iMaxRoomCombinations = ((TimetableModel)this.getModel()).getProperties().getPropertyInt("General.MaxRoomCombinations", this.iMaxRoomCombinations);
        this.iFewerSeatsDisouraged = ((TimetableModel)this.getModel()).getProperties().getPropertyDouble("Global.FewerSeatsDisouraged", this.iFewerSeatsDisouraged);
        this.iFewerSeatsStronglyDisouraged = ((TimetableModel)this.getModel()).getProperties().getPropertyDouble("Global.FewerSeatsStronglyDisouraged", this.iFewerSeatsStronglyDisouraged);
        this.iNormalizedPrefDecreaseFactor = ((TimetableModel)this.getModel()).getProperties().getPropertyDouble("General.NormalizedPrefDecreaseFactor", this.iNormalizedPrefDecreaseFactor);
        this.iLoadStudentEnrlsFromSolution = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("Global.LoadStudentEnrlsFromSolution", this.iLoadStudentEnrlsFromSolution);
        this.iLoadStudentInstructorConflicts = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("Global.LoadStudentInstructorConflicts", this.iLoadStudentInstructorConflicts);
        this.iFixMinPerWeek = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("Global.FixMinPerWeek", this.iFixMinPerWeek);
        this.iAlterTimePatternWeight = ((TimetableModel)this.getModel()).getProperties().getPropertyDouble("TimePreferences.Weight", this.iAlterTimePatternWeight);
        this.iAlterDatePatternWeight = ((TimetableModel)this.getModel()).getProperties().getPropertyDouble("General.AlternativeDatePatternWeight", this.iAlterDatePatternWeight);
        this.iAlterTimePatternModel.setPreferences(((TimetableModel)this.getModel()).getProperties().getProperty("TimePreferences.Pref", null));
        this.iWeakenTimePreferences = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("TimePreferences.Weaken", this.iWeakenTimePreferences);
        this.iAutoSameStudentsConstraint = ((TimetableModel)this.getModel()).getProperties().getProperty("General.AutoSameStudentsConstraint", this.iAutoSameStudentsConstraint);
        this.iInstructorFormat = ((TimetableModel)this.getModel()).getProperties().getProperty("General.InstructorFormat", DepartmentalInstructor.sNameFormatLastFist);
        this.iInstructorDistributionsAcrossDepartments = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.ApplyInstructorDistributionsAcrossAllDepartments", this.iInstructorDistributionsAcrossDepartments);
        try {
            Object studentCourseDemandsClassName = ((TimetableModel)this.getModel()).getProperties().getProperty("Curriculum.StudentCourseDemadsClass", LastLikeStudentCourseDemands.class.getName());
            if (((String)studentCourseDemandsClassName).indexOf(32) >= 0) {
                studentCourseDemandsClassName = ((String)studentCourseDemandsClassName).replace(" ", "");
            }
            if (((String)studentCourseDemandsClassName).indexOf(46) < 0) {
                studentCourseDemandsClassName = "org.unitime.timetable.solver.curricula." + (String)studentCourseDemandsClassName;
            }
            Class<?> studentCourseDemandsClass = Class.forName((String)studentCourseDemandsClassName);
            this.iStudentCourseDemands = (StudentCourseDemands)studentCourseDemandsClass.getConstructor(DataProperties.class).newInstance(((TimetableModel)this.getModel()).getProperties());
        }
        catch (Exception e) {
            this.iProgress.message(this.msglevel("badStudentCourseDemands", 5), MSG.warnFailedLoadCustomStudentDemands(), (Throwable)e);
            this.iStudentCourseDemands = new LastLikeStudentCourseDemands(((TimetableModel)this.getModel()).getProperties());
        }
        IdGenerator studentIdGenerator = new IdGenerator();
        if (this.iStudentCourseDemands instanceof StudentCourseDemands.NeedsStudentIdGenerator) {
            ((StudentCourseDemands.NeedsStudentIdGenerator)((Object)this.iStudentCourseDemands)).setStudentIdGenerator(studentIdGenerator);
        }
        ((TimetableModel)this.getModel()).getProperties().setProperty("General.SaveStudentEnrollments", this.iStudentCourseDemands.isMakingUpStudents() ? "false" : "true");
        ((TimetableModel)this.getModel()).getProperties().setProperty("General.WeightStudents", this.iStudentCourseDemands.isWeightStudentsToFillUpOffering() ? "true" : "false");
        if (((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.StudentGroupCourseDemands", false)) {
            this.iStudentGroupCourseDemands = new StudentGroupCourseDemands(((TimetableModel)this.getModel()).getProperties());
            if (this.iStudentGroupCourseDemands instanceof StudentCourseDemands.NeedsStudentIdGenerator) {
                this.iStudentGroupCourseDemands.setStudentIdGenerator(studentIdGenerator);
            }
        }
        this.iCommittedStudentConflictsMode = CommittedStudentConflictsMode.valueOf(((TimetableModel)this.getModel()).getProperties().getProperty("General.CommittedStudentConflicts", this.iCommittedStudentConflictsMode.name()));
        this.iLoadCommittedAssignments = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.LoadCommittedAssignments", this.iLoadCommittedAssignments);
        if (this.iCommittedStudentConflictsMode == CommittedStudentConflictsMode.Load && this.iStudentCourseDemands.isMakingUpStudents()) {
            this.iCommittedStudentConflictsMode = CommittedStudentConflictsMode.Compute;
            ((TimetableModel)this.getModel()).getProperties().setProperty("General.CommittedStudentConflicts", this.iCommittedStudentConflictsMode.name());
        }
        if (this.iLoadStudentEnrlsFromSolution && this.iStudentCourseDemands.isMakingUpStudents()) {
            this.iLoadStudentEnrlsFromSolution = false;
            ((TimetableModel)this.getModel()).getProperties().setProperty("Global.LoadStudentEnrlsFromSolution", "false");
        }
        if (this.iLoadStudentInstructorConflicts && this.iStudentCourseDemands.isMakingUpStudents()) {
            this.iLoadStudentInstructorConflicts = false;
            ((TimetableModel)this.getModel()).getProperties().setProperty("Global.LoadStudentInstructorConflicts", "false");
        }
        try {
            Object classWeightProviderClassName = ((TimetableModel)this.getModel()).getProperties().getProperty("ClassWeightProvider.Class", DefaultClassWeights.class.getName());
            if (((String)classWeightProviderClassName).indexOf(32) >= 0) {
                classWeightProviderClassName = ((String)classWeightProviderClassName).replace(" ", "");
            }
            if (((String)classWeightProviderClassName).indexOf(46) < 0) {
                classWeightProviderClassName = "org.unitime.timetable.solver.course.weights." + (String)classWeightProviderClassName;
            }
            Class<?> classWeightProviderClass = Class.forName((String)classWeightProviderClassName);
            this.iClassWeightProvider = (ClassWeightProvider)classWeightProviderClass.getConstructor(DataProperties.class).newInstance(((TimetableModel)this.getModel()).getProperties());
        }
        catch (Exception e) {
            this.iProgress.message(this.msglevel("badClassWeightProvider", 5), MSG.warnFauledLoadCustomClassWeights(), (Throwable)e);
            this.iClassWeightProvider = new DefaultClassWeights(((TimetableModel)this.getModel()).getProperties());
        }
        this.iLoadCommittedReservations = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.LoadCommittedReservations", this.iLoadCommittedReservations);
        this.iUseAmPm = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.UseAmPm", this.iUseAmPm);
        this.iShowClassSuffix = ApplicationProperty.SolverShowClassSufix.isTrue();
        this.iShowConfigName = ApplicationProperty.SolverShowConfiguratioName.isTrue();
        String onlineOnlyStudentFilter = model.getProperties().getProperty("Load.OnlineOnlyStudentFilter", null);
        this.iOnlineOnlyInstructionalModeRegExp = model.getProperties().getProperty("Load.OnlineOnlyInstructionalModeRegExp");
        this.iResidentialInstructionalModeRegExp = model.getProperties().getProperty("Load.ResidentialInstructionalModeRegExp");
        this.iOnlineOnlyStudentSuffix = model.getProperties().getProperty("Load.OnlineOnlyStudentSuffix", "OL");
        if (onlineOnlyStudentFilter != null && !onlineOnlyStudentFilter.isEmpty()) {
            this.iOnlineOnlyStudentQuery = new Query(onlineOnlyStudentFilter);
            this.iProgress.info("Online-only student filter: " + String.valueOf(this.iOnlineOnlyStudentQuery));
        }
    }

    public int msglevel(String type, int defaultLevel) {
        String level = ApplicationProperty.SolverLogLevel.value(type);
        if (level == null) {
            return defaultLevel;
        }
        if ("warn".equalsIgnoreCase(level)) {
            return 5;
        }
        if ("error".equalsIgnoreCase(level)) {
            return 6;
        }
        if ("fatal".equalsIgnoreCase(level)) {
            return 7;
        }
        if ("info".equalsIgnoreCase(level)) {
            return 3;
        }
        if ("debug".equalsIgnoreCase(level)) {
            return 1;
        }
        if ("trace".equalsIgnoreCase(level)) {
            return 0;
        }
        return defaultLevel;
    }

    private String getClassLabel(Class_ clazz) {
        return "<A href='classDetail.action?cid=" + clazz.getUniqueId() + "'>" + clazz.getClassLabel(this.iShowClassSuffix, this.iShowConfigName) + "</A>";
    }

    private String getClassLabel(Lecture lecture) {
        return "<A href='classDetail.action?cid=" + lecture.getClassId() + "'>" + lecture.getName() + "</A>";
    }

    private String getOfferingLabel(InstructionalOffering offering) {
        return "<A href='instructionalOfferingDetail.action?io=" + offering.getUniqueId() + "'>" + offering.getCourseName() + "</A>";
    }

    private String getOfferingLabel(CourseOffering offering) {
        return "<A href='instructionalOfferingDetail.action?io=" + offering.getInstructionalOffering().getUniqueId() + "'>" + offering.getCourseName() + "</A>";
    }

    private String getSubpartLabel(SchedulingSubpart subpart) {
        String suffix = subpart.getSchedulingSubpartSuffix();
        return "<A href='schedulingSubpartDetail.action?ssuid=" + subpart.getUniqueId() + "'>" + subpart.getCourseName() + " " + subpart.getItypeDesc().trim() + (String)(suffix == null || suffix.length() == 0 ? "" : " (" + suffix + ")") + "</A>";
    }

    private PreferenceLevel getRoomPreference(Long deptId, Long locationId) {
        Hashtable roomPreferencesThisDept;
        if (this.iRoomPreferences == null) {
            this.iRoomPreferences = new Hashtable();
            for (int i = 0; i < this.iSolverGroup.length; ++i) {
                for (Department department : this.iSolverGroup[i].getDepartments()) {
                    Hashtable<Long, PreferenceLevel> roomPreferencesThisDept2 = new Hashtable<Long, PreferenceLevel>();
                    this.iRoomPreferences.put(department.getUniqueId(), roomPreferencesThisDept2);
                    for (RoomPref pref : department.getPreferences(RoomPref.class)) {
                        roomPreferencesThisDept2.put(pref.getRoom().getUniqueId(), pref.getPrefLevel());
                    }
                }
            }
        }
        if ((roomPreferencesThisDept = (Hashtable)this.iRoomPreferences.get(deptId)) == null) {
            return null;
        }
        return (PreferenceLevel)roomPreferencesThisDept.get(locationId);
    }

    public static List<RoomLocation> computeRoomLocations(Class_ clazz) {
        return TimetableDatabaseLoader.computeRoomLocations(clazz, false, 0.01, 0.02, 0);
    }

    public static List<RoomLocation> computeRoomLocations(Class_ clazz, Integer roomIndex) {
        return TimetableDatabaseLoader.computeRoomLocations(clazz, false, 0.01, 0.02, roomIndex);
    }

    public static List<RoomLocation> computeRoomLocations(Class_ clazz, boolean interactiveMode, double fewerSeatsDisouraged, double fewerSeatsStronglyDisouraged, Integer roomIndex) {
        int minClassLimit = clazz.getExpectedCapacity();
        int maxClassLimit = clazz.getMaxExpectedCapacity();
        if (maxClassLimit < minClassLimit) {
            maxClassLimit = minClassLimit;
        }
        float room2limitRatio = clazz.getRoomRatio().floatValue();
        int roomCapacity = Math.round(minClassLimit <= 0 ? room2limitRatio : room2limitRatio * (float)minClassLimit);
        int discouragedCapacity = (int)Math.round((1.0 - fewerSeatsStronglyDisouraged) * (double)roomCapacity);
        int stronglyDiscouragedCapacity = (int)Math.round((1.0 - fewerSeatsStronglyDisouraged) * (double)roomCapacity);
        ArrayList<RoomLocation> roomLocations = new ArrayList<RoomLocation>();
        boolean reqRoom = false;
        boolean reqBldg = false;
        boolean reqGroup = false;
        Set<Location> allRooms = clazz.getAvailableRooms();
        Set<RoomGroupPref> groupPrefs = clazz.effectivePreferences(RoomGroupPref.class);
        Set<RoomPref> roomPrefs = clazz.effectivePreferences(RoomPref.class);
        Set<BuildingPref> bldgPrefs = clazz.effectivePreferences(BuildingPref.class);
        Set<RoomFeaturePref> featurePrefs = clazz.effectivePreferences(RoomFeaturePref.class);
        if (clazz.getNbrRooms() > 1 && roomIndex != null) {
            Preference p;
            Iterator<Preference> i = groupPrefs.iterator();
            while (i.hasNext()) {
                p = i.next();
                if (((BaseRoomGroupPref)p).getRoomIndex() == null || ((BaseRoomGroupPref)p).getRoomIndex().equals(roomIndex)) continue;
                i.remove();
            }
            i = roomPrefs.iterator();
            while (i.hasNext()) {
                p = (RoomPref)i.next();
                if (((BaseRoomPref)p).getRoomIndex() == null || ((BaseRoomPref)p).getRoomIndex().equals(roomIndex)) continue;
                i.remove();
            }
            i = bldgPrefs.iterator();
            while (i.hasNext()) {
                p = (BuildingPref)i.next();
                if (((BaseBuildingPref)p).getRoomIndex() == null || ((BaseBuildingPref)p).getRoomIndex().equals(roomIndex)) continue;
                i.remove();
            }
            i = featurePrefs.iterator();
            while (i.hasNext()) {
                p = (RoomFeaturePref)i.next();
                if (((BaseRoomFeaturePref)p).getRoomIndex() == null || ((BaseRoomFeaturePref)p).getRoomIndex().equals(roomIndex)) continue;
                i.remove();
            }
        }
        for (Location room : allRooms) {
            boolean add = true;
            SumPreferenceCombination pref = new SumPreferenceCombination();
            PreferenceCombination groupPref = PreferenceCombination.getDefault();
            for (RoomGroupPref p : groupPrefs) {
                if (!p.getRoomGroup().getRooms().contains(room)) continue;
                groupPref.addPreferenceProlog(p.getPrefLevel().getPrefProlog());
            }
            if (groupPref.getPreferenceProlog().equals(PreferenceLevel.sProhibited)) {
                if (interactiveMode) {
                    pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                } else {
                    add = false;
                }
            }
            if (reqGroup && !groupPref.getPreferenceProlog().equals(PreferenceLevel.sRequired)) {
                if (interactiveMode) {
                    pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                } else {
                    add = false;
                }
            }
            if (!reqGroup && groupPref.getPreferenceProlog().equals(PreferenceLevel.sRequired)) {
                reqGroup = true;
                if (interactiveMode) {
                    for (RoomLocation r : roomLocations) {
                        r.setPreference(r.getPreference() + 100);
                    }
                } else {
                    roomLocations.clear();
                }
            }
            if (!groupPref.getPreferenceProlog().equals(PreferenceLevel.sProhibited) && !groupPref.getPreferenceProlog().equals(PreferenceLevel.sRequired)) {
                pref.addPreferenceProlog(groupPref.getPreferenceProlog());
            }
            String roomPref = null;
            BasePreferenceLevel roomPreference = null;
            for (RoomPref x : clazz.getManagingDept().getPreferences(RoomPref.class)) {
                if (!room.equals(x.getRoom())) continue;
                roomPreference = x.getPrefLevel();
            }
            if (roomPreference != null) {
                roomPref = roomPreference.getPrefProlog();
                if (PreferenceLevel.sProhibited.equals(roomPref)) {
                    add = false;
                }
                if (PreferenceLevel.sStronglyDiscouraged.equals(roomPref)) {
                    roomPref = PreferenceLevel.sProhibited;
                }
            }
            for (RoomPref p : roomPrefs) {
                if (!room.equals(p.getRoom())) continue;
                roomPref = p.getPrefLevel().getPrefProlog();
                break;
            }
            if (roomPref != null && roomPref.equals(PreferenceLevel.sProhibited)) {
                if (interactiveMode) {
                    pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                } else {
                    add = false;
                }
            }
            if (reqRoom && (roomPref == null || !roomPref.equals(PreferenceLevel.sRequired))) {
                if (interactiveMode) {
                    pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                } else {
                    add = false;
                }
            }
            if (!reqRoom && roomPref != null && roomPref.equals(PreferenceLevel.sRequired)) {
                reqRoom = true;
                if (interactiveMode) {
                    for (RoomLocation r : roomLocations) {
                        r.setPreference(r.getPreference() + 100);
                    }
                } else {
                    roomLocations.clear();
                }
            }
            if (roomPref != null && !roomPref.equals(PreferenceLevel.sProhibited) && !roomPref.equals(PreferenceLevel.sRequired)) {
                pref.addPreferenceProlog(roomPref);
            }
            Building bldg = room instanceof Room ? ((Room)room).getBuilding() : null;
            String bldgPref = null;
            for (BuildingPref p : bldgPrefs) {
                if (bldg == null || !bldg.equals(p.getBuilding())) continue;
                bldgPref = p.getPrefLevel().getPrefProlog();
                break;
            }
            if (bldgPref != null && bldgPref.equals(PreferenceLevel.sProhibited)) {
                if (interactiveMode) {
                    pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                } else {
                    add = false;
                }
            }
            if (reqBldg && (bldgPref == null || !bldgPref.equals(PreferenceLevel.sRequired))) {
                if (interactiveMode) {
                    pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                } else {
                    add = false;
                }
            }
            if (!reqBldg && bldgPref != null && bldgPref.equals(PreferenceLevel.sRequired)) {
                reqBldg = true;
                if (interactiveMode) {
                    for (RoomLocation r : roomLocations) {
                        r.setPreference(r.getPreference() + 100);
                    }
                } else {
                    roomLocations.clear();
                }
            }
            if (bldgPref != null && !bldgPref.equals(PreferenceLevel.sProhibited) && !bldgPref.equals(PreferenceLevel.sRequired)) {
                pref.addPreferenceProlog(bldgPref);
            }
            boolean acceptableFeatures = true;
            MinMaxPreferenceCombination featurePref = new MinMaxPreferenceCombination();
            for (RoomFeaturePref roomFeaturePref : featurePrefs) {
                RoomFeature feature = roomFeaturePref.getRoomFeature();
                String p = roomFeaturePref.getPrefLevel().getPrefProlog();
                boolean hasFeature = feature.getRooms().contains(room);
                if (p.equals(PreferenceLevel.sProhibited) && hasFeature) {
                    acceptableFeatures = false;
                }
                if (p.equals(PreferenceLevel.sRequired) && !hasFeature) {
                    acceptableFeatures = false;
                }
                if (p == null || !hasFeature || p.equals(PreferenceLevel.sProhibited) || p.equals(PreferenceLevel.sRequired)) continue;
                featurePref.addPreferenceProlog(p);
            }
            pref.addPreferenceInt(featurePref.getPreferenceInt());
            if (!acceptableFeatures) {
                if (interactiveMode) {
                    pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                } else {
                    add = false;
                }
            }
            if (clazz.getNbrRooms() <= 1 || !Boolean.TRUE.equals(clazz.isRoomsSplitAttendance())) {
                if (room.getCapacity() < stronglyDiscouragedCapacity) {
                    if (interactiveMode) {
                        pref.addPreferenceInt(1000);
                    } else {
                        add = false;
                    }
                } else if (room.getCapacity() < discouragedCapacity) {
                    pref.addPreferenceProlog(PreferenceLevel.sStronglyDiscouraged);
                } else if (room.getCapacity() < roomCapacity) {
                    pref.addPreferenceProlog(PreferenceLevel.sDiscouraged);
                }
            }
            int prefInt = pref.getPreferenceInt();
            if (!add) continue;
            roomLocations.add(new RoomLocation(room.getUniqueId(), room.getLabel(), bldg == null ? null : bldg.getUniqueId(), prefInt, room.getCapacity().intValue(), room.getCoordinateX(), room.getCoordinateY(), room.isIgnoreTooFar() == null ? false : room.isIgnoreTooFar(), null));
        }
        return roomLocations;
    }

    /*
     * WARNING - void declaration
     */
    private Lecture loadClass(Class_ clazz, org.unitime.timetable.model.Assignment assignment, org.hibernate.Session hibSession) {
        int nrRooms;
        if (clazz.isCancelled().booleanValue()) {
            this.iProgress.message(this.msglevel("cancelledClass", 5), MSG.warnCancelledClass(this.getClassLabel(clazz)));
            return null;
        }
        ArrayList<TimeLocation> timeLocations = new ArrayList<TimeLocation>();
        HashMap<Long, RoomLocation> roomLocations = new HashMap<Long, RoomLocation>();
        this.iProgress.message(this.msglevel("loadingClass", 1), MSG.debugLoadingClass(this.getClassLabel(clazz)));
        Department dept = clazz.getControllingDept();
        this.iDeptNames.put(dept.getUniqueId(), dept.getShortLabel());
        this.iProgress.trace("department: " + dept.getName() + " (id:" + dept.getUniqueId() + ")");
        int minClassLimit = clazz.getExpectedCapacity();
        int maxClassLimit = clazz.getMaxExpectedCapacity();
        if (maxClassLimit < minClassLimit) {
            maxClassLimit = minClassLimit;
        }
        if (clazz.getSchedulingSubpart().getInstrOfferingConfig().isUnlimitedEnrollment().booleanValue()) {
            maxClassLimit = Integer.MAX_VALUE;
            minClassLimit = Integer.MAX_VALUE;
        }
        float room2limitRatio = clazz.getRoomRatio().floatValue();
        int roomCapacity = Math.round(minClassLimit <= 0 ? room2limitRatio : room2limitRatio * (float)minClassLimit);
        this.iProgress.trace("class limit: [" + minClassLimit + "," + maxClassLimit + "]");
        this.iProgress.trace("room2limitRatio: " + room2limitRatio);
        this.iProgress.trace("room capacity: " + roomCapacity);
        int discouragedCapacity = (int)Math.round((1.0 - this.iFewerSeatsDisouraged) * (double)roomCapacity);
        this.iProgress.trace("discouraged capacity: " + discouragedCapacity);
        int stronglyDiscouragedCapacity = (int)Math.round((1.0 - this.iFewerSeatsStronglyDisouraged) * (double)roomCapacity);
        this.iProgress.trace("strongly discouraged capacity: " + stronglyDiscouragedCapacity);
        Set<TimePref> timePrefs = clazz.effectivePreferences(TimePref.class);
        if (timePrefs.isEmpty()) {
            if (clazz.getSchedulingSubpart().getMinutesPerWk() != 0) {
                DurationModel dm = clazz.getSchedulingSubpart().getInstrOfferingConfig().getDurationModel();
                this.iProgress.message(this.msglevel("noTimePattern", 5), MSG.warnNoTimePattern(this.getClassLabel(clazz), dm.getArrangedHours(clazz.getSchedulingSubpart().getMinutesPerWk(), clazz.effectiveDatePattern())));
            }
            return null;
        }
        HashSet<TimePattern> patterns = new HashSet<TimePattern>();
        DatePattern datePattern = clazz.effectiveDatePattern();
        if (datePattern == null) {
            this.iProgress.message(this.msglevel("noDatePattern", 5), MSG.warnNoDatePattern(this.getClassLabel(clazz)));
            return null;
        }
        this.iAllUsedDatePatterns.add(datePattern);
        int n = nrRooms = clazz.getNbrRooms() == null ? 1 : clazz.getNbrRooms();
        if (nrRooms > 0) {
            int maxRoomIndex = clazz.hasRoomIndexedPrefs() ? nrRooms - 1 : 0;
            for (int roomIndex = 0; roomIndex <= maxRoomIndex; ++roomIndex) {
                Set<RoomGroupPref> groupPrefs = clazz.effectivePreferences(RoomGroupPref.class);
                Set<RoomPref> roomPrefs = clazz.effectivePreferences(RoomPref.class);
                Set<BuildingPref> bldgPrefs = clazz.effectivePreferences(BuildingPref.class);
                Set<RoomFeaturePref> featurePrefs = clazz.effectivePreferences(RoomFeaturePref.class);
                if (maxRoomIndex > 0) {
                    Preference p;
                    Iterator<Preference> i = groupPrefs.iterator();
                    while (i.hasNext()) {
                        p = i.next();
                        if (((BaseRoomGroupPref)p).getRoomIndex() == null || ((BaseRoomGroupPref)p).getRoomIndex().equals(roomIndex)) continue;
                        i.remove();
                    }
                    i = roomPrefs.iterator();
                    while (i.hasNext()) {
                        p = (RoomPref)i.next();
                        if (((BaseRoomPref)p).getRoomIndex() == null || ((BaseRoomPref)p).getRoomIndex().equals(roomIndex)) continue;
                        i.remove();
                    }
                    i = bldgPrefs.iterator();
                    while (i.hasNext()) {
                        p = (BuildingPref)i.next();
                        if (((BaseBuildingPref)p).getRoomIndex() == null || ((BaseBuildingPref)p).getRoomIndex().equals(roomIndex)) continue;
                        i.remove();
                    }
                    i = featurePrefs.iterator();
                    while (i.hasNext()) {
                        p = (RoomFeaturePref)i.next();
                        if (((BaseRoomFeaturePref)p).getRoomIndex() == null || ((BaseRoomFeaturePref)p).getRoomIndex().equals(roomIndex)) continue;
                        i.remove();
                    }
                }
                boolean reqRoom = false;
                boolean reqBldg = false;
                boolean reqGroup = false;
                Set<Location> allRooms = clazz.getAvailableRooms();
                ArrayList<RoomLocation> roomLocationsThisIndex = new ArrayList<RoomLocation>();
                for (Location location : allRooms) {
                    this.iProgress.trace("checking room " + location.getLabel() + " ...");
                    boolean add = true;
                    SumPreferenceCombination pref = new SumPreferenceCombination();
                    PreferenceCombination groupPref = PreferenceCombination.getDefault();
                    for (RoomGroupPref p : groupPrefs) {
                        if (!p.getRoomGroup().getRooms().contains(location)) continue;
                        groupPref.addPreferenceProlog(p.getPrefLevel().getPrefProlog());
                    }
                    if (groupPref.getPreferenceProlog().equals(PreferenceLevel.sProhibited)) {
                        this.iProgress.trace("group is prohibited :-(");
                        if (this.iInteractiveMode || this.iAllowProhibitedRooms) {
                            pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                        } else {
                            add = false;
                        }
                    }
                    if (reqGroup && !groupPref.getPreferenceProlog().equals(PreferenceLevel.sRequired)) {
                        this.iProgress.trace("group is not required :-(");
                        if (this.iInteractiveMode || this.iAllowProhibitedRooms) {
                            pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                        } else {
                            add = false;
                        }
                    }
                    if (!reqGroup && groupPref.getPreferenceProlog().equals(PreferenceLevel.sRequired)) {
                        this.iProgress.trace("group is required, removing all previous rooms (they are not required)");
                        reqGroup = true;
                        if (this.iInteractiveMode || this.iAllowProhibitedRooms) {
                            for (RoomLocation r2 : roomLocationsThisIndex) {
                                r2.setPreference(r2.getPreference() + 100);
                            }
                        } else {
                            roomLocationsThisIndex.clear();
                        }
                    }
                    if (!groupPref.getPreferenceProlog().equals(PreferenceLevel.sProhibited) && !groupPref.getPreferenceProlog().equals(PreferenceLevel.sRequired)) {
                        pref.addPreferenceProlog(groupPref.getPreferenceProlog());
                    }
                    String roomPref = null;
                    boolean strDiscRoom = false;
                    PreferenceLevel roomPreference = this.getRoomPreference(clazz.getManagingDept().getUniqueId(), location.getUniqueId());
                    if (roomPreference != null) {
                        roomPref = roomPreference.getPrefProlog();
                        if (!this.iInteractiveMode && PreferenceLevel.sProhibited.equals(roomPref)) {
                            this.iProgress.trace("room is prohibited (on room level) :-(");
                            add = false;
                        }
                        if (PreferenceLevel.sStronglyDiscouraged.equals(roomPref)) {
                            roomPref = PreferenceLevel.sProhibited;
                            strDiscRoom = true;
                        }
                    }
                    for (RoomPref p : roomPrefs) {
                        if (!location.equals(p.getRoom())) continue;
                        strDiscRoom = false;
                        roomPref = p.getPrefLevel().getPrefProlog();
                        this.iProgress.trace("room preference is " + p.getPrefLevel().getPrefName());
                        break;
                    }
                    if (roomPref != null && roomPref.equals(PreferenceLevel.sProhibited)) {
                        this.iProgress.trace("room is prohibited :-(");
                        if (this.iInteractiveMode || this.iAllowProhibitedRooms && !strDiscRoom) {
                            pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                        } else {
                            add = false;
                        }
                    }
                    if (reqRoom && (roomPref == null || !roomPref.equals(PreferenceLevel.sRequired))) {
                        this.iProgress.trace("room is not required :-(");
                        if (this.iInteractiveMode || this.iAllowProhibitedRooms) {
                            pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                        } else {
                            add = false;
                        }
                    }
                    if (!reqRoom && roomPref != null && roomPref.equals(PreferenceLevel.sRequired)) {
                        this.iProgress.trace("room is required, removing all previous rooms (they are not required)");
                        reqRoom = true;
                        if (this.iInteractiveMode || this.iAllowProhibitedRooms) {
                            for (RoomLocation r3 : roomLocationsThisIndex) {
                                r3.setPreference(r3.getPreference() + 100);
                            }
                        } else {
                            roomLocationsThisIndex.clear();
                        }
                    }
                    if (roomPref != null && !roomPref.equals(PreferenceLevel.sProhibited) && !roomPref.equals(PreferenceLevel.sRequired)) {
                        pref.addPreferenceProlog(roomPref);
                    }
                    Building bldg = location instanceof Room ? ((Room)location).getBuilding() : null;
                    String bldgPref = null;
                    for (BuildingPref p : bldgPrefs) {
                        if (bldg == null || !bldg.equals(p.getBuilding())) continue;
                        bldgPref = p.getPrefLevel().getPrefProlog();
                        this.iProgress.trace("building preference is " + p.getPrefLevel().getPrefName());
                        break;
                    }
                    if (bldgPref != null && bldgPref.equals(PreferenceLevel.sProhibited)) {
                        this.iProgress.trace("building is prohibited :-(");
                        if (this.iInteractiveMode || this.iAllowProhibitedRooms) {
                            pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                        } else {
                            add = false;
                        }
                    }
                    if (reqBldg && (bldgPref == null || !bldgPref.equals(PreferenceLevel.sRequired))) {
                        this.iProgress.trace("building is not required :-(");
                        if (this.iInteractiveMode || this.iAllowProhibitedRooms) {
                            pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                        } else {
                            add = false;
                        }
                    }
                    if (!reqBldg && bldgPref != null && bldgPref.equals(PreferenceLevel.sRequired)) {
                        this.iProgress.trace("building is required, removing all previous rooms (they are not required)");
                        reqBldg = true;
                        if (this.iInteractiveMode || this.iAllowProhibitedRooms) {
                            for (RoomLocation r4 : roomLocationsThisIndex) {
                                r4.setPreference(r4.getPreference() + 100);
                            }
                        } else {
                            roomLocationsThisIndex.clear();
                        }
                    }
                    if (bldgPref != null && !bldgPref.equals(PreferenceLevel.sProhibited) && !bldgPref.equals(PreferenceLevel.sRequired)) {
                        pref.addPreferenceProlog(bldgPref);
                    }
                    boolean acceptableFeatures = true;
                    MinMaxPreferenceCombination featurePref = new MinMaxPreferenceCombination();
                    for (RoomFeaturePref roomFeaturePref : featurePrefs) {
                        RoomFeature feature = roomFeaturePref.getRoomFeature();
                        String p = roomFeaturePref.getPrefLevel().getPrefProlog();
                        boolean hasFeature = feature.getRooms().contains(location);
                        if (p.equals(PreferenceLevel.sProhibited) && hasFeature) {
                            this.iProgress.trace("present feature " + feature.getLabel() + " is prohibited :-(");
                            acceptableFeatures = false;
                        }
                        if (p.equals(PreferenceLevel.sRequired) && !hasFeature) {
                            this.iProgress.trace("not present feature " + feature.getLabel() + " is required :-(");
                            acceptableFeatures = false;
                        }
                        if (p == null || !hasFeature || p.equals(PreferenceLevel.sProhibited) || p.equals(PreferenceLevel.sRequired)) continue;
                        featurePref.addPreferenceProlog(p);
                    }
                    pref.addPreferenceInt(featurePref.getPreferenceInt());
                    if (!acceptableFeatures) {
                        if (this.iInteractiveMode || this.iAllowProhibitedRooms) {
                            pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                        } else {
                            add = false;
                        }
                    }
                    if (clazz.getNbrRooms() <= 1 || !Boolean.TRUE.equals(clazz.isRoomsSplitAttendance())) {
                        if (location.getCapacity() < stronglyDiscouragedCapacity) {
                            this.iProgress.trace("too small :-(");
                            if (this.iInteractiveMode) {
                                pref.addPreferenceInt(1000);
                            } else {
                                add = false;
                            }
                        } else if (location.getCapacity() < discouragedCapacity) {
                            this.iProgress.trace("room of strongly discouraged size");
                            pref.addPreferenceProlog(PreferenceLevel.sStronglyDiscouraged);
                        } else if (location.getCapacity() < roomCapacity) {
                            this.iProgress.trace("room of discouraged size");
                            pref.addPreferenceProlog(PreferenceLevel.sDiscouraged);
                        }
                    }
                    int prefInt = pref.getPreferenceInt();
                    this.iProgress.trace("room preference is " + prefInt);
                    if (!add) continue;
                    roomLocationsThisIndex.add(new RoomLocation(location.getUniqueId(), location.getLabel(), bldg == null ? null : bldg.getUniqueId(), prefInt, location.getCapacity().intValue(), location.getCoordinateX(), location.getCoordinateY(), location.isIgnoreTooFar() == null ? false : location.isIgnoreTooFar(), this.getRoomConstraint(clazz.getManagingDept(), location, hibSession)));
                }
                if (roomIndex == 0) {
                    for (RoomLocation roomLocation : roomLocationsThisIndex) {
                        roomLocations.put(roomLocation.getId(), roomLocation);
                    }
                    continue;
                }
                HashSet untouched = new HashSet(roomLocations.keySet());
                for (RoomLocation r6 : roomLocationsThisIndex) {
                    RoomLocation original = (RoomLocation)roomLocations.get(r6.getId());
                    if (original != null) {
                        if (r6.getPreference() != original.getPreference()) {
                            original.setPreference(roomIndex, r6.getPreference());
                        }
                        untouched.remove(r6.getId());
                        continue;
                    }
                    roomLocations.put(r6.getId(), r6);
                    for (int idx = 0; idx < roomIndex; ++idx) {
                        r6.setPreference(idx, Constants.sPreferenceLevelProhibited);
                    }
                }
                for (Long id : untouched) {
                    ((RoomLocation)roomLocations.get(id)).setPreference(roomIndex, Constants.sPreferenceLevelProhibited);
                }
            }
            if (roomLocations.isEmpty() || roomLocations.size() < nrRooms) {
                this.iProgress.message(this.msglevel("noRoom", 5), clazz.getNbrRooms() > 1 ? MSG.warnNoRooms(this.getClassLabel(clazz)) : MSG.warnNoRoom(this.getClassLabel(clazz)));
                return null;
            }
        } else {
            Set<RoomGroupPref> groupPrefs = clazz.effectivePreferences(RoomGroupPref.class);
            Set<RoomPref> roomPrefs = clazz.effectivePreferences(RoomPref.class);
            Set<BuildingPref> bldgPrefs = clazz.effectivePreferences(BuildingPref.class);
            Set<RoomFeaturePref> featurePrefs = clazz.effectivePreferences(RoomFeaturePref.class);
            if (!(groupPrefs.isEmpty() && roomPrefs.isEmpty() && bldgPrefs.isEmpty() && featurePrefs.isEmpty())) {
                this.iProgress.message(this.msglevel("zeroRoomsButPref", 5), MSG.warnZeroRoomsButPref(this.getClassLabel(clazz)));
            }
        }
        if (assignment != null && assignment.getTimeLocation() != null) {
            timeLocations.clear();
            timeLocations.add(assignment.getTimeLocation());
            this.iProgress.debug(this.getClassLabel(clazz) + " is fixed in " + assignment.getTimeLocation().getLongName(this.iUseAmPm));
        } else {
            int day;
            int minPerWeek = clazz.getSchedulingSubpart().getMinutesPerWk();
            boolean onlyReq = false;
            for (TimePref timePref : timePrefs) {
                TimePatternModel pattern = timePref.getTimePatternModel();
                if (!pattern.isExactTime() && pattern.countPreferences(PreferenceLevel.sRequired) <= 0) continue;
                onlyReq = true;
            }
            if (onlyReq) {
                this.iProgress.trace("time pattern has required times");
            }
            ClassDurationType dtype = clazz.getSchedulingSubpart().getInstrOfferingConfig().getEffectiveDurationType();
            DurationModel dm = clazz.getSchedulingSubpart().getInstrOfferingConfig().getDurationModel();
            for (TimePref timePref : timePrefs) {
                TimeLocation loc;
                String pr;
                TimePatternModel pattern = timePref.getTimePatternModel();
                if (pattern.isExactTime()) {
                    if (datePattern.isPatternSet()) {
                        Set<DatePatternPref> datePatternPrefs = clazz.effectivePreferences(DatePatternPref.class);
                        boolean hasReq = false;
                        for (DatePatternPref p : datePatternPrefs) {
                            if (!PreferenceLevel.sRequired.equals(p.getPrefLevel().getPrefProlog())) continue;
                            hasReq = true;
                            break;
                        }
                        for (DatePattern child : datePattern.findChildren()) {
                            int minsPerMeeting = dm.getExactTimeMinutesPerMeeting(clazz.getSchedulingSubpart().getMinutesPerWk(), child, pattern.getExactDays());
                            int n2 = ExactTimeMins.getNrSlotsPerMtg(minsPerMeeting);
                            int breakTime = ExactTimeMins.getBreakTime(minsPerMeeting);
                            pr = PreferenceLevel.sNeutral;
                            for (DatePatternPref p : datePatternPrefs) {
                                if (!p.getDatePattern().equals(child)) continue;
                                pr = p.getPrefLevel().getPrefProlog();
                            }
                            int prVal = 0;
                            if (!PreferenceLevel.sNeutral.equals(pr) && !PreferenceLevel.sRequired.equals(pr)) {
                                prVal = PreferenceLevel.prolog2int(pr);
                            }
                            if (this.iInteractiveMode) {
                                if (hasReq && !PreferenceLevel.sRequired.equals(pr)) {
                                    prVal += 100;
                                }
                                if (PreferenceLevel.sProhibited.equals(pr)) {
                                    prVal += 100;
                                }
                            } else if (hasReq && !PreferenceLevel.sRequired.equals(pr) || PreferenceLevel.sProhibited.equals(pr)) continue;
                            TimeLocation loc2 = new TimeLocation(pattern.getExactDays(), pattern.getExactStartSlot(), n2, PreferenceLevel.sIntLevelNeutral, 0.0, PreferenceLevel.prolog2int(pr), child.getUniqueId(), child.getName(), child.getPatternBitSet(), breakTime);
                            loc2.setTimePatternId(pattern.getTimePattern().getUniqueId());
                            if (!PreferenceLevel.sNeutral.equals(pr) && !PreferenceLevel.sRequired.equals(pr)) {
                                loc2.setNormalizedPreference(this.iAlterDatePatternWeight * (double)prVal);
                            }
                            if (loc2.getStartSlot() + loc2.getLength() > 288) {
                                this.iProgress.message(this.msglevel("timeOverMidnight", 6), MSG.warnExactTimeOverMidnight(this.getClassLabel(clazz), loc2.getName(this.iUseAmPm)));
                                continue;
                            }
                            boolean validTime = true;
                            TimeLocation.IntEnumeration e = loc2.getDays();
                            while (e.hasMoreElements()) {
                                int dayCode = Constants.DAY_CODES[(Integer)e.nextElement()];
                                if (dm.isValidSelection(clazz.getSchedulingSubpart().getMinutesPerWk(), child, timePref.getTimePattern(), dayCode)) continue;
                                this.iProgress.debug("time " + loc2.getLongName(this.iUseAmPm) + " is not valid :-(");
                                validTime = false;
                            }
                            if (!validTime) continue;
                            timeLocations.add(loc2);
                        }
                        continue;
                    }
                    int minsPerMeeting = dm.getExactTimeMinutesPerMeeting(clazz.getSchedulingSubpart().getMinutesPerWk(), datePattern, pattern.getExactDays());
                    int length = ExactTimeMins.getNrSlotsPerMtg(minsPerMeeting);
                    int breakTime = ExactTimeMins.getBreakTime(minsPerMeeting);
                    loc = new TimeLocation(pattern.getExactDays(), pattern.getExactStartSlot(), length, PreferenceLevel.sIntLevelNeutral, 0.0, datePattern.getUniqueId(), datePattern.getName(), datePattern.getPatternBitSet(), breakTime);
                    loc.setTimePatternId(pattern.getTimePattern().getUniqueId());
                    if (loc.getStartSlot() + loc.getLength() > 288) {
                        this.iProgress.message(this.msglevel("timeOverMidnight", 6), MSG.warnExactTimeOverMidnight(this.getClassLabel(clazz), loc.getName(this.iUseAmPm)));
                        continue;
                    }
                    boolean validTime = true;
                    TimeLocation.IntEnumeration intEnumeration = loc.getDays();
                    while (intEnumeration.hasMoreElements()) {
                        int dayCode = Constants.DAY_CODES[(Integer)intEnumeration.nextElement()];
                        if (dm.isValidSelection(clazz.getSchedulingSubpart().getMinutesPerWk(), datePattern, timePref.getTimePattern(), dayCode)) continue;
                        this.iProgress.debug("time " + loc.getLongName(this.iUseAmPm) + " is not valid :-(");
                        validTime = false;
                    }
                    if (!validTime) continue;
                    timeLocations.add(loc);
                    continue;
                }
                patterns.add(pattern.getTimePattern());
                if (this.iWeakenTimePreferences) {
                    pattern.weakenHardPreferences();
                    onlyReq = false;
                }
                if (!dm.isValidCombination(clazz.getSchedulingSubpart().getMinutesPerWk(), datePattern, timePref.getTimePattern())) {
                    this.iProgress.message(this.msglevel("noTimePattern", 5), MSG.warnWrongTimePattern(this.getClassLabel(clazz), clazz.getSchedulingSubpart().getMinutesPerWk(), dtype == null ? MSG.defaultDurationTypeName() : dtype.getLabel(), pattern.getName()));
                    minPerWeek = pattern.getMinPerMtg() * pattern.getNrMeetings();
                    if (this.iFixMinPerWeek) {
                        clazz.getSchedulingSubpart().setMinutesPerWk(minPerWeek);
                    }
                }
                for (int time = 0; time < pattern.getNrTimes(); ++time) {
                    if (pattern.getStartSlot(time) + pattern.getSlotsPerMtg() > 288) {
                        this.iProgress.message(this.msglevel("timeOverMidnight", 5), MSG.warnTimeOverMidnight(pattern.getName(), this.getClassLabel(clazz), pattern.getStartTime(time)));
                        continue;
                    }
                    for (day = 0; day < pattern.getNrDays(); ++day) {
                        String altPref;
                        String pref = pattern.getPreference(day, time);
                        this.iProgress.trace("checking time " + pattern.getDayHeader(day) + " " + pattern.getTimeHeaderShort(time) + " (" + pref + ")");
                        if (!dm.isValidSelection(clazz.getSchedulingSubpart().getMinutesPerWk(), datePattern, timePref.getTimePattern(), pattern.getDayCode(day))) {
                            this.iProgress.trace("time is not valid :-(");
                            continue;
                        }
                        if (!this.iInteractiveMode && pref.equals(PreferenceLevel.sProhibited)) {
                            this.iProgress.trace("time is prohibited :-(");
                            continue;
                        }
                        if (!this.iInteractiveMode && onlyReq && !pref.equals(PreferenceLevel.sRequired)) {
                            this.iProgress.trace("time is not required :-(");
                            continue;
                        }
                        if (datePattern.isPatternSet()) {
                            Set<DatePatternPref> datePatternPrefs = clazz.effectivePreferences(DatePatternPref.class);
                            boolean hasReq = false;
                            for (DatePatternPref p : datePatternPrefs) {
                                if (!PreferenceLevel.sRequired.equals(p.getPrefLevel().getPrefProlog())) continue;
                                hasReq = true;
                                break;
                            }
                            for (DatePattern child : datePattern.findChildren()) {
                                String altPref2;
                                if (!dm.isValidSelection(clazz.getSchedulingSubpart().getMinutesPerWk(), child, timePref.getTimePattern(), pattern.getDayCode(day))) continue;
                                pr = PreferenceLevel.sNeutral;
                                for (DatePatternPref p : datePatternPrefs) {
                                    if (!p.getDatePattern().equals(child)) continue;
                                    pr = p.getPrefLevel().getPrefProlog();
                                }
                                int prVal = 0;
                                if (!PreferenceLevel.sNeutral.equals(pr) && !PreferenceLevel.sRequired.equals(pr)) {
                                    prVal = PreferenceLevel.prolog2int(pr);
                                }
                                if (this.iInteractiveMode) {
                                    if (hasReq && !PreferenceLevel.sRequired.equals(pr)) {
                                        prVal += 100;
                                    }
                                    if (PreferenceLevel.sProhibited.equals(pr)) {
                                        prVal += 100;
                                    }
                                } else if (hasReq && !PreferenceLevel.sRequired.equals(pr) || PreferenceLevel.sProhibited.equals(pr)) continue;
                                TimeLocation loc2 = new TimeLocation(pattern.getDayCode(day), pattern.getStartSlot(time), pattern.getSlotsPerMtg(), PreferenceLevel.prolog2int(pattern.getPreference(day, time)), pattern.getNormalizedPreference(day, time, this.iNormalizedPrefDecreaseFactor), PreferenceLevel.prolog2int(pr), child.getUniqueId(), child.getName(), child.getPatternBitSet(), pattern.getBreakTime());
                                loc2.setTimePatternId(pattern.getTimePattern().getUniqueId());
                                if (this.iAlterTimePatternWeight != 0.0 && !(altPref2 = this.iAlterTimePatternModel.getCombinedPreference(loc2.getDayCode(), loc2.getStartSlot(), loc2.getLength(), 2)).equals(PreferenceLevel.sNeutral)) {
                                    loc2.setNormalizedPreference(loc2.getNormalizedPreference() + this.iAlterTimePatternWeight * (double)PreferenceLevel.prolog2int(altPref2));
                                }
                                if (this.iInteractiveMode && onlyReq && !pref.equals(PreferenceLevel.sRequired)) {
                                    loc2.setPreference(PreferenceLevel.sIntLevelProhibited);
                                    loc2.setNormalizedPreference((double)PreferenceLevel.sIntLevelProhibited);
                                }
                                if (!PreferenceLevel.sNeutral.equals(pr) && !PreferenceLevel.sRequired.equals(pr)) {
                                    loc2.setNormalizedPreference(loc2.getNormalizedPreference() + this.iAlterDatePatternWeight * (double)prVal);
                                }
                                timeLocations.add(loc2);
                            }
                            continue;
                        }
                        loc = new TimeLocation(pattern.getDayCode(day), pattern.getStartSlot(time), pattern.getSlotsPerMtg(), PreferenceLevel.prolog2int(pattern.getPreference(day, time)), pattern.getNormalizedPreference(day, time, this.iNormalizedPrefDecreaseFactor), datePattern.getUniqueId(), datePattern.getName(), datePattern.getPatternBitSet(), pattern.getBreakTime());
                        loc.setTimePatternId(pattern.getTimePattern().getUniqueId());
                        if (this.iAlterTimePatternWeight != 0.0 && !(altPref = this.iAlterTimePatternModel.getCombinedPreference(loc.getDayCode(), loc.getStartSlot(), loc.getLength(), 2)).equals(PreferenceLevel.sNeutral)) {
                            loc.setNormalizedPreference(loc.getNormalizedPreference() + this.iAlterTimePatternWeight * (double)PreferenceLevel.prolog2int(altPref));
                        }
                        if (this.iInteractiveMode && onlyReq && !pref.equals(PreferenceLevel.sRequired)) {
                            loc.setPreference(PreferenceLevel.sIntLevelProhibited);
                            loc.setNormalizedPreference((double)PreferenceLevel.sIntLevelProhibited);
                        }
                        timeLocations.add(loc);
                    }
                }
            }
            if (this.iInteractiveMode) {
                for (TimePattern pattern : TimePattern.findApplicable(this.iSession, false, false, false, minPerWeek, datePattern, dm, clazz.getManagingDept())) {
                    if (patterns.contains(pattern)) continue;
                    TimePatternModel model = pattern.getTimePatternModel();
                    this.iProgress.trace("adding prohibited pattern " + model.getName());
                    for (int time = 0; time < model.getNrTimes(); ++time) {
                        for (day = 0; day < model.getNrDays(); ++day) {
                            if (datePattern.isPatternSet()) {
                                Set<DatePatternPref> datePatternPrefs = clazz.effectivePreferences(DatePatternPref.class);
                                for (DatePattern child : datePattern.findChildren()) {
                                    void var29_65;
                                    if (!dm.isValidSelection(clazz.getSchedulingSubpart().getMinutesPerWk(), child, pattern, model.getDayCode(day))) continue;
                                    String string = PreferenceLevel.sNeutral;
                                    for (DatePatternPref p : datePatternPrefs) {
                                        if (!p.getDatePattern().equals(child)) continue;
                                        String string2 = p.getPrefLevel().getPrefProlog();
                                    }
                                    TimeLocation loc = new TimeLocation(model.getDayCode(day), model.getStartSlot(time), model.getSlotsPerMtg(), PreferenceLevel.prolog2int(model.getPreference(day, time)), model.getNormalizedPreference(day, time, this.iNormalizedPrefDecreaseFactor), PreferenceLevel.prolog2int((String)var29_65), child.getUniqueId(), child.getName(), child.getPatternBitSet(), model.getBreakTime());
                                    loc.setTimePatternId(model.getTimePattern().getUniqueId());
                                    loc.setPreference(1000);
                                    loc.setNormalizedPreference(1000.0);
                                    timeLocations.add(loc);
                                }
                                continue;
                            }
                            if (!dm.isValidSelection(clazz.getSchedulingSubpart().getMinutesPerWk(), datePattern, pattern, model.getDayCode(day))) continue;
                            TimeLocation loc = new TimeLocation(model.getDayCode(day), model.getStartSlot(time), model.getSlotsPerMtg(), PreferenceLevel.prolog2int(model.getPreference(day, time)), model.getNormalizedPreference(day, time, this.iNormalizedPrefDecreaseFactor), datePattern.getUniqueId(), datePattern.getName(), datePattern.getPatternBitSet(), model.getBreakTime());
                            loc.setTimePatternId(model.getTimePattern().getUniqueId());
                            loc.setPreference(1000);
                            loc.setNormalizedPreference(1000.0);
                            timeLocations.add(loc);
                        }
                    }
                }
            }
        }
        if (timeLocations.isEmpty()) {
            this.iProgress.message(this.msglevel("noTime", 5), MSG.warnNoTime(this.getClassLabel(clazz)));
            return null;
        }
        List<DepartmentalInstructor> instructors = clazz.getLeadInstructors();
        String className = clazz.getClassLabel(this.iShowClassSuffix, this.iShowConfigName);
        Lecture lecture = new Lecture(clazz.getUniqueId(), clazz.getManagingDept().getSolverGroup().getUniqueId(), clazz.getSchedulingSubpart().getUniqueId(), className, timeLocations, roomLocations.values(), nrRooms, null, minClassLimit, maxClassLimit, (double)room2limitRatio);
        lecture.setNote(clazz.getNotes());
        if (clazz.getManagingDept() != null) {
            lecture.setScheduler(clazz.getManagingDept().getUniqueId());
        }
        lecture.setDepartment(dept.getUniqueId());
        for (DepartmentalInstructor instructor : instructors) {
            this.getInstructorConstraint(instructor, hibSession).addVariable((Variable)lecture);
        }
        if (nrRooms > 1) {
            lecture.setMaxRoomCombinations(this.iMaxRoomCombinations);
        }
        lecture.setSplitAttendance(nrRooms > 1 && Boolean.TRUE.equals(clazz.isRoomsSplitAttendance()));
        long estNrValues = lecture.nrValues();
        if (estNrValues > 1000000L) {
            this.iProgress.message(this.msglevel("hugeDomain", 5), MSG.warnHugeDomain(this.getClassLabel(lecture), estNrValues));
            for (DepartmentalInstructor instructor : instructors) {
                this.getInstructorConstraint(instructor, hibSession).removeVariable((Variable)lecture);
            }
            return null;
        }
        if (estNrValues > 10000L) {
            this.iProgress.message(this.msglevel("bigDomain", 5), MSG.warnBigDomain(this.getClassLabel(lecture), estNrValues));
        }
        if (lecture.computeValues(this.getAssignment(), ((TimetableModel)this.getModel()).isAllowBreakHard()).isEmpty()) {
            if (!this.iInteractiveMode) {
                this.iProgress.message(this.msglevel("noPlacement", 5), MSG.warnNoPlacement(this.getClassLabel(lecture)));
                for (DepartmentalInstructor instructor : instructors) {
                    this.getInstructorConstraint(instructor, hibSession).removeVariable((Variable)lecture);
                }
                return null;
            }
            this.iProgress.message(this.msglevel("noPlacement", 5), MSG.warnNoPlacementInteractive(this.getClassLabel(lecture)));
        }
        if (this.iClassWeightProvider != null) {
            lecture.setWeight(this.iClassWeightProvider.getWeight(lecture, clazz));
        }
        this.iLectures.put(clazz.getUniqueId(), lecture);
        ((TimetableModel)this.getModel()).addVariable((Variable)lecture);
        for (RoomLocation r : roomLocations.values()) {
            r.getRoomConstraint().addVariable((Variable)lecture);
        }
        return lecture;
    }

    private void assignCommited() {
        if (!((TimetableModel)this.getModel()).hasConstantVariables()) {
            return;
        }
        this.setPhase(MSG.phaseAssignCommitted(), ((TimetableModel)this.getModel()).constantVariables().size());
        for (Lecture lecture : ((TimetableModel)this.getModel()).constantVariables()) {
            this.incProgress();
            if (this.getAssignment().getValue((Variable)lecture) != null) continue;
            Placement placement = (Placement)lecture.getInitialAssignment();
            ((TimetableModel)this.getModel()).weaken(this.getAssignment(), (Value)placement);
            Map conflictConstraints = ((TimetableModel)this.getModel()).conflictConstraints(this.getAssignment(), (Value)placement);
            if (conflictConstraints.isEmpty()) {
                this.getAssignment().assign(0L, (Value)placement);
                continue;
            }
            Object warn = MSG.warnCannotAssignCommitted(this.getClassLabel(lecture), placement.getLongName(this.iUseAmPm));
            warn = (String)warn + MSG.warnReasonFirstLine();
            for (Constraint c : conflictConstraints.keySet()) {
                Set vals = (Set)conflictConstraints.get(c);
                for (Placement v : vals) {
                    warn = (String)warn + MSG.warnReasonConflict(this.getClassLabel((Lecture)v.variable()), v.getLongName(this.iUseAmPm));
                }
                warn = (String)warn + MSG.warnReasonConstraint(TimetableSolver.getConstraintName((Constraint<Lecture, Placement>)c));
                this.iProgress.message(this.msglevel("cannotAssignCommitted", 5), (String)warn);
            }
        }
    }

    private void purgeInvalidValues() {
        this.setPhase(MSG.phasePurgeInvalidValues(), ((TimetableModel)this.getModel()).variables().size());
        for (Lecture lecture : new ArrayList(((TimetableModel)this.getModel()).variables())) {
            ArrayList oldValues = new ArrayList(lecture.values(this.getAssignment()));
            lecture.purgeInvalidValues(this.iInteractiveMode);
            if (lecture.values(this.getAssignment()).isEmpty()) {
                Object warn = this.iInteractiveMode ? MSG.warnNoPlacementAfterCommitInteractive(this.getClassLabel(lecture)) : MSG.warnNoPlacementAfterCommit(this.getClassLabel(lecture));
                for (Placement p : oldValues) {
                    warn = (String)warn + MSG.warnReasonNotValid(TimetableSolver.getNotValidReason(p, (Assignment<Lecture, Placement>)this.getAssignment(), this.iUseAmPm));
                }
                this.iProgress.message(this.msglevel("noPlacementAfterCommit", 5), (String)warn);
                if (!this.iInteractiveMode) {
                    ((TimetableModel)this.getModel()).removeVariable((Variable)lecture);
                    for (Constraint c : new ArrayList(lecture.constraints())) {
                        c.removeVariable((Variable)lecture);
                        if (!c.variables().isEmpty() && !(c instanceof BinaryConstraint)) continue;
                        ((TimetableModel)this.getModel()).removeConstraint(c);
                    }
                    for (org.cpsolver.coursett.model.Student s : lecture.students()) {
                        s.getLectures().remove(lecture);
                    }
                }
            }
            this.incProgress();
        }
    }

    private void loadAssignment(org.unitime.timetable.model.Assignment assignment) {
        Set vals;
        Lecture lecture = this.iLectures.get(assignment.getClazz().getUniqueId());
        int dayCode = assignment.getDays();
        int startSlot = assignment.getStartSlot();
        Long patternId = assignment.getTimePattern().getUniqueId();
        DatePattern datePattern = assignment.getDatePattern();
        Set<Location> rooms = assignment.getRooms();
        if (lecture == null) {
            return;
        }
        Object initialPlacement = null;
        for (Object placement : lecture.values(this.getAssignment())) {
            if (placement.getTimeLocation().getDayCode() != dayCode || placement.getTimeLocation().getStartSlot() != startSlot || !placement.getTimeLocation().getTimePatternId().equals(patternId) || datePattern != null && !placement.getTimeLocation().getDatePatternId().equals(datePattern.getUniqueId()) || rooms.size() != placement.getNrRooms()) continue;
            boolean sameRooms = true;
            Iterator<Location> i = rooms.iterator();
            while (sameRooms && i.hasNext()) {
                Location r = i.next();
                if (placement.hasRoomLocation(r.getUniqueId())) continue;
                sameRooms = false;
            }
            if (!sameRooms) continue;
            initialPlacement = placement;
            break;
        }
        if (initialPlacement == null) {
            TimeLocation timeLocation = null;
            for (TimeLocation t : lecture.timeLocations()) {
                if (t.getDayCode() != dayCode || t.getStartSlot() != startSlot || !t.getTimePatternId().equals(patternId) || datePattern != null && !t.getDatePatternId().equals(datePattern.getUniqueId())) continue;
                timeLocation = t;
                break;
            }
            ArrayList<RoomLocation> roomLocations = new ArrayList<RoomLocation>();
            for (Location room : rooms) {
                for (RoomLocation r : lecture.roomLocations()) {
                    if (!r.getId().equals(room.getUniqueId())) continue;
                    roomLocations.add(r);
                }
            }
            if (timeLocation != null && roomLocations.size() == lecture.getNrRooms()) {
                initialPlacement = new Placement(lecture, timeLocation, roomLocations);
            }
        }
        if (initialPlacement == null) {
            StringBuffer sb = new StringBuffer(assignment.getTimeLocation().getLongName(this.iUseAmPm) + " ");
            Iterator<Object> i = rooms.iterator();
            while (i.hasNext()) {
                sb.append(((Location)i.next()).getLabel());
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
            if (!assignment.getInstructors().isEmpty()) {
                sb.append(" ");
                i = assignment.getInstructors().iterator();
                while (i.hasNext()) {
                    sb.append(((DepartmentalInstructor)i.next()).getName(this.iInstructorFormat));
                    if (!i.hasNext()) continue;
                    sb.append(", ");
                }
            }
            this.iProgress.message(this.msglevel("placementNotValid", 5), MSG.warnPlacementNotValid(this.getClassLabel(lecture), sb.toString()));
            return;
        }
        if (!initialPlacement.isValid()) {
            Map conflictConstraints;
            Object reason = "";
            for (InstructorConstraint ic : lecture.getInstructorConstraints()) {
                if (ic.isAvailable(lecture, initialPlacement)) continue;
                reason = (String)reason + MSG.warnReasonInstructorNotAvailable(ic.getName());
            }
            if (lecture.getNrRooms() > 0) {
                if (initialPlacement.isMultiRoom()) {
                    for (RoomLocation roomLocation : initialPlacement.getRoomLocations()) {
                        if (roomLocation.getRoomConstraint().isAvailable(lecture, initialPlacement.getTimeLocation(), lecture.getScheduler())) continue;
                        reason = (String)reason + MSG.warnReasonRoomNotAvailable(roomLocation.getName());
                    }
                } else if (!initialPlacement.getRoomLocation().getRoomConstraint().isAvailable(lecture, initialPlacement.getTimeLocation(), lecture.getScheduler())) {
                    reason = (String)reason + MSG.warnReasonRoomNotAvailable(initialPlacement.getRoomLocation().getName());
                }
            }
            if (lecture.getNrRooms() > 1 && lecture.isSplitAttendance() && initialPlacement.getRoomSize() < lecture.minRoomUse()) {
                reason = (String)reason + MSG.warnReasonSelectedRoomsTooSmall(initialPlacement.getRoomSize(), lecture.minRoomUse());
            }
            if (initialPlacement.isMultiRoom() && initialPlacement.isRoomProhibited()) {
                int roomIndex = 0;
                for (Object r : initialPlacement.getRoomLocations()) {
                    if ("P".equals(Constants.preferenceLevel2preference((int)r.getPreference(roomIndex)))) {
                        reason = (String)reason + MSG.warnReasonInvalidRoomCombinationProhibitedRoom(r.getName(), roomIndex + 1);
                    }
                    ++roomIndex;
                }
            }
            if (initialPlacement.isMultiRoom()) {
                for (RoomLocation r1 : initialPlacement.getRoomLocations()) {
                    for (RoomLocation r2 : initialPlacement.getRoomLocations()) {
                        if (r2.getRoomConstraint() == null || r2.getRoomConstraint().getParentRoom() == null || !r2.getRoomConstraint().getParentRoom().equals((Object)r1.getRoomConstraint())) continue;
                        reason = (String)reason + MSG.warnReasonInvalidRoomCombinationPartition(r2.getName(), r1.getName());
                    }
                }
            }
            if (!(conflictConstraints = ((TimetableModel)this.getModel()).conflictConstraints(this.getAssignment(), (Value)initialPlacement)).isEmpty()) {
                for (Constraint c : conflictConstraints.keySet()) {
                    vals = (Set)conflictConstraints.get(c);
                    for (Placement p : vals) {
                        Lecture l = (Lecture)p.variable();
                        if (l.isCommitted()) {
                            reason = (String)reason + MSG.warnReasonConstraintCommitedAssignment(this.getClassLabel(l), p.getLongName(this.iUseAmPm), TimetableSolver.getConstraintName((Constraint<Lecture, Placement>)c));
                        }
                        if (!p.equals(initialPlacement)) continue;
                        reason = (String)reason + MSG.warnReasonConstraint(TimetableSolver.getConstraintName((Constraint<Lecture, Placement>)c));
                    }
                }
            }
            if (((String)reason).isEmpty()) {
                this.iProgress.message(this.msglevel("cannotAssign", 5), MSG.warnCannotAssignClass(this.getClassLabel(lecture), initialPlacement.getLongName(this.iUseAmPm)));
            } else {
                this.iProgress.message(this.msglevel("cannotAssign", 5), MSG.warnCannotAssignClassWithReason(this.getClassLabel(lecture), initialPlacement.getLongName(this.iUseAmPm), (String)reason));
            }
        } else {
            if (this.iMppAssignment) {
                lecture.setInitialAssignment(initialPlacement);
            }
            ((TimetableModel)this.getModel()).weaken(this.getAssignment(), initialPlacement);
            Map conflictConstraints = ((TimetableModel)this.getModel()).conflictConstraints(this.getAssignment(), initialPlacement);
            if (conflictConstraints.isEmpty()) {
                this.getAssignment().assign(0L, initialPlacement);
            } else {
                Object warn = MSG.warnCannotAssignClass(this.getClassLabel(lecture), initialPlacement.getLongName(this.iUseAmPm));
                warn = (String)warn + MSG.warnReasonFirstLine();
                for (Constraint c : conflictConstraints.keySet()) {
                    vals = (Set)conflictConstraints.get(c);
                    for (Placement v : vals) {
                        warn = (String)warn + MSG.warnReasonConflict(this.getClassLabel((Lecture)v.variable()), v.getLongName(this.iUseAmPm));
                    }
                    warn = (String)warn + MSG.warnReasonConstraint(TimetableSolver.getConstraintName((Constraint<Lecture, Placement>)c));
                    this.iProgress.message(this.msglevel("cannotAssign", 5), (String)warn);
                }
            }
        }
    }

    private RoomConstraint getRoomConstraint(Department dept, Location location, org.hibernate.Session hibSession) {
        RoomConstraint rc = this.iRooms.get(location.getUniqueId());
        if (rc == null) {
            PreferenceLevel roomPreference = this.getRoomPreference(dept.getUniqueId(), location.getUniqueId());
            boolean discouraged = !this.iInteractiveMode && roomPreference != null && (roomPreference.getPrefProlog().equals(PreferenceLevel.sProhibited) || roomPreference.getPrefProlog().equals(PreferenceLevel.sStronglyDiscouraged) || roomPreference.getPrefProlog().equals(PreferenceLevel.sDiscouraged));
            org.unitime.timetable.model.RoomSharingModel sharingModel = location.getRoomSharingModel();
            if (sharingModel != null && this.iIgnoreRoomSharing) {
                for (int d = 0; d < sharingModel.getNrDays(); ++d) {
                    for (int t = 0; t < sharingModel.getNrTimes(); ++t) {
                        if (String.valueOf(org.unitime.timetable.model.RoomSharingModel.sNotAvailablePref).equals(sharingModel.getPreference(d, t))) continue;
                        sharingModel.setPreference(d, t, String.valueOf(org.unitime.timetable.model.RoomSharingModel.sFreeForAllPref));
                    }
                }
            }
            if (sharingModel != null && sharingModel.allAvailable(null)) {
                sharingModel = null;
            }
            Long buildingId = null;
            if (location instanceof Room) {
                buildingId = ((Room)location).getBuilding().getUniqueId();
            }
            rc = discouraged ? new DiscouragedRoomConstraint(((TimetableModel)this.getModel()).getProperties(), location.getUniqueId(), location.getLabel(), buildingId, location.getCapacity().intValue(), (RoomSharingModel)sharingModel, location.getCoordinateX(), location.getCoordinateY(), location.isIgnoreTooFar() == null ? false : location.isIgnoreTooFar(), location.isIgnoreRoomCheck() == null ? true : location.isIgnoreRoomCheck() == false) : new RoomConstraint(location.getUniqueId(), location.getLabel(), buildingId, location.getCapacity().intValue(), (RoomSharingModel)sharingModel, location.getCoordinateX(), location.getCoordinateY(), location.isIgnoreTooFar() == null ? false : location.isIgnoreTooFar(), location.isIgnoreRoomCheck() == null ? true : location.isIgnoreRoomCheck() == false);
            rc.setType(location instanceof Room ? ((Room)location).getRoomType().getUniqueId() : null);
            ((TimetableModel)this.getModel()).addConstraint((Constraint)rc);
            this.iRooms.put(location.getUniqueId(), rc);
            this.iRoomsByPermId.put(location.getPermanentId(), rc);
            if (location instanceof Room && ((Room)location).getParentRoom() != null) {
                this.getRoomConstraint(dept, ((Room)location).getParentRoom(), hibSession).addPartition(rc);
            }
            if (location instanceof Room) {
                for (Room child : ((Room)location).getPartitions()) {
                    this.getRoomConstraint(dept, child, hibSession);
                }
            }
        }
        return rc;
    }

    private InstructorConstraint getInstructorConstraint(DepartmentalInstructor instructor, org.hibernate.Session hibSession) {
        Object ic;
        if (instructor.getExternalUniqueId() != null && instructor.getExternalUniqueId().length() > 0 && (ic = this.iInstructors.get(instructor.getExternalUniqueId())) != null) {
            return ic;
        }
        ic = this.iInstructors.get(instructor.getUniqueId());
        if (ic == null) {
            boolean ignDist = instructor.isIgnoreToFar() != null && instructor.isIgnoreToFar() != false;
            ic = this.iSoftInstructorConstraints ? new SoftInstructorConstraint(instructor.getUniqueId(), instructor.getExternalUniqueId(), instructor.getName(this.iInstructorFormat), ignDist) : new InstructorConstraint(instructor.getUniqueId(), instructor.getExternalUniqueId(), instructor.getName(this.iInstructorFormat), ignDist);
            ic.setType(instructor.getPositionType() == null ? Long.valueOf(Long.MAX_VALUE) : Long.valueOf(instructor.getPositionType().getSortOrder().intValue()));
            ((TimetableModel)this.getModel()).addConstraint((Constraint)ic);
            this.iInstructors.put(instructor.getUniqueId(), (InstructorConstraint)ic);
            if (instructor.getExternalUniqueId() != null && instructor.getExternalUniqueId().length() > 0) {
                this.iInstructors.put(instructor.getExternalUniqueId(), (InstructorConstraint)ic);
            }
        }
        return ic;
    }

    private void loadInstructorAvailabilities(org.hibernate.Session hibSession, Set<String> puids) {
        org.hibernate.query.Query q = hibSession.createQuery("select distinct i.externalUniqueId, a from ClassInstructor ci inner join ci.instructor i inner join ci.classInstructing.assignments a where ci.lead = true and i.externalUniqueId in :puids and a.solution.owner.session.uniqueId=:sessionId and a.solution.commited=true and a.solution.owner.uniqueId not in (" + this.iSolverGroupIds + ")", Object[].class);
        q.setParameter("sessionId", (Object)this.iSessionId);
        q.setParameterList("puids", puids, String.class);
        for (Object[] x : q.list()) {
            String puid = (String)x[0];
            org.unitime.timetable.model.Assignment a = (org.unitime.timetable.model.Assignment)x[1];
            InstructorConstraint ic = this.iInstructors.get(puid);
            Placement p = a.getPlacement();
            ic.setNotAvailable(p);
            if (this.iLectures.containsKey(a.getClassId())) continue;
            this.iLectures.put(a.getClassId(), (Lecture)p.variable());
            ((TimetableModel)this.getModel()).addVariable((Variable)((Lecture)p.variable()));
        }
    }

    private void loadInstructorAvailabilities(org.hibernate.Session hibSession) {
        this.setPhase(MSG.phaseLoadInstructorAvailabilities(), 1L);
        HashSet<String> puids = new HashSet<String>();
        Enumeration<InstructorConstraint> e = this.iInstructors.elements();
        while (e.hasMoreElements()) {
            InstructorConstraint ic = e.nextElement();
            if (ic.getPuid() == null) continue;
            puids.add(ic.getPuid());
            if (puids.size() != 100) continue;
            this.loadInstructorAvailabilities(hibSession, puids);
            puids.clear();
        }
        if (!puids.isEmpty()) {
            this.loadInstructorAvailabilities(hibSession, puids);
        }
        this.incProgress();
    }

    private void loadInstructorStudentConflicts(org.hibernate.Session hibSession, Set<String> puids) {
        for (Object[] x : hibSession.createQuery("select s.uniqueId, s.externalUniqueId from Student s where s.session.uniqueId = :sessionId and s.externalUniqueId in :puids", Object[].class).setParameter("sessionId", (Object)this.iSessionId).setParameterList("puids", puids, String.class).list()) {
            Long studentId = (Long)x[0];
            String puid = (String)x[1];
            InstructorConstraint ic = this.iInstructors.get(puid);
            org.cpsolver.coursett.model.Student s = this.iStudents.get(studentId);
            if (s == null || ic == null) continue;
            this.iProgress.debug(MSG.debugStudentInstructorPair(puid, s.getId()));
            s.setInstructor(ic);
            for (Lecture lecture : ic.variables()) {
                s.addLecture(lecture);
                lecture.addStudent(this.getAssignment(), s);
            }
        }
    }

    private void loadInstructorStudentConflicts(org.hibernate.Session hibSession) {
        this.setPhase(MSG.phaseLoadInstructorStudentConflicts(), 1L);
        HashSet<String> puids = new HashSet<String>();
        for (InstructorConstraint ic : this.iInstructors.values()) {
            if (ic.getPuid() == null) continue;
            puids.add(ic.getPuid());
            if (puids.size() != 100) continue;
            this.loadInstructorStudentConflicts(hibSession, puids);
            puids.clear();
        }
        if (!puids.isEmpty()) {
            this.loadInstructorStudentConflicts(hibSession, puids);
        }
        this.incProgress();
    }

    private void loadRoomAvailabilities(org.hibernate.Session hibSession, String roomids) {
        org.hibernate.query.Query q = hibSession.createQuery("select distinct r.uniqueId, a from Location r inner join r.assignments as a where r.uniqueId in (" + roomids + ") and a.solution.owner.session.uniqueId=:sessionId and a.solution.commited=true and a.solution.owner.uniqueId not in (" + this.iSolverGroupIds + ") and r.ignoreRoomCheck = false", Object[].class);
        q.setParameter("sessionId", (Object)this.iSessionId);
        for (Object[] x : q.list()) {
            Long roomId = (Long)x[0];
            org.unitime.timetable.model.Assignment a = (org.unitime.timetable.model.Assignment)x[1];
            Placement p = a.getPlacement();
            RoomConstraint rc = this.iRooms.get(roomId);
            rc.setNotAvailable(p);
            if (this.iLectures.containsKey(a.getClassId())) continue;
            this.iLectures.put(a.getClassId(), (Lecture)p.variable());
            ((TimetableModel)this.getModel()).addVariable((Variable)((Lecture)p.variable()));
        }
    }

    private void loadRoomAvailabilities(org.hibernate.Session hibSession) {
        this.setPhase(MSG.phaseLoadRoomAvailabilities(), 1L);
        StringBuffer roomids = new StringBuffer();
        int idx = 0;
        Enumeration<RoomConstraint> e = this.iRooms.elements();
        while (e.hasMoreElements()) {
            RoomConstraint rc = e.nextElement();
            if (roomids.length() > 0) {
                roomids.append(",");
            }
            roomids.append(rc.getResourceId());
            if (++idx != 100) continue;
            this.loadRoomAvailabilities(hibSession, roomids.toString());
            roomids = new StringBuffer();
            idx = 0;
        }
        if (roomids.length() > 0) {
            this.loadRoomAvailabilities(hibSession, roomids.toString());
        }
        this.incProgress();
    }

    private Constraint createGroupConstraint(DistributionPref pref) {
        return this.createGroupConstraint(pref.getUniqueId(), pref.getDistributionType(), pref.getPrefLevel(), pref.getOwner());
    }

    private Constraint createGroupConstraint(Long id, DistributionType type, PreferenceLevel pref, Object owner) {
        PreferenceLevel sd;
        PreferenceLevel sp;
        if (this.iWeakenDistributions && PreferenceLevel.sRequired.equals(pref.getPrefProlog()) && (sp = PreferenceLevel.getPreferenceLevel(PreferenceLevel.sStronglyPreferred)) != null && type.isAllowed(sp)) {
            pref = sp;
        }
        if (this.iWeakenDistributions && PreferenceLevel.sProhibited.equals(pref.getPrefProlog()) && (sd = PreferenceLevel.getPreferenceLevel(PreferenceLevel.sStronglyDiscouraged)) != null && type.isAllowed(sd)) {
            pref = sd;
        }
        SpreadConstraint gc = null;
        if (type.getReference().matches("_(.+)_")) {
            for (FlexibleConstraint.FlexibleConstraintType fcType : FlexibleConstraint.FlexibleConstraintType.values()) {
                if (!type.getReference().matches(fcType.getPattern())) continue;
                try {
                    gc = fcType.create(id, owner.toString(), pref.getPrefProlog(), type.getReference());
                }
                catch (IllegalArgumentException e) {
                    this.iProgress.warn(MSG.warnFlexibleConstraintNotLoaded(type.getReference()), (Throwable)e);
                }
            }
            if (gc == null) {
                this.iProgress.warn(MSG.warnDistributionConstraintNotKnown(type.getReference()));
                return null;
            }
        } else if ("SAME_INSTR".equals(type.getReference())) {
            if (PreferenceLevel.sRequired.equals(pref.getPrefProlog())) {
                gc = new InstructorConstraint(Long.valueOf(-id.longValue()), null, type.getLabel(), false);
            }
        } else if ("SPREAD".equals(type.getReference())) {
            gc = new SpreadConstraint(((TimetableModel)this.getModel()).getProperties(), MSG.nameSpreadConstraint());
        } else if ("MIN_ROOM_USE".equals(type.getReference())) {
            if (!this.iInteractiveMode) {
                gc = new MinimizeNumberOfUsedRoomsConstraint(((TimetableModel)this.getModel()).getProperties());
            } else {
                this.iProgress.message(this.msglevel("constraintNotUsed", 3), MSG.warnMinRoomUseInteractive());
            }
        } else if ("MIN_GRUSE(10x1h)".equals(type.getReference())) {
            if (!this.iInteractiveMode) {
                gc = new MinimizeNumberOfUsedGroupsOfTime(((TimetableModel)this.getModel()).getProperties(), "10x1h", MinimizeNumberOfUsedGroupsOfTime.sGroups10of1h);
            } else {
                this.iProgress.message(this.msglevel("constraintNotUsed", 3), MSG.warnMinGroupUseInteractive());
            }
        } else if ("MIN_GRUSE(5x2h)".equals(type.getReference())) {
            if (!this.iInteractiveMode) {
                gc = new MinimizeNumberOfUsedGroupsOfTime(((TimetableModel)this.getModel()).getProperties(), "5x2h", MinimizeNumberOfUsedGroupsOfTime.sGroups5of2h);
            } else {
                this.iProgress.message(this.msglevel("constraintNotUsed", 3), MSG.warnMinGroupUseInteractive());
            }
        } else if ("MIN_GRUSE(3x3h)".equals(type.getReference())) {
            if (!this.iInteractiveMode) {
                gc = new MinimizeNumberOfUsedGroupsOfTime(((TimetableModel)this.getModel()).getProperties(), "3x3h", MinimizeNumberOfUsedGroupsOfTime.sGroups3of3h);
            } else {
                this.iProgress.message(this.msglevel("constraintNotUsed", 3), MSG.warnMinGroupUseInteractive());
            }
        } else if ("MIN_GRUSE(2x5h)".equals(type.getReference())) {
            if (!this.iInteractiveMode) {
                gc = new MinimizeNumberOfUsedGroupsOfTime(((TimetableModel)this.getModel()).getProperties(), "2x5h", MinimizeNumberOfUsedGroupsOfTime.sGroups2of5h);
            } else {
                this.iProgress.message(this.msglevel("constraintNotUsed", 3), MSG.warnMinGroupUseInteractive());
            }
        } else if ("NO_CONFLICT".equals(type.getReference())) {
            if (PreferenceLevel.sRequired.equals(pref.getPrefProlog())) {
                gc = new IgnoreStudentConflictsConstraint();
            }
        } else {
            GroupConstraint.ConstraintTypeInterface gcType = GroupConstraint.getConstraintType((String)type.getReference());
            if (gcType == null) {
                this.iProgress.error(MSG.warnDistributionConstraintNotImplemented(type.getReference()));
                return null;
            }
            gc = new GroupConstraint(id, gcType, pref.getPrefProlog());
        }
        return gc;
    }

    private void errorAddGroupConstraintNotFound(DistributionPref pref, Class_ clazz) {
        if (pref.getOwner() != null && pref.getOwner() instanceof DepartmentalInstructor) {
            this.iProgress.message(this.msglevel("notLoadedInInstrPref", 3), MSG.warnClassNotLoadedButUsedInDistPref(this.getClassLabel(clazz), pref.getLabel()));
        } else {
            this.iProgress.message(this.msglevel("notLoadedInDistPref", 5), MSG.warnClassNotLoadedButUsedInDistPref(this.getClassLabel(clazz), pref.getLabel()));
        }
    }

    private Lecture getLecture(Class_ clazz) {
        Lecture lecture;
        block5: {
            lecture = this.iLectures.get(clazz.getUniqueId());
            if (lecture != null) {
                return lecture;
            }
            if (this.iAllClasses.contains(clazz)) {
                return null;
            }
            try {
                org.unitime.timetable.model.Assignment assignment = clazz.getCommittedAssignment();
                if (assignment != null) {
                    Placement placement = assignment.getPlacement();
                    lecture = (Lecture)placement.variable();
                    ((TimetableModel)this.getModel()).addVariable((Variable)lecture);
                    this.iLectures.put(clazz.getUniqueId(), lecture);
                }
            }
            catch (LazyInitializationException e) {
                org.unitime.timetable.model.Assignment assignment = (org.unitime.timetable.model.Assignment)AssignmentDAO.getInstance().get(clazz.getCommittedAssignment().getUniqueId());
                if (assignment == null) break block5;
                Placement placement = assignment.getPlacement();
                lecture = (Lecture)placement.variable();
                ((TimetableModel)this.getModel()).addVariable((Variable)lecture);
                this.iLectures.put(clazz.getUniqueId(), lecture);
            }
        }
        return lecture;
    }

    private void addGroupConstraint(Constraint<Lecture, Placement> gc) {
        if (gc.variables().isEmpty()) {
            return;
        }
        boolean allVariablesAreCommitted = true;
        for (Lecture lecture : gc.variables()) {
            if (lecture.isCommitted()) continue;
            allVariablesAreCommitted = false;
            break;
        }
        if (allVariablesAreCommitted) {
            Object vars = "";
            for (Lecture l : gc.variables()) {
                vars = (String)vars + (((String)vars).isEmpty() ? "" : ", ") + this.getClassLabel(l);
            }
            this.iProgress.debug(MSG.debugDistributionAllCommitted(gc.getName(), (String)vars));
            for (Lecture lecture : new ArrayList(gc.variables())) {
                gc.removeVariable((Variable)lecture);
            }
            return;
        }
        ((TimetableModel)this.getModel()).addConstraint(gc);
        this.iProgress.trace("Added constraint " + gc.getName() + " between " + String.valueOf(gc.variables()));
    }

    /*
     * WARNING - void declaration
     */
    private void loadGroupConstraint(DistributionPref pref) {
        DistributionPref.Structure structure = pref.getStructure();
        if (structure == null) {
            structure = DistributionPref.Structure.AllClasses;
        }
        if (structure == DistributionPref.Structure.Progressive) {
            void var8_31;
            int maxSize = 0;
            for (DistributionObject distributionObject : pref.getOrderedSetOfDistributionObjects()) {
                if (distributionObject.getPrefGroup() instanceof Class_) {
                    maxSize = Math.max(maxSize, 1);
                    continue;
                }
                if (!(distributionObject.getPrefGroup() instanceof SchedulingSubpart)) continue;
                maxSize = Math.max(maxSize, ((SchedulingSubpart)distributionObject.getPrefGroup()).getClasses().size());
            }
            Constraint[] gc = new Constraint[maxSize];
            Set[] gcClasses = new Set[maxSize];
            for (int i = 0; i < gc.length; ++i) {
                gc[i] = this.createGroupConstraint(pref);
                if (gc[i] == null) {
                    return;
                }
                gcClasses[i] = new HashSet();
            }
            ArrayList<Lecture> allLectureOfCorrectOrder = new ArrayList<Lecture>();
            for (DistributionObject distributionObject : pref.getOrderedSetOfDistributionObjects()) {
                if (distributionObject.getPrefGroup() instanceof Class_) {
                    Class_ clazz = (Class_)distributionObject.getPrefGroup();
                    Lecture lecture = this.getLecture(clazz);
                    if (lecture == null) continue;
                    allLectureOfCorrectOrder.add(lecture);
                    continue;
                }
                if (!(distributionObject.getPrefGroup() instanceof SchedulingSubpart)) continue;
                SchedulingSubpart subpart = (SchedulingSubpart)distributionObject.getPrefGroup();
                ArrayList<Class_> classes = new ArrayList<Class_>(subpart.getClasses());
                Collections.sort(classes, new ClassComparator(5));
                for (Class_ clazz : classes) {
                    Lecture lecture = this.getLecture(clazz);
                    if (lecture == null) continue;
                    allLectureOfCorrectOrder.add(lecture);
                }
            }
            ArrayList<DistributionObject> distributionObjects = new ArrayList<DistributionObject>(pref.getDistributionObjects());
            Collections.sort(distributionObjects, new ChildrenFirstDistributionObjectComparator());
            for (DistributionObject distributionObject : distributionObjects) {
                int j;
                if (distributionObject.getPrefGroup() instanceof Class_) {
                    Class_ clazz = (Class_)distributionObject.getPrefGroup();
                    Lecture lecture = this.getLecture(clazz);
                    if (lecture == null) {
                        this.errorAddGroupConstraintNotFound(pref, clazz);
                        continue;
                    }
                    for (j = 0; j < gc.length; ++j) {
                        gc[j].addVariable((Variable)lecture);
                        gcClasses[j].add(clazz);
                    }
                    continue;
                }
                if (distributionObject.getPrefGroup() instanceof SchedulingSubpart) {
                    SchedulingSubpart subpart = (SchedulingSubpart)distributionObject.getPrefGroup();
                    ArrayList<Class_> classes = new ArrayList<Class_>(subpart.getClasses());
                    Collections.sort(classes, new ClassComparator(5));
                    if (classes.isEmpty()) {
                        this.iProgress.message(this.msglevel("badDistributionObj", 5), MSG.warnBadDistributionObject(pref.getLabel(), this.getSubpartLabel(subpart)));
                        continue;
                    }
                    for (j = 0; j < gc.length; ++j) {
                        Lecture lecture;
                        Class_ clazz = null;
                        Iterator k = gcClasses[j].iterator();
                        while (k.hasNext() && clazz == null) {
                            clazz = TimetableDatabaseLoader.getParentClass((Class_)k.next(), subpart);
                        }
                        if (clazz == null) {
                            ArrayList<Class_> adepts = new ArrayList<Class_>();
                            block14: for (Class_ adept : classes) {
                                for (Class_ other : gcClasses[j]) {
                                    if (!TimetableDatabaseLoader.shareParent(other.getSchedulingSubpart(), adept.getSchedulingSubpart()) || TimetableDatabaseLoader.shareParent(other, adept)) continue;
                                    continue block14;
                                }
                                adepts.add(adept);
                            }
                            if (!adepts.isEmpty() && adepts.size() < classes.size()) {
                                int k2 = 0;
                                block16: for (int i = 0; i < j; ++i) {
                                    block17: for (Class_ adept : adepts) {
                                        for (Class_ other : gcClasses[i]) {
                                            if (!TimetableDatabaseLoader.shareParent(other.getSchedulingSubpart(), adept.getSchedulingSubpart()) || TimetableDatabaseLoader.shareParent(other, adept)) continue;
                                            continue block17;
                                        }
                                        ++k2;
                                        continue block16;
                                    }
                                }
                                clazz = (Class_)adepts.get(k2 % adepts.size());
                            }
                        }
                        if (clazz == null) {
                            clazz = (Class_)classes.get(j % classes.size());
                        }
                        if ((lecture = this.getLecture(clazz)) == null) {
                            this.errorAddGroupConstraintNotFound(pref, clazz);
                            continue;
                        }
                        gc[j].addVariable((Variable)lecture);
                        gcClasses[j].add(clazz);
                    }
                    continue;
                }
                this.iProgress.message(this.msglevel("badDistributionObj", 5), MSG.warnBadDistributionObjectNotSupported(pref.getLabel(), distributionObject.getPrefGroup().toString()));
            }
            boolean bl = false;
            while (var8_31 < gc.length) {
                ObjectsByGivenOrderComparator cmp = new ObjectsByGivenOrderComparator(allLectureOfCorrectOrder);
                if (!gc[var8_31].variables().isEmpty()) {
                    Collections.sort(gc[var8_31].variables(), cmp);
                    this.addGroupConstraint((Constraint<Lecture, Placement>)gc[var8_31]);
                }
                ++var8_31;
            }
        } else if (structure == DistributionPref.Structure.Pairwise) {
            ArrayList<Lecture> lectures = new ArrayList<Lecture>();
            for (DistributionObject distributionObject : pref.getOrderedSetOfDistributionObjects()) {
                if (distributionObject.getPrefGroup() instanceof Class_) {
                    Class_ clazz = (Class_)distributionObject.getPrefGroup();
                    Lecture lecture = this.getLecture(clazz);
                    if (lecture == null) {
                        this.errorAddGroupConstraintNotFound(pref, clazz);
                        continue;
                    }
                    lectures.add(lecture);
                    continue;
                }
                if (distributionObject.getPrefGroup() instanceof SchedulingSubpart) {
                    SchedulingSubpart subpart = (SchedulingSubpart)distributionObject.getPrefGroup();
                    ArrayList<Class_> classes = new ArrayList<Class_>(subpart.getClasses());
                    Collections.sort(classes, new ClassComparator(5));
                    for (Class_ clazz : classes) {
                        Lecture lecture = this.getLecture(clazz);
                        if (lecture == null) {
                            this.errorAddGroupConstraintNotFound(pref, clazz);
                            continue;
                        }
                        lectures.add(lecture);
                    }
                    continue;
                }
                this.iProgress.message(this.msglevel("badDistributionObj", 5), MSG.warnBadDistributionObjectNotSupported(pref.getLabel(), distributionObject.getPrefGroup().toString()));
            }
            if (lectures.size() < 2) {
                this.iProgress.message(this.msglevel("distrPrefIncomplete", 5), MSG.warnBadDistributionIncomplete(pref.getLabel()));
            } else {
                void var8_34;
                long n = lectures.size();
                long estimate = n * (n - 1L) / 2L;
                if (estimate > 10000L) {
                    this.iProgress.message(this.msglevel("distrPrefTooManyError", 6), MSG.errorDistributionTooMany(pref.preferenceText(true, false, "<br>", "<br>", "")));
                    return;
                }
                if (estimate > 1000L) {
                    this.iProgress.message(this.msglevel("distrPrefTooManyWarn", 5), MSG.warnDistributionTooMany(pref.preferenceText(true, false, "<br>", "<br>", "")));
                }
                boolean bl = false;
                while (var8_34 < lectures.size() - 1) {
                    Lecture l1 = (Lecture)lectures.get((int)var8_34);
                    for (void idx2 = var8_34 + true; idx2 < lectures.size(); ++idx2) {
                        Lecture l2 = (Lecture)lectures.get((int)idx2);
                        Constraint gc = this.createGroupConstraint(pref);
                        if (gc == null) {
                            return;
                        }
                        gc.addVariable((Variable)l1);
                        gc.addVariable((Variable)l2);
                        this.addGroupConstraint((Constraint<Lecture, Placement>)gc);
                    }
                    ++var8_34;
                }
            }
        } else if (structure == DistributionPref.Structure.OneOfEach) {
            ArrayList<Lecture> lectures = new ArrayList<Lecture>();
            ArrayList<Integer> counts = new ArrayList<Integer>();
            for (DistributionObject distributionObject : pref.getOrderedSetOfDistributionObjects()) {
                int count = 0;
                if (distributionObject.getPrefGroup() instanceof Class_) {
                    Class_ class_ = (Class_)distributionObject.getPrefGroup();
                    Lecture lecture = this.getLecture(class_);
                    if (lecture == null) {
                        this.errorAddGroupConstraintNotFound(pref, class_);
                        continue;
                    }
                    lectures.add(lecture);
                    ++count;
                } else if (distributionObject.getPrefGroup() instanceof SchedulingSubpart) {
                    SchedulingSubpart schedulingSubpart = (SchedulingSubpart)distributionObject.getPrefGroup();
                    ArrayList<Class_> classes = new ArrayList<Class_>(schedulingSubpart.getClasses());
                    Collections.sort(classes, new ClassComparator(5));
                    for (Class_ clazz : classes) {
                        Lecture lecture = this.getLecture(clazz);
                        if (lecture == null) {
                            this.errorAddGroupConstraintNotFound(pref, clazz);
                            continue;
                        }
                        lectures.add(lecture);
                        ++count;
                    }
                } else {
                    this.iProgress.message(this.msglevel("badDistributionObj", 5), MSG.warnBadDistributionObjectNotSupported(pref.getLabel(), distributionObject.getPrefGroup().toString()));
                }
                if (count <= 0) continue;
                counts.add(count);
            }
            if (counts.size() > 1) {
                double estimate = 1.0;
                for (Integer n : counts) {
                    estimate *= (double)n.intValue();
                }
                if (estimate > 10000.0) {
                    this.iProgress.message(this.msglevel("distrPrefTooManyError", 6), MSG.errorDistributionTooMany(pref.preferenceText(true, false, "<br>", "<br>", "")));
                    return;
                }
                if (estimate > 1000.0) {
                    this.iProgress.message(this.msglevel("distrPrefTooManyWarn", 5), MSG.warnDistributionTooMany(pref.preferenceText(true, false, "<br>", "<br>", "")));
                }
                Enumeration e = DistributionPref.permutations(lectures, counts);
                while (e.hasMoreElements()) {
                    Collection collection = e.nextElement();
                    Constraint gc = this.createGroupConstraint(pref);
                    if (gc == null) {
                        return;
                    }
                    for (Lecture lecture : collection) {
                        gc.addVariable((Variable)lecture);
                    }
                    this.addGroupConstraint((Constraint<Lecture, Placement>)gc);
                    this.iProgress.debug("Posted " + gc.getName() + " between " + String.valueOf(gc.variables()));
                }
            }
        } else {
            Integer grouping = null;
            switch (structure) {
                case GroupsOfTwo: {
                    grouping = 2;
                    break;
                }
                case GroupsOfThree: {
                    grouping = 3;
                    break;
                }
                case GroupsOfFour: {
                    grouping = 4;
                    break;
                }
                case GroupsOfFive: {
                    grouping = 5;
                }
            }
            Constraint gc = this.createGroupConstraint(pref);
            if (gc == null) {
                return;
            }
            for (DistributionObject distributionObject : pref.getOrderedSetOfDistributionObjects()) {
                if (distributionObject.getPrefGroup() instanceof Class_) {
                    Class_ clazz = (Class_)distributionObject.getPrefGroup();
                    Lecture lecture = this.getLecture(clazz);
                    if (lecture == null) {
                        this.errorAddGroupConstraintNotFound(pref, clazz);
                        continue;
                    }
                    gc.addVariable((Variable)lecture);
                    if (grouping == null || gc.variables().size() != grouping.intValue()) continue;
                    this.addGroupConstraint((Constraint<Lecture, Placement>)gc);
                    gc = this.createGroupConstraint(pref);
                    if (gc != null) continue;
                    return;
                }
                if (distributionObject.getPrefGroup() instanceof SchedulingSubpart) {
                    SchedulingSubpart subpart = (SchedulingSubpart)distributionObject.getPrefGroup();
                    ArrayList<Class_> arrayList = new ArrayList<Class_>(subpart.getClasses());
                    Collections.sort(arrayList, new ClassComparator(5));
                    for (Class_ clazz : arrayList) {
                        Lecture lecture = this.getLecture(clazz);
                        if (lecture == null) {
                            this.errorAddGroupConstraintNotFound(pref, clazz);
                            continue;
                        }
                        gc.addVariable((Variable)lecture);
                        if (grouping == null || gc.variables().size() != grouping.intValue()) continue;
                        this.addGroupConstraint((Constraint<Lecture, Placement>)gc);
                        gc = this.createGroupConstraint(pref);
                        if (gc != null) continue;
                        return;
                    }
                    continue;
                }
                this.iProgress.message(this.msglevel("badDistributionObj", 5), MSG.warnBadDistributionObjectNotSupported(pref.getLabel(), distributionObject.getPrefGroup().toString()));
            }
            this.addGroupConstraint((Constraint<Lecture, Placement>)gc);
        }
    }

    private void loadInstructorGroupConstraint(DepartmentalInstructor instructor, DistributionPref pref) {
        boolean loadConstraint = false;
        for (ClassInstructor classInstructor : instructor.getClasses()) {
            Iterator clazz = classInstructor.getClassInstructing();
            if (!classInstructor.isLead().booleanValue() || !((Class_)((Object)clazz)).getManagingDept().isInheritInstructorPreferences().booleanValue()) continue;
            loadConstraint = true;
            break;
        }
        if (!loadConstraint) {
            return;
        }
        InstructorConstraint ic = null;
        ic = instructor.getExternalUniqueId() != null && instructor.getExternalUniqueId().length() > 0 ? this.iInstructors.get(instructor.getExternalUniqueId()) : this.iInstructors.get(instructor.getUniqueId());
        ArrayList<Lecture> variables = new ArrayList<Lecture>();
        if (ic != null && this.iInstructorDistributionsAcrossDepartments) {
            for (Lecture lecutre : ic.variables()) {
                variables.add(lecutre);
            }
            if (ic.getUnavailabilities() != null) {
                for (Placement p : ic.getUnavailabilities()) {
                    if (((Lecture)p.variable()).getId() <= 0L) continue;
                    variables.add((Lecture)p.variable());
                }
            }
        } else {
            for (ClassInstructor classInstructor : instructor.getClasses()) {
                if (!classInstructor.isLead().booleanValue()) continue;
                Class_ clazz = classInstructor.getClassInstructing();
                Lecture lecture = this.getLecture(clazz);
                if (lecture == null) {
                    this.errorAddGroupConstraintNotFound(pref, clazz);
                    continue;
                }
                variables.add(lecture);
            }
        }
        if (variables.size() > 1) {
            Constraint gc = this.createGroupConstraint(pref);
            if (gc == null) {
                return;
            }
            for (Lecture var : variables) {
                gc.addVariable((Variable)var);
            }
            this.addGroupConstraint((Constraint<Lecture, Placement>)gc);
        }
        if (ic != null) {
            List<DistributionType> distributions = this.iInstructorDistributions.get(ic);
            if (distributions == null) {
                distributions = new ArrayList<DistributionType>();
                this.iInstructorDistributions.put(ic, distributions);
            }
            distributions.add(pref.getDistributionType());
        }
    }

    private void loadInstructorGroupConstraints(DepartmentalInstructor instructor, Set<Long> checkedDistPrefIds) {
        Set<DistributionPref> prefs = instructor.getPreferences(DistributionPref.class);
        if (prefs == null || prefs.isEmpty()) {
            return;
        }
        for (DistributionPref pref : prefs) {
            if (!checkedDistPrefIds.add(pref.getUniqueId())) continue;
            this.loadInstructorGroupConstraint(instructor, pref);
        }
    }

    private void loadInstructorGroupConstraints(Department department, Set<Long> checkedDistPrefIds, org.hibernate.Session hibSession) {
        if (!department.isInheritInstructorPreferences().booleanValue()) {
            return;
        }
        List instructors = null;
        instructors = department.isExternalManager() != false ? hibSession.createQuery("select distinct i.instructor from Class_ as c inner join c.classInstructors i where i.lead = true and (c.managingDept.uniqueId=:deptId or (c.managingDept is null and c.controllingDept.uniqueId=:deptId))", DepartmentalInstructor.class).setParameter("deptId", (Object)department.getUniqueId()).list() : hibSession.createQuery("select distinct di from DepartmentalInstructor di inner join di.department d where d.uniqueId=:deptId", DepartmentalInstructor.class).setParameter("deptId", (Object)department.getUniqueId()).list();
        if (instructors == null || instructors.isEmpty()) {
            return;
        }
        this.setPhase(MSG.phaseLoadInstructorGroupConstraints(department.getShortLabel()), instructors.size());
        for (DepartmentalInstructor instructor : instructors) {
            this.loadInstructorGroupConstraints(instructor, checkedDistPrefIds);
            if (instructor.hasUnavailabilities()) {
                InstructorConstraint ic = null;
                ic = instructor.getExternalUniqueId() != null && instructor.getExternalUniqueId().length() > 0 ? this.iInstructors.get(instructor.getExternalUniqueId()) : this.iInstructors.get(instructor.getUniqueId());
                if (ic != null) {
                    boolean skipDuplicateLoad = false;
                    if (department.isExternalManager().booleanValue()) {
                        for (SolverGroup g : this.iSolverGroup) {
                            if (!g.getDepartments().contains(instructor.getDepartment())) continue;
                            skipDuplicateLoad = true;
                            break;
                        }
                    }
                    if (!skipDuplicateLoad) {
                        for (RoomAvailabilityInterface.TimeBlock time : instructor.listUnavailableDays()) {
                            this.iProgress.debug(ic.getName() + " not available due to " + String.valueOf(time) + " (" + instructor.getDepartment().getDeptCode() + ")");
                            Placement p = this.timeBlock2Placement(time);
                            if (p == null) continue;
                            ic.setNotAvailable(p);
                            ((TimetableModel)this.getModel()).addVariable((Variable)((Lecture)p.variable()));
                            ((Lecture)p.variable()).setDepartment(instructor.getDepartment().getUniqueId());
                        }
                    }
                }
            }
            this.incProgress();
        }
    }

    private static Class_ getParentClass(Class_ clazz, SchedulingSubpart parentSubpart) {
        if (clazz == null) {
            return null;
        }
        if (parentSubpart.getClasses().contains(clazz)) {
            return clazz;
        }
        return TimetableDatabaseLoader.getParentClass(clazz.getParentClass(), parentSubpart);
    }

    private static boolean shareParent(Class_ c1, Class_ c2) {
        if (c1.getParentClass() == null) {
            return false;
        }
        for (Class_ p = c2.getParentClass(); p != null; p = p.getParentClass()) {
            if (!c1.getParentClass().equals(p)) continue;
            return true;
        }
        return TimetableDatabaseLoader.shareParent(c1.getParentClass(), c2);
    }

    private static boolean shareParent(SchedulingSubpart s1, SchedulingSubpart s2) {
        if (s1.getParentSubpart() == null) {
            return false;
        }
        for (SchedulingSubpart p = s2.getParentSubpart(); p != null; p = p.getParentSubpart()) {
            if (!s1.getParentSubpart().equals(p)) continue;
            return true;
        }
        return TimetableDatabaseLoader.shareParent(s1.getParentSubpart(), s2);
    }

    private String getClassLimitConstraitName(SchedulingSubpart subpart) {
        if (subpart == null) {
            return MSG.nameClassLimitConstraint();
        }
        String name = subpart.getCourseName() + " " + subpart.getItypeDesc().trim();
        String sufix = subpart.getSchedulingSubpartSuffix();
        if (sufix != null && sufix.length() > 0) {
            name = name + " (" + sufix + ")";
        }
        return name;
    }

    private String getClassLimitConstraitName(Lecture lecture) {
        SchedulingSubpart subpart = this.iSubparts.get(lecture.getSchedulingSubpartId());
        if (subpart == null) {
            subpart = (SchedulingSubpart)SchedulingSubpartDAO.getInstance().get(lecture.getSchedulingSubpartId());
        }
        return this.getClassLimitConstraitName(subpart);
    }

    private void createChildrenClassLimitConstraits(Lecture parentLecture) {
        if (!parentLecture.hasAnyChildren()) {
            return;
        }
        for (Long subpartId : parentLecture.getChildrenSubpartIds()) {
            List children = parentLecture.getChildren(subpartId);
            ClassLimitConstraint clc = new ClassLimitConstraint(parentLecture, this.getClassLimitConstraitName(parentLecture));
            boolean isMakingSense = false;
            for (Lecture lecture : children) {
                this.createChildrenClassLimitConstraits(lecture);
                if (lecture.isCommitted() || lecture.minClassLimit() == lecture.maxClassLimit()) continue;
                isMakingSense = true;
            }
            if (!isMakingSense) continue;
            for (Lecture lecture : children) {
                if (!lecture.isCommitted()) {
                    clc.addVariable((Variable)lecture);
                    continue;
                }
                clc.setClassLimitDelta(clc.getClassLimitDelta() - this.iClasses.get(lecture.getClassId()).getClassLimit());
            }
            if (clc.variables().isEmpty()) continue;
            SchedulingSubpart subpart = this.iSubparts.get(subpartId);
            if (subpart == null) {
                subpart = (SchedulingSubpart)SchedulingSubpartDAO.getInstance().get(subpartId);
            }
            for (Class_ clazz : subpart.getClasses()) {
                if (this.iLectures.get(clazz.getUniqueId()) != null) continue;
                clc.setClassLimitDelta(clc.getClassLimitDelta() - clazz.getClassLimit());
            }
            this.iProgress.trace("Added constraint " + clc.getName() + " between " + String.valueOf(clc.variables()));
            ((TimetableModel)this.getModel()).addConstraint((Constraint)clc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        ApplicationProperties.setSessionId(this.iSessionId);
        org.hibernate.Session hibSession = null;
        Transaction tx = null;
        try {
            hibSession = TimetableManagerDAO.getInstance().getSession();
            hibSession.setCacheMode(CacheMode.IGNORE);
            hibSession.setHibernateFlushMode(FlushMode.COMMIT);
            tx = hibSession.beginTransaction();
            this.load(hibSession);
            tx.commit();
        }
        catch (Exception e) {
            this.iProgress.message(this.msglevel("loadFailed", 7), MSG.fatalLoadFailed(e.getMessage()), (Throwable)e);
            tx.rollback();
        }
        finally {
            if (hibSession != null && hibSession.isOpen()) {
                hibSession.close();
            }
        }
    }

    private boolean postSameStudentConstraint(Class_ clazz, String type) {
        boolean posted = false;
        if (!clazz.getChildClasses().isEmpty()) {
            for (Class_ c : clazz.getChildClasses()) {
                if (!this.postSameStudentConstraint(c, type)) continue;
                posted = true;
            }
        }
        if (posted) {
            return true;
        }
        Lecture lecture = this.getLecture(clazz);
        if (lecture == null) {
            return false;
        }
        ArrayList<Lecture> variables = new ArrayList<Lecture>();
        variables.add(lecture);
        Class_ parent = clazz;
        while ((parent = parent.getParentClass()) != null) {
            Lecture parentLecture = this.getLecture(parent);
            if (parentLecture == null) continue;
            variables.add(parentLecture);
        }
        for (SchedulingSubpart subpart : clazz.getSchedulingSubpart().getInstrOfferingConfig().getSchedulingSubparts()) {
            Class_ singleClazz;
            Lecture singleLecture;
            if (subpart.getClasses().size() != 1 || (singleLecture = this.getLecture(singleClazz = subpart.getClasses().iterator().next())) == null || variables.contains(singleLecture)) continue;
            variables.add(singleLecture);
        }
        if (variables.size() == 1) {
            return false;
        }
        GroupConstraint gc = new GroupConstraint(null, GroupConstraint.getConstraintType((String)type), PreferenceLevel.sRequired);
        for (Lecture var : variables) {
            gc.addVariable(var);
        }
        this.addGroupConstraint((Constraint<Lecture, Placement>)gc);
        return true;
    }

    private boolean postPrecedenceConstraint(Class_ clazz, String preference) {
        boolean posted = false;
        if (!clazz.getChildClasses().isEmpty()) {
            for (Class_ c : clazz.getChildClasses()) {
                if (!this.postPrecedenceConstraint(c, preference)) continue;
                posted = true;
            }
        }
        if (posted) {
            return true;
        }
        Lecture lecture = this.getLecture(clazz);
        if (lecture == null) {
            return false;
        }
        ArrayList<Lecture> variables = new ArrayList<Lecture>();
        variables.add(lecture);
        HashSet<Integer> itypes = new HashSet<Integer>();
        itypes.add(clazz.getSchedulingSubpart().getItype().getItype());
        Class_ parent = clazz;
        while ((parent = parent.getParentClass()) != null) {
            Lecture parentLecture = this.getLecture(parent);
            if (parentLecture == null) continue;
            variables.add(0, parentLecture);
            itypes.add(parent.getSchedulingSubpart().getItype().getItype());
        }
        if (variables.size() <= 1 || itypes.size() <= 1) {
            return false;
        }
        GroupConstraint gc = new GroupConstraint(null, (GroupConstraint.ConstraintTypeInterface)GroupConstraint.ConstraintType.PRECEDENCE, preference);
        Object info = "";
        for (Lecture var : variables) {
            gc.addVariable(var);
            if (!((String)info).isEmpty()) {
                info = (String)info + ", ";
            }
            info = (String)info + this.getClassLabel(var);
        }
        this.iProgress.info(MSG.infoAutomaticPrecedence((String)info, PreferenceLevel.prolog2string(preference)));
        this.addGroupConstraint((Constraint<Lecture, Placement>)gc);
        return true;
    }

    private void propagateCommittedAssignment(HashSet students, org.unitime.timetable.model.Assignment assignment) {
        Class_ clazz = assignment.getClazz();
        Lecture parentLecture = null;
        Class_ c = clazz;
        while ((parentLecture == null || parentLecture.isCommitted()) && c.getParentClass() != null) {
            c = c.getParentClass();
            parentLecture = this.iLectures.get(c.getUniqueId());
        }
        if (parentLecture != null && !parentLecture.isCommitted()) {
            for (Lecture lecture : parentLecture.sameSubpartLectures()) {
                if (lecture.equals((Object)parentLecture) || lecture.isCommitted()) continue;
                for (org.cpsolver.coursett.model.Student student : students) {
                    student.addCanNotEnroll(lecture);
                }
            }
        }
        if (!clazz.getSchedulingSubpart().getChildSubparts().isEmpty()) {
            for (SchedulingSubpart subpart : clazz.getSchedulingSubpart().getChildSubparts()) {
                for (Class_ child : subpart.getClasses()) {
                    if (clazz.equals(child.getParentClass())) continue;
                    this.propagateCommittedAssignment(students, clazz, child);
                }
            }
        }
    }

    private void propagateCommittedAssignment(HashSet students, Class_ parent, Class_ clazz) {
        Lecture lecture = this.iLectures.get(clazz.getUniqueId());
        if (lecture != null && !lecture.isCommitted()) {
            for (org.cpsolver.coursett.model.Student student : students) {
                student.addCanNotEnroll(lecture);
            }
        } else {
            for (Class_ child : clazz.getChildClasses()) {
                this.propagateCommittedAssignment(students, parent, child);
            }
        }
    }

    private void loadCommittedStudentConflicts(org.hibernate.Session hibSession, Set<Long> offeringsToAvoid) {
        org.unitime.timetable.model.Assignment assignment;
        List assignmentEnrollments = hibSession.createQuery("select distinct a, e.studentId, io.uniqueId from Solution s inner join s.assignments a inner join s.studentEnrollments e inner join a.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering io where s.commited=true and s.owner.session.uniqueId=:sessionId and s.owner.uniqueId not in (" + this.iSolverGroupIds + ") and a.clazz=e.clazz", Object[].class).setParameter("sessionId", (Object)this.iSessionId).list();
        Hashtable<org.unitime.timetable.model.Assignment, HashSet<org.cpsolver.coursett.model.Student>> assignments = new Hashtable<org.unitime.timetable.model.Assignment, HashSet<org.cpsolver.coursett.model.Student>>();
        for (Object[] objectArray : assignmentEnrollments) {
            org.cpsolver.coursett.model.Student student;
            assignment = (org.unitime.timetable.model.Assignment)objectArray[0];
            Long studentId = (Long)objectArray[1];
            Long offeringId = (Long)objectArray[2];
            if (offeringsToAvoid.contains(offeringId) || (student = this.iStudents.get(studentId)) == null) continue;
            HashSet<org.cpsolver.coursett.model.Student> students = (HashSet<org.cpsolver.coursett.model.Student>)assignments.get(assignment);
            if (students == null) {
                students = new HashSet<org.cpsolver.coursett.model.Student>();
                assignments.put(assignment, students);
            }
            students.add(student);
        }
        for (Object[] objectArray : assignmentEnrollments) {
            assignment = (org.unitime.timetable.model.Assignment)objectArray[0];
            if (assignments.containsKey(assignment)) continue;
            hibSession.evict((Object)assignment);
        }
        this.setPhase(MSG.phaseLoadCommittedStudentConflicts(), assignments.size());
        for (Map.Entry entry : assignments.entrySet()) {
            assignment = (org.unitime.timetable.model.Assignment)entry.getKey();
            HashSet students = (HashSet)entry.getValue();
            Placement committedPlacement = assignment.getPlacement();
            for (org.cpsolver.coursett.model.Student student : students) {
                student.addCommitedPlacement(committedPlacement);
            }
            if (!this.iLectures.containsKey(assignment.getClassId())) {
                this.iLectures.put(assignment.getClassId(), (Lecture)committedPlacement.variable());
                ((TimetableModel)this.getModel()).addVariable((Variable)((Lecture)committedPlacement.variable()));
            }
            this.propagateCommittedAssignment(students, assignment);
            this.incProgress();
        }
    }

    private boolean somehowEnroll(org.cpsolver.coursett.model.Student student, CourseOffering course, float weight, Double priority) {
        if (course.getInstructionalOffering().isNotOffered().booleanValue()) {
            return false;
        }
        boolean hasSomethingCommitted = false;
        block0: for (InstrOfferingConfig config : course.getInstructionalOffering().getInstrOfferingConfigs()) {
            for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                for (Class_ clazz2 : subpart.getClasses()) {
                    if (clazz2.getCommittedAssignment() == null) continue;
                    hasSomethingCommitted = true;
                    break block0;
                }
            }
        }
        if (!hasSomethingCommitted) {
            return false;
        }
        if (!this.iOfferings.containsKey(course.getInstructionalOffering())) {
            this.iOfferings.put(course.getInstructionalOffering(), this.loadOffering(course.getInstructionalOffering(), true));
        }
        if (this.iLoadCommittedReservations) {
            Lecture lecture;
            InstructionalMethod im;
            StudentSchedulingRule rule;
            InstructionalOffering offering = course.getInstructionalOffering();
            HashSet<Long> reservedClasses = new HashSet<Long>();
            for (Reservation reservation : offering.getReservations()) {
                StudentCourseDemands.WeightedStudentId studentId;
                if (reservation.getClasses().isEmpty() && reservation.getConfigurations().isEmpty()) continue;
                if (reservation instanceof CourseReservation) {
                    CourseReservation cr = (CourseReservation)reservation;
                    if (!course.equals(cr.getCourse())) {
                        continue;
                    }
                } else if (reservation instanceof CurriculumReservation) {
                    StudentCourseDemands.WeightedStudentId studentId2 = this.iWeightedStudents.get(student.getId());
                    if (studentId2 == null) continue;
                    CurriculumReservation cr = (CurriculumReservation)reservation;
                    boolean match = false;
                    for (StudentCourseDemands.AreaClasfMajor areaClasfMajor : studentId2.getMajors()) {
                        if (!cr.hasArea(areaClasfMajor.getArea()) || !cr.hasClassification(areaClasfMajor.getClasf()) || !cr.hasMajor(areaClasfMajor.getMajor()) || !cr.hasConcentration(areaClasfMajor.getMajor(), areaClasfMajor.getConcentration())) continue;
                        match = true;
                        break;
                    }
                    if (!match && !studentId2.getMinors().isEmpty()) {
                        for (StudentCourseDemands.AreaClasfMajor areaClasfMajor : studentId2.getMinors()) {
                            if (!cr.hasArea(areaClasfMajor.getArea()) || !cr.hasClassification(areaClasfMajor.getClasf()) || !cr.hasMinor(areaClasfMajor.getMajor())) continue;
                            match = true;
                            break;
                        }
                    }
                    if (!match) {
                        continue;
                    }
                } else if (reservation instanceof LearningCommunityReservation) {
                    StudentCourseDemands.Group g;
                    LearningCommunityReservation lcr = (LearningCommunityReservation)reservation;
                    if (!course.equals(lcr.getCourse()) || (studentId = this.iWeightedStudents.get(student.getId())) == null || lcr.getGroup() == null || (g = studentId.getGroup(lcr.getGroup().getGroupAbbreviation())) == null || g.getId() < 0L) {
                        continue;
                    }
                } else if (reservation instanceof StudentGroupReservation) {
                    StudentCourseDemands.Group g;
                    StudentGroupReservation gr;
                    StudentCourseDemands.WeightedStudentId studentId2 = this.iWeightedStudents.get(student.getId());
                    if (studentId2 == null || (gr = (StudentGroupReservation)reservation).getGroup() == null || (g = studentId2.getGroup(gr.getGroup().getGroupAbbreviation())) == null || g.getId() < 0L) {
                        continue;
                    }
                } else if (reservation instanceof IndividualReservation) {
                    IndividualReservation ir = (IndividualReservation)reservation;
                    studentId = this.iWeightedStudents.get(student.getId());
                    if (studentId == null) continue;
                    boolean match = false;
                    for (Student student2 : ir.getStudents()) {
                        if (studentId.getStudentId() != student2.getUniqueId().longValue()) continue;
                        match = true;
                    }
                    if (!match) {
                        continue;
                    }
                } else {
                    boolean match;
                    if (!(reservation instanceof UniversalOverrideReservation)) continue;
                    Iterator<InstrOfferingConfig> ur = (UniversalOverrideReservation)reservation;
                    studentId = this.iWeightedStudents.get(student.getId());
                    if (studentId == null || studentId.getStudent() == null) continue;
                    boolean bl = match = ((BaseUniversalOverrideReservation)((Object)ur)).getFilter() != null && !((BaseUniversalOverrideReservation)((Object)ur)).getFilter().isEmpty() && new Query(((BaseUniversalOverrideReservation)((Object)ur)).getFilter()).match(new DbFindEnrollmentInfoAction.DbStudentMatcher(studentId.getStudent()));
                    if (!match) continue;
                }
                for (Class_ clazz : reservation.getClasses()) {
                    this.propagateReservedClasses(clazz, reservedClasses);
                    for (Class_ parent = clazz.getParentClass(); parent != null; parent = parent.getParentClass()) {
                        reservedClasses.add(parent.getUniqueId());
                    }
                }
                for (InstrOfferingConfig config : reservation.getConfigurations()) {
                    for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                        for (Class_ class_ : subpart.getClasses()) {
                            reservedClasses.add(class_.getUniqueId());
                        }
                    }
                }
            }
            if (!reservedClasses.isEmpty()) {
                this.iProgress.debug(course.getCourseName() + ": Student " + student.getId() + " has reserved classes " + String.valueOf(reservedClasses));
                HashSet<Lecture> prohibited = new HashSet<Lecture>();
                for (InstrOfferingConfig config : course.getInstructionalOffering().getInstrOfferingConfigs()) {
                    boolean hasConfigReservation = false;
                    block13: for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                        for (Class_ class_ : subpart.getClasses()) {
                            if (!reservedClasses.contains(class_.getUniqueId())) continue;
                            hasConfigReservation = true;
                            break block13;
                        }
                    }
                    for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                        boolean bl;
                        boolean bl2 = false;
                        for (Class_ clazz4 : subpart.getClasses()) {
                            if (!reservedClasses.contains(clazz4.getUniqueId())) continue;
                            bl = true;
                            break;
                        }
                        if (hasConfigReservation && !bl) continue;
                        for (Class_ clazz : subpart.getClasses()) {
                            Lecture lecture2;
                            if (reservedClasses.contains(clazz.getUniqueId()) || (lecture2 = this.iLectures.get(clazz.getUniqueId())) == null) continue;
                            prohibited.add(lecture2);
                        }
                    }
                }
                this.iProgress.debug(course.getCourseName() + ": Student " + student.getId() + " cannot attend classes " + String.valueOf(prohibited));
                student.addCanNotEnroll(offering.getUniqueId(), prohibited);
            }
            if ((rule = this.iStudentRules.get(student)) != null) {
                if (rule.getInstructonalMethod() != null) {
                    for (InstrOfferingConfig config : offering.getInstrOfferingConfigs()) {
                        im = config.getEffectiveInstructionalMethod();
                        if (rule.matchesInstructionalMethod(im)) continue;
                        this.iProgress.debug(course.getCourseName() + ": " + rule.getRuleName() + " student " + student.getId() + " cannot attend config " + config.getName() + (String)(im == null ? "" : " (" + im.getReference() + ")"));
                        for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                            for (Class_ class_ : subpart.getClasses()) {
                                lecture = this.iLectures.get(class_.getUniqueId());
                                if (lecture == null || !this.iLoadCommittedReservations && lecture.isCommitted()) continue;
                                student.addCanNotEnroll(lecture);
                            }
                        }
                    }
                }
            } else if (this.iOnlineOnlyInstructionalModeRegExp != null) {
                if (this.iOnlineOnlyStudents.contains(student)) {
                    if (this.iOnlineOnlyInstructionalModeRegExp != null) {
                        for (InstrOfferingConfig config : offering.getInstrOfferingConfigs()) {
                            im = config.getEffectiveInstructionalMethod();
                            if (this.iOnlineOnlyInstructionalModeRegExp.isEmpty()) {
                                if (im == null || im.getReference() == null || im.getReference().isEmpty()) continue;
                                this.iProgress.debug(course.getCourseName() + ": Online-only student " + student.getId() + " cannot attend config " + config.getName() + " (" + im.getReference() + ")");
                                for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                                    for (Class_ class_ : subpart.getClasses()) {
                                        lecture = this.iLectures.get(class_.getUniqueId());
                                        if (lecture == null || !this.iLoadCommittedReservations && lecture.isCommitted()) continue;
                                        student.addCanNotEnroll(lecture);
                                    }
                                }
                                continue;
                            }
                            if (im != null && im.getReference() != null && im.getReference().matches(this.iOnlineOnlyInstructionalModeRegExp)) continue;
                            this.iProgress.debug(course.getCourseName() + ": Online-only student " + student.getId() + " cannot attend config " + config.getName() + (String)(im == null ? "" : " (" + im.getReference() + ")"));
                            for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                                for (Class_ class_ : subpart.getClasses()) {
                                    lecture = this.iLectures.get(class_.getUniqueId());
                                    if (lecture == null || !this.iLoadCommittedReservations && lecture.isCommitted()) continue;
                                    student.addCanNotEnroll(lecture);
                                }
                            }
                        }
                    }
                } else if (this.iResidentialInstructionalModeRegExp != null) {
                    for (InstrOfferingConfig config : offering.getInstrOfferingConfigs()) {
                        im = config.getEffectiveInstructionalMethod();
                        if (this.iResidentialInstructionalModeRegExp.isEmpty()) {
                            if (im == null || im.getReference() == null || im.getReference().isEmpty()) continue;
                            this.iProgress.debug(course.getCourseName() + ": Residential student " + student.getId() + " cannot attend config " + config.getName() + " (" + im.getReference() + ")");
                            for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                                for (Class_ class_ : subpart.getClasses()) {
                                    lecture = this.iLectures.get(class_.getUniqueId());
                                    if (lecture == null || !this.iLoadCommittedReservations && lecture.isCommitted()) continue;
                                    student.addCanNotEnroll(lecture);
                                }
                            }
                            continue;
                        }
                        if (im != null && im.getReference() != null && im.getReference().matches(this.iResidentialInstructionalModeRegExp)) continue;
                        this.iProgress.debug(course.getCourseName() + ": Residential student " + student.getId() + " cannot attend config " + config.getName() + (String)(im == null ? "" : " (" + im.getReference() + ")"));
                        for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                            for (Class_ class_ : subpart.getClasses()) {
                                lecture = this.iLectures.get(class_.getUniqueId());
                                if (lecture == null || !this.iLoadCommittedReservations && lecture.isCommitted()) continue;
                                student.addCanNotEnroll(lecture);
                            }
                        }
                    }
                }
            }
        }
        student.addOffering(course.getInstructionalOffering().getUniqueId(), (double)weight, priority);
        Set<org.cpsolver.coursett.model.Student> students = this.iCourse2students.get(course);
        if (students == null) {
            students = new HashSet<org.cpsolver.coursett.model.Student>();
            this.iCourse2students.put(course, students);
        }
        students.add(student);
        return true;
    }

    private void makeupCommittedStudentConflicts(Set<Long> offeringsToAvoid) {
        this.setPhase(MSG.phaseMakeupCommittedStudentConflicts(), this.iStudents.size());
        for (org.cpsolver.coursett.model.Student student : this.iStudents.values()) {
            Set<StudentCourseDemands.WeightedCourseOffering> other;
            Set<StudentCourseDemands.WeightedCourseOffering> courses = this.iStudentCourseDemands.getCourses(student.getId());
            if (this.iStudentGroupCourseDemands != null && (other = this.iStudentGroupCourseDemands.getCourses(student.getId())) != null && !other.isEmpty()) {
                if (courses == null) {
                    courses = other;
                } else {
                    courses.addAll(other);
                }
            }
            this.incProgress();
            if (courses == null) continue;
            for (StudentCourseDemands.WeightedCourseOffering course : courses) {
                if (course.getPrimaryOfferingId() != null && !course.getPrimaryOfferingId().equals(course.getCourseOffering().getInstructionalOffering().getUniqueId())) {
                    student.addAlternatives(course.getPrimaryOfferingId(), course.getCourseOffering().getInstructionalOffering().getUniqueId());
                }
                if (offeringsToAvoid.contains(course.getCourseOffering().getInstructionalOffering().getUniqueId()) || this.somehowEnroll(student, course.getCourseOffering(), course.getWeight(), this.iStudentCourseDemands.getEnrollmentPriority(student.getId(), course.getCourseOfferingId()))) continue;
                offeringsToAvoid.add(course.getCourseOffering().getInstructionalOffering().getUniqueId());
            }
        }
    }

    private void propagateReservedClasses(Class_ clazz, Set<Long> reservedClasses) {
        reservedClasses.add(clazz.getUniqueId());
        for (Class_ child : clazz.getChildClasses()) {
            this.propagateReservedClasses(child, reservedClasses);
        }
    }

    private boolean canAttend(Set<Lecture> cannotAttendLectures, Collection<Lecture> lectures) {
        for (Lecture lecture : lectures) {
            if (cannotAttendLectures.contains(lecture)) continue;
            boolean canAttend = true;
            if (lecture.hasAnyChildren()) {
                for (Long subpartId : lecture.getChildrenSubpartIds()) {
                    if (this.canAttend(cannotAttendLectures, lecture.getChildren(subpartId))) continue;
                    canAttend = false;
                    break;
                }
            }
            if (!canAttend) continue;
            return true;
        }
        return false;
    }

    private boolean canAttendConfigurations(Set<Lecture> cannotAttendLectures, List<Configuration> configurations) {
        for (Configuration cfg : configurations) {
            boolean canAttend = true;
            for (Long subpartId : cfg.getTopSubpartIds()) {
                if (this.canAttend(cannotAttendLectures, cfg.getTopLectures(subpartId))) continue;
                canAttend = false;
                break;
            }
            if (!canAttend) continue;
            return true;
        }
        return false;
    }

    private void checkReservation(CourseOffering course, Set<Lecture> cannotAttendLectures, List<Configuration> configurations) {
        if (this.canAttendConfigurations(cannotAttendLectures, configurations)) {
            return;
        }
        this.iProgress.message(this.msglevel("badCourseReservation", 5), MSG.warnBadCourseReservations(this.getOfferingLabel(course)));
    }

    private Collection<InstrOfferingConfig> sortedConfigs(InstructionalOffering offering) {
        if (offering.getInstrOfferingConfigs().size() <= 1) {
            return offering.getInstrOfferingConfigs();
        }
        TreeSet<InstrOfferingConfig> configs = new TreeSet<InstrOfferingConfig>(new InstrOfferingConfigComparator(offering.getControllingCourseOffering().getSubjectArea().getUniqueId()));
        configs.addAll(offering.getInstrOfferingConfigs());
        return configs;
    }

    private Hashtable<InstrOfferingConfig, Set<SchedulingSubpart>> loadOffering(InstructionalOffering offering, boolean assignCommitted) {
        HashSet<Long> solverGroupIds = new HashSet<Long>();
        for (Long solverGroupId : this.iSolverGroupId) {
            solverGroupIds.add(solverGroupId);
        }
        Hashtable<InstrOfferingConfig, Set<SchedulingSubpart>> cfg2topSubparts = new Hashtable<InstrOfferingConfig, Set<SchedulingSubpart>>();
        ArrayList<Configuration> altCfgs = new ArrayList<Configuration>();
        this.iAltConfigurations.put(offering, altCfgs);
        for (InstrOfferingConfig config : this.sortedConfigs(offering)) {
            Configuration cfg = new Configuration(offering.getUniqueId(), config.getUniqueId(), config.getLimit().intValue());
            HashSet<SchedulingSubpart> topSubparts = new HashSet<SchedulingSubpart>();
            for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                for (Class_ clazz : subpart.getClasses()) {
                    Lecture lecture = this.iLectures.get(clazz.getUniqueId());
                    if (lecture != null) continue;
                    if (clazz.getManagingDept().getSolverGroup() == null) {
                        this.iProgress.message(this.msglevel("noSolverGroup", 5), MSG.warnNoSolverGroup(this.getClassLabel(clazz), clazz.getManagingDept().getManagingDeptAbbv()));
                        continue;
                    }
                    if (solverGroupIds.contains(clazz.getManagingDept().getSolverGroup().getUniqueId()) || clazz.getCommittedAssignment() == null || this.iLectures.containsKey(clazz.getUniqueId())) continue;
                    Placement committedPlacement = clazz.getCommittedAssignment().getPlacement();
                    lecture = (Lecture)committedPlacement.variable();
                    this.iLectures.put(clazz.getUniqueId(), lecture);
                    this.iClasses.put(lecture.getClassId(), clazz);
                    this.iSubparts.put(subpart.getUniqueId(), subpart);
                    ((TimetableModel)this.getModel()).addVariable((Variable)lecture);
                    if (!assignCommitted) continue;
                    ((TimetableModel)this.getModel()).weaken(this.getAssignment(), (Value)committedPlacement);
                    Map conflictConstraints = ((TimetableModel)this.getModel()).conflictConstraints(this.getAssignment(), (Value)committedPlacement);
                    if (conflictConstraints.isEmpty()) {
                        this.getAssignment().assign(0L, (Value)committedPlacement);
                        continue;
                    }
                    Object warn = MSG.warnCannotAssignCommitted(this.getClassLabel(lecture), committedPlacement.getLongName(this.iUseAmPm));
                    warn = (String)warn + MSG.warnReasonFirstLine();
                    for (Constraint c : conflictConstraints.keySet()) {
                        Set vals = (Set)conflictConstraints.get(c);
                        for (Placement v : vals) {
                            warn = (String)warn + MSG.warnReasonConflict(this.getClassLabel((Lecture)v.variable()), v.getLongName(this.iUseAmPm));
                        }
                        warn = (String)warn + MSG.warnReasonConstraint(TimetableSolver.getConstraintName((Constraint<Lecture, Placement>)c));
                        this.iProgress.message(this.msglevel("cannotAssignCommitted", 5), (String)warn);
                    }
                }
            }
            for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                ArrayList<Lecture> sameSubpart = new ArrayList<Lecture>();
                for (Class_ clazz : subpart.getClasses()) {
                    Lecture lecture = this.iLectures.get(clazz.getUniqueId());
                    if (lecture == null) continue;
                    Class_ parentClazz = clazz.getParentClass();
                    if (parentClazz != null) {
                        Lecture parentLecture = null;
                        Class_ c = clazz;
                        while (parentLecture == null && c.getParentClass() != null) {
                            c = c.getParentClass();
                            parentLecture = this.iLectures.get(c.getUniqueId());
                        }
                        if (parentLecture != null) {
                            lecture.setParent(parentLecture);
                        }
                    }
                    sameSubpart.add(lecture);
                    lecture.setSameSubpartLectures(sameSubpart);
                    if (lecture.getParent() != null) continue;
                    lecture.setConfiguration(cfg);
                    topSubparts.add(subpart);
                }
            }
            if (cfg.getTopLectures().isEmpty()) continue;
            altCfgs.add(cfg);
            cfg.setAltConfigurations(altCfgs);
            cfg2topSubparts.put(config, topSubparts);
        }
        return cfg2topSubparts;
    }

    /*
     * WARNING - void declaration
     */
    private void load(org.hibernate.Session hibSession) throws Exception {
        Date[] startEnd;
        void var10_51;
        int i;
        this.iProgress.setStatus(MSG.statusLoadingInputData());
        TravelTime.populateTravelTimes(((TimetableModel)this.getModel()).getDistanceMetric(), this.iSessionId, hibSession);
        this.iSolverGroup = null;
        this.iSession = null;
        if (this.iSolverGroup == null) {
            this.iSolverGroup = new SolverGroup[this.iSolverGroupId.length];
            for (int i2 = 0; i2 < this.iSolverGroupId.length; ++i2) {
                this.iSolverGroup[i2] = (SolverGroup)SolverGroupDAO.getInstance().get(this.iSolverGroupId[i2], hibSession);
                if (this.iSolverGroup[i2] == null) {
                    this.iProgress.message(this.msglevel("loadFailed", 7), MSG.fatalUnableToLoadSolverGroup(this.iSolverGroupId[i2]));
                    return;
                }
                this.iProgress.debug("solver group[" + (i2 + 1) + "]: " + this.iSolverGroup[i2].getName());
            }
        }
        if (this.iSolverGroup == null || this.iSolverGroup.length == 0) {
            this.iProgress.message(this.msglevel("loadFailed", 7), MSG.fatalNoSolverGroupLoaded());
            return;
        }
        this.iDepartmentIds = "";
        for (int j = 0; j < this.iSolverGroup.length; ++j) {
            for (Department d : this.iSolverGroup[j].getDepartments()) {
                if (this.iDepartmentIds.length() > 0) {
                    this.iDepartmentIds = this.iDepartmentIds + ",";
                }
                this.iDepartmentIds = this.iDepartmentIds + d.getUniqueId().toString();
            }
        }
        ((TimetableModel)this.getModel()).getProperties().setProperty("General.DepartmentIds", this.iDepartmentIds);
        Hashtable<Long, org.unitime.timetable.model.Solution> solutions = null;
        if (this.iSolutionId != null && this.iSolutionId.length > 0) {
            solutions = new Hashtable<Long, org.unitime.timetable.model.Solution>();
            Object note = "";
            for (int i3 = 0; i3 < this.iSolutionId.length; ++i3) {
                org.unitime.timetable.model.Solution solution = (org.unitime.timetable.model.Solution)SolutionDAO.getInstance().get(this.iSolutionId[i3], hibSession);
                if (solution == null) {
                    this.iProgress.message(this.msglevel("loadFailed", 7), MSG.fatalUnableToLoadSolution(this.iSolutionId[i3]));
                    return;
                }
                this.iProgress.debug("solution[" + (i3 + 1) + "] version: " + solution.getUniqueId() + " (created " + String.valueOf(solution.getCreated()) + ", solver group " + solution.getOwner().getName() + ")");
                if (solution.getNote() != null && !((String)note).contains(solution.getNote())) {
                    if (((String)note).length() > 0) {
                        note = (String)note + "\n";
                    }
                    note = (String)note + solution.getNote();
                }
                solutions.put(solution.getOwner().getUniqueId(), solution);
                if (((String)note).length() <= 1000) continue;
                note = ((String)note).substring(0, 1000);
            }
            ((TimetableModel)this.getModel()).getProperties().setProperty("General.Note", (String)note);
            Object solutionIdStr = "";
            for (i = 0; i < this.iSolverGroupId.length; ++i) {
                org.unitime.timetable.model.Solution solution = (org.unitime.timetable.model.Solution)solutions.get(this.iSolverGroupId[i]);
                if (solution == null) continue;
                if (((String)solutionIdStr).length() > 0) {
                    solutionIdStr = (String)solutionIdStr + ",";
                }
                solutionIdStr = (String)solutionIdStr + solution.getUniqueId().toString();
            }
            ((TimetableModel)this.getModel()).getProperties().setProperty("General.SolutionId", (String)solutionIdStr);
        }
        if (this.iSession == null) {
            this.iSession = (Session)SessionDAO.getInstance().get(this.iSessionId, hibSession);
        }
        if (this.iSession == null) {
            this.iProgress.message(this.msglevel("loadFailed", 7), MSG.fatalNoSessionLoaded());
            return;
        }
        this.iProgress.debug("session: " + this.iSession.getLabel());
        ((TimetableModel)this.getModel()).getProperties().setProperty("Data.Term", this.iSession.getAcademicYearTerm());
        ((TimetableModel)this.getModel()).getProperties().setProperty("Data.Initiative", this.iSession.getAcademicInitiative());
        ((TimetableModel)this.getModel()).setYear(this.iSession.getSessionStartYear());
        ((TimetableModel)this.getModel()).getProperties().setProperty("DatePattern.DayOfWeekOffset", String.valueOf(Constants.getDayOfWeek(DateUtils.getDate(1, this.iSession.getPatternStartMonth(), this.iSession.getSessionStartYear()))));
        if (this.iSession.getDefaultDatePattern() != null) {
            BitSet pattern = this.iSession.getDefaultDatePattern().getPatternBitSet();
            Object patternStr = "";
            for (i = 0; i < pattern.length(); ++i) {
                patternStr = (String)patternStr + (pattern.get(i) ? "1" : "0");
            }
            ((TimetableModel)this.getModel()).getProperties().setProperty("DatePattern.Default", (String)patternStr);
        }
        this.iAllClasses = new TreeSet<Class_>(new ClassComparator(5));
        for (int i4 = 0; i4 < this.iSolverGroup.length; ++i4) {
            for (Department d : this.iSolverGroup[i4].getDepartments()) {
                this.iAllClasses.addAll(d.getClassesFetchWithStructure());
            }
        }
        if (this.iAllClasses == null || this.iAllClasses.isEmpty()) {
            this.iProgress.message(this.msglevel("noClasses", 7), MSG.fatalNoClassesToLoad());
            return;
        }
        this.iProgress.debug("classes to load: " + this.iAllClasses.size());
        this.setPhase(MSG.phaseLoadingClasses(), this.iAllClasses.size());
        HashMap<Long, org.unitime.timetable.model.Assignment> assignments = null;
        if (this.iFixedTimesMPP) {
            assignments = new HashMap<Long, org.unitime.timetable.model.Assignment>();
            if (solutions != null) {
                for (int idx = 0; idx < this.iSolverGroupId.length; ++idx) {
                    org.unitime.timetable.model.Solution solution = (org.unitime.timetable.model.Solution)solutions.get(this.iSolverGroupId[idx]);
                    if (solution == null) continue;
                    for (org.unitime.timetable.model.Assignment assignment : solution.getAssignments()) {
                        assignments.put(assignment.getClassId(), assignment);
                    }
                }
            } else if (this.iLoadCommittedAssignments) {
                for (Class_ clazz : this.iAllClasses) {
                    if (clazz.getCommittedAssignment() == null) continue;
                    assignments.put(clazz.getUniqueId(), clazz.getCommittedAssignment());
                }
            }
        }
        int ord = 0;
        HashSet<SchedulingSubpart> subparts = new HashSet<SchedulingSubpart>();
        for (Class_ class_ : this.iAllClasses) {
            Lecture lecture = this.loadClass(class_, assignments == null ? null : (org.unitime.timetable.model.Assignment)assignments.get(class_.getUniqueId()), hibSession);
            subparts.add(class_.getSchedulingSubpart());
            if (lecture != null) {
                lecture.setOrd(ord++);
            }
            this.iClasses.put(class_.getUniqueId(), class_);
            this.incProgress();
        }
        this.loadInstructorAvailabilities(hibSession);
        this.loadRoomAvailabilities(hibSession);
        this.setPhase(MSG.phaseLoadingOfferings(), this.iAllClasses.size());
        HashSet<Long> loadedOfferings = new HashSet<Long>();
        for (Class_ clazz : this.iAllClasses) {
            InstructionalOffering instructionalOffering;
            Lecture lecture = this.iLectures.get(clazz.getUniqueId());
            this.incProgress();
            if (lecture == null || !loadedOfferings.add((instructionalOffering = clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering()).getUniqueId())) continue;
            this.iOfferings.put(instructionalOffering, this.loadOffering(instructionalOffering, false));
        }
        ArrayList arrayList = new ArrayList();
        for (int i5 = 0; i5 < this.iSolverGroup.length; ++i5) {
            arrayList.addAll(this.iSolverGroup[i5].getDistributionPreferences());
        }
        this.setPhase(MSG.phaseLoadingDistributions(), arrayList.size());
        for (DistributionPref distributionPref : arrayList) {
            if (!PreferenceLevel.sNeutral.equals(distributionPref.getPrefLevel().getPrefProlog())) {
                this.loadGroupConstraint(distributionPref);
            }
            this.incProgress();
        }
        HashSet<Long> checkedDistPrefIds = new HashSet<Long>();
        for (int i6 = 0; i6 < this.iSolverGroup.length; ++i6) {
            Iterator<Department> iterator = this.iSolverGroup[i6].getDepartments().iterator();
            while (iterator.hasNext()) {
                this.loadInstructorGroupConstraints(iterator.next(), checkedDistPrefIds, hibSession);
            }
        }
        if (this.iAutoSameStudents) {
            this.setPhase(MSG.phasePostingSameStudents(), this.iAllClasses.size());
            for (Class_ class_ : this.iAllClasses) {
                Lecture lecture = this.iLectures.get(class_.getUniqueId());
                if (lecture == null) continue;
                if (!lecture.hasAnyChildren()) {
                    this.postSameStudentConstraint(class_, this.iAutoSameStudentsConstraint);
                }
                this.incProgress();
            }
        }
        if (this.iAutoPrecedence != null) {
            PreferenceLevel pref = PreferenceLevel.getPreferenceLevel(this.iAutoPrecedence);
            if (pref == null) {
                for (PreferenceLevel p : PreferenceLevel.getPreferenceLevelList()) {
                    if (!this.iAutoPrecedence.equalsIgnoreCase(p.getPrefProlog()) && !this.iAutoPrecedence.equalsIgnoreCase(p.getPrefName()) && !this.iAutoPrecedence.equals(p.getAbbreviation())) continue;
                    pref = p;
                    break;
                }
            }
            if (pref == null) {
                this.iProgress.message(this.msglevel("autoPrecedence", 5), MSG.warnPrecedenceNotRecognized(this.iAutoPrecedence));
            } else if (!PreferenceLevel.sNeutral.equals(pref.getPrefProlog())) {
                this.setPhase(MSG.phasePostingAutomaticPrecedences(), this.iAllClasses.size());
                for (Class_ clazz : this.iAllClasses) {
                    Lecture lecture = this.iLectures.get(clazz.getUniqueId());
                    if (lecture == null) continue;
                    if (!lecture.hasAnyChildren()) {
                        this.postPrecedenceConstraint(clazz, pref.getPrefProlog());
                    }
                    this.incProgress();
                }
            }
        }
        this.postAutomaticHierarchicalConstraints(hibSession);
        this.postAutomaticInstructorConstraints(hibSession);
        this.assignCommited();
        this.setPhase(MSG.phasePostingClassLimits(), this.iOfferings.size());
        for (Map.Entry<InstructionalOffering, Hashtable<InstrOfferingConfig, Set<SchedulingSubpart>>> entry : this.iOfferings.entrySet()) {
            Hashtable<InstrOfferingConfig, Set<SchedulingSubpart>> topSubparts = entry.getValue();
            for (Map.Entry<InstrOfferingConfig, Set<SchedulingSubpart>> entry2 : topSubparts.entrySet()) {
                InstrOfferingConfig config = entry2.getKey();
                Set<SchedulingSubpart> set = entry2.getValue();
                for (SchedulingSubpart subpart : set) {
                    Lecture lecture;
                    boolean isMakingSense = false;
                    for (Class_ clazz : subpart.getClasses()) {
                        Lecture lecture2 = this.iLectures.get(clazz.getUniqueId());
                        if (lecture2 == null) continue;
                        this.createChildrenClassLimitConstraits(lecture2);
                        if (lecture2.isCommitted() || lecture2.minClassLimit() == lecture2.maxClassLimit()) continue;
                        isMakingSense = true;
                    }
                    if (!isMakingSense) continue;
                    if (subpart.getParentSubpart() == null) {
                        ClassLimitConstraint clc = new ClassLimitConstraint(config.getLimit().intValue(), this.getClassLimitConstraitName(subpart));
                        for (Class_ clazz : subpart.getClasses()) {
                            lecture = this.iLectures.get(clazz.getUniqueId());
                            if (lecture == null || lecture.isCommitted()) {
                                clc.setClassLimitDelta(clc.getClassLimitDelta() - clazz.getClassLimit());
                                continue;
                            }
                            clc.addVariable((Variable)lecture);
                        }
                        if (clc.variables().isEmpty()) continue;
                        this.iProgress.trace("Added constraint " + clc.getName() + " between " + String.valueOf(clc.variables()));
                        ((TimetableModel)this.getModel()).addConstraint((Constraint)clc);
                        continue;
                    }
                    Hashtable<Long, ClassLimitConstraint> clcs = new Hashtable<Long, ClassLimitConstraint>();
                    for (Class_ clazz : subpart.getClasses()) {
                        lecture = this.iLectures.get(clazz.getUniqueId());
                        Class_ parentClazz = clazz.getParentClass();
                        ClassLimitConstraint clc = (ClassLimitConstraint)clcs.get(parentClazz.getUniqueId());
                        if (clc == null) {
                            clc = new ClassLimitConstraint(parentClazz.getClassLimit(), parentClazz.getClassLabel(this.iShowClassSuffix, this.iShowConfigName));
                            clcs.put(parentClazz.getUniqueId(), clc);
                        }
                        if (lecture == null || lecture.isCommitted()) {
                            clc.setClassLimitDelta(clc.getClassLimitDelta() - clazz.getClassLimit());
                            continue;
                        }
                        clc.addVariable((Variable)lecture);
                    }
                    for (ClassLimitConstraint clc : clcs.values()) {
                        if (clc.variables().isEmpty()) continue;
                        this.iProgress.trace("Added constraint " + clc.getName() + " between " + String.valueOf(clc.variables()));
                        ((TimetableModel)this.getModel()).addConstraint((Constraint)clc);
                    }
                }
            }
            this.incProgress();
        }
        this.iStudentCourseDemands.init(hibSession, this.iProgress, this.iSession, this.iOfferings.keySet());
        if (this.iStudentGroupCourseDemands != null) {
            this.iStudentGroupCourseDemands.init(hibSession, this.iProgress, this.iSession, this.iOfferings.keySet());
        }
        this.setPhase(MSG.phaseLoadingStudents(), this.iOfferings.size());
        for (InstructionalOffering instructionalOffering : this.iOfferings.keySet()) {
            boolean unlimitedOffering = false;
            int n = 0;
            for (InstrOfferingConfig config : instructionalOffering.getInstrOfferingConfigs()) {
                if (config.isUnlimitedEnrollment().booleanValue()) {
                    unlimitedOffering = true;
                    continue;
                }
                n += config.getLimit().intValue();
            }
            Object var13_82 = null;
            if (!unlimitedOffering) {
                int totalCourseLimit = 0;
                for (CourseOffering courseOffering : instructionalOffering.getCourseOfferings()) {
                    int courseLimit = -1;
                    if (courseOffering.getReservation() != null) {
                        courseLimit = courseOffering.getReservation();
                    }
                    if (courseLimit < 0) {
                        if (instructionalOffering.getCourseOfferings().size() == 1) {
                            courseLimit = n;
                        } else {
                            this.iProgress.message(this.msglevel("crossListWithoutReservation", 3), MSG.infoCrosslistNoCourseReservations(this.getOfferingLabel(courseOffering)));
                            courseLimit = courseOffering.getProjectedDemand() != null && instructionalOffering.getProjectedDemand() > 0 ? courseOffering.getProjectedDemand() : (courseOffering.getDemand() != null && instructionalOffering.getDemand() > 0 ? courseOffering.getDemand() : n / instructionalOffering.getCourseOfferings().size());
                        }
                    }
                    totalCourseLimit += courseLimit;
                }
                if (totalCourseLimit < n) {
                    this.iProgress.message(this.msglevel("courseReservationsBelowLimit", totalCourseLimit == 0 ? 3 : 5), MSG.warnReservationBelowLimit(this.getOfferingLabel(instructionalOffering), totalCourseLimit, n));
                }
                if (totalCourseLimit > n) {
                    this.iProgress.message(this.msglevel("courseReservationsOverLimit", 3), MSG.warnReservationsOverLimit(this.getOfferingLabel(instructionalOffering), totalCourseLimit, n));
                }
                if (totalCourseLimit == 0) continue;
                if (totalCourseLimit != n) {
                    Double d = (double)n / (double)totalCourseLimit;
                }
            }
            for (CourseOffering courseOffering : instructionalOffering.getCourseOfferings()) {
                void var13_84;
                void var16_174;
                Set<StudentCourseDemands.WeightedStudentId> other;
                Set<StudentCourseDemands.WeightedStudentId> set = this.iStudentCourseDemands.getDemands(courseOffering);
                if (this.iStudentGroupCourseDemands != null && (other = this.iStudentGroupCourseDemands.getDemands(courseOffering)) != null && !other.isEmpty()) {
                    if (set == null) {
                        Set<StudentCourseDemands.WeightedStudentId> set2 = other;
                    } else {
                        set.addAll(other);
                    }
                }
                float studentWeight = 0.0f;
                if (var16_174 != null) {
                    for (StudentCourseDemands.WeightedStudentId studentId : var16_174) {
                        studentWeight += studentId.getWeight();
                    }
                }
                int courseLimit = -1;
                if (courseOffering.getReservation() != null) {
                    courseLimit = courseOffering.getReservation();
                }
                if (courseLimit < 0) {
                    courseLimit = instructionalOffering.getCourseOfferings().size() == 1 && !unlimitedOffering ? n : Math.round(studentWeight);
                }
                if (var13_84 != null) {
                    courseLimit = (int)Math.round((double)courseLimit * var13_84.doubleValue());
                }
                if (var16_174 == null || var16_174.isEmpty()) {
                    this.iProgress.message(this.msglevel("offeringWithoutDemand", 3), MSG.infoNoStudentInCourse(this.getOfferingLabel(courseOffering)));
                    continue;
                }
                if (courseLimit == 0 && instructionalOffering.getCourseOfferings().size() > 1) {
                    this.iProgress.message(this.msglevel("noCourseReservation", 5), MSG.warnNoReservedSpaceForCourse(this.getOfferingLabel(courseOffering)));
                }
                double weight = this.iStudentCourseDemands.isWeightStudentsToFillUpOffering() && courseLimit != 0 ? (double)courseLimit / (double)studentWeight : 1.0;
                HashSet<Lecture> cannotAttendLectures = null;
                if (instructionalOffering.getCourseOfferings().size() > 1) {
                    HashSet<Long> reservedClasses = new HashSet<Long>();
                    int limit = 0;
                    boolean unlimited = false;
                    for (Reservation reservation : instructionalOffering.getReservations()) {
                        Object parent;
                        if (!(reservation instanceof CourseReservation) || !courseOffering.equals(((CourseReservation)reservation).getCourse())) continue;
                        for (Class_ class_ : reservation.getClasses()) {
                            limit += class_.getMaxExpectedCapacity().intValue();
                            this.propagateReservedClasses(class_, reservedClasses);
                            for (parent = class_.getParentClass(); parent != null; parent = ((BaseClass_)parent).getParentClass()) {
                                reservedClasses.add(((BasePreferenceGroup)parent).getUniqueId());
                            }
                        }
                        for (InstrOfferingConfig instrOfferingConfig : reservation.getConfigurations()) {
                            if (instrOfferingConfig.isUnlimitedEnrollment().booleanValue()) {
                                unlimited = true;
                            } else {
                                limit += instrOfferingConfig.getLimit().intValue();
                            }
                            parent = instrOfferingConfig.getSchedulingSubparts().iterator();
                            while (parent.hasNext()) {
                                SchedulingSubpart subpart = (SchedulingSubpart)parent.next();
                                for (Class_ class_ : subpart.getClasses()) {
                                    reservedClasses.add(class_.getUniqueId());
                                }
                            }
                        }
                    }
                    if (!reservedClasses.isEmpty()) {
                        this.iProgress.debug("Course requests for course " + this.getOfferingLabel(courseOffering) + " are " + String.valueOf(reservedClasses));
                        if (!unlimited && courseLimit > limit) {
                            this.iProgress.message(this.msglevel("insufficientCourseReservation", 5), MSG.warnTooLittleSpaceInCourse(this.getOfferingLabel(courseOffering), limit, courseLimit));
                        }
                        cannotAttendLectures = new HashSet<Lecture>();
                        for (InstrOfferingConfig instrOfferingConfig : courseOffering.getInstructionalOffering().getInstrOfferingConfigs()) {
                            boolean hasConfigReservation = false;
                            block39: for (SchedulingSubpart subpart : instrOfferingConfig.getSchedulingSubparts()) {
                                for (Class_ class_ : subpart.getClasses()) {
                                    if (!reservedClasses.contains(class_.getUniqueId())) continue;
                                    hasConfigReservation = true;
                                    break block39;
                                }
                            }
                            for (SchedulingSubpart subpart : instrOfferingConfig.getSchedulingSubparts()) {
                                boolean hasSubpartReservation = false;
                                for (Class_ class_ : subpart.getClasses()) {
                                    if (!reservedClasses.contains(class_.getUniqueId())) continue;
                                    hasSubpartReservation = true;
                                    break;
                                }
                                if (hasConfigReservation && !hasSubpartReservation) continue;
                                for (Class_ class_ : subpart.getClasses()) {
                                    Lecture lecture;
                                    if (reservedClasses.contains(class_.getUniqueId()) || (lecture = this.iLectures.get(class_.getUniqueId())) == null || !this.iLoadCommittedReservations && lecture.isCommitted()) continue;
                                    cannotAttendLectures.add(lecture);
                                }
                            }
                        }
                        if (!cannotAttendLectures.isEmpty()) {
                            this.iProgress.debug("Prohibited lectures for course " + this.getOfferingLabel(courseOffering) + " are " + String.valueOf(cannotAttendLectures));
                            this.checkReservation(courseOffering, cannotAttendLectures, this.iAltConfigurations.get(instructionalOffering));
                        }
                    }
                }
                ArrayList<StudentSchedulingRule> rules = new ArrayList<StudentSchedulingRule>();
                for (StudentSchedulingRule rule : hibSession.createQuery("from StudentSchedulingRule order by ord", StudentSchedulingRule.class).list()) {
                    if (!rule.isAppliesToBatch().booleanValue() || !rule.matchSession(this.iSession)) continue;
                    rules.add(rule);
                }
                for (StudentCourseDemands.WeightedStudentId studentId : var16_174) {
                    Lecture lecture;
                    StudentSchedulingRule studentSchedulingRule;
                    void var26_249;
                    org.cpsolver.coursett.model.Student student = this.iStudents.get(studentId.getStudentId());
                    if (student == null) {
                        student = new org.cpsolver.coursett.model.Student(Long.valueOf(studentId.getStudentId()));
                        student.setAcademicArea(studentId.getArea());
                        student.setAcademicClassification(studentId.getClasf());
                        student.setMajor(studentId.getMajor());
                        student.setCurriculum(studentId.getCurriculum());
                        ((TimetableModel)this.getModel()).addStudent(student);
                        this.iStudents.put(studentId.getStudentId(), student);
                        this.iWeightedStudents.put(studentId.getStudentId(), studentId);
                        for (StudentCourseDemands.Group g : studentId.getGroups()) {
                            void var28_261;
                            if (!g.isKeepTogether()) continue;
                            StudentGroup studentGroup = this.iGroups.get(g.getId());
                            if (studentGroup == null) {
                                StudentGroup studentGroup2 = new StudentGroup(g.getId().longValue(), g.getWeight(), g.getName());
                                this.iGroups.put(g.getId(), studentGroup2);
                                ((TimetableModel)this.getModel()).addStudentGroup(studentGroup2);
                            }
                            var28_261.addStudent(student);
                            student.addGroup((StudentGroup)var28_261);
                        }
                        for (StudentSchedulingRule rule2 : rules) {
                            if ((studentId.getStudent() == null || !rule2.getStudentQuery().match(new DbFindEnrollmentInfoAction.DbStudentMatcher(studentId.getStudent()))) && (studentId.getStudent() != null || !rule2.getStudentQuery().match(new StudentSectioningDatabaseLoader.ProjectedStudentMatcher(studentId)))) continue;
                            this.iStudentRules.put(student, rule2);
                            break;
                        }
                        if (this.iOnlineOnlyStudentQuery != null && (studentId.getStudent() != null && this.iOnlineOnlyStudentQuery.match(new DbFindEnrollmentInfoAction.DbStudentMatcher(studentId.getStudent())) || studentId.getStudent() == null && this.iOnlineOnlyStudentQuery.match(new StudentSectioningDatabaseLoader.ProjectedStudentMatcher(studentId)))) {
                            this.iOnlineOnlyStudents.add(student);
                            if (student.getCurriculum() != null && this.iOnlineOnlyStudentSuffix != null && !this.iOnlineOnlyStudentSuffix.isEmpty()) {
                                student.setCurriculum(student.getCurriculum() + " " + this.iOnlineOnlyStudentSuffix);
                            }
                        }
                    }
                    if (studentId.getPrimaryOfferingId() != null && !studentId.getPrimaryOfferingId().equals(instructionalOffering.getUniqueId())) {
                        student.addAlternatives(studentId.getPrimaryOfferingId(), instructionalOffering.getUniqueId());
                    }
                    student.addOffering(instructionalOffering.getUniqueId(), weight * (double)studentId.getWeight(), this.iStudentCourseDemands.getEnrollmentPriority(studentId.getStudentId(), courseOffering.getUniqueId()));
                    Set<org.cpsolver.coursett.model.Student> set3 = this.iCourse2students.get(courseOffering);
                    if (set3 == null) {
                        HashSet hashSet = new HashSet();
                        this.iCourse2students.put(courseOffering, hashSet);
                    }
                    var26_249.add(student);
                    student.addCanNotEnroll(instructionalOffering.getUniqueId(), cannotAttendLectures);
                    HashSet<Long> reservedClasses = new HashSet<Long>();
                    for (Reservation reservation : instructionalOffering.getReservations()) {
                        if (reservation.getClasses().isEmpty() && reservation.getConfigurations().isEmpty() || reservation instanceof CourseReservation) continue;
                        if (reservation instanceof CurriculumReservation) {
                            boolean bl;
                            boolean bl2;
                            CurriculumReservation cr = (CurriculumReservation)reservation;
                            boolean bl3 = false;
                            for (StudentCourseDemands.AreaClasfMajor acm : studentId.getMajors()) {
                                if (!cr.hasArea(acm.getArea()) || !cr.hasClassification(acm.getClasf()) || !cr.hasMajor(acm.getMajor()) || !cr.hasConcentration(acm.getMajor(), acm.getConcentration())) continue;
                                bl2 = true;
                                break;
                            }
                            if (!bl2 && !studentId.getMinors().isEmpty()) {
                                for (StudentCourseDemands.AreaClasfMajor acm : studentId.getMinors()) {
                                    if (!cr.hasArea(acm.getArea()) || !cr.hasClassification(acm.getClasf()) || !cr.hasMinor(acm.getMajor())) continue;
                                    bl = true;
                                    break;
                                }
                            }
                            if (!bl) {
                                continue;
                            }
                        } else if (reservation instanceof StudentGroupReservation) {
                            StudentCourseDemands.Group group;
                            StudentGroupReservation gr = (StudentGroupReservation)reservation;
                            if (gr.getGroup() == null || (group = studentId.getGroup(gr.getGroup().getGroupAbbreviation())) == null || group.getId() < 0L) {
                                continue;
                            }
                        } else {
                            boolean bl;
                            if (!(reservation instanceof IndividualReservation)) continue;
                            Iterator<InstrOfferingConfig> ir = (IndividualReservation)reservation;
                            boolean bl4 = false;
                            for (Student s : ((BaseIndividualReservation)((Object)ir)).getStudents()) {
                                if (studentId.getStudentId() != s.getUniqueId().longValue()) continue;
                                bl = true;
                            }
                            if (!bl) continue;
                        }
                        for (Class_ class_ : reservation.getClasses()) {
                            void var32_298;
                            this.propagateReservedClasses(class_, reservedClasses);
                            Class_ class_2 = class_.getParentClass();
                            while (var32_298 != null) {
                                reservedClasses.add(var32_298.getUniqueId());
                                Class_ class_3 = var32_298.getParentClass();
                            }
                        }
                        for (InstrOfferingConfig instrOfferingConfig : reservation.getConfigurations()) {
                            for (SchedulingSubpart subpart : instrOfferingConfig.getSchedulingSubparts()) {
                                for (Class_ class_ : subpart.getClasses()) {
                                    reservedClasses.add(class_.getUniqueId());
                                }
                            }
                        }
                    }
                    if (!reservedClasses.isEmpty()) {
                        this.iProgress.debug(courseOffering.getCourseName() + ": Student " + student.getId() + " has reserved classes " + String.valueOf(reservedClasses));
                        HashSet<Lecture> hashSet = new HashSet<Lecture>();
                        for (InstrOfferingConfig config : courseOffering.getInstructionalOffering().getInstrOfferingConfigs()) {
                            boolean bl = false;
                            block58: for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                                for (Class_ class_ : subpart.getClasses()) {
                                    if (!reservedClasses.contains(class_.getUniqueId())) continue;
                                    bl = true;
                                    break block58;
                                }
                            }
                            for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                                boolean hasSubpartReservation = false;
                                for (Class_ clazz7 : subpart.getClasses()) {
                                    if (!reservedClasses.contains(clazz7.getUniqueId())) continue;
                                    hasSubpartReservation = true;
                                    break;
                                }
                                if (bl && !hasSubpartReservation) continue;
                                for (Class_ clazz : subpart.getClasses()) {
                                    Lecture lecture3;
                                    if (reservedClasses.contains(clazz.getUniqueId()) || (lecture3 = this.iLectures.get(clazz.getUniqueId())) == null || !this.iLoadCommittedReservations && lecture3.isCommitted()) continue;
                                    hashSet.add(lecture3);
                                }
                            }
                        }
                        this.iProgress.debug(courseOffering.getCourseName() + ": Student " + student.getId() + " cannot attend classes " + String.valueOf(hashSet));
                        student.addCanNotEnroll(instructionalOffering.getUniqueId(), hashSet);
                    }
                    if ((studentSchedulingRule = this.iStudentRules.get(student)) != null) {
                        if (studentSchedulingRule.getInstructonalMethod() == null) continue;
                        for (InstrOfferingConfig config : instructionalOffering.getInstrOfferingConfigs()) {
                            InstructionalMethod instructionalMethod = config.getEffectiveInstructionalMethod();
                            if (studentSchedulingRule.matchesInstructionalMethod(instructionalMethod)) continue;
                            this.iProgress.debug(courseOffering.getCourseName() + ": " + studentSchedulingRule.getRuleName() + " student " + student.getId() + " cannot attend config " + config.getName() + (String)(instructionalMethod == null ? "" : " (" + instructionalMethod.getReference() + ")"));
                            for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                                for (Class_ class_ : subpart.getClasses()) {
                                    lecture = this.iLectures.get(class_.getUniqueId());
                                    if (lecture == null || !this.iLoadCommittedReservations && lecture.isCommitted()) continue;
                                    student.addCanNotEnroll(lecture);
                                }
                            }
                        }
                        continue;
                    }
                    if (this.iOnlineOnlyInstructionalModeRegExp == null) continue;
                    if (this.iOnlineOnlyStudents.contains(student)) {
                        if (this.iOnlineOnlyInstructionalModeRegExp == null) continue;
                        for (InstrOfferingConfig config : instructionalOffering.getInstrOfferingConfigs()) {
                            InstructionalMethod instructionalMethod = config.getEffectiveInstructionalMethod();
                            if (this.iOnlineOnlyInstructionalModeRegExp.isEmpty()) {
                                if (instructionalMethod == null || instructionalMethod.getReference() == null || instructionalMethod.getReference().isEmpty()) continue;
                                this.iProgress.debug(courseOffering.getCourseName() + ": Online-only student " + student.getId() + " cannot attend config " + config.getName() + " (" + instructionalMethod.getReference() + ")");
                                for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                                    for (Class_ class_ : subpart.getClasses()) {
                                        lecture = this.iLectures.get(class_.getUniqueId());
                                        if (lecture == null || !this.iLoadCommittedReservations && lecture.isCommitted()) continue;
                                        student.addCanNotEnroll(lecture);
                                    }
                                }
                                continue;
                            }
                            if (instructionalMethod != null && instructionalMethod.getReference() != null && instructionalMethod.getReference().matches(this.iOnlineOnlyInstructionalModeRegExp)) continue;
                            this.iProgress.debug(courseOffering.getCourseName() + ": Online-only student " + student.getId() + " cannot attend config " + config.getName() + (String)(instructionalMethod == null ? "" : " (" + instructionalMethod.getReference() + ")"));
                            for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                                for (Class_ class_ : subpart.getClasses()) {
                                    lecture = this.iLectures.get(class_.getUniqueId());
                                    if (lecture == null || !this.iLoadCommittedReservations && lecture.isCommitted()) continue;
                                    student.addCanNotEnroll(lecture);
                                }
                            }
                        }
                        continue;
                    }
                    if (this.iResidentialInstructionalModeRegExp == null) continue;
                    for (InstrOfferingConfig config : instructionalOffering.getInstrOfferingConfigs()) {
                        InstructionalMethod instructionalMethod = config.getEffectiveInstructionalMethod();
                        if (this.iResidentialInstructionalModeRegExp.isEmpty()) {
                            if (instructionalMethod == null || instructionalMethod.getReference() == null || instructionalMethod.getReference().isEmpty()) continue;
                            this.iProgress.debug(courseOffering.getCourseName() + ": Residential student " + student.getId() + " cannot attend config " + config.getName() + " (" + instructionalMethod.getReference() + ")");
                            for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                                for (Class_ class_ : subpart.getClasses()) {
                                    lecture = this.iLectures.get(class_.getUniqueId());
                                    if (lecture == null || !this.iLoadCommittedReservations && lecture.isCommitted()) continue;
                                    student.addCanNotEnroll(lecture);
                                }
                            }
                            continue;
                        }
                        if (instructionalMethod != null && instructionalMethod.getReference() != null && instructionalMethod.getReference().matches(this.iResidentialInstructionalModeRegExp)) continue;
                        this.iProgress.debug(courseOffering.getCourseName() + ": Residential student " + student.getId() + " cannot attend config " + config.getName() + (String)(instructionalMethod == null ? "" : " (" + instructionalMethod.getReference() + ")"));
                        for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                            for (Class_ class_ : subpart.getClasses()) {
                                lecture = this.iLectures.get(class_.getUniqueId());
                                if (lecture == null || !this.iLoadCommittedReservations && lecture.isCommitted()) continue;
                                student.addCanNotEnroll(lecture);
                            }
                        }
                    }
                }
            }
            this.incProgress();
        }
        this.iProgress.debug(this.iStudents.size() + " students loaded.");
        if (!hibSession.isOpen()) {
            this.iProgress.message(this.msglevel("hibernateFailure", 7), MSG.fatalHibernateSessionClosed());
        }
        if (this.iCommittedStudentConflictsMode == CommittedStudentConflictsMode.Load && !this.iStudentCourseDemands.isMakingUpStudents()) {
            this.loadCommittedStudentConflicts(hibSession, loadedOfferings);
        } else if (this.iCommittedStudentConflictsMode != CommittedStudentConflictsMode.Ignore) {
            this.makeupCommittedStudentConflicts(loadedOfferings);
        }
        if (!hibSession.isOpen()) {
            this.iProgress.message(this.msglevel("hibernateFailure", 7), MSG.fatalHibernateSessionClosed());
        }
        Hashtable<org.cpsolver.coursett.model.Student, HashSet<Lecture>> iPreEnrollments = new Hashtable<org.cpsolver.coursett.model.Student, HashSet<Lecture>>();
        if (this.iLoadStudentEnrlsFromSolution) {
            if (this.iStudentCourseDemands.canUseStudentClassEnrollmentsAsSolution()) {
                List list = hibSession.createQuery("select distinct e.student.uniqueId, e.clazz.uniqueId from StudentClassEnrollment e, Class_ c where e.courseOffering.instructionalOffering = c.schedulingSubpart.instrOfferingConfig.instructionalOffering and c.managingDept.solverGroup.uniqueId in (" + this.iSolverGroupIds + ")", Object[].class).list();
                this.setPhase(MSG.phaseLoadingStudentEnrollemnts(), list.size());
                int totalEnrollments = 0;
                for (Object[] objectArray : list) {
                    Long studentId = (Long)objectArray[0];
                    Long l = (Long)objectArray[1];
                    org.cpsolver.coursett.model.Student student = this.iStudents.get(studentId);
                    if (student == null) continue;
                    Lecture lecture = this.iLectures.get(l);
                    if (lecture != null && lecture.getConfiguration() != null) {
                        HashSet<Lecture> preEnrollments = (HashSet<Lecture>)iPreEnrollments.get(student);
                        if (preEnrollments == null) {
                            preEnrollments = new HashSet<Lecture>();
                            iPreEnrollments.put(student, preEnrollments);
                        }
                        preEnrollments.add(lecture);
                        if (student.hasOffering(lecture.getConfiguration().getOfferingId()) && student.canEnroll(lecture)) {
                            student.addLecture(lecture);
                            lecture.addStudent(this.getAssignment(), student);
                            ++totalEnrollments;
                        }
                    }
                    this.incProgress();
                }
                this.iProgress.message(this.msglevel("enrollmentsLoaded", 3), MSG.infoEnrollmentsLoaded(totalEnrollments, iPreEnrollments.size()));
            } else {
                void var10_46;
                boolean bl = false;
                while (var10_46 < this.iSolverGroupId.length) {
                    void var12_67;
                    org.unitime.timetable.model.Solution solution = solutions == null ? null : (org.unitime.timetable.model.Solution)solutions.get(this.iSolverGroupId[var10_46]);
                    Object var12_64 = null;
                    if (solution != null) {
                        List list = hibSession.createQuery("select distinct e.studentId, e.clazz.uniqueId from StudentEnrollment e where e.solution.uniqueId=:solutionId", Object[].class).setParameter("solutionId", (Object)solution.getUniqueId()).list();
                    } else {
                        List list = hibSession.createQuery("select distinct e.studentId, e.clazz.uniqueId from StudentEnrollment e where e.solution.owner.uniqueId=:sovlerGroupId and e.solution.commited = true", Object[].class).setParameter("sovlerGroupId", (Object)this.iSolverGroupId[var10_46]).list();
                    }
                    this.setPhase(MSG.phaseLoadingStudentEnrollemntsPhase((int)(var10_46 + true)), var12_67.size());
                    for (Object[] o : var12_67) {
                        Long l = (Long)o[0];
                        Long l2 = (Long)o[1];
                        org.cpsolver.coursett.model.Student student = this.iStudents.get(l);
                        if (student == null) continue;
                        Lecture lecture = this.iLectures.get(l2);
                        if (lecture != null && lecture.getConfiguration() != null) {
                            HashSet<Lecture> preEnrollments = (HashSet<Lecture>)iPreEnrollments.get(student);
                            if (preEnrollments == null) {
                                preEnrollments = new HashSet<Lecture>();
                                iPreEnrollments.put(student, preEnrollments);
                            }
                            preEnrollments.add(lecture);
                            if (student.hasOffering(lecture.getConfiguration().getOfferingId()) && student.canEnroll(lecture)) {
                                student.addLecture(lecture);
                                lecture.addStudent(this.getAssignment(), student);
                            }
                        }
                        this.incProgress();
                    }
                    ++var10_46;
                }
                if (((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("Global.LoadOtherCommittedStudentEnrls", true)) {
                    List list = hibSession.createQuery("select distinct e.studentId, e.clazz.uniqueId from StudentEnrollment e, Class_ c where e.solution.commited = true and e.solution.owner.uniqueId not in (" + this.iSolverGroupIds + ") and e.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering = c.schedulingSubpart.instrOfferingConfig.instructionalOffering and c.managingDept.solverGroup.uniqueId in (" + this.iSolverGroupIds + ")", Object[].class).list();
                    this.setPhase(MSG.phaseLoadingOtherStudentEnrollments(), list.size());
                    for (Object[] objectArray : list) {
                        Long l = (Long)objectArray[0];
                        Long clazzId = (Long)objectArray[1];
                        org.cpsolver.coursett.model.Student student = this.iStudents.get(l);
                        if (student == null) continue;
                        Lecture lecture = this.iLectures.get(clazzId);
                        if (lecture != null && lecture.getConfiguration() != null) {
                            HashSet<Lecture> preEnrollments = (HashSet<Lecture>)iPreEnrollments.get(student);
                            if (preEnrollments == null) {
                                preEnrollments = new HashSet<Lecture>();
                                iPreEnrollments.put(student, preEnrollments);
                            }
                            preEnrollments.add(lecture);
                            if (student.hasOffering(lecture.getConfiguration().getOfferingId()) && student.canEnroll(lecture)) {
                                student.addLecture(lecture);
                                lecture.addStudent(this.getAssignment(), student);
                            }
                        }
                        this.incProgress();
                    }
                }
            }
        }
        if (!hibSession.isOpen()) {
            this.iProgress.message(this.msglevel("hibernateFailure", 7), MSG.fatalHibernateSessionClosed());
        }
        Object var10_48 = null;
        if (SolverServerImplementation.getInstance() != null) {
            RoomAvailabilityInterface roomAvailabilityInterface = SolverServerImplementation.getInstance().getRoomAvailability();
        } else {
            RoomAvailabilityInterface roomAvailabilityInterface = RoomAvailability.getInstance();
        }
        if (var10_51 != null && (startEnd = this.initializeRoomAvailability((RoomAvailabilityInterface)var10_51)) != null) {
            this.loadRoomAvailability((RoomAvailabilityInterface)var10_51, startEnd);
            this.loadInstructorAvailability((RoomAvailabilityInterface)var10_51, startEnd);
        }
        if (!hibSession.isOpen()) {
            this.iProgress.message(this.msglevel("hibernateFailure", 7), MSG.fatalHibernateSessionClosed());
        }
        this.setPhase(MSG.phaseInitialSectioning(), this.iOfferings.size());
        for (InstructionalOffering instructionalOffering : this.iOfferings.keySet()) {
            HashSet<org.cpsolver.coursett.model.Student> hashSet = new HashSet<org.cpsolver.coursett.model.Student>();
            for (CourseOffering courseOffering : instructionalOffering.getCourseOfferings()) {
                Set<org.cpsolver.coursett.model.Student> set = this.iCourse2students.get(courseOffering);
                if (set == null) continue;
                hashSet.addAll(set);
            }
            if (hashSet.isEmpty()) continue;
            ((TimetableModel)this.getModel()).getStudentSectioning().initialSectioning(this.getAssignment(), instructionalOffering.getUniqueId(), instructionalOffering.getCourseName(), hashSet, (Collection)this.iAltConfigurations.get(instructionalOffering));
            this.incProgress();
        }
        Enumeration<org.cpsolver.coursett.model.Student> e = this.iStudents.elements();
        while (e.hasMoreElements()) {
            e.nextElement().clearDistanceCache();
        }
        if (!iPreEnrollments.isEmpty()) {
            this.setPhase(MSG.phaseCheckingLoadedEnrollments(), iPreEnrollments.size());
            for (Map.Entry entry : iPreEnrollments.entrySet()) {
                this.incProgress();
                org.cpsolver.coursett.model.Student student = (org.cpsolver.coursett.model.Student)entry.getKey();
                Set lectures = (Set)entry.getValue();
                for (Lecture lecture : lectures) {
                    if (lecture.students().contains(student)) continue;
                    this.iProgress.message(this.msglevel("studentNotEnrolled", 5), MSG.warnStudentShouldBeInClass(student.getId(), this.getClassLabel(lecture)));
                }
                for (Lecture lecture : student.getLectures()) {
                    if (lectures.contains(lecture)) continue;
                    Lecture instead = null;
                    if (lecture.sameStudentsLectures() != null) {
                        for (Lecture other : lecture.sameStudentsLectures()) {
                            if (!lectures.contains(other)) continue;
                            instead = other;
                        }
                    }
                    if (instead != null) {
                        this.iProgress.message(this.msglevel("studentEnrolled", 5), MSG.warnStudentShouldNotBeInClassShouldBeInOther(student.getId(), this.getClassLabel(lecture), this.getClassLabel(instead)));
                        continue;
                    }
                    this.iProgress.message(this.msglevel("studentEnrolled", 3), MSG.warnStudentShouldNotBeInClass(student.getId(), this.getClassLabel(lecture)));
                }
            }
        }
        if (!hibSession.isOpen()) {
            this.iProgress.message(this.msglevel("hibernateFailure", 7), MSG.fatalHibernateSessionClosed());
        }
        if (this.iLoadStudentInstructorConflicts) {
            this.loadInstructorStudentConflicts(hibSession);
        }
        this.setPhase(MSG.phaseComputingJenrl(), this.iStudents.size());
        Hashtable jenrls = new Hashtable();
        for (org.cpsolver.coursett.model.Student student : this.iStudents.values()) {
            for (Lecture lecture : student.getLectures()) {
                for (Lecture l2 : student.getLectures()) {
                    JenrlConstraint jenrl;
                    if (lecture.getId() >= l2.getId()) continue;
                    Hashtable<Lecture, JenrlConstraint> x = (Hashtable<Lecture, JenrlConstraint>)jenrls.get(lecture);
                    if (x == null) {
                        x = new Hashtable<Lecture, JenrlConstraint>();
                        jenrls.put(lecture, x);
                    }
                    if ((jenrl = (JenrlConstraint)x.get(l2)) == null) {
                        jenrl = new JenrlConstraint();
                        ((TimetableModel)this.getModel()).addConstraint((Constraint)jenrl);
                        jenrl.addVariable((Variable)lecture);
                        jenrl.addVariable((Variable)l2);
                        x.put(l2, jenrl);
                    }
                    jenrl.incJenrl(this.getAssignment(), student);
                }
            }
            this.incProgress();
        }
        if (!hibSession.isOpen()) {
            this.iProgress.message(this.msglevel("hibernateFailure", 7), MSG.fatalHibernateSessionClosed());
        }
        if (!((TimetableModel)this.getModel()).getStudentSectioning().hasFinalSectioning()) {
            this.postAutomaticStudentConstraints(hibSession);
        }
        if (solutions != null) {
            void var12_73;
            boolean bl = false;
            while (var12_73 < this.iSolverGroupId.length) {
                org.unitime.timetable.model.Solution solution = (org.unitime.timetable.model.Solution)solutions.get(this.iSolverGroupId[var12_73]);
                if (solution != null) {
                    this.setPhase(MSG.phaseCreatingInitialAssignmentPhase((int)(var12_73 + true)), solution.getAssignments().size());
                    for (org.unitime.timetable.model.Assignment assignment : solution.getAssignments()) {
                        this.loadAssignment(assignment);
                        this.incProgress();
                    }
                }
                ++var12_73;
            }
        } else if (this.iLoadCommittedAssignments) {
            this.setPhase(MSG.phaseCreatingCommittedAssignment(), ((TimetableModel)this.getModel()).variables().size());
            for (Lecture lecture : ((TimetableModel)this.getModel()).variables()) {
                if (lecture.isCommitted()) continue;
                Class_ clazz = this.iClasses.get(lecture.getClassId());
                if (clazz != null && clazz.getCommittedAssignment() != null) {
                    this.loadAssignment(clazz.getCommittedAssignment());
                }
                this.incProgress();
            }
        }
        if (!hibSession.isOpen()) {
            this.iProgress.message(this.msglevel("hibernateFailure", 7), MSG.fatalHibernateSessionClosed());
        }
        if (this.iSpread) {
            this.setPhase(MSG.phasePostingAutoSpreads(), subparts.size());
            for (SchedulingSubpart schedulingSubpart : subparts) {
                if (schedulingSubpart.getClasses().size() <= 1) {
                    this.incProgress();
                    continue;
                }
                if (!schedulingSubpart.isAutoSpreadInTime().booleanValue()) {
                    this.iProgress.debug("Automatic spread constraint disabled for " + this.getSubpartLabel(schedulingSubpart));
                    this.incProgress();
                    continue;
                }
                SpreadConstraint spread = new SpreadConstraint(((TimetableModel)this.getModel()).getProperties(), schedulingSubpart.getCourseName() + " " + schedulingSubpart.getItypeDesc().trim());
                for (Class_ class_ : schedulingSubpart.getClasses()) {
                    Lecture lecture = this.getLecture(class_);
                    if (lecture == null) continue;
                    spread.addVariable(lecture);
                }
                if (spread.variables().isEmpty()) {
                    this.iProgress.message(this.msglevel("courseWithNoClasses", 5), MSG.warnCourseWithNoClasses(this.getSubpartLabel(schedulingSubpart)));
                } else {
                    ((TimetableModel)this.getModel()).addConstraint((Constraint)spread);
                }
                this.incProgress();
            }
        }
        if (this.iDeptBalancing) {
            this.setPhase(MSG.phasePostingDeptSpreads(), ((TimetableModel)this.getModel()).variables().size());
            Hashtable<Long, DepartmentSpreadConstraint> hashtable = new Hashtable<Long, DepartmentSpreadConstraint>();
            for (Lecture lecture : ((TimetableModel)this.getModel()).variables()) {
                void var15_152;
                if (lecture.getDepartment() == null) continue;
                DepartmentSpreadConstraint departmentSpreadConstraint = (DepartmentSpreadConstraint)hashtable.get(lecture.getDepartment());
                if (departmentSpreadConstraint == null) {
                    DepartmentSpreadConstraint departmentSpreadConstraint2 = new DepartmentSpreadConstraint(((TimetableModel)this.getModel()).getProperties(), lecture.getDepartment(), this.iDeptNames.get(lecture.getDepartment()));
                    hashtable.put(lecture.getDepartment(), departmentSpreadConstraint2);
                    ((TimetableModel)this.getModel()).addConstraint((Constraint)departmentSpreadConstraint2);
                }
                var15_152.addVariable(lecture);
                this.incProgress();
            }
        }
        if (this.iSubjectBalancing) {
            this.setPhase(MSG.phasePostingSubjectSpreads(), ((TimetableModel)this.getModel()).variables().size());
            Hashtable<Long, SpreadConstraint> hashtable = new Hashtable<Long, SpreadConstraint>();
            for (Lecture lecture : ((TimetableModel)this.getModel()).variables()) {
                Class_ class_ = this.iClasses.get(lecture.getClassId());
                if (class_ == null) continue;
                for (CourseOffering co : class_.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getCourseOfferings()) {
                    Long subject = co.getSubjectArea().getUniqueId();
                    SpreadConstraint subjectSpreadConstr = (SpreadConstraint)hashtable.get(subject);
                    if (subjectSpreadConstr == null) {
                        subjectSpreadConstr = new SpreadConstraint(((TimetableModel)this.getModel()).getProperties(), co.getSubjectArea().getSubjectAreaAbbreviation());
                        hashtable.put(subject, subjectSpreadConstr);
                        ((TimetableModel)this.getModel()).addConstraint((Constraint)subjectSpreadConstr);
                    }
                    subjectSpreadConstr.addVariable(lecture);
                }
                this.incProgress();
            }
        }
        if (((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.PurgeInvalidPlacements", true)) {
            this.purgeInvalidValues();
        }
        this.setPhase(MSG.phaseCheckingForInconsistencies(), ((TimetableModel)this.getModel()).variables().size());
        for (Lecture lecture : ((TimetableModel)this.getModel()).variables()) {
            Placement p2;
            this.incProgress();
            for (org.cpsolver.coursett.model.Student student : lecture.students()) {
                if (student.canEnroll(lecture)) continue;
                this.iProgress.message(this.msglevel("badStudentEnrollment", 3), MSG.warnBadStudentEnrollment(student.getId(), this.getClassLabel(lecture)));
            }
            if (!lecture.values(this.getAssignment()).isEmpty() && lecture.timeLocations().size() == 1 && !lecture.getInstructorConstraints().isEmpty()) {
                block100: for (Lecture lecture2 : ((TimetableModel)this.getModel()).variables()) {
                    if (lecture2.values(this.getAssignment()).isEmpty() || lecture2.timeLocations().size() != 1 || lecture.getClassId().compareTo(lecture2.getClassId()) <= 0) continue;
                    Placement placement = (Placement)lecture.values(this.getAssignment()).get(0);
                    p2 = (Placement)lecture2.values(this.getAssignment()).get(0);
                    if (lecture2.getInstructorConstraints().isEmpty()) continue;
                    for (InstructorConstraint ic : lecture.getInstructorConstraints()) {
                        if (!lecture2.getInstructorConstraints().contains(ic)) continue;
                        if (placement.canShareRooms(p2)) {
                            if (lecture.getNrRooms() == 0 || lecture2.getNrRooms() == 0 || placement.sameRooms(p2)) continue;
                            for (RoomLocation r1 : lecture.roomLocations()) {
                                if (!lecture2.roomLocations().contains(r1)) continue;
                                continue block100;
                            }
                        }
                        if (placement.getTimeLocation().hasIntersection(p2.getTimeLocation())) {
                            this.iProgress.message(this.msglevel("reqInstructorOverlap", 5), MSG.warnSameInstructorTimeConflict(this.getClassLabel(lecture), placement.getLongName(this.iUseAmPm), this.getClassLabel(lecture2), p2.getLongName(this.iUseAmPm)));
                            continue;
                        }
                        if (ic.getDistancePreference(placement, p2) != PreferenceLevel.sIntLevelProhibited || lecture.roomLocations().size() != 1 || lecture2.roomLocations().size() != 1) continue;
                        this.iProgress.message(this.msglevel("reqInstructorBackToBack", 5), MSG.warnSameInstructorBackToBack(Math.round(Placement.getDistanceInMeters((DistanceMetric)((TimetableModel)this.getModel()).getDistanceMetric(), (Placement)placement, (Placement)p2)), this.getClassLabel(lecture), placement.getLongName(this.iUseAmPm), this.getClassLabel(lecture2), p2.getLongName(this.iUseAmPm)));
                    }
                }
            }
            if (!lecture.isSingleton()) continue;
            for (Lecture lecture3 : ((TimetableModel)this.getModel()).variables()) {
                Placement placement;
                if (!lecture3.isSingleton() || lecture.getClassId().compareTo(lecture3.getClassId()) <= 0 || !(placement = new Placement(lecture, (TimeLocation)lecture.timeLocations().get(0), lecture.roomLocations())).shareRooms(p2 = new Placement(lecture3, (TimeLocation)lecture3.timeLocations().get(0), lecture3.roomLocations())) || !placement.getTimeLocation().hasIntersection(p2.getTimeLocation()) || placement.canShareRooms(p2)) continue;
                this.iProgress.message(this.msglevel("reqRoomOverlap", 5), MSG.warnSameRoomTimeConflict(this.getClassLabel(lecture), placement.getLongName(this.iUseAmPm), this.getClassLabel(lecture3), p2.getLongName(this.iUseAmPm)));
            }
            if (this.getAssignment().getValue((Variable)lecture) != null) continue;
            Placement placement = new Placement(lecture, (TimeLocation)lecture.timeLocations().get(0), lecture.roomLocations());
            if (!placement.isValid()) {
                void var15_166;
                Map map;
                void var15_160;
                String string = "";
                for (InstructorConstraint ic : lecture.getInstructorConstraints()) {
                    if (ic.isAvailable(lecture, placement)) continue;
                    String string2 = (String)var15_160 + MSG.warnReasonInstructorNotAvailable(ic.getName());
                }
                if (lecture.getNrRooms() > 0) {
                    if (placement.isMultiRoom()) {
                        for (RoomLocation roomLocation : placement.getRoomLocations()) {
                            void var15_162;
                            if (roomLocation.getRoomConstraint().isAvailable(lecture, placement.getTimeLocation(), lecture.getScheduler())) continue;
                            String string3 = (String)var15_162 + MSG.warnReasonRoomNotAvailable(roomLocation.getName());
                        }
                    } else if (!placement.getRoomLocation().getRoomConstraint().isAvailable(lecture, placement.getTimeLocation(), lecture.getScheduler())) {
                        String string4 = (String)var15_160 + MSG.warnReasonRoomNotAvailable(placement.getRoomLocation().getName());
                    }
                }
                if (!(map = ((TimetableModel)this.getModel()).conflictConstraints(this.getAssignment(), (Value)placement)).isEmpty()) {
                    for (Constraint c : map.keySet()) {
                        Set vals = (Set)map.get(c);
                        for (Placement p : vals) {
                            Lecture l = (Lecture)p.variable();
                            if (l.isCommitted()) {
                                String string5 = (String)var15_166 + MSG.warnReasonConstraintCommitedAssignment(this.getClassLabel(l), p.getLongName(this.iUseAmPm), TimetableSolver.getConstraintName((Constraint<Lecture, Placement>)c));
                            }
                            if (!p.equals((Object)placement)) continue;
                            String string6 = (String)var15_166 + MSG.warnReasonConstraint(TimetableSolver.getConstraintName((Constraint<Lecture, Placement>)c));
                        }
                    }
                }
                this.iProgress.message(this.msglevel("reqInvalidPlacement", 5), var15_166.isEmpty() ? MSG.warnRequiresInvalidPlacement(this.getClassLabel(lecture), placement.getLongName(this.iUseAmPm)) : MSG.warnRequiresInvalidPlacementWithReason(this.getClassLabel(lecture), placement.getLongName(this.iUseAmPm), (String)var15_166));
                continue;
            }
            if (!this.iAssignSingleton || !((TimetableModel)this.getModel()).conflictValues(this.getAssignment(), (Value)placement).isEmpty()) continue;
            this.getAssignment().assign(0L, (Value)placement);
        }
        ((TimetableModel)this.getModel()).createAssignmentContexts(this.getAssignment(), true);
        if (((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.EnrollmentCheck", true)) {
            new EnrollmentCheck((TimetableModel)this.getModel(), (Assignment<Lecture, Placement>)this.getAssignment(), this.msglevel("enrollmentCheck", 5)).checkStudentEnrollments(this.iProgress);
        }
        if (((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.SwitchStudents", true) && this.getAssignment().nrAssignedVariables() != 0 && !this.iLoadStudentEnrlsFromSolution) {
            ((TimetableModel)this.getModel()).switchStudents(this.getAssignment(), this.getTerminationCondition());
        }
        this.setPhase(MSG.phaseDone(), 1L);
        this.incProgress();
        this.iProgress.message(this.msglevel("allDone", 3), MSG.infoModelLoaded());
    }

    public void roomAvailabilityActivate(RoomAvailabilityInterface availability, Date startTime, Date endTime) {
        try {
            availability.activate(this.iSessionId, startTime, endTime, RoomAvailabilityInterface.sClassType, ApplicationProperty.RoomAvailabilitySolverWaitForSync.isTrue());
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            this.iProgress.message(this.msglevel("roomAvailabilityFailure", 5), MSG.warnRoomAvailableServiceFailed(e.getMessage()));
        }
    }

    public Date[] initializeRoomAvailability(RoomAvailabilityInterface availability) {
        Date startDate = null;
        Date endDate = null;
        for (DatePattern dp : this.iAllUsedDatePatterns) {
            if (startDate == null || startDate.compareTo(dp.getStartDate()) > 0) {
                startDate = dp.getStartDate();
            }
            if (endDate != null && endDate.compareTo(dp.getEndDate()) >= 0) continue;
            endDate = dp.getEndDate();
        }
        if (startDate == null || endDate == null) {
            this.iProgress.message(this.msglevel("roomAvailabilityFailure", 5), MSG.warnRoomAvailableServiceNoDates());
            return null;
        }
        Calendar startDateCal = Calendar.getInstance(Locale.US);
        startDateCal.setTime(startDate);
        startDateCal.set(11, 0);
        startDateCal.set(12, 0);
        startDateCal.set(13, 0);
        Calendar endDateCal = Calendar.getInstance(Locale.US);
        endDateCal.setTime(endDate);
        endDateCal.set(11, 23);
        endDateCal.set(12, 59);
        endDateCal.set(13, 59);
        this.roomAvailabilityActivate(availability, startDateCal.getTime(), endDateCal.getTime());
        return new Date[]{startDateCal.getTime(), endDateCal.getTime()};
    }

    public void loadRoomAvailability(RoomAvailabilityInterface availability, Date[] startEnd) {
        this.setPhase(MSG.phaseLoadingRoomAvailability(), this.iRooms.size());
        int firstDOY = this.iSession.getDayOfYear(1, this.iSession.getPatternStartMonth());
        int lastDOY = this.iSession.getDayOfYear(0, this.iSession.getPatternEndMonth() + 1);
        int size = lastDOY - firstDOY;
        Calendar c = Calendar.getInstance(Locale.US);
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_PATTERN);
        int sessionYear = this.iSession.getSessionStartYear();
        Enumeration<RoomConstraint> e = this.iRooms.elements();
        while (e.hasMoreElements()) {
            Collection<RoomAvailabilityInterface.TimeBlock> times;
            RoomConstraint room = e.nextElement();
            this.incProgress();
            if (!room.getConstraint() || (times = this.getRoomAvailability(availability, room, startEnd[0], startEnd[1])) == null) continue;
            for (RoomAvailabilityInterface.TimeBlock time : times) {
                int length;
                this.iProgress.debug(room.getName() + " not available due to " + String.valueOf(time));
                int dayCode = 0;
                c.setTime(time.getStartTime());
                int m = c.get(2);
                int d = c.get(5);
                if (c.get(1) < sessionYear) {
                    m -= 12 * (sessionYear - c.get(1));
                }
                if (c.get(1) > sessionYear) {
                    m += 12 * (c.get(1) - sessionYear);
                }
                BitSet weekCode = new BitSet(size);
                int offset = this.iSession.getDayOfYear(d, m) - firstDOY;
                if (offset < 0 || offset >= size) continue;
                weekCode.set(offset);
                switch (c.get(7)) {
                    case 2: {
                        dayCode = Constants.DAY_CODES[0];
                        break;
                    }
                    case 3: {
                        dayCode = Constants.DAY_CODES[1];
                        break;
                    }
                    case 4: {
                        dayCode = Constants.DAY_CODES[2];
                        break;
                    }
                    case 5: {
                        dayCode = Constants.DAY_CODES[3];
                        break;
                    }
                    case 6: {
                        dayCode = Constants.DAY_CODES[4];
                        break;
                    }
                    case 7: {
                        dayCode = Constants.DAY_CODES[5];
                        break;
                    }
                    case 1: {
                        dayCode = Constants.DAY_CODES[6];
                    }
                }
                int startSlot = (c.get(11) * 60 + c.get(12) - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
                c.setTime(time.getEndTime());
                int endSlot = (c.get(11) * 60 + c.get(12) - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
                if (endSlot == 0 && c.get(5) != d) {
                    endSlot = 288;
                }
                if ((length = endSlot - startSlot) <= 0) continue;
                TimeLocation timeLocation = new TimeLocation(dayCode, startSlot, length, 0, 0.0, null, df.format(time.getStartTime()), weekCode, 0);
                ArrayList<TimeLocation> timeLocations = new ArrayList<TimeLocation>(1);
                timeLocations.add(timeLocation);
                RoomLocation roomLocation = new RoomLocation(room.getResourceId(), room.getName(), room.getBuildingId(), 0, room.getCapacity(), room.getPosX(), room.getPosY(), room.getIgnoreTooFar(), room);
                ArrayList<RoomLocation> roomLocations = new ArrayList<RoomLocation>(1);
                roomLocations.add(roomLocation);
                Lecture lecture = new Lecture(Long.valueOf(--this.iFakeLectureId), null, null, time.getEventName(), timeLocations, roomLocations, 1, new Placement(null, timeLocation, roomLocations), 0, 0, 1.0);
                lecture.setNote(time.getEventType());
                Placement p = (Placement)lecture.getInitialAssignment();
                lecture.setBestAssignment((Value)p, 0L);
                lecture.setCommitted(true);
                room.setNotAvailable(p);
                ((TimetableModel)this.getModel()).addVariable((Variable)((Lecture)p.variable()));
            }
        }
    }

    public Collection<RoomAvailabilityInterface.TimeBlock> getRoomAvailability(RoomAvailabilityInterface availability, RoomConstraint room, Date startTime, Date endTime) {
        Collection<RoomAvailabilityInterface.TimeBlock> ret = null;
        String ts = null;
        try {
            ret = availability.getRoomAvailability(room.getResourceId(), startTime, endTime, RoomAvailabilityInterface.sClassType);
            if (!this.iRoomAvailabilityTimeStampIsSet) {
                ts = availability.getTimeStamp(startTime, endTime, RoomAvailabilityInterface.sClassType);
            }
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            this.iProgress.message(this.msglevel("roomAvailabilityFailure", 5), MSG.warnRoomAvailableServiceFailed(e.getMessage()));
        }
        if (!this.iRoomAvailabilityTimeStampIsSet) {
            this.iRoomAvailabilityTimeStampIsSet = true;
            if (ts != null) {
                ((TimetableModel)this.getModel()).getProperties().setProperty("RoomAvailability.TimeStamp", ts);
                this.iProgress.message(this.msglevel("roomAvailabilityUpdated", 3), MSG.infoUsingRoomAvailability(ts));
            } else {
                this.iProgress.message(this.msglevel("roomAvailabilityFailure", 6), MSG.warnRoomAvailableServiceNotAvailable());
            }
        }
        return ret;
    }

    private Placement timeBlock2Placement(RoomAvailabilityInterface.TimeBlock time) {
        int length;
        int firstDOY = this.iSession.getDayOfYear(1, this.iSession.getPatternStartMonth());
        int lastDOY = this.iSession.getDayOfYear(0, this.iSession.getPatternEndMonth() + 1);
        int size = lastDOY - firstDOY;
        Calendar c = Calendar.getInstance(Locale.US);
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_PATTERN);
        int sessionYear = this.iSession.getSessionStartYear();
        int dayCode = 0;
        c.setTime(time.getStartTime());
        int m = c.get(2);
        int d = c.get(5);
        if (c.get(1) < sessionYear) {
            m -= 12 * (sessionYear - c.get(1));
        }
        if (c.get(1) > sessionYear) {
            m += 12 * (c.get(1) - sessionYear);
        }
        BitSet weekCode = new BitSet(size);
        int offset = this.iSession.getDayOfYear(d, m) - firstDOY;
        if (offset < 0 || offset >= size) {
            return null;
        }
        weekCode.set(offset);
        switch (c.get(7)) {
            case 2: {
                dayCode = Constants.DAY_CODES[0];
                break;
            }
            case 3: {
                dayCode = Constants.DAY_CODES[1];
                break;
            }
            case 4: {
                dayCode = Constants.DAY_CODES[2];
                break;
            }
            case 5: {
                dayCode = Constants.DAY_CODES[3];
                break;
            }
            case 6: {
                dayCode = Constants.DAY_CODES[4];
                break;
            }
            case 7: {
                dayCode = Constants.DAY_CODES[5];
                break;
            }
            case 1: {
                dayCode = Constants.DAY_CODES[6];
            }
        }
        int startSlot = (c.get(11) * 60 + c.get(12) - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
        c.setTime(time.getEndTime());
        int endSlot = (c.get(11) * 60 + c.get(12) - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
        if (endSlot == 0 && c.get(5) != d) {
            endSlot = 288;
        }
        if ((length = endSlot - startSlot) <= 0) {
            return null;
        }
        TimeLocation timeLocation = new TimeLocation(dayCode, startSlot, length, 0, 0.0, null, df.format(time.getStartTime()), weekCode, 0);
        ArrayList<TimeLocation> timeLocations = new ArrayList<TimeLocation>(1);
        timeLocations.add(timeLocation);
        Placement placement = null;
        ArrayList<RoomLocation> roomLocations = new ArrayList<RoomLocation>(1);
        if (time instanceof RoomAvailabilityInterface.HasRoom && ((RoomAvailabilityInterface.HasRoom)((Object)time)).getLocationId() != null) {
            RoomAvailabilityInterface.HasRoom r = (RoomAvailabilityInterface.HasRoom)((Object)time);
            RoomConstraint room = this.iRooms.get(r.getLocationId());
            if (room == null && r.getPermanentId() != null) {
                room = this.iRoomsByPermId.get(r.getPermanentId());
            }
            RoomLocation roomLocation = null;
            roomLocation = room != null ? new RoomLocation(room.getResourceId(), room.getName(), room.getBuildingId(), 0, room.getCapacity(), room.getPosX(), room.getPosY(), room.getIgnoreTooFar(), room) : new RoomLocation(r.getLocationId(), r.getLabel(), null, 0, 0, r.getCoordinateX(), r.getCoordinateY(), r.isIgnoreTooFar(), null);
            roomLocations.add(roomLocation);
            placement = new Placement(null, timeLocation, roomLocation);
        } else {
            placement = new Placement(null, timeLocation, (RoomLocation)null);
        }
        Lecture lecture = new Lecture(Long.valueOf(--this.iFakeLectureId), null, null, time.getEventName(), timeLocations, roomLocations, placement.getNrRooms(), placement, 0, 0, 1.0);
        lecture.setNote(time.getEventType());
        Placement p = (Placement)lecture.getInitialAssignment();
        lecture.setBestAssignment((Value)p, 0L);
        lecture.setCommitted(true);
        return p;
    }

    public void loadInstructorAvailability(RoomAvailabilityInterface availability, Date[] startEnd) {
        this.setPhase(MSG.phaseLoadingInstructorAvailability(), ((TimetableModel)this.getModel()).getInstructorConstraints().size());
        for (InstructorConstraint instructor : ((TimetableModel)this.getModel()).getInstructorConstraints()) {
            this.incProgress();
            Collection<RoomAvailabilityInterface.TimeBlock> times = this.getInstructorAvailability(availability, instructor, startEnd[0], startEnd[1]);
            if (times == null) continue;
            for (RoomAvailabilityInterface.TimeBlock time : times) {
                this.iProgress.debug(instructor.getName() + " not available due to " + String.valueOf(time));
                Placement p = this.timeBlock2Placement(time);
                if (p == null) continue;
                instructor.setNotAvailable(p);
                ((TimetableModel)this.getModel()).addVariable((Variable)((Lecture)p.variable()));
            }
        }
    }

    public Collection<RoomAvailabilityInterface.TimeBlock> getInstructorAvailability(RoomAvailabilityInterface availability, InstructorConstraint instructor, Date startTime, Date endTime) {
        Collection<RoomAvailabilityInterface.TimeBlock> ret = null;
        String ts = null;
        try {
            ret = availability.getInstructorAvailability(instructor.getResourceId(), startTime, endTime, RoomAvailabilityInterface.sClassType);
            if (!this.iRoomAvailabilityTimeStampIsSet) {
                ts = availability.getTimeStamp(startTime, endTime, RoomAvailabilityInterface.sClassType);
            }
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            this.iProgress.message(this.msglevel("roomAvailabilityFailure", 5), MSG.warnRoomAvailableServiceFailed(e.getMessage()));
        }
        if (!this.iRoomAvailabilityTimeStampIsSet) {
            this.iRoomAvailabilityTimeStampIsSet = true;
            if (ts != null) {
                ((TimetableModel)this.getModel()).getProperties().setProperty("RoomAvailability.TimeStamp", ts);
                this.iProgress.message(this.msglevel("roomAvailabilityUpdated", 3), MSG.infoUsingRoomAvailability(ts));
            } else {
                this.iProgress.message(this.msglevel("roomAvailabilityFailure", 6), MSG.warnRoomAvailableServiceNotAvailable());
            }
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    protected void postAutomaticHierarchicalConstraints(org.hibernate.Session hibSession) {
        String constraints = ((TimetableModel)this.getModel()).getProperties().getProperty("General.AutomaticHierarchicalConstraints");
        if (constraints == null || constraints.isEmpty()) {
            return;
        }
        List types = hibSession.createQuery("from DistributionType where examPref = false", DistributionType.class).list();
        List patterns = hibSession.createQuery("from DatePattern where session.uniqueId = :sessionId", DatePattern.class).setParameter("sessionId", (Object)this.iSessionId).list();
        for (String term : constraints.split("[,;][ ]?(?=([^\"]*\"[^\"]*\")*[^\"]*$)")) {
            void var12_19;
            String constraint = term.trim().toLowerCase();
            if (constraint.isEmpty()) continue;
            PreferenceLevel pref = null;
            for (PreferenceLevel preferenceLevel : PreferenceLevel.getPreferenceLevelList()) {
                if (constraint.startsWith(preferenceLevel.getPrefName().toLowerCase() + " ") || constraint.startsWith(preferenceLevel.getPrefName().toLowerCase() + ":")) {
                    pref = preferenceLevel;
                    constraint = constraint.substring(preferenceLevel.getPrefName().length() + 1).trim();
                    break;
                }
                if (constraint.startsWith(preferenceLevel.getPrefProlog().toLowerCase() + " ") || constraint.startsWith(preferenceLevel.getPrefProlog().toLowerCase() + ":")) {
                    pref = preferenceLevel;
                    constraint = constraint.substring(preferenceLevel.getPrefProlog().length() + 1).trim();
                    break;
                }
                if (preferenceLevel.getPrefAbbv() != null && (constraint.startsWith(preferenceLevel.getPrefAbbv().toLowerCase() + " ") || constraint.startsWith(preferenceLevel.getPrefAbbv().toLowerCase() + ":"))) {
                    pref = preferenceLevel;
                    constraint = constraint.substring(preferenceLevel.getPrefAbbv().length() + 1).trim();
                    break;
                }
                if (PreferenceLevel.sRequired.equals(preferenceLevel.getPrefProlog()) && (constraint.startsWith("required ") || constraint.startsWith("required:"))) {
                    pref = preferenceLevel;
                    constraint = constraint.substring("required ".length()).trim();
                    break;
                }
                if (PreferenceLevel.sStronglyPreferred.equals(preferenceLevel.getPrefProlog()) && (constraint.startsWith("strongly preferred ") || constraint.startsWith("strongly preferred:"))) {
                    pref = preferenceLevel;
                    constraint = constraint.substring("strongly preferred ".length()).trim();
                    break;
                }
                if (PreferenceLevel.sPreferred.equals(preferenceLevel.getPrefProlog()) && (constraint.startsWith("preferred ") || constraint.startsWith("preferred:"))) {
                    pref = preferenceLevel;
                    constraint = constraint.substring("preferred ".length()).trim();
                    break;
                }
                if (PreferenceLevel.sNeutral.equals(preferenceLevel.getPrefProlog()) && (constraint.startsWith("neutral ") || constraint.startsWith("neutral:"))) {
                    pref = preferenceLevel;
                    constraint = constraint.substring("neutral ".length()).trim();
                    break;
                }
                if (PreferenceLevel.sDiscouraged.equals(preferenceLevel.getPrefProlog()) && (constraint.startsWith("discouraged ") || constraint.startsWith("discouraged:"))) {
                    pref = preferenceLevel;
                    constraint = constraint.substring("discouraged ".length()).trim();
                    break;
                }
                if (PreferenceLevel.sStronglyDiscouraged.equals(preferenceLevel.getPrefProlog()) && (constraint.startsWith("strongly discouraged ") || constraint.startsWith("strongly discouraged:"))) {
                    pref = preferenceLevel;
                    constraint = constraint.substring("strongly discouraged ".length()).trim();
                    break;
                }
                if (!PreferenceLevel.sProhibited.equals(preferenceLevel.getPrefProlog()) || !constraint.startsWith("prohibited ") && !constraint.startsWith("prohibited:")) continue;
                pref = preferenceLevel;
                constraint = constraint.substring("prohibited ".length()).trim();
                break;
            }
            if (pref == null) {
                this.iProgress.message(this.msglevel("automaticHierarchicalConstraints", 5), MSG.warnFailedToParseAutomaticHierarchicalConstraint(term));
                continue;
            }
            Object type = null;
            for (Object t : types) {
                if (constraint.equalsIgnoreCase(((BaseRefTableEntry)t).getReference()) || constraint.equalsIgnoreCase(((BaseDistributionType)t).getAbbreviation()) || constraint.equalsIgnoreCase(((BaseRefTableEntry)t).getLabel())) {
                    type = t;
                    constraint = "";
                    break;
                }
                if (constraint.startsWith(((BaseRefTableEntry)t).getReference().toLowerCase() + " ") || constraint.startsWith(((BaseRefTableEntry)t).getReference().toLowerCase() + ":")) {
                    type = t;
                    constraint = constraint.substring(((BaseRefTableEntry)t).getReference().length() + 1).trim();
                    break;
                }
                if (constraint.startsWith(((BaseDistributionType)t).getAbbreviation().toLowerCase() + " ") || constraint.startsWith(((BaseDistributionType)t).getAbbreviation().toLowerCase() + ":")) {
                    type = t;
                    constraint = constraint.substring(((BaseDistributionType)t).getAbbreviation().length() + 1).trim();
                    break;
                }
                if (!constraint.startsWith(((BaseRefTableEntry)t).getLabel().toLowerCase() + " ") && !constraint.startsWith(((BaseRefTableEntry)t).getLabel().toLowerCase() + ":")) continue;
                type = t;
                constraint = constraint.substring(((BaseRefTableEntry)t).getLabel().length() + 1).trim();
                break;
            }
            if (type == null) {
                for (GroupConstraint.ConstraintType t : GroupConstraint.ConstraintType.values()) {
                    if (constraint.equalsIgnoreCase(t.reference()) || constraint.equalsIgnoreCase(t.getName())) {
                        type = new DistributionType();
                        ((BaseRefTableEntry)type).setReference(t.reference());
                        ((BaseRefTableEntry)type).setLabel(t.getName());
                        ((BaseDistributionType)type).setAbbreviation(t.getName());
                        constraint = "";
                        break;
                    }
                    if (constraint.startsWith(t.reference().toLowerCase() + " ") || constraint.startsWith(t.reference().toLowerCase() + ":")) {
                        type = new DistributionType();
                        ((BaseRefTableEntry)type).setReference(t.reference());
                        ((BaseRefTableEntry)type).setLabel(t.getName());
                        ((BaseDistributionType)type).setAbbreviation(t.getName());
                        constraint = constraint.substring(t.reference().length() + 1).trim();
                        break;
                    }
                    if (!constraint.startsWith(t.getName().toLowerCase() + " ") && !constraint.startsWith(t.getName().toLowerCase() + ":")) continue;
                    type = new DistributionType();
                    ((BaseRefTableEntry)type).setReference(t.reference());
                    ((BaseRefTableEntry)type).setLabel(t.getName());
                    ((BaseDistributionType)type).setAbbreviation(t.getName());
                    constraint = constraint.substring(t.getName().length() + 1).trim();
                    break;
                }
            }
            if (type == null) {
                this.iProgress.message(this.msglevel("automaticHierarchicalConstraints", 5), MSG.warnFailedToParseAutomaticHierarchicalConstraint(term));
                continue;
            }
            Object var12_17 = null;
            if (!constraint.isEmpty()) {
                Object t;
                t = patterns.iterator();
                while (t.hasNext()) {
                    DatePattern p3 = (DatePattern)t.next();
                    if (!constraint.equalsIgnoreCase(p3.getName()) && !constraint.equalsIgnoreCase("\"" + p3.getName() + "\"")) continue;
                    DatePattern datePattern = p3;
                    break;
                }
                if (var12_19 == null) {
                    this.iProgress.message(this.msglevel("automaticHierarchicalConstraints", 5), MSG.warnFailedToParseAutomaticHierarchicalConstraintBadDatePattern(constraint));
                    continue;
                }
            }
            this.setPhase(var12_19 == null ? MSG.phasePostingAutomaticConstraint(pref.getPrefName(), ((BaseRefTableEntry)type).getLabel()) : MSG.phasePostingAutomaticConstraintDatePattern(pref.getPrefName(), ((BaseRefTableEntry)type).getLabel(), var12_19.getName()), this.iAllClasses.size());
            for (Class_ clazz : this.iAllClasses) {
                Lecture lecture = this.iLectures.get(clazz.getUniqueId());
                if (lecture == null) continue;
                if (!lecture.hasAnyChildren()) {
                    this.postAutomaticHierarchicalConstraint(clazz, (DistributionType)type, pref, (DatePattern)var12_19);
                }
                this.incProgress();
            }
        }
    }

    protected boolean postAutomaticHierarchicalConstraint(Class_ clazz, DistributionType type, PreferenceLevel preference, DatePattern pattern) {
        boolean posted = false;
        if (!clazz.getChildClasses().isEmpty()) {
            for (Class_ c : clazz.getChildClasses()) {
                if (!this.postAutomaticHierarchicalConstraint(c, type, preference, pattern)) continue;
                posted = true;
            }
        }
        if (posted) {
            return true;
        }
        if (this.getLecture(clazz) == null) {
            return false;
        }
        if (pattern != null && !pattern.equals(clazz.effectiveDatePattern())) {
            return false;
        }
        ArrayList<Lecture> variables = new ArrayList<Lecture>();
        for (Class_ parent = clazz; parent != null; parent = parent.getParentClass()) {
            Lecture lecture;
            if (pattern != null && !pattern.equals(parent.effectiveDatePattern()) || (lecture = this.getLecture(parent)) == null) continue;
            variables.add(0, lecture);
        }
        if (variables.size() <= 1) {
            return false;
        }
        Constraint gc = this.createGroupConstraint(clazz.getUniqueId(), type, preference, clazz);
        if (gc == null) {
            return false;
        }
        Object info = "";
        for (Lecture var : variables) {
            gc.addVariable((Variable)var);
            if (!((String)info).isEmpty()) {
                info = (String)info + ", ";
            }
            info = (String)info + this.getClassLabel(var);
        }
        this.iProgress.info(MSG.infoPostedConstraint(type.getLabel(), (String)info, preference.getPrefName()));
        this.addGroupConstraint((Constraint<Lecture, Placement>)gc);
        return true;
    }

    protected void postAutomaticStudentConstraints(org.hibernate.Session hibSession) {
        String constraints = ((TimetableModel)this.getModel()).getProperties().getProperty("General.AutomaticStudentConstraints");
        if (constraints == null || constraints.isEmpty()) {
            return;
        }
        HashMap<String, Integer> classes2counts = new HashMap<String, Integer>();
        HashMap<Object, org.cpsolver.coursett.model.Student> firstStudent = new HashMap<Object, org.cpsolver.coursett.model.Student>();
        for (org.cpsolver.coursett.model.Student student : ((TimetableModel)this.getModel()).getAllStudents()) {
            Object lecture22;
            TreeSet<Long> idSet = new TreeSet<Long>();
            for (Object lecture22 : student.getLectures()) {
                idSet.add(lecture22.getClassId());
            }
            Object ids = "";
            lecture22 = idSet.iterator();
            while (lecture22.hasNext()) {
                Long id = (Long)lecture22.next();
                ids = (String)ids + (((String)ids).isEmpty() ? "" : ",") + id;
            }
            Integer count = (Integer)classes2counts.get(ids);
            classes2counts.put((String)ids, 1 + (count == null ? 0 : count));
            if (count != null) continue;
            firstStudent.put(ids, student);
        }
        int limit = ((TimetableModel)this.getModel()).getProperties().getPropertyInt("General.AutomaticStudentConstraints.StudentLimit", 5);
        List types = hibSession.createQuery("from DistributionType where examPref = false", DistributionType.class).list();
        for (String term : constraints.split("[,;][ ]?(?=([^\"]*\"[^\"]*\")*[^\"]*$)")) {
            String constraint = term.trim().toLowerCase();
            if (constraint.isEmpty()) continue;
            PreferenceLevel pref = null;
            for (PreferenceLevel p : PreferenceLevel.getPreferenceLevelList()) {
                if (constraint.startsWith(p.getPrefName().toLowerCase() + " ") || constraint.startsWith(p.getPrefName().toLowerCase() + ":")) {
                    pref = p;
                    constraint = constraint.substring(p.getPrefName().length() + 1).trim();
                    break;
                }
                if (constraint.startsWith(p.getPrefProlog().toLowerCase() + " ") || constraint.startsWith(p.getPrefProlog().toLowerCase() + ":")) {
                    pref = p;
                    constraint = constraint.substring(p.getPrefProlog().length() + 1).trim();
                    break;
                }
                if (p.getPrefAbbv() != null && constraint.startsWith(p.getPrefAbbv().toLowerCase() + " ") || constraint.startsWith(p.getPrefAbbv().toLowerCase() + ":")) {
                    pref = p;
                    constraint = constraint.substring(p.getPrefAbbv().length() + 1).trim();
                    break;
                }
                if (PreferenceLevel.sRequired.equals(p.getPrefProlog()) && (constraint.startsWith("required ") || constraint.startsWith("required:"))) {
                    pref = p;
                    constraint = constraint.substring("required ".length()).trim();
                    break;
                }
                if (PreferenceLevel.sStronglyPreferred.equals(p.getPrefProlog()) && (constraint.startsWith("strongly preferred ") || constraint.startsWith("strongly preferred:"))) {
                    pref = p;
                    constraint = constraint.substring("strongly preferred ".length()).trim();
                    break;
                }
                if (PreferenceLevel.sPreferred.equals(p.getPrefProlog()) && (constraint.startsWith("preferred ") || constraint.startsWith("preferred:"))) {
                    pref = p;
                    constraint = constraint.substring("preferred ".length()).trim();
                    break;
                }
                if (PreferenceLevel.sNeutral.equals(p.getPrefProlog()) && (constraint.startsWith("neutral ") || constraint.startsWith("neutral:"))) {
                    pref = p;
                    constraint = constraint.substring("neutral ".length()).trim();
                    break;
                }
                if (PreferenceLevel.sDiscouraged.equals(p.getPrefProlog()) && (constraint.startsWith("discouraged ") || constraint.startsWith("discouraged:"))) {
                    pref = p;
                    constraint = constraint.substring("discouraged ".length()).trim();
                    break;
                }
                if (PreferenceLevel.sStronglyDiscouraged.equals(p.getPrefProlog()) && (constraint.startsWith("strongly discouraged ") || constraint.startsWith("strongly discouraged:"))) {
                    pref = p;
                    constraint = constraint.substring("strongly discouraged ".length()).trim();
                    break;
                }
                if (!PreferenceLevel.sProhibited.equals(p.getPrefProlog()) || !constraint.startsWith("prohibited ") && !constraint.startsWith("prohibited:")) continue;
                pref = p;
                constraint = constraint.substring("prohibited ".length()).trim();
                break;
            }
            if (pref == null) {
                this.iProgress.message(this.msglevel("automaticStudentConstraints", 5), MSG.warnFailedToParseAutomaticStudentConstraint(term));
                continue;
            }
            BaseRefTableEntry type = null;
            for (DistributionType distributionType : types) {
                if (constraint.equalsIgnoreCase(distributionType.getReference()) || constraint.equalsIgnoreCase(distributionType.getAbbreviation()) || constraint.equalsIgnoreCase(distributionType.getLabel())) {
                    type = distributionType;
                    constraint = "";
                    break;
                }
                if (constraint.startsWith(distributionType.getReference().toLowerCase() + " ") || constraint.startsWith(distributionType.getReference().toLowerCase() + ":")) {
                    type = distributionType;
                    constraint = constraint.substring(distributionType.getReference().length() + 1).trim();
                    break;
                }
                if (constraint.startsWith(distributionType.getAbbreviation().toLowerCase() + " ") || constraint.startsWith(distributionType.getAbbreviation().toLowerCase() + ":")) {
                    type = distributionType;
                    constraint = constraint.substring(distributionType.getAbbreviation().length() + 1).trim();
                    break;
                }
                if (!constraint.startsWith(distributionType.getLabel().toLowerCase() + " ") && !constraint.startsWith(distributionType.getLabel().toLowerCase() + ":")) continue;
                type = distributionType;
                constraint = constraint.substring(distributionType.getLabel().length() + 1).trim();
                break;
            }
            if (type == null) {
                for (GroupConstraint.ConstraintType constraintType : GroupConstraint.ConstraintType.values()) {
                    if (!constraint.equalsIgnoreCase(constraintType.reference()) && !constraint.equalsIgnoreCase(constraintType.getName())) continue;
                    type = new DistributionType();
                    type.setReference(constraintType.reference());
                    type.setLabel(constraintType.getName());
                    ((BaseDistributionType)type).setAbbreviation(constraintType.getName());
                }
            }
            if (type == null) {
                this.iProgress.message(this.msglevel("automaticStudentConstraints", 5), MSG.warnFailedToParseAutomaticStudentConstraint(term));
                continue;
            }
            this.setPhase(MSG.phasePostingAutomaticStudentConstraints(pref.getPrefName(), type.getLabel()), classes2counts.size());
            for (Map.Entry entry : classes2counts.entrySet()) {
                Constraint gc;
                this.incProgress();
                if ((Integer)entry.getValue() < limit) continue;
                ArrayList<Lecture> variables = new ArrayList<Lecture>();
                for (String id : ((String)entry.getKey()).split(",")) {
                    Lecture lecture = this.iLectures.get(Long.valueOf(id));
                    if (lecture == null) continue;
                    variables.add(lecture);
                }
                org.cpsolver.coursett.model.Student student = (org.cpsolver.coursett.model.Student)firstStudent.get(entry.getKey());
                if (variables.size() <= 1 || (gc = this.createGroupConstraint(student.getId(), (DistributionType)type, pref, student)) == null) continue;
                Object info = "";
                for (Lecture var : variables) {
                    gc.addVariable((Variable)var);
                    if (!((String)info).isEmpty()) {
                        info = (String)info + ", ";
                    }
                    info = (String)info + this.getClassLabel(var);
                }
                this.iProgress.info(MSG.infoPostedConstraint(type.getLabel(), (String)info, pref.getPrefName()));
                this.addGroupConstraint((Constraint<Lecture, Placement>)gc);
            }
        }
    }

    protected void checkTermination() {
        if (this.getTerminationCondition() != null && !this.getTerminationCondition().canContinue(new Solution(this.getModel(), this.getAssignment()))) {
            throw new RuntimeException(MSG.fatalLoadInterrupted());
        }
    }

    protected void setPhase(String phase, long progressMax) {
        this.checkTermination();
        this.iProgress.setPhase(phase, progressMax);
    }

    protected void incProgress() {
        this.checkTermination();
        this.iProgress.incProgress();
    }

    protected boolean isSameType(DistributionType t1, DistributionType t2) {
        if (t1.getReference().equals(t2.getReference())) {
            return true;
        }
        if (t1.getReference().matches("_(.+)_")) {
            for (FlexibleConstraint.FlexibleConstraintType fcType : FlexibleConstraint.FlexibleConstraintType.values()) {
                if (!t1.getReference().matches(fcType.getPattern()) || !t2.getReference().matches(fcType.getPattern())) continue;
                return true;
            }
            return false;
        }
        return t1.getReference().replaceFirst("\\([a-z0-9\\.]+\\)", "").equals(t2.getReference().replaceFirst("\\([a-z0-9\\.]+\\)", ""));
    }

    protected void postAutomaticInstructorConstraints(org.hibernate.Session hibSession) {
        String constraints = ((TimetableModel)this.getModel()).getProperties().getProperty("General.AutomaticInstructorConstraints");
        if (constraints == null || constraints.isEmpty()) {
            return;
        }
        List types = hibSession.createQuery("from DistributionType where examPref = false", DistributionType.class).list();
        for (String term : constraints.split("[,;][ ]?(?=([^\"]*\"[^\"]*\")*[^\"]*$)")) {
            String constraint = term.trim().toLowerCase();
            if (constraint.isEmpty()) continue;
            PreferenceLevel pref = null;
            for (PreferenceLevel p : PreferenceLevel.getPreferenceLevelList()) {
                if (constraint.startsWith(p.getPrefName().toLowerCase() + " ") || constraint.startsWith(p.getPrefName().toLowerCase() + ":")) {
                    pref = p;
                    constraint = constraint.substring(p.getPrefName().length() + 1).trim();
                    break;
                }
                if (constraint.startsWith(p.getPrefProlog().toLowerCase() + " ") || constraint.startsWith(p.getPrefProlog().toLowerCase() + ":")) {
                    pref = p;
                    constraint = constraint.substring(p.getPrefProlog().length() + 1).trim();
                    break;
                }
                if (p.getPrefAbbv() != null && (constraint.startsWith(p.getPrefAbbv().toLowerCase() + " ") || constraint.startsWith(p.getPrefAbbv().toLowerCase() + ":"))) {
                    pref = p;
                    constraint = constraint.substring(p.getPrefAbbv().length() + 1).trim();
                    break;
                }
                if (PreferenceLevel.sRequired.equals(p.getPrefProlog()) && (constraint.startsWith("required ") || constraint.startsWith("required:"))) {
                    pref = p;
                    constraint = constraint.substring("required ".length()).trim();
                    break;
                }
                if (PreferenceLevel.sStronglyPreferred.equals(p.getPrefProlog()) && (constraint.startsWith("strongly preferred ") || constraint.startsWith("strongly preferred:"))) {
                    pref = p;
                    constraint = constraint.substring("strongly preferred ".length()).trim();
                    break;
                }
                if (PreferenceLevel.sPreferred.equals(p.getPrefProlog()) && (constraint.startsWith("preferred ") || constraint.startsWith("preferred:"))) {
                    pref = p;
                    constraint = constraint.substring("preferred ".length()).trim();
                    break;
                }
                if (PreferenceLevel.sNeutral.equals(p.getPrefProlog()) && (constraint.startsWith("neutral ") || constraint.startsWith("neutral:"))) {
                    pref = p;
                    constraint = constraint.substring("neutral ".length()).trim();
                    break;
                }
                if (PreferenceLevel.sDiscouraged.equals(p.getPrefProlog()) && (constraint.startsWith("discouraged ") || constraint.startsWith("discouraged:"))) {
                    pref = p;
                    constraint = constraint.substring("discouraged ".length()).trim();
                    break;
                }
                if (PreferenceLevel.sStronglyDiscouraged.equals(p.getPrefProlog()) && (constraint.startsWith("strongly discouraged ") || constraint.startsWith("strongly discouraged:"))) {
                    pref = p;
                    constraint = constraint.substring("strongly discouraged ".length()).trim();
                    break;
                }
                if (!PreferenceLevel.sProhibited.equals(p.getPrefProlog()) || !constraint.startsWith("prohibited ") && !constraint.startsWith("prohibited:")) continue;
                pref = p;
                constraint = constraint.substring("prohibited ".length()).trim();
                break;
            }
            if (pref == null) {
                this.iProgress.message(this.msglevel("automaticHierarchicalConstraints", 5), MSG.warnFailedToParseAutomaticInstructorConstraint(term));
                continue;
            }
            BaseRefTableEntry type = null;
            for (DistributionType t : types) {
                if (!constraint.equalsIgnoreCase(t.getReference()) && !constraint.equalsIgnoreCase(t.getAbbreviation()) && !constraint.equalsIgnoreCase(t.getLabel())) continue;
                type = t;
                break;
            }
            if (type == null) {
                for (GroupConstraint.ConstraintType constraintType : GroupConstraint.ConstraintType.values()) {
                    if (!constraint.equalsIgnoreCase(constraintType.reference()) && !constraint.equalsIgnoreCase(constraintType.getName())) continue;
                    type = new DistributionType();
                    type.setReference(constraintType.reference());
                    type.setLabel(constraintType.getName());
                    ((BaseDistributionType)type).setAbbreviation(constraintType.getName());
                    break;
                }
            }
            if (type == null) {
                this.iProgress.message(this.msglevel("automaticHierarchicalConstraints", 5), MSG.warnFailedToParseAutomaticInstructorConstraint(term));
                continue;
            }
            this.setPhase(MSG.phasePostingAutomaticConstraint(pref.getPrefName(), type.getLabel()), this.iInstructors.size());
            block4: for (InstructorConstraint ic : ((TimetableModel)this.getModel()).getInstructorConstraints()) {
                Constraint gc;
                this.incProgress();
                List variables = ic.variables();
                if (this.iInstructorDistributionsAcrossDepartments && ic.getUnavailabilities() != null) {
                    for (Object p : ic.getUnavailabilities()) {
                        if (((Lecture)p.variable()).getId() <= 0L) continue;
                        variables.add((Lecture)p.variable());
                    }
                }
                if (variables.size() <= 1) continue;
                List<DistributionType> list = this.iInstructorDistributions.get(ic);
                if (list != null) {
                    Object p;
                    p = list.iterator();
                    while (p.hasNext()) {
                        DistributionType other = (DistributionType)p.next();
                        if (!this.isSameType((DistributionType)type, other)) continue;
                        continue block4;
                    }
                }
                if ((gc = this.createGroupConstraint(ic.getId(), (DistributionType)type, pref, ic)) == null) continue;
                Object info = "";
                for (Lecture var : variables) {
                    gc.addVariable((Variable)var);
                    if (!((String)info).isEmpty()) {
                        info = (String)info + ", ";
                    }
                    info = (String)info + this.getClassLabel(var);
                }
                this.iProgress.info(MSG.infoPostedConstraint(type.getLabel(), (String)info, pref.getPrefName()));
                this.addGroupConstraint((Constraint<Lecture, Placement>)gc);
            }
        }
    }

    public static enum CommittedStudentConflictsMode {
        Ignore,
        Load,
        Compute;

    }

    public static class ChildrenFirstDistributionObjectComparator
    implements Comparator<DistributionObject> {
        @Override
        public int compare(DistributionObject d1, DistributionObject d2) {
            if (d1.getPrefGroup() instanceof Class_) {
                if (d2.getPrefGroup() instanceof Class_) {
                    return d1.compareTo(d2);
                }
                return 1;
            }
            if (d2.getPrefGroup() instanceof Class_) {
                return -1;
            }
            if (!(d1.getPrefGroup() instanceof SchedulingSubpart) || !(d2.getPrefGroup() instanceof SchedulingSubpart)) {
                return d1.compareTo(d2);
            }
            SchedulingSubpart s1 = (SchedulingSubpart)d1.getPrefGroup();
            SchedulingSubpart s2 = (SchedulingSubpart)d2.getPrefGroup();
            if (s1.getClasses().size() <= 1) {
                if (s2.getClasses().size() <= 1) {
                    return d1.compareTo(d2);
                }
                return 1;
            }
            if (s2.getClasses().size() <= 1) {
                return -1;
            }
            if (TimetableDatabaseLoader.getParentClass(s1.getClasses().iterator().next(), s2) != null) {
                return -1;
            }
            if (TimetableDatabaseLoader.getParentClass(s2.getClasses().iterator().next(), s1) != null) {
                return 1;
            }
            if (TimetableDatabaseLoader.shareParent(s1, s2)) {
                if (s1.getClasses().size() < s2.getClasses().size()) {
                    return 1;
                }
                if (s1.getClasses().size() > s2.getClasses().size()) {
                    return -1;
                }
            }
            return d1.compareTo(d2);
        }
    }

    public static class ObjectsByGivenOrderComparator
    implements Comparator {
        List<?> iOrderedSet = null;

        public ObjectsByGivenOrderComparator(List<?> orderedSetOfLectures) {
            this.iOrderedSet = orderedSetOfLectures;
        }

        public int compare(Object o1, Object o2) {
            int idx2;
            int idx1 = this.iOrderedSet.indexOf(o1);
            int cmp = Double.compare(idx1, idx2 = this.iOrderedSet.indexOf(o2));
            if (cmp != 0) {
                return cmp;
            }
            return ((Comparable)o1).compareTo(o2);
        }
    }
}

