/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimeLocation;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.DatePatternDAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao.TimePatternDAO;
import org.unitime.timetable.solver.ClassAssignmentProxy;

public class SolverAssignmentInfo
implements ClassAssignmentProxy.AssignmentInfo {
    private static final long serialVersionUID = 6729805504556505822L;
    private Long iUniqueId;
    private Long iClassId;
    private String iClassName;
    private transient Class_ iClazz;
    private int iDays;
    private int iStartSlot;
    private int iSlotPerMtg;
    private Long iTimePatternId;
    private Long iDatePatternId;
    private String iDatePatternName;
    private BitSet iWeekCode;
    private int iBreakTime;
    private boolean iCommited;
    private transient TimePattern iTimePattern;
    private transient DatePattern iDatePattern;
    private transient TimeLocation iTimeLocation;
    private List<Long> iRoomIds = null;
    private transient Set<Location> iRooms;
    private transient Placement iPlacement;
    private transient List<RoomLocation> iRoomLocations;

    public SolverAssignmentInfo(Lecture lecture, Placement placement) {
        this.iClassId = lecture.getClassId();
        this.iClassName = lecture.getName();
        this.iCommited = lecture.isCommitted();
        this.iPlacement = placement;
        this.iTimeLocation = placement.getTimeLocation();
        this.iStartSlot = this.iTimeLocation.getStartSlot();
        this.iDays = this.iTimeLocation.getDayCode();
        this.iSlotPerMtg = this.iTimeLocation.getLength();
        this.iTimePatternId = this.iTimeLocation.getTimePatternId();
        this.iDatePatternId = this.iTimeLocation.getDatePatternId();
        this.iDatePatternName = this.iTimeLocation.getDatePatternName();
        this.iWeekCode = this.iTimeLocation.getWeekCode();
        this.iBreakTime = this.iTimeLocation.getBreakTime();
        this.iRoomIds = new ArrayList<Long>(placement.getNrRooms());
        if (placement.getNrRooms() == 1) {
            this.iRoomIds.add(placement.getRoomLocation().getId());
        } else if (placement.getNrRooms() > 1) {
            for (RoomLocation room : placement.getRoomLocations()) {
                this.iRoomIds.add(room.getId());
            }
        }
    }

    public SolverAssignmentInfo(Assignment assignment) {
        this.iUniqueId = assignment.getUniqueId();
        this.iClassId = assignment.getClassId();
        this.iClassName = assignment.getClassName();
        this.iCommited = assignment.isCommitted();
        this.iPlacement = assignment.getPlacement();
        this.iTimeLocation = this.iPlacement.getTimeLocation();
        this.iStartSlot = this.iTimeLocation.getStartSlot();
        this.iDays = this.iTimeLocation.getDayCode();
        this.iSlotPerMtg = this.iTimeLocation.getLength();
        this.iTimePatternId = this.iTimeLocation.getTimePatternId();
        this.iDatePatternId = this.iTimeLocation.getDatePatternId();
        this.iDatePatternName = this.iTimeLocation.getDatePatternName();
        this.iWeekCode = this.iTimeLocation.getWeekCode();
        this.iBreakTime = this.iTimeLocation.getBreakTime();
        this.iRoomIds = new ArrayList<Long>(this.iPlacement.getNrRooms());
        if (this.iPlacement.getNrRooms() == 1) {
            this.iRoomIds.add(this.iPlacement.getRoomLocation().getId());
        } else if (this.iPlacement.getNrRooms() > 1) {
            for (RoomLocation room : this.iPlacement.getRoomLocations()) {
                this.iRoomIds.add(room.getId());
            }
        }
    }

    @Override
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Override
    public Long getClassId() {
        return this.iClassId;
    }

    @Override
    public String getClassName() {
        return this.iClassName;
    }

    @Override
    public Class_ getClazz() {
        if (this.iClassId == null) {
            return null;
        }
        if (this.iClazz == null) {
            this.iClazz = (Class_)Class_DAO.getInstance().get(this.iClassId);
        }
        return this.iClazz;
    }

    @Override
    public Integer getDays() {
        return this.iDays;
    }

    @Override
    public Integer getStartSlot() {
        return this.iStartSlot;
    }

    @Override
    public int getSlotPerMtg() {
        return this.iSlotPerMtg;
    }

    @Override
    public TimePattern getTimePattern() {
        if (this.iTimePatternId == null) {
            return null;
        }
        if (this.iTimePattern == null) {
            this.iTimePattern = (TimePattern)TimePatternDAO.getInstance().get(this.iTimePatternId);
        }
        return this.iTimePattern;
    }

    @Override
    public DatePattern getDatePattern() {
        if (this.iDatePatternId == null) {
            return null;
        }
        if (this.iDatePattern == null) {
            this.iDatePattern = (DatePattern)DatePatternDAO.getInstance().get(this.iDatePatternId);
        }
        return this.iDatePattern;
    }

    @Override
    public TimeLocation getTimeLocation() {
        if (this.iTimeLocation == null) {
            this.iTimeLocation = new TimeLocation(this.iDays, this.iStartSlot, this.iSlotPerMtg, 0, 0.0, this.iDatePatternId, this.iDatePatternName, this.iWeekCode, this.iBreakTime);
        }
        return this.iTimeLocation;
    }

    @Override
    public Set<Location> getRooms() {
        if (this.iRooms == null) {
            this.iRooms = new HashSet<Location>();
            for (Long roomId : this.iRoomIds) {
                this.iRooms.add((Location)LocationDAO.getInstance().get(roomId));
            }
        }
        return this.iRooms;
    }

    @Override
    public Placement getPlacement() {
        if (this.iPlacement == null) {
            this.iPlacement = new Placement(new Lecture(this.iClassId, null, this.iClassName), this.getTimeLocation(), this.getRoomLocations());
        }
        return this.iPlacement;
    }

    @Override
    public List<RoomLocation> getRoomLocations() {
        if (this.iRoomLocations == null) {
            this.iRoomLocations = new ArrayList<RoomLocation>();
            for (Location room : this.getRooms()) {
                this.iRoomLocations.add(new RoomLocation(room.getUniqueId(), room.getLabel(), room instanceof Room ? ((Room)room).getBuilding().getUniqueId() : null, 0, room.getCapacity().intValue(), room.getCoordinateX(), room.getCoordinateY(), room.isIgnoreTooFar().booleanValue(), null));
            }
        }
        return this.iRoomLocations;
    }

    @Override
    public boolean isCommitted() {
        return this.iCommited;
    }

    @Override
    public boolean overlaps(ClassAssignmentProxy.AssignmentInfo a) {
        return this.getTimeLocation().hasIntersection(a.getTimeLocation());
    }
}

