/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.solver;

import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.CourseTimetablingSolverInterface;
import org.unitime.timetable.gwt.shared.FilterInterface;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@GwtRpcImplements(value=CourseTimetablingSolverInterface.AssignmentHistoryFilterRequest.class)
public class AssignmentHistoryFilterBackend
implements GwtRpcImplementation<CourseTimetablingSolverInterface.AssignmentHistoryFilterRequest, CourseTimetablingSolverInterface.AssignmentHistoryFilterResponse> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public CourseTimetablingSolverInterface.AssignmentHistoryFilterResponse execute(CourseTimetablingSolverInterface.AssignmentHistoryFilterRequest request, SessionContext context) {
        context.checkPermission(Right.AssignmentHistory);
        CourseTimetablingSolverInterface.AssignmentHistoryFilterResponse response = new CourseTimetablingSolverInterface.AssignmentHistoryFilterResponse();
        FilterInterface.FilterParameterInterface simplifiedMode = new FilterInterface.FilterParameterInterface();
        simplifiedMode.setName("simpleMode");
        simplifiedMode.setType("boolean");
        simplifiedMode.setLabel(MESSAGES.propCourseTimetablingSolverSimplifiedMode());
        simplifiedMode.setDefaultValue(context.getUser().getProperty("SuggestionsModel.simpleMode", "0"));
        response.addParameter(simplifiedMode);
        for (PreferenceLevel pref : PreferenceLevel.getPreferenceLevelList(true)) {
            response.addPreference(new RoomInterface.PreferenceInterface(pref.getUniqueId(), PreferenceLevel.prolog2bgColor(pref.getPrefProlog()), pref.getPrefProlog(), pref.getPrefName(), pref.getAbbreviation(), false));
        }
        return response;
    }
}

