/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.solver;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.CourseTimetablingSolverInterface;
import org.unitime.timetable.gwt.shared.SolverInterface;
import org.unitime.timetable.gwt.shared.TableInterface;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.SolutionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.solver.SolverPageBackend;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.interactive.ClassAssignmentDetails;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.solver.ui.AssignmentPreferenceInfo;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.webutil.BackTracker;

@GwtRpcImplements(value=CourseTimetablingSolverInterface.AssignedClassesRequest.class)
public class AssignedClassesBackend
implements GwtRpcImplementation<CourseTimetablingSolverInterface.AssignedClassesRequest, CourseTimetablingSolverInterface.AssignedClassesResponse> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    protected static DecimalFormat sDF = new DecimalFormat("0.###", new DecimalFormatSymbols(Locale.US));
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;

    public static boolean isAllSubjects(String subjects) {
        if (subjects == null || subjects.isEmpty() || subjects.equals(Constants.ALL_OPTION_VALUE)) {
            return true;
        }
        for (String id : subjects.split(",")) {
            if (!Constants.ALL_OPTION_VALUE.equals(id)) continue;
            return true;
        }
        return false;
    }

    public static int getOrder(ClassAssignmentDetails.TimeInfo time) {
        int firstWorkDay = ApplicationProperty.TimePatternFirstDayOfWeek.intValue();
        int days = time.getDays();
        if (firstWorkDay != 0) {
            days = time.getDays() << firstWorkDay;
            days = (days & 0x7F) + (days >> 7);
        }
        return (Constants.sDayCode2Order[days] << 18) + (time.getStartSlot() << 11) + time.getMin();
    }

    @Override
    public CourseTimetablingSolverInterface.AssignedClassesResponse execute(CourseTimetablingSolverInterface.AssignedClassesRequest request, SessionContext context) {
        Session hibSession;
        context.checkPermission(Right.AssignedClasses);
        CourseTimetablingSolverInterface.AssignedClassesResponse response = new CourseTimetablingSolverInterface.AssignedClassesResponse();
        context.getUser().setProperty("SuggestionsModel.simpleMode", request.getFilter().getParameterValue("simpleMode"));
        boolean simple = "1".equals(request.getFilter().getParameterValue("simpleMode"));
        SolverProxy solver = this.courseTimetablingSolverService.getSolver();
        String subjects = request.getFilter().getParameterValue("subjectArea");
        context.setAttribute(SessionAttribute.OfferingsSubjectArea, (Object)(AssignedClassesBackend.isAllSubjects(subjects) ? Constants.ALL_OPTION_VALUE : request.getFilter().getParameterValue("subjectArea")));
        String instructorNameFormat = UserProperty.NameFormat.get(context.getUser());
        Object solutionIdsStr = (String)context.getAttribute(SessionAttribute.SelectedSolution);
        if (solver == null) {
            if (solutionIdsStr == null || ((String)solutionIdsStr).isEmpty()) {
                for (SolverGroup g : SolverGroup.getUserSolverGroups(context.getUser())) {
                    for (Long id : SolutionDAO.getInstance().getSession().createQuery("select s.uniqueId from Solution s where s.commited = true and s.owner.uniqueId = :groupId", Long.class).setParameter("groupId", (Object)g.getUniqueId()).setCacheable(true).list()) {
                        if (solutionIdsStr == null) {
                            solutionIdsStr = id.toString();
                            continue;
                        }
                        solutionIdsStr = (String)solutionIdsStr + (((String)solutionIdsStr).isEmpty() ? "" : ",") + id;
                    }
                }
            }
            if (solutionIdsStr == null || ((String)solutionIdsStr).isEmpty()) {
                throw new GwtRpcException(MESSAGES.errorAssignedClassesNoSolution());
            }
        }
        List<Object> assignedClasses = new ArrayList();
        if (AssignedClassesBackend.isAllSubjects(subjects)) {
            if (solver != null) {
                assignedClasses = solver.getAssignedClasses(new String[0]);
            } else {
                hibSession = SolutionDAO.getInstance().getSession();
                for (String solutionId : ((String)solutionIdsStr).split(",")) {
                    Solution solution = (Solution)SolutionDAO.getInstance().get(Long.valueOf(solutionId));
                    try {
                        for (Assignment assignment : solution.getAssignments()) {
                            assignedClasses.add(new ClassAssignmentDetails(solution, assignment, false, hibSession, instructorNameFormat));
                        }
                    }
                    catch (ObjectNotFoundException e) {
                        hibSession.refresh((Object)solution);
                        for (Assignment a2 : solution.getAssignments()) {
                            assignedClasses.add(new ClassAssignmentDetails(solution, a2, false, hibSession, instructorNameFormat));
                        }
                    }
                }
            }
        } else {
            hibSession = SolutionDAO.getInstance().getSession();
            for (String id : subjects.split(",")) {
                String prefix = request.getFilter().getParameter("subjectArea").getOptionText(id) + " ";
                if (solver != null) {
                    assignedClasses.addAll(solver.getAssignedClasses(prefix));
                    continue;
                }
                for (String solutionId : ((String)solutionIdsStr).split(",")) {
                    Solution solution = (Solution)SolutionDAO.getInstance().get(Long.valueOf(solutionId));
                    try {
                        for (Assignment a : solution.getAssignments()) {
                            if (prefix != null && !a.getClassName().startsWith(prefix)) continue;
                            assignedClasses.add(new ClassAssignmentDetails(solution, a, false, hibSession, instructorNameFormat));
                        }
                    }
                    catch (ObjectNotFoundException e) {
                        hibSession.refresh((Object)solution);
                        for (Assignment a : solution.getAssignments()) {
                            if (prefix != null && !a.getClassName().startsWith(prefix)) continue;
                            assignedClasses.add(new ClassAssignmentDetails(solution, a, false, hibSession, instructorNameFormat));
                        }
                    }
                }
            }
        }
        Collections.sort(assignedClasses);
        for (ClassAssignmentDetails classAssignmentDetails : assignedClasses) {
            boolean bl;
            AssignmentPreferenceInfo ci = classAssignmentDetails.getInfo();
            TableInterface.TableCellMulti studentConfs = new TableInterface.TableCellMulti();
            studentConfs.add(this.dispNumber(ci.getNrStudentConflicts()));
            if (ci.getNrCommitedStudentConflicts() != 0) {
                if (studentConfs.getNrChunks() <= 1) {
                    studentConfs.add(" (");
                } else {
                    studentConfs.add(",");
                }
                studentConfs.add(this.dispNumber(ci.getNrCommitedStudentConflicts()).setFormattedValue("c" + ci.getNrCommitedStudentConflicts()));
            }
            if (ci.getNrDistanceStudentConflicts() != 0) {
                if (studentConfs.getNrChunks() <= 1) {
                    studentConfs.add(" (");
                } else {
                    studentConfs.add(",");
                }
                studentConfs.add(this.dispNumber(ci.getNrDistanceStudentConflicts()).setFormattedValue("d" + ci.getNrDistanceStudentConflicts()));
            }
            if (ci.getNrHardStudentConflicts() != 0) {
                if (studentConfs.getNrChunks() <= 1) {
                    studentConfs.add(" (");
                } else {
                    studentConfs.add(",");
                }
                studentConfs.add(this.dispNumber(ci.getNrHardStudentConflicts()).setFormattedValue("h" + ci.getNrHardStudentConflicts()));
            }
            if (studentConfs.getNrChunks() > 1) {
                studentConfs.add(")");
            }
            TableInterface.TableCellRooms rooms = new TableInterface.TableCellRooms();
            if (classAssignmentDetails.getAssignedRoom() != null) {
                for (int i = 0; i < classAssignmentDetails.getAssignedRoom().length; ++i) {
                    rooms.add(classAssignmentDetails.getAssignedRoom()[i].getName(), classAssignmentDetails.getAssignedRoom()[i].getColor(), classAssignmentDetails.getAssignedRoom()[i].getId(), PreferenceLevel.int2string(classAssignmentDetails.getAssignedRoom()[i].getPref()));
                }
            } else if (classAssignmentDetails.getRoom() != null) {
                for (int i = 0; i < classAssignmentDetails.getRoom().length; ++i) {
                    rooms.add(classAssignmentDetails.getRoom()[i].getName(), classAssignmentDetails.getRoom()[i].getColor(), classAssignmentDetails.getRoom()[i].getId(), PreferenceLevel.int2string(classAssignmentDetails.getRoom()[i].getPref()));
                }
            }
            TableInterface.TableCellItems instructors = new TableInterface.TableCellItems();
            if (classAssignmentDetails.getInstructor() != null) {
                for (int i = 0; i < classAssignmentDetails.getInstructor().length; ++i) {
                    instructors.add(classAssignmentDetails.getInstructor()[i].getName(), classAssignmentDetails.getInstructor()[i].getColor(), classAssignmentDetails.getInstructor()[i].getId());
                }
            }
            ClassAssignmentDetails.TimeInfo time = classAssignmentDetails.getAssignedTime() != null ? classAssignmentDetails.getAssignedTime() : classAssignmentDetails.getTime();
            boolean bl2 = bl = solver == null && context.hasPermission(classAssignmentDetails.getClazz().getClassId(), "Class_", Right.ClassDetail);
            if (simple) {
                response.addRow(new TableInterface.TableRowInterface(classAssignmentDetails.getClazz().getClassId(), bl ? "classDetail.action?cid=" + classAssignmentDetails.getClazz().getClassId() : "gwt.jsp?page=suggestions&menu=hide&id=" + classAssignmentDetails.getClazz().getClassId(), bl ? null : MESSAGES.dialogSuggestions(), new TableInterface.TableCellClassName(classAssignmentDetails.getClazz().getName()).setColor(PreferenceLevel.prolog2color(classAssignmentDetails.getClazz().getPref())), new TableInterface.TableCellInterface<String>(time.getDatePatternName()).setColor(PreferenceLevel.int2color(time.getDatePatternPreference())), new TableInterface.TableCellTime(time.getDaysName() + " " + time.getStartTime() + " - " + time.getEndTime()).setOrder(AssignedClassesBackend.getOrder(time)).setId(classAssignmentDetails.getClazz().getClassId() + "," + time.getDays() + "," + time.getStartSlot()).setColor(PreferenceLevel.int2color(time.getPref())), rooms, instructors, studentConfs));
                continue;
            }
            response.addRow(new TableInterface.TableRowInterface(classAssignmentDetails.getClazz().getClassId(), bl ? "classDetail.action?cid=" + classAssignmentDetails.getClazz().getClassId() : "gwt.jsp?page=suggestions&menu=hide&id=" + classAssignmentDetails.getClazz().getClassId(), bl ? null : MESSAGES.dialogSuggestions(), new TableInterface.TableCellClassName(classAssignmentDetails.getClazz().getName()).setColor(PreferenceLevel.prolog2color(classAssignmentDetails.getClazz().getPref())), new TableInterface.TableCellInterface<String>(time.getDatePatternName()).setColor(PreferenceLevel.int2color(time.getDatePatternPreference())), new TableInterface.TableCellTime(time.getDaysName() + " " + time.getStartTime() + " - " + time.getEndTime()).setOrder(AssignedClassesBackend.getOrder(time)).setId(classAssignmentDetails.getClazz().getClassId() + "," + time.getDays() + "," + time.getStartSlot()).setColor(PreferenceLevel.int2color(time.getPref())), rooms, instructors, studentConfs, this.dispNumber(ci.getTimePreference()), this.dispNumber(ci.sumRoomPreference()), this.dispNumber(ci.getGroupConstraintPref()), this.dispNumber(ci.getBtbInstructorPreference()), this.dispNumber(ci.getUselessHalfHours()), this.dispNumber(ci.getTooBigRoomPreference()), this.dispNumber(ci.getDeptBalancPenalty()), this.dispNumber(ci.getSpreadPenalty()), this.dispNumber(ci.getPerturbationPenalty())));
        }
        if (simple) {
            response.setHeader(new TableInterface.TableHeaderIterface(MESSAGES.colClass()), new TableInterface.TableHeaderIterface(MESSAGES.colDate()), new TableInterface.TableHeaderIterface(MESSAGES.colTime()), new TableInterface.TableHeaderIterface(MESSAGES.colRoom()), new TableInterface.TableHeaderIterface(MESSAGES.colInstructor()), new TableInterface.TableHeaderIterface(MESSAGES.colNrStudentConflicts()));
        } else {
            response.setHeader(new TableInterface.TableHeaderIterface(MESSAGES.colClass()), new TableInterface.TableHeaderIterface(MESSAGES.colDate()), new TableInterface.TableHeaderIterface(MESSAGES.colTime()), new TableInterface.TableHeaderIterface(MESSAGES.colRoom()), new TableInterface.TableHeaderIterface(MESSAGES.colInstructor()), new TableInterface.TableHeaderIterface(MESSAGES.colShortStudentConflicts()), new TableInterface.TableHeaderIterface(MESSAGES.colShortTimePref()), new TableInterface.TableHeaderIterface(MESSAGES.colShortRoomPref()), new TableInterface.TableHeaderIterface(MESSAGES.colShortDistPref()), new TableInterface.TableHeaderIterface(MESSAGES.colShortInstructorBtbPref()), new TableInterface.TableHeaderIterface(MESSAGES.colShortUselessHalfHours()), new TableInterface.TableHeaderIterface(MESSAGES.colShortTooBigRooms()), new TableInterface.TableHeaderIterface(MESSAGES.colShortDepartmentBalance()), new TableInterface.TableHeaderIterface(MESSAGES.colShortSameSubpartBalance()), new TableInterface.TableHeaderIterface(MESSAGES.colShortPerturbations()));
        }
        SolverPageBackend.fillSolverWarnings(context, solver, SolverInterface.SolverType.COURSE, response);
        BackTracker.markForBack(context, "gwt.jsp?page=assignedClasses", MESSAGES.pageAssignedClasses(), true, true);
        if (ApplicationProperty.TimeGridShowCrosslists.isTrue()) {
            AssignedClassesBackend.addCrosslistedNames(response, ApplicationProperty.SolverShowClassSufix.isTrue(), ApplicationProperty.SolverShowConfiguratioName.isTrue());
        }
        return response;
    }

    public TableInterface.TableCellInterface dispNumber(int value) {
        return new TableInterface.TableCellInterface<Integer>(value).setColor(value < 0 ? "green" : (value > 0 ? "red" : null));
    }

    public TableInterface.TableCellInterface dispNumber(double value) {
        return new TableInterface.TableCellInterface<Double>(value, sDF.format(value)).setColor(value < 0.0 ? "green" : (value > 0.0 ? "red" : null));
    }

    public static void addCrosslistedNames(TableInterface table, boolean showClassSuffix, boolean showConfigNames) {
        block7: {
            HashMap<Long, TableInterface.TableRowInterface> id2row;
            block6: {
                id2row = new HashMap<Long, TableInterface.TableRowInterface>();
                for (TableInterface.TableRowInterface row : table.getRows()) {
                    if (!row.hasId()) continue;
                    id2row.put(row.getId(), row);
                }
                if (id2row.isEmpty()) {
                    return;
                }
                if (id2row.size() > 1000) break block6;
                for (Object[] o : Class_DAO.getInstance().getSession().createQuery("select c, co from Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where co.isControl = false and c.uniqueId in :classIds order by co.subjectAreaAbbv, co.courseNbr", Object[].class).setParameterList("classIds", id2row.keySet(), Long.class).setCacheable(true).list()) {
                    Class_ clazz = (Class_)o[0];
                    CourseOffering course = (CourseOffering)o[1];
                    TableInterface.TableRowInterface row = (TableInterface.TableRowInterface)id2row.get(clazz.getUniqueId());
                    if (row == null) continue;
                    ((TableInterface.TableCellClassName)row.getCell(0)).addAlternative(clazz.getClassLabel(course, showClassSuffix, showConfigNames));
                }
                break block7;
            }
            ArrayList<Long> ids = new ArrayList<Long>(1000);
            for (Long id : id2row.keySet()) {
                ids.add(id);
                if (ids.size() != 1000) continue;
                for (Object[] o : Class_DAO.getInstance().getSession().createQuery("select c, co from Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where co.isControl = false and c.uniqueId in :classIds order by co.subjectAreaAbbv, co.courseNbr", Object[].class).setParameterList("classIds", ids, Long.class).setCacheable(true).list()) {
                    Class_ clazz = (Class_)o[0];
                    CourseOffering course = (CourseOffering)o[1];
                    TableInterface.TableRowInterface row = (TableInterface.TableRowInterface)id2row.get(clazz.getUniqueId());
                    if (row == null) continue;
                    ((TableInterface.TableCellClassName)row.getCell(0)).addAlternative(clazz.getClassLabel(course, showClassSuffix, showConfigNames));
                }
                ids.clear();
            }
            if (ids.isEmpty()) break block7;
            for (Object[] o : Class_DAO.getInstance().getSession().createQuery("select c, co from Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where co.isControl = false and c.uniqueId in :classIds order by co.subjectAreaAbbv, co.courseNbr", Object[].class).setParameterList("classIds", ids, Long.class).setCacheable(true).list()) {
                Class_ clazz = (Class_)o[0];
                CourseOffering course = (CourseOffering)o[1];
                TableInterface.TableRowInterface row = (TableInterface.TableRowInterface)id2row.get(clazz.getUniqueId());
                if (row == null) continue;
                ((TableInterface.TableCellClassName)row.getCell(0)).addAlternative(clazz.getClassLabel(course, showClassSuffix, showConfigNames));
            }
        }
    }
}

