/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.hql;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseLong;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.SavedHQLInterface;
import org.unitime.timetable.model.SavedHQL;
import org.unitime.timetable.model.SavedHQLParameter;
import org.unitime.timetable.model.dao.SavedHQLDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@GwtRpcImplements(value=SavedHQLInterface.HQLStoreRpcRequest.class)
public class HQLStoreBackend
implements GwtRpcImplementation<SavedHQLInterface.HQLStoreRpcRequest, GwtRpcResponseLong> {
    @Autowired
    private SessionContext sessionContext;

    @Override
    @PreAuthorize(value="(#query.id != null and checkPermission(#query.id, 'SavedHQL', 'HQLReportEdit')) or (#query.id == null and checkPermission('HQLReportAdd'))")
    public GwtRpcResponseLong execute(SavedHQLInterface.HQLStoreRpcRequest query, SessionContext context) {
        if (SavedHQL.Flag.ADMIN_ONLY.isSet(query.getFlags())) {
            this.sessionContext.checkPermission(Right.HQLReportsAdminOnly);
        }
        Session hibSession = SavedHQLDAO.getInstance().getSession();
        SavedHQL hql = null;
        if (query.getId() != null) {
            hql = (SavedHQL)SavedHQLDAO.getInstance().get(query.getId(), hibSession);
        }
        if (hql == null) {
            hql = new SavedHQL();
            hql.setParameters(new HashSet<SavedHQLParameter>());
        }
        hql.setName(query.getName());
        hql.setDescription(query.getDescription());
        hql.setType(query.getFlags());
        hql.setQuery(query.getQuery());
        if (query.hasParameters()) {
            HashMap<String, SavedHQLParameter> params = new HashMap<String, SavedHQLParameter>();
            for (SavedHQLParameter parameter : hql.getParameters()) {
                params.put(parameter.getName(), parameter);
            }
            for (SavedHQLInterface.Parameter p : query.getParameters()) {
                SavedHQLParameter parameter = (SavedHQLParameter)params.remove(p.getName());
                if (parameter == null) {
                    parameter = new SavedHQLParameter();
                    parameter.setName(p.getName());
                    parameter.setSavedHQL(hql);
                    hql.getParameters().add(parameter);
                }
                parameter.setType(p.getType());
                parameter.setLabel(p.getLabel());
                parameter.setDefaultValue(p.getDefaultValue());
            }
            for (SavedHQLParameter parameter : params.values()) {
                hibSession.remove((Object)parameter);
                hql.getParameters().remove(parameter);
            }
        } else {
            Iterator<SavedHQLParameter> i = hql.getParameters().iterator();
            while (i.hasNext()) {
                hibSession.remove((Object)i.next());
                i.remove();
            }
        }
        if (hql.getUniqueId() == null) {
            hibSession.persist((Object)hql);
        } else {
            hibSession.merge((Object)hql);
        }
        hibSession.flush();
        hibSession.refresh((Object)hql);
        return new GwtRpcResponseLong(hql.getUniqueId());
    }
}

