/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.studentsct;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.report.AbstractStudentSectioningReport;
import org.cpsolver.studentsct.reservation.Reservation;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.ReservationInterface;
import org.unitime.timetable.solver.studentsct.StudentSolver;

public class Reservations
extends AbstractStudentSectioningReport {
    protected static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);

    public Reservations(StudentSectioningModel model) {
        super(model);
    }

    public CSVFile createTable(Assignment<Request, Enrollment> assignment, DataProperties properties) {
        CSVFile csv = new CSVFile();
        csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"__Offering"), new CSVFile.CSVField((Object)MESSAGES.colInstructionalOffering().replace("<br>", "\n")), new CSVFile.CSVField((Object)MESSAGES.colReservationType().replace("<br>", "\n")), new CSVFile.CSVField((Object)MESSAGES.colOwner()), new CSVFile.CSVField((Object)MESSAGES.colRestrictions()), new CSVFile.CSVField((Object)MESSAGES.colReservedSpace().replace("<br>", "\n")), new CSVFile.CSVField((Object)MESSAGES.colCurrentEnrollment().replace("<br>", "\n"))});
        ArrayList<Object> reservations = new ArrayList<Object>();
        HashMap studentTable = new HashMap();
        for (Offering offering : this.getModel().getOfferings()) {
            if (offering.isDummy()) continue;
            for (Reservation r : offering.getReservations()) {
                HashSet<Long> studentIds = new HashSet<Long>();
                for (Course course : r.getOffering().getCourses()) {
                    for (CourseRequest cr : course.getRequests()) {
                        if (!r.isApplicable(cr.getStudent()) || !this.matches((Request)cr) || !this.matches(offering.getCourse(cr.getStudent()))) continue;
                        studentIds.add(cr.getStudent().getId());
                    }
                }
                if (studentIds == null || studentIds.isEmpty()) continue;
                int assigned = 0;
                int total = 0;
                for (Enrollment e : r.getEnrollments(assignment)) {
                    ++total;
                    if (!studentIds.contains(e.getStudent().getId())) continue;
                    ++assigned;
                }
                ReservationInterface reservation = StudentSolver.convert(r, this.getModel(), assignment);
                reservation.setEnrollment(assigned);
                reservation.setLastLike(total);
                reservations.add(reservation);
                studentTable.put(reservation.getId(), studentIds);
            }
        }
        Collections.sort(reservations);
        for (ReservationInterface reservationInterface : reservations) {
            ReservationInterface.IdName group;
            ReservationInterface.Course c;
            Set studentIds = (Set)studentTable.get(reservationInterface.getId());
            int total = reservationInterface.getLastLike();
            int assigned = reservationInterface.getEnrollment();
            ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
            line.add(new CSVFile.CSVField((Object)reservationInterface.getOffering().getId()));
            Object course = reservationInterface.getOffering().getAbbv();
            for (ReservationInterface.Course c2 : reservationInterface.getOffering().getCourses()) {
                if (c2.isControl()) continue;
                course = (String)course + "\n  " + c2.getAbbv();
            }
            line.add(new CSVFile.CSVField(course));
            Object flags = "";
            if (reservationInterface.isAllowOverlaps()) {
                flags = (String)flags + "\n  " + MESSAGES.checkCanOverlap();
            }
            if (reservationInterface.isOverLimit()) {
                flags = (String)flags + "\n  " + MESSAGES.checkCanOverLimit();
            }
            if (reservationInterface.isMustBeUsed()) {
                flags = (String)flags + "\n  " + MESSAGES.checkMustBeUsed();
            }
            if (reservationInterface.isExpired()) {
                flags = (String)flags + "\n  " + MESSAGES.checkAllwaysExpired();
            }
            Integer limit = reservationInterface.getReservationLimit();
            if (reservationInterface instanceof ReservationInterface.CourseReservation) {
                line.add(new CSVFile.CSVField((Object)(MESSAGES.reservationCourseAbbv() + (String)flags)));
                c = ((ReservationInterface.CourseReservation)reservationInterface).getCourse();
                limit = c.getLimit();
                line.add(new CSVFile.CSVField((Object)c.getAbbv()));
            } else if (reservationInterface instanceof ReservationInterface.IndividualReservation) {
                if (reservationInterface.isOverride()) {
                    line.add(new CSVFile.CSVField((Object)(MESSAGES.reservationIndividualOverrideAbbv() + (String)flags)));
                } else if (reservationInterface instanceof ReservationInterface.OverrideReservation) {
                    String type = CONSTANTS.reservationOverrideTypeAbbv()[((ReservationInterface.OverrideReservation)reservationInterface).getType().ordinal()];
                    line.add(new CSVFile.CSVField(type == null ? ((ReservationInterface.OverrideReservation)reservationInterface).getType().name() + (String)flags : type));
                } else {
                    line.add(new CSVFile.CSVField((Object)(MESSAGES.reservationIndividualAbbv() + (String)flags)));
                }
                Object students = "";
                if (limit == null) {
                    limit = ((ReservationInterface.IndividualReservation)reservationInterface).getStudents().size();
                }
                for (ReservationInterface.IdName student : ((ReservationInterface.IndividualReservation)reservationInterface).getStudents()) {
                    if (!studentIds.contains(student.getId())) continue;
                    students = (String)students + (((String)students).isEmpty() ? "" : "\n") + student.getName();
                }
                line.add(new CSVFile.CSVField(students));
            } else if (reservationInterface instanceof ReservationInterface.GroupReservation) {
                if (reservationInterface.isOverride()) {
                    line.add(new CSVFile.CSVField((Object)(MESSAGES.reservationStudentGroupOverrideAbbv() + (String)flags)));
                } else {
                    line.add(new CSVFile.CSVField((Object)(MESSAGES.reservationStudentGroupAbbv() + (String)flags)));
                }
                group = ((ReservationInterface.GroupReservation)reservationInterface).getGroup();
                line.add(new CSVFile.CSVField((Object)(group.getAbbv() + " - " + group.getName() + " (" + group.getLimit() + ")")));
            } else if (reservationInterface instanceof ReservationInterface.LCReservation) {
                if (reservationInterface.getOffering().getCourses().size() > 1) {
                    c = ((ReservationInterface.LCReservation)reservationInterface).getCourse();
                    line.add(new CSVFile.CSVField((Object)(MESSAGES.reservationLearningCommunityAbbv() + "\n  " + c.getAbbv() + (String)flags)));
                } else {
                    line.add(new CSVFile.CSVField((Object)(MESSAGES.reservationLearningCommunityAbbv() + (String)flags)));
                }
                group = ((ReservationInterface.LCReservation)reservationInterface).getGroup();
                line.add(new CSVFile.CSVField((Object)(group.getAbbv() + " - " + group.getName() + " (" + group.getLimit() + ")")));
            } else if (reservationInterface instanceof ReservationInterface.CurriculumReservation) {
                if (reservationInterface.isOverride()) {
                    line.add(new CSVFile.CSVField((Object)(MESSAGES.reservationCurriculumOverride() + (String)flags)));
                } else {
                    line.add(new CSVFile.CSVField((Object)(MESSAGES.reservationCurriculumAbbv() + (String)flags)));
                }
                ReservationInterface.Areas curriculum = ((ReservationInterface.CurriculumReservation)reservationInterface).getCurriculum();
                Object owner = "";
                for (ReservationInterface.IdName area : curriculum.getAreas()) {
                    owner = (String)owner + (((String)owner).isEmpty() ? "" : "\n") + area.getAbbv() + " - " + area.getName();
                    for (ReservationInterface.IdName major : curriculum.getMajors()) {
                        if (!area.getId().equals(major.getParentId())) continue;
                        owner = (String)owner + (((String)owner).isEmpty() ? "  " : "\n  ") + major.getAbbv() + " - " + major.getName();
                        for (ReservationInterface.IdName conc : curriculum.getConcentrations()) {
                            if (!major.getId().equals(conc.getParentId())) continue;
                            owner = (String)owner + (((String)owner).isEmpty() ? "    " : "\n    ") + conc.getAbbv() + " - " + conc.getName();
                        }
                    }
                    for (ReservationInterface.IdName minor : curriculum.getMinors()) {
                        if (!area.getId().equals(minor.getParentId())) continue;
                        owner = (String)owner + (((String)owner).isEmpty() ? "  " : "\n  ") + minor.getAbbv() + " - " + minor.getName();
                    }
                }
                boolean firstClasf = true;
                for (ReservationInterface.IdName clasf : curriculum.getClassifications()) {
                    if (curriculum.getAreas().size() == 1) {
                        owner = (String)owner + (((String)owner).isEmpty() ? "  " : "\n  ") + clasf.getAbbv() + " - " + clasf.getName();
                        continue;
                    }
                    if (firstClasf) {
                        owner = (String)owner + (((String)owner).isEmpty() ? "\n" : "\n\n") + clasf.getAbbv() + " - " + clasf.getName();
                        firstClasf = false;
                        continue;
                    }
                    owner = (String)owner + (((String)owner).isEmpty() ? "" : "\n") + clasf.getAbbv() + " - " + clasf.getName();
                }
                for (ReservationInterface.IdName major : curriculum.getMajors()) {
                    if (major.getParentId() != null) continue;
                    owner = (String)owner + (((String)owner).isEmpty() ? "  " : "\n  ") + major.getAbbv() + " - " + major.getName();
                    for (ReservationInterface.IdName conc : curriculum.getConcentrations()) {
                        if (!major.getId().equals(conc.getParentId())) continue;
                        owner = (String)owner + (((String)owner).isEmpty() ? "    " : "\n    ") + conc.getAbbv() + " - " + conc.getName();
                    }
                }
                for (ReservationInterface.IdName minor : curriculum.getMinors()) {
                    if (minor.getParentId() != null) continue;
                    owner = (String)owner + (((String)owner).isEmpty() ? "  " : "\n  ") + minor.getAbbv() + " - " + minor.getName();
                }
                line.add(new CSVFile.CSVField(owner));
            } else if (reservationInterface instanceof ReservationInterface.UniversalReservation) {
                line.add(new CSVFile.CSVField((Object)(MESSAGES.reservationUniversalOverrideAbbv() + (String)flags)));
                String filter = ((ReservationInterface.UniversalReservation)reservationInterface).getFilter();
                line.add(new CSVFile.CSVField((Object)(filter == null ? "" : filter)));
            } else {
                line.add(new CSVFile.CSVField((Object)(MESSAGES.reservationUnknownAbbv() + (String)flags)));
                line.add(new CSVFile.CSVField((Object)""));
            }
            Object restrictions = "";
            for (ReservationInterface.Config config : reservationInterface.getConfigs()) {
                restrictions = (String)restrictions + (((String)restrictions).isEmpty() ? "" : "\n") + MESSAGES.selectionConfiguration(config.getName(), config.getLimit() == null ? MESSAGES.configUnlimited() : config.getLimit().toString());
            }
            for (ReservationInterface.Clazz clazz : reservationInterface.getClasses()) {
                restrictions = (String)restrictions + (((String)restrictions).isEmpty() ? "" : "\n") + clazz.getName() + (String)(clazz.getLimit() == null ? "" : " (" + clazz.getLimit() + ")");
            }
            line.add(new CSVFile.CSVField(restrictions));
            line.add(new CSVFile.CSVField((Object)(limit == null ? "\u221e" : String.valueOf(limit))));
            line.add(new CSVFile.CSVField(assigned < total ? assigned + " / " + total : String.valueOf(assigned)));
            csv.addLine(line);
        }
        return csv;
    }
}

