/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.query.NativeQuery;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.DegreePlanInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CriticalCoursesProvider;
import org.unitime.timetable.onlinesectioning.custom.CustomCourseLookupHolder;
import org.unitime.timetable.onlinesectioning.custom.DegreePlansProvider;
import org.unitime.timetable.onlinesectioning.custom.ExternalTermProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.BannerTermProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.CriticalCoursesFile;
import org.unitime.timetable.onlinesectioning.match.CourseMatcher;
import org.unitime.timetable.onlinesectioning.model.XAreaClassificationMajor;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XStudentId;
import org.unitime.timetable.onlinesectioning.server.DatabaseServer;

public class CriticalCoursesQuery
implements CriticalCoursesProvider,
DegreePlansProvider {
    private static Log sLog = LogFactory.getLog(CriticalCoursesFile.class);
    private ExternalTermProvider iExternalTermProvider;

    public CriticalCoursesQuery() throws ServletException, IOException {
        try {
            String clazz = ApplicationProperty.CustomizationExternalTerm.value();
            this.iExternalTermProvider = clazz == null || clazz.isEmpty() ? new BannerTermProvider() : (ExternalTermProvider)Class.forName(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            sLog.error((Object)"Failed to create external term provider, using the default one instead.", (Throwable)e);
            this.iExternalTermProvider = new BannerTermProvider();
        }
    }

    public String getCatalogYear(OnlineSectioningServer server) {
        return ApplicationProperties.getProperty("banner.dgw.catalogYear." + server.getAcademicSession().getTerm() + server.getAcademicSession().getYear(), ApplicationProperties.getProperty("banner.dgw.catalogYear", this.iExternalTermProvider.getExternalTerm(server.getAcademicSession()).substring(0, 4) + "10"));
    }

    protected String getCriticalCoursesSQL() {
        return ApplicationProperties.getProperty("banner.dgw.criticalCoursesSQL", "select (course_discipline || ' ' || course_number) as course from timetable.tmpl_course_view where is_critical='Y' and tmpl_description not like '%Statewide%' and tmpl_college=:area and tmpl_major=:major and tmpl_catyear=:catyear");
    }

    protected String getCriticalPlaceholdersSQL() {
        return ApplicationProperties.getProperty("banner.dgw.criticalPlaceholdersSQL", "select placeholder_value from timetable.tmpl_placeholder_view where placeholder_value like '%*' and placeholder_type = '" + this.getUccPlaceHolderType() + "' and tmpl_description not like '%Statewide%' and tmpl_college=:area and tmpl_major=:major and tmpl_catyear=:catyear");
    }

    protected boolean getCriticalPlaceHolderAllowPartialMatch() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.dgw.placeHolderPartialMatch", "true"));
    }

    protected String getUccPlaceHolderType() {
        return ApplicationProperties.getProperty("banner.dgw.uccPlaceHolderCodeRegExp", "UNIV-CORE");
    }

    protected String getCriticalPlaceHolderRegExp() {
        return ApplicationProperties.getProperty("banner.dgw.criticalPlaceHolderRegExp", ".* ?\\* ?");
    }

    @Override
    public CriticalCoursesProvider.CriticalCourses getCriticalCourses(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudentId student) {
        return this.getCriticalCourses(server, helper, student, helper.getAction());
    }

    @Override
    public CriticalCoursesProvider.CriticalCourses getCriticalCourses(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudentId studentId, OnlineSectioningLog.Action.Builder action) {
        XStudent student;
        XStudent xStudent = student = studentId instanceof XStudent ? (XStudent)studentId : server.getStudent(studentId.getStudentId());
        if (student == null) {
            return null;
        }
        String catyear = this.getCatalogYear(server);
        String sqlCourses = this.getCriticalCoursesSQL();
        String sqlPlaceholders = this.getCriticalPlaceholdersSQL();
        CriticalCoursesImpl cc = new CriticalCoursesImpl();
        for (XAreaClassificationMajor acm : this.getAreaClasfMajors(server, helper, student)) {
            List placeholders;
            NativeQuery query = helper.getHibSession().createNativeQuery(sqlCourses, String.class);
            query.setParameter("area", (Object)acm.getArea());
            if (action != null) {
                action.addOptionBuilder().setKey("area").setValue(acm.getArea());
            }
            query.setParameter("major", (Object)acm.getMajor());
            if (action != null) {
                action.addOptionBuilder().setKey("major").setValue(acm.getMajor());
            }
            if (sqlCourses.contains(":catyear")) {
                query.setParameter("catyear", (Object)catyear);
                if (action != null) {
                    action.addOptionBuilder().setKey("catyear").setValue(catyear);
                }
            }
            cc.addCourses(query.list());
            if (action != null) {
                action.addOptionBuilder().setKey("critical").setValue(cc.toString());
            }
            if (sqlPlaceholders == null || sqlPlaceholders.isEmpty() || !CustomCourseLookupHolder.hasProvider()) continue;
            query = helper.getHibSession().createNativeQuery(sqlPlaceholders, String.class);
            query.setParameter("area", (Object)acm.getArea());
            query.setParameter("major", (Object)acm.getMajor());
            if (sqlPlaceholders.contains(":catyear")) {
                query.setParameter("catyear", (Object)catyear);
            }
            if ((placeholders = query.list()) != null && !placeholders.isEmpty()) {
                for (String ph : placeholders) {
                    cc.addCourseIds(CustomCourseLookupHolder.getProvider().getCourseIds(server.getAcademicSession(), helper.getHibSession(), ph, this.getCriticalPlaceHolderAllowPartialMatch()));
                }
            }
            if (action == null) continue;
            action.addOptionBuilder().setKey("placeholders").setValue(placeholders.toString());
        }
        return cc;
    }

    @Override
    public void dispose() {
    }

    public CatalogYearTerm[] getCatalogYearTermSequence(OnlineSectioningServer server, XStudent student, XAreaClassificationMajor acm) {
        int seq;
        int firstYear = Integer.parseInt(this.getCatalogYear(server)) / 100;
        int year = Integer.parseInt(this.iExternalTermProvider.getExternalTerm(server.getAcademicSession()).substring(0, 4));
        String term = this.iExternalTermProvider.getExternalTerm(server.getAcademicSession());
        int n = term.endsWith("20") ? 1 : (seq = term.endsWith("30") ? 2 : 0);
        if ("01".equals(acm.getClassification()) || "02".equals(acm.getClassification())) {
            return new CatalogYearTerm[]{new CatalogYearTerm(year, firstYear, seq, true)};
        }
        if ("03".equals(acm.getClassification()) || "04".equals(acm.getClassification())) {
            return new CatalogYearTerm[]{new CatalogYearTerm(year, firstYear, seq, false), new CatalogYearTerm(year - 1, firstYear, seq + 3, true)};
        }
        if ("05".equals(acm.getClassification()) || "06".equals(acm.getClassification())) {
            return new CatalogYearTerm[]{new CatalogYearTerm(year - 0, firstYear, seq, false), new CatalogYearTerm(year - 1, firstYear, seq + 3, false), new CatalogYearTerm(year - 2, firstYear, seq + 6, true)};
        }
        if ("07".equals(acm.getClassification()) || "08".equals(acm.getClassification())) {
            return new CatalogYearTerm[]{new CatalogYearTerm(year - 1, firstYear, seq + 3, false), new CatalogYearTerm(year - 2, firstYear, seq + 6, false), new CatalogYearTerm(year - 3, firstYear, seq + 9, true)};
        }
        if ("09".equals(acm.getClassification()) || "10".equals(acm.getClassification())) {
            return new CatalogYearTerm[]{new CatalogYearTerm(year - 2, firstYear, seq + 6, false), new CatalogYearTerm(year - 3, firstYear, seq + 9, false), new CatalogYearTerm(year - 4, firstYear, seq + 9, true)};
        }
        return new CatalogYearTerm[]{new CatalogYearTerm(year, firstYear, seq, true), new CatalogYearTerm(year - 1, firstYear, seq + 3, false), new CatalogYearTerm(year - 2, firstYear, seq + 6, false), new CatalogYearTerm(year - 3, firstYear, seq + 9, false)};
    }

    protected String getPlannedCoursesSQL() {
        return ApplicationProperties.getProperty("banner.dgw.plannedCoursesSQL", "select tmpl_id, tmpl_description, tmpl_conc, course_discipline, course_number, choice_group_id, trim(is_critical) from timetable.tmpl_course_view where tmpl_description not like '%Statewide%' and tmpl_college=:area and tmpl_major=:major and tmpl_catyear=:catyear and term_seq=:term order by tmpl_conc, choice_group_id desc, course_discipline, course_number");
    }

    protected String getPlannedPlaceholdersSQL() {
        return ApplicationProperties.getProperty("banner.dgw.criticalPlaceholdersSQL", "select tmpl_id, tmpl_description, tmpl_conc, placeholder_type, placeholder_value from timetable.tmpl_placeholder_view where tmpl_description not like '%Statewide%' and tmpl_college=:area and tmpl_major=:major and tmpl_catyear=:catyear and term_seq=:term order by tmpl_conc, placeholder_value");
    }

    protected List<XAreaClassificationMajor> getAreaClasfMajors(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student) {
        return student.getMajors();
    }

    protected DegreePlanInterface.DegreeCourseInterface getCourse(OnlineSectioningServer server, String subjectArea, String courseNbr, boolean critical, CourseMatcher matcher) {
        DegreePlanInterface.DegreeCourseInterface course = new DegreePlanInterface.DegreeCourseInterface();
        course.setSubject(subjectArea);
        course.setCourse(courseNbr);
        course.setId(subjectArea + " " + courseNbr);
        course.setCritical(critical);
        course.setSelected(false);
        Collection<? extends XCourseId> ids = server.findCourses(subjectArea + " " + courseNbr, -1, matcher);
        if (ids != null) {
            for (XCourseId xCourseId : ids) {
                Serializable io;
                XCourse xc = xCourseId instanceof XCourse ? (XCourse)xCourseId : server.getCourse(xCourseId.getCourseId());
                if (xc == null || !xCourseId.getCourseName().startsWith(subjectArea + " " + courseNbr)) continue;
                if (course.getTitle() == null || xCourseId.getCourseName().equals(subjectArea + " " + courseNbr)) {
                    course.setTitle(xc.getTitle());
                }
                ClassAssignmentInterface.CourseAssignment ca = new ClassAssignmentInterface.CourseAssignment();
                ca.setCourseId(xc.getCourseId());
                ca.setSubject(xc.getSubjectArea());
                ca.setCourseNbr(xc.getCourseNumber());
                ca.setTitle(xc.getTitle());
                ca.setNote(xc.getNote());
                ca.setCreditAbbv(xc.getCreditAbbv());
                ca.setCreditText(xc.getCreditText());
                ca.setTitle(xc.getTitle());
                ca.setHasUniqueName(xc.hasUniqueName());
                ca.setLimit(xc.getLimit());
                int firstChoiceReqs = 0;
                int enrl = 0;
                Collection<XCourseRequest> requests = server.getRequests(xCourseId.getOfferingId());
                if (requests != null) {
                    for (XCourseRequest r : requests) {
                        if (r.getEnrollment() != null && r.getEnrollment().getCourseId().equals(xCourseId.getCourseId())) {
                            ++enrl;
                        }
                        if (r.isAlternative() || r.getEnrollment() != null || !r.getCourseIds().get(0).equals(xCourseId)) continue;
                        ++firstChoiceReqs;
                    }
                }
                ca.setEnrollment(enrl);
                ca.setProjected(firstChoiceReqs);
                if (server instanceof DatabaseServer) {
                    io = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(xCourseId.getOfferingId());
                    ca.setCanWaitList(io != null && ((InstructionalOffering)io).effectiveWaitList());
                } else {
                    io = server.getOffering(xCourseId.getOfferingId());
                    ca.setCanWaitList(io != null && ((XOffering)io).isWaitList());
                }
                course.addCourse(ca);
            }
        }
        if (course.hasCourses()) {
            for (ClassAssignmentInterface.CourseAssignment courseAssignment : course.getCourses()) {
                if (!courseAssignment.getSubject().equals(course.getSubject()) || !courseAssignment.getCourseNbr().equals(course.getCourse())) continue;
                course.setCourseId(courseAssignment.getCourseId());
            }
        }
        return course;
    }

    protected List<XCourse> getPlaceHolderCourses(OnlineSectioningServer server, OnlineSectioningHelper helper, String phType, String phName, CourseMatcher matcher) {
        if (!CustomCourseLookupHolder.hasProvider()) {
            return null;
        }
        if (phType == null || !phType.matches(this.getUccPlaceHolderType())) {
            return null;
        }
        List<XCourse> courses = CustomCourseLookupHolder.getProvider().getCourses(server, helper, phName, this.getCriticalPlaceHolderAllowPartialMatch());
        if (matcher == null || courses == null || courses.isEmpty()) {
            return courses;
        }
        ArrayList<XCourse> ret = new ArrayList<XCourse>();
        for (XCourse course : courses) {
            if (!matcher.match(course)) continue;
            ret.add(course);
        }
        return ret;
    }

    protected boolean isCriticalPlaceholder(String phValue) {
        return phValue != null && phValue.matches(this.getCriticalPlaceHolderRegExp());
    }

    @Override
    public List<DegreePlanInterface> getDegreePlans(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, CourseMatcher matcher) throws SectioningException {
        String sqlCourses = this.getPlannedCoursesSQL();
        String sqlPlaceholders = this.getPlannedPlaceholdersSQL();
        OnlineSectioningLog.Action.Builder action = helper.getAction();
        HashMap<CallSite, DegreePlanInterface> plans = new HashMap<CallSite, DegreePlanInterface>();
        for (XAreaClassificationMajor acm : this.getAreaClasfMajors(server, helper, student)) {
            for (CatalogYearTerm cyt : this.getCatalogYearTermSequence(server, student, acm)) {
                String progConc;
                String progName;
                String progCode;
                if (cyt == null) continue;
                String catyear = cyt.getCatalogYear();
                int term = cyt.getTermSequence();
                if (catyear == null) continue;
                NativeQuery query = helper.getHibSession().createNativeQuery(sqlCourses, Object[].class);
                query.setParameter("area", (Object)acm.getArea());
                if (action != null) {
                    action.addOptionBuilder().setKey("area").setValue(acm.getArea());
                }
                query.setParameter("major", (Object)acm.getMajor());
                if (action != null) {
                    action.addOptionBuilder().setKey("major").setValue(acm.getMajor());
                }
                if (sqlCourses.contains(":catyear")) {
                    query.setParameter("catyear", (Object)catyear);
                    if (action != null) {
                        action.addOptionBuilder().setKey("catyear").setValue(catyear);
                    }
                }
                if (sqlCourses.contains(":term")) {
                    query.setParameter("term", (Object)term);
                    if (action != null) {
                        action.addOptionBuilder().setKey("term").setValue(String.valueOf(term));
                    }
                }
                for (Object[] o : query.list()) {
                    progCode = (String)o[0] + ":" + cyt.getCatalogYear() + ":" + cyt.getTermSequence();
                    progName = (String)o[1];
                    progConc = (String)o[2];
                    String subject = (String)o[3];
                    String courseNbr = (String)o[4];
                    String choiceGroupId = (String)o[5];
                    boolean isCritical = "Y".equals(o[6]);
                    DegreePlanInterface plan = (DegreePlanInterface)plans.get(progCode);
                    if (plan == null) {
                        plan = new DegreePlanInterface();
                        plan.setId(progCode);
                        plan.setName(progName + " (" + cyt.getYear() + ")");
                        plan.setSchool(acm.getArea());
                        plan.setDegree(acm.getMajor());
                        plan.setGroup(new DegreePlanInterface.DegreeGroupInterface());
                        plan.getGroup().setChoice(false);
                        if (progConc != null && !progConc.isEmpty()) {
                            plan.setDegree(acm.getMajor() + "/" + progConc);
                        } else {
                            plan.setActive(cyt.isActive());
                        }
                        plans.put((CallSite)((Object)progCode), plan);
                    }
                    if (choiceGroupId == null || choiceGroupId.isEmpty()) {
                        plan.getGroup().addCourse(this.getCourse(server, subject, courseNbr, isCritical, matcher));
                        continue;
                    }
                    DegreePlanInterface.DegreeGroupInterface group = plan.getGroup().getGroup(choiceGroupId);
                    if (group == null) {
                        group = new DegreePlanInterface.DegreeGroupInterface();
                        group.setChoice(true);
                        group.setId(choiceGroupId);
                        group.setCritical(isCritical);
                        plan.getGroup().addGroup(group);
                    }
                    group.addCourse(this.getCourse(server, subject, courseNbr, isCritical, matcher));
                }
                if (sqlPlaceholders == null || sqlPlaceholders.isEmpty()) continue;
                query = helper.getHibSession().createNativeQuery(sqlPlaceholders, Object[].class);
                query.setParameter("area", (Object)acm.getArea());
                query.setParameter("major", (Object)acm.getMajor());
                if (sqlCourses.contains(":catyear")) {
                    query.setParameter("catyear", (Object)catyear);
                }
                if (sqlPlaceholders.contains(":term")) {
                    query.setParameter("term", (Object)term);
                }
                for (Object[] o : query.list()) {
                    List<XCourse> phc;
                    progCode = (String)o[0] + ":" + cyt.getCatalogYear() + ":" + cyt.getTermSequence();
                    progName = (String)o[1];
                    progConc = (String)o[2];
                    String placType = (String)o[3];
                    String placName = (String)o[4];
                    DegreePlanInterface plan = (DegreePlanInterface)plans.get(progCode);
                    if (plan == null) {
                        plan = new DegreePlanInterface();
                        plan.setId(progCode);
                        plan.setName(progName + " (" + cyt.getYear() + ")");
                        plan.setSchool(acm.getArea());
                        plan.setDegree(acm.getMajor());
                        plan.setGroup(new DegreePlanInterface.DegreeGroupInterface());
                        plan.getGroup().setChoice(false);
                        if (progConc != null && !progConc.isEmpty()) {
                            plan.setDegree(acm.getMajor() + "/" + progConc);
                        } else {
                            plan.setActive(true);
                        }
                        plans.put((CallSite)((Object)progCode), plan);
                    }
                    if ((phc = this.getPlaceHolderCourses(server, helper, placType, placName, matcher)) != null && !phc.isEmpty()) {
                        DegreePlanInterface.DegreeGroupInterface phg = new DegreePlanInterface.DegreeGroupInterface();
                        phg.setChoice(true);
                        phg.setPlaceHolder(true);
                        phg.setDescription(placName);
                        phg.setId(placName);
                        phg.setCritical(this.isCriticalPlaceholder(placName));
                        DegreePlanInterface.DegreeCourseInterface course = null;
                        for (XCourse xc : phc) {
                            Serializable io;
                            if (course == null || !course.getSubject().equals(xc.getSubjectArea()) || !xc.getCourseNumber().startsWith(course.getCourse())) {
                                course = new DegreePlanInterface.DegreeCourseInterface();
                                course.setSubject(this.iExternalTermProvider.getExternalSubject(server.getAcademicSession(), xc.getSubjectArea(), xc.getCourseNumber()));
                                course.setCourse(this.iExternalTermProvider.getExternalCourseNumber(server.getAcademicSession(), xc.getSubjectArea(), xc.getCourseNumber()));
                                course.setTitle(xc.getTitle());
                                course.setId(placName + "-" + xc.getCourseId());
                                course.setCourseId(xc.getCourseId());
                                course.setSelected(false);
                                phg.addCourse(course);
                            }
                            ClassAssignmentInterface.CourseAssignment ca = new ClassAssignmentInterface.CourseAssignment();
                            ca.setCourseId(xc.getCourseId());
                            ca.setSubject(xc.getSubjectArea());
                            ca.setCourseNbr(xc.getCourseNumber());
                            ca.setTitle(xc.getTitle());
                            ca.setNote(xc.getNote());
                            ca.setCreditAbbv(xc.getCreditAbbv());
                            ca.setCreditText(xc.getCreditText());
                            ca.setTitle(xc.getTitle());
                            ca.setHasUniqueName(xc.hasUniqueName());
                            ca.setLimit(xc.getLimit());
                            int firstChoiceReqs = 0;
                            int enrl = 0;
                            Collection<XCourseRequest> requests = server.getRequests(xc.getOfferingId());
                            if (requests != null) {
                                for (XCourseRequest r : requests) {
                                    if (r.getEnrollment() != null && r.getEnrollment().getCourseId().equals(xc.getCourseId())) {
                                        ++enrl;
                                    }
                                    if (r.isAlternative() || r.getEnrollment() != null || !r.getCourseIds().get(0).equals(xc)) continue;
                                    ++firstChoiceReqs;
                                }
                            }
                            ca.setEnrollment(enrl);
                            ca.setProjected(firstChoiceReqs);
                            if (server instanceof DatabaseServer) {
                                io = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(xc.getOfferingId());
                                ca.setCanWaitList(io != null && ((InstructionalOffering)io).effectiveWaitList());
                            } else {
                                io = server.getOffering(xc.getOfferingId());
                                ca.setCanWaitList(io != null && ((XOffering)io).isWaitList());
                            }
                            course.addCourse(ca);
                        }
                        plan.getGroup().addGroup(phg);
                        continue;
                    }
                    DegreePlanInterface.DegreePlaceHolderInterface placeholder = new DegreePlanInterface.DegreePlaceHolderInterface();
                    placeholder.setType(placType);
                    placeholder.setName(placName);
                    plan.getGroup().addPlaceHolder(placeholder);
                }
            }
        }
        ArrayList<DegreePlanInterface> ret = new ArrayList<DegreePlanInterface>(plans.values());
        Collections.sort(ret, new Comparator<DegreePlanInterface>(){

            @Override
            public int compare(DegreePlanInterface p1, DegreePlanInterface p2) {
                return p1.getName().compareToIgnoreCase(p2.getName());
            }
        });
        if (action != null) {
            for (DegreePlanInterface plan : ret) {
                Object value = "";
                if (plan.getGroup().hasCourses()) {
                    for (DegreePlanInterface.DegreeCourseInterface c : plan.getGroup().getCourses()) {
                        value = (String)value + (((String)value).isEmpty() ? "" : "\n") + c.getCourseName();
                    }
                }
                if (plan.getGroup().hasGroups()) {
                    for (DegreePlanInterface.DegreeGroupInterface g : plan.getGroup().getGroups()) {
                        value = (String)value + (((String)value).isEmpty() ? "" : "\n") + String.valueOf(g);
                    }
                }
                if (plan.getGroup().hasPlaceHolders()) {
                    for (DegreePlanInterface.DegreePlaceHolderInterface p : plan.getGroup().getPlaceHolders()) {
                        value = (String)value + (((String)value).isEmpty() ? "" : "\n") + p.getName();
                    }
                }
                if (plan.isActive()) {
                    helper.info((String)value);
                }
                action.addOptionBuilder().setKey(plan.getDegree()).setValue((String)value);
            }
        }
        return ret;
    }

    protected static class CriticalCoursesImpl
    implements CriticalCoursesProvider.CriticalCourses {
        private Set<String> iCriticalCourses = new TreeSet<String>();
        private Set<Long> iCourseIds = new HashSet<Long>();

        protected CriticalCoursesImpl() {
        }

        public void addCourses(Collection<String> courses) {
            if (courses != null && !courses.isEmpty()) {
                this.iCriticalCourses.addAll(courses);
            }
        }

        public void addCourseIds(Collection<Long> courseIds) {
            if (courseIds != null && !courseIds.isEmpty()) {
                this.iCourseIds.addAll(courseIds);
            }
        }

        @Override
        public boolean isEmpty() {
            return this.iCriticalCourses.isEmpty() && this.iCourseIds.isEmpty();
        }

        @Override
        public int isCritical(CourseOffering course) {
            if (this.iCourseIds.contains(course.getUniqueId())) {
                return CourseDemand.Critical.IMPORTANT.ordinal();
            }
            for (String c : this.iCriticalCourses) {
                if (!course.getCourseName().startsWith(c)) continue;
                return CourseDemand.Critical.IMPORTANT.ordinal();
            }
            return CourseDemand.Critical.NORMAL.ordinal();
        }

        @Override
        public int isCritical(XCourseId course) {
            if (this.iCourseIds.contains(course.getCourseId())) {
                return CourseDemand.Critical.IMPORTANT.ordinal();
            }
            for (String c : this.iCriticalCourses) {
                if (!course.getCourseName().startsWith(c)) continue;
                return CourseDemand.Critical.IMPORTANT.ordinal();
            }
            return CourseDemand.Critical.NORMAL.ordinal();
        }

        public String toString() {
            return this.iCriticalCourses.toString();
        }
    }

    static class CatalogYearTerm {
        private String iCatalogYear;
        private int iTermSequence;
        private boolean iActive;

        CatalogYearTerm(int year, int firstYear, int term, boolean active) {
            this.iCatalogYear = Math.min(year, firstYear) + "10";
            this.iTermSequence = term;
            this.iActive = active;
        }

        public String getCatalogYear() {
            return this.iCatalogYear;
        }

        public int getTermSequence() {
            return this.iTermSequence;
        }

        public boolean isActive() {
            return this.iActive;
        }

        public String getYear() {
            int year = 1 + this.iTermSequence / 3;
            switch (this.iTermSequence % 3) {
                case 0: {
                    return (String)(year == 1 ? "1st" : (year == 2 ? "2nd" : (year == 3 ? "3rd" : year + "th"))) + " Fall";
                }
                case 1: {
                    return (String)(year == 1 ? "1st" : (year == 2 ? "2nd" : (year == 3 ? "3rd" : year + "th"))) + " Spring";
                }
                case 2: {
                    return (String)(year == 1 ? "1st" : (year == 2 ? "2nd" : (year == 3 ? "3rd" : year + "th"))) + " Summer";
                }
            }
            return (String)(year == 1 ? "1st" : (year == 2 ? "2nd" : (year == 3 ? "3rd" : year + "th"))) + " Year";
        }
    }
}

