/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.Roles;

@MappedSuperclass
public abstract class BaseRoles
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iRoleId;
    private String iReference;
    private String iAbbv;
    private Boolean iManager;
    private Boolean iEnabled;
    private Boolean iInstructor;
    private Set<String> iRights;

    public BaseRoles() {
    }

    public BaseRoles(Long roleId) {
        this.setRoleId(roleId);
    }

    @Id
    @UniqueIdGenerator(sequence="role_seq")
    @Column(name="role_id")
    public Long getRoleId() {
        return this.iRoleId;
    }

    public void setRoleId(Long roleId) {
        this.iRoleId = roleId;
    }

    @Column(name="reference", nullable=false, length=20)
    public String getReference() {
        return this.iReference;
    }

    public void setReference(String reference) {
        this.iReference = reference;
    }

    @Column(name="abbv", nullable=false, length=40)
    public String getAbbv() {
        return this.iAbbv;
    }

    public void setAbbv(String abbv) {
        this.iAbbv = abbv;
    }

    @Column(name="manager", nullable=false)
    public Boolean isManager() {
        return this.iManager;
    }

    @Transient
    public Boolean getManager() {
        return this.iManager;
    }

    public void setManager(Boolean manager) {
        this.iManager = manager;
    }

    @Column(name="enabled", nullable=false)
    public Boolean isEnabled() {
        return this.iEnabled;
    }

    @Transient
    public Boolean getEnabled() {
        return this.iEnabled;
    }

    public void setEnabled(Boolean enabled) {
        this.iEnabled = enabled;
    }

    @Column(name="instructor", nullable=false)
    public Boolean isInstructor() {
        return this.iInstructor;
    }

    @Transient
    public Boolean getInstructor() {
        return this.iInstructor;
    }

    public void setInstructor(Boolean instructor) {
        this.iInstructor = instructor;
    }

    @ElementCollection
    @CollectionTable(name="rights", joinColumns={@JoinColumn(name="role_id")})
    @Column(name="value")
    public Set<String> getRights() {
        return this.iRights;
    }

    public void setRights(Set<String> rights) {
        this.iRights = rights;
    }

    public void addToRights(String string) {
        if (this.iRights == null) {
            this.iRights = new HashSet<String>();
        }
        this.iRights.add(string);
    }

    @Deprecated
    public void addTorights(String string) {
        this.addToRights(string);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Roles)) {
            return false;
        }
        if (this.getRoleId() == null || ((Roles)o).getRoleId() == null) {
            return false;
        }
        return this.getRoleId().equals(((Roles)o).getRoleId());
    }

    public int hashCode() {
        if (this.getRoleId() == null) {
            return super.hashCode();
        }
        return this.getRoleId().hashCode();
    }

    public String toString() {
        return "Roles[" + this.getRoleId() + "]";
    }

    public String toDebugString() {
        return "Roles[\n\tAbbv: " + this.getAbbv() + "\n\tEnabled: " + this.getEnabled() + "\n\tInstructor: " + this.getInstructor() + "\n\tManager: " + this.getManager() + "\n\tReference: " + this.getReference() + "\n\tRoleId: " + this.getRoleId() + "]";
    }
}

