/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.List;
import java.util.StringTokenizer;
import org.hibernate.HibernateException;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BaseRoomGroup;
import org.unitime.timetable.model.dao.RoomGroupDAO;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="room_group")
public class RoomGroup
extends BaseRoomGroup
implements Comparable {
    private static final long serialVersionUID = 1L;
    public static String GROUP_LIST_ATTR_NAME = "roomGroupsList";

    public RoomGroup() {
    }

    public RoomGroup(Long uniqueId) {
        super(uniqueId);
    }

    @Transient
    public static List<RoomGroup> getAllRoomGroups() throws HibernateException {
        return RoomGroupDAO.getInstance().getSession().createQuery("from RoomGroup order by name", RoomGroup.class).setCacheable(true).list();
    }

    public static List<RoomGroup> getAllGlobalRoomGroups(Long sessionId) throws HibernateException {
        return RoomGroupDAO.getInstance().getSession().createQuery("from RoomGroup g where g.global = true and g.session.uniqueId = :sessionId order by name", RoomGroup.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list();
    }

    public static List<RoomGroup> getAllGlobalRoomGroups(Session session) throws HibernateException {
        return RoomGroup.getAllGlobalRoomGroups(session.getUniqueId());
    }

    public static RoomGroup findGlobalRoomGroupForName(Session session, String name) {
        return (RoomGroup)RoomGroupDAO.getInstance().getSession().createQuery("from RoomGroup where global = true and name = :name and session.uniqueId = :sessionId", RoomGroup.class).setParameter("name", (Object)name).setParameter("sessionId", (Object)session.getUniqueId()).setCacheable(true).setMaxResults(1).uniqueResult();
    }

    public static RoomGroup getGlobalDefaultRoomGroup(Long sessionId) {
        List groups = RoomGroupDAO.getInstance().getSession().createQuery("from RoomGroup g where g.global = true and g.session.uniqueId = :sessionId and g.defaultGroup = true order by name", RoomGroup.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list();
        return groups.isEmpty() ? null : (RoomGroup)groups.get(0);
    }

    public static RoomGroup getGlobalDefaultRoomGroup(Session session) {
        return RoomGroup.getGlobalDefaultRoomGroup(session.getUniqueId());
    }

    public static List<RoomGroup> getAllDepartmentRoomGroups(Department dept) {
        return RoomGroupDAO.getInstance().getSession().createQuery("from RoomGroup g where g.global = false and g.department.uniqueId = :deptId order by name", RoomGroup.class).setParameter("deptId", (Object)dept.getUniqueId()).setCacheable(true).list();
    }

    public static List<RoomGroup> getAllRoomGroupsForSession(Long sessionId) {
        return RoomGroupDAO.getInstance().getSession().createQuery("from RoomGroup g where g.session.uniqueId = :sessionId order by name", RoomGroup.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list();
    }

    public static List<RoomGroup> getAllRoomGroupsForSession(Session session) {
        return RoomGroup.getAllRoomGroupsForSession(session.getUniqueId());
    }

    public int compareTo(Object o) {
        int cmp;
        if (o == null || !(o instanceof RoomGroup)) {
            return -1;
        }
        RoomGroup rg = (RoomGroup)o;
        int n = this.isGlobal().booleanValue() == rg.isGlobal().booleanValue() ? 0 : (cmp = this.isGlobal() != false ? -1 : 1);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.getName().compareTo(rg.getName());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? Long.valueOf(-1L) : this.getUniqueId()).compareTo(rg.getUniqueId() == null ? -1L : rg.getUniqueId());
    }

    public boolean hasLocation(Location location) {
        return this.getRooms().contains(location);
    }

    public String htmlLabel() {
        return "<span " + (String)(this.isGlobal() != false ? "" : "style='color:#" + this.getDepartment().getRoomSharingColor(null) + ";font-weight:bold;' ") + "title='" + this.getName() + " (" + (this.isGlobal() != false ? "global" : (this.getDepartment().isExternalManager() != false ? this.getDepartment().getExternalMgrLabel() : this.getDepartment().getName())) + ")'>" + this.getName() + "</span>";
    }

    @Transient
    public String getNameWithTitle() {
        return this.getName() + (this.isGlobal() != null && this.isGlobal() != false ? "" : " (Department)");
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public Object clone() {
        RoomGroup newRoomGroup = new RoomGroup();
        newRoomGroup.setDefaultGroup(this.isDefaultGroup());
        newRoomGroup.setDepartment(this.getDepartment());
        newRoomGroup.setDescription(this.getDescription());
        newRoomGroup.setGlobal(this.isGlobal());
        newRoomGroup.setName(this.getName());
        newRoomGroup.setAbbv(this.getAbbv());
        newRoomGroup.setSession(this.getSession());
        return newRoomGroup;
    }

    public RoomGroup findSameRoomGroupInSession(Session session) {
        Department d;
        if (session == null) {
            return null;
        }
        if (this.isGlobal().booleanValue()) {
            return (RoomGroup)RoomGroupDAO.getInstance().getSession().createQuery("from RoomGroup where global = true and name = :name and session.uniqueId = :sessionId", RoomGroup.class).setParameter("name", (Object)this.getName()).setParameter("sessionId", (Object)session.getUniqueId()).setMaxResults(1).setCacheable(true).uniqueResult();
        }
        Department department = d = this.getDepartment() == null ? null : this.getDepartment().findSameDepartmentInSession(session);
        if (d != null) {
            return (RoomGroup)RoomGroupDAO.getInstance().getSession().createQuery("from RoomGroup where global = false and name = :name and department.uniqueId = :deptId", RoomGroup.class).setParameter("name", (Object)this.getName()).setParameter("deptId", (Object)d.getUniqueId()).setMaxResults(1).setCacheable(true).uniqueResult();
        }
        return null;
    }

    @Override
    @Transient
    public String getAbbv() {
        if (super.getAbbv() != null && super.getAbbv().trim().length() > 0) {
            return super.getAbbv();
        }
        StringBuffer sb = new StringBuffer();
        StringTokenizer stk = new StringTokenizer(this.getName(), " ");
        while (stk.hasMoreTokens()) {
            String word = stk.nextToken();
            if ("and".equalsIgnoreCase(word)) {
                sb.append("&amp;");
                continue;
            }
            if (word.replaceAll("[a-zA-Z\\.]*", "").length() == 0) {
                for (int i = 0; i < word.length(); ++i) {
                    if (i == 0) {
                        sb.append(word.substring(i, i + 1).toUpperCase());
                        continue;
                    }
                    if ((i != 1 || word.length() <= 3) && (word.charAt(i) < 'A' || word.charAt(i) > 'Z')) continue;
                    sb.append(word.charAt(i));
                }
                continue;
            }
            sb.append(word);
        }
        return sb.toString();
    }
}

