/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Days;
import org.joda.time.Hours;
import org.joda.time.Minutes;
import org.joda.time.Months;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.model.base.BaseQueryLog;
import org.unitime.timetable.model.dao.QueryLogDAO;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="query_log")
public class QueryLog
extends BaseQueryLog {
    private static final long serialVersionUID = 7073111443207707716L;
    protected static Log sLog = LogFactory.getLog(QueryLog.class);
    private static String sExtendedEncoding = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-.";
    private static int sExtendedEncodingMax = sExtendedEncoding.length() * sExtendedEncoding.length();

    public static int getNrSessions(int days) {
        Calendar c = Calendar.getInstance(Locale.US);
        c.setTime(new Date());
        c.add(6, -days);
        return ((Number)QueryLogDAO.getInstance().getSession().createQuery("select count(distinct q.sessionId) from QueryLog q where q.timeStamp > :date", Number.class).setParameter("date", (Object)c.getTime()).uniqueResult()).intValue();
    }

    public static int getNrActiveUsers(int days) {
        Calendar c = Calendar.getInstance(Locale.US);
        c.setTime(new Date());
        c.add(6, -days);
        return ((Number)QueryLogDAO.getInstance().getSession().createQuery("select count(distinct q.uid) from QueryLog q where q.timeStamp > :date", Number.class).setParameter("date", (Object)c.getTime()).uniqueResult()).intValue();
    }

    public static WebTable getTopQueries(int days) {
        Calendar c = Calendar.getInstance(Locale.US);
        c.setTime(new Date());
        c.add(6, -days);
        WebTable table = new WebTable(8, "Page Statistics (last " + days + " days)", "stats.action?ord=%%", new String[]{"URI", "Calls", "Calls [>10ms]", "Calls [>100ms]", "Calls [>1min]", "AvgTime [ms]", "MaxTime [s]", "Errors"}, new String[]{"left", "right", "right", "right", "right", "right", "right", "right"}, new boolean[]{true, false, false, false, false, false, false, false});
        DecimalFormat df = new DecimalFormat("#,##0.00");
        HashMap<String, Integer> errors = new HashMap<String, Integer>();
        for (Object o : QueryLogDAO.getInstance().getSession().createQuery("select q.uri, count(q) from QueryLog q where q.timeStamp > :date and q.exception is not null group by q.uri", Object[].class).setParameter("date", (Object)c.getTime()).list()) {
            errors.put((String)o[0], ((Number)o[1]).intValue());
        }
        HashMap<String, Integer> overMinutes = new HashMap<String, Integer>();
        for (Object o : QueryLogDAO.getInstance().getSession().createQuery("select q.uri, count(q) from QueryLog q where q.timeStamp > :date and q.timeSpent > 1000 group by q.uri", Object[].class).setParameter("date", (Object)c.getTime()).list()) {
            overMinutes.put((String)o[0], ((Number)o[1]).intValue());
        }
        HashMap<String, Integer> over100mss = new HashMap<String, Integer>();
        for (Object[] o : QueryLogDAO.getInstance().getSession().createQuery("select q.uri, count(q) from QueryLog q where q.timeStamp > :date and q.timeSpent > 100 group by q.uri", Object[].class).setParameter("date", (Object)c.getTime()).list()) {
            over100mss.put((String)o[0], ((Number)o[1]).intValue());
        }
        HashMap<String, Integer> over10mss = new HashMap<String, Integer>();
        for (Object[] o : QueryLogDAO.getInstance().getSession().createQuery("select q.uri, count(q) from QueryLog q where q.timeStamp > :date and q.timeSpent > 10 group by q.uri", Object[].class).setParameter("date", (Object)c.getTime()).list()) {
            over10mss.put((String)o[0], ((Number)o[1]).intValue());
        }
        for (Object[] o : QueryLogDAO.getInstance().getSession().createQuery("select q.uri, count(q), avg(q.timeSpent), max(q.timeSpent) from QueryLog q where q.timeStamp > :date group by q.uri", Object[].class).setParameter("date", (Object)c.getTime()).list()) {
            Integer over10ms;
            Integer over100ms;
            Integer overMinute;
            Integer nrErrors = (Integer)errors.get((String)o[0]);
            if (nrErrors == null) {
                nrErrors = 0;
            }
            if ((overMinute = (Integer)overMinutes.get((String)o[0])) == null) {
                overMinute = 0;
            }
            if ((over100ms = (Integer)over100mss.get((String)o[0])) == null) {
                over100ms = 0;
            }
            if ((over10ms = (Integer)over10mss.get((String)o[0])) == null) {
                over10ms = 0;
            }
            table.addLine(new String[]{(String)o[0], ((Number)o[1]).toString(), over10ms.toString(), over100ms.toString(), overMinute.toString(), df.format(((Number)o[2]).doubleValue()), df.format(((Number)o[3]).doubleValue() / 1000.0), nrErrors.toString()}, new Comparable[]{(String)o[0], Integer.valueOf(((Number)o[1]).intValue()), over10ms, over100ms, overMinute, Double.valueOf(((Number)o[2]).doubleValue()), Double.valueOf(((Number)o[3]).doubleValue()), nrErrors});
        }
        return table;
    }

    private static String encode(List<Double> data, double max) {
        StringBuffer ret = new StringBuffer();
        for (Double val : data) {
            int scaled = (int)Math.floor((double)sExtendedEncodingMax * val / max);
            if (scaled >= sExtendedEncodingMax) {
                ret.append("..");
                continue;
            }
            if (scaled < 0) {
                ret.append("__");
                continue;
            }
            ret.append(sExtendedEncoding.charAt(scaled / sExtendedEncoding.length()));
            ret.append(sExtendedEncoding.charAt(scaled % sExtendedEncoding.length()));
        }
        return ret.toString();
    }

    public static String getChart(ChartWindow w, ChartType t) {
        DateTime now = DateTime.now();
        String axe = w.axe(now);
        DateTime dt = w.getFirst(now);
        List[] data = new List[]{new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList()};
        double[] max = new double[]{0.0, 0.0};
        if (t == ChartType.USERS) {
            Map<String, int[]> queries = w.getQueriesPerType(QueryLogDAO.getInstance().getSession());
            Map<String, int[]> usersAndSessions = w.getUsersAndSessions(QueryLogDAO.getInstance().getSession());
            while (dt != null) {
                double[] us = w.countUsers(usersAndSessions, dt);
                int[] q = w.countQueries(queries, dt);
                double users = us[0];
                data[0].add(users);
                double sessions = us[1];
                data[1].add(sessions);
                max[0] = Math.max(max[0], Math.max(users, sessions));
                double calls = (double)(q[Type.STRUCTS.ordinal()] + q[Type.OTHER.ordinal()]) / (double)w.getMinutes();
                double gwtCalls = (double)(q[Type.GWT.ordinal()] + q[Type.RPC.ordinal()]) / (double)w.getMinutes();
                data[2].add(calls);
                data[3].add(gwtCalls);
                max[1] = Math.max(max[1], Math.max(calls, gwtCalls));
                dt = w.next(dt, now);
            }
            sLog.debug((Object)("[" + w.name() + "] Users: " + max[0] + " / " + String.valueOf(data[0])));
            sLog.debug((Object)("[" + w.name() + "] Sessions: " + max[0] + " / " + String.valueOf(data[1])));
            sLog.debug((Object)("[" + w.name() + "] Calls: " + max[1] + " / " + String.valueOf(data[2])));
            sLog.debug((Object)("[" + w.name() + "] GWT: " + max[1] + " / " + String.valueOf(data[3])));
        } else {
            Map<String, double[]> times = w.getTimes(QueryLogDAO.getInstance().getSession());
            while (dt != null) {
                double[] tm = w.countTimes(times, dt);
                double sumTime = tm[3 * Type.STRUCTS.ordinal()] + tm[3 * Type.OTHER.ordinal()];
                double cntTime = tm[3 * Type.STRUCTS.ordinal() + 1] + tm[3 * Type.OTHER.ordinal() + 1];
                double avgTime = cntTime > 0.0 ? sumTime / cntTime : 0.0;
                double gwtSumTime = tm[3 * Type.GWT.ordinal()] + tm[3 * Type.RPC.ordinal()];
                double gwtCntTime = tm[3 * Type.GWT.ordinal() + 1] + tm[3 * Type.RPC.ordinal() + 1];
                double gwtAvgTime = gwtCntTime > 0.0 ? gwtSumTime / gwtCntTime : 0.0;
                double maxTime = Math.max(tm[3 * Type.STRUCTS.ordinal() + 2], tm[3 * Type.OTHER.ordinal() + 2]);
                double gwtMaxTime = Math.max(tm[3 * Type.GWT.ordinal() + 2], tm[3 * Type.RPC.ordinal() + 2]);
                data[0].add(maxTime);
                data[1].add(avgTime);
                data[2].add(gwtMaxTime);
                data[3].add(gwtAvgTime);
                max[0] = Math.max(max[0], Math.max(maxTime, gwtMaxTime));
                max[1] = Math.max(max[1], Math.max(avgTime, gwtAvgTime));
                dt = w.next(dt, now);
            }
            sLog.debug((Object)("[" + w.name() + "] Max Time: " + max[0] + " / " + String.valueOf(data[0])));
            sLog.debug((Object)("[" + w.name() + "] Avg Time: " + max[1] + " / " + String.valueOf(data[1])));
            sLog.debug((Object)("[" + w.name() + "] Gwt Max Time: " + max[0] + " / " + String.valueOf(data[2])));
            sLog.debug((Object)("[" + w.name() + "] Gwt Avg Time: " + max[1] + " / " + String.valueOf(data[3])));
        }
        DecimalFormat df = new DecimalFormat("0.0");
        double[] range = new double[]{0.1, 0.2, 0.5, 1.0, 2.0, 5.0, 10.0, 20.0, 25.0, 50.0, 100.0, 200.0, 250.0, 500.0, 1000.0, 2000.0, 2500.0, 5000.0, 10000.0, 20000.0, 50000.0, 100000.0, 1000000.0, 1.0E7};
        double[] step = new double[]{1.0, 1.0};
        for (int i = 0; i < max.length; ++i) {
            if (max[i] <= 1.0) {
                max[i] = 1.0;
                step[i] = 0.1;
                continue;
            }
            int x = 0;
            while (max[i] / range[x] > 16.0) {
                ++x;
            }
            step[i] = range[x];
        }
        switch (t) {
            case USERS: {
                return "http://chart.apis.google.com/chart?cht=lc&chd=e:" + QueryLog.encode(data[0], max[0]) + "," + QueryLog.encode(data[1], max[0]) + "," + QueryLog.encode(data[2], max[1]) + "," + QueryLog.encode(data[3], max[1]) + "&chs=400x300&chl=" + axe + "&chxt=x,y,y,r,r&chxr=1,0," + df.format(max[0]) + "," + df.format(step[0]) + "|3,0," + df.format(max[1]) + "," + df.format(step[1]) + "&chdl=Users+per+" + w.getBase() + "|HTTP+Sessions+per+" + w.getBase() + "|Pages+per+Minute|GWT+Calls+per+Minute&chco=0000FF,00FF00,FF0000,FFA500&chdlp=t&chds=0," + df.format(max[0]) + ",0," + df.format(max[0]) + ",0," + df.format(max[1]) + ",0," + df.format(max[1]) + "&chxl=4:||e|t|u|n|i|M|+|r|e|p|+|s|l|l|a|C||2:|s|n|o|i|s|s|e|s|+|s|r|e|s|u|+|f|o|+|r|b|N&chxs=1,0000FF|2,00FF00|3,FF0000|4,FFA500";
            }
            case TIME: {
                return "http://chart.apis.google.com/chart?cht=lc&chd=e:" + QueryLog.encode(data[0], max[0]) + "," + QueryLog.encode(data[2], max[0]) + "," + QueryLog.encode(data[1], max[1]) + "," + QueryLog.encode(data[3], max[1]) + "&chs=400x300&chl=" + axe + "&chxt=x,y,y,r,r&chxr=1,0," + df.format(max[0]) + "," + df.format(step[0]) + "|3,0," + df.format(max[1]) + "," + df.format(step[1]) + "&chdlp=t&chds=0," + df.format(max[0]) + ",0," + df.format(max[0]) + ",0," + df.format(max[1]) + ",0," + df.format(max[1]) + "&chdl=Max+Time+[s]|GWT+Max+Time+[s]|Average+Time+[ms]|GWT+Average+Time+[ms]&chco=0000FF,00FF00,FF0000,FFA500&chxl=4:||e|m|i|T|+|e|g|a|r|e|v|A||2:||e|m|i|T|+|x|a|M|&chxs=1,0000FF|2,00FF00|3,FF0000|4,FFA500";
            }
        }
        return "";
    }

    public static enum ChartWindow {
        LAST_HOUR("Last 3 Hours", "kkmm", (ReadablePeriod)Hours.THREE, 10, (ReadablePeriod)Minutes.ONE, "k:mm", DateTimeFieldType.minuteOfHour(), 20, 0, 10, "Minute", "to_char(timeStamp, 'HH24MI')", "timeStamp > adddate(current_date(), -1)", "date_format(timeStamp, '%H%i')", "timeStamp > adddate(current_date(), -1)"),
        LAST_WEEK("Last 7 Days", "ddkk", (ReadablePeriod)Days.SEVEN, 1, (ReadablePeriod)Hours.ONE, "MM/d", DateTimeFieldType.hourOfDay(), 24, 0, 60, "Hour", "to_char(timeStamp, 'DDHH24')", "timeStamp > adddate(current_date(), - 7)", "date_format(timeStamp, '%d%H')", "timeStamp > adddate(current_date(), -7)"),
        LAST_MONTH("Last 3 Months", "MMdd", (ReadablePeriod)Months.THREE, 1, (ReadablePeriod)Days.ONE, "MMM/d", DateTimeFieldType.dayOfMonth(), 32, 1, 1440, "Day", "to_char(timeStamp, 'MMDD')", "timeStamp > adddate(current_date(), - 92)", "date_format(timeStamp, '%m%d')", "timeStamp > adddate(current_date(), -92)");

        private String iName;
        private DateFormat iFormat;
        private ReadablePeriod iStart;
        private ReadablePeriod iIncrement;
        private int iWindow;
        private String iOracleFormat;
        private String iOracleCondition;
        private String iMySqlFormat;
        private String iMySqlCondition;
        private String iAxeFormat;
        private String iBase;
        private int iMinutes;
        private DateTimeFieldType iAxeType;
        int iAxeMod;
        int iAxeValue;

        private ChartWindow(String name, String format, ReadablePeriod start, int window, ReadablePeriod increment, String axeFormat, DateTimeFieldType axeType, int axeMod, int axeValue, int minutes, String base, String oracleFormat, String oracleCondition, String mySqlFormat, String mySqlCondition) {
            this.iName = name;
            this.iFormat = new SimpleDateFormat(format, Locale.US);
            this.iStart = start;
            this.iWindow = window;
            this.iIncrement = increment;
            this.iAxeFormat = axeFormat;
            this.iAxeType = axeType;
            this.iAxeMod = axeMod;
            this.iAxeValue = axeValue;
            this.iMinutes = minutes;
            this.iBase = base;
            this.iOracleFormat = oracleFormat;
            this.iOracleCondition = oracleCondition;
            this.iMySqlFormat = mySqlFormat;
            this.iMySqlCondition = mySqlCondition;
        }

        @Transient
        public String getName() {
            return this.iName;
        }

        @Transient
        public String getBase() {
            return this.iBase;
        }

        public String format(DateTime date) {
            return this.iFormat.format(date.getMillis());
        }

        public DateTime getFirst(DateTime now) {
            return now.minus(this.iStart);
        }

        public DateTime next(DateTime date, DateTime now) {
            DateTime ret = date.plus(this.iIncrement);
            return ret.isAfter((ReadableInstant)now) ? null : ret;
        }

        @Transient
        public int getMinutes() {
            return this.iMinutes;
        }

        public Map<String, int[]> getUsersAndSessions(Session hibSession) {
            String query = null;
            query = HibernateUtil.isMySQL() ? "select " + this.iMySqlFormat + ", count(distinct uid), count(distinct sessionId) from QueryLog where " + this.iMySqlCondition + " group by " + this.iMySqlFormat : "select " + this.iOracleFormat + ", count(distinct uid), count(distinct sessionId) from QueryLog where " + this.iOracleCondition + " group by " + this.iOracleFormat;
            HashMap<String, int[]> ret = new HashMap<String, int[]>();
            for (Object[] o : hibSession.createQuery(query, Object[].class).list()) {
                String dt = (String)o[0];
                int users = ((Number)o[1]).intValue();
                int sessions = ((Number)o[2]).intValue();
                ret.put(dt, new int[]{users, sessions});
            }
            return ret;
        }

        public Map<String, int[]> getQueriesPerType(Session hibSession) {
            String query = null;
            query = HibernateUtil.isMySQL() ? "select " + this.iMySqlFormat + ", type, count(uniqueId) from QueryLog where " + this.iMySqlCondition + " group by type, " + this.iMySqlFormat : "select " + this.iOracleFormat + ", type, count(uniqueId) from QueryLog where " + this.iOracleCondition + " group by type, " + this.iOracleFormat;
            HashMap<String, int[]> ret = new HashMap<String, int[]>();
            for (Object[] o : hibSession.createQuery(query, Object[].class).list()) {
                String dt = (String)o[0];
                int type = ((Number)o[1]).intValue();
                int queries = ((Number)o[2]).intValue();
                int[] counts = (int[])ret.get(dt);
                if (counts == null) {
                    counts = new int[Type.values().length];
                    for (int i = 0; i < counts.length; ++i) {
                        counts[i] = 0;
                    }
                    ret.put(dt, counts);
                }
                counts[type] = queries;
            }
            return ret;
        }

        public Map<String, double[]> getTimes(Session hibSession) {
            String query = null;
            query = HibernateUtil.isMySQL() ? "select " + this.iMySqlFormat + ", type, count(uniqueId), sum(timeSpent), max(timeSpent) from QueryLog where " + this.iMySqlCondition + " group by type, " + this.iMySqlFormat : "select " + this.iOracleFormat + ", type, count(uniqueId), sum(timeSpent), max(timeSpent) from QueryLog where " + this.iOracleCondition + " group by type, " + this.iOracleFormat;
            HashMap<String, double[]> ret = new HashMap<String, double[]>();
            for (Object[] o : hibSession.createQuery(query, Object[].class).list()) {
                String dt = (String)o[0];
                int type = ((Number)o[1]).intValue();
                int cnt = ((Number)o[2]).intValue();
                double sum = ((Number)o[3]).doubleValue();
                double max = ((Number)o[4]).doubleValue() / 1000.0;
                double[] counts = (double[])ret.get(dt);
                if (counts == null) {
                    counts = new double[3 * Type.values().length];
                    for (int i = 0; i < counts.length; ++i) {
                        counts[i] = 0.0;
                    }
                    ret.put(dt, counts);
                }
                counts[3 * type] = sum;
                counts[3 * type + 1] = cnt;
                counts[3 * type + 2] = max;
            }
            return ret;
        }

        public double[] countUsers(Map<String, int[]> table, DateTime date) {
            int i;
            DateTime d = date;
            int[] ret = new int[2];
            for (i = 0; i < ret.length; ++i) {
                ret[i] = 0;
            }
            for (i = 0; i < this.iWindow; ++i) {
                int[] count = table.get(this.format(d));
                if (count != null) {
                    for (int j = 0; j < count.length; ++j) {
                        int n = j;
                        ret[n] = ret[n] + count[j];
                    }
                }
                d = d.plus(this.iIncrement);
            }
            return new double[]{(double)ret[0] / (double)this.iWindow, (double)ret[1] / (double)this.iWindow};
        }

        public int[] countQueries(Map<String, int[]> table, DateTime date) {
            int i;
            DateTime d = date;
            int[] ret = new int[Type.values().length];
            for (i = 0; i < ret.length; ++i) {
                ret[i] = 0;
            }
            for (i = 0; i < this.iWindow; ++i) {
                int[] count = table.get(this.format(d));
                if (count != null) {
                    for (int j = 0; j < count.length; ++j) {
                        int n = j;
                        ret[n] = ret[n] + count[j];
                    }
                }
                d = d.plus(this.iIncrement);
            }
            return ret;
        }

        public double[] countTimes(Map<String, double[]> table, DateTime date) {
            int i;
            DateTime d = date;
            double[] ret = new double[3 * Type.values().length];
            for (i = 0; i < ret.length; ++i) {
                ret[i] = 0.0;
            }
            for (i = 0; i < this.iWindow; ++i) {
                double[] count = table.get(this.format(d));
                if (count != null) {
                    for (int j = 0; j < count.length; ++j) {
                        if (j % 3 == 2) {
                            ret[j] = Math.max(ret[j], count[j]);
                            continue;
                        }
                        int n = j;
                        ret[n] = ret[n] + count[j];
                    }
                }
                d = d.plus(this.iIncrement);
            }
            return ret;
        }

        public String axe(DateTime now) {
            SimpleDateFormat format = new SimpleDateFormat(this.iAxeFormat, Localization.getJavaLocale());
            DateTime dt = this.getFirst(now);
            int i = 0;
            StringBuffer ret = new StringBuffer();
            while (dt != null) {
                if (i > 0) {
                    ret.append("|");
                }
                if (dt.get(this.iAxeType) % this.iAxeMod == this.iAxeValue) {
                    ret.append(format.format(dt.getMillis()));
                }
                ++i;
                dt = this.next(dt, now);
            }
            return ret.toString();
        }
    }

    public static enum ChartType {
        USERS,
        TIME;

    }

    public static enum Type {
        STRUCTS,
        GWT,
        OTHER,
        RPC;

    }
}

