/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.Transient;
import java.util.List;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BaseDepartmentRoomFeature;
import org.unitime.timetable.model.dao.DepartmentRoomFeatureDAO;

@Entity
@DiscriminatorValue(value="department")
public class DepartmentRoomFeature
extends BaseDepartmentRoomFeature {
    private static final long serialVersionUID = 1L;

    public DepartmentRoomFeature() {
    }

    public DepartmentRoomFeature(Long uniqueId) {
        super(uniqueId);
    }

    public static String featureTypeDisplayString() {
        return "Department";
    }

    @Transient
    public String getDeptCode() {
        return this.getDepartment() == null ? null : this.getDepartment().getDeptCode();
    }

    public String htmlLabel() {
        return "<span style='color:#" + this.getDepartment().getRoomSharingColor(null) + ";font-weight:bold;' title='" + this.getLabel() + " (" + (this.getDepartment().isExternalManager() != false ? this.getDepartment().getExternalMgrLabel() : this.getDepartment().getName()) + (String)(this.getFeatureType() == null ? "" : " " + this.getFeatureType().getReference()) + ")'>" + this.getLabel() + (String)(this.getFeatureType() == null ? "" : " (" + this.getFeatureType().getReference() + ")") + "</span>";
    }

    @Override
    @Transient
    public String getLabelWithType() {
        return this.getLabel() + (String)(this.getFeatureType() == null ? " (Department)" : " (Department " + this.getFeatureType().getReference() + ")");
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    public static List<DepartmentRoomFeature> getAllRoomFeaturesForSession(Session session) {
        if (session == null) {
            return null;
        }
        return DepartmentRoomFeatureDAO.getInstance().getSession().createQuery("select distinct d from DepartmentRoomFeature d where d.department.session.uniqueId=:sessionId order by label", DepartmentRoomFeature.class).setParameter("sessionId", (Object)session.getUniqueId()).setCacheable(true).list();
    }

    public Object clone() {
        DepartmentRoomFeature newFeature = new DepartmentRoomFeature();
        newFeature.setLabel(this.getLabel());
        newFeature.setAbbv(this.getAbbv());
        newFeature.setDepartment(this.getDepartment());
        newFeature.setFeatureType(this.getFeatureType());
        return newFeature;
    }
}

